/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.entity.model.BizObjField;
import kd.ai.ids.core.entity.model.ResultConfig;
import kd.ai.ids.core.entity.model.ResultField;
import kd.ai.ids.core.entity.model.ResultType;
import kd.ai.ids.core.entity.model.sf.std.LineageGraphDTO;
import kd.ai.ids.core.entity.model.sf.std.SfOnlineScheme;
import kd.ai.ids.core.enumtype.AppTypeEnum;
import kd.ai.ids.core.enumtype.DataappSalesForecastEnum;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.IdsVersionEnum;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.mvc.bill.BillView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizAssociateSchemeFormPlugin
extends BaseFormPlugin {
    private static final String KEY_APPID_NAME_MAP = "appid_name_map";
    private static final String KEY_FMODELTYPEID_NAME_MAP = "fmodeltypeid_name_map";
    private static final String KEY_RESULTTYPEID_NAME_MAP = "resulttypeid_name_map";
    private static final String KEY_BTN_SAVESCHEME = "savescheme";
    private static final String KEY_ADVCONAP_QUEUE = "advconapqueue";
    private static final String KEY_FLEX_RECEIVENOTICE = "flexreceivenotice";
    private static final String KEY_PKID = "pkId";
    private static final String KEY_INSERT_FIELD_BTN = "insertfieldbtn";

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    private String getResultConfig() {
        return this.getCache().get("resultConfig");
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_INSERT_FIELD_BTN});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        super.click(evt);
        if (evtKey.equals(KEY_INSERT_FIELD_BTN)) {
            String filterField = (String)this.getModel().getValue("filterfield");
            String filterCondition = (String)this.getModel().getValue("filtercondition");
            filterCondition = StringUtils.isEmpty((CharSequence)filterCondition) ? filterField : String.format("%s %s", filterCondition, filterField);
            this.getModel().setValue("filtercondition", (Object)filterCondition);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"appid")) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            String appId = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.initFmodeltypeidComEdit(appId);
            JSONObject idNameJo = this.getCache().getAsObject(KEY_APPID_NAME_MAP);
            this.getModel().setValue("appname", (Object)idNameJo.getString(appId));
            this.initMappingFieldComboEdit(true);
            this.getView().hideLoading();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"modeltypeid")) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            String fmodeltypeid = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.initResultTypeComboEdit(fmodeltypeid);
            JSONObject idNameJo = this.getCache().getAsObject(KEY_FMODELTYPEID_NAME_MAP);
            this.getModel().setValue("modeltypename", (Object)idNameJo.getString(fmodeltypeid));
            this.initMappingFieldComboEdit(true);
            this.getView().hideLoading();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"resulttype")) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            String resultTypeId = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.getCache().put("resultTypeId", resultTypeId);
            JSONObject idNameJo = this.getCache().getAsObject(KEY_RESULTTYPEID_NAME_MAP);
            this.getModel().setValue("resulttypename", (Object)idNameJo.getString(resultTypeId));
            this.initMappingFieldComboEdit(true);
            this.initFilterFieldComboEdit();
            this.getView().hideLoading();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"bizobj")) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            this.initMappingFieldComboEdit(true);
            this.getView().hideLoading();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"bizobjfield")) {
            int rowIndex = changeData[0].getRowIndex();
            String oldValue = changeData[0].getOldValue() != null ? changeData[0].getOldValue().toString() : null;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_mapping_entry");
            EntryData entryData = entryGrid.getEntryData();
            DynamicObject[] dataEntitys = entryData.getDataEntitys();
            ArrayList<String> bizobjfieldList = new ArrayList<String>();
            if (dataEntitys != null && dataEntitys.length > 0) {
                long newCount;
                for (DynamicObject dynamicObject : dataEntitys) {
                    String bizobjfield = dynamicObject.getString("bizobjfield");
                    if (!StringUtils.isNotEmpty((CharSequence)bizobjfield)) continue;
                    bizobjfieldList.add(bizobjfield);
                }
                long oldCount = bizobjfieldList.size();
                if (oldCount > (newCount = bizobjfieldList.stream().distinct().count())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d", (String)"BizAssociateSchemeFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]));
                    this.getModel().setValue("bizobjfield", (Object)oldValue, rowIndex);
                    return;
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"receivenotice")) {
            boolean receiveNotice = Boolean.parseBoolean(changeData[0].getNewValue().toString());
            this.setReceiveNoticeVisible(receiveNotice);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Donothing donothing;
        String operateKey;
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing && StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_SAVESCHEME, (CharSequence)(operateKey = (donothing = (Donothing)source).getOperateKey()))) {
            DynamicObject dynamicObject;
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (pkValue != null && Long.parseLong(pkValue.toString()) > 0L && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"ids_biz_associate_scheme")).getInt("status") == EnableEnum.AVAIL.getKey()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7f16\u8f91\u5df2\u542f\u7528\u7684\u65b9\u6848", (String)"BizAssociateSchemeFormPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            boolean receiveNotice = (Boolean)this.getModel().getValue("receivenotice");
            String eventNumber = (String)this.getModel().getValue("eventnumber");
            if (receiveNotice && StringUtils.isEmpty((CharSequence)eventNumber)) {
                this.getView().showTipNotification("\u542f\u7528\u4e8b\u4ef6\u901a\u77e5\u65f6\uff0c\u4e8b\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_mapping_entry");
            EntryData entryData = entryGrid.getEntryData();
            DynamicObject[] dataEntitys = entryData.getDataEntitys();
            ArrayList<String> quotefieldList = new ArrayList<String>();
            if (dataEntitys != null && dataEntitys.length > 0) {
                for (DynamicObject dynamicObject2 : dataEntitys) {
                    String quotefield = dynamicObject2.getString("quotefield");
                    if (!StringUtils.isNotEmpty((CharSequence)quotefield)) continue;
                    quotefieldList.add(quotefield);
                }
            }
            if (quotefieldList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u5f15\u7528\u6570\u636e\u5b57\u6bb5", (String)"BizAssociateSchemeFormPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            String customparams = (String)this.getModel().getValue("customparams");
            if (StringUtils.isNotEmpty((CharSequence)customparams)) {
                Object obj = null;
                try {
                    obj = JSON.parse((String)customparams);
                }
                catch (Exception e) {
                    this.log.info(String.format("%s\u4e0d\u662fJSON\u5b57\u7b26\u4e32", customparams));
                }
                if (obj == null || !(obj instanceof JSONObject)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u5fc5\u987b\u4e3aJSON\u5b57\u7b26\u4e32", (String)"BizAssociateSchemeFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.getView().invokeOperation("save");
        }
    }

    private List<ResultField> getResultFieldListFromLineageTable(String fschemeid, String resultTypeId) {
        LineageGraphDTO lineageGraphDTO;
        JSONArray tblColumns;
        ArrayList<ResultField> resultFieldList = null;
        JSONObject lineageTableJo = this.dataModelService().getLineageTable(this.getSubServiceId(), fschemeid, resultTypeId);
        if (lineageTableJo != null && (tblColumns = (lineageGraphDTO = (LineageGraphDTO)lineageTableJo.toJavaObject(LineageGraphDTO.class)).getTblColumns()) != null && tblColumns.size() > 0) {
            resultFieldList = new ArrayList<ResultField>(tblColumns.size());
            for (Object colObj : tblColumns) {
                JSONObject colJo = (JSONObject)colObj;
                ResultField resultField = new ResultField();
                resultField.setId(colJo.getString("name"));
                resultField.setName(colJo.getString("description"));
                resultFieldList.add(resultField);
            }
        }
        return resultFieldList;
    }

    private void initMappingFieldComboEdit(boolean deleteEntryData) {
        Object fmodeltypeidObj = this.getModel().getValue("modeltypeid");
        Object resultTypeIdObj = this.getModel().getValue("resulttype");
        Object bizobj = this.getModel().getValue("bizobj");
        if (fmodeltypeidObj == null || resultTypeIdObj == null || bizobj == null) {
            return;
        }
        String fmodeltypeid = fmodeltypeidObj.toString();
        String resultTypeId = resultTypeIdObj.toString();
        String entityNumber = null;
        if (bizobj != null) {
            DynamicObject bizobjDynamicObject = (DynamicObject)bizobj;
            entityNumber = bizobjDynamicObject.getString("number");
        }
        List<ResultField> resultFieldList = null;
        resultFieldList = this.getTenantDTO().getIdsVersion().equalsIgnoreCase(IdsVersionEnum.BIC.getKey()) ? this.getResultFieldList(fmodeltypeid, resultTypeId) : this.getResultFieldListFromLineageTable(fmodeltypeid, resultTypeId);
        if (resultFieldList != null && !resultFieldList.isEmpty()) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_mapping_entry");
            List controls = entryGrid.getControls();
            List<BizObjField> bizObjFieldList = this.getBizObjAllFieldList(entityNumber);
            for (Control control : controls) {
                int i;
                if (!(control instanceof ComboEdit)) continue;
                ComboEdit comboEdit = (ComboEdit)control;
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
                if (comboEdit.getKey().equals("quotefield")) {
                    for (i = 0; i < resultFieldList.size(); ++i) {
                        ResultField resultField = resultFieldList.get(i);
                        String id = resultField.getId();
                        String quoteFieldName = resultField.getName();
                        LocaleString comboItemText = new LocaleString(quoteFieldName);
                        ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(id));
                        comboItemList.add(comboItem);
                    }
                } else if (comboEdit.getKey().equals("bizobjfield")) {
                    for (i = 0; i < bizObjFieldList.size(); ++i) {
                        BizObjField bizObjField = bizObjFieldList.get(i);
                        int fieldType = bizObjField.getFieldType();
                        String fieldName = bizObjField.getFieldName();
                        String fieldCaption = bizObjField.getFieldCaption();
                        if (!AppConstants.INT_LIST.contains(fieldType) && !AppConstants.LONG_LIST.contains(fieldType) && !AppConstants.FLOAT_LIST.contains(fieldType) && !AppConstants.CHAR_LIST.contains(fieldType) && !AppConstants.DATE_LIST.contains(fieldType) && !AppConstants.DATETIME_LIST.contains(fieldType)) continue;
                        LocaleString comboItemText = new LocaleString(fieldCaption);
                        ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(fieldName));
                        comboItemList.add(comboItem);
                        comboEdit.setEnable("s", false, i);
                    }
                }
                comboEdit.setComboItems(comboItemList);
            }
            if (deleteEntryData) {
                this.getModel().deleteEntryData("field_mapping_entry");
                int rowCount = bizObjFieldList.size();
                int[] rowIndex = this.getModel().batchCreateNewEntryRow("field_mapping_entry", rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    BizObjField bizObjField = bizObjFieldList.get(i);
                    this.getModel().setValue("bizobjfield", (Object)bizObjField.getFieldName(), rowIndex[i]);
                }
            }
        }
    }

    private void initFilterFieldComboEdit() {
        String fmodeltypeid = (String)this.getModel().getValue("modeltypeid");
        String resultTypeId = (String)this.getModel().getValue("resulttype");
        List<ResultField> resultFieldList = null;
        resultFieldList = this.getTenantDTO().getIdsVersion().equalsIgnoreCase(IdsVersionEnum.BIC.getKey()) ? this.getResultFieldList(fmodeltypeid, resultTypeId) : this.getResultFieldListFromLineageTable(fmodeltypeid, resultTypeId);
        if (resultFieldList != null && resultFieldList.size() > 0) {
            ComboEdit filterFieldComboEdit = (ComboEdit)this.getControl("filterfield");
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(resultFieldList.size());
            for (ResultField resultField : resultFieldList) {
                String id = resultField.getId();
                String fieldName = resultField.getName();
                LocaleString comboItemText = new LocaleString(fieldName);
                ComboItem comboItem = new ComboItem(comboItemText, id);
                comboItemList.add(comboItem);
            }
            filterFieldComboEdit.setComboItems(comboItemList);
        }
    }

    private void initResultTypeComboEdit(String fmodeltypeid) {
        if (this.getTenantDTO().getIdsVersion().equalsIgnoreCase(IdsVersionEnum.BIC.getKey())) {
            HashMap<String, String> idNameMap = new HashMap<String, String>(3);
            Map<String, List<ResultType>> fmodeltypeidResultTypeListMap = this.getFmodeltypeidResultTypeListMap();
            List<ResultType> resultTypeList = fmodeltypeidResultTypeListMap.get(fmodeltypeid);
            ComboEdit resultTypeComboEdit = (ComboEdit)this.getControl("resulttype");
            if (resultTypeList != null && !resultTypeList.isEmpty()) {
                ArrayList<ComboItem> resultTypeComboItemList = new ArrayList<ComboItem>(resultTypeList.size());
                for (ResultType resultType : resultTypeList) {
                    String id = resultType.getId();
                    String resultTypeName = resultType.getName();
                    LocaleString comboItemText = new LocaleString(resultTypeName);
                    ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(id));
                    resultTypeComboItemList.add(comboItem);
                    idNameMap.put(id, resultTypeName);
                }
                resultTypeComboEdit.setComboItems(resultTypeComboItemList);
                this.getCache().put(KEY_RESULTTYPEID_NAME_MAP, JSON.toJSONString(idNameMap));
            }
        } else {
            String subServiceId = this.getSubServiceId();
            ArrayList<ResultType> resultTypeList = new ArrayList<ResultType>();
            JSONArray lineageGraphJa = this.dataModelService().getLineageGraph(subServiceId);
            if (lineageGraphJa != null && lineageGraphJa.size() > 0) {
                List lineageGraphDTOList = lineageGraphJa.toJavaList(LineageGraphDTO.class);
                lineageGraphDTOList = lineageGraphDTOList.stream().filter(e -> e.getTags() != null && e.getTags().toJavaList(String.class).contains("exportS3")).collect(Collectors.toList());
                for (LineageGraphDTO lineageGraphDTO : lineageGraphDTOList) {
                    JSONArray tagsConfigJa = lineageGraphDTO.getTagsConfig();
                    if (tagsConfigJa == null || tagsConfigJa.size() <= 0) continue;
                    for (Object tagsConfigObj : tagsConfigJa) {
                        JSONObject tagsConfigJo = (JSONObject)tagsConfigObj;
                        JSONObject tagsConfigValueJo = tagsConfigJo.getJSONObject("value");
                        String fmodeltypeidValue = tagsConfigValueJo.getString("fmodeltypeid");
                        if (!StringUtils.equalsIgnoreCase((CharSequence)fmodeltypeidValue, (CharSequence)fmodeltypeid)) continue;
                        JSONObject resultTypeJo = tagsConfigValueJo.getJSONObject("resultType");
                        ResultType resultType = new ResultType();
                        resultType.setId(resultTypeJo.getString("id"));
                        resultType.setName(resultTypeJo.getString("name"));
                        resultTypeList.add(resultType);
                    }
                }
            }
            HashMap<String, String> idNameMap = new HashMap<String, String>(3);
            ComboEdit resultTypeComboEdit = (ComboEdit)this.getControl("resulttype");
            if (resultTypeList != null && !resultTypeList.isEmpty()) {
                ArrayList<ComboItem> resultTypeComboItemList = new ArrayList<ComboItem>(resultTypeList.size());
                for (ResultType resultType : resultTypeList) {
                    String id = resultType.getId();
                    String resultTypeName = resultType.getName();
                    LocaleString comboItemText = new LocaleString(resultTypeName);
                    ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(id));
                    resultTypeComboItemList.add(comboItem);
                    idNameMap.put(id, resultTypeName);
                }
                resultTypeComboEdit.setComboItems(resultTypeComboItemList);
                this.getCache().put(KEY_RESULTTYPEID_NAME_MAP, JSON.toJSONString(idNameMap));
            }
        }
    }

    private void initFmodeltypeidComEdit(String appId) {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.getTenantDTO();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), appId);
        if (tenantDTO.getIdsVersion().equalsIgnoreCase(IdsVersionEnum.BIC.getKey())) {
            HashMap<String, String> idNameMap = new HashMap<String, String>();
            this.getCache().put("subServiceId", subServiceId);
            this.loadResultConfig();
            List<ResultConfig> resultConfigList = this.getResultConfigList();
            if (resultConfigList != null && !resultConfigList.isEmpty()) {
                ComboEdit comboEdit = (ComboEdit)this.getControl("modeltypeid");
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(resultConfigList.size());
                for (ResultConfig resultConfig : resultConfigList) {
                    String id = resultConfig.getId();
                    String name = resultConfig.getName();
                    LocaleString comboItemText = new LocaleString(name);
                    ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(id));
                    comboItemList.add(comboItem);
                    idNameMap.put(id, name);
                }
                comboEdit.setComboItems(comboItemList);
            }
            this.getCache().put(KEY_FMODELTYPEID_NAME_MAP, JSON.toJSONString(idNameMap));
        } else {
            HashMap<String, String> idNameMap = new HashMap<String, String>();
            this.getCache().put("subServiceId", subServiceId);
            JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(subServiceId);
            List sfOnlineSchemeList = dataJa.toJavaList(SfOnlineScheme.class);
            if (sfOnlineSchemeList != null && !sfOnlineSchemeList.isEmpty()) {
                ComboEdit comboEdit = (ComboEdit)this.getControl("modeltypeid");
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(sfOnlineSchemeList.size());
                for (SfOnlineScheme sfOnlineScheme : sfOnlineSchemeList) {
                    String id = String.valueOf(sfOnlineScheme.getFschemeid());
                    String name = sfOnlineScheme.getFname();
                    LocaleString comboItemText = new LocaleString(name);
                    ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(id));
                    comboItemList.add(comboItem);
                    idNameMap.put(id, name);
                }
                comboEdit.setComboItems(comboItemList);
            }
            this.getCache().put(KEY_FMODELTYPEID_NAME_MAP, JSON.toJSONString(idNameMap));
        }
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        Object pkId = billShowParameter.getPkId();
        if (pkId != null) {
            String entityId = billShowParameter.getFormId();
            DynamicObject schemeDo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityId);
            String bizobj = schemeDo.getDynamicObject("bizobj").getString("number");
            this.checkIfNewField(bizobj, schemeDo);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        RequestContext rc = RequestContext.get();
        BillView billView = (BillView)e.getSource();
        BillShowParameter billShowParameter = (BillShowParameter)billView.getFormShowParameter();
        Object pkId = billShowParameter.getPkId();
        String entityId = billShowParameter.getFormId();
        boolean receiveNotice = true;
        this.setQueueConfigVisible(rc);
        this.loadDataappList();
        if (pkId != null) {
            this.getCache().put(KEY_PKID, pkId.toString());
            DynamicObject schemeDo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityId);
            String appId = schemeDo.getString("appid");
            String fmodeltypeid = schemeDo.getString("modeltypeid");
            receiveNotice = schemeDo.getBoolean("receivenotice");
            this.initFmodeltypeidComEdit(appId);
            this.initResultTypeComboEdit(fmodeltypeid);
            this.initMappingFieldComboEdit(false);
            this.initFilterFieldComboEdit();
        }
        this.setReceiveNoticeVisible(receiveNotice);
    }

    private void checkIfNewField(String bizobj, DynamicObject schemeDo) {
        List<BizObjField> bizObjFieldList = this.getBizObjAllFieldList(bizobj);
        DynamicObjectCollection fieldMappingEntryDoc = schemeDo.getDynamicObjectCollection("field_mapping_entry");
        ArrayList<String> oldFieldList = new ArrayList<String>();
        for (DynamicObject fieldMappingEntryDo : fieldMappingEntryDoc) {
            oldFieldList.add(fieldMappingEntryDo.getString("bizobjfield"));
        }
        boolean ifNewField = false;
        if (bizObjFieldList != null && bizObjFieldList.size() > 0) {
            int oldSeq = oldFieldList.size();
            for (BizObjField bizObjField : bizObjFieldList) {
                String fieldName = bizObjField.getFieldName();
                if (oldFieldList.contains(fieldName)) continue;
                DynamicObject fieldMappingDo = fieldMappingEntryDoc.addNew();
                fieldMappingDo.set("seq", (Object)(++oldSeq));
                fieldMappingDo.set("bizobjfield", (Object)fieldName);
                ifNewField = true;
            }
        }
        if (ifNewField) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeDo});
        }
    }

    private List<BizObjField> getBizObjAllFieldList(String bizobj) {
        ArrayList<BizObjField> bizObjFieldList = new ArrayList<BizObjField>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizobj);
        if (mainEntityType != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getAlias())) {
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entry : allEntities.entrySet()) {
                Map fieldMap;
                EntityType entityType = (EntityType)entry.getValue();
                String entityName = entityType.getName();
                ISimpleProperty primaryKey = entityType.getPrimaryKey();
                if (primaryKey != null) {
                    BizObjField bizObjPkField = new BizObjField();
                    bizObjPkField.setEntryEntity(entityName);
                    bizObjPkField.setFieldType(Integer.valueOf(primaryKey.getDbType()));
                    String pkFieldName = primaryKey.getName();
                    String pkFieldCaption = "ID";
                    if (!(entityType instanceof BillEntityType)) {
                        pkFieldName = String.format("%s.%s", entityName, pkFieldName);
                        pkFieldCaption = String.format("%s.%s", entityType.getDisplayName().getLocaleValue(), pkFieldCaption);
                    }
                    bizObjPkField.setFieldName(pkFieldName);
                    bizObjPkField.setFieldCaption(pkFieldCaption);
                    bizObjFieldList.add(bizObjPkField);
                }
                if ((fieldMap = entityType.getFields()) == null || fieldMap.isEmpty()) continue;
                Iterator iterator = fieldMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    String fieldName = (String)iterator.next().getKey();
                    IDataEntityProperty dp = (IDataEntityProperty)fieldMap.get(fieldName);
                    if (StringUtils.isEmpty((CharSequence)dp.getAlias())) continue;
                    String fieldCaption = dp.getDisplayName().getLocaleValue();
                    if (!(entityType instanceof BillEntityType)) {
                        fieldName = String.format("%s.%s", entityName, fieldName);
                        fieldCaption = String.format("%s.%s", entityType.getDisplayName().getLocaleValue(), fieldCaption);
                    }
                    BizObjField bizObjField = new BizObjField();
                    bizObjField.setFieldName(fieldName);
                    bizObjField.setFieldCaption(fieldCaption);
                    bizObjField.setEntryEntity(entityName);
                    if (dp instanceof FieldProp) {
                        FieldProp fieldProp = (FieldProp)dp;
                        bizObjField.setFieldType(Integer.valueOf(fieldProp.getDbType()));
                    } else {
                        if (!(dp instanceof BasedataProp)) continue;
                        BasedataProp basedataProp = (BasedataProp)dp;
                        bizObjField.setFieldType(Integer.valueOf(basedataProp.getDbType()));
                    }
                    bizObjFieldList.add(bizObjField);
                }
            }
        }
        return bizObjFieldList;
    }

    private void setQueueConfigVisible(RequestContext rc) {
        IdsParameter idsParameter = ((IIdsParameterService)Services.get(IIdsParameterService.class)).getIdsParameter(Long.valueOf(rc.getOrgId()));
        if (idsParameter.getMqConfig().booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ADVCONAP_QUEUE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ADVCONAP_QUEUE});
        }
    }

    private void setReceiveNoticeVisible(boolean receiveNotice) {
        this.getView().setVisible(Boolean.valueOf(receiveNotice), new String[]{KEY_FLEX_RECEIVENOTICE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("number", (Object)("SCHEME-" + new Date().getTime()));
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
    }

    private void loadResultConfig() {
        RequestContext rc = RequestContext.get();
        JSONArray dataJa = this.modelResultService().getResultConfig(Long.valueOf(rc.getOrgId()), this.getSubServiceId());
        if (dataJa != null && !dataJa.isEmpty()) {
            this.getCache().put("resultConfig", JSON.toJSONString((Object)dataJa));
        }
    }

    private List<ResultConfig> getResultConfigList() {
        List<Object> resultConfigList = new ArrayList<ResultConfig>();
        String resultConfig = this.getResultConfig();
        if (StringUtils.isNotEmpty((CharSequence)resultConfig)) {
            resultConfigList = JSON.parseArray((String)resultConfig, ResultConfig.class);
        }
        return resultConfigList;
    }

    private Map<String, List<ResultType>> getFmodeltypeidResultTypeListMap() {
        HashMap<String, List<ResultType>> fmodeltypeidResultTypeListMap = new HashMap<String, List<ResultType>>();
        List<ResultConfig> resultConfigList = this.getResultConfigList();
        if (resultConfigList != null && !resultConfigList.isEmpty()) {
            for (ResultConfig resultConfig : resultConfigList) {
                fmodeltypeidResultTypeListMap.put(resultConfig.getId(), resultConfig.getResultTypeList());
            }
        }
        return fmodeltypeidResultTypeListMap;
    }

    private List<ResultField> getResultFieldList(String fmodeltypeid, String resultTypeId) {
        List<ResultType> resultTypeList;
        List<Object> resultFieldList = new ArrayList<ResultField>();
        Map<String, List<ResultType>> fmodeltypeidResultTypeListMap = this.getFmodeltypeidResultTypeListMap();
        if (fmodeltypeidResultTypeListMap != null && (resultTypeList = fmodeltypeidResultTypeListMap.get(fmodeltypeid)) != null && !resultTypeList.isEmpty()) {
            for (ResultType resultType : resultTypeList) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)resultTypeId, (CharSequence)resultType.getId())) continue;
                resultFieldList = resultType.getFields();
            }
        }
        return resultFieldList;
    }

    private void loadDataappList() {
        HashMap<String, String> idNameMap = new HashMap<String, String>();
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.getTenantDTO();
        JSONObject dataJo = null;
        if (tenantDTO != null) {
            dataJo = this.dataAppService().getSubAppList(Long.valueOf(rc.getOrgId()), rc.getTenantId(), tenantDTO.getTenantId());
        }
        ArrayList<JSONObject> appJoList = new ArrayList<JSONObject>();
        for (AppTypeEnum appType : AppTypeEnum.values()) {
            JSONArray subAppArray;
            JSONArray jSONArray = subAppArray = dataJo == null ? null : dataJo.getJSONArray(appType.getKey());
            if (subAppArray == null || subAppArray.isEmpty()) continue;
            for (int index = 0; index < subAppArray.size(); ++index) {
                JSONObject appJo = subAppArray.getJSONObject(index);
                appJoList.add(appJo);
            }
        }
        if (appJoList != null && !appJoList.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("appid");
            ArrayList<ComboItem> dataappComboItemList = new ArrayList<ComboItem>(appJoList.size());
            Set allSfAppIdSet = DataappSalesForecastEnum.getAllAppIdSet();
            for (JSONObject jo : appJoList) {
                String appId = jo.getString("appId");
                String appName = jo.getString("appName");
                idNameMap.put(appId, appName);
                LocaleString comboItemText = new LocaleString(appName);
                ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(appId));
                if (!allSfAppIdSet.contains(appId)) {
                    comboItem.setItemVisible(false);
                }
                dataappComboItemList.add(comboItem);
            }
            comboEdit.setComboItems(dataappComboItemList);
        }
        this.getCache().put(KEY_APPID_NAME_MAP, JSON.toJSONString(idNameMap));
    }
}

