/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import java.util.EventObject;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.ITaskExecuteService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BizAssociateSchemeListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(BizAssociateSchemeListPlugin.class);
    private static final String KEY_BTN_ENABLE = "enable";
    private static final String KEY_BTN_DISABLE = "disable";
    private static final String KEY_BTN_EXECUTE = "execute";
    private static final String KEY_BTN_REFRESH = "refresh";
    private static final String KEY_TOOLBARAP = "toolbarap";
    private final ITaskExecuteService taskExecuteService = (ITaskExecuteService)Services.get(ITaskExecuteService.class);
    private final ITenantService tenantService = (ITenantService)Services.get(ITenantService.class);
    private final IDataappService dataappService = (IDataappService)Services.get(IDataappService.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
    }

    public void createNewData(BizDataEventArgs e) {
        RequestContext rc = RequestContext.get();
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        RequestContext rc = RequestContext.get();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            ListSelectedRowCollection listSelectedData = donothing.getListSelectedData();
            if (listSelectedData == null || listSelectedData.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            Object[] pkArray = listSelectedData.getPrimaryKeyValues();
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ids_biz_associate_scheme");
            DynamicObject[] selectedDynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)newDynamicObject.getDynamicObjectType());
            if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_ENABLE, (CharSequence)operateKey)) {
                for (DynamicObject dynamicObject : selectedDynamicObjectArray) {
                    dynamicObject.set("status", (Object)EnableEnum.AVAIL.getKey());
                }
                SaveServiceHelper.save((DynamicObject[])selectedDynamicObjectArray);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"Common_Operation_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_DISABLE, (CharSequence)operateKey)) {
                for (DynamicObject dynamicObject : selectedDynamicObjectArray) {
                    dynamicObject.set("status", (Object)EnableEnum.INVALID.getKey());
                }
                SaveServiceHelper.save((DynamicObject[])selectedDynamicObjectArray);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"Common_Operation_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_EXECUTE, (CharSequence)operateKey)) {
                TenantDTO tenantDTO = this.tenantService.getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
                String salesForecastAppId = this.dataappService.getSalesForecastAppIdByPlatformCode();
                String subServiceId = this.dataappService.getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
                this.taskExecuteService.executeBizAssociateSchemeTask(selectedDynamicObjectArray, Long.valueOf(rc.getOrgId()), subServiceId, Long.valueOf(rc.getCurrUserId()), null);
            }
            this.getView().invokeOperation(KEY_BTN_REFRESH);
        }
    }
}

