/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.ids.core.enumtype.AppStatusEnum;
import kd.ai.ids.core.enumtype.AppTypeEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;

public class DataAnalysisFormPlugin
extends BaseFormPlugin {
    private static final String KEY_APPID_SUBSERVICEID_MAP = "appid_subserviceid_map";
    private static final String KEY_ALBELAP_SELECT_REPORT = "labelapselectreport";
    private static final String KEY_DATA_ANALYSIS_REPORT_SELECT = "dataanalysisreportselect";
    private static final String KEY_DATAAPP_SELECT = "dataappselect";
    private static final String KEY_DATA_ANALYSIS_REPORT_DETAIL_CUSTOMCONTROLAP = "customcontrolap";
    private static final String KEY_FLEXAP_REPORT = "flexpanelapreport";
    private static final String KEY_FLEXAP_NO_REPORT = "flexapnoreport";
    private static final String KEY_LABELAP_NO_RESULT = "labelapnoresult";
    private static final String KEY_LABELAP_TIP_WAIT = "labelaptipwait";
    private static final String KEY_LABELAP_TIP_CONTACT = "labelaptipcontact";
    private static final String EVENT_NAME_HIDE_LOADING = "hideLoading";

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        RequestContext rc = RequestContext.get();
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_DATA_ANALYSIS_REPORT_SELECT)) {
            String reportId = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.loadReportDetail(rc, Long.parseLong(reportId));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_DATAAPP_SELECT)) {
            String appId = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            JSONObject appIdSubServiceIdMap = this.getCache().getAsObject(KEY_APPID_SUBSERVICEID_MAP);
            String subServiceId = appIdSubServiceIdMap.getString(appId);
            this.getCache().put("subServiceId", subServiceId);
            this.loadOnlineDataAnalysisReportList();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        this.loadDataappList(tenantDTO);
        this.loadOnlineDataAnalysisReportList();
    }

    private void loadOnlineDataAnalysisReportList() {
        RequestContext rc = RequestContext.get();
        JSONArray dataJa = this.dataAnalysisService().getReportList(Long.valueOf(rc.getOrgId()), this.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            this.showNoReportPanel();
            return;
        }
        this.showReportPanel();
        long defaultReportId = 0L;
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_DATA_ANALYSIS_REPORT_SELECT);
        int len = dataJa.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            JSONObject jo = dataJa.getJSONObject(i);
            long reportId = jo.getLongValue("id");
            if (defaultReportId == 0L) {
                defaultReportId = reportId;
            }
            LocaleString comboItemText = new LocaleString(jo.getString("title"));
            ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(reportId));
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
        if (defaultReportId > 0L) {
            this.loadReportDetail(rc, defaultReportId);
        }
    }

    private void loadDataappList(TenantDTO tenantDTO) {
        HashMap<String, String> appIdSubServiceIdMap = new HashMap<String, String>();
        RequestContext rc = RequestContext.get();
        JSONObject dataJo = null;
        if (tenantDTO != null) {
            dataJo = this.dataAppService().getSubAppList(Long.valueOf(rc.getOrgId()), rc.getTenantId(), tenantDTO.getTenantId());
        }
        ArrayList<JSONObject> appJoList = new ArrayList<JSONObject>();
        for (AppTypeEnum appType : AppTypeEnum.values()) {
            JSONArray subAppArray;
            JSONArray jSONArray = subAppArray = dataJo == null ? null : dataJo.getJSONArray(appType.getKey());
            if (subAppArray == null || subAppArray.isEmpty()) continue;
            for (int index = 0; index < subAppArray.size(); ++index) {
                JSONObject appJo = subAppArray.getJSONObject(index);
                if (appJo.getIntValue("status") == AppStatusEnum.INIT.getKey()) continue;
                appJoList.add(appJo);
            }
        }
        if (appJoList != null && !appJoList.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_DATAAPP_SELECT);
            ArrayList<ComboItem> dataappComboItemList = new ArrayList<ComboItem>(appJoList.size());
            for (JSONObject jo : appJoList) {
                String appId = jo.getString("appId");
                String appName = jo.getString("appName");
                String subServiceId = jo.getString("subServiceId");
                appIdSubServiceIdMap.put(appId, subServiceId);
                LocaleString comboItemText = new LocaleString(appName);
                ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(appId));
                dataappComboItemList.add(comboItem);
                if (!StringUtils.isEmpty((CharSequence)this.getSubServiceId())) continue;
                this.getCache().put("subServiceId", subServiceId);
                this.getModel().setValue(KEY_DATAAPP_SELECT, (Object)appId);
            }
            comboEdit.setComboItems(dataappComboItemList);
        }
        this.getCache().put(KEY_APPID_SUBSERVICEID_MAP, JSON.toJSONString(appIdSubServiceIdMap));
    }

    private void loadReportDetail(RequestContext rc, long reportId) {
        this.getView().showLoading(null, 2000);
        this.getModel().setValue(KEY_DATA_ANALYSIS_REPORT_SELECT, (Object)reportId);
        String cacheKey = "report_" + reportId;
        String data = this.getPageCache().getBigObject(cacheKey);
        if (StringUtils.isEmpty((CharSequence)data)) {
            JSONObject dataJo = this.dataAnalysisService().getReportDetail(Long.valueOf(rc.getOrgId()), this.getSubServiceId(), Long.valueOf(reportId));
            if (dataJo == null || dataJo.isEmpty()) {
                return;
            }
            data = dataJo.getString("content");
            if (StringUtils.isNotEmpty((CharSequence)data)) {
                this.getPageCache().putBigObject(cacheKey, data);
            }
        }
        if (StringUtils.isEmpty((CharSequence)data)) {
            return;
        }
        CustomControl customControl = (CustomControl)this.getControl(KEY_DATA_ANALYSIS_REPORT_DETAIL_CUSTOMCONTROLAP);
        customControl.setData((Object)data);
    }

    private void showNoReportPanel() {
        Label noResultLabel = (Label)this.getControl(KEY_LABELAP_NO_RESULT);
        String noResultText = ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u679c", (String)"DataAnalysisFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]);
        noResultLabel.setText(noResultText);
        Label tipWaitLabel = (Label)this.getControl(KEY_LABELAP_TIP_WAIT);
        String tipWaitText = ResManager.loadKDString((String)"\u5e94\u7528\u4e0a\u7ebf\u540e\u4f1a\u81ea\u52a8\u751f\u6210\u6570\u636e\u5206\u6790\u62a5\u544a\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85", (String)"DataAnalysisFormPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]);
        tipWaitLabel.setText(tipWaitText);
        Label tipContactLabel = (Label)this.getControl(KEY_LABELAP_TIP_CONTACT);
        String tipContactText = ResManager.loadKDString((String)"\u5982\u6709\u7591\u95ee\u60a8\u53ef\u7535\u8bdd\u8054\u7cfb\u6211\u4eec\uff0c0755-84371244", (String)"DataAnalysisFormPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]);
        tipContactLabel.setText(tipContactText);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEXAP_REPORT});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEXAP_NO_REPORT});
    }

    private void showReportPanel() {
        Label selectReportLabel = (Label)this.getControl(KEY_ALBELAP_SELECT_REPORT);
        String selectReportText = ResManager.loadKDString((String)"\u5206\u6790\u62a5\u544a", (String)"DataAnalysisFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]);
        selectReportLabel.setText(selectReportText);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEXAP_NO_REPORT});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEXAP_REPORT});
    }

    public void customEvent(CustomEventArgs e) {
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        if (KEY_DATA_ANALYSIS_REPORT_DETAIL_CUSTOMCONTROLAP.equals(controlKey) && EVENT_NAME_HIDE_LOADING.equals(eventName)) {
            this.getView().hideLoading();
        }
    }
}

