/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.query.data.DataMarkFilterItemQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.service.IDataMarkService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.plugin.form.DataMarkDetailContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;

public class DataMarkDetailDataProvider
extends ListDataProvider {
    private static final Log log = LogFactory.getLog(DataMarkDetailDataProvider.class);
    private IDataMarkService dataMarkService = (IDataMarkService)Services.get(IDataMarkService.class);
    private DataMarkDetailContext ctx;

    public DataMarkDetailDataProvider setCtx(DataMarkDetailContext ctx) {
        this.ctx = ctx;
        return this;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        long current = start == 0 ? 1L : (long)(start / limit + 1);
        List<String> predictDetailFieldList = this.ctx.getPredictDetailFieldList();
        String orderByExpr = this.getOrderByExpr();
        orderByExpr = StringUtils.replace((String)orderByExpr, (String)",id desc", (String)"");
        orderByExpr = StringUtils.replace((String)orderByExpr, (String)"id desc", (String)"");
        String orderField = "";
        if (StringUtils.isNotEmpty((CharSequence)orderByExpr)) {
            orderField = orderByExpr.split(" ")[0];
            if (predictDetailFieldList != null && !predictDetailFieldList.contains(orderField)) {
                orderByExpr = null;
            }
        }
        List qFilterList = this.getQFilters();
        StringBuffer filters = new StringBuffer();
        if (qFilterList != null) {
            String qFilters = qFilterList.toString();
            String[] filterArr = (qFilters = qFilters.substring(1, qFilters.length() - 1)).split(" AND ");
            if (filterArr != null && filterArr.length > 0) {
                for (String filter : filterArr) {
                    String filterField = filter.split(" ")[0];
                    if (predictDetailFieldList == null || !predictDetailFieldList.contains(filterField)) continue;
                    filters = StringUtils.isEmpty((CharSequence)filters.toString()) ? filters.append(filter) : filters.append(" AND ").append(filter);
                }
            }
        }
        RequestContext rc = RequestContext.get();
        DataMarkFilterItemQuery currentFilterItemQuery = this.ctx.getCurFilterItemQuery();
        currentFilterItemQuery.setCurrent(Long.valueOf(current));
        currentFilterItemQuery.setSize(Long.valueOf(limit));
        currentFilterItemQuery.setOrderByExpr(orderByExpr);
        currentFilterItemQuery.setFilters(filters.toString());
        currentFilterItemQuery.setNeedRecord(Boolean.valueOf(true));
        this.ctx.setCurFilterItemQuery(currentFilterItemQuery);
        BaseResult baseResult = this.dataMarkService.getDataMarkDetailList(Long.valueOf(rc.getOrgId()), currentFilterItemQuery);
        DynamicObjectType dynamicObjectType = new DynamicObjectType("ids_data_mark_details");
        DynamicObjectCollection data = new DynamicObjectCollection(dynamicObjectType, null);
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            this.ctx.setCurLastDetailBaseResult(baseResult);
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            String[] properties = new String[]{};
            String[] lowerProperties = new String[]{};
            String[] propertyTypes = new String[]{};
            JSONArray fieldsJa = dataJo.getJSONArray("fields");
            JSONObject resultJo = dataJo.getJSONObject("result");
            JSONArray recordsJa = resultJo.getJSONArray("records");
            ArrayList<String> fpredimentypeCodeList = new ArrayList<String>();
            if (recordsJa != null && !recordsJa.isEmpty()) {
                for (int i = 0; i < recordsJa.size(); ++i) {
                    JSONObject recordJo = recordsJa.getJSONObject(i);
                    fpredimentypeCodeList.add(recordJo.getString("fpredimentypeCode"));
                }
            }
            Map codeMarkCountMap = this.dataMarkService.getCodeMarkCountMap(Long.valueOf(rc.getOrgId()), currentFilterItemQuery.getSubServiceId(), fpredimentypeCodeList);
            if (fieldsJa != null && !fieldsJa.isEmpty()) {
                properties = new String[fieldsJa.size()];
                lowerProperties = new String[fieldsJa.size()];
                propertyTypes = new String[fieldsJa.size()];
                for (int i = 0; i < fieldsJa.size(); ++i) {
                    String fieldId;
                    JSONObject fieldJo = fieldsJa.getJSONObject(i);
                    properties[i] = fieldId = fieldJo.getString("id");
                    lowerProperties[i] = fieldId != null ? fieldId.toLowerCase() : null;
                    propertyTypes[i] = fieldJo.getString("fieldType");
                }
            }
            for (int p = 0; p < properties.length; ++p) {
                String prop = lowerProperties[p];
                DynamicSimpleProperty dsp = null;
                try {
                    dsp = new DynamicSimpleProperty(prop, Class.forName(propertyTypes[p]), null);
                }
                catch (ClassNotFoundException e) {
                    CommonUtil.getStackTrace((Exception)e);
                }
                dynamicObjectType.addProperty(dsp);
            }
            long total = resultJo.getLongValue("total");
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
            if (recordsJa != null && !recordsJa.isEmpty()) {
                for (int i = 0; i < recordsJa.size(); ++i) {
                    JSONObject recordJo = recordsJa.getJSONObject(i);
                    dataList.add(recordJo);
                    DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                    for (int p = 0; p < properties.length; ++p) {
                        String lowerProperty;
                        String property = properties[p];
                        if (property == null) continue;
                        Object val = recordJo.get((Object)property);
                        String decimalType = BigDecimal.class.toString();
                        if (propertyTypes[p].equals(decimalType.split(" ")[1])) {
                            Object object = val = val == null ? Integer.valueOf(0) : val.toString().replace(",", "");
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)(lowerProperty = lowerProperties[p]), (CharSequence)"isMark") && codeMarkCountMap != null) {
                            val = codeMarkCountMap.getOrDefault(recordJo.getString("fpredimentypeCode"), 0) > 0 ? YesNoEnum.YES.getKey() : YesNoEnum.NO.getKey();
                        }
                        dynamicObject.set(lowerProperty, val);
                    }
                    data.add((Object)dynamicObject);
                }
                this.getQueryResult().setCollection(data);
                this.getQueryResult().setDataCount((int)total);
                this.ctx.getCache().put("total", String.valueOf(total));
            }
            this.ctx.setBillDataList(dataList);
        } else {
            this.ctx.setCurLastDetailBaseResult(BaseResult.fail((String)"", (String)""));
        }
        return data;
    }

    public int getRealCount() {
        return Integer.parseInt(this.ctx.getCache().get("total"));
    }

    public int getMaxCount() {
        return Integer.parseInt(this.ctx.getCache().get("total"));
    }
}

