/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.ai.ids.core.cache.AppCache;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.enumtype.AppConfigParameterEnum;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.enumtype.DataMarkListType;
import kd.ai.ids.core.enumtype.FilterItemBizTypeEnum;
import kd.ai.ids.core.enumtype.FilterItemTypeEnum;
import kd.ai.ids.core.enumtype.MarkTypeEnum;
import kd.ai.ids.core.enumtype.ModelConfigItemEnum;
import kd.ai.ids.core.enumtype.OutlierTagTypeEnum;
import kd.ai.ids.core.enumtype.SubParameterScopeEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.query.data.DataMarkFilterItemQuery;
import kd.ai.ids.core.query.data.DeleteDataMarkQuery;
import kd.ai.ids.core.query.data.FilterItemValuesDTO;
import kd.ai.ids.core.query.data.SaveDataMarkQuery;
import kd.ai.ids.core.query.label.LabelItem;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.control.IdsFilterItemEdit;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.form.DataMarkDetailContext;
import kd.ai.ids.plugin.form.DataMarkDetailDataProvider;
import kd.ai.ids.plugin.tool.ControlTools;
import kd.ai.ids.plugin.tool.FormTools;
import kd.ai.ids.plugin.tool.PopAppUtils;
import kd.ai.ids.plugin.tool.ShowTipsTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Donothing;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DataMarkDetailListPlugin
extends BaseFormPlugin
implements CreateListColumnsListener,
TabSelectListener,
ItemClickListener {
    public static final String KEY_LOAD_DATA_MARK_SUMMARY = "loadDataMarkSummary";
    public static final String KEY_PREDIMENTTYPE_LAST_LABEL_ID = "predimenttype_last_label_id";
    public static final String KEY_PREDIMENTTYPE_ALL_LABEL_ID = "predimenttype_all_label_id";
    public static final String KEY_PREDIMENTTYPE_DIM_LABEL_ID = "predimenttype_dim_label_id";
    public static final String KEY_PREDIMENTTYPE_LABEL_NAME = "predimenttype_label_name_";
    private static final String KEY_LABEL_MARKED_OBJ_COUNT = "markedobjcount";
    private static final String KEY_LABEL_UNMARK_OBJ_COUNT = "unmarkobjcount";
    private static final String KEY_LABEL_MARKED_OBJ_RECORD_COUNT = "markedobjrecordcount";
    private static final String KEY_LABEL_MARKED_BILL_COUNT = "markedbillcount";
    private static final String KEY_LABEL_BEFORE_MARK_ERROR = "beforemarkerror";
    private static final String KEY_LABEL_AFTER_MARK_ERROR = "aftermarkerror";
    private static final String KEY_LABEL_BEFORE_MARK_ERROR_PERCENT = "beforemarkerrorpercent";
    private static final String KEY_LABEL_AFTER_MARK_ERROR_PERCENT = "aftermarkerrorpercent";
    private static final String KEY_VECTORAP_CHANGE_ERROR = "vectorapchangeerror";
    private static final String KEY_DECIMAL_CHANGE_ERROR = "decimalchangeerror";
    private static final String KEY_LABEL_CHANGE_ERROR_PERCENT = "labelchangeerrorpercent";
    private static final String[] QUERY_FIELD_LIST = new String[]{"fpretimetype", "1"};
    private static final String KEY_BTN_UN_ONLINE_OK = "btnunonlineok";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_MULBD_PREFIX = "predimenttype";
    private static final String KEY_BILL_LIST_AP_ITEM_DATA_MARK = "billlistapitemdatamark";
    private static final String KEY_LIST_GRID_VIEW_ITEM_DATA_MARK = "listgridviewitemdatamark";
    private static final String KEY_LIST_OP_COLUMN_MARK = "listopcolumnmark";
    private static final String KEY_DATARANGEEDIT_TIME = "daterangeedittime";
    private static final String KEY_OPERATE_KEY_ENTER_AND_MARK = "enterandmark";
    private static final String KEY_OPERATE_KEY_MARK = "datamark";
    private static final String KEY_OPERATE_KEY_MARK_ANALYSIS = "markanalysis";
    private static final String KEY_BTN_ITEM_BATCH_MARK = "btnitembatchmark";
    private static final String KEY_FLEX_PANELAP_FILTER = "flexpanelapfilter";
    private static final String KEY_FLEX_EMPTY_FILTER = "flexemptyfilter";
    private DataMarkDetailContext ctx = null;
    private AtomicBoolean initBillListListener = new AtomicBoolean(false);
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_FLEX_PREDICT_OUTLIER = "flexpredictoutlier";
    private static final String KEY_FLEX_HISTORY_OUTLIER = "flexhistoryoutlier";
    private static final String KEY_LIST_BOX = "listbox";
    private static final String KEY_LIST_BOX_ITEM_MARK_ENTRY = "markentry";
    private static final String KEY_TAB_PAGE_PREFIX = "tabpage_";
    private static final String KEY_TAB_KEY_PREDICT = "predict";
    private static final String KEY_TAB_KEY_ANALYSIS = "analysis";
    private static final String KEY_TAB_KEY_HISTORY = "history";
    private static final String KEY_FLEX_FILTER_ITEM_LIST = "flexpanelap3";
    private static final String KEY_FLEX_LISTBOX_OUTLIER = "flexlistboxoutlier";
    private static final String KEY_FLEX_FILTER_WRAP = "flexfilterwrap";
    private static final String KEY_FLEX_PREDICT_DATA_LIST = "flexpredictdatalist";
    private static final String KEY_IS_INIT_PAGE_DATA = "is_init_page_data";
    private static final String KEY_BTN_DEL_MARK_BILL = "btndelmarkbill";
    private static final String KEY_ENTRY_ENTITY_BILL = "billentryentity";
    private static final String KEY_F_ENTRY_ID = "fentryid";
    private static final String KEY_FLEX_FILTER = "flexfilter";
    private static final String KEY_BTN_FILTER = "btnfilter";
    private static final String KEY_VECTOR_FILTER = "vectorfilter";
    private static final String KEY_IS_FOLD_FILTER = "isFoldFilter";
    private static final String KEY_LISTOPCOLUMNMARK = "listopcolumnmark";
    private static final String KEY_FLEX_MARK_SUMMARY = "flexmarksummary";
    private static final String KEY_FLEX_MARK_ERROR = "flexmarkerror";
    private static final String KEY_CUSTOMCONTROLAP_STACKED = "ai_ids_data_mark_analysis";
    private static final String KEY_CUSTOMCONTROLAP_BAR = "ai_ids_dm_tag_influence";
    private static final String KEY_FLEX_LAYER = "flexlayer";
    private static final String KEY_FLEX_DRAWER_SHADOW = "flexdrawershadow";
    private static final String KEY_LABEL_PREDICT_ITEM = "labelpredictitem";
    private static final String KEY_VECTORAP_CLOSE = "vectorapclose";
    private static final String KEY_TOOLBARAP = "toolbarap";
    private static final String KEY_BARITEMAP_ITEM_BATCH_MARK = "baritemapitembatchmark";

    private boolean getIsInitPageData() {
        String isInit = this.getCache().get(KEY_IS_INIT_PAGE_DATA);
        return kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)isInit) ? Boolean.parseBoolean(isInit) : false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.ctx = new DataMarkDetailContext(this.getCache());
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_ITEM_DATA_MARK);
        billList.setBillFormId("ids_data_mark_details");
        billList.setEntityId("ids_data_mark_details");
        billList.setEntryEntity("ids_data_mark_details");
        if (!this.initBillListListener.getAndSet(true)) {
            billList.addCreateListColumnsListener((CreateListColumnsListener)this);
            billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new DataMarkDetailDataProvider().setCtx(this.ctx)));
            billList.addPagerClickListener(pagerClickEvent -> {
                int currentPageIndex = pagerClickEvent.getCurrentPageIndex();
                int pageRows = pagerClickEvent.getPageRows();
                this.ctx.setPageIndex(currentPageIndex);
                this.ctx.setPageSize(pageRows);
            });
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_RESET, KEY_BTN_DEL_MARK_BILL, KEY_BTN_FILTER, KEY_VECTOR_FILTER, KEY_BTN_ITEM_BATCH_MARK, KEY_VECTORAP_CLOSE, KEY_FLEX_DRAWER_SHADOW});
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        Toolbar toolbar = (Toolbar)this.getView().getControl(KEY_TOOLBARAP);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        RequestContext rc = RequestContext.get();
        String itemKey = evt.getItemKey();
        if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)KEY_BARITEMAP_ITEM_BATCH_MARK)) {
            this.showMarkForm();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        super.click(evt);
        switch (evtKey) {
            case "btnrefresh": {
                this.refreshBillList(false, this.ctx.getCurFilterItemQuery());
                break;
            }
            case "btnreset": {
                this.resetQueryCondition();
                this.refreshBillList(true, null);
                break;
            }
            case "btndelmarkbill": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY_BILL);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u8bb0\u5f55\u5417\uff1f", (String)"MarkOutlierTagListPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_BTN_DEL_MARK_BILL, (IFormPlugin)this);
                this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener, null, "");
                break;
            }
            case "btnfilter": 
            case "vectorfilter": {
                this.expandOrFoldFilterPanel(true);
                break;
            }
            case "vectorapclose": 
            case "flexdrawershadow": {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_LAYER});
                break;
            }
        }
    }

    private void expandOrFoldFilterPanel(boolean isAutoSwitch) {
        String isFoldFilter = AppCache.get().get(KEY_IS_FOLD_FILTER);
        boolean isFold = true;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)isFoldFilter)) {
            isFold = Boolean.parseBoolean(isFoldFilter);
        }
        Vector vector = (Vector)this.getControl(KEY_VECTOR_FILTER);
        HashMap map1 = new HashMap();
        HashMap map2 = new HashMap();
        if (isAutoSwitch) {
            if (isFold) {
                this.expandFilterPanel(vector, map1, map2);
            } else {
                this.foldFilterPanel(vector, map1, map2);
            }
        } else if (isFold) {
            this.foldFilterPanel(vector, map1, map2);
        } else {
            this.expandFilterPanel(vector, map1, map2);
        }
    }

    private void foldFilterPanel(Vector vector, Map map1, Map map2) {
        AppCache.get().put(KEY_IS_FOLD_FILTER, Boolean.TRUE.toString(), 604800);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_FILTER});
        map1.put("zh_CN", "\u5c55\u5f00\u8fc7\u6ee4");
        map2.put("text", map1);
        this.getView().updateControlMetadata(KEY_BTN_FILTER, map2);
        vector.setFontClass("kdfont kdfont-zhankai4");
    }

    private void expandFilterPanel(Vector vector, Map map1, Map map2) {
        AppCache.get().put(KEY_IS_FOLD_FILTER, Boolean.FALSE.toString(), 604800);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_FILTER});
        map1.put("zh_CN", "\u6536\u8d77\u8fc7\u6ee4");
        map2.put("text", map1);
        this.getView().updateControlMetadata(KEY_BTN_FILTER, map2);
        vector.setFontClass("kdfont kdfont-shouqi7");
    }

    private List<String> getSelectedFpredimentypeCodeList() {
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_ITEM_DATA_MARK);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<String> fpredimentypeCodeList = new ArrayList<String>();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            long rowIndex = (Long)listSelectedRow.getPrimaryKeyValue();
            List<JSONObject> billDataList = this.ctx.getBillDataList();
            JSONObject rowData = billDataList.get((int)rowIndex);
            String fpredimentypeCode = rowData.getString("fpredimentypeCode");
            fpredimentypeCodeList.add(fpredimentypeCode);
        }
        return fpredimentypeCodeList;
    }

    private void showMarkForm() {
        List<String> fpredimentypeCodeList = this.getSelectedFpredimentypeCodeList();
        if (CollectionUtils.isNotEmpty(fpredimentypeCodeList)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ids_mark_outlier_tag_dlg");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("fpredimentypeCodeList", fpredimentypeCodeList);
            customParams.put("fmarktype", MarkTypeEnum.ITEM.getId());
            customParams.put("subServiceId", this.ctx.getSubServiceId());
            customParams.put("isMark", YesNoEnum.NO.getKey());
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BTN_ITEM_BATCH_MARK));
            this.getView().showForm(showParameter);
        }
    }

    private void deleteBatchMarkBill() {
        RequestContext rc = RequestContext.get();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY_BILL);
        DynamicObjectCollection entityDoc = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY_BILL);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
            return;
        }
        String fmarkType = MarkTypeEnum.BILL.getId();
        for (int selectRow : selectRows) {
            ArrayList<String> fentryidList = new ArrayList<String>(1);
            DynamicObject dynamicObject = (DynamicObject)entityDoc.get(selectRow);
            fentryidList.add(dynamicObject.getString(KEY_F_ENTRY_ID));
            String fpredimentypeCode = dynamicObject.getString("fpredimentypecode");
            DeleteDataMarkQuery deleteDataMarkQuery = new DeleteDataMarkQuery();
            deleteDataMarkQuery.setFpredimentypeCode(fpredimentypeCode);
            deleteDataMarkQuery.setSubServiceId(this.ctx.getSubServiceId());
            deleteDataMarkQuery.setFuserid(rc.getUid());
            deleteDataMarkQuery.setFusername(rc.getUserName());
            deleteDataMarkQuery.setFentryidList(fentryidList);
            BaseResult baseResult = this.dataMarkService().deleteBatchMark(Long.valueOf(rc.getOrgId()), deleteDataMarkQuery);
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u5220\u9664\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u5220\u9664\u6210\u529f", fmarkType, fpredimentypeCode));
                continue;
            }
            this.getView().showErrorNotification(baseResult.getDescriptionCn());
            LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u5220\u9664\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u5220\u9664\u5931\u8d25", fmarkType, fpredimentypeCode));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"Common_Delete_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
        this.loadOutlierBillEntry();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            BillList billList;
            ListSelectedRow listSelectedRow;
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OPERATE_KEY_ENTER_AND_MARK) || kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OPERATE_KEY_MARK)) {
                BillList billList2 = (BillList)this.getControl(KEY_BILL_LIST_AP_ITEM_DATA_MARK);
                ListSelectedRow listSelectedRow2 = billList2.getCurrentSelectedRowInfo();
                if (listSelectedRow2 != null) {
                    String preObjName;
                    long rowIndex = (Long)listSelectedRow2.getPrimaryKeyValue();
                    List<JSONObject> billDataList = this.ctx.getBillDataList();
                    JSONObject rowData = billDataList.get((int)rowIndex);
                    String fpredimentypeCode = rowData.getString("fpredimentypeCode");
                    String fpredimentypeCodeName = rowData.getString("fpredimentypeCodeName");
                    String[] predimentypeCodeNameArr = kd.bos.dataentity.utils.StringUtils.split((String)(fpredimentypeCodeName = fpredimentypeCodeName.replaceAll("->", "====")), (String)"====");
                    String string = preObjName = predimentypeCodeNameArr != null && predimentypeCodeNameArr.length > 0 ? predimentypeCodeNameArr[predimentypeCodeNameArr.length - 1] : "";
                    if (preObjName.length() > 6) {
                        preObjName = String.format("%s...", preObjName.substring(0, 6));
                    }
                    String caption = ResManager.loadKDString((String)"\u6807\u6ce8\u8be6\u60c5", (String)"ModelAnaOutlierDetailListPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    String appNumber = "ids";
                    String appId = AppMetadataCache.getAppInfo((String)appNumber).getAppId();
                    IFormView mainView = this.getView().getMainView();
                    if (mainView != null) {
                        String mainViewPageId = mainView.getPageId();
                        String appPageId = appNumber + mainViewPageId;
                        String billPageId = fpredimentypeCode + mainViewPageId;
                        if (null != mainView.getViewNoPlugin(billPageId)) {
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            hashMap.put("view", this.getView());
                            hashMap.put("appname", String.format("%s-%s", caption, preObjName));
                            hashMap.put("formnumber", "ids_outlier_mark_detail");
                            hashMap.put("parametertype", "FormShowParameter");
                            PopAppUtils.activatePage(billPageId, this.getView(), hashMap);
                        } else {
                            FormShowParameter formShowParameter = new FormShowParameter();
                            formShowParameter.setFormId("ids_outlier_mark_detail");
                            formShowParameter.setCaption(String.format("%s-%s", caption, preObjName));
                            formShowParameter.setAppId(appId);
                            formShowParameter.setCustomParam("appid", (Object)appId);
                            HashMap<String, String> customParams = new HashMap<String, String>();
                            customParams.put("fpredimentypeCode", fpredimentypeCode);
                            customParams.put("fpredimentypeCodeName", rowData.getString("fpredimentypeCodeName"));
                            formShowParameter.setCustomParams(customParams);
                            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
                            formShowParameter.setPageId(billPageId);
                            IFormView fromView = this.getView().getView(appPageId);
                            if (fromView != null) {
                                fromView.showForm(formShowParameter);
                                this.getView().sendFormAction(fromView);
                            }
                        }
                    }
                }
            } else if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OPERATE_KEY_MARK_ANALYSIS) && (listSelectedRow = (billList = (BillList)this.getControl(KEY_BILL_LIST_AP_ITEM_DATA_MARK)).getCurrentSelectedRowInfo()) != null) {
                long rowIndex = (Long)listSelectedRow.getPrimaryKeyValue();
                List<JSONObject> billDataList = this.ctx.getBillDataList();
                JSONObject rowData = billDataList.get((int)rowIndex);
                String fpredimentypeCode = rowData.getString("fpredimentypeCode");
                String fpredimentypeCodeName = rowData.getString("fpredimentypeCodeName");
                String fpretimetype = rowData.getString("fpretimetype");
                this.getDataMarkAnalysis(fpredimentypeCode, fpretimetype);
                this.getDataMarkTagInfluenceAnalysis(fpredimentypeCode, fpretimetype);
                this.setLabelText(KEY_LABEL_PREDICT_ITEM, fpredimentypeCodeName);
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_LAYER});
            }
        }
    }

    private void resetQueryCondition() {
        this.clearPredimentTypeFilterData();
        DataMarkFilterItemQuery defaultFilterItemQuery = this.ctx.getDefaultFilterItemQuery();
        if (defaultFilterItemQuery != null) {
            defaultFilterItemQuery.setCurrent(Long.valueOf(1L));
            defaultFilterItemQuery.setOrderByExpr(null);
            defaultFilterItemQuery.setFilters(null);
        }
        this.ctx.setCurFilterItemQuery(defaultFilterItemQuery);
        if (defaultFilterItemQuery != null) {
            DateRangeEdit timeDateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATARANGEEDIT_TIME);
            String keyTimeStartDate = timeDateRangeEdit.getStartDateFieldKey();
            String keyTimeEndDate = timeDateRangeEdit.getEndDateFieldKey();
            this.getModel().setValue(keyTimeStartDate, null);
            this.getModel().setValue(keyTimeEndDate, null);
        }
    }

    private void clearPredimentTypeFilterData() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        List allLabelIdList = this.getCache().getAsList(KEY_PREDIMENTTYPE_ALL_LABEL_ID, String.class);
        for (String key : allLabelIdList) {
            this.getCache().remove("ListData_" + key);
            this.getCache().remove("SelectedList_" + key);
            clientViewProxy.setFieldProperty("predimenttype_" + key, "v", (Object)new Object[0]);
        }
    }

    private void buildFilterItemValuesDTOList(List<FilterItemValuesDTO> filterItemValuesDTOList, String labelId) {
        String fieldKey = "predimenttype_" + labelId;
        IdsFilterItemEdit edit = (IdsFilterItemEdit)this.getControl(fieldKey);
        List<String> numberList = edit.getSelectedNumberList();
        FilterItemValuesDTO filterItem = new FilterItemValuesDTO();
        filterItem.setLabelId(labelId);
        String values = "-1";
        if (numberList != null && !numberList.isEmpty()) {
            values = String.join((CharSequence)",", numberList);
        }
        filterItem.setValues(values);
        filterItemValuesDTOList.add(filterItem);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        RequestContext rc = RequestContext.get();
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        ChangeData newData = changeData[0];
        boolean isInitPageData = this.getIsInitPageData();
        if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"tag")) {
            if (!isInitPageData) {
                String tag = newData.getNewValue() != null ? changeData[0].getNewValue().toString() : "";
                tag = StrUtils.trimSplitChar((String)tag);
                String ftagname = null;
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)tag)) {
                    DynamicObject tagDo = BusinessDataServiceHelper.loadSingle((String)"ids_mark_outlier_tag", (String)"name,status,allowtimeconfig", (QFilter[])new QFilter("number", "=", (Object)tag).toArray());
                    if (tagDo == null) {
                        String msg = ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u3010%s\u3011\u5df2\u88ab\u5220\u9664\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"MarkOutlierTagDlgFormPlugin_4", (String)"ai-ids-plugin", (Object[])new Object[0]);
                        ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), String.format(msg, tag), BaseResult.FAIL);
                        return;
                    }
                    if (!tagDo.getBoolean("status")) {
                        String msg = ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u3010%s\u3011\u5df2\u88ab\u7981\u7528\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"MarkOutlierTagDlgFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]);
                        ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), String.format(msg, tag), BaseResult.FAIL);
                        return;
                    }
                    ftagname = tagDo.getString("name");
                }
                DynamicObject dataEntity = newData.getDataEntity();
                String fentryid = dataEntity.getString(KEY_F_ENTRY_ID);
                String fpredimentypeCode = dataEntity.getString("fpredimentypecode");
                SaveDataMarkQuery saveDataMarkQuery = new SaveDataMarkQuery();
                saveDataMarkQuery.setFtag(tag);
                String customTag = dataEntity.getString("customtag");
                customTag = StrUtils.trimSplitChar((String)customTag);
                String ftagtype = dataEntity.getString("ftagtype");
                saveDataMarkQuery.setFcustomTag(customTag);
                saveDataMarkQuery.setFentryidList(Collections.singletonList(fentryid));
                saveDataMarkQuery.setFmarktype(MarkTypeEnum.BILL.getId());
                saveDataMarkQuery.setFpredimentypeCodeList(Collections.singletonList(fpredimentypeCode));
                saveDataMarkQuery.setSubServiceId(this.ctx.getSubServiceId());
                saveDataMarkQuery.setFuserid(rc.getUid());
                saveDataMarkQuery.setFusername(rc.getUserName());
                saveDataMarkQuery.setFtagtype(ftagtype);
                saveDataMarkQuery.setFtagname(ftagname);
                BaseResult baseResult = this.dataOutlierAnaService().saveMark(Long.valueOf(rc.getOrgId()), saveDataMarkQuery);
                if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                    if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)customTag) && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)tag)) {
                        this.getModel().deleteEntryRow(KEY_ENTRY_ENTITY_BILL, newData.getRowIndex());
                        this.loadOutlierBillEntry();
                    }
                    String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.SUCCESS);
                    LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u6807\u6ce8-\u6210\u529f", saveDataMarkQuery.getFmarktype(), fpredimentypeCode));
                } else {
                    this.getView().showErrorNotification(baseResult.getDescriptionCn());
                    LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u6807\u6ce8-\u5931\u8d25", saveDataMarkQuery.getFmarktype(), fpredimentypeCode));
                }
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"customtag") && !isInitPageData) {
            String customTag = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            DynamicObject dataEntity = newData.getDataEntity();
            String tag = dataEntity.getString("tag");
            DynamicObject tagDo = BusinessDataServiceHelper.loadSingle((String)"ids_mark_outlier_tag", (String)"name,status,allowtimeconfig", (QFilter[])new QFilter("number", "=", (Object)tag).toArray());
            String ftagname = "";
            if (tagDo != null) {
                ftagname = tagDo.getString("name");
            }
            String ftagtype = dataEntity.getString("ftagtype");
            customTag = StrUtils.trimSplitChar((String)customTag);
            tag = StrUtils.trimSplitChar((String)tag);
            String fentryid = dataEntity.getString(KEY_F_ENTRY_ID);
            String fpredimentypeCode = dataEntity.getString("fpredimentypecode");
            SaveDataMarkQuery saveDataMarkQuery = new SaveDataMarkQuery();
            saveDataMarkQuery.setFtag(tag);
            saveDataMarkQuery.setFcustomTag(customTag);
            saveDataMarkQuery.setFentryidList(Collections.singletonList(fentryid));
            saveDataMarkQuery.setFmarktype(MarkTypeEnum.BILL.getId());
            saveDataMarkQuery.setFpredimentypeCodeList(Collections.singletonList(fpredimentypeCode));
            saveDataMarkQuery.setSubServiceId(this.ctx.getSubServiceId());
            saveDataMarkQuery.setFuserid(rc.getUid());
            saveDataMarkQuery.setFusername(rc.getUserName());
            saveDataMarkQuery.setFtagtype(ftagtype);
            saveDataMarkQuery.setFtagname(ftagname);
            BaseResult baseResult = this.dataOutlierAnaService().saveMark(Long.valueOf(rc.getOrgId()), saveDataMarkQuery);
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)customTag) && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)tag)) {
                    this.getModel().deleteEntryRow(KEY_ENTRY_ENTITY_BILL, newData.getRowIndex());
                    this.loadOutlierBillEntry();
                }
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
                ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.SUCCESS);
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u81ea\u5b9a\u4e49\u6807\u6ce8-\u6210\u529f", saveDataMarkQuery.getFmarktype(), fpredimentypeCode));
            } else {
                this.getView().showErrorNotification(baseResult.getDescriptionCn());
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u81ea\u5b9a\u4e49\u6807\u6ce8-\u5931\u8d25", saveDataMarkQuery.getFmarktype(), fpredimentypeCode));
            }
        }
    }

    private void setOutlierTabFlexVisible(String tabKey) {
        if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_KEY_PREDICT) || kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_KEY_ANALYSIS)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREDICT_OUTLIER});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_FILTER_ITEM_LIST});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREDICT_DATA_LIST});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_LISTBOX_OUTLIER});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_FILTER_WRAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_HISTORY_OUTLIER});
        } else if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_KEY_HISTORY)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREDICT_OUTLIER});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_FILTER_ITEM_LIST});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_LISTBOX_OUTLIER});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_FILTER_WRAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_HISTORY_OUTLIER});
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    private void loadAnaResultsFilterItem() {
        RequestContext rc = RequestContext.get();
        String fitemKeys = String.format("%s,%s,%s", ModelConfigItemEnum.DATAMARK_PRE_DIMEN_TYPE.getId(), ModelConfigItemEnum.DATAMARK_FILTER_ITEM.getId(), ModelConfigItemEnum.DATAMARK_PREDICT_ITEM_DATA_FIELDS.getId());
        JSONObject dataJo = this.commonService().getModelConfigItem(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId(), fitemKeys);
        if (dataJo == null) {
            return;
        }
        JSONArray predimenttypeArray = dataJo.getJSONObject(ModelConfigItemEnum.DATAMARK_PRE_DIMEN_TYPE.getId()).getJSONArray("fitemvalue");
        JSONArray filteritemArray = dataJo.getJSONObject(ModelConfigItemEnum.DATAMARK_FILTER_ITEM.getId()).getJSONArray("fitemvalue");
        predimenttypeArray.addAll(CollectionUtils.isNotEmpty((Collection)predimenttypeArray) ? predimenttypeArray.size() - 1 : 0, (Collection)filteritemArray);
        this.initPreDimentType(predimenttypeArray);
    }

    private void initPreDimentType(JSONArray predimentTypeArray) {
        ArrayList<String> filterLabelIdList = new ArrayList<String>();
        List allLabelIdList = this.getCache().getAsList(KEY_PREDIMENTTYPE_ALL_LABEL_ID, String.class);
        ArrayList<String> dimLabelIdList = new ArrayList<String>(5);
        Container panel = (Container)this.getControl(KEY_FLEX_FILTER_ITEM_LIST);
        String[] deleteControls = (String[])allLabelIdList.stream().flatMap(s -> {
            String key = "predimenttype_" + s;
            return Stream.of(key + "_panel", key + "_label", key);
        }).toArray(String[]::new);
        panel.deleteControls(deleteControls);
        if (predimentTypeArray != null && !predimentTypeArray.isEmpty()) {
            int index = 0;
            int len = predimentTypeArray.size();
            for (int i = 0; i < len; ++i) {
                JSONObject jo = predimentTypeArray.getJSONObject(i);
                String labelId = jo.getString("labelId");
                String fieldKey = "predimenttype_" + labelId;
                String labelName = jo.getString("labelName");
                String type = jo.getString("type");
                this.getCache().put(KEY_PREDIMENTTYPE_LABEL_NAME + labelId, labelName);
                filterLabelIdList.add(labelId);
                if (!allLabelIdList.contains(labelId)) {
                    allLabelIdList.add(labelId);
                }
                if (!dimLabelIdList.contains(labelId) && kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)FilterItemTypeEnum.DIM.getId())) {
                    dimLabelIdList.add(labelId);
                }
                Map<String, Object> control = ControlTools.createMulBaseDataControl(fieldKey, labelName);
                panel.insertControls(index, Collections.singletonList(control));
                ++index;
            }
        }
        this.getCache().put(KEY_PREDIMENTTYPE_DIM_LABEL_ID, dimLabelIdList);
        this.getCache().put(KEY_PREDIMENTTYPE_ALL_LABEL_ID, allLabelIdList);
        this.ctx.setPreDimentTypeFilterLabelIdList(filterLabelIdList);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.expandOrFoldFilterPanel(false);
        this.initControlVisible();
        String defaultTabKey = "tabpage_predict";
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fpredimentype = (String)formShowParameter.getCustomParam("fpredimentype");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fpredimentype)) {
            defaultTabKey = KEY_TAB_PAGE_PREFIX + fpredimentype;
            Tab tab = (Tab)this.getControl(KEY_TABAP);
            tab.activeTab(defaultTabKey);
        }
        String filterItemQueryStr = (String)formShowParameter.getCustomParam("filterItemQuery");
        DataMarkFilterItemQuery filterItemQuery = null;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)filterItemQueryStr)) {
            filterItemQuery = (DataMarkFilterItemQuery)JSON.toJavaObject((JSON)JSON.parseObject((String)filterItemQueryStr), DataMarkFilterItemQuery.class);
            this.ctx.setCurFilterItemQuery(filterItemQuery);
            DateRangeEdit timeDateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATARANGEEDIT_TIME);
            String keyTimeStartDate = timeDateRangeEdit.getStartDateFieldKey();
            String keyTimeEndDate = timeDateRangeEdit.getEndDateFieldKey();
            if (filterItemQuery.getStartTime() != null) {
                this.getModel().setValue(keyTimeStartDate, (Object)DateUtils.parseDate((String)filterItemQuery.getStartTime(), (String)"yyyy-MM-dd"));
            }
            if (filterItemQuery.getEndTime() != null) {
                this.getModel().setValue(keyTimeEndDate, (Object)DateUtils.parseDate((String)filterItemQuery.getEndTime(), (String)"yyyy-MM-dd"));
            }
        }
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.ctx.setSubServiceId(subServiceId);
        this.loadAnaResultsFilterItem();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)fpredimentype)) {
            this.loadChartData(true, null);
        }
    }

    private void getDataMarkSummaryData() {
        RequestContext rc = RequestContext.get();
        BaseResult baseResult = this.dataMarkService().getDataMarkSummary(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId());
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
            this.ctx.setDataMarkSummaryBaseResult(baseResult);
        }
    }

    private void showDataMarkSummary() {
        RequestContext rc = RequestContext.get();
        BaseResult baseResult = this.ctx.getDataMarkSummaryBaseResult();
        if (baseResult == null) {
            baseResult = this.dataMarkService().getDataMarkSummary(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId());
        }
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
            String[] split;
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            this.setLabelText(KEY_LABEL_MARKED_OBJ_COUNT, String.valueOf(dataJo.getLongValue("markedObjCount")));
            this.setLabelText(KEY_LABEL_UNMARK_OBJ_COUNT, String.valueOf(dataJo.getLongValue("unmarkObjCount")));
            this.setLabelText(KEY_LABEL_MARKED_OBJ_RECORD_COUNT, String.valueOf(dataJo.getLongValue("markedObjRecordCount")));
            this.setLabelText(KEY_LABEL_MARKED_BILL_COUNT, String.valueOf(dataJo.getLongValue("markedBillCount")));
            double beforeMarkError = dataJo.getDoubleValue("beforeMarkError");
            double afterMarkError = dataJo.getDoubleValue("afterMarkError");
            double changeMarkError = afterMarkError - beforeMarkError;
            boolean isReduce = changeMarkError < 0.0;
            changeMarkError = isReduce ? -changeMarkError : changeMarkError;
            String beforeMarkErrorStr = String.valueOf(beforeMarkError);
            String afterMarkErrorStr = String.valueOf(afterMarkError);
            String beforeMarkErrorInt = beforeMarkErrorStr;
            String afterMarkErrorInt = afterMarkErrorStr;
            String beforeMarkErrorPercent = ".0%";
            String afterMarkErrorPercent = ".0%";
            if (beforeMarkErrorStr.contains(".")) {
                split = beforeMarkErrorStr.split("\\.");
                beforeMarkErrorInt = split[0];
                beforeMarkErrorPercent = String.format(".%s", split[1]) + "%";
            }
            if (afterMarkErrorStr.contains(".")) {
                split = afterMarkErrorStr.split("\\.");
                afterMarkErrorInt = split[0];
                afterMarkErrorPercent = String.format(".%s", split[1]) + "%";
            }
            this.setLabelText(KEY_LABEL_BEFORE_MARK_ERROR, beforeMarkErrorInt);
            this.setLabelText(KEY_LABEL_AFTER_MARK_ERROR, afterMarkErrorInt);
            this.setLabelText(KEY_LABEL_BEFORE_MARK_ERROR_PERCENT, beforeMarkErrorPercent);
            this.setLabelText(KEY_LABEL_AFTER_MARK_ERROR_PERCENT, afterMarkErrorPercent);
            Vector changeErrorVector = (Vector)this.getControl(KEY_VECTORAP_CHANGE_ERROR);
            changeErrorVector.setFontClass(isReduce ? "kdfont kdfont-guolvxia" : "kdfont kdfont-guolvshang");
            this.getModel().setValue(KEY_DECIMAL_CHANGE_ERROR, (Object)changeMarkError);
            HashMap<String, String> propsMap = new HashMap<String, String>();
            propsMap.put("fc", isReduce ? "#1BA854" : "#212121");
            this.getView().updateControlMetadata(KEY_VECTORAP_CHANGE_ERROR, propsMap);
            this.getView().updateControlMetadata(KEY_DECIMAL_CHANGE_ERROR, propsMap);
            this.getView().updateControlMetadata(KEY_LABEL_CHANGE_ERROR_PERCENT, propsMap);
        }
    }

    private void getDataMarkAnalysis(String fpredimentypeCode, String fpretimetype) {
        RequestContext rc = RequestContext.get();
        BaseResult baseResult = this.dataMarkService().getDataMarkAnalysis(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId(), fpredimentypeCode, fpretimetype);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("containerId", KEY_CUSTOMCONTROLAP_STACKED);
            customData.put("chartType", "tag_mark_ana");
            customData.put("data", dataJo);
            customData.put("timestamp", new Date().getTime());
            customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOMCONTROLAP_STACKED);
            customControl.setData(customData);
        }
    }

    private void getDataMarkTagInfluenceAnalysis(String fpredimentypeCode, String fpretimetype) {
        RequestContext rc = RequestContext.get();
        BaseResult baseResult = this.dataMarkService().getDataMarkTagInfluenceAnalysis(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId(), fpredimentypeCode, fpretimetype);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("containerId", KEY_CUSTOMCONTROLAP_BAR);
            customData.put("chartType", "tag_influence_ana");
            customData.put("data", dataJo);
            customData.put("timestamp", new Date().getTime());
            customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOMCONTROLAP_BAR);
            customControl.setData(customData);
        }
    }

    private void initControlVisible() {
        this.setOutlierTabFlexVisible(KEY_TAB_KEY_PREDICT);
    }

    private void loadChartData(boolean isInit, DataMarkFilterItemQuery filterItemQuery) {
        if (filterItemQuery == null) {
            filterItemQuery = new DataMarkFilterItemQuery();
        }
        filterItemQuery.setListType(kd.bos.dataentity.utils.StringUtils.equals((CharSequence)this.ctx.getCurrTabKey(), (CharSequence)KEY_TAB_KEY_ANALYSIS) ? DataMarkListType.MARKED.getId() : DataMarkListType.ALL.getId());
        DateRangeEdit timeDateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATARANGEEDIT_TIME);
        String keyTimeStartDate = timeDateRangeEdit.getStartDateFieldKey();
        String keyTimeEndDate = timeDateRangeEdit.getEndDateFieldKey();
        Date timeStartDate = (Date)this.getModel().getValue(keyTimeStartDate);
        Date timeEndDate = (Date)this.getModel().getValue(keyTimeEndDate);
        if (timeStartDate != null) {
            filterItemQuery.setStartTime(DateFormatUtils.format((Date)timeStartDate, (String)"yyyy-MM-dd"));
        } else {
            filterItemQuery.setStartTime(null);
        }
        if (timeEndDate != null) {
            filterItemQuery.setEndTime(DateFormatUtils.format((Date)timeEndDate, (String)"yyyy-MM-dd"));
        } else {
            filterItemQuery.setEndTime(null);
        }
        filterItemQuery.setSubServiceId(this.ctx.getSubServiceId());
        filterItemQuery.setCurrent(Long.valueOf(1L));
        ArrayList<FilterItemValuesDTO> filterItemValuesDTOList = new ArrayList<FilterItemValuesDTO>();
        if (isInit && filterItemQuery.getFilterItemValuesDTOList() != null) {
            Map<String, FilterItemValuesDTO> filterItemValuesDTOMap = filterItemQuery.getFilterItemValuesDTOList().stream().collect(Collectors.toMap(FilterItemValuesDTO::getLabelId, filterItemValuesDTO -> filterItemValuesDTO));
            Iterator iterator = filterItemValuesDTOMap.entrySet().iterator();
            while (iterator.hasNext()) {
                String labelId = (String)iterator.next().getKey();
                String values = ((FilterItemValuesDTO)filterItemValuesDTOMap.get(labelId)).getValues();
                String fieldKey = "predimenttype_" + labelId;
                IdsFilterItemEdit edit = (IdsFilterItemEdit)this.getControl(fieldKey);
                edit.setItemByNumber(values, 0);
            }
        }
        for (String lableId : this.ctx.getPreDimentTypeFilterLabelIdList()) {
            this.buildFilterItemValuesDTOList(filterItemValuesDTOList, lableId);
        }
        filterItemQuery.setQueryFieldList(Arrays.asList(QUERY_FIELD_LIST));
        filterItemQuery.setFilterItemValuesDTOList(filterItemValuesDTOList);
        this.ctx.setCurFilterItemQuery(filterItemQuery);
        if (isInit) {
            this.ctx.setDefaultFilterItemQuery(filterItemQuery);
        }
        this.getView().addClientCallBack(KEY_LOAD_DATA_MARK_SUMMARY, Integer.valueOf(0));
        DataMarkFilterItemQuery finalFilterItemQuery = filterItemQuery;
        this.loadAnaLastDetailFromRemote(finalFilterItemQuery);
    }

    private void refreshBillList(boolean isInit, DataMarkFilterItemQuery filterItemQuery) {
        this.loadChartData(isInit, filterItemQuery);
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_ITEM_DATA_MARK);
        billList.setPageIndex(1);
        billList.clearSelection();
        billList.refresh();
    }

    private void loadAnaLastDetailFromRemote(DataMarkFilterItemQuery filterItemQuery) {
        RequestContext rc = RequestContext.get();
        filterItemQuery.setNeedRecord(Boolean.FALSE);
        BaseResult baseResult = this.dataMarkService().getDataMarkDetailList(Long.valueOf(rc.getOrgId()), filterItemQuery);
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            this.ctx.setCurLastDetailBaseResult(baseResult);
        } else {
            this.ctx.setCurLastDetailBaseResult(BaseResult.fail((String)"", (String)""));
        }
    }

    public void createListColumns(BeforeCreateListColumnsArgs arg0) {
        RequestContext rc = RequestContext.get();
        List columns = arg0.getListColumns();
        IListColumn seqListColumn = (IListColumn)columns.get(0);
        columns.clear();
        columns.add(seqListColumn);
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_ITEM_DATA_MARK);
        BaseResult baseResult = this.ctx.getCurLastDetailBaseResult();
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            JSONArray fieldsJa = CommonUtil.emptyIfNull((JSONArray)dataJo.getJSONArray("fields"));
            List<String> summaryFieldList = Arrays.asList(AppConstants.PREDICT_DETAIL_SUMMARY_FIELD_ARR);
            List<String> fixedFieldList = Arrays.asList(AppConstants.DATA_MARK_DETAIL_FIXED_FIELD_ARR);
            ArrayList<String> fieldList = new ArrayList<String>(10);
            for (int i = 0; i < fieldsJa.size(); ++i) {
                DecimalListColumn listColumn;
                JSONObject fieldsJo = fieldsJa.getJSONObject(i);
                String s = fieldsJo.getString("id");
                String id = s != null ? s.toLowerCase() : "";
                fieldList.add(id);
                boolean allowOrder = fieldsJo.getBooleanValue("allowOrder");
                boolean allowFilter = fieldsJo.getBooleanValue("allowFilter");
                boolean isHyperlink = false;
                boolean isFixed = fixedFieldList.contains(id.toLowerCase());
                if (summaryFieldList.contains(s)) {
                    listColumn = this.createDecimalListColumn(id, fieldsJo.getString("name"), i + 1, allowOrder, allowFilter, isFixed, isHyperlink);
                    listColumn.setParentViewKey(KEY_LIST_GRID_VIEW_ITEM_DATA_MARK);
                    columns.add(listColumn);
                    continue;
                }
                listColumn = this.createListColumn(id, fieldsJo.getString("name"), i + 1, allowOrder, allowFilter, isFixed, isHyperlink);
                listColumn.setParentViewKey(KEY_LIST_GRID_VIEW_ITEM_DATA_MARK);
                if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)"id")) {
                    listColumn.setVisible(0);
                } else if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)"fpretimetype")) {
                    listColumn.setVisible(0);
                }
                columns.add(listColumn);
            }
            ListOperationColumn listOperationColumn = this.createListOperationColumn("listopcolumnmark", ResManager.loadKDString((String)"\u6570\u636e\u6807\u6ce8", (String)"ModelAnaOutlierDetailListPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]), fieldsJa.size() + 2);
            listOperationColumn.setParentViewKey(KEY_LIST_GRID_VIEW_ITEM_DATA_MARK);
            columns.add(listOperationColumn);
            this.ctx.setPredictDetailFieldList(fieldList);
        }
        billList.addPackageDataListener(pkEvent -> {
            Object status = pkEvent.getRowData().get("ismark");
            if (pkEvent.getSource() instanceof ListOperationColumnDesc && "listopcolumnmark".equalsIgnoreCase(((ListOperationColumnDesc)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)this.ctx.getCurrTabKey(), (CharSequence)KEY_TAB_KEY_PREDICT)) {
                        if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)status.toString(), (CharSequence)YesNoEnum.YES.getKeyStr())) {
                            if (KEY_OPERATE_KEY_MARK.equalsIgnoreCase(operationColItem.getOperationKey())) {
                                operationColItem.setVisible(false);
                            } else if (KEY_OPERATE_KEY_ENTER_AND_MARK.equalsIgnoreCase(operationColItem.getOperationKey())) {
                                operationColItem.setVisible(true);
                            }
                        } else if (KEY_OPERATE_KEY_MARK.equalsIgnoreCase(operationColItem.getOperationKey())) {
                            operationColItem.setVisible(true);
                        } else if (KEY_OPERATE_KEY_ENTER_AND_MARK.equalsIgnoreCase(operationColItem.getOperationKey())) {
                            operationColItem.setVisible(false);
                        }
                        if (!KEY_OPERATE_KEY_MARK_ANALYSIS.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                        operationColItem.setVisible(false);
                        continue;
                    }
                    if (!kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)this.ctx.getCurrTabKey(), (CharSequence)KEY_TAB_KEY_ANALYSIS)) continue;
                    if (KEY_OPERATE_KEY_MARK_ANALYSIS.equalsIgnoreCase(operationColItem.getOperationKey())) {
                        operationColItem.setVisible(true);
                        continue;
                    }
                    if (!KEY_OPERATE_KEY_MARK.equalsIgnoreCase(operationColItem.getOperationKey()) && !KEY_OPERATE_KEY_ENTER_AND_MARK.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_MARK_SUMMARY});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_LAYER});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_EMPTY_FILTER});
    }

    private ListColumn createListColumn(String key, String caption, int colIndex, boolean allowOrder, boolean allowFilter, boolean isFixed, boolean isHyperlink) {
        ListColumn col = new ListColumn();
        this.setListColumnProperties(key, caption, colIndex, allowOrder, allowFilter, col, isFixed, isHyperlink);
        return col;
    }

    private DecimalListColumn createDecimalListColumn(String key, String caption, int colIndex, boolean allowOrder, boolean allowFilter, boolean isFixed, boolean isHyperlink) {
        DecimalListColumn col = new DecimalListColumn();
        col.setSummary(1);
        col.setZeroShow(true);
        this.setListColumnProperties(key, caption, colIndex, allowOrder, allowFilter, (ListColumn)col, isFixed, isHyperlink);
        return col;
    }

    private ListOperationColumn createListOperationColumn(String key, String caption, int colIndex) {
        LocaleString opColNameLocale = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u6807\u6ce8", (String)"ModelAnaOutlierDetailListPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]));
        if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)this.ctx.getCurrTabKey(), (CharSequence)KEY_TAB_KEY_ANALYSIS)) {
            opColNameLocale = new LocaleString(ResManager.loadKDString((String)"\u6807\u6ce8\u5206\u6790", (String)"ModelAnaOutlierDetailListPlugin_4", (String)"ai-ids-plugin", (Object[])new Object[0]));
        }
        ListOperationColumn col = new ListOperationColumn();
        col.setCaption(new LocaleString(caption));
        col.setListFieldKey(key);
        col.setKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setWidth(new LocaleString("8%"));
        col.setFixed(true);
        col.setName(opColNameLocale);
        ArrayList<OperationColItem> operationColItemList = new ArrayList<OperationColItem>();
        OperationColItem enterAndMarkItem = new OperationColItem();
        enterAndMarkItem.setOperationKey(KEY_OPERATE_KEY_ENTER_AND_MARK);
        enterAndMarkItem.setId(KEY_OPERATE_KEY_ENTER_AND_MARK);
        enterAndMarkItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b\u5e76\u6807\u6ce8", (String)"ModelAnaOutlierDetailListPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0])));
        operationColItemList.add(enterAndMarkItem);
        OperationColItem markColItem = new OperationColItem();
        markColItem.setOperationKey(KEY_OPERATE_KEY_MARK);
        markColItem.setId(KEY_OPERATE_KEY_MARK);
        markColItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u6807\u6ce8", (String)"ModelAnaOutlierDetailListPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0])));
        operationColItemList.add(markColItem);
        OperationColItem markAnalysisColItem = new OperationColItem();
        markAnalysisColItem.setOperationKey(KEY_OPERATE_KEY_MARK_ANALYSIS);
        markAnalysisColItem.setId(KEY_OPERATE_KEY_MARK_ANALYSIS);
        markAnalysisColItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b", (String)"ModelAnaOutlierDetailListPlugin_5", (String)"ai-ids-plugin", (Object[])new Object[0])));
        operationColItemList.add(markAnalysisColItem);
        col.setOperationColItems(operationColItemList);
        return col;
    }

    private void setListColumnProperties(String key, String caption, int colIndex, boolean allowOrder, boolean allowFilter, ListColumn col, boolean isFixed, boolean isHyperlink) {
        col.setCaption(new LocaleString(caption));
        col.setListFieldKey(key);
        col.setKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setWidth(new LocaleString("8%"));
        col.setBlankFieldCanOrderAndFilter(true);
        col.setColumnOrder(allowOrder);
        col.setColumnFilter(allowFilter);
        col.setFixed(isFixed);
        col.setHyperlink(isHyperlink);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)KEY_BTN_UN_ONLINE_OK, (CharSequence)callBackId)) {
            if (e.getResult() == MessageBoxResult.Cancel) {
                this.getView().close();
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)KEY_BTN_DEL_MARK_BILL) && e.getResult() == MessageBoxResult.Yes) {
            this.deleteBatchMarkBill();
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        switch (name) {
            case "loadDataMarkSummary": {
                this.getDataMarkSummaryData();
                break;
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getControl() != null) {
            return;
        }
        String key = e.getKey();
        String[] keySplit = key.split("_");
        if (keySplit.length > 1 && KEY_MULBD_PREFIX.equals(keySplit[0])) {
            String labelId = keySplit[1];
            IdsFilterItemEdit edit = new IdsFilterItemEdit();
            edit.setKey(key);
            edit.setView(this.getView());
            LabelItem item = new LabelItem();
            item.setId(labelId);
            item.setName(this.getCache().get(KEY_PREDIMENTTYPE_LABEL_NAME + labelId));
            edit.setLabel(item);
            edit.setSubServiceId(this.ctx.getSubServiceId());
            edit.setMultiSelect(!Objects.equals(labelId, this.getCache().get(KEY_PREDIMENTTYPE_LAST_LABEL_ID)));
            edit.setBizType(FilterItemBizTypeEnum.MODEL_ANA_OUTLIER.getId());
            ArrayList<String> labelIdList = new ArrayList<String>();
            ArrayList<String> allLabelIdList = new ArrayList<String>();
            DataMarkFilterItemQuery curFilterItemQuery = this.ctx.getCurFilterItemQuery();
            if (curFilterItemQuery != null) {
                List filterItemValuesDTOList = curFilterItemQuery.getFilterItemValuesDTOList();
                for (int i = 0; i < filterItemValuesDTOList.size(); ++i) {
                    FilterItemValuesDTO filterItemValuesDTO = (FilterItemValuesDTO)filterItemValuesDTOList.get(i);
                    allLabelIdList.add(filterItemValuesDTO.getLabelId());
                    if (i == filterItemValuesDTOList.size() - 1) continue;
                    labelIdList.add(filterItemValuesDTO.getLabelId());
                }
            }
            edit.setPrevLabelId(labelIdList);
            edit.setAllLabelId(allLabelIdList);
            edit.setPageCache(this.getCache());
            e.setControl((Control)edit);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        boolean isOnline = false;
        if (tenantDTO != null) {
            isOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        }
        if (!isOnline) {
            e.setCancel(true);
            Object source = e.getSource();
            if (!(source instanceof FormShowParameter)) {
                return;
            }
            FormShowParameter fsp = (FormShowParameter)source;
            String parentPageId = fsp.getParentPageId();
            IdsPageCache parentCache = new IdsPageCache(parentPageId);
            parentCache.put("is_online_" + fsp.getFormId(), "false");
            parentCache.saveChanges();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        RequestContext rc = RequestContext.get();
        String tabKey = tabSelectEvent.getTabKey();
        String[] tabKeyArr = tabKey.split("_");
        if (tabKeyArr != null && tabKeyArr.length > 1) {
            tabKey = tabKeyArr[1];
        }
        this.setOutlierTabFlexVisible(tabKey);
        this.ctx.setCurrTabKey(tabKey);
        this.resetQueryCondition();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tabKey, (CharSequence)KEY_TAB_KEY_PREDICT)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PANELAP_FILTER});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_EMPTY_FILTER});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TOOLBARAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_MARK_SUMMARY});
            BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_ITEM_DATA_MARK);
            billList.getView().setVisible(Boolean.TRUE, new String[]{"ismark"});
            this.refreshBillList(true, null);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tabKey, (CharSequence)KEY_TAB_KEY_HISTORY)) {
            Listbox listbox = (Listbox)this.getView().getControl(KEY_LIST_BOX);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_MARK_SUMMARY});
            ListboxItem currentMarkItem = new ListboxItem(KEY_LIST_BOX_ITEM_MARK_ENTRY, "\u5df2\u6807\u6ce8\u5355\u636e");
            ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>();
            itemlist.add(currentMarkItem);
            listbox.addItems(itemlist);
            listbox.activeItem(KEY_LIST_BOX_ITEM_MARK_ENTRY);
            this.loadOutlierBillEntry();
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)tabKey, (CharSequence)KEY_TAB_KEY_ANALYSIS)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PANELAP_FILTER});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_EMPTY_FILTER});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOOLBARAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_MARK_SUMMARY});
            boolean enableMarkError = this.commonService().getBooleanValue(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId(), SubParameterScopeEnum.MODEL_RESULT_PARAMETER.getKey(), AppConfigParameterEnum.ENABLE_MARK_ERROR.getId());
            this.getView().setVisible(Boolean.valueOf(enableMarkError), new String[]{KEY_FLEX_MARK_ERROR});
            BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_ITEM_DATA_MARK);
            billList.getView().setVisible(Boolean.FALSE, new String[]{"ismark"});
            this.showDataMarkSummary();
            this.refreshBillList(true, null);
        }
    }

    private void loadOutlierBillEntry() {
        FormTools.showLoading(this.getView(), this.getView().getPageId(), null);
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY_BILL);
        this.getCache().put(KEY_IS_INIT_PAGE_DATA, Boolean.TRUE.toString());
        RequestContext rc = RequestContext.get();
        HashMap metadata = new HashMap();
        JSONObject dataJo = this.dataOutlierAnaService().getOutlierBillEntry(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId(), null, null, 1, Integer.MAX_VALUE, KEY_LIST_BOX_ITEM_MARK_ENTRY, null, null);
        this.getView().updateControlMetadata(KEY_ENTRY_ENTITY_BILL, metadata);
        JSONObject resultJo = dataJo.getJSONObject("result");
        DynamicObject[] tagArr = BusinessDataServiceHelper.load((String)"ids_mark_outlier_tag", (String)"number,name", (QFilter[])new QFilter("type", "=", (Object)OutlierTagTypeEnum.BILL.getKey()).and("status", "=", (Object)YesNoEnum.YES.getKeyStr()).toArray());
        JSONArray fieldJa = dataJo.getJSONArray("fields");
        JSONArray recordJa = resultJo.getJSONArray("records");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY_BILL);
        if (recordJa != null && !recordJa.isEmpty()) {
            List controls = entryGrid.getControls();
            for (Control control : controls) {
                if (!(control instanceof ComboEdit)) continue;
                ComboEdit comboEdit = (ComboEdit)control;
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
                if (tagArr == null || !kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)comboEdit.getKey(), (CharSequence)"tag")) continue;
                for (int i = 0; i < tagArr.length; ++i) {
                    DynamicObject tagDo = tagArr[i];
                    String fnumber = tagDo.getString("number");
                    String fname = tagDo.getString("name");
                    LocaleString comboItemText = new LocaleString(fname);
                    ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(fnumber));
                    comboItemList.add(comboItem);
                    comboEdit.setEnable("s", true, i);
                }
                comboEdit.setComboItems(comboItemList);
            }
            int rowCount = recordJa.size();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY_BILL, rowCount);
            for (int i = 0; i < rowCount; ++i) {
                JSONObject jo = recordJa.getJSONObject(i);
                for (Object fieldO : fieldJa) {
                    JSONObject fieldJo = JSON.parseObject((String)JSON.toJSONString(fieldO));
                    String key = fieldJo.getString("id");
                    Object value = jo.get((Object)key);
                    this.getModel().setValue(key.toLowerCase(), value, rowIndex[i]);
                }
            }
            entryGrid.setSplitPage(true);
            entryGrid.setPageIndex(resultJo.getInteger("current").intValue());
            entryGrid.setPageRows(20);
        }
        Optional.ofNullable(entryGrid).ifPresent(e -> {
            e.setColumnProperty("ftagtype", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("tag", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("customtag", "isFixed", (Object)Boolean.TRUE);
        });
        this.getCache().put(KEY_IS_INIT_PAGE_DATA, Boolean.FALSE.toString());
        FormTools.hideLoading(this.getView(), this.getView().getPageId());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        RequestContext rc = RequestContext.get();
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_BTN_ITEM_BATCH_MARK) && returnData != null) {
            JSONObject saveMarkResultJo = JsonUtils.parseObj((Object)returnData);
            String fmarktype = saveMarkResultJo.getString("fmarktype");
            if (saveMarkResultJo.getBooleanValue("status") && kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)fmarktype, (CharSequence)MarkTypeEnum.ITEM.getId())) {
                String ftag = saveMarkResultJo.getString("ftag");
                String ftagtype = saveMarkResultJo.getString("ftagtype");
                String ftagname = saveMarkResultJo.getString("ftagname");
                String fcustomtag = saveMarkResultJo.getString("fcustomTag");
                Date fstartDate = saveMarkResultJo.getDate("fstartdate");
                Date fendDate = saveMarkResultJo.getDate("fenddate");
                BigDecimal fweight = saveMarkResultJo.getBigDecimal("fweight");
                List<String> fpredimentypeCodeList = this.getSelectedFpredimentypeCodeList();
                SaveDataMarkQuery saveDataMarkQuery = new SaveDataMarkQuery();
                saveDataMarkQuery.setFendDate(fendDate);
                saveDataMarkQuery.setFstartDate(fstartDate);
                saveDataMarkQuery.setFweight(fweight);
                saveDataMarkQuery.setFtag(ftag);
                saveDataMarkQuery.setFtagtype(ftagtype);
                saveDataMarkQuery.setFtagname(ftagname);
                saveDataMarkQuery.setFpredimentypeCodeList(fpredimentypeCodeList);
                saveDataMarkQuery.setFmarktype(fmarktype);
                saveDataMarkQuery.setFcustomTag(fcustomtag);
                saveDataMarkQuery.setFuserid(rc.getUid());
                saveDataMarkQuery.setFusername(rc.getUserName());
                saveDataMarkQuery.setSubServiceId(this.ctx.getSubServiceId());
                BaseResult baseResult = this.dataMarkService().saveDataMark(Long.valueOf(rc.getOrgId()), saveDataMarkQuery);
                if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                    String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.SUCCESS);
                    this.refreshBillList(false, this.ctx.getCurFilterItemQuery());
                    for (String code : fpredimentypeCodeList) {
                        LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u6807\u6ce8-\u6210\u529f", fmarktype, code));
                    }
                } else {
                    ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), baseResult.getDescriptionCn(), BaseResult.FAIL);
                }
            }
        }
    }
}

