/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.constants.DataModeConstants;
import kd.ai.ids.core.entity.model.DataModeLevel;
import kd.ai.ids.core.entity.model.DataModeTree;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IDataModelService;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.bos.context.RequestContext;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class DataModeFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(DataModeFormPlugin.class);
    private IdsPageCache cache;
    private IDataModelService service = (IDataModelService)Services.get(IDataModelService.class);
    private static DataModeTree tree = new DataModeTree();
    private static final String LINEAGE_GRAPH_CACHE = "lineage_graph_cache";
    private static final String CUSTOM_CONTROL_BLOOD_RELATION = "ai_ids_lineage_graph";
    private static final String CUSTOM_EVENT_SHOW_TABLE = "showTblInfo";
    private static final String CUSTOM_EVENT_HIDDEN_TABLE = "hiddenTblInfo";
    private static final String CONTROL_TABLE_ENTRY_GRID = "table_grid";
    private static final String CONTROL_LABEL_TABLE_NAME = "table_name";
    private static final String CONTROL_LABEL_TABLE_COMMENT = "table_desc";
    private static final String CONTROL_LABEL_TABLE_BASE_INFO = "base_info";
    private static final String CONTROL_IMAGE = "imageap";
    private static final String PANEL_TABLE_INFO = "table_info";
    private static final String CACHE_CURRENT_TABLE = "current_select_table";
    private static final String CACHE_SUBSERVICE_ID = "subserviceid";
    private static final String CURRENT_TABLE_INFO_IS_SHOW = "current_table_info_is_show";
    private static final String TREE_CONTROL_KEY = "tabletree";
    private static final String TREE_SEARCH_CONTROL = "tree_search";
    private static final String TREE_ROOT_NODE = "lineage";

    public IdsPageCache getCache() {
        return this.cache;
    }

    public void initialize() {
        super.initialize();
        if (this.cache == null) {
            this.cache = new IdsPageCache(this.getView().getPageId());
        }
    }

    public void destory() {
        super.destory();
        if (this.cache != null) {
            this.cache.saveChanges();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        if (this.cache != null) {
            this.cache.release();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Image image = (Image)this.getControl(CONTROL_IMAGE);
        image.addClickListener((ClickListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_CONTROL_KEY);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(TREE_SEARCH_CONTROL);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getSubserviceId();
        Image image = (Image)this.getControl(CONTROL_IMAGE);
        image.setUrl("kingdee/ai-ids/modelanalysic/img/right_14_15.png");
        this.initLineageGraph();
        this.getCache().put(CURRENT_TABLE_INFO_IS_SHOW, String.valueOf(Boolean.FALSE));
        this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_TABLE_INFO});
    }

    private void getSubserviceId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String appIdentifier = (String)fsp.getCustomParam("appIdentifier");
        this.getCache().put("appIdentifier", appIdentifier);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String dataappId = ((IDataappService)Services.get(IDataappService.class)).getAppIdByPlatformCode(appIdentifier);
        String subServiceId = ((IDataappService)Services.get(IDataappService.class)).getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), dataappId);
        this.getCache().put(CACHE_SUBSERVICE_ID, subServiceId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CONTROL_IMAGE)) {
            String status = this.getCache().get(CURRENT_TABLE_INFO_IS_SHOW);
            this.getView().setVisible(Boolean.valueOf(!Boolean.parseBoolean(status)), new String[]{PANEL_TABLE_INFO});
            this.getCache().put(CURRENT_TABLE_INFO_IS_SHOW, String.valueOf(!Boolean.parseBoolean(status)));
        }
    }

    private void refreshTableInfo(String tblName) {
        this.getCache().put(CURRENT_TABLE_INFO_IS_SHOW, String.valueOf(Boolean.TRUE));
        this.getCache().put(CACHE_CURRENT_TABLE, tblName);
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_TABLE_INFO});
        this.dynamicShowTableFieldsRow(tblName);
    }

    private void dynamicShowTableFieldsRow(String tableName) {
        if (!StringUtils.isEmpty((CharSequence)tableName)) {
            tableName = tableName.replaceAll("\n", "");
            String subserviceId = this.getCache().get(CACHE_SUBSERVICE_ID);
            JSONObject data = this.service.getLineageTable(subserviceId, null, tableName);
            if (data != null) {
                String tblName = data.getString("tblName");
                String tblComment = data.getString("tblComment");
                String tblType = data.getString("tblType");
                String nodeType = data.getString("nodeType");
                Label tblNameLabel = (Label)this.getControl(CONTROL_LABEL_TABLE_NAME);
                Label tblCommentLabel = (Label)this.getControl(CONTROL_LABEL_TABLE_COMMENT);
                Label tblBasicInfoLabel = (Label)this.getControl(CONTROL_LABEL_TABLE_BASE_INFO);
                tblNameLabel.setText(tblName);
                tblCommentLabel.setText(tblComment);
                tblBasicInfoLabel.setText(this.getTblInfo(tblType, nodeType));
                JSONArray tblColumns = data.getJSONArray("tblColumns");
                if (tblColumns != null && !tblColumns.isEmpty()) {
                    JSONArray list = new JSONArray(tblColumns.size());
                    for (int i = 0; i < tblColumns.size(); ++i) {
                        JSONObject tbl = tblColumns.getJSONObject(i);
                        String name = tbl.getString("name");
                        String dataType = tbl.getString("data_type");
                        String description = tbl.getString("description");
                        JSONObject row = new JSONObject();
                        row.put("field_name", (Object)name);
                        row.put("field_type", (Object)dataType);
                        row.put("field_desc", (Object)description);
                        list.add((Object)row);
                    }
                    this.getModel().deleteEntryData(CONTROL_TABLE_ENTRY_GRID);
                    int count = list.size();
                    if (count == 0) {
                        return;
                    }
                    int[] rowIndex = this.getModel().batchCreateNewEntryRow(CONTROL_TABLE_ENTRY_GRID, count);
                    for (int i = 0; i < count; ++i) {
                        JSONObject field = list.getJSONObject(i);
                        String fieldName = field.getString("field_name");
                        String fieldType = field.getString("field_type");
                        String fieldDesc = field.getString("field_desc");
                        this.getModel().setValue("field_name", (Object)fieldName, rowIndex[i]);
                        this.getModel().setValue("field_type", (Object)fieldType, rowIndex[i]);
                        this.getModel().setValue("field_desc", (Object)fieldDesc, rowIndex[i]);
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"field_name"});
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"field_type"});
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"field_desc"});
                    }
                }
            }
        }
    }

    private void initLineageGraph() {
        JSONArray data = this.loadingLineageGraphData();
        this.showLineageGraph(data == null ? new JSONArray() : data, null);
        this.genDataModeTree(data);
        this.showLineageTree(tree);
    }

    private JSONArray loadingLineageGraphData() {
        String subserviceId = this.getCache().get(CACHE_SUBSERVICE_ID);
        JSONArray data = this.service.getLineageGraph(subserviceId);
        this.getCache().put(LINEAGE_GRAPH_CACHE, JSONObject.toJSONString((Object)data));
        return data;
    }

    private DataModeConstants.DwLevel parseLevel(JSONArray fqn) {
        String level;
        if (fqn.size() >= 2 && DataModeConstants.DwLevel.contains((String)(level = fqn.getString(1)))) {
            return DataModeConstants.DwLevel.valueOf((String)level);
        }
        List items = fqn.toJavaList(String.class);
        if (items.contains(DataModeConstants.DwLevel.ods.getLevel())) {
            return DataModeConstants.DwLevel.ods;
        }
        if (items.contains(DataModeConstants.DwLevel.dwd.getLevel())) {
            return DataModeConstants.DwLevel.dwd;
        }
        if (items.contains(DataModeConstants.DwLevel.dws.getLevel())) {
            return DataModeConstants.DwLevel.dws;
        }
        if (items.contains(DataModeConstants.DwLevel.ads.getLevel())) {
            return DataModeConstants.DwLevel.ads;
        }
        return DataModeConstants.DwLevel.other;
    }

    private DataModeTree genDataModeTree(JSONArray data) {
        if (tree != null) {
            tree.getChildren().clear();
            if (data != null && !data.isEmpty()) {
                List dirs = tree.getChildren();
                for (int i = 0; i < data.size(); ++i) {
                    JSONObject item = data.getJSONObject(i);
                    JSONArray fqn = item.getJSONArray("fqn");
                    String tblName = item.getString("tblName");
                    String tblType = item.getString("tblType");
                    DataModeConstants.DwLevel level = DataModeConstants.DwLevel.other;
                    if (fqn != null && !fqn.isEmpty()) {
                        level = this.parseLevel(fqn);
                    }
                    DataModeLevel table = new DataModeLevel("TABLE_", tblName);
                    table.setTblType(tblType);
                    table.setDwLevel(level);
                    DataModeLevel existDir = tree.findGroup(level.getLevel());
                    if (existDir == null) {
                        DataModeLevel dir = new DataModeLevel("DIR_", level.getLevel());
                        dir.setDwLevel(level);
                        dir.getChildren().add(table);
                        dirs.add(dir);
                        continue;
                    }
                    existDir.getChildren().add(table);
                }
                dirs.sort(new Comparator<DataModeLevel>(){

                    @Override
                    public int compare(DataModeLevel o1, DataModeLevel o2) {
                        return o1.getDwLevel().getIndex() - o2.getDwLevel().getIndex();
                    }
                });
                tree.setChildren(dirs);
            }
        }
        return tree;
    }

    private void showLineageTree(DataModeTree tree) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_CONTROL_KEY);
        if (treeView != null) {
            treeView.deleteAllNodes();
            treeView.setMulti(Boolean.FALSE.booleanValue());
            String rootNodeId = TREE_ROOT_NODE;
            TreeNode root = new TreeNode("", rootNodeId, "\u8840\u7f18\u5173\u7cfb");
            treeView.setRootVisible(Boolean.FALSE.booleanValue());
            treeView.addNode(root);
            treeView.expand(TREE_ROOT_NODE);
            treeView.setDraggable(Boolean.FALSE.booleanValue());
            if (tree != null) {
                List groups = tree.getChildren();
                this.addTreeNodes(root, rootNodeId, groups);
            }
        }
    }

    private void addTreeNodes(TreeNode root, String rootNodeId, List<DataModeLevel> groups) {
        for (DataModeLevel group : groups) {
            String nodeId = group.getNodeId();
            String nodeName = group.getNodeName();
            String nodeType = group.getNodeType();
            String showName = "";
            showName = StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"DIR_") ? (StringUtils.equalsIgnoreCase((CharSequence)nodeName, (CharSequence)DataModeConstants.DwLevel.other.getLevel()) ? String.format("%s", DataModeConstants.DwLevel.parseName((String)nodeName)) : String.format("%s\uff08%s\uff09", DataModeConstants.DwLevel.parseName((String)nodeName), nodeName)) : String.format("%s", nodeName);
            TreeNode tNode = new TreeNode(rootNodeId, nodeId, showName);
            JSONObject data = new JSONObject();
            if (StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"DIR_")) {
                data.put("nodeType", (Object)"DIR_");
                data.put("nodeName", (Object)nodeName);
                data.put("nodeId", (Object)nodeId);
                tNode.setData((Object)data);
            } else {
                tNode.setIcon("kdfont kdfont-geshibiaoge2");
                data.put("nodeType", (Object)"TABLE_");
                data.put("nodeName", (Object)nodeName);
                data.put("nodeId", (Object)nodeId);
                tNode.setData((Object)data);
            }
            root.addChild(tNode);
            List tables = group.getChildren();
            if (tables.isEmpty()) continue;
            tables.sort(new Comparator<DataModeLevel>(){

                @Override
                public int compare(DataModeLevel o1, DataModeLevel o2) {
                    return o1.getNodeName().compareTo(o2.getNodeName());
                }
            });
            this.addTreeNodes(tNode, nodeId, tables);
        }
    }

    private String getTblInfo(String tblType, String nodeType) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"source", (CharSequence)tblType)) {
            return "\u6e90\u8868";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"model", (CharSequence)tblType)) {
            return String.format("%s-%s", "\u4e1a\u52a1\u8868", nodeType);
        }
        return tblType;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        if (CUSTOM_CONTROL_BLOOD_RELATION.equals(controlKey)) {
            if (CUSTOM_EVENT_SHOW_TABLE.equals(eventName)) {
                JSONObject info;
                String args = e.getEventArgs();
                if (!StringUtils.isEmpty((CharSequence)args) && (info = JSONObject.parseObject((String)args)) != null) {
                    String tblName = info.getString("tblName");
                    this.refreshTableInfo(tblName);
                }
            } else if (CUSTOM_EVENT_HIDDEN_TABLE.equals(eventName)) {
                this.getCache().put(CURRENT_TABLE_INFO_IS_SHOW, String.valueOf(Boolean.FALSE));
                this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_TABLE_INFO});
            }
        }
    }

    private void showLineageGraph(JSONArray tables, String selectedTable) {
        JSONObject graphData = new JSONObject();
        graphData.put("graphData", (Object)tables);
        graphData.put("selectedTable", (Object)selectedTable);
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("chartType", "ids_lineage_graph");
        customData.put("containerId", CUSTOM_CONTROL_BLOOD_RELATION);
        customData.put("timestamp", new Date().getTime());
        customData.put("data", graphData);
        customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        customData.put("pageId", this.getView().getPageId());
        CustomControl customControl = (CustomControl)this.getControl(CUSTOM_CONTROL_BLOOD_RELATION);
        customControl.setData(customData);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.loadingLineageGraphData();
        JSONArray data = this.getCache().getAsArray(LINEAGE_GRAPH_CACHE);
        this.genDataModeTree(data);
        String text = searchEnterEvent.getText();
        if (StringUtils.isEmpty((CharSequence)text)) {
            this.showLineageTree(tree);
        } else {
            List<DataModeLevel> groups = this.searchGroups(text);
            if (!groups.isEmpty()) {
                tree.getChildren().clear();
                tree.setChildren(groups);
                this.showLineageTree(tree);
                this.expandGroups(groups);
            } else {
                tree.getChildren().clear();
                this.showLineageTree(tree);
            }
        }
    }

    public void expandGroups(List<DataModeLevel> groups) {
        final TreeView treeView = (TreeView)this.getView().getControl(TREE_CONTROL_KEY);
        groups.stream().forEach(new Consumer<DataModeLevel>(){

            @Override
            public void accept(DataModeLevel dataModeLevel) {
                String nodeId = dataModeLevel.getNodeId();
                treeView.expand(nodeId);
            }
        });
    }

    public List<DataModeLevel> searchGroups(String text) {
        if (tree != null) {
            List groups = tree.getChildren();
            ArrayList<DataModeLevel> newGroups = new ArrayList<DataModeLevel>();
            if (groups != null && !groups.isEmpty()) {
                for (DataModeLevel group : groups) {
                    List<DataModeLevel> res = this.searchTableByGroup(group.getChildren(), text);
                    if (res.isEmpty()) continue;
                    DataModeLevel newGroup = this.copyGroup(group);
                    newGroup.setChildren(res);
                    newGroups.add(newGroup);
                }
            }
            return newGroups;
        }
        return new ArrayList<DataModeLevel>();
    }

    public DataModeLevel copyGroup(DataModeLevel group) {
        DataModeLevel newGroup = new DataModeLevel();
        newGroup.setDwLevel(group.getDwLevel());
        newGroup.setTblType(group.getTblType());
        newGroup.setNodeId(group.getNodeId());
        newGroup.setNodeName(group.getNodeName());
        newGroup.setNodeType(group.getNodeType());
        return newGroup;
    }

    public List<DataModeLevel> searchTableByGroup(List<DataModeLevel> tables, final String text) {
        if (tables != null && !tables.isEmpty()) {
            List<DataModeLevel> res = tables.stream().filter(new Predicate<DataModeLevel>(){

                @Override
                public boolean test(DataModeLevel dataModeLevel) {
                    String nodeType = dataModeLevel.getNodeType();
                    String tableName = dataModeLevel.getNodeName();
                    return StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"TABLE_") && tableName.indexOf(text) != -1;
                }
            }).collect(Collectors.toList());
            return res;
        }
        return new ArrayList<DataModeLevel>();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object obj = evt.getNodeId();
        String nodeId = (String)obj;
        logger.info("click node id : {}", (Object)nodeId);
        if (nodeId.startsWith("TABLE_")) {
            String tblName = nodeId.substring("TABLE_".length());
            logger.info("show tbl : {}", (Object)tblName);
            this.refreshTableInfo(tblName);
            JSONArray tables = this.getCache().getAsArray(LINEAGE_GRAPH_CACHE);
            this.showLineageGraph(tables == null ? new JSONArray() : tables, tblName);
        } else {
            logger.info("directory click ,id : {}", (Object)nodeId);
        }
    }
}

