/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.ids.core.cache.SessionCache;
import kd.ai.ids.plugin.control.FilterItemProvider;
import kd.ai.ids.plugin.control.IdsF7BillList;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.VirtualEntityTools;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.list.F7SelectedList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.util.StringUtils;

public class FilterF7FormPlugin
extends BaseFormPlugin
implements CreateListColumnsListener {
    private static final String KEY_BILL_LIST = "billlistap";
    private static final String KEY_SEARCHAP = "searchap";
    private static final String KEY_SEARCH_TEXT = "searchText";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_GRIDVIEW = "gridview";
    private static final String KEY_PARAM_MULTI_SELECT = "multiSelect";
    private static final String KEY_TITLE = "title";
    private static final String KEY_PARAM_PROVIDER = "provider";
    private static final String KEY_FLEXPANELAP_1 = "flexpanelap1";
    private MainEntityType entityType = null;
    private FilterItemProvider filterItemProvider;

    private MainEntityType getEntityType() {
        if (this.entityType == null) {
            this.entityType = VirtualEntityTools.createEntityType();
        }
        return this.entityType;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initFilterItemProvider();
        this.getView().addCustomControls(new String[]{KEY_BILL_LIST});
        IdsF7BillList billList = (IdsF7BillList)this.getControl(KEY_BILL_LIST);
        billList.getContext().setEntryEntityDtos(EntityTypeUtil.getEntryEntities((EntityType)this.getEntityType()));
        billList.getContext().setBillListEntityId(billList.getEntityId());
        billList.setListUserOption(new ListUserOption());
        billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new BillListDataProvider()));
        billList.getContext().setLookup(true);
        Container container = (Container)this.getControl(KEY_FLEXPANELAP_1);
        for (int i = 0; i < container.getItems().size(); ++i) {
            if (!KEY_BILL_LIST.equals(((Control)container.getItems().get(i)).getKey())) continue;
            container.getItems().set(i, billList);
            break;
        }
        billList.addCreateListColumnsListener(this);
        if (this.isNotMultiSelect()) {
            billList.setMulti(false);
        }
    }

    private boolean isNotMultiSelect() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String multiSelect = (String)fsp.getCustomParam(KEY_PARAM_MULTI_SELECT);
        String expect = "false";
        return expect.equals(multiSelect);
    }

    private void initFilterItemProvider() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String providerJson = (String)fsp.getCustomParam(KEY_PARAM_PROVIDER);
        if (StringUtils.isNotEmpty((String)providerJson)) {
            this.filterItemProvider = FilterItemProvider.fromJsonString(providerJson);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String labelName = this.filterItemProvider.getLabel().getName();
        Label title = (Label)this.getControl(KEY_TITLE);
        title.setText(labelName);
        if (this.isNotMultiSelect()) {
            IdsF7BillList billList = (IdsF7BillList)this.getControl(KEY_BILL_LIST);
            this.getView().setVisible(Boolean.FALSE, new String[]{billList.getContext().getF7SeletedControlId()});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List<String> selectedIdList = this.filterItemProvider.getSelectedIdList();
        if (selectedIdList != null && !selectedIdList.isEmpty()) {
            ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
            for (String pkId : selectedIdList) {
                if (pkId == null) continue;
                ListSelectedRow listSelectedRow = new ListSelectedRow((Object)pkId, Boolean.TRUE);
                listSelectedRowCollection.add((Object)listSelectedRow);
            }
            IdsF7BillList billList = (IdsF7BillList)this.getControl(KEY_BILL_LIST);
            billList.putSelectedRows(listSelectedRowCollection);
        }
    }

    public void afterBindData(EventObject e) {
        IdsF7BillList billList;
        F7SelectedList f7SelectedList;
        super.afterBindData(e);
        if (!this.isNotMultiSelect() && (f7SelectedList = (F7SelectedList)this.getControl((billList = (IdsF7BillList)this.getControl(KEY_BILL_LIST)).getContext().getF7SeletedControlId())) != null) {
            f7SelectedList.addItems(this.getF7SelectedItems(billList.getSelectedRows()));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IdsF7BillList billList = (IdsF7BillList)this.getControl(KEY_BILL_LIST);
        if (!this.isNotMultiSelect()) {
            this.addF7SelectedListener(billList);
        }
        this.addClickListeners(new String[]{KEY_BTN_OK});
        Search search = (Search)this.getControl(KEY_SEARCHAP);
        search.addEnterListener(searchEnterEvent -> {
            this.getCache().put(KEY_SEARCH_TEXT, searchEnterEvent.getText());
            billList.bindData(null);
        });
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        String parentViewKey = KEY_GRIDVIEW;
        columns.add(this.createListColumn("number", "\u7f16\u7801", columns.size(), parentViewKey));
        columns.add(this.createListColumn("name", "\u540d\u79f0", columns.size(), parentViewKey));
    }

    private ListColumn createListColumn(String key, String caption, int colIndex, String parentViewKey) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setListFieldKey(key);
        col.setKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setParentViewKey(parentViewKey);
        return col;
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (KEY_BILL_LIST.equals(key) && !(e.getControl() instanceof IdsF7BillList)) {
            IdsF7BillList billList = new IdsF7BillList();
            billList.setKey(key);
            billList.setView(this.getView());
            MainEntityType entityType = this.getEntityType();
            billList.setEntityId(entityType.getName());
            billList.setEntityType((EntityType)entityType);
            billList.getItems().addAll(((Container)e.getControl()).getItems());
            billList.setFilterItemProvider(this.filterItemProvider);
            e.setControl((Control)billList);
        }
    }

    private List<ValueTextItem> getF7SelectedItems(ListSelectedRowCollection listSelectedRowCollection) {
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>();
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            String id = String.valueOf(listSelectedRow.getPrimaryKeyValue());
            DynamicObject record = this.filterItemProvider.getDataById(id);
            if (record == null) continue;
            valueTextItems.add(new ValueTextItem(id, record.getString("name")));
        }
        return valueTextItems;
    }

    void addF7SelectedListener(IdsF7BillList billList) {
        final F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(billList.getContext().getF7SeletedControlId());
        if (f7SelectedList != null) {
            billList.addListRowClickListener(new ListRowClickListener(){

                public void listRowClick(ListRowClickEvent listRowClickEvent) {
                    f7SelectedList.addItems(FilterF7FormPlugin.this.getF7SelectedItems(listRowClickEvent.getListSelectedRowCollection()));
                }
            });
            f7SelectedList.addF7SelectedListRemoveListener(f7SelectedListRemoveEvent -> {
                billList.restoreSelection(f7SelectedListRemoveEvent.getParam().toString());
                billList.getListCache().savePageCache();
            });
            f7SelectedList.addF7SelectedListRemoveAllListener(f7SelectedListRemoveEvent -> {
                billList.clearSelection();
                billList.getListCache().savePageCache();
            });
            f7SelectedList.addF7SelectedListSortListener(f7SelectedListSortEvent -> {
                ListSelectedRowCollection listSelectedRowCollection = billList.sortListSelectedRowsByKeys(f7SelectedListSortEvent.getSortItems());
                f7SelectedList.addItems(this.getF7SelectedItems(listSelectedRowCollection));
                billList.getListCache().savePageCache();
            });
            billList.addClearSelectionListener(event -> f7SelectedList.removeAllItemsByClient());
        }
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String btnKey = ctl.getKey();
        if (KEY_BTN_OK.equals(btnKey)) {
            this.resetSubDimlevel(this.filterItemProvider.getLabel().getId());
            IdsF7BillList billList = (IdsF7BillList)this.getControl(KEY_BILL_LIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            for (ListSelectedRow listSelectedRow : selectedRows) {
                String id = String.valueOf(listSelectedRow.getPrimaryKeyValue());
                DynamicObject record = this.filterItemProvider.getDataById(id);
                if (record == null) continue;
                listSelectedRow.setBillNo(id);
                listSelectedRow.setName(record.getString("name"));
                listSelectedRow.setNumber(record.getString("number"));
            }
            if (selectedRows.isEmpty()) {
                selectedRows.setClearFlag(true);
            }
            this.getView().returnDataToParent((Object)selectedRows);
            this.getView().close();
        }
    }

    private void resetSubDimlevel(String currDimlevel) {
        List<String> allLabelIdList = this.filterItemProvider.getAllLabelId();
        if (allLabelIdList != null) {
            int index = allLabelIdList.indexOf(currDimlevel);
            for (int i = 0; i < allLabelIdList.size(); ++i) {
                String dimlevel = allLabelIdList.get(i);
                if (i <= index) continue;
                SessionCache.get().remove("ListData_" + dimlevel);
                this.getCache().remove("SelectedList_" + dimlevel);
            }
        }
    }

    @Override
    public void destory() {
        super.destory();
        this.filterItemProvider.saveChanges();
    }

    public class BillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            String search = FilterF7FormPlugin.this.getCache().get(FilterF7FormPlugin.KEY_SEARCH_TEXT);
            QueryResult queryResult = FilterF7FormPlugin.this.filterItemProvider.getData(start, limit, search);
            this.getQueryResult().setCollection(queryResult.getCollection());
            this.getQueryResult().setDataCount(queryResult.getDataCount());
            return queryResult.getCollection();
        }
    }
}

