/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.ai.ids.core.enumtype.AppConfigParameterEnum;
import kd.ai.ids.core.enumtype.MarkTypeEnum;
import kd.ai.ids.core.enumtype.SubParameterScopeEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.ShowTipsTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MarkOutlierTagDlgFormPlugin
extends BaseFormPlugin {
    private static final String KEY_FLEX_TAG = "flexpanelaptag";
    private static final String KEY_RADIOGROUP_TAG = "radiogrouptag";
    private static final String KEY_DATE_RANGE = "daterange";
    private static final String KEY_CUSTOM_TAG = "customtag";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_TAG_TYPE_COMBO = "tagtype";
    private static final String KEY_FWEIGHT = "fweight";
    private static final String KEY_SAVE_MARK_RESULT = "saveMarkResult";
    private static final String KEY_EXIST_TAG_KEY_LIST = "existTagKeyList";
    private static final String TAGTYPE_ITEM_LIST = "[{\"id\":\"finvorgid\",\"name\":\"\u5e93\u5b58\u7ec4\u7ec7\u6807\u7b7e\"},{\"id\":\"fwarehouseid\",\"name\":\"\u4ed3\u5e93\u6807\u7b7e\"},{\"id\":\"fcustid\",\"name\":\"\u5ba2\u6237\u6807\u7b7e\"},{\"id\":\"fmaterialid\",\"name\":\"\u7269\u6599\u6807\u7b7e\"},{\"id\":\"fother\",\"name\":\"\u5176\u4ed6\"}]";
    private static final String TAGTYPE_BILL_LIST = "[{\"id\":\"bill\",\"name\":\"\u5355\u636e\u6807\u7b7e\"}]";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_TAG_TYPE_COMBO)) {
            ChangeData[] changeData = e.getChangeSet();
            String ftagtype = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            DynamicObject[] tagDoArr = BusinessDataServiceHelper.load((String)"ids_mark_outlier_tag", (String)"number,name", (QFilter[])new QFilter("status", "=", (Object)YesNoEnum.YES.getKeyStr()).and("status", "=", (Object)YesNoEnum.YES.getKeyStr()).and("type", "=", (Object)ftagtype).toArray());
            Container flex = (Container)this.getControl(KEY_FLEX_TAG);
            List existTagKeyList = this.getCache().getAsList(KEY_EXIST_TAG_KEY_LIST, String.class);
            if (existTagKeyList != null && !existTagKeyList.isEmpty()) {
                flex.deleteControls(existTagKeyList.toArray(new String[existTagKeyList.size()]));
            }
            ArrayList<String> tagKeyList = new ArrayList<String>();
            if (tagDoArr != null && tagDoArr.length > 0) {
                for (DynamicObject tagDo : tagDoArr) {
                    String key = tagDo.getString("number");
                    String tagName = tagDo.getString("name");
                    tagKeyList.add(key);
                    Control control = this.getView().getControl(key);
                    if (control != null) continue;
                    FieldAp fieldAp = this.createFieldAp(key, new LocaleString(tagName));
                    fieldAp.setHeight(new LocaleString("18px"));
                    flex.addControls(Collections.singletonList(fieldAp.createControl()));
                }
            }
            this.getCache().put(KEY_EXIST_TAG_KEY_LIST, tagKeyList);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTNOK, (CharSequence)evtKey)) {
            String fmarktype = this.getCache().get("fmarktype");
            String ftag = (String)this.getModel().getValue(KEY_RADIOGROUP_TAG);
            DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATE_RANGE);
            String keyStartDate = dateRangeEdit.getStartDateFieldKey();
            String keyEndDate = dateRangeEdit.getEndDateFieldKey();
            Date startDate = (Date)this.getModel().getValue(keyStartDate);
            Date endDate = (Date)this.getModel().getValue(keyEndDate);
            String customtag = (String)this.getModel().getValue(KEY_CUSTOM_TAG);
            if (StringUtils.isEmpty((CharSequence)ftag) && StringUtils.isEmpty((CharSequence)customtag)) {
                this.getView().showTipNotification("\u6807\u7b7e\u4e0e\u5907\u6ce8\u81f3\u5c11\u9009\u62e9\u4e00\u9879\u8fdb\u884c\u586b\u5199");
                return;
            }
            String ftagname = null;
            String ftagtype = null;
            if (StringUtils.isNotEmpty((CharSequence)ftag)) {
                DynamicObject tagDo = BusinessDataServiceHelper.loadSingle((String)"ids_mark_outlier_tag", (String)"type,name,status,allowtimeconfig", (QFilter[])new QFilter("number", "=", (Object)ftag).toArray());
                if (tagDo == null) {
                    String msg = ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u3010%s\u3011\u5df2\u88ab\u5220\u9664\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"MarkOutlierTagDlgFormPlugin_4", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), String.format(msg, ftag), BaseResult.FAIL);
                    return;
                }
                if (!tagDo.getBoolean("status")) {
                    String msg = ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u3010%s\u3011\u5df2\u88ab\u7981\u7528\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"MarkOutlierTagDlgFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), String.format(msg, ftag), BaseResult.FAIL);
                    return;
                }
                ftagname = tagDo.getString("name");
                ftagtype = tagDo.getString("type");
            }
            if (!(StringUtils.equalsIgnoreCase((CharSequence)fmarktype, (CharSequence)MarkTypeEnum.BILL.getId()) || startDate != null && endDate != null)) {
                this.getView().showTipNotification("\u5f71\u54cd\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            String fstartdate = null;
            if (startDate != null) {
                fstartdate = KDDateFormatUtils.getDateFormat().format(startDate);
            }
            String fenddate = null;
            if (endDate != null) {
                if (endDate.after(new Date())) {
                    String msg = ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5f53\u524d\u65e5\u671f", (String)"MarkOutlierTagDlgFormPlugin_5", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.FAIL);
                    return;
                }
                fenddate = KDDateFormatUtils.getDateFormat().format(endDate);
            }
            JSONObject saveMarkResult = new JSONObject();
            saveMarkResult.put("ftag", (Object)ftag);
            saveMarkResult.put("fcustomTag", (Object)customtag);
            saveMarkResult.put("fstartdate", (Object)fstartdate);
            saveMarkResult.put("fenddate", (Object)fenddate);
            saveMarkResult.put("status", (Object)Boolean.TRUE);
            saveMarkResult.put("fmarktype", (Object)fmarktype);
            saveMarkResult.put("ftagtype", this.getModel().getValue(KEY_TAG_TYPE_COMBO));
            saveMarkResult.put(KEY_FWEIGHT, this.getModel().getValue(KEY_FWEIGHT));
            saveMarkResult.put("ftagname", (Object)ftagname);
            String saveResult = JSON.toJSONString((Object)saveMarkResult);
            this.getCache().put(KEY_SAVE_MARK_RESULT, saveResult);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RequestContext rc = RequestContext.get();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String subServiceId = (String)formShowParameter.getCustomParam("subServiceId");
        boolean enableMarkFweight = this.commonService().getBooleanValue(Long.valueOf(rc.getOrgId()), subServiceId, SubParameterScopeEnum.MODEL_RESULT_PARAMETER.getKey(), AppConfigParameterEnum.ENABLE_MARK_WEIGHT.getId());
        if (!enableMarkFweight) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FWEIGHT});
        }
        String fmarktype = (String)formShowParameter.getCustomParam("fmarktype");
        this.getCache().put("fmarktype", fmarktype);
        String outlierTagType = this.initTagTypeCombo(fmarktype);
        if (StringUtils.equalsIgnoreCase((CharSequence)fmarktype, (CharSequence)MarkTypeEnum.BILL.getId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_TAG_TYPE_COMBO});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FWEIGHT});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DATE_RANGE});
        }
        int isMark = formShowParameter.getCustomParam("isMark") != null ? ((Integer)formShowParameter.getCustomParam("isMark")).intValue() : YesNoEnum.NO.getKey();
        String ftag = (String)formShowParameter.getCustomParam("ftag");
        String fcustomTag = (String)formShowParameter.getCustomParam("fcustomTag");
        ftag = StrUtils.trimSplitChar((String)ftag);
        fcustomTag = StrUtils.trimSplitChar((String)fcustomTag);
        DynamicObject[] tagDoArr = BusinessDataServiceHelper.load((String)"ids_mark_outlier_tag", (String)"number,name", (QFilter[])new QFilter("status", "=", (Object)YesNoEnum.YES.getKeyStr()).and("status", "=", (Object)YesNoEnum.YES.getKeyStr()).and("type", "=", (Object)outlierTagType).toArray());
        ArrayList<String> tagKeyList = new ArrayList<String>();
        if (tagDoArr != null && tagDoArr.length > 0) {
            for (DynamicObject tagDo : tagDoArr) {
                String key = tagDo.getString("number");
                String name = tagDo.getString("name");
                tagKeyList.add(key);
                Container flex = (Container)this.getControl(KEY_FLEX_TAG);
                Control control = this.getView().getControl(key);
                if (control != null) continue;
                FieldAp fieldAp = this.createFieldAp(key, new LocaleString(name));
                fieldAp.setHeight(new LocaleString("18px"));
                flex.addControls(Collections.singletonList(fieldAp.createControl()));
            }
            if (isMark == YesNoEnum.YES.getKey()) {
                if (StringUtils.isNotEmpty((CharSequence)ftag)) {
                    this.getModel().setValue(KEY_RADIOGROUP_TAG, (Object)ftag);
                    DynamicObject tagDo = BusinessDataServiceHelper.loadSingle((String)"ids_mark_outlier_tag", (String)"allowtimeconfig,status", (QFilter[])new QFilter("number", "=", (Object)ftag).toArray());
                    if (tagDo != null) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)tagDo.getString("status"), (CharSequence)YesNoEnum.NO.getKeyStr())) {
                            String tip = ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u3010%s\u3011\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u6b63\u5e38\u56de\u663e", (String)"MarkOutlierTagDlgFormPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]);
                            this.getView().showTipNotification(String.format(tip, ftag));
                        }
                    } else {
                        String tip = ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u3010%s\u3011\u5df2\u88ab\u5220\u9664\uff0c\u4e0d\u80fd\u6b63\u5e38\u56de\u663e", (String)"MarkOutlierTagDlgFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(String.format(tip, ftag));
                    }
                }
                this.getModel().setValue(KEY_CUSTOM_TAG, (Object)fcustomTag);
            }
        }
        this.getCache().put(KEY_EXIST_TAG_KEY_LIST, tagKeyList);
    }

    private String initTagTypeCombo(String markType) {
        String defaultTagType = null;
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_TAG_TYPE_COMBO);
        JSONArray itemJa = new JSONArray();
        if (StringUtils.isEmpty((CharSequence)markType) || StringUtils.equalsIgnoreCase((CharSequence)markType, (CharSequence)MarkTypeEnum.ITEM.getId())) {
            itemJa = JSONArray.parseArray((String)TAGTYPE_ITEM_LIST);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)markType, (CharSequence)MarkTypeEnum.BILL.getId())) {
            itemJa = JSONArray.parseArray((String)TAGTYPE_BILL_LIST);
        }
        int len = itemJa.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            JSONObject jo = itemJa.getJSONObject(i);
            String key = jo.getString("id");
            LocaleString comboItemText = new LocaleString(jo.getString("name"));
            ComboItem comboItem = new ComboItem(comboItemText, key);
            if (i == 0) {
                defaultTagType = key;
            }
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
        this.getModel().setValue(KEY_TAG_TYPE_COMBO, defaultTagType);
        return defaultTagType;
    }

    private FieldAp createFieldAp(String key, LocaleString name) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(name);
        fieldAp.setFireUpdEvt(true);
        RadioField radioField = new RadioField();
        radioField.setId(key);
        radioField.setKey(key);
        radioField.setName(name);
        radioField.setGroup(KEY_RADIOGROUP_TAG);
        radioField.setItems(key);
        fieldAp.setField((Field)radioField);
        fieldAp.setWidth(new LocaleString("100px"));
        return fieldAp;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)this.getCache().get(KEY_SAVE_MARK_RESULT));
    }
}

