/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IDataOutlierAnaService;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MarkOutlierTagListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(MarkOutlierTagListPlugin.class);
    private static final String KEY_PKID_LIST = "pkIdList";
    private static final String KEY_BTN_DELETE_TAG = "deletetag";
    private static final String KEY_BTN_ENABLE = "enable";
    private static final String KEY_BTN_DISABLE = "disable";
    private static final String KEY_BTN_REFRESH = "refresh";
    private static final String KEY_TOOLBARAP = "toolbarap";

    public IDataappService dataAppService() {
        return (IDataappService)Services.get(IDataappService.class);
    }

    public ITenantService tenantService() {
        return (ITenantService)Services.get(ITenantService.class);
    }

    public IDataOutlierAnaService dataOutlierAnaService() {
        return (IDataOutlierAnaService)Services.get(IDataOutlierAnaService.class);
    }

    private String getSubServiceId() {
        return this.getPageCache().get("subServiceId");
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
    }

    public void createNewData(BizDataEventArgs e) {
        RequestContext rc = RequestContext.get();
    }

    public void afterCreateNewData(EventObject e) {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.getPageCache().put("subServiceId", subServiceId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        RequestContext rc = RequestContext.get();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            ListSelectedRowCollection listSelectedData = donothing.getListSelectedData();
            if (listSelectedData == null || listSelectedData.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            Object[] pkArray = listSelectedData.getPrimaryKeyValues();
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ids_mark_outlier_tag");
            DynamicObject[] selectedDynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)newDynamicObject.getDynamicObjectType());
            if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_ENABLE, (CharSequence)operateKey)) {
                for (DynamicObject dynamicObject : selectedDynamicObjectArray) {
                    dynamicObject.set("status", (Object)EnableEnum.AVAIL.getKey());
                }
                SaveServiceHelper.save((DynamicObject[])selectedDynamicObjectArray);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"Common_Operation_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_DISABLE, (CharSequence)operateKey)) {
                ArrayList<String> fnumberList = new ArrayList<String>(10);
                for (DynamicObject dynamicObject : selectedDynamicObjectArray) {
                    dynamicObject.set("status", (Object)EnableEnum.INVALID.getKey());
                    fnumberList.add(dynamicObject.getString("number"));
                }
                List usedNumberList = this.dataOutlierAnaService().checkTagUseDetail(rc, fnumberList, this.getSubServiceId());
                if (CollectionUtils.isNotEmpty((Collection)usedNumberList)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u7981\u7528", (String)"MarkOutlierTagListPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]), StringUtils.join((Object[])usedNumberList.toArray(), (String)",")), Integer.valueOf(10000));
                    return;
                }
                SaveServiceHelper.save((DynamicObject[])selectedDynamicObjectArray);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"Common_Operation_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_DELETE_TAG, (CharSequence)operateKey)) {
                ArrayList<Long> pkIdList = new ArrayList<Long>(10);
                ArrayList<String> notAllowDeleteNumberList = new ArrayList<String>(10);
                for (DynamicObject dynamicObject : selectedDynamicObjectArray) {
                    boolean status = dynamicObject.getBoolean("status");
                    boolean ispreinsdata = dynamicObject.getBoolean("ispreinsdata");
                    if (status || ispreinsdata) {
                        notAllowDeleteNumberList.add(dynamicObject.getString("number"));
                        continue;
                    }
                    pkIdList.add(dynamicObject.getLong("id"));
                }
                if (!notAllowDeleteNumberList.isEmpty()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u542f\u7528\u6216\u4e3a\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (String)"MarkOutlierTagListPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]), StringUtils.join((Object[])notAllowDeleteNumberList.toArray(), (String)",")), Integer.valueOf(10000));
                    return;
                }
                if (CollectionUtils.isNotEmpty(pkIdList)) {
                    this.getPageCache().put(KEY_PKID_LIST, JSON.toJSONString(pkIdList));
                    String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u8bb0\u5f55\u5417\uff1f", (String)"MarkOutlierTagListPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_BTN_DELETE_TAG, (IFormPlugin)this);
                    this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener, null, selectedDynamicObjectArray.length + "");
                }
            }
            this.getView().invokeOperation(KEY_BTN_REFRESH);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)KEY_BTN_DELETE_TAG) && e.getResult() == MessageBoxResult.Yes) {
            String customVaule = e.getCustomVaule();
            String pkIds = this.getPageCache().get(KEY_PKID_LIST);
            List pkIdList = JSONArray.parseArray((String)pkIds, Long.class);
            QFilter qFilter = new QFilter("id", "in", (Object)pkIdList);
            DeleteServiceHelper.delete((String)"ids_mark_outlier_tag", (QFilter[])qFilter.toArray());
            if (pkIdList.size() == Integer.parseInt(customVaule)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"Common_Operation_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation(KEY_BTN_REFRESH);
        }
    }
}

