/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.ai.ids.core.enumtype.FilterItemBizTypeEnum;
import kd.ai.ids.core.enumtype.TimeTypeEnum;
import kd.ai.ids.core.query.label.LabelItem;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.plugin.control.IdsFilterItemEdit;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.ControlTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class MaterialSaleAnaFormPlugin
extends BaseFormPlugin {
    private static final String KEY_CUSTOM_CONTROL_AP_SANKEY = "customcontrolapsankey";
    private static final String CHART_TYPE_KEY = "sale_analysic_samKey";
    private static final String KEY_COMBO_SCHEME = "comboscheme";
    private static final String KEY_MUL_COMBO_F_DIM1_LEVEL = "mulcombofdim1level";
    private static final String KEY_COMBO_F_TIME_TYPE = "comboftimetype";
    private static final String EVENT_NAME_HIDE_LOADING = "hideLoading";
    private static final String KEY_NUMBER_SCHEME_JO_MAP = "number_schemejo_map";
    private static final String KEY_DEFAULT_SCHEME_NUMBER = "defaultSchemeNumber";
    private static final String KEY_DIM2LEVEL = "dim2level";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_LABEL_DIM_VALUE = "labelapdim%svalue";
    private static final String KEY_LABEL_DIM_VALUE_UNIT = "labelapdim%svalueunit";
    private static final String KEY_LABEL_DIM_PERCENT = "labelapdim%spercent";
    private static final String KEY_LABEL_DIM2LEVEL = "labelapdim2level";
    private static final String KEY_LABEL_DIM3LEVEL = "labelapdim3level";
    private static final String KEY_LABEL_DIM4LEVEL = "labelapdim4level";
    private static final String KEY_LABEL_ORG = "labelaporg";
    private static final String KEY_FLEX_PANEL_AP9 = "flexpanelap9";
    private static final String KEY_MULBD_PREFIX = "predimenttype";
    private static final String KEY_OLD_DIM2LEVEL = "olddim2level";

    @Override
    public void setLabelText(String key, String text) {
        Label label = (Label)this.getView().getControl(key);
        if (label != null) {
            label.setText(text);
        }
    }

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    private JSONObject getFdim2level() {
        return this.getCache().getAsObject(KEY_DIM2LEVEL);
    }

    private String getOldDim2level() {
        return this.getCache().get(KEY_OLD_DIM2LEVEL);
    }

    private String getDefaultSchemeNumber() {
        return this.getCache().get(KEY_DEFAULT_SCHEME_NUMBER);
    }

    private JSONObject getSchemeJoByNumber(String fschemeNumber) {
        JSONObject numberSchemeJoMapJo = this.getCache().getAsObject(KEY_NUMBER_SCHEME_JO_MAP);
        return numberSchemeJoMapJo.getJSONObject(fschemeNumber);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_RESET});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        super.click(evt);
        switch (evtKey) {
            case "btnok": {
                this.loadChartData();
                break;
            }
            case "btnreset": {
                this.resetQueryCondition();
                this.loadChartData();
                break;
            }
        }
    }

    private void resetQueryCondition() {
        String fschemeNumber = this.getDefaultSchemeNumber();
        this.getModel().setValue(KEY_COMBO_SCHEME, (Object)fschemeNumber);
        this.getModel().setValue(KEY_MUL_COMBO_F_DIM1_LEVEL, null);
        String dim2level = this.getFdim2level().getString("id");
        this.resetDim2levelCombo(dim2level);
        this.getModel().setValue(KEY_COMBO_F_TIME_TYPE, (Object)TimeTypeEnum.M1.getId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        RequestContext rc = RequestContext.get();
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_SCHEME)) {
            String oldDim2level = this.getFdim2level().getString("id");
            this.getCache().put(KEY_OLD_DIM2LEVEL, oldDim2level);
            this.resetDim2levelCombo(oldDim2level);
            this.getModel().setValue(KEY_MUL_COMBO_F_DIM1_LEVEL, null);
            String fschemeNumber = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            JSONObject schemeJo = this.getSchemeJoByNumber(fschemeNumber);
            JSONArray idNameList = schemeJo.getJSONArray("idNameList");
            String fdim1levelType = idNameList.getJSONObject(0).getString("id");
            String fdim1levelName = idNameList.getJSONObject(0).getString("name");
            String fdim2levelName = idNameList.getJSONObject(1).getString("name");
            this.getCache().put(KEY_DIM2LEVEL, idNameList.getJSONObject(1).toJSONString());
            this.setLabelText(KEY_LABEL_DIM2LEVEL, fdim2levelName);
            this.setLabelText(KEY_LABEL_DIM3LEVEL, idNameList.getJSONObject(2).getString("name"));
            this.setLabelText(KEY_LABEL_DIM4LEVEL, idNameList.getJSONObject(3).getString("name"));
            this.setLabelText(KEY_LABEL_ORG, fdim1levelName);
            this.initDim2level();
            this.loadDim1levelList(rc, fschemeNumber, fdim1levelType);
        }
    }

    private void resetDim2levelCombo(String oldDim2level) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        this.getCache().remove("ListData_" + oldDim2level);
        this.getCache().remove("SelectedList_" + oldDim2level);
        clientViewProxy.setFieldProperty("predimenttype_" + oldDim2level, "v", (Object)new Object[0]);
    }

    private void initDim2level() {
        Container panel = (Container)this.getControl(KEY_FLEX_PANEL_AP9);
        String oldDim2level = this.getOldDim2level();
        String[] deleteControls = (String[])Collections.singletonList(oldDim2level).stream().flatMap(s -> {
            String key = "predimenttype_" + s;
            return Stream.of(key + "_panel", key + "_label", key);
        }).toArray(String[]::new);
        panel.deleteControls(deleteControls);
        String dim2level = "";
        String dim2levelName = "";
        JSONObject dim2levelJo = this.getFdim2level();
        if (dim2levelJo != null) {
            dim2level = dim2levelJo.getString("id");
            dim2levelName = dim2levelJo.getString("name");
        }
        String key = "predimenttype_" + dim2level;
        Map<String, Object> control = ControlTools.createMulBaseDataControl(key, String.format("%s", dim2levelName), ResManager.loadKDString((String)"\u9500\u552e\u989dTOP10", (String)"MaterialSaleAnaFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]), "h");
        panel.insertControls(0, Collections.singletonList(control));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadTimeTypeItemList();
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.getCache().put("subServiceId", subServiceId);
        this.loadMaterailSaleSchemeList(rc);
        this.initDim2level();
    }

    private void loadMaterailSaleSchemeList(RequestContext rc) {
        JSONArray dataJa = this.materialSaleAnaService().getMaterialSaleSchemeList(Long.valueOf(rc.getOrgId()), this.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        String defaultSchemeNumber = "";
        JSONObject dim1levelIdNameJo = new JSONObject();
        JSONObject dim2levelIdNameJo = new JSONObject();
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_SCHEME);
        int len = dataJa.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        HashMap<String, JSONObject> numberSchemeJoMap = new HashMap<String, JSONObject>(10);
        for (int i = 0; i < len; ++i) {
            JSONObject jo = dataJa.getJSONObject(i);
            String fnumber = jo.getString("fnumber");
            numberSchemeJoMap.put(fnumber, jo);
            JSONArray idNameList = jo.getJSONArray("idNameList");
            LocaleString comboItemText = new LocaleString(jo.getString("fname"));
            ComboItem comboItem = new ComboItem(comboItemText, fnumber);
            data.add(comboItem);
            if (!StringUtils.isEmpty((CharSequence)defaultSchemeNumber) || idNameList == null || idNameList.size() <= 0) continue;
            defaultSchemeNumber = fnumber;
            this.getCache().put(KEY_DEFAULT_SCHEME_NUMBER, defaultSchemeNumber);
            dim1levelIdNameJo = idNameList.getJSONObject(0);
            dim2levelIdNameJo = idNameList.getJSONObject(1);
        }
        comboEdit.setComboItems(data);
        this.getCache().put(KEY_NUMBER_SCHEME_JO_MAP, JSON.toJSONString(numberSchemeJoMap));
        if (StringUtils.isNotEmpty((CharSequence)defaultSchemeNumber)) {
            this.getModel().setValue(KEY_COMBO_SCHEME, (Object)defaultSchemeNumber);
            String fdim1levelType = dim1levelIdNameJo.getString("id");
            this.getCache().put(KEY_DIM2LEVEL, dim2levelIdNameJo.toJSONString());
            this.loadDim1levelList(rc, defaultSchemeNumber, fdim1levelType);
            this.loadChartData();
        }
    }

    private void loadDim1levelList(RequestContext rc, String fschemeNumber, String fdim1levelType) {
        JSONArray dataJa = this.materialSaleAnaService().getDim1levelList(Long.valueOf(rc.getOrgId()), this.getSubServiceId(), fschemeNumber, fdim1levelType);
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_MUL_COMBO_F_DIM1_LEVEL);
        int len = dataJa.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            JSONObject jo = dataJa.getJSONObject(i);
            String fnumber = jo.getString("number");
            LocaleString comboItemText = new LocaleString(jo.getString("name"));
            ComboItem comboItem = new ComboItem(comboItemText, fnumber);
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
    }

    private void loadChartData() {
        JSONObject graphData;
        JSONObject dataJo;
        JSONArray summaryData;
        String dim2level = this.getFdim2level().getString("id");
        this.getCache().put(KEY_OLD_DIM2LEVEL, dim2level);
        String fieldKey = "predimenttype_" + dim2level;
        IdsFilterItemEdit edit = (IdsFilterItemEdit)this.getControl(fieldKey);
        List<String> fdim2levelList = edit.getSelectedNumberList();
        if (fdim2levelList != null && fdim2levelList.size() > 10) {
            JSONObject fdim2levelJo = this.getFdim2level();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6700\u591a\u652f\u6301\u9009\u62e910\u4e2a", (String)"MaterialSaleAnaFormPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]), fdim2levelJo.getString("name")));
            return;
        }
        this.getView().showLoading(null, 2000);
        RequestContext rc = RequestContext.get();
        String subServiceId = this.getSubServiceId();
        String schemeNumber = (String)this.getModel().getValue(KEY_COMBO_SCHEME);
        String ftimetype = (String)this.getModel().getValue(KEY_COMBO_F_TIME_TYPE);
        String fdiim1levelNumbers = (String)this.getModel().getValue(KEY_MUL_COMBO_F_DIM1_LEVEL);
        List<String> fdim1levelList = null;
        if (StringUtils.isNotEmpty((CharSequence)fdiim1levelNumbers)) {
            fdim1levelList = Arrays.asList(StringUtils.split((String)fdiim1levelNumbers, (char)','));
        }
        if ((summaryData = (dataJo = this.materialSaleAnaService().getMaterialSaleAnaData(Long.valueOf(rc.getOrgId()), subServiceId, schemeNumber, ftimetype, fdim1levelList, fdim2levelList)).getJSONArray("summaryData")) != null && summaryData.size() > 0) {
            for (int i = 0; i < summaryData.size(); ++i) {
                JSONObject summaryItem = summaryData.getJSONObject(i);
                this.setLabelText(String.format(KEY_LABEL_DIM_VALUE, i + 2), summaryItem.getString("fdimvalueFormat"));
                this.setLabelText(String.format(KEY_LABEL_DIM_VALUE_UNIT, i + 2), summaryItem.getString("funit"));
                this.setLabelText(String.format(KEY_LABEL_DIM_PERCENT, i + 2), summaryItem.getString("fdimpercent"));
            }
        }
        if ((graphData = dataJo.getJSONObject("graphData")) == null) {
            return;
        }
        CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL_AP_SANKEY);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("containerId", KEY_CUSTOM_CONTROL_AP_SANKEY);
        map.put("chartType", CHART_TYPE_KEY);
        map.put("data", (String)graphData);
        customControl.setData(map);
    }

    private void loadTimeTypeItemList() {
        String start1Date = DateFormatUtils.format((Date)KDDateUtils.getTheMonthStart((int)-1), (String)"MM-dd");
        String start6Date = DateFormatUtils.format((Date)KDDateUtils.getTheMonthStart((int)-6), (String)"MM-dd");
        String endDate = DateFormatUtils.format((Date)KDDateUtils.addDays((Date)KDDateUtils.getTheMonthEnd((int)-1), (int)-1), (String)"MM-dd");
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_F_TIME_TYPE);
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(2);
        ComboItem month1Item = new ComboItem(new LocaleString(String.format("%s(%s~%s)", TimeTypeEnum.M1.getName(), start1Date, endDate)), TimeTypeEnum.M1.getId());
        itemList.add(month1Item);
        ComboItem month6Item = new ComboItem(new LocaleString(String.format("%s(%s~%s)", TimeTypeEnum.M6.getName(), start6Date, endDate)), TimeTypeEnum.M6.getId());
        itemList.add(month6Item);
        comboEdit.setComboItems(itemList);
        this.getModel().setValue(KEY_COMBO_F_TIME_TYPE, (Object)TimeTypeEnum.M1.getId());
    }

    public void customEvent(CustomEventArgs e) {
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        if (KEY_CUSTOM_CONTROL_AP_SANKEY.equals(controlKey) && EVENT_NAME_HIDE_LOADING.equals(eventName)) {
            this.getView().hideLoading();
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getControl() != null) {
            return;
        }
        String key = e.getKey();
        String[] keySplit = key.split("_");
        if (keySplit.length > 1 && KEY_MULBD_PREFIX.equals(keySplit[0])) {
            String labelId = keySplit[1];
            IdsFilterItemEdit edit = new IdsFilterItemEdit();
            edit.setKey(key);
            edit.setView(this.getView());
            LabelItem item = new LabelItem();
            item.setId(labelId);
            JSONObject fdim2level = this.getFdim2level();
            item.setName(fdim2level.getString("name"));
            edit.setLabel(item);
            edit.setSubServiceId(this.getSubServiceId());
            edit.setMultiSelect(true);
            edit.setBizType(FilterItemBizTypeEnum.MATERIAL_SALE.getId());
            String fschemeNumber = (String)this.getModel().getValue(KEY_COMBO_SCHEME);
            edit.setFschemeNumber(fschemeNumber);
            edit.setFdimtype(fdim2level.getString("id"));
            String fdiim1levelNumbers = (String)this.getModel().getValue(KEY_MUL_COMBO_F_DIM1_LEVEL);
            List<String> fdim1levelList = null;
            if (StringUtils.isNotEmpty((CharSequence)fdiim1levelNumbers)) {
                fdim1levelList = Arrays.asList(StringUtils.split((String)fdiim1levelNumbers, (char)','));
            }
            edit.setFdim1levelList(fdim1levelList);
            edit.setPageCache(this.getCache());
            e.setControl((Control)edit);
        }
    }
}

