/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.enumtype.FilterItemBizTypeEnum;
import kd.ai.ids.core.query.data.FilterItemDTO;
import kd.ai.ids.core.query.data.FilterItemQuery;
import kd.ai.ids.core.query.data.FilterItemValuesDTO;
import kd.ai.ids.core.query.label.LabelItem;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.control.IdsFilterItemEdit;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.form.ModelAnalysisChart;
import kd.ai.ids.plugin.form.ModelAnalysisContext;
import kd.ai.ids.plugin.tool.ControlTools;
import kd.ai.ids.plugin.tool.FormTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ModelAnalysisFormPlugin
extends BaseFormPlugin
implements BeforeBindDataListener {
    public static final String KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP = "modSchemeSelectMap_";
    public static final String KEY_LOAD_ANA_YEAR_TREND = "LoadAnaYearTrend";
    public static final String KEY_LOAD_ANA_LAST_TREND = "LoadAnaLastTrend";
    public static final String KEY_LOAD_ANA_LAST_TREND_DETAIL = "LoadAnaLastTrendDetail";
    public static final String KEY_ERROR_DATA = "error";
    public static final String KEY_CHECK_AND_HIDE_LOADING = "CheckAndHideLoading";
    public static final String KEY_PREDIMENTTYPE_LAST_LABEL_ID = "predimenttype_last_label_id";
    public static final String KEY_PREDIMENTTYPE_ALL_LABEL_ID = "predimenttype_all_label_id";
    public static final String KEY_PREDIMENTTYPE_LABEL_NAME = "predimenttype_label_name_";
    public static final String KEY_LAST_TREND_GRAPH1 = "lasttrendgraph1";
    private static final String KEY_BTN_UN_ONLINE_OK = "btnunonlineok";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_BTN_PREDICT_MODEL_EXPLAIN = "btnmodelexplain";
    private static final String KEY_COMBO_MODSCHEME_SELECT = "combomodschemeselect";
    private static final String KEY_LABEL_ORG_DIM = "labelorgdim";
    private static final String KEY_LABEL_PRODUCT_DIM = "labelproductdim";
    private static final String KEY_LABEL_PREDICT_PERIOD = "labelpredictperiod";
    private static final String KEY_LABEL_PREDICT_LENGTH = "labelpredictlength";
    private static final String KEY_LABEL_PREDICT_VALUE = "labelpredictvalue";
    private static final String KEY_MULBD_PREFIX = "predimenttype";
    private static final String KEY_COMBO_FPREVALUETYPE = "combofprevaluetype";
    private static final String KEY_POINTLINE_CHART_YEAR_TREND = "pointlinechartyeartrend";
    private static final String KEY_CUSTOME_CHART_LAST_TREND = "customchartlasttrend";
    private static final String KEY_LABEL_PREDICT_DETAIL_TITLE = "labelpredictdetailtitle";
    private static final String KEY_FORMID_IDS_PREDICT_MODEL_EXPLAIN = "ids_predict_model_explain";
    private static final String KEY_FILTER_ITEM_QUERY = "filterItemQuery";
    private static final String KEY_LABEL_YEAR_TREND_TITLE = "labelapyeartrendtitle";
    private static final String KEY_LABEL_LAST_TREND_TITLE = "labelaplasttrendtitle";
    private static final String KEY_LABEL_LAST_TREND_LIST_TITLE = "labelaplasttrendlisttitle";
    private static final String KEY_VECTOR_LAST_TREND_GRAPH = "vectoraplasttrendgraph";
    private static final String KEY_VECTOR_LAST_TREND_LIST = "vectoraplasttrendlist";
    private static final String KEY_ENTRY_ENTITY_LAST_TREND = "lasttrendentryentity";
    private final ModelAnalysisChart modelAnalysisChart = new ModelAnalysisChart();
    private ModelAnalysisContext ctx = null;
    private static final int CALL_BACK_DEFAULT_DURATION = 300;

    @Override
    public void initialize() {
        super.initialize();
        this.ctx = new ModelAnalysisContext(this.getCache());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_RESET, KEY_BTN_PREDICT_MODEL_EXPLAIN, KEY_CUSTOME_CHART_LAST_TREND, KEY_VECTOR_LAST_TREND_LIST, KEY_VECTOR_LAST_TREND_GRAPH});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        if (evtKey.equals(KEY_CUSTOME_CHART_LAST_TREND)) {
            String dateStr;
            ChartClickEvent e = (ChartClickEvent)evt;
            String name = e.getName();
            if (StringUtils.isEmpty((CharSequence)name)) {
                return;
            }
            String fpretimetype = this.ctx.getCurPreTimeType();
            Date startDate = null;
            Date endDate = null;
            Date now = new Date();
            if (StringUtils.equalsIgnoreCase((CharSequence)"fdate", (CharSequence)fpretimetype)) {
                dateStr = name = name.replace('.', '-');
                endDate = startDate = DateUtils.parseDate((String)dateStr, (String)"yy-MM-dd");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"fweek", (CharSequence)fpretimetype)) {
                String beginOfWeek = name = name.replace('.', '-');
                startDate = DateUtils.parseDate((String)beginOfWeek, (String)"yy-MM-dd");
                endDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)startDate, (int)6);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"fmonth", (CharSequence)fpretimetype)) {
                name = name.replace('.', '-');
                dateStr = name + DateFormatUtils.format((Date)now, (String)"-dd");
                startDate = DateUtils.beginOfMonth((String)dateStr);
                endDate = DateUtils.endOfMonth((String)dateStr);
            }
            FilterItemQuery filterItemQuery = this.ctx.getCurFilterItemQuery();
            filterItemQuery.setStartTime(DateFormatUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
            filterItemQuery.setEndTime(DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ids_predict_detail_list");
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put(KEY_FILTER_ITEM_QUERY, JSON.toJSONString((Object)filterItemQuery));
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else {
            switch (evtKey) {
                case "btnrefresh": {
                    this.loadChartData(false, this.ctx.getCurFilterItemQuery());
                    break;
                }
                case "btnreset": {
                    this.resetQueryCondition();
                    this.loadChartData(true, null);
                    break;
                }
                case "btnmodelexplain": {
                    this.showPredictModelExplain();
                    break;
                }
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        String fpretimetype = "";
        FilterItemQuery filterItemQuery = null;
        if (controlKey.equalsIgnoreCase(KEY_LAST_TREND_GRAPH1) && eventName.equalsIgnoreCase("barClick")) {
            String dateStr;
            JSONObject menuObj = JSON.parseObject((String)args);
            String name = menuObj.getString("fdate");
            fpretimetype = menuObj.getString("fpretimetype");
            String filterQueryStr = menuObj.getString("filterQuery");
            filterItemQuery = (FilterItemQuery)JSON.toJavaObject((JSON)JSON.parseObject((String)filterQueryStr), FilterItemQuery.class);
            Date startDate = null;
            Date endDate = null;
            Date now = new Date();
            if (StringUtils.equalsIgnoreCase((CharSequence)"fdate", (CharSequence)fpretimetype)) {
                dateStr = name = name.replace('.', '-');
                endDate = startDate = DateUtils.parseDate((String)dateStr, (String)"yy-MM-dd");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"fweek", (CharSequence)fpretimetype)) {
                String beginOfWeek = name = name.replace('.', '-');
                startDate = DateUtils.parseDate((String)beginOfWeek, (String)"yy-MM-dd");
                endDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)startDate, (int)6);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"fmonth", (CharSequence)fpretimetype)) {
                name = name.replace('.', '-');
                dateStr = name + DateFormatUtils.format((Date)now, (String)"-dd");
                startDate = DateUtils.beginOfMonth((String)dateStr);
                endDate = DateUtils.endOfMonth((String)dateStr);
            }
            filterItemQuery.setStartTime(DateFormatUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
            filterItemQuery.setEndTime(DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ids_predict_detail_list");
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put(KEY_FILTER_ITEM_QUERY, JSON.toJSONString((Object)filterItemQuery));
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    private void showPredictModelExplain() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(KEY_FORMID_IDS_PREDICT_MODEL_EXPLAIN);
        HashMap<String, String> customParams = new HashMap<String, String>();
        String fmodeltypeid = this.ctx.getCurModelTypeId();
        String s = this.getCache().get(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + fmodeltypeid);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return;
        }
        JSONObject modSchemeSelectJo = JSON.parseObject((String)s);
        if (modSchemeSelectJo != null) {
            String fmodeltypeidName = modSchemeSelectJo.getString("fmodeltypeidFname");
            String orgDimName = modSchemeSelectJo.getString("fpredimentypeOrgFname");
            String productDimName = modSchemeSelectJo.getString("fpredimentypeProductFname");
            String predictPeriodName = modSchemeSelectJo.getString("fpretimetypeFname");
            String predictLengthName = modSchemeSelectJo.getString("ftn");
            String predictValueName = modSchemeSelectJo.getString("fprevaluetypeFname");
            customParams.put("fmodeltypeidName", fmodeltypeidName);
            customParams.put("orgDimName", orgDimName);
            customParams.put("productDimName", productDimName);
            customParams.put("predictPeriodName", predictPeriodName);
            customParams.put("predictLengthName", predictLengthName);
            customParams.put("predictValueName", predictValueName);
            customParams.put("subServiceId", this.ctx.getSubServiceId());
            customParams.put("fmodeltypeid", fmodeltypeid);
        }
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void resetQueryCondition() {
        this.clearPredimentTypeFilterData();
        FilterItemQuery defaultFilterItemQuery = this.ctx.getDefaultFilterItemQuery();
        if (defaultFilterItemQuery != null) {
            defaultFilterItemQuery.setCurrent(Long.valueOf(1L));
            defaultFilterItemQuery.setOrderByExpr(null);
            defaultFilterItemQuery.setFilters(null);
        }
        this.ctx.setCurFilterItemQuery(defaultFilterItemQuery);
        if (defaultFilterItemQuery != null) {
            this.getModel().setValue(KEY_COMBO_FPREVALUETYPE, (Object)defaultFilterItemQuery.getPrevaluetypeDTO().getId());
        }
    }

    private void clearPredimentTypeFilterData() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        List allLabelIdList = this.getCache().getAsList(KEY_PREDIMENTTYPE_ALL_LABEL_ID, String.class);
        for (String key : allLabelIdList) {
            this.getCache().remove("ListData_" + key);
            this.getCache().remove("SelectedList_" + key);
            clientViewProxy.setFieldProperty("predimenttype_" + key, "v", (Object)new Object[0]);
        }
    }

    private void buildFilterItemValuesDTOList(List<FilterItemValuesDTO> filterItemValuesDTOList, String filterItemType) {
        String fieldKey = "predimenttype_" + filterItemType;
        IdsFilterItemEdit edit = (IdsFilterItemEdit)this.getControl(fieldKey);
        List<String> numberList = edit.getSelectedNumberList();
        FilterItemValuesDTO filterItem = new FilterItemValuesDTO();
        filterItem.setLabelId(filterItemType);
        String values = "-1";
        if (numberList != null && !numberList.isEmpty()) {
            values = String.join((CharSequence)",", numberList);
        }
        filterItem.setValues(values);
        filterItemValuesDTOList.add(filterItem);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_MODSCHEME_SELECT)) {
            String fmodeltypeid = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.resetQueryCondition();
            this.showCurrentModSelectAndFilterItem(fmodeltypeid);
            this.loadChartData(true, null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_FPREVALUETYPE)) {
            String fprevaluetype = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.ctx.setCurPreValueType(fprevaluetype);
        }
    }

    private void showCurrentModSelectAndFilterItem(String modelTypeId) {
        String s = this.getCache().get(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return;
        }
        JSONObject modSchemeSelectJo = JSON.parseObject((String)s);
        if (modSchemeSelectJo != null) {
            String orgDimName = modSchemeSelectJo.getString("fpredimentypeOrgFname");
            String productDimName = modSchemeSelectJo.getString("fpredimentypeProductFname");
            String fpretimetype = modSchemeSelectJo.getString("fpretimetype");
            String predictPeriodName = modSchemeSelectJo.getString("fpretimetypeFname");
            String predictLengthName = modSchemeSelectJo.getString("ftn");
            String predictValueName = modSchemeSelectJo.getString("fprevaluetypeFname");
            this.ctx.setCurPreTimeType(fpretimetype);
            this.setLabelText(KEY_LABEL_ORG_DIM, orgDimName);
            this.setLabelText(KEY_LABEL_PRODUCT_DIM, productDimName);
            this.setLabelText(KEY_LABEL_PREDICT_PERIOD, predictPeriodName);
            this.setLabelText(KEY_LABEL_PREDICT_LENGTH, predictLengthName);
            this.setLabelText(KEY_LABEL_PREDICT_VALUE, predictValueName);
            this.loadAnaResultsFilterItem(modelTypeId);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    private void loadOnlineModelTypeList(RequestContext rc) {
        JSONArray dataJa = this.anaResultService().getOnlineSchemeList(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_MODSCHEME_SELECT);
        int len = dataJa.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        HashMap<String, String> modSchemeSelectMap = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            JSONObject jo = dataJa.getJSONObject(i);
            String modelTypeId = jo.getString("fmodeltypeid");
            if (StringUtils.isEmpty((CharSequence)this.ctx.getCurModelTypeId())) {
                this.ctx.setCurModelTypeId(modelTypeId);
            }
            modSchemeSelectMap.put(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId, jo.toJSONString());
            LocaleString comboItemText = new LocaleString(jo.getString("fmodeltypeidFname"));
            ComboItem comboItem = new ComboItem(comboItemText, modelTypeId);
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
        this.getCache().put(modSchemeSelectMap);
        this.showCurrentModSelectAndFilterItem(this.ctx.getCurModelTypeId());
    }

    private void loadAnaResultsFilterItem(String fmodeltypeid) {
        this.ctx.setCurModelTypeId(fmodeltypeid);
        RequestContext rc = RequestContext.get();
        JSONObject dataJo = this.anaResultService().getFilterItem(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId(), fmodeltypeid, false);
        if (dataJo == null) {
            return;
        }
        JSONArray predimenttypeArray = dataJo.getJSONArray("predimenttypeArray");
        JSONArray fprevaluetypeArray = dataJo.getJSONArray("fprevaluetypeArray");
        this.initPreDimentType(predimenttypeArray);
        this.initPreValueTypeCombo(fprevaluetypeArray);
    }

    private void initPreDimentType(JSONArray predimentTypeArray) {
        ArrayList<String> filterLabelIdList = new ArrayList<String>();
        List allLabelIdList = this.getCache().getAsList(KEY_PREDIMENTTYPE_ALL_LABEL_ID, String.class);
        Container panel = (Container)this.getControl("flexpanelap3");
        String[] deleteControls = (String[])allLabelIdList.stream().flatMap(s -> {
            String key = "predimenttype_" + s;
            return Stream.of(key + "_panel", key + "_label", key);
        }).toArray(String[]::new);
        panel.deleteControls(deleteControls);
        if (predimentTypeArray != null && !predimentTypeArray.isEmpty()) {
            int index = 0;
            int len = predimentTypeArray.size();
            for (int i = 0; i < len; ++i) {
                JSONObject jo = predimentTypeArray.getJSONObject(i);
                String labelId = jo.getString("labelId");
                String fieldKey = "predimenttype_" + labelId;
                String showText = jo.getString("labelName");
                this.getCache().put(KEY_PREDIMENTTYPE_LABEL_NAME + labelId, showText);
                boolean isMul = true;
                if (i == len - 1) {
                    this.getCache().put(KEY_PREDIMENTTYPE_LAST_LABEL_ID, labelId);
                    isMul = false;
                }
                filterLabelIdList.add(labelId);
                if (!allLabelIdList.contains(labelId)) {
                    allLabelIdList.add(labelId);
                }
                Map<String, Object> control = isMul ? ControlTools.createMulBaseDataControl(fieldKey, showText) : ControlTools.createBaseDataControl(fieldKey, showText);
                panel.insertControls(index, Collections.singletonList(control));
                ++index;
            }
        }
        this.getCache().put(KEY_PREDIMENTTYPE_ALL_LABEL_ID, allLabelIdList);
        this.ctx.setPreDimentTypeFilterLabelIdList(filterLabelIdList);
    }

    private void initPreValueTypeCombo(JSONArray fprevaluetypeArray) {
        if (fprevaluetypeArray == null || fprevaluetypeArray.isEmpty()) {
            return;
        }
        JSONObject jo = fprevaluetypeArray.getJSONObject(0);
        JSONArray valueJa = jo.getJSONArray("value");
        if (valueJa == null || valueJa.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_FPREVALUETYPE);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(valueJa.size());
        for (int i = 0; i < valueJa.size(); ++i) {
            JSONObject valueJo = valueJa.getJSONObject(i);
            String id = valueJo.getString("id");
            String name = valueJo.getString("name");
            if (i == 0) {
                this.ctx.setCurPreValueType(id);
            }
            ComboItem comboItem = new ComboItem(new LocaleString(name), id);
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
    }

    private void loadAnaYearTrendFromRemote(FilterItemQuery filterItemQuery) {
        RequestContext rc = RequestContext.get();
        JSONObject dataJo = this.anaResultService().getYearTrend(Long.valueOf(rc.getOrgId()), filterItemQuery);
        if (dataJo != null) {
            this.ctx.setCurAnaYearTrendData(dataJo.toJSONString());
        } else {
            this.ctx.setCurAnaYearTrendData(KEY_ERROR_DATA);
        }
    }

    private void refreshAnaYearTrend(JSONObject dataJo, FilterItemQuery filterItemQuery) {
        Control yearTrendChart = this.getControl(KEY_POINTLINE_CHART_YEAR_TREND);
        if (yearTrendChart instanceof PointLineChart) {
            this.setLabelText(KEY_LABEL_YEAR_TREND_TITLE, dataJo.getString("title"));
            PointLineChart pointLineChart = (PointLineChart)yearTrendChart;
            this.modelAnalysisChart.refreshAnaYearTrend(dataJo, filterItemQuery, pointLineChart);
        }
    }

    private void loadAnaLastTrendFromRemote(FilterItemQuery filterItemQuery) {
        RequestContext rc = RequestContext.get();
        JSONObject dataJo = this.anaResultService().getLastTrend(Long.valueOf(rc.getOrgId()), filterItemQuery);
        if (dataJo != null) {
            this.ctx.setCurAnaLastTrendData(dataJo.toJSONString());
        } else {
            this.ctx.setCurAnaLastTrendData(KEY_ERROR_DATA);
        }
    }

    private void loadAnaLastTrendDetailFromRemote(FilterItemQuery filterItemQuery) {
        RequestContext rc = RequestContext.get();
        JSONObject dataJo = this.anaResultService().getLastTrendDetail(Long.valueOf(rc.getOrgId()), filterItemQuery);
        if (dataJo != null) {
            this.ctx.setCurAnaLastTrendDetailData(dataJo.toJSONString());
        } else {
            this.ctx.setCurAnaLastTrendDetailData(KEY_ERROR_DATA);
        }
    }

    private void setCustomChart(JSONObject dataJo) {
        Date now = new Date();
        HashMap<String, Object> customData = new HashMap<String, Object>();
        FilterItemQuery filterItemQuery = this.ctx.getCurFilterItemQuery();
        dataJo.put("filterQuery", (Object)filterItemQuery);
        String fpretimetype = this.ctx.getCurPreTimeType();
        dataJo.put("fpretimetype", (Object)fpretimetype);
        customData.put("data", dataJo);
        customData.put("timestamp", now.getTime());
        customData.put("chartType", "analysic_trend");
        customData.put("pageId", this.getView().getPageId());
        customData.put("uniqueCode", this.getView().getPageId());
        CustomControl customControl = (CustomControl)this.getControl(KEY_LAST_TREND_GRAPH1);
        customControl.setData(customData);
    }

    private void refreshAnaLastTrendDetail(JSONObject dataJo) {
        String title = dataJo.getString("title");
        this.setLabelText(KEY_LABEL_LAST_TREND_LIST_TITLE, title);
        this.showLastTrendDetailList();
    }

    private void showLastTrendDetailList() {
        JSONObject dataJo = JSON.parseObject((String)this.ctx.getCurAnaLastTrendDetailData());
        JSONArray valueArrayJa = dataJo.getJSONArray("valueArray");
        JSONArray ftimeListJa = dataJo.getJSONArray("ftimeList");
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY_LAST_TREND);
        if (ftimeListJa != null && !ftimeListJa.isEmpty()) {
            int i;
            int rowCount = valueArrayJa.size();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY_LAST_TREND, rowCount);
            EntryGrid entry = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY_LAST_TREND);
            for (i = 0; i < 38; ++i) {
                int finalI = i;
                boolean colVisible = finalI < ftimeListJa.size();
                Optional.ofNullable(entry).ifPresent(e -> {
                    String valueColName = String.format("value%s", finalI + 1);
                    e.setColumnProperty(valueColName, "header", colVisible ? new LocaleString(ftimeListJa.getString(finalI)) : "");
                    e.setColumnProperty(valueColName, "vi", (Object)colVisible);
                });
            }
            for (i = 0; i < rowCount; ++i) {
                JSONObject valueJo = valueArrayJa.getJSONObject(i);
                JSONArray valueJa = valueJo.getJSONArray("value");
                this.getModel().setValue("statindicators", (Object)valueJo.getString("label"), rowIndex[i]);
                for (int j = 0; j < valueJa.size(); ++j) {
                    this.getModel().setValue(String.format("value%s", j + 1), (Object)valueJa.getDouble(j), rowIndex[i]);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filterItemQueryStr = (String)formShowParameter.getCustomParam(KEY_FILTER_ITEM_QUERY);
        FilterItemQuery filterItemQuery = null;
        if (StringUtils.isNotEmpty((CharSequence)filterItemQueryStr)) {
            filterItemQuery = (FilterItemQuery)JSON.toJavaObject((JSON)JSON.parseObject((String)filterItemQueryStr), FilterItemQuery.class);
            this.ctx.setCurFilterItemQuery(filterItemQuery);
            this.ctx.setCurModelTypeId(filterItemQuery.getFmodeltypeid());
            this.ctx.setCurPreValueType(filterItemQuery.getPrevaluetypeDTO().getId());
        }
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.ctx.setSubServiceId(subServiceId);
        this.loadOnlineModelTypeList(rc);
        this.loadChartData(true, filterItemQuery);
        this.getModel().setValue(KEY_COMBO_MODSCHEME_SELECT, (Object)this.ctx.getCurModelTypeId());
        this.getModel().setValue(KEY_COMBO_FPREVALUETYPE, (Object)this.ctx.getCurPreValueType());
    }

    private void loadChartData(boolean isInit, FilterItemQuery filterItemQuery) {
        Object oldFilterItemValuesDTOList;
        if (filterItemQuery == null) {
            filterItemQuery = new FilterItemQuery();
        }
        filterItemQuery.setFmodeltypeid(this.ctx.getCurModelTypeId());
        filterItemQuery.setSubServiceId(this.ctx.getSubServiceId());
        FilterItemDTO prevaluetypeDTO = new FilterItemDTO();
        prevaluetypeDTO.setId(this.ctx.getCurPreValueType());
        prevaluetypeDTO.setName((String)AppConstants.prevaluetypeFilterKvMap.get(this.ctx.getCurPreValueType()));
        filterItemQuery.setPrevaluetypeDTO(prevaluetypeDTO);
        ArrayList<FilterItemValuesDTO> filterItemValuesDTOList = new ArrayList<FilterItemValuesDTO>();
        if (!isInit) {
            filterItemQuery.setCurrent(Long.valueOf(1L));
        }
        if (isInit && (oldFilterItemValuesDTOList = filterItemQuery.getFilterItemValuesDTOList()) != null) {
            Map<String, FilterItemValuesDTO> filterItemValuesDTOMap = oldFilterItemValuesDTOList.stream().collect(Collectors.toMap(FilterItemValuesDTO::getLabelId, filterItemValuesDTO -> filterItemValuesDTO));
            Iterator<Map.Entry<String, FilterItemValuesDTO>> iterator = filterItemValuesDTOMap.entrySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                String labelId = iterator.next().getKey();
                String values = filterItemValuesDTOMap.get(labelId).getValues();
                if (StringUtils.isEmpty((CharSequence)values) || StringUtils.equalsIgnoreCase((CharSequence)values, (CharSequence)"-1")) continue;
                String fieldKey = "predimenttype_" + labelId;
                IdsFilterItemEdit edit = (IdsFilterItemEdit)this.getControl(fieldKey);
                edit.setPageCache(this.getCache());
                String searchKey = values.split(",")[0];
                edit.getLookUpList(Arrays.asList(null, searchKey));
                edit.setItemByNumber(values, 0);
                ++index;
            }
        }
        for (String bdmulbdDim : this.ctx.getPreDimentTypeFilterLabelIdList()) {
            this.buildFilterItemValuesDTOList(filterItemValuesDTOList, bdmulbdDim);
        }
        filterItemQuery.setFilterItemValuesDTOList(filterItemValuesDTOList);
        this.ctx.setCurFilterItemQuery(filterItemQuery);
        if (isInit) {
            this.ctx.setDefaultFilterItemQuery(filterItemQuery);
        }
        FormTools.showLoading(this.getView(), this.getView().getPageId(), null);
        this.getView().addClientCallBack(KEY_LOAD_ANA_YEAR_TREND);
        this.getView().addClientCallBack(KEY_LOAD_ANA_LAST_TREND);
        this.getView().addClientCallBack(KEY_LOAD_ANA_LAST_TREND_DETAIL);
        this.getView().addClientCallBack(KEY_CHECK_AND_HIDE_LOADING);
        this.clearData();
        this.getCache().saveChanges();
        FilterItemQuery finalFilterItemQuery = filterItemQuery;
        ThreadUtils.execute(() -> {
            this.loadAnaYearTrendFromRemote(finalFilterItemQuery);
            this.getCache().saveChanges();
        });
        ThreadUtils.execute(() -> {
            this.loadAnaLastTrendFromRemote(finalFilterItemQuery);
            this.getCache().saveChanges();
        });
        ThreadUtils.execute(() -> {
            this.loadAnaLastTrendDetailFromRemote(finalFilterItemQuery);
            this.getCache().saveChanges();
        });
    }

    private void clearData() {
        this.ctx.setCurAnaYearTrendData("");
        this.ctx.setCurAnaLastTrendData("");
        this.ctx.setCurAnaLastTrendDetailData("");
        this.setLabelText(KEY_LABEL_PREDICT_DETAIL_TITLE, "");
        this.clearChartData(KEY_POINTLINE_CHART_YEAR_TREND, KEY_CUSTOME_CHART_LAST_TREND);
    }

    private void clearChartData(String ... keys) {
        for (String key : keys) {
            Chart chart = (Chart)this.getControl(key);
            chart.clearData();
            chart.refresh();
        }
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)KEY_BTN_UN_ONLINE_OK, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
            this.getView().close();
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        boolean isOnline = false;
        if (tenantDTO != null) {
            isOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        }
        if (!isOnline) {
            e.setCancel(true);
            Object source = e.getSource();
            if (!(source instanceof FormShowParameter)) {
                return;
            }
            FormShowParameter fsp = (FormShowParameter)source;
            String parentPageId = fsp.getParentPageId();
            IdsPageCache parentCache = new IdsPageCache(parentPageId);
            parentCache.put("is_online_" + fsp.getFormId(), "false");
            parentCache.saveChanges();
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        String anaYearTrendData = this.ctx.getCurAnaYearTrendData();
        String anaLastTrendData = this.ctx.getCurAnaLastTrendData();
        String anaLastTrendDetailData = this.ctx.getCurAnaLastTrendDetailData();
        switch (name) {
            case "LoadAnaYearTrend": {
                this.clientCallBackLoadAnaYearTrend(name, anaYearTrendData);
                break;
            }
            case "LoadAnaLastTrend": {
                this.clientCallBackLoadAnaLastTrend(name, anaLastTrendData);
                break;
            }
            case "LoadAnaLastTrendDetail": {
                this.clientCallBackLoadAnaLastTrendDetail(name, anaLastTrendDetailData);
                break;
            }
            case "CheckAndHideLoading": {
                this.clientCallBackCheckAndHideLoading(name, anaYearTrendData, anaLastTrendData);
                break;
            }
        }
    }

    private int getCallBackDuration() {
        return 300 + RandomUtils.nextInt((int)300);
    }

    private void clientCallBackCheckAndHideLoading(String name, String anaYearTrendData, String anaLastTrendData) {
        if (StringUtils.isNotEmpty((CharSequence)anaYearTrendData) && StringUtils.isNotEmpty((CharSequence)anaLastTrendData)) {
            FormTools.hideLoading(this.getView(), this.getView().getPageId());
        } else {
            this.getView().addClientCallBack(name, Integer.valueOf(this.getCallBackDuration()));
        }
    }

    private void clientCallBackLoadAnaLastTrendDetail(String name, String anaLastTrendDetailData) {
        if (StringUtils.isEmpty((CharSequence)anaLastTrendDetailData)) {
            this.getView().addClientCallBack(name, Integer.valueOf(this.getCallBackDuration()));
        } else if (!KEY_ERROR_DATA.equals(anaLastTrendDetailData)) {
            this.refreshAnaLastTrendDetail(JSON.parseObject((String)anaLastTrendDetailData));
        }
    }

    private void clientCallBackLoadAnaLastTrend(String name, String anaLastTrendData) {
        if (StringUtils.isEmpty((CharSequence)anaLastTrendData)) {
            this.getView().addClientCallBack(name, Integer.valueOf(this.getCallBackDuration()));
        } else if (!KEY_ERROR_DATA.equals(anaLastTrendData)) {
            this.setCustomChart(JSON.parseObject((String)anaLastTrendData));
        }
    }

    private void clientCallBackLoadAnaYearTrend(String name, String anaYearTrendData) {
        if (StringUtils.isEmpty((CharSequence)anaYearTrendData)) {
            this.getView().addClientCallBack(name, Integer.valueOf(this.getCallBackDuration()));
        } else if (!KEY_ERROR_DATA.equals(anaYearTrendData)) {
            FilterItemQuery currentFilterItemQuery = this.ctx.getCurFilterItemQuery();
            this.refreshAnaYearTrend(JSON.parseObject((String)anaYearTrendData), currentFilterItemQuery);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getControl() != null) {
            return;
        }
        String key = e.getKey();
        String[] keySplit = key.split("_");
        if (keySplit.length > 1 && KEY_MULBD_PREFIX.equals(keySplit[0])) {
            String labelId = keySplit[1];
            IdsFilterItemEdit edit = new IdsFilterItemEdit();
            edit.setKey(key);
            edit.setView(this.getView());
            LabelItem item = new LabelItem();
            item.setId(labelId);
            item.setName(this.getCache().get(KEY_PREDIMENTTYPE_LABEL_NAME + labelId));
            edit.setLabel(item);
            edit.setSubServiceId(this.ctx.getSubServiceId());
            edit.setModelTypeId(this.ctx.getCurModelTypeId());
            edit.setMultiSelect(!Objects.equals(labelId, this.getCache().get(KEY_PREDIMENTTYPE_LAST_LABEL_ID)));
            edit.setBizType(FilterItemBizTypeEnum.MODEL_ANA.getId());
            ArrayList<String> labelIdList = new ArrayList<String>();
            ArrayList<String> allLabelIdList = new ArrayList<String>();
            FilterItemQuery curFilterItemQuery = this.ctx.getCurFilterItemQuery();
            if (curFilterItemQuery != null) {
                List filterItemValuesDTOList = curFilterItemQuery.getFilterItemValuesDTOList();
                for (int i = 0; i < filterItemValuesDTOList.size(); ++i) {
                    FilterItemValuesDTO filterItemValuesDTO = (FilterItemValuesDTO)filterItemValuesDTOList.get(i);
                    allLabelIdList.add(filterItemValuesDTO.getLabelId());
                    if (i == filterItemValuesDTOList.size() - 1) continue;
                    labelIdList.add(filterItemValuesDTO.getLabelId());
                }
            }
            edit.setPrevLabelId(labelIdList);
            edit.setAllLabelId(allLabelIdList);
            edit.setPageCache(this.getCache());
            e.setControl((Control)edit);
        }
    }
}

