/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.query.data.FilterItemQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.service.IAnaResultService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.plugin.form.ModelAnalysisContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.list.SummaryResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;

public class ModelAnalysisLastDetailDataProvider
extends ListDataProvider {
    private static final Log log = LogFactory.getLog(ModelAnalysisLastDetailDataProvider.class);
    private ModelAnalysisContext ctx;

    public ModelAnalysisLastDetailDataProvider setCtx(ModelAnalysisContext ctx) {
        this.ctx = ctx;
        return this;
    }

    public List<SummaryResult> getSummaryResults() {
        ArrayList<SummaryResult> summaryResults = new ArrayList<SummaryResult>();
        RequestContext rc = RequestContext.get();
        FilterItemQuery currentFilterItemQuery = this.ctx.getCurFilterItemQuery();
        BaseResult baseResult = ((IAnaResultService)Services.get(IAnaResultService.class)).getLastDetailListSummary(Long.valueOf(rc.getOrgId()), currentFilterItemQuery);
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            for (String field : AppConstants.PREDICT_DETAIL_SUMMARY_FIELD_ARR) {
                BigDecimal result = dataJo.getBigDecimal(field);
                SummaryResult summaryResult = new SummaryResult(field, result, 1);
                NumberPrecision numberPrecision = new NumberPrecision();
                numberPrecision.setPrecision(0);
                numberPrecision.setResult(result);
                summaryResult.setNumberPrecision(numberPrecision);
                summaryResults.add(summaryResult);
            }
        }
        return summaryResults;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        RequestContext rc;
        boolean isSuperUser;
        this.ctx.setPageSize(limit);
        long current = start == 0 ? 1L : (long)(start / limit + 1);
        List<String> predictDetailFieldList = this.ctx.getPredictDetailFieldList();
        String orderByExpr = this.getOrderByExpr();
        orderByExpr = StringUtils.replace((String)orderByExpr, (String)",id desc", (String)"");
        orderByExpr = StringUtils.replace((String)orderByExpr, (String)"id desc", (String)"");
        String orderField = "";
        if (StringUtils.isNotEmpty((CharSequence)orderByExpr)) {
            orderField = orderByExpr.split(" ")[0];
            if (predictDetailFieldList != null && !predictDetailFieldList.contains(orderField)) {
                orderByExpr = null;
            }
        }
        List qFilterList = this.getQFilters();
        StringBuffer filters = new StringBuffer();
        if (qFilterList != null) {
            String qFilters = qFilterList.toString();
            String[] filterArr = (qFilters = qFilters.substring(1, qFilters.length() - 1)).split(" AND ");
            if (filterArr != null && filterArr.length > 0) {
                for (String filter : filterArr) {
                    String filterField = filter.split(" ")[0];
                    if (predictDetailFieldList == null || !predictDetailFieldList.contains(filterField)) continue;
                    filters = StringUtils.isEmpty((CharSequence)filters.toString()) ? filters.append(filter) : filters.append(" AND ").append(filter);
                }
            }
        }
        if (!(isSuperUser = PermissionServiceHelper.isSuperUser((long)(rc = RequestContext.get()).getCurrUserId()))) {
            QFilter dataQFilter = PermissionServiceHelper.getOperationRuleFilter((String)"ids", (String)IdsFormIdEnum.IDS_PREDICT_DETAIL_L_PERM.getId(), (String)"view", (StringBuilder)new StringBuilder("\u65e0\u6743\u9650\u8bbf\u95ee"));
            if (dataQFilter != null && StringUtils.equalsIgnoreCase((CharSequence)dataQFilter.getProperty(), (CharSequence)"org")) {
                log.info("dataQFilter:{}", (Object)dataQFilter.toString());
                List orgidList = (List)dataQFilter.getValue();
                if (CollectionUtils.isNotEmpty((Collection)orgidList)) {
                    String dataQFilterStr = String.format(" %s ", dataQFilter);
                    filters = StringUtils.isEmpty((CharSequence)filters.toString()) ? filters.append(dataQFilterStr) : filters.append(" AND ").append(dataQFilterStr);
                }
            }
        } else {
            log.info("{}({}) is superUser", (Object)rc.getUserName(), (Object)rc.getCurrUserId());
        }
        log.info("filters : {}", (Object)filters);
        FilterItemQuery currentFilterItemQuery = this.ctx.getCurFilterItemQuery();
        currentFilterItemQuery.setCurrent(Long.valueOf(current));
        currentFilterItemQuery.setSize(Long.valueOf(limit));
        currentFilterItemQuery.setOrderByExpr(orderByExpr);
        currentFilterItemQuery.setFilters(filters.toString());
        currentFilterItemQuery.setNeedRecord(Boolean.valueOf(true));
        this.ctx.setCurFilterItemQuery(currentFilterItemQuery);
        IAnaResultService anaResultService = (IAnaResultService)Services.get(IAnaResultService.class);
        BaseResult baseResult = anaResultService.getLastDetailList(Long.valueOf(rc.getOrgId()), currentFilterItemQuery);
        DynamicObjectType dynamicObjectType = new DynamicObjectType("ids_predict_details");
        DynamicObjectCollection data = new DynamicObjectCollection(dynamicObjectType, null);
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            this.ctx.setCurLastDetailBaseResult(baseResult);
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            String[] properties = new String[]{};
            String[] lowerProperties = new String[]{};
            String[] propertyTypes = new String[]{};
            JSONArray fieldsJa = dataJo.getJSONArray("fields");
            if (fieldsJa != null && !fieldsJa.isEmpty()) {
                properties = new String[fieldsJa.size()];
                lowerProperties = new String[fieldsJa.size()];
                propertyTypes = new String[fieldsJa.size()];
                for (int i = 0; i < fieldsJa.size(); ++i) {
                    String fieldId;
                    JSONObject fieldJo = fieldsJa.getJSONObject(i);
                    properties[i] = fieldId = fieldJo.getString("id");
                    lowerProperties[i] = fieldId != null ? fieldId.toLowerCase() : null;
                    propertyTypes[i] = fieldJo.getString("fieldType");
                }
            }
            for (int p = 0; p < properties.length; ++p) {
                String prop = lowerProperties[p];
                DynamicSimpleProperty dsp = null;
                try {
                    dsp = new DynamicSimpleProperty(prop, Class.forName(propertyTypes[p]), null);
                }
                catch (ClassNotFoundException e) {
                    CommonUtil.getStackTrace((Exception)e);
                }
                dynamicObjectType.addProperty(dsp);
            }
            JSONObject resultJo = dataJo.getJSONObject("result");
            JSONArray recordsJa = resultJo.getJSONArray("records");
            long total = resultJo.getLongValue("total");
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
            if (recordsJa != null && !recordsJa.isEmpty()) {
                for (int i = 0; i < recordsJa.size(); ++i) {
                    JSONObject recordJo = recordsJa.getJSONObject(i);
                    dataList.add(recordJo);
                    DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                    for (int p = 0; p < properties.length; ++p) {
                        String property = properties[p];
                        if (property == null) continue;
                        Object val = recordJo.get((Object)property);
                        String decimalType = BigDecimal.class.toString();
                        if (propertyTypes[p].equals(decimalType.split(" ")[1])) {
                            val = val == null ? Integer.valueOf(0) : val.toString().replace(",", "");
                        }
                        dynamicObject.set(lowerProperties[p], val);
                    }
                    data.add((Object)dynamicObject);
                }
                this.getQueryResult().setCollection(data);
                this.getQueryResult().setDataCount((int)total);
                this.ctx.getCache().put("total", String.valueOf(total));
            }
            this.ctx.setBillDataList(dataList);
        } else {
            this.ctx.setCurLastDetailBaseResult(BaseResult.fail((String)"", (String)""));
        }
        return data;
    }

    public int getRealCount() {
        return Integer.parseInt(this.ctx.getCache().get("total"));
    }

    public int getMaxCount() {
        return Integer.parseInt(this.ctx.getCache().get("total"));
    }
}

