/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.ai.ids.core.enumtype.AppConfigParameterEnum;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.enumtype.MarkTypeEnum;
import kd.ai.ids.core.enumtype.OutlierTagTypeEnum;
import kd.ai.ids.core.enumtype.SubParameterScopeEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.query.data.DeleteDataMarkQuery;
import kd.ai.ids.core.query.data.SaveDataMarkQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.ShowTipsTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;

public class OutlierMarkDetailPlugin
extends BaseFormPlugin
implements ListboxClickListener,
ItemClickListener,
PagerClickListener,
SelectRowsEventListener,
TabSelectListener {
    private static final String KEY_CUSTOMCONTROLAP = "ai_ids_error_mark_line";
    private static final String CHART_TYPE_KEY = "error_mark_line";
    private static final String EVENT_REFRESH_BILL_LIST = "refreshBillList";
    private static final String KEY_ENTRY_ENTITY_BILL = "billentryentity";
    private static final String KEY_ENTRY_ENTITY_ITEM = "itementryentity";
    private static final String KEY_TAG = "tag";
    private static final String KEY_CUSTOM_TAG = "customtag";
    private static final String KEY_MARK_ITEM_ENTRY_PREFIX = "item_";
    private static final String KEY_MARK_ITEM_FWEIGHT = "item_fweight";
    private static final String KEY_MARK_ITEM_TAG = "item_ftag";
    private static final String KEY_MARK_ITEM_ID = "item_id";
    private static final String KEY_F_ENTRY_ID = "fentryid";
    private static final String KEY_LABEL_PRE_DIMEN_TYPE_CODE_NAME = "predimentypecodename";
    private static final String KEY_IS_INIT_PAGE_DATA = "is_init_page_data";
    private static final String KEY_LIST_BOX_OUTLIER = "listboxoutlier";
    private static final String KEY_CURRENT_MARK_TYPE = "current_mark_type";
    private static final String KEY_LIST_BOX_CURRENT_ITEM = "listbox_current_item";
    private static final String KEY_LIST_BOX_ITEM_BILL_ENTRY = "billentry";
    private static final String KEY_LIST_BOX_ITEM_MARK_ENTRY = "markentry";
    private static final String KEY_BTN_DEL_MARK = "baritemdelmark";
    private static final String KEY_BTN_BATCH_FILL = "baritembatchfill";
    private static final String KEY_BTN_BATCH_MARK = "baritembatchmark";
    private static final String KEY_BTN_ITEM_ADD = "btnitemadd";
    private static final String KEY_BTN_ITEM_DEL = "btnitemdel";
    private static final String KEY_DATE_RANGE = "daterange";
    private static final String KEY_F_START_DATE = "fstartdate";
    private static final String KEY_F_END_DATE = "fenddate";
    private static final String KEY_IS_BATCH_OPERATION = "isBatchOperation";
    private static final String KEY_FLEX_BILL_MARK = "flexbillmark";
    private static final String KEY_FLEX_ITEM_MARK = "flexitemmark";
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_TAB_KEY_ITEM = "tabitem";
    private static final String KEY_TAB_KEY_BILL = "tabbill";

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    private String getModeltypeId() {
        return this.getCache().get("modeltypeId");
    }

    private String getCurrentListboxItem() {
        return this.getCache().get(KEY_LIST_BOX_CURRENT_ITEM);
    }

    private String getCurrentFmarktype() {
        return this.getCache().get(KEY_CURRENT_MARK_TYPE);
    }

    private boolean getIsBatchOperation() {
        String isBatchOperationStr = this.getCache().get(KEY_IS_BATCH_OPERATION);
        boolean isBatchOperation = StringUtils.isEmpty((CharSequence)isBatchOperationStr) || Boolean.parseBoolean(isBatchOperationStr);
        return isBatchOperation;
    }

    private String getFpredimentypeCode() {
        return this.getCache().get("fpredimentypeCode");
    }

    private boolean getIsInitPageData() {
        String isInit = this.getCache().get(KEY_IS_INIT_PAGE_DATA);
        return StringUtils.isNotEmpty((CharSequence)isInit) ? Boolean.parseBoolean(isInit) : false;
    }

    @Override
    public void initialize() {
        super.initialize();
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_DEL_MARK, KEY_BTN_BATCH_MARK, KEY_BTN_BATCH_FILL, KEY_BTN_ITEM_ADD, KEY_BTN_ITEM_DEL});
        Listbox box = (Listbox)this.getView().getControl(KEY_LIST_BOX_OUTLIER);
        box.addListboxClickListener((ListboxClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY_BILL);
        entryGrid.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent cellClickEvent) {
                OutlierMarkDetailPlugin.this.getCache().put(OutlierMarkDetailPlugin.KEY_IS_BATCH_OPERATION, Boolean.FALSE.toString());
            }

            public void cellDoubleClick(CellClickEvent cellClickEvent) {
                OutlierMarkDetailPlugin.this.getCache().put(OutlierMarkDetailPlugin.KEY_IS_BATCH_OPERATION, Boolean.FALSE.toString());
            }
        });
        EntryGrid itemEntryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY_ITEM);
        itemEntryGrid.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent cellClickEvent) {
                OutlierMarkDetailPlugin.this.getCache().put(OutlierMarkDetailPlugin.KEY_IS_BATCH_OPERATION, Boolean.FALSE.toString());
            }

            public void cellDoubleClick(CellClickEvent cellClickEvent) {
                OutlierMarkDetailPlugin.this.getCache().put(OutlierMarkDetailPlugin.KEY_IS_BATCH_OPERATION, Boolean.FALSE.toString());
            }
        });
        entryGrid.addPagerClickListener(new PagerClickListener(){

            public void pagerClick(PagerClickEvent pagerClickEvent) {
                int currentPageIndex = pagerClickEvent.getCurrentPageIndex();
                OutlierMarkDetailPlugin.this.log.info("currentPageIndex:{}", (Object)currentPageIndex);
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        RequestContext rc = RequestContext.get();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_DEL_MARK, (CharSequence)evtKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY_BILL);
            DynamicObjectCollection entityDoc = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY_BILL);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> fentryidList = new ArrayList<String>(10);
            String fmarktype = MarkTypeEnum.BILL.getId();
            for (int selectRow : selectRows) {
                DynamicObject dynamicObject = (DynamicObject)entityDoc.get(selectRow);
                fentryidList.add(dynamicObject.getString(KEY_F_ENTRY_ID));
            }
            DeleteDataMarkQuery deleteDataMarkQuery = new DeleteDataMarkQuery();
            deleteDataMarkQuery.setFpredimentypeCode(this.getFpredimentypeCode());
            deleteDataMarkQuery.setSubServiceId(this.getSubServiceId());
            deleteDataMarkQuery.setFuserid(rc.getUid());
            deleteDataMarkQuery.setFusername(rc.getUserName());
            deleteDataMarkQuery.setFentryidList(fentryidList);
            BaseResult baseResult = this.dataMarkService().deleteBatchMark(Long.valueOf(rc.getOrgId()), deleteDataMarkQuery);
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"Common_Delete_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
                this.loadBillEntryList();
                this.loadLineData(null, null);
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u5220\u9664\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u5220\u9664\u6210\u529f", fmarktype, this.getFpredimentypeCode()));
            } else {
                this.getView().showErrorNotification(baseResult.getDescriptionCn());
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u5220\u9664\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u5220\u9664\u5931\u8d25", fmarktype, this.getFpredimentypeCode()));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_BATCH_MARK, (CharSequence)evtKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY_BILL);
            DynamicObjectCollection entityDoc = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY_BILL);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> fentryidList = new ArrayList<String>(10);
            DynamicObject singleDo = null;
            for (int selectRow : selectRows) {
                DynamicObject dynamicObject = (DynamicObject)entityDoc.get(selectRow);
                fentryidList.add(dynamicObject.getString(KEY_F_ENTRY_ID));
                if (singleDo != null) continue;
                singleDo = dynamicObject;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ids_mark_outlier_tag_dlg");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("outlierTagType", OutlierTagTypeEnum.BILL.getKey());
            customParams.put("fmodeltypeid", this.getModeltypeId());
            customParams.put("fentryids", org.apache.commons.lang3.StringUtils.join(fentryidList, (String)","));
            customParams.put("fpredimentypeCode", this.getFpredimentypeCode());
            customParams.put("subServiceId", this.getSubServiceId());
            customParams.put("fmarktype", MarkTypeEnum.BILL.getId());
            if (fentryidList.size() == 1 && singleDo != null && (StringUtils.isNotEmpty((CharSequence)singleDo.getString(KEY_TAG)) || StringUtils.isNotEmpty((CharSequence)singleDo.getString(KEY_CUSTOM_TAG)))) {
                customParams.put("isMark", YesNoEnum.YES.getKey());
                customParams.put("ftag", singleDo.getString(KEY_TAG));
                customParams.put("fcustomTag", singleDo.getString(KEY_CUSTOM_TAG));
                customParams.put("fstartDate", null);
                customParams.put("fendDate", null);
            }
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BTN_BATCH_MARK));
            this.getView().showForm(showParameter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_BATCH_FILL, (CharSequence)evtKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY_BILL);
            EntryData entryData = entryGrid.getEntryData();
            Map data = entryData.getData();
            int totalPages = data.getOrDefault("pagecount", 0);
            int pageRows = data.getOrDefault("pagerows", 10);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY_BILL);
            int pageIndex = entryCurrentRowIndex / pageRows;
            int entryRowCount = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY_BILL);
            String entryCurrentFieldKey = this.getModel().getEntryCurrentFieldKey(KEY_ENTRY_ENTITY_BILL);
            if (StringUtils.isEmpty((CharSequence)entryCurrentFieldKey) || StringUtils.equalsIgnoreCase((CharSequence)entryCurrentFieldKey, (CharSequence)"0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u5355\u5143\u683c", (String)"Common_Select_Operation_Cell", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            Object customtag = this.getModel().getValue(entryCurrentFieldKey, entryCurrentRowIndex);
            int currentPageIndexTotal = pageIndex == totalPages - 1 ? entryRowCount : (pageIndex + 1) * pageRows;
            this.getCache().put(KEY_IS_BATCH_OPERATION, Boolean.TRUE.toString());
            for (int i = entryCurrentRowIndex; i < currentPageIndexTotal; ++i) {
                this.getModel().setValue(entryCurrentFieldKey, customtag, i);
            }
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
            ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.SUCCESS);
            this.loadLineData(null, null);
            LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u6807\u6ce8-\u6210\u529f", MarkTypeEnum.BILL.getId(), this.getFpredimentypeCode()));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_ITEM_ADD, (CharSequence)evtKey)) {
            List<String> fpredimentypeCodeList = Collections.singletonList(this.getFpredimentypeCode());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ids_mark_outlier_tag_dlg");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("fpredimentypeCodeList", fpredimentypeCodeList);
            customParams.put("fmarktype", MarkTypeEnum.ITEM.getId());
            customParams.put("subServiceId", this.getSubServiceId());
            customParams.put("isMark", YesNoEnum.NO.getKey());
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BTN_ITEM_ADD));
            this.getView().showForm(showParameter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_ITEM_DEL, (CharSequence)evtKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY_ITEM);
            DynamicObjectCollection entityDoc = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY_ITEM);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> idList = new ArrayList<Long>(10);
            for (int selectRow : selectRows) {
                DynamicObject dynamicObject = (DynamicObject)entityDoc.get(selectRow);
                idList.add(dynamicObject.getLong(KEY_MARK_ITEM_ID));
            }
            DeleteDataMarkQuery deleteDataMarkQuery = new DeleteDataMarkQuery();
            deleteDataMarkQuery.setFpredimentypeCode(this.getFpredimentypeCode());
            deleteDataMarkQuery.setSubServiceId(this.getSubServiceId());
            deleteDataMarkQuery.setFuserid(rc.getUid());
            deleteDataMarkQuery.setFusername(rc.getUserName());
            deleteDataMarkQuery.setIdList(idList);
            BaseResult baseResult = this.dataMarkService().deleteBatchMark(Long.valueOf(rc.getOrgId()), deleteDataMarkQuery);
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"Common_Delete_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
                this.loadItemMarkList();
                this.loadLineData(null, null);
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u5220\u9664\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u5220\u9664\u6210\u529f", MarkTypeEnum.ITEM.getId(), this.getFpredimentypeCode()));
            } else {
                this.getView().showErrorNotification(baseResult.getDescriptionCn());
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u5220\u9664\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u5220\u9664\u5931\u8d25", MarkTypeEnum.ITEM.getId(), this.getFpredimentypeCode()));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        RequestContext rc = RequestContext.get();
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        boolean isInitPageData = this.getIsInitPageData();
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATE_RANGE);
        String dateRangeStartDate = dateRangeEdit.getStartDateFieldKey();
        String dateRangeEndDate = dateRangeEdit.getEndDateFieldKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_TAG)) {
            if (!isInitPageData) {
                ChangeData newData = changeData[0];
                String ftag = newData.getNewValue() != null ? changeData[0].getNewValue().toString() : "";
                ftag = StrUtils.trimSplitChar((String)ftag);
                String ftagname = "";
                if (StringUtils.isNotEmpty((CharSequence)ftag)) {
                    DynamicObject tagDo = BusinessDataServiceHelper.loadSingle((String)"ids_mark_outlier_tag", (String)"name,status,allowtimeconfig", (QFilter[])new QFilter("number", "=", (Object)ftag).toArray());
                    if (tagDo == null) {
                        String msg = ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u3010%s\u3011\u5df2\u88ab\u5220\u9664\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"MarkOutlierTagDlgFormPlugin_4", (String)"ai-ids-plugin", (Object[])new Object[0]);
                        ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), String.format(msg, ftag), BaseResult.FAIL);
                        return;
                    }
                    if (!tagDo.getBoolean("status")) {
                        String msg = ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u3010%s\u3011\u5df2\u88ab\u7981\u7528\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"MarkOutlierTagDlgFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]);
                        ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), String.format(msg, ftag), BaseResult.FAIL);
                        return;
                    }
                    ftagname = tagDo.getString("name");
                }
                DynamicObject dataEntity = newData.getDataEntity();
                String fentryid = dataEntity.getString(KEY_F_ENTRY_ID);
                String customTag = dataEntity.getString(KEY_CUSTOM_TAG);
                customTag = StrUtils.trimSplitChar((String)customTag);
                String markType = MarkTypeEnum.BILL.getId();
                SaveDataMarkQuery saveDataMarkQuery = new SaveDataMarkQuery();
                saveDataMarkQuery.setFtag(ftag);
                saveDataMarkQuery.setFtagtype(OutlierTagTypeEnum.BILL.getKey());
                saveDataMarkQuery.setFtagname(ftagname);
                saveDataMarkQuery.setFpredimentypeCodeList(Collections.singletonList(this.getFpredimentypeCode()));
                saveDataMarkQuery.setFmarktype(markType);
                saveDataMarkQuery.setFcustomTag(customTag);
                saveDataMarkQuery.setFuserid(rc.getUid());
                saveDataMarkQuery.setFusername(rc.getUserName());
                saveDataMarkQuery.setSubServiceId(this.getSubServiceId());
                saveDataMarkQuery.setFentryidList(Collections.singletonList(fentryid));
                BaseResult baseResult = this.dataMarkService().saveDataMark(Long.valueOf(rc.getOrgId()), saveDataMarkQuery);
                if (!this.getIsBatchOperation()) {
                    if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                        String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
                        ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.SUCCESS);
                        this.loadLineData(null, null);
                        LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u6807\u6ce8-\u6210\u529f", markType, this.getFpredimentypeCode()));
                        if (StringUtils.isEmpty((CharSequence)customTag) && StringUtils.isEmpty((CharSequence)ftag)) {
                            this.getModel().deleteEntryRow(KEY_ENTRY_ENTITY_BILL, newData.getRowIndex());
                            this.loadBillEntryList();
                        }
                    } else {
                        this.getView().showErrorNotification(baseResult.getDescriptionCn());
                        LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u6807\u6ce8-\u5931\u8d25", markType, this.getFpredimentypeCode()));
                    }
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_CUSTOM_TAG)) {
            if (!isInitPageData) {
                ChangeData newData = changeData[0];
                String customTag = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
                DynamicObject dataEntity = newData.getDataEntity();
                String fentryid = dataEntity.getString(KEY_F_ENTRY_ID);
                String ftag = dataEntity.getString(KEY_TAG);
                String ftagname = null;
                if (StringUtils.isNotEmpty((CharSequence)ftag)) {
                    DynamicObject tagDo = BusinessDataServiceHelper.loadSingle((String)"ids_mark_outlier_tag", (String)"name,status,allowtimeconfig", (QFilter[])new QFilter("number", "=", (Object)ftag).toArray());
                    ftagname = tagDo.getString("name");
                }
                customTag = StrUtils.trimSplitChar((String)customTag);
                ftag = StrUtils.trimSplitChar((String)ftag);
                String markType = MarkTypeEnum.BILL.getId();
                SaveDataMarkQuery saveDataMarkQuery = new SaveDataMarkQuery();
                saveDataMarkQuery.setFtag(ftag);
                saveDataMarkQuery.setFtagtype(OutlierTagTypeEnum.BILL.getKey());
                saveDataMarkQuery.setFtagname(ftagname);
                saveDataMarkQuery.setFpredimentypeCodeList(Collections.singletonList(this.getFpredimentypeCode()));
                saveDataMarkQuery.setFmarktype(markType);
                saveDataMarkQuery.setFcustomTag(customTag);
                saveDataMarkQuery.setFuserid(rc.getUid());
                saveDataMarkQuery.setFusername(rc.getUserName());
                saveDataMarkQuery.setSubServiceId(this.getSubServiceId());
                saveDataMarkQuery.setFentryidList(Collections.singletonList(fentryid));
                BaseResult baseResult = this.dataMarkService().saveDataMark(Long.valueOf(rc.getOrgId()), saveDataMarkQuery);
                if (!this.getIsBatchOperation()) {
                    if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                        String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
                        ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.SUCCESS);
                        this.loadLineData(null, null);
                        LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u81ea\u5b9a\u4e49\u6807\u6ce8-\u6210\u529f", markType, this.getFpredimentypeCode()));
                        if (StringUtils.isEmpty((CharSequence)customTag) && StringUtils.isEmpty((CharSequence)ftag)) {
                            this.getModel().deleteEntryRow(KEY_ENTRY_ENTITY_BILL, newData.getRowIndex());
                            this.loadBillEntryList();
                        }
                    } else {
                        this.getView().showErrorNotification(baseResult.getDescriptionCn());
                        LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u81ea\u5b9a\u4e49\u6807\u6ce8-\u5931\u8d25", markType, this.getFpredimentypeCode()));
                    }
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)dateRangeEndDate) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)dateRangeStartDate)) {
            Date startDate = (Date)this.getModel().getValue(dateRangeStartDate);
            Date endDate = (Date)this.getModel().getValue(dateRangeEndDate);
            String fstartDate = null;
            String fendDate = null;
            if (startDate != null && endDate != null) {
                fstartDate = KDDateFormatUtils.getDateFormat().format(startDate);
                fendDate = KDDateFormatUtils.getDateFormat().format(endDate);
                if (KDDateUtils.addDays((Date)startDate, (int)30).before(endDate)) {
                    this.getView().showTipNotification(String.format("[%s ~ %s]\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc731\u5929", fstartDate, fendDate));
                    return;
                }
            } else {
                return;
            }
            this.loadLineData(fstartDate, fendDate);
            this.loadBillEntryList();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_BILL_MARK});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_ITEM_MARK});
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.getCache().put("subServiceId", subServiceId);
        this.getCache().put(KEY_LIST_BOX_CURRENT_ITEM, KEY_LIST_BOX_ITEM_BILL_ENTRY);
        this.getCache().put(KEY_CURRENT_MARK_TYPE, MarkTypeEnum.ITEM.getId());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fpredimentypeCode = (String)formShowParameter.getCustomParam("fpredimentypeCode");
        String fpredimentypeCodeName = (String)formShowParameter.getCustomParam("fpredimentypeCodeName");
        this.setLabelText(KEY_LABEL_PRE_DIMEN_TYPE_CODE_NAME, StringUtils.isNotEmpty((CharSequence)fpredimentypeCodeName) ? StringUtils.join((Object[])fpredimentypeCodeName.split("->"), (String)">") : "");
        String modeltypeId = (String)formShowParameter.getCustomParam("modeltypeId");
        this.getCache().put("fpredimentypeCode", fpredimentypeCode);
        this.getCache().put("modeltypeId", modeltypeId);
        Listbox listbox = (Listbox)this.getView().getControl(KEY_LIST_BOX_OUTLIER);
        ListboxItem billEntryItem = new ListboxItem(KEY_LIST_BOX_ITEM_BILL_ENTRY, ResManager.loadKDString((String)"\u5355\u636e\u660e\u7ec6", (String)"OutlierMarkDetailPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]));
        ListboxItem markEntryItem = new ListboxItem(KEY_LIST_BOX_ITEM_MARK_ENTRY, ResManager.loadKDString((String)"\u5df2\u6807\u6ce8", (String)"OutlierMarkDetailPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]));
        ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>();
        itemlist.add(billEntryItem);
        itemlist.add(markEntryItem);
        listbox.addItems(itemlist);
        this.setEntryVisible();
        if (StringUtils.isNotEmpty((CharSequence)this.getFpredimentypeCode())) {
            this.loadLineData(null, null);
            this.loadItemMarkList();
        }
    }

    private void loadLineData(String fstartDate, String fendDate) {
        JSONArray tagJa = new JSONArray();
        RequestContext rc = RequestContext.get();
        JSONObject dataJo = this.dataOutlierAnaService().getMaterialSaleTrendNomodeltype(Long.valueOf(rc.getOrgId()), this.getSubServiceId(), this.getModeltypeId(), this.getFpredimentypeCode());
        dataJo.put("fmarktype", (Object)this.getCurrentFmarktype());
        dataJo.put("fstartDate", (Object)fstartDate);
        dataJo.put("fendDate", (Object)fendDate);
        dataJo.put("tagList", (Object)tagJa);
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("containerId", KEY_CUSTOMCONTROLAP);
        customData.put("chartType", CHART_TYPE_KEY);
        customData.put("uniqueCode", this.getFpredimentypeCode() + "_" + this.getCurrentFmarktype());
        customData.put("data", dataJo);
        customData.put("timestamp", new Date().getTime());
        customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        customData.put("pageId", this.getView().getPageId());
        CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOMCONTROLAP);
        customControl.setData(customData);
    }

    private Map<String, String> getStartEndDateMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATE_RANGE);
        String dateRangeStartDate = dateRangeEdit.getStartDateFieldKey();
        String dateRangeEndDate = dateRangeEdit.getEndDateFieldKey();
        Date startDate = (Date)this.getModel().getValue(dateRangeStartDate);
        Date endDate = (Date)this.getModel().getValue(dateRangeEndDate);
        String fstartDate = null;
        String fendDate = null;
        if (startDate != null) {
            fstartDate = KDDateFormatUtils.getDateFormat().format(startDate);
        }
        if (endDate != null) {
            fendDate = KDDateFormatUtils.getDateFormat().format(endDate);
        }
        map.put(KEY_F_START_DATE, fstartDate);
        map.put(KEY_F_END_DATE, fendDate);
        return map;
    }

    private void loadBillEntryList() {
        String listType = this.getCurrentListboxItem();
        Map<String, String> startEndDateMap = this.getStartEndDateMap();
        String fstartDate = startEndDateMap.get(KEY_F_START_DATE);
        String fendDate = startEndDateMap.get(KEY_F_END_DATE);
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY_BILL);
        this.getCache().put(KEY_IS_INIT_PAGE_DATA, "true");
        RequestContext rc = RequestContext.get();
        HashMap<String, Boolean> metadata = new HashMap<String, Boolean>();
        if (StringUtils.equalsIgnoreCase((CharSequence)listType, (CharSequence)KEY_LIST_BOX_ITEM_MARK_ENTRY)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_DEL_MARK});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_BATCH_FILL});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_BATCH_MARK});
            metadata.put("selchexkbox", Boolean.TRUE);
            metadata.put("ismul", Boolean.TRUE);
        }
        JSONObject dataJo = this.dataOutlierAnaService().getBillEntryNoModeltype(Long.valueOf(rc.getOrgId()), this.getSubServiceId(), this.getFpredimentypeCode(), null, 1, Integer.MAX_VALUE, listType, fstartDate, fendDate);
        this.getView().updateControlMetadata(KEY_ENTRY_ENTITY_BILL, metadata);
        JSONObject resultJo = dataJo.getJSONObject("result");
        DynamicObject[] tagArr = BusinessDataServiceHelper.load((String)"ids_mark_outlier_tag", (String)"number,name", (QFilter[])new QFilter("type", "=", (Object)OutlierTagTypeEnum.BILL.getKey()).and("status", "=", (Object)YesNoEnum.YES.getKeyStr()).toArray());
        if (tagArr == null) {
            return;
        }
        JSONArray fieldJa = dataJo.getJSONArray("fields");
        JSONArray recordJa = resultJo.getJSONArray("records");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY_BILL);
        if (recordJa != null && !recordJa.isEmpty()) {
            this.setEntryVisible();
            List controls = entryGrid.getControls();
            for (Control control : controls) {
                if (!(control instanceof ComboEdit)) continue;
                ComboEdit comboEdit = (ComboEdit)control;
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
                if (!comboEdit.getKey().equals(KEY_TAG)) continue;
                for (int i = 0; i < tagArr.length; ++i) {
                    DynamicObject tagDo = tagArr[i];
                    String fnumber = tagDo.getString("number");
                    String fname = tagDo.getString("name");
                    LocaleString comboItemText = new LocaleString(fname);
                    ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(fnumber));
                    comboItemList.add(comboItem);
                    comboEdit.setEnable("s", true, i);
                }
                comboEdit.setComboItems(comboItemList);
            }
            int rowCount = recordJa.size();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY_BILL, rowCount);
            for (int i = 0; i < rowCount; ++i) {
                JSONObject jo = recordJa.getJSONObject(i);
                for (Object fieldO : fieldJa) {
                    JSONObject fieldJo = JSON.parseObject((String)JSON.toJSONString(fieldO));
                    String key = fieldJo.getString("id");
                    Object value = jo.get((Object)key);
                    this.getModel().setValue(key.toLowerCase(), value, rowIndex[i]);
                }
            }
            entryGrid.setSplitPage(true);
            entryGrid.setPageIndex(resultJo.getInteger("current").intValue());
            entryGrid.setPageRow(10);
            entryGrid.setPageRows(10);
        } else {
            this.setEntryVisible();
        }
        Optional.ofNullable(entryGrid).ifPresent(e -> {
            e.setColumnProperty("ftagtype", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty(KEY_TAG, "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty(KEY_CUSTOM_TAG, "isFixed", (Object)Boolean.TRUE);
        });
        this.getCache().put(KEY_IS_INIT_PAGE_DATA, "false");
    }

    private void loadItemMarkList() {
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY_ITEM);
        this.getCache().put(KEY_IS_INIT_PAGE_DATA, "true");
        RequestContext rc = RequestContext.get();
        HashMap<String, Boolean> metadata = new HashMap<String, Boolean>();
        metadata.put("selchexkbox", Boolean.TRUE);
        metadata.put("ismul", Boolean.TRUE);
        this.getView().updateControlMetadata(KEY_ENTRY_ENTITY_ITEM, metadata);
        JSONObject dataJo = this.dataMarkService().getMarkList(Long.valueOf(rc.getOrgId()), this.getSubServiceId(), this.getFpredimentypeCode(), MarkTypeEnum.ITEM.getId(), 1L, Integer.MAX_VALUE);
        if (dataJo == null) {
            return;
        }
        JSONObject resultJo = dataJo.getJSONObject("result");
        DynamicObject[] tagArr = BusinessDataServiceHelper.load((String)"ids_mark_outlier_tag", (String)"number,name", (QFilter[])new QFilter("status", "=", (Object)YesNoEnum.YES.getKeyStr()).and("type", "not in", Arrays.asList(OutlierTagTypeEnum.BILL.getKey(), OutlierTagTypeEnum.DATE.getKey())).toArray());
        if (tagArr == null) {
            return;
        }
        JSONArray fieldJa = dataJo.getJSONArray("fields");
        JSONArray recordJa = resultJo.getJSONArray("records");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY_ITEM);
        boolean enableMarkFweight = this.commonService().getBooleanValue(Long.valueOf(rc.getOrgId()), this.getSubServiceId(), SubParameterScopeEnum.MODEL_RESULT_PARAMETER.getKey(), AppConfigParameterEnum.ENABLE_MARK_WEIGHT.getId());
        List fieldEdits = entryGrid.getFieldEdits();
        for (Object fieldEdit : fieldEdits) {
            if (enableMarkFweight || !fieldEdit.getFieldKey().equals(KEY_MARK_ITEM_FWEIGHT)) continue;
            fieldEdit.setVisible(KEY_MARK_ITEM_FWEIGHT, false);
        }
        if (recordJa != null && !recordJa.isEmpty()) {
            this.setEntryVisible();
            List controls = entryGrid.getControls();
            for (Control control : controls) {
                if (!(control instanceof ComboEdit)) continue;
                ComboEdit comboEdit = (ComboEdit)control;
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
                if (!comboEdit.getKey().equals(KEY_MARK_ITEM_TAG)) continue;
                for (int i = 0; i < tagArr.length; ++i) {
                    DynamicObject tagDo = tagArr[i];
                    String fnumber = tagDo.getString("number");
                    String fname = tagDo.getString("name");
                    LocaleString comboItemText = new LocaleString(fname);
                    ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(fnumber));
                    comboItemList.add(comboItem);
                    comboEdit.setEnable("s", true, i);
                }
                comboEdit.setComboItems(comboItemList);
            }
            int rowCount = recordJa.size();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY_ITEM, rowCount);
            for (int i = 0; i < rowCount; ++i) {
                JSONObject jo = recordJa.getJSONObject(i);
                for (Object fieldO : fieldJa) {
                    JSONObject fieldJo = JSON.parseObject((String)JSON.toJSONString(fieldO));
                    String key = fieldJo.getString("id");
                    Object value = jo.get((Object)key);
                    this.getModel().setValue(KEY_MARK_ITEM_ENTRY_PREFIX + key.toLowerCase(), value, rowIndex[i]);
                }
            }
            entryGrid.setSplitPage(true);
            entryGrid.setPageIndex(resultJo.getInteger("current").intValue());
            entryGrid.setPageRow(10);
            entryGrid.setPageRows(10);
        } else {
            this.setEntryVisible();
        }
        this.getCache().put(KEY_IS_INIT_PAGE_DATA, "false");
    }

    private void setEntryVisible() {
        if (StringUtils.isEmpty((CharSequence)this.getCurrentListboxItem()) || StringUtils.equalsIgnoreCase((CharSequence)KEY_LIST_BOX_ITEM_BILL_ENTRY, (CharSequence)this.getCurrentListboxItem())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRY_ENTITY_BILL});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_BATCH_FILL});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_BATCH_MARK});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_LIST_BOX_ITEM_MARK_ENTRY, (CharSequence)this.getCurrentListboxItem())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRY_ENTITY_BILL});
        }
    }

    public void customEvent(CustomEventArgs e) {
        RequestContext rc = RequestContext.get();
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        JSONObject args = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)eventArgs)) {
            args = JSON.parseObject((String)eventArgs);
        }
        if (KEY_CUSTOMCONTROLAP.equals(controlKey)) {
            CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOMCONTROLAP);
            if (EVENT_REFRESH_BILL_LIST.equalsIgnoreCase(eventName)) {
                String fbiztime = args.getString("fdate");
                String fstartdate = args.getString(KEY_F_START_DATE);
                String fenddate = args.getString(KEY_F_END_DATE);
                if (StringUtils.isEmpty((CharSequence)fstartdate) && StringUtils.isNotEmpty((CharSequence)fbiztime)) {
                    fstartdate = fbiztime;
                }
                if (StringUtils.isEmpty((CharSequence)fenddate) && StringUtils.isNotEmpty((CharSequence)fbiztime)) {
                    fenddate = fbiztime;
                }
                DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATE_RANGE);
                String dateRangeStartDate = dateRangeEdit.getStartDateFieldKey();
                String dateRangeEndDate = dateRangeEdit.getEndDateFieldKey();
                Date startDate = KDDateUtils.parseDate((String)fstartdate);
                Date endDate = KDDateUtils.parseDate((String)fenddate);
                if (startDate != null && endDate != null && KDDateUtils.addDays((Date)startDate, (int)30).before(endDate)) {
                    this.getView().showTipNotification(String.format("[%s ~ %s]\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc731\u5929", fstartdate, fenddate));
                    return;
                }
                this.getModel().setValue(dateRangeStartDate, (Object)DateUtils.parseDate((String)fstartdate, (String)"yyyy-MM-dd"));
                this.getModel().setValue(dateRangeEndDate, (Object)DateUtils.parseDate((String)fenddate, (String)"yyyy-MM-dd"));
                this.getCache().put(KEY_F_START_DATE, fstartdate);
                this.getCache().put(KEY_F_END_DATE, fenddate);
                this.getCache().put(KEY_LIST_BOX_CURRENT_ITEM, KEY_LIST_BOX_ITEM_BILL_ENTRY);
                this.loadBillEntryList();
                Listbox listbox = (Listbox)this.getView().getControl(KEY_LIST_BOX_OUTLIER);
                listbox.activeItem(KEY_LIST_BOX_ITEM_BILL_ENTRY);
            } else if ("showTip".equalsIgnoreCase(eventName)) {
                if (args.getIntValue("errcode") == BaseResult.SUCCESS.intValue()) {
                    this.getView().showSuccessNotification(args.getString("descriptionCn"));
                } else {
                    this.getView().showErrorNotification(args.getString("descriptionCn"));
                }
            }
        }
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        this.getCache().put(KEY_LIST_BOX_CURRENT_ITEM, itemId);
        Map<String, String> startEndDateMap = this.getStartEndDateMap();
        String fstartDate = startEndDateMap.get(KEY_F_START_DATE);
        String fendDate = startEndDateMap.get(KEY_F_END_DATE);
        this.loadLineData(fstartDate, fendDate);
        this.loadBillEntryList();
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        RequestContext rc = RequestContext.get();
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_BTN_BATCH_MARK)) {
            if (returnData != null) {
                JSONObject saveMarkResultJo = JsonUtils.parseObj((Object)returnData);
                String markType = saveMarkResultJo.getString("fmarktype");
                if (saveMarkResultJo.getBooleanValue("status") && StringUtils.equalsIgnoreCase((CharSequence)markType, (CharSequence)MarkTypeEnum.BILL.getId())) {
                    EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY_BILL);
                    int[] selectRows = entryGrid.getSelectRows();
                    if (selectRows == null || selectRows.length == 0) {
                        return;
                    }
                    String ftag = saveMarkResultJo.getString("ftag");
                    String fcustomtag = saveMarkResultJo.getString("fcustomTag");
                    this.getCache().put(KEY_IS_BATCH_OPERATION, Boolean.TRUE.toString());
                    for (int i = 0; i < selectRows.length; ++i) {
                        int rowIndex = selectRows[i];
                        if (StringUtils.isNotEmpty((CharSequence)ftag)) {
                            this.getModel().setValue(KEY_TAG, (Object)ftag, rowIndex);
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)fcustomtag)) continue;
                        this.getModel().setValue(KEY_CUSTOM_TAG, (Object)fcustomtag, rowIndex);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
                    this.loadLineData(null, null);
                    LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u6807\u6ce8-\u6210\u529f", MarkTypeEnum.BILL.getId(), this.getFpredimentypeCode()));
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_BTN_ITEM_ADD) && returnData != null) {
            JSONObject saveMarkResultJo = JsonUtils.parseObj((Object)returnData);
            String fmarktype = saveMarkResultJo.getString("fmarktype");
            if (saveMarkResultJo.getBooleanValue("status") && StringUtils.equalsIgnoreCase((CharSequence)fmarktype, (CharSequence)MarkTypeEnum.ITEM.getId())) {
                String ftag = saveMarkResultJo.getString("ftag");
                String ftagtype = saveMarkResultJo.getString("ftagtype");
                String ftagname = saveMarkResultJo.getString("ftagname");
                String fcustomtag = saveMarkResultJo.getString("fcustomTag");
                Date fstartDate = saveMarkResultJo.getDate(KEY_F_START_DATE);
                Date fendDate = saveMarkResultJo.getDate(KEY_F_END_DATE);
                BigDecimal fweight = saveMarkResultJo.getBigDecimal("fweight");
                List<String> fpredimentypeCodeList = Collections.singletonList(this.getFpredimentypeCode());
                SaveDataMarkQuery saveDataMarkQuery = new SaveDataMarkQuery();
                saveDataMarkQuery.setFendDate(fendDate);
                saveDataMarkQuery.setFstartDate(fstartDate);
                saveDataMarkQuery.setFweight(fweight);
                saveDataMarkQuery.setFtag(ftag);
                saveDataMarkQuery.setFtagtype(ftagtype);
                saveDataMarkQuery.setFtagname(ftagname);
                saveDataMarkQuery.setFpredimentypeCodeList(fpredimentypeCodeList);
                saveDataMarkQuery.setFmarktype(fmarktype);
                saveDataMarkQuery.setFcustomTag(fcustomtag);
                saveDataMarkQuery.setFuserid(rc.getUid());
                saveDataMarkQuery.setFusername(rc.getUserName());
                saveDataMarkQuery.setSubServiceId(this.getSubServiceId());
                BaseResult baseResult = this.dataMarkService().saveDataMark(Long.valueOf(rc.getOrgId()), saveDataMarkQuery);
                if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                    String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.SUCCESS);
                    this.loadLineData(null, null);
                    this.loadItemMarkList();
                    for (String code : fpredimentypeCodeList) {
                        LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u4fdd\u5b58\u6807\u6ce8", (String)String.format("\u7c7b\u578b:%s, \u6807\u8bc6:%s\uff0c\u4fdd\u5b58\u6807\u6ce8-\u6210\u529f", fmarktype, code));
                    }
                } else {
                    ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), baseResult.getDescriptionCn(), BaseResult.FAIL);
                }
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        RequestContext rc = RequestContext.get();
        String tabKey = tabSelectEvent.getTabKey();
        String[] tabKeyArr = tabKey.split("_");
        if (tabKeyArr != null && tabKeyArr.length > 1) {
            tabKey = tabKeyArr[1];
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_KEY_ITEM)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_BILL_MARK});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_ITEM_MARK});
            this.getCache().put(KEY_CURRENT_MARK_TYPE, MarkTypeEnum.ITEM.getId());
            this.loadLineData(null, null);
            this.loadItemMarkList();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_KEY_BILL)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_BILL_MARK});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ITEM_MARK});
            this.getCache().put(KEY_CURRENT_MARK_TYPE, MarkTypeEnum.BILL.getId());
            Date now = KDDateUtils.now();
            String fstartdate = KDDateFormatUtils.getDateFormat().format(KDDateUtils.addDays((Date)now, (int)-29));
            String fenddate = KDDateFormatUtils.getDateFormat().format(now);
            DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATE_RANGE);
            String dateRangeStartDate = dateRangeEdit.getStartDateFieldKey();
            String dateRangeEndDate = dateRangeEdit.getEndDateFieldKey();
            this.getModel().setValue(dateRangeStartDate, (Object)DateUtils.parseDate((String)fstartdate, (String)"yyyy-MM-dd"));
            this.getModel().setValue(dateRangeEndDate, (Object)DateUtils.parseDate((String)fenddate, (String)"yyyy-MM-dd"));
            this.loadBillEntryList();
        }
    }
}

