/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.query.data.PredictDetailExportProgressQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.service.IAnaResultService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;

public class PredictDetailExportTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PredictDetailExportTask.class);

    public IAnaResultService anaResultService() {
        return (IAnaResultService)Services.get(IAnaResultService.class);
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        boolean needRetry;
        this.feedbackProgress(0, "\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", null);
        PredictDetailExportProgressQuery predictDetailExportProgressQuery = new PredictDetailExportProgressQuery();
        predictDetailExportProgressQuery.setSubServiceId(params.get("subServiceId").toString());
        predictDetailExportProgressQuery.setRequestId(params.get("requestId").toString());
        int total = Integer.parseInt(params.get("total").toString());
        Date startTime = KDDateUtils.now();
        do {
            JSONObject progressJo = this.anaResultService().getLastDetailListExportProgress(predictDetailExportProgressQuery);
            Date endTime = KDDateUtils.now();
            log.info("PredictDetailExportTask startTime:{}, endTime:{}", (Object)KDDateFormatUtils.getDateTimeFormat().format(startTime), (Object)KDDateFormatUtils.getDateTimeFormat().format(endTime));
            if (endTime.after(KDDateUtils.addMinutes((Date)startTime, (int)15))) {
                log.info("PredictDetailExportTask timeout startTime:{}", (Object)KDDateFormatUtils.getDateTimeFormat().format(startTime));
                break;
            }
            if (progressJo == null) {
                needRetry = true;
            } else {
                int progressTotal = progressJo.getIntValue("total");
                total = progressTotal > 0 ? progressTotal : total;
                int dealed = progressJo.getIntValue("dealed");
                int executeStatus = progressJo.getIntValue("executeStatus");
                needRetry = total > dealed || executeStatus == ExecuteStatusEnum.EXECUTING.getKey();
                int progress = total > 0 ? 100 * dealed / total : 0;
                String desc = String.format("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a%s/%s", dealed, total);
                if (total > 0 && dealed >= total) {
                    desc = "\u6570\u636e\u5df2\u5904\u7406\u5b8c\u6210\uff0c\u6b63\u5728\u51c6\u5907\u6587\u4ef6...";
                }
                this.feedbackProgress(progress, desc, null);
                if (this.isStop()) {
                    needRetry = false;
                    this.stop();
                }
            }
            if (!needRetry) continue;
            log.info("sleep 3s");
            ThreadUtils.sleep((long)3000L);
        } while (needRetry);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("errcode", BaseResult.SUCCESS);
        this.feedbackCustomdata(result);
    }
}

