/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.ai.ids.core.cache.AppCache;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.cache.SessionCache;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.enumtype.AppConfigParameterEnum;
import kd.ai.ids.core.enumtype.FilterItemBizTypeEnum;
import kd.ai.ids.core.enumtype.FilterItemTypeEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.query.data.FilterItemDTO;
import kd.ai.ids.core.query.data.FilterItemQuery;
import kd.ai.ids.core.query.data.FilterItemValuesDTO;
import kd.ai.ids.core.query.label.LabelItem;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.control.IdsFilterItemEdit;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.form.ModelAnalysisContext;
import kd.ai.ids.plugin.form.ModelAnalysisLastDetailDataProvider;
import kd.ai.ids.plugin.job.IdsJobForm;
import kd.ai.ids.plugin.tool.ControlTools;
import kd.ai.ids.plugin.tool.PopAppUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.time.DateFormatUtils;

public class PredictDetailListPlugin
extends BaseFormPlugin
implements CreateListColumnsListener {
    public static final String KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP = "modSchemeSelectMap_";
    public static final String KEY_PREDIMENTTYPE_LAST_LABEL_ID = "predimenttype_last_label_id";
    public static final String KEY_PREDIMENTTYPE_ALL_LABEL_ID = "predimenttype_all_label_id";
    public static final String KEY_PREDIMENTTYPE_DIM_LABEL_ID = "predimenttype_dim_label_id";
    public static final String KEY_PREDIMENTTYPE_LABEL_NAME = "predimenttype_label_name_";
    private static final String KEY_BTN_UN_ONLINE_OK = "btnunonlineok";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_BTN_EXPORT = "btnexport";
    private static final String KEY_COMBO_MOD_SCHEME_SELECT = "combomodschemeselect";
    private static final String KEY_LABEL_ORG_DIM = "labelorgdim";
    private static final String KEY_LABEL_PRODUCT_DIM = "labelproductdim";
    private static final String KEY_LABEL_PREDICT_PERIOD = "labelpredictperiod";
    private static final String KEY_LABEL_PREDICT_LENGTH = "labelpredictlength";
    private static final String KEY_LABEL_PREDICT_VALUE = "labelpredictvalue";
    private static final String KEY_MULBD_PREFIX = "predimenttype";
    private static final String KEY_COMBO_FPREVALUETYPE = "combofprevaluetype";
    private static final String KEY_DATARANGEEDIT_TIME = "daterangeedittime";
    private static final String KEY_DATEEDIT_TIME = "dateedittime";
    private static final String KEY_LABEL_LASTUPDATETIME = "labellastupdatetime";
    private static final String KEY_BILL_LIST_AP_PREDICT_DETAIL = "billlistappredictdetail";
    private static final String KEY_LISTGRIDVIEW_PREDICT_DETAIL = "listgridviewpredictdetail";
    private static final String[] QUERY_FIELD_LIST = new String[]{"fpreperiod", "flast_update_time", "fis_outlier", "fis_last_period"};
    private ModelAnalysisContext ctx = null;
    private AtomicBoolean initBillListListener = new AtomicBoolean(false);
    private static final String KEY_FIELD_FMATERIAL_NUMBER = "fmaterialnumber";
    private static final String KEY_FIELD_OFFSET_PERCENT = "offsetpercent";
    private static final String KEY_CACHE_PREDICT_DETAIL_DATA_LIST = "predictdetaildata";
    private static final String KEY_FILTER_ITEM_QUERY = "filterItemQuery";
    private static final String KEY_FLEX_FILTER = "flexfilter";
    private static final String KEY_BTN_FILTER = "btnfilter";
    private static final String KEY_VECTOR_FILTER = "vectorfilter";
    private static final String KEY_IS_FOLD_FILTER = "isFoldFilter";
    private static final String TASK_CLOSE_BACK = "taskcloseback";

    private boolean enableNewProductForecast() {
        String s = SessionCache.get().get(AppConfigParameterEnum.ENABLE_NEW_PRODUCT_FORECAST.getId());
        return Boolean.parseBoolean(s);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.ctx = new ModelAnalysisContext(this.getCache());
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_PREDICT_DETAIL);
        billList.setBillFormId("ids_predict_details");
        billList.setEntityId("ids_predict_details");
        billList.setEntryEntity("ids_predict_details");
        if (!this.initBillListListener.getAndSet(true)) {
            billList.addCreateListColumnsListener((CreateListColumnsListener)this);
            billList.addAfterBindDataListener(afterBindDataEvent -> this.setCellStyle());
            billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new ModelAnalysisLastDetailDataProvider().setCtx(this.ctx)));
            billList.addHyperClickListener(hyperLinkClickEvent -> this.addHyperClickListener(hyperLinkClickEvent));
            billList.addPagerClickListener(pagerClickEvent -> {
                int currentPageIndex = pagerClickEvent.getCurrentPageIndex();
                int pageRows = pagerClickEvent.getPageRows();
                this.ctx.setPageIndex(currentPageIndex);
                this.ctx.setPageSize(pageRows);
            });
        }
    }

    private void addHyperClickListener(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        List<JSONObject> billDataList = this.ctx.getBillDataList();
        int pageSize = this.ctx.getPageSize();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        JSONObject currentRowJo = billDataList.get(rowIndex %= pageSize);
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)KEY_FIELD_FMATERIAL_NUMBER)) {
            FilterItemQuery filterItemQuery = this.ctx.getCurFilterItemQuery();
            List filterItemValuesDTOList = filterItemQuery.getFilterItemValuesDTOList();
            int filterItemSize = filterItemValuesDTOList.size();
            List dimLabelIdList = this.getCache().getAsList(KEY_PREDIMENTTYPE_DIM_LABEL_ID, String.class);
            for (int i = 0; i < filterItemValuesDTOList.size() - 1; ++i) {
                FilterItemValuesDTO filterItemValuesDTO = (FilterItemValuesDTO)filterItemValuesDTOList.get(i);
                String labelId = filterItemValuesDTO.getLabelId();
                if (dimLabelIdList.contains(labelId)) {
                    filterItemValuesDTO.setValues(currentRowJo.getString(labelId));
                    filterItemValuesDTOList.set(i, filterItemValuesDTO);
                    continue;
                }
                filterItemValuesDTO.setValues(null);
                filterItemValuesDTOList.set(i, filterItemValuesDTO);
            }
            FilterItemValuesDTO lastDimDTO = (FilterItemValuesDTO)filterItemValuesDTOList.get(filterItemSize - 1);
            String fmaterialnumber = currentRowJo.getString(fieldName);
            lastDimDTO.setValues(fmaterialnumber);
            filterItemValuesDTOList.set(filterItemSize - 1, lastDimDTO);
            filterItemQuery.setFilterItemValuesDTOList(filterItemValuesDTOList);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ids_model_analysis");
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put(KEY_FILTER_ITEM_QUERY, JSON.toJSONString((Object)filterItemQuery));
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)KEY_FIELD_OFFSET_PERCENT)) {
            String preObjName;
            int fisOutlier = currentRowJo.getIntValue("fisOutlier");
            int fisLastPeriod = currentRowJo.getIntValue("fisLastPeriod");
            if (fisOutlier != 1 || fisLastPeriod != 1) {
                return;
            }
            String modeltypeId = this.ctx.getCurModelTypeId();
            String fpredimentypeCode = currentRowJo.getString("fpredimentypeCode");
            String fpredimentypeCodeName = currentRowJo.getString("fpredimentypeCodeName");
            String[] predimentypeCodeNameArr = StringUtils.split((String)(fpredimentypeCodeName = fpredimentypeCodeName.replaceAll("->", "====")), (String)"====");
            String string = preObjName = predimentypeCodeNameArr != null && predimentypeCodeNameArr.length > 0 ? predimentypeCodeNameArr[predimentypeCodeNameArr.length - 1] : "";
            if (preObjName.length() > 6) {
                preObjName = String.format("%s...", preObjName.substring(0, 6));
            }
            String caption = ResManager.loadKDString((String)"\u6807\u6ce8\u8be6\u60c5", (String)"ModelAnaOutlierDetailListPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]);
            String appNumber = "ids";
            String appId = AppMetadataCache.getAppInfo((String)appNumber).getAppId();
            IFormView mainView = this.getView().getMainView();
            if (mainView != null) {
                String mainViewPageId = mainView.getPageId();
                String appPageId = appNumber + mainViewPageId;
                String billPageId = fpredimentypeCode + mainViewPageId;
                if (null != mainView.getViewNoPlugin(billPageId)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("view", this.getView());
                    hashMap.put("appname", String.format("%s-%s", caption, preObjName));
                    hashMap.put("formnumber", "ids_outlier_mark_detail");
                    hashMap.put("parametertype", "FormShowParameter");
                    PopAppUtils.activatePage(billPageId, this.getView(), hashMap);
                } else {
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.setFormId("ids_outlier_mark_detail");
                    formShowParameter.setCaption(String.format("%s-%s", caption, preObjName));
                    formShowParameter.setAppId(appId);
                    formShowParameter.setCustomParam("appid", (Object)appId);
                    HashMap<String, String> customParams = new HashMap<String, String>();
                    customParams.put("fpredimentypeCode", fpredimentypeCode);
                    customParams.put("fpredimentypeCodeName", currentRowJo.getString("fpredimentypeCodeName"));
                    customParams.put("modeltypeId", modeltypeId);
                    formShowParameter.setCustomParams(customParams);
                    formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
                    formShowParameter.setPageId(billPageId);
                    IFormView fromView = this.getView().getView(appPageId);
                    if (fromView != null) {
                        fromView.showForm(formShowParameter);
                        this.getView().sendFormAction(fromView);
                    }
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_RESET, KEY_BTN_FILTER, KEY_VECTOR_FILTER, KEY_BTN_EXPORT});
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnrefresh": {
                this.refreshBillList(false, this.ctx.getCurFilterItemQuery());
                break;
            }
            case "btnreset": {
                this.resetQueryCondition();
                this.refreshBillList(true, null);
                break;
            }
            case "btnfilter": 
            case "vectorfilter": {
                this.expandOrFoldFilterPanel(true, false);
                break;
            }
            case "btnexport": {
                this.exportList();
                break;
            }
        }
    }

    private String getSingleExportCacheKey() {
        return KEY_BTN_EXPORT + this.getView().getEntityId();
    }

    private void exportList() {
        RequestContext rc = RequestContext.get();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)rc.getCurrUserId(), (String)"1ZY6U=RCHA6Y", (String)IdsFormIdEnum.IDS_PREDICT_DETAIL_LIST.getId(), (String)"4730fc9f000004ae");
        if (!hasPermission) {
            return;
        }
        String requestId = SessionCache.get().get(this.getSingleExportCacheKey());
        if (StringUtils.isNotEmpty((CharSequence)requestId)) {
            this.getView().showTipNotification(String.format("\u5df2\u6709\u4e0b\u8f7d\u4efb\u52a1\u5728\u6267\u884c\uff0c\u8bf7\u7b49\u5f85\u4e0b\u8f7d\u5b8c\u6210\u6216%s\u5206\u949f\u540e\u518d\u8bd5", 15));
            return;
        }
        FilterItemQuery filterItemQuery = this.ctx.getCurFilterItemQuery();
        long total = Long.parseLong(this.ctx.getCache().get("total"));
        if (total == 0L) {
            this.getView().showTipNotification("\u67e5\u8be2\u8bb0\u5f55\u4e3a0\u6761\uff0c\u4e0d\u652f\u6301\u5bfc\u51fa");
            return;
        }
        if (total > 1000000L) {
            this.getView().showTipNotification(String.format("\u5bfc\u51fa\u603b\u8bb0\u5f55\u6570%s\u8d85\u8fc7100\u4e07\u6761\uff0c\u8bf7\u8fc7\u6ee4\u67e5\u8be2\u540e\u518d\u5bfc\u51fa", total));
            this.expandOrFoldFilterPanel(true, true);
            return;
        }
        FilterItemValuesDTO filterItemValuesDTO = (FilterItemValuesDTO)filterItemQuery.getFilterItemValuesDTOList().get(0);
        if (!CommonUtil.useMock() && (StringUtils.isEmpty((CharSequence)filterItemValuesDTO.getValues()) || StringUtils.equalsIgnoreCase((CharSequence)filterItemValuesDTO.getValues(), (CharSequence)"-1"))) {
            String dimName = this.getCache().get(KEY_PREDIMENTTYPE_LABEL_NAME + filterItemValuesDTO.getLabelId());
            this.getView().showTipNotification(String.format("\u5bfc\u51fa\u524d\u8bf7\u5148\u6309\u3010%s\u3011\u8fdb\u884c\u8fc7\u6ee4\u67e5\u8be2", dimName));
            this.expandOrFoldFilterPanel(true, true);
            return;
        }
        String msg = String.format("\u5c06\u5bfc\u51fa%s\u6761\u8bb0\u5f55\uff0c\r\n\u662f\u5426\u7ee7\u7eed\u6267\u884c\u64cd\u4f5c\uff1f", total);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_BTN_EXPORT, (IFormPlugin)this);
        this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, total + "");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TASK_CLOSE_BACK)) {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                SessionCache.get().remove(this.getSingleExportCacheKey());
                String data = taskInfo.getData();
                JSONObject dataJo = JSONObject.parseObject((String)data);
                if (dataJo.getIntValue("errcode") == BaseResult.SUCCESS.intValue()) {
                    RequestContext rc = RequestContext.get();
                    FilterItemQuery curFilterItemQuery = this.ctx.getCurFilterItemQuery();
                    String exportUrl = this.anaResultService().getLastDetailListExportFileUrl(Long.valueOf(rc.getOrgId()), curFilterItemQuery.getSubServiceId(), curFilterItemQuery.getRequestId());
                    this.getView().download(exportUrl);
                    this.getView().showMessage("\u5df2\u4e0b\u8f7d\u5b8c\u6210");
                }
            }
        }
    }

    private void triggerExport(long total) {
        RequestContext rc = RequestContext.get();
        long orgId = rc.getOrgId();
        FilterItemQuery curFilterItemQuery = this.ctx.getCurFilterItemQuery();
        curFilterItemQuery.setTotal(Long.valueOf(total));
        curFilterItemQuery.setFcreator(String.valueOf(rc.getCurrUserId()));
        curFilterItemQuery.setFcreatorname(rc.getUserName());
        ThreadUtils.execute(() -> this.anaResultService().getLastDetailListExport(Long.valueOf(orgId), curFilterItemQuery));
        ThreadUtils.sleep((long)100L);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("ids");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("\u660e\u7ec6\u5217\u8868\u5bfc\u51fa");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.ai.ids.plugin.form.PredictDetailExportTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("subServiceId", curFilterItemQuery.getSubServiceId());
        params.put("requestId", curFilterItemQuery.getRequestId());
        params.put("total", total);
        SessionCache.get().put(this.getSingleExportCacheKey(), curFilterItemQuery.getRequestId(), 900);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TASK_CLOSE_BACK);
        IdsJobForm.dispatch(jobInfo, this.getView(), closeCallBack);
    }

    private void expandOrFoldFilterPanel(boolean isAutoSwitch, boolean forceExpand) {
        String isFoldFilter = AppCache.get().get(KEY_IS_FOLD_FILTER);
        boolean isFold = true;
        if (StringUtils.isNotEmpty((CharSequence)isFoldFilter)) {
            isFold = Boolean.parseBoolean(isFoldFilter);
        }
        Vector vector = (Vector)this.getControl(KEY_VECTOR_FILTER);
        HashMap map1 = new HashMap();
        HashMap map2 = new HashMap();
        if (isAutoSwitch) {
            if (forceExpand || isFold) {
                this.expandFilterPanel(vector, map1, map2);
            } else {
                this.foldFilterPanel(vector, map1, map2);
            }
        } else if (isFold) {
            this.foldFilterPanel(vector, map1, map2);
        } else {
            this.expandFilterPanel(vector, map1, map2);
        }
    }

    private void foldFilterPanel(Vector vector, Map map1, Map map2) {
        AppCache.get().put(KEY_IS_FOLD_FILTER, Boolean.TRUE.toString(), 604800);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_FILTER});
        map1.put("zh_CN", "\u5c55\u5f00\u8fc7\u6ee4");
        map2.put("text", map1);
        this.getView().updateControlMetadata(KEY_BTN_FILTER, map2);
        vector.setFontClass("kdfont kdfont-zhankai4");
    }

    private void expandFilterPanel(Vector vector, Map map1, Map map2) {
        AppCache.get().put(KEY_IS_FOLD_FILTER, Boolean.FALSE.toString(), 604800);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_FILTER});
        map1.put("zh_CN", "\u6536\u8d77\u8fc7\u6ee4");
        map2.put("text", map1);
        this.getView().updateControlMetadata(KEY_BTN_FILTER, map2);
        vector.setFontClass("kdfont kdfont-shouqi7");
    }

    private void resetQueryCondition() {
        this.clearPredimentTypeFilterData();
        FilterItemQuery defaultFilterItemQuery = this.ctx.getDefaultFilterItemQuery();
        if (defaultFilterItemQuery != null) {
            defaultFilterItemQuery.setCurrent(Long.valueOf(1L));
            defaultFilterItemQuery.setOrderByExpr(null);
            defaultFilterItemQuery.setFilters(null);
        }
        this.ctx.setCurFilterItemQuery(defaultFilterItemQuery);
        if (defaultFilterItemQuery != null) {
            this.getModel().setValue(KEY_COMBO_FPREVALUETYPE, (Object)defaultFilterItemQuery.getPrevaluetypeDTO().getId());
            DateRangeEdit timeDateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATARANGEEDIT_TIME);
            String keyTimeStartDate = timeDateRangeEdit.getStartDateFieldKey();
            String keyTimeEndDate = timeDateRangeEdit.getEndDateFieldKey();
            this.getModel().setValue(keyTimeStartDate, null);
            this.getModel().setValue(keyTimeEndDate, null);
            this.getModel().setValue(KEY_DATEEDIT_TIME, null);
        }
    }

    private void clearPredimentTypeFilterData() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        List allLabelIdList = this.getCache().getAsList(KEY_PREDIMENTTYPE_ALL_LABEL_ID, String.class);
        for (String key : allLabelIdList) {
            this.getCache().remove("ListData_" + key);
            this.getCache().remove("SelectedList_" + key);
            clientViewProxy.setFieldProperty("predimenttype_" + key, "v", (Object)new Object[0]);
        }
    }

    private void buildFilterItemValuesDTOList(List<FilterItemValuesDTO> filterItemValuesDTOList, String labelId) {
        String fieldKey = "predimenttype_" + labelId;
        IdsFilterItemEdit edit = (IdsFilterItemEdit)this.getControl(fieldKey);
        List<String> numberList = edit.getSelectedNumberList();
        FilterItemValuesDTO filterItem = new FilterItemValuesDTO();
        filterItem.setLabelId(labelId);
        String values = "-1";
        if (numberList != null && !numberList.isEmpty()) {
            values = String.join((CharSequence)",", numberList);
        }
        filterItem.setValues(values);
        filterItemValuesDTOList.add(filterItem);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_MOD_SCHEME_SELECT)) {
            String fmodeltypeid = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.setDateFilterVisible(fmodeltypeid);
            this.resetQueryCondition();
            this.showCurrentModSelectAndFilterItem(fmodeltypeid);
            this.refreshBillList(true, null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_FPREVALUETYPE)) {
            String fprevaluetype = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.ctx.setCurPreValueType(fprevaluetype);
        }
    }

    private void setDateFilterVisible(String fmodeltypeid) {
        if (AppConstants.rollWeekModeltypeIdList.contains(fmodeltypeid)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_DATEEDIT_TIME});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DATARANGEEDIT_TIME});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DATEEDIT_TIME});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_DATARANGEEDIT_TIME});
        }
    }

    private void showCurrentModSelectAndFilterItem(String modelTypeId) {
        String s = this.getCache().get(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return;
        }
        JSONObject modSchemeSelectJo = JSON.parseObject((String)s);
        if (modSchemeSelectJo != null) {
            String orgDimName = modSchemeSelectJo.getString("fpredimentypeOrgFname");
            String productDimName = modSchemeSelectJo.getString("fpredimentypeProductFname");
            String predictPeriodName = modSchemeSelectJo.getString("fpretimetypeFname");
            String predictLengthName = modSchemeSelectJo.getString("ftn");
            String predictValueName = modSchemeSelectJo.getString("fprevaluetypeFname");
            this.setLabelText(KEY_LABEL_ORG_DIM, orgDimName);
            this.setLabelText(KEY_LABEL_PRODUCT_DIM, productDimName);
            this.setLabelText(KEY_LABEL_PREDICT_PERIOD, predictPeriodName);
            this.setLabelText(KEY_LABEL_PREDICT_LENGTH, predictLengthName);
            this.setLabelText(KEY_LABEL_PREDICT_VALUE, predictValueName);
            this.loadAnaResultsFilterItem(modelTypeId);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    private void loadOnlineModelTypeList(RequestContext rc) {
        JSONArray dataJa = this.anaResultService().getOnlineSchemeList(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_MOD_SCHEME_SELECT);
        int len = dataJa.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        HashMap<String, String> modSchemeSelectMap = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            JSONObject jo = dataJa.getJSONObject(i);
            String modelTypeId = jo.getString("fmodeltypeid");
            if (StringUtils.isEmpty((CharSequence)this.ctx.getCurModelTypeId())) {
                this.ctx.setCurModelTypeId(modelTypeId);
            }
            modSchemeSelectMap.put(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId, jo.toJSONString());
            LocaleString comboItemText = new LocaleString(jo.getString("fmodeltypeidFname"));
            ComboItem comboItem = new ComboItem(comboItemText, modelTypeId);
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
        this.getCache().put(modSchemeSelectMap);
        this.setDateFilterVisible(this.ctx.getCurModelTypeId());
        this.showCurrentModSelectAndFilterItem(this.ctx.getCurModelTypeId());
    }

    private void loadAnaResultsFilterItem(String fmodeltypeid) {
        this.ctx.setCurModelTypeId(fmodeltypeid);
        RequestContext rc = RequestContext.get();
        JSONObject dataJo = this.anaResultService().getFilterItem(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId(), fmodeltypeid, true);
        if (dataJo == null) {
            return;
        }
        JSONArray predimenttypeArray = dataJo.getJSONArray("predimenttypeArray");
        JSONArray fprevaluetypeArray = dataJo.getJSONArray("fprevaluetypeArray");
        this.initPreDimentType(predimenttypeArray);
        this.initPreValueTypeCombo(fprevaluetypeArray);
    }

    private void initPreDimentType(JSONArray predimentTypeArray) {
        ArrayList<String> filterLabelIdList = new ArrayList<String>();
        List allLabelIdList = this.getCache().getAsList(KEY_PREDIMENTTYPE_ALL_LABEL_ID, String.class);
        ArrayList<String> dimLabelIdList = new ArrayList<String>(5);
        Container panel = (Container)this.getControl("flexpanelap3");
        String[] deleteControls = (String[])allLabelIdList.stream().flatMap(s -> {
            String key = "predimenttype_" + s;
            return Stream.of(key + "_panel", key + "_label", key);
        }).toArray(String[]::new);
        panel.deleteControls(deleteControls);
        if (predimentTypeArray != null && !predimentTypeArray.isEmpty()) {
            int index = 0;
            int len = predimentTypeArray.size();
            for (int i = 0; i < len; ++i) {
                JSONObject jo = predimentTypeArray.getJSONObject(i);
                String labelId = jo.getString("labelId");
                String type = jo.getString("type");
                String fieldKey = "predimenttype_" + labelId;
                String showText = jo.getString("labelName");
                this.getCache().put(KEY_PREDIMENTTYPE_LABEL_NAME + labelId, showText);
                filterLabelIdList.add(labelId);
                if (!allLabelIdList.contains(labelId)) {
                    allLabelIdList.add(labelId);
                }
                if (!dimLabelIdList.contains(labelId) && StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)FilterItemTypeEnum.DIM.getId())) {
                    dimLabelIdList.add(labelId);
                }
                Map<String, Object> control = ControlTools.createMulBaseDataControl(fieldKey, showText);
                panel.insertControls(index, Collections.singletonList(control));
                ++index;
            }
        }
        this.getCache().put(KEY_PREDIMENTTYPE_DIM_LABEL_ID, dimLabelIdList);
        this.getCache().put(KEY_PREDIMENTTYPE_ALL_LABEL_ID, allLabelIdList);
        this.ctx.setPreDimentTypeFilterLabelIdList(filterLabelIdList);
    }

    private void initPreValueTypeCombo(JSONArray fprevaluetypeArray) {
        if (fprevaluetypeArray == null || fprevaluetypeArray.isEmpty()) {
            return;
        }
        JSONObject jo = fprevaluetypeArray.getJSONObject(0);
        JSONArray valueJa = jo.getJSONArray("value");
        if (valueJa == null || valueJa.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_FPREVALUETYPE);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(valueJa.size());
        for (int i = 0; i < valueJa.size(); ++i) {
            JSONObject valueJo = valueJa.getJSONObject(i);
            String id = valueJo.getString("id");
            String name = valueJo.getString("name");
            if (i == 0 && StringUtils.isEmpty((CharSequence)this.ctx.getCurPreValueType())) {
                this.ctx.setCurPreValueType(id);
            }
            ComboItem comboItem = new ComboItem(new LocaleString(name), id);
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.expandOrFoldFilterPanel(false, false);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filterItemQueryStr = (String)formShowParameter.getCustomParam(KEY_FILTER_ITEM_QUERY);
        FilterItemQuery filterItemQuery = null;
        if (StringUtils.isNotEmpty((CharSequence)filterItemQueryStr)) {
            filterItemQuery = (FilterItemQuery)JSON.toJavaObject((JSON)JSON.parseObject((String)filterItemQueryStr), FilterItemQuery.class);
            this.ctx.setCurFilterItemQuery(filterItemQuery);
            this.ctx.setCurModelTypeId(filterItemQuery.getFmodeltypeid());
            this.ctx.setCurPreValueType(filterItemQuery.getPrevaluetypeDTO().getId());
            DateRangeEdit timeDateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATARANGEEDIT_TIME);
            String keyTimeStartDate = timeDateRangeEdit.getStartDateFieldKey();
            String keyTimeEndDate = timeDateRangeEdit.getEndDateFieldKey();
            this.getModel().setValue(keyTimeStartDate, (Object)DateUtils.parseDate((String)filterItemQuery.getStartTime(), (String)"yyyy-MM-dd"));
            this.getModel().setValue(keyTimeEndDate, (Object)DateUtils.parseDate((String)filterItemQuery.getEndTime(), (String)"yyyy-MM-dd"));
            if (AppConstants.rollWeekModeltypeIdList.contains(filterItemQuery.getFmodeltypeid())) {
                this.getModel().setValue(KEY_DATEEDIT_TIME, (Object)DateUtils.parseDate((String)filterItemQuery.getStartTime(), (String)"yyyy-MM-dd"));
            }
        }
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.ctx.setSubServiceId(subServiceId);
        this.loadOnlineModelTypeList(rc);
        this.loadChartData(true, filterItemQuery);
        this.getModel().setValue(KEY_COMBO_MOD_SCHEME_SELECT, (Object)this.ctx.getCurModelTypeId());
        this.getModel().setValue(KEY_COMBO_FPREVALUETYPE, (Object)this.ctx.getCurPreValueType());
    }

    private void loadChartData(boolean isInit, FilterItemQuery filterItemQuery) {
        if (filterItemQuery == null) {
            filterItemQuery = new FilterItemQuery();
        }
        DateRangeEdit timeDateRangeEdit = (DateRangeEdit)this.getView().getControl(KEY_DATARANGEEDIT_TIME);
        String keyTimeStartDate = timeDateRangeEdit.getStartDateFieldKey();
        String keyTimeEndDate = timeDateRangeEdit.getEndDateFieldKey();
        Date timeStartDate = (Date)this.getModel().getValue(keyTimeStartDate);
        Date timeEndDate = (Date)this.getModel().getValue(keyTimeEndDate);
        if (AppConstants.rollWeekModeltypeIdList.contains(filterItemQuery.getFmodeltypeid())) {
            timeStartDate = (Date)this.getModel().getValue(KEY_DATEEDIT_TIME);
            timeEndDate = (Date)this.getModel().getValue(KEY_DATEEDIT_TIME);
        }
        if (timeStartDate != null) {
            filterItemQuery.setStartTime(DateFormatUtils.format((Date)timeStartDate, (String)"yyyy-MM-dd"));
        } else {
            filterItemQuery.setStartTime(null);
        }
        if (timeEndDate != null) {
            filterItemQuery.setEndTime(DateFormatUtils.format((Date)timeEndDate, (String)"yyyy-MM-dd"));
        } else {
            filterItemQuery.setEndTime(null);
        }
        filterItemQuery.setFmodeltypeid(this.ctx.getCurModelTypeId());
        filterItemQuery.setSubServiceId(this.ctx.getSubServiceId());
        filterItemQuery.setCurrent(Long.valueOf(1L));
        FilterItemDTO prevaluetypeDTO = new FilterItemDTO();
        prevaluetypeDTO.setId(this.ctx.getCurPreValueType());
        prevaluetypeDTO.setName((String)AppConstants.prevaluetypeFilterKvMap.get(this.ctx.getCurPreValueType()));
        filterItemQuery.setPrevaluetypeDTO(prevaluetypeDTO);
        ArrayList<FilterItemValuesDTO> filterItemValuesDTOList = new ArrayList<FilterItemValuesDTO>();
        if (isInit && filterItemQuery.getFilterItemValuesDTOList() != null) {
            Map<String, FilterItemValuesDTO> filterItemValuesDTOMap = filterItemQuery.getFilterItemValuesDTOList().stream().collect(Collectors.toMap(FilterItemValuesDTO::getLabelId, filterItemValuesDTO -> filterItemValuesDTO));
            Iterator iterator = filterItemValuesDTOMap.entrySet().iterator();
            while (iterator.hasNext()) {
                String labelId = (String)iterator.next().getKey();
                String values = ((FilterItemValuesDTO)filterItemValuesDTOMap.get(labelId)).getValues();
                String fieldKey = "predimenttype_" + labelId;
                IdsFilterItemEdit edit = (IdsFilterItemEdit)this.getControl(fieldKey);
                edit.setItemByNumber(values, 0);
            }
        }
        for (String lableId : this.ctx.getPreDimentTypeFilterLabelIdList()) {
            this.buildFilterItemValuesDTOList(filterItemValuesDTOList, lableId);
        }
        filterItemQuery.setFilterItemValuesDTOList(filterItemValuesDTOList);
        ArrayList<String> queryFieldList = new ArrayList<String>(Arrays.asList(QUERY_FIELD_LIST));
        if (this.enableNewProductForecast()) {
            queryFieldList.add("fmaterial_tag");
        }
        filterItemQuery.setQueryFieldList(queryFieldList);
        filterItemQuery.setRequestId(UUID.randomUUID().toString());
        this.ctx.setCurFilterItemQuery(filterItemQuery);
        if (isInit) {
            this.ctx.setDefaultFilterItemQuery(filterItemQuery);
        }
        FilterItemQuery finalFilterItemQuery = filterItemQuery;
        this.loadAnaLastDetailFromRemote(finalFilterItemQuery);
    }

    private void refreshBillList(boolean isInit, FilterItemQuery filterItemQuery) {
        this.loadChartData(isInit, filterItemQuery);
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_PREDICT_DETAIL);
        billList.setPageIndex(1);
        billList.clearSelection();
        billList.refresh();
    }

    private void loadAnaLastDetailFromRemote(FilterItemQuery filterItemQuery) {
        RequestContext rc = RequestContext.get();
        filterItemQuery.setNeedRecord(Boolean.valueOf(false));
        BaseResult baseResult = this.anaResultService().getLastDetailList(Long.valueOf(rc.getOrgId()), filterItemQuery);
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            JSONObject resultJo = dataJo.getJSONObject("result");
            String flastUpdateTime = resultJo.getString("flastUpdateTime");
            this.setLastUpdateTimeTips(flastUpdateTime);
            this.ctx.setCurLastDetailBaseResult(baseResult);
        } else {
            this.ctx.setCurLastDetailBaseResult(BaseResult.fail((String)"", (String)""));
        }
    }

    private void setCellStyle() {
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_PREDICT_DETAIL);
        ArrayList<CellStyle> cslist = new ArrayList<CellStyle>();
        BaseResult baseResult = this.ctx.getCurLastDetailBaseResult();
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            JSONArray fieldsJa = CommonUtil.emptyIfNull((JSONArray)dataJo.getJSONArray("fields"));
            JSONObject resultJo = dataJo.getJSONObject("result");
            JSONArray recordsJa = CommonUtil.emptyIfNull((JSONArray)resultJo.getJSONArray("records"));
            int current = this.ctx.getPageIndex();
            int pageSize = this.ctx.getPageSize();
            int startRowIndex = (current - 1) * pageSize;
            for (int i = 0; i < recordsJa.size(); ++i) {
                JSONObject recordJo = recordsJa.getJSONObject(i);
                int fisOutlier = recordJo.getIntValue("fisOutlier");
                int fisLastPeriod = recordJo.getIntValue("fisLastPeriod");
                for (Object fieldO : fieldsJa) {
                    JSONObject fieldJo = (JSONObject)fieldO;
                    String fieldKey = fieldJo.getString("id").toLowerCase();
                    CellStyle cs = new CellStyle();
                    cs.setFieldKey(fieldKey);
                    if (fisOutlier == 1 && fisLastPeriod == 1) {
                        if (KEY_FIELD_OFFSET_PERCENT.equalsIgnoreCase(fieldKey)) {
                            cs.setBackColor("#FFF1D4");
                        } else {
                            cs.setForeColor("#333333");
                        }
                    }
                    cs.setRow(startRowIndex + i);
                    cslist.add(cs);
                }
            }
        }
        billList.setCellStyle(cslist);
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        IListColumn seqListColumn = (IListColumn)columns.get(0);
        columns.clear();
        columns.add(seqListColumn);
        BaseResult baseResult = this.ctx.getCurLastDetailBaseResult();
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            JSONArray fieldsJa = CommonUtil.emptyIfNull((JSONArray)dataJo.getJSONArray("fields"));
            List<String> summaryFieldList = Arrays.asList(AppConstants.PREDICT_DETAIL_SUMMARY_FIELD_ARR);
            ArrayList<String> fieldList = new ArrayList<String>(10);
            for (int i = 0; i < fieldsJa.size(); ++i) {
                DecimalListColumn listColumn;
                JSONObject fieldsJo = fieldsJa.getJSONObject(i);
                String s = fieldsJo.getString("id");
                String id = s != null ? s.toLowerCase() : "";
                fieldList.add(id);
                boolean allowOrder = fieldsJo.getBooleanValue("allowOrder");
                boolean allowFilter = fieldsJo.getBooleanValue("allowFilter");
                boolean isHyperlink = false;
                if (KEY_FIELD_FMATERIAL_NUMBER.equalsIgnoreCase(id) || KEY_FIELD_OFFSET_PERCENT.equalsIgnoreCase(id)) {
                    isHyperlink = true;
                }
                if (summaryFieldList.contains(s)) {
                    listColumn = this.createDecimalListColumn(id, fieldsJo.getString("name"), i + 1, allowOrder, allowFilter, isHyperlink);
                    listColumn.setParentViewKey(KEY_LISTGRIDVIEW_PREDICT_DETAIL);
                    columns.add(listColumn);
                    continue;
                }
                listColumn = this.createListColumn(id, fieldsJo.getString("name"), i + 1, allowOrder, allowFilter, isHyperlink);
                listColumn.setParentViewKey(KEY_LISTGRIDVIEW_PREDICT_DETAIL);
                columns.add(listColumn);
            }
            this.ctx.setPredictDetailFieldList(fieldList);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private ListColumn createListColumn(String key, String caption, int colIndex, boolean allowOrder, boolean allowFilter, boolean isHyperlink) {
        ListColumn col = new ListColumn();
        this.setListColumnProperties(key, caption, colIndex, allowOrder, allowFilter, col, isHyperlink);
        return col;
    }

    private DecimalListColumn createDecimalListColumn(String key, String caption, int colIndex, boolean allowOrder, boolean allowFilter, boolean isHyperlink) {
        DecimalListColumn col = new DecimalListColumn();
        col.setSummary(1);
        col.setZeroShow(true);
        this.setListColumnProperties(key, caption, colIndex, allowOrder, allowFilter, (ListColumn)col, isHyperlink);
        return col;
    }

    private void setListColumnProperties(String key, String caption, int colIndex, boolean allowOrder, boolean allowFilter, ListColumn col, boolean isHyperlink) {
        col.setCaption(new LocaleString(caption));
        col.setListFieldKey(key);
        col.setKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setWidth(new LocaleString("8%"));
        col.setBlankFieldCanOrderAndFilter(true);
        col.setColumnOrder(allowOrder);
        col.setColumnFilter(allowFilter);
        col.setHyperlink(isHyperlink);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (StringUtils.equals((CharSequence)KEY_BTN_UN_ONLINE_OK, (CharSequence)callBackId)) {
            if (e.getResult() == MessageBoxResult.Cancel) {
                this.getView().close();
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)KEY_BTN_EXPORT) && e.getResult() == MessageBoxResult.Yes) {
            long total = Long.parseLong(this.ctx.getCache().get("total"));
            this.triggerExport(total);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        boolean isOnline = false;
        if (tenantDTO != null) {
            isOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        }
        if (!isOnline) {
            e.setCancel(true);
            Object source = e.getSource();
            if (!(source instanceof FormShowParameter)) {
                return;
            }
            FormShowParameter fsp = (FormShowParameter)source;
            String parentPageId = fsp.getParentPageId();
            IdsPageCache parentCache = new IdsPageCache(parentPageId);
            parentCache.put("is_online_" + fsp.getFormId(), "false");
            parentCache.saveChanges();
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getControl() != null) {
            return;
        }
        String key = e.getKey();
        String[] keySplit = key.split("_");
        if (keySplit.length > 1 && KEY_MULBD_PREFIX.equals(keySplit[0])) {
            String labelId = keySplit[1];
            IdsFilterItemEdit edit = new IdsFilterItemEdit();
            edit.setKey(key);
            edit.setView(this.getView());
            LabelItem item = new LabelItem();
            item.setId(labelId);
            item.setName(this.getCache().get(KEY_PREDIMENTTYPE_LABEL_NAME + labelId));
            edit.setLabel(item);
            edit.setSubServiceId(this.ctx.getSubServiceId());
            edit.setModelTypeId(this.ctx.getCurModelTypeId());
            edit.setMultiSelect(!Objects.equals(labelId, this.getCache().get(KEY_PREDIMENTTYPE_LAST_LABEL_ID)));
            edit.setBizType(FilterItemBizTypeEnum.MODEL_ANA.getId());
            ArrayList<String> labelIdList = new ArrayList<String>();
            ArrayList<String> allLabelIdList = new ArrayList<String>();
            FilterItemQuery curFilterItemQuery = this.ctx.getCurFilterItemQuery();
            if (curFilterItemQuery != null) {
                List filterItemValuesDTOList = curFilterItemQuery.getFilterItemValuesDTOList();
                for (int i = 0; i < filterItemValuesDTOList.size(); ++i) {
                    FilterItemValuesDTO filterItemValuesDTO = (FilterItemValuesDTO)filterItemValuesDTOList.get(i);
                    allLabelIdList.add(filterItemValuesDTO.getLabelId());
                    if (i == filterItemValuesDTOList.size() - 1) continue;
                    labelIdList.add(filterItemValuesDTO.getLabelId());
                }
            }
            edit.setPrevLabelId(labelIdList);
            edit.setAllLabelId(allLabelIdList);
            edit.setPageCache(this.getCache());
            e.setControl((Control)edit);
        }
    }

    private void setLastUpdateTimeTips(String lastUpdateTime) {
        Label ftimeLabel = (Label)this.getControl(KEY_LABEL_LASTUPDATETIME);
        Tips tips = new Tips();
        tips.setShowIcon(true);
        tips.setType("text");
        tips.setIconClassName("kdfont kdfont-Toast-tishi");
        tips.setTitle(new LocaleString("\u6570\u636e\u66f4\u65b0\u65f6\u95f4"));
        tips.setContent(new LocaleString(lastUpdateTime));
        ftimeLabel.addTips(tips);
    }
}

