/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.enumtype.IdsVersionEnum;
import kd.ai.ids.core.query.data.FilterItemQuery;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;

public class PredictModelExplainFormPlugin
extends BaseFormPlugin {
    private static final String KEY_INFLUENCE_FACTOR_CUSTOMCONTROLAP = "if_customcontrolap";
    private static final String KEY_CLICK = "click";
    private static final String KEY_ENTRY_ENTITY_ALGORITHM = "algorithmentryentity";
    private static final String KEY_CACHE_CURRENT_FILTER_ITEM_QUERY = "currentFilterItemQuery";
    private static final String KEY_CURRENT_ANA_INFLUENCE_FACTOR_DATA = "CurrentAnaInfluenceFactorData";
    private static final String KEY_BTN_ALGORITHM_DESC = "btnalgorithdesc";
    private static final String KEY_CACHE_ALGORITHM_DESC = "algorithmDesc";
    private static final String KEY_FORMID_IDS_ALGORITHM_DESC = "ids_algorithm_desc";
    private static final String KEY_LABELFMODELTYPEIDFNAME = "labelfmodeltypeidfname";
    private static final String KEY_LABELORGDIM = "labelorgdim";
    private static final String KEY_LABELCUSTDIM = "labelcustdim";
    private static final String KEY_LABELPRODUCTDIM = "labelproductdim";
    private static final String KEY_LABELPREDICTPERIOD = "labelpredictperiod";
    private static final String KEY_LABELPREDICTLENGTH = "labelpredictlength";
    private static final String KEY_LABELPREDICTVALUE = "labelpredictvalue";
    private static final String FLEX_ORG_DIM = "flexorgdim";
    private static final String FLEX_CUST_DIM = "flexcustdim";
    private static final String FLEX_PRODUCT_DIM = "flexproductdim";
    private static final String FLEX_INFLUENCE_FACTOR = "flexinfluencefactor";

    public FilterItemQuery getCurFilterItemQuery() {
        return (FilterItemQuery)this.getCache().getAsObject(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY, FilterItemQuery.class);
    }

    public void setCurFilterItemQuery(FilterItemQuery currentFilterItemQuery) {
        this.getCache().put(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY, JSON.toJSONString((Object)currentFilterItemQuery));
    }

    public String getCurAnaInfluenceFactorData() {
        return this.getCache().get(KEY_CURRENT_ANA_INFLUENCE_FACTOR_DATA);
    }

    public void setCurAnaInfluenceFactorData(String s) {
        this.getCache().put(KEY_CURRENT_ANA_INFLUENCE_FACTOR_DATA, s);
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector vector = (Vector)this.getControl(KEY_BTN_ALGORITHM_DESC);
        vector.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String evtKey = source.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)evtKey, (CharSequence)KEY_BTN_ALGORITHM_DESC)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(KEY_FORMID_IDS_ALGORITHM_DESC);
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put(KEY_CACHE_ALGORITHM_DESC, this.getCache().get(KEY_CACHE_ALGORITHM_DESC));
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String subServiceId = (String)formShowParameter.getCustomParam("subServiceId");
        String fmodeltypeid = (String)formShowParameter.getCustomParam("fmodeltypeid");
        String fmodeltypeidName = (String)formShowParameter.getCustomParam("fmodeltypeidName");
        String orgDimName = (String)formShowParameter.getCustomParam("orgDimName");
        String custDimName = (String)formShowParameter.getCustomParam("custDimName");
        String productDimName = (String)formShowParameter.getCustomParam("productDimName");
        String predictPeriodName = (String)formShowParameter.getCustomParam("predictPeriodName");
        String predictLengthName = (String)formShowParameter.getCustomParam("predictLengthName");
        String predictValueName = (String)formShowParameter.getCustomParam("predictValueName");
        this.setLabelText(KEY_LABELFMODELTYPEIDFNAME, fmodeltypeidName);
        this.setLabelText(KEY_LABELORGDIM, orgDimName);
        this.setLabelText(KEY_LABELCUSTDIM, custDimName);
        this.setLabelText(KEY_LABELPRODUCTDIM, productDimName);
        this.setLabelText(KEY_LABELPREDICTPERIOD, predictPeriodName);
        this.setLabelText(KEY_LABELPREDICTLENGTH, predictLengthName);
        this.setLabelText(KEY_LABELPREDICTVALUE, predictValueName);
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ORG_DIM, FLEX_CUST_DIM, FLEX_PRODUCT_DIM});
        if (!StringUtils.isEmpty((CharSequence)orgDimName)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ORG_DIM});
        }
        if (!StringUtils.isEmpty((CharSequence)custDimName)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_CUST_DIM});
        }
        if (!StringUtils.isEmpty((CharSequence)productDimName)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PRODUCT_DIM});
        }
        FilterItemQuery filterItemQuery = new FilterItemQuery();
        filterItemQuery.setSubServiceId(subServiceId);
        filterItemQuery.setFmodeltypeid(fmodeltypeid);
        this.setCurFilterItemQuery(filterItemQuery);
        TenantDTO tenantDTO = this.getTenantDTO();
        JSONArray algorithmJa = null;
        algorithmJa = StringUtils.equalsIgnoreCase((CharSequence)tenantDTO.getIdsVersion(), (CharSequence)IdsVersionEnum.STANDARD.getKey()) ? this.loadAlgorithmErrorFromRemoteForStd(subServiceId, fmodeltypeid) : this.loadAlgorithmErrorFromRemote(filterItemQuery);
        if (algorithmJa != null && !algorithmJa.isEmpty()) {
            int rowCount = algorithmJa.size();
            this.getModel().deleteEntryData(KEY_ENTRY_ENTITY_ALGORITHM);
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY_ALGORITHM, rowCount);
            StringBuilder algorithmDesc = new StringBuilder();
            for (int i = 0; i < rowCount; ++i) {
                JSONObject jo = algorithmJa.getJSONObject(i);
                String name = jo.getString("name");
                String desc = jo.getString("desc");
                if (i == 0) {
                    algorithmDesc.append(name).append('\uff1a').append(desc);
                } else {
                    algorithmDesc.append("<br/>").append(name).append('\uff1a').append(desc);
                }
                this.getModel().setValue("name", (Object)jo.getString("name"), rowIndex[i]);
                for (String algorithmError : AppConstants.ALGORITHM_ERROR_ARR) {
                    this.getModel().setValue(algorithmError, (Object)jo.getDouble(algorithmError), rowIndex[i]);
                }
            }
            this.getCache().put(KEY_CACHE_ALGORITHM_DESC, algorithmDesc.toString());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)tenantDTO.getIdsVersion(), (CharSequence)IdsVersionEnum.STANDARD.getKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_INFLUENCE_FACTOR});
        } else {
            JSONObject dataJo = this.loadAnaInfluenceFactorFromRemote(filterItemQuery, "0");
            this.refreshAnaInfluenceFactor(dataJo, "0");
        }
    }

    private void refreshAnaInfluenceFactor(JSONObject dataJo, String parentId) {
        if (dataJo == null || dataJo.isEmpty()) {
            return;
        }
        CustomControl chart = (CustomControl)this.getControl(KEY_INFLUENCE_FACTOR_CUSTOMCONTROLAP);
        if (chart != null) {
            dataJo.put("parentId", (Object)parentId);
            chart.setData((Object)dataJo);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (KEY_INFLUENCE_FACTOR_CUSTOMCONTROLAP.equals(controlKey) && KEY_CLICK.equals(eventName)) {
            try {
                JSONObject args = JSON.parseObject((String)eventArgs);
                this.loadAndRefreshAnaInfluenceFactorSecond(args.getString("id"));
            }
            catch (Exception ex) {
                this.log.warn("", (Throwable)ex);
            }
        }
    }

    private void loadAndRefreshAnaInfluenceFactorSecond(String parentId) {
        String anaInfluenceFactorData = this.getCurAnaInfluenceFactorData();
        if (StringUtils.isEmpty((CharSequence)anaInfluenceFactorData)) {
            return;
        }
        JSONObject data = JSON.parseObject((String)anaInfluenceFactorData);
        if (!data.containsKey((Object)parentId)) {
            FilterItemQuery currentFilterItemQuery = this.getCurFilterItemQuery();
            this.loadAnaInfluenceFactorFromRemote(currentFilterItemQuery, parentId);
            anaInfluenceFactorData = this.getCurAnaInfluenceFactorData();
            data = JSON.parseObject((String)anaInfluenceFactorData);
        }
        this.refreshAnaInfluenceFactor(data.getJSONObject(parentId), parentId);
    }

    private JSONObject loadAnaInfluenceFactorFromRemote(FilterItemQuery filterItemQuery, String parentId) {
        RequestContext rc = RequestContext.get();
        JSONObject dataJo = this.anaResultService().getInfluenceFactor(Long.valueOf(rc.getOrgId()), filterItemQuery, parentId);
        if (dataJo != null) {
            String s;
            JSONObject data = "0".equals(parentId) ? new JSONObject() : (StringUtils.isNotEmpty((CharSequence)(s = this.getCurAnaInfluenceFactorData())) ? JSON.parseObject((String)s) : new JSONObject());
            data.put(parentId, (Object)dataJo);
            this.setCurAnaInfluenceFactorData(data.toJSONString());
        }
        return dataJo;
    }

    private JSONArray loadAlgorithmErrorFromRemote(FilterItemQuery filterItemQuery) {
        RequestContext rc = RequestContext.get();
        JSONArray dataJa = this.anaResultService().getAlgorithmError(Long.valueOf(rc.getOrgId()), filterItemQuery);
        return dataJa;
    }

    private JSONArray loadAlgorithmErrorFromRemoteForStd(String subServiceId, String fschemeid) {
        JSONArray dataJa = this.sfStandardService().getAlgorithmError(subServiceId, Integer.parseInt(fschemeid));
        JSONArray newDataJa = new JSONArray();
        if (dataJa != null && dataJa.size() > 0) {
            for (Object obj : dataJa) {
                JSONObject jo = (JSONObject)obj;
                JSONObject newJo = new JSONObject();
                for (String newKey : jo.keySet()) {
                    String oldKey;
                    String string = oldKey = StringUtils.startsWith((CharSequence)newKey, (CharSequence)"f") ? newKey.substring(1) : newKey;
                    if (oldKey.equalsIgnoreCase("wmapeamt")) {
                        oldKey = "wmape_amt";
                    }
                    newJo.put(oldKey, (Object)jo.getString(newKey));
                }
                newDataJa.add((Object)newJo);
            }
        }
        return newDataJa;
    }
}

