/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.enumtype.ActionEnum;
import kd.ai.ids.core.enumtype.DimFilterTypeEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.query.data.FilterItemValuesDTO;
import kd.ai.ids.core.query.data.HomeOverviewQuery;
import kd.ai.ids.core.query.data.PredictObjCheckQuery;
import kd.ai.ids.core.query.data.PredictObjConfigQuery;
import kd.ai.ids.core.query.data.PredictObjListQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.MathUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.form.PredictObjConfigContext;
import kd.ai.ids.plugin.form.PredictObjConfigDataProvider;
import kd.ai.ids.plugin.tool.ShowTipsTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;

public class PredictObjConfigFormPlugin
extends BaseFormPlugin
implements CreateListColumnsListener,
TabSelectListener {
    public static final String KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP = "modSchemeSelectMap_";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_COMBO_MOD_SCHEME_SELECT = "combomodschemeselect";
    private static final String KEY_BILL_LIST_AP_PREDICT_DETAIL = "billlistappredictobj";
    private static final String KEY_LISTGRIDVIEW_PREDICT_DETAIL = "listgridviewpredictdetail";
    private PredictObjConfigContext ctx = null;
    private AtomicBoolean initBillListListener = new AtomicBoolean(false);
    private static final String KEY_FLEX_DYNAMIC_FILTER = "flexdynamicfilter";
    private static final String KEY_PRE_DIM_LEVEL_NAME_N = "predimlevelname_%s";
    private static final String KEY_PRE_DIM_LEVEL_COUNT_N = "predimlevelcount_%s";
    private static final String KEY_FLEX_DIM_LEVEL_N = "flexdimlevel_%s";
    private static final String KEY_HOME_OVERVIEW_N = "homeoverview_%s";
    private static final String KEY_CURRENT_COUNT = "currentcount";
    private static final String KEY_CONTROL_FORGID = "forgid";
    private static final String KEY_FLEX_CUR_PREDICT_OBJ = "flexcurepredictobj";
    private static final String KEY_FLEX_CONFIG_PREDICT_OBJ = "flexconfigepredictobj";
    private static final String KEY_TABPAGE_PREDICT = "tabpage_predict";
    private static final String KEY_TABPAGE_CONFIG = "tabpage_config";
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_CONFIG_PREFIX = "config_";
    private static final String KEY_CONFIG_ENTRYENTITY = "configentryentity";
    private static final String[] CONFIG_ENTRY_ENTITY_ALL_DIM_FIELD = new String[]{"forgid", "fwarehouseid", "fcustid", "fmaterialid"};
    private static final String KEY_TOOLBARAP_CONFIG = "toolbarapconfig";
    private static final String KEY_BAR_ITEM_ADD_PREDICT = "baritemaddpredict";
    private static final String KEY_BAR_ITEM_CANCEL_PREDICT = "baritemcancelpredict";
    private static final String KEY_F_PREDIMTYPE_CODE = "fpredimtypecode";
    private static final String KEY_F_IS_PREDICT = "fispredict";
    private static final String KEY_IS_PREDICTED_LIST = "fispredictedlist";

    private JSONObject getHomeOverviewJo(String fmodeltypeid) {
        JSONObject jo = this.getCache().getAsObject(String.format(KEY_HOME_OVERVIEW_N, fmodeltypeid));
        return jo;
    }

    private JSONObject getModSchemeJo(String fmodeltypeid) {
        JSONObject jo = this.getCache().getAsObject(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + fmodeltypeid);
        return jo;
    }

    private boolean isPredictedList() {
        return Boolean.parseBoolean(this.getCache().get(KEY_IS_PREDICTED_LIST));
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.ctx == null) {
            this.ctx = new PredictObjConfigContext(this.getCache());
        }
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_PREDICT_DETAIL);
        billList.setBillFormId("ids_predict_obj_details");
        billList.setEntityId("ids_predict_obj_details");
        billList.setEntryEntity("ids_predict_obj_details");
        if (!this.initBillListListener.getAndSet(true)) {
            billList.addCreateListColumnsListener((CreateListColumnsListener)this);
            billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new PredictObjConfigDataProvider().setCtx(this.ctx)));
            billList.addPagerClickListener(pagerClickEvent -> {
                int currentPageIndex = pagerClickEvent.getCurrentPageIndex();
                int pageRows = pagerClickEvent.getPageRows();
                this.ctx.setPageIndex(currentPageIndex);
                this.ctx.setPageSize(pageRows);
            });
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_RESET});
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP_CONFIG});
    }

    public void itemClick(ItemClickEvent evt) {
        BaseResult baseResult;
        super.itemClick(evt);
        RequestContext rc = RequestContext.get();
        String itemKey = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_CONFIG_ENTRYENTITY);
        DynamicObjectCollection entityDoc = this.getModel().getEntryEntity(KEY_CONFIG_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> fpredimtypeCodeList = new ArrayList<String>(10);
        boolean hasDifferentStatus = false;
        int fispredict = -1;
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entityDoc.get(selectRow);
            fpredimtypeCodeList.add(dynamicObject.getString("config_fpredimtypecode"));
            int tempFispredict = dynamicObject.getInt("config_fispredict");
            if (fispredict != -1 && fispredict != tempFispredict) {
                hasDifferentStatus = true;
                break;
            }
            fispredict = tempFispredict;
        }
        if (hasDifferentStatus) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e00\u81f4\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"Common_Select_Same_Status_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
            return;
        }
        PredictObjConfigQuery predictObjConfigQuery = new PredictObjConfigQuery();
        predictObjConfigQuery.setFmodeltypeid(this.ctx.getCurModelTypeId());
        predictObjConfigQuery.setFuserid(rc.getUid());
        predictObjConfigQuery.setFusername(rc.getUserName());
        predictObjConfigQuery.setSubServiceId(this.ctx.getSubServiceId());
        predictObjConfigQuery.setFpredimentypeCodeList(fpredimtypeCodeList);
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)KEY_BAR_ITEM_ADD_PREDICT)) {
            predictObjConfigQuery.setFaction(ActionEnum.ADD.getId());
            if (fispredict == YesNoEnum.YES.getKey()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u52a0\u5165\u9884\u6d4b\u7684\u5bf9\u8c61\u65e0\u9700\u91cd\u590d\u52a0\u5165", (String)"PredictObjConfigFormPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)KEY_BAR_ITEM_CANCEL_PREDICT)) {
            predictObjConfigQuery.setFaction(ActionEnum.DELETE.getId());
            if (fispredict == YesNoEnum.NO.getKey()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u52a0\u5165\u9884\u6d4b\u7684\u5bf9\u8c61\u65e0\u9700\u53d6\u6d88", (String)"PredictObjConfigFormPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
        }
        if (Objects.equals((baseResult = this.predictObjService().configPredictObj(Long.valueOf(rc.getOrgId()), predictObjConfigQuery)).getErrcode(), BaseResult.SUCCESS)) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"Common_Save_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
            ShowTipsTools.showTipNotificationOnceIn2Seconds(this.getCache(), this.getView(), msg, BaseResult.SUCCESS);
            for (String fpredimentypeCode : fpredimtypeCodeList) {
                LogServiceHelper.addLog((IFormView)this.getView(), (String)itemKey, (String)String.format("\u6807\u8bc6:%s\uff0c\u6210\u529f", fpredimentypeCode));
            }
            if (this.isPredictedList()) {
                this.loadPredictConfigFromRemote(this.ctx.getCurFilterItemQuery());
            } else {
                this.loadConfigPredictObjList(false);
            }
        } else {
            this.getView().showErrorNotification(baseResult.getDescriptionCn());
            for (String fpredimentypeCode : fpredimtypeCodeList) {
                LogServiceHelper.addLog((IFormView)this.getView(), (String)itemKey, (String)String.format("\u6807\u8bc6:%s\uff0c\u5931\u8d25", fpredimentypeCode));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String btnKey = ctl.getKey();
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        String currentTab = tab.getCurrentTab();
        switch (btnKey) {
            case "btnrefresh": {
                if (KEY_TABPAGE_PREDICT.equalsIgnoreCase(currentTab)) {
                    this.loadCurrentPredictObjList();
                    break;
                }
                if (!KEY_TABPAGE_CONFIG.equals(currentTab)) break;
                this.loadConfigPredictObjList(false);
                break;
            }
            case "btnreset": {
                this.resetQueryCondition();
                if (KEY_TABPAGE_PREDICT.equalsIgnoreCase(currentTab)) {
                    this.loadCurrentPredictObjList();
                    break;
                }
                if (!KEY_TABPAGE_CONFIG.equals(currentTab)) break;
                this.loadPredictConfigFromRemote(this.ctx.getCurFilterItemQuery());
                break;
            }
        }
    }

    private void loadConfigPredictObjList(boolean isResetRefresh) {
        DynamicObject forgidDo = (DynamicObject)this.getModel().getValue(KEY_CONTROL_FORGID);
        JSONObject modSchemeJo = this.getModSchemeJo(this.ctx.getCurModelTypeId());
        String fpredimentype = modSchemeJo.getString("fpredimentype");
        String fpredimentypeFname = modSchemeJo.getString("fpredimentypeFname");
        String[] fpredimentypeArr = StringUtils.split((String)fpredimentype, (String)"/");
        String[] fpredimentypeFnameArr = StringUtils.split((String)fpredimentypeFname, (String)"/");
        String fpredimentypeCode = null;
        String emptyDimTypes = "";
        if (forgidDo != null) {
            fpredimentypeCode = forgidDo.getString("number");
        } else {
            emptyDimTypes = fpredimentypeFnameArr[0];
        }
        int fpredimentypeLength = fpredimentypeArr.length;
        for (int i = 0; i < fpredimentypeLength; ++i) {
            if (i == 0 || i == fpredimentypeLength - 1) continue;
            String dimType = fpredimentypeArr[i];
            DynamicObject dimDo = (DynamicObject)this.getModel().getValue(dimType);
            if (dimDo != null) {
                String fdimnumber = dimDo.getString("number");
                fpredimentypeCode = String.format("%s%s%s", fpredimentypeCode, "->", fdimnumber);
                continue;
            }
            emptyDimTypes = StringUtils.isEmpty((CharSequence)emptyDimTypes) ? fpredimentypeFnameArr[i] : String.format("%s,%s", emptyDimTypes, fpredimentypeFnameArr[i]);
        }
        String lastPredimentype = fpredimentypeArr[fpredimentypeArr.length - 1];
        MulBasedataDynamicObjectCollection fmaterialidsDoc = (MulBasedataDynamicObjectCollection)this.getModel().getValue(lastPredimentype);
        JSONObject dataJo = JSONObject.parseObject((String)"{\"total\":0,\"current\":1,\"pages\":0,\"size\":20,\"records\":[]}");
        int total = 0;
        if (fmaterialidsDoc != null && fmaterialidsDoc.size() > 0) {
            total = fmaterialidsDoc.size();
            JSONArray recordJa = new JSONArray();
            for (DynamicObject fmaterialidDo : fmaterialidsDoc) {
                String fmaterialnumber = fmaterialidDo.getDynamicObject(1).getString("number");
                String newFpredimentypeCode = String.format("%s%s%s", fpredimentypeCode, "->", fmaterialnumber);
                JSONObject recordJo = new JSONObject();
                recordJo.put("fpredimentypeCode", (Object)newFpredimentypeCode);
                recordJa.add((Object)recordJo);
            }
            dataJo.put("total", (Object)total);
            dataJo.put("size", (Object)20);
            dataJo.put("pages", (Object)(total % 20 == 0 ? total / 20 : total / 20 + 1));
            dataJo.put("records", (Object)recordJa);
        } else {
            String string = emptyDimTypes = StringUtils.isEmpty((CharSequence)emptyDimTypes) ? fpredimentypeFnameArr[fpredimentypeArr.length - 1] : String.format("%s,%s", emptyDimTypes, fpredimentypeFnameArr[fpredimentypeArr.length - 1]);
        }
        if (StringUtils.isNotEmpty((CharSequence)emptyDimTypes) && !isResetRefresh) {
            String s = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s", (String)"PredictObjConfigFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(s, emptyDimTypes));
            return;
        }
        BaseResult baseResult = new BaseResult();
        baseResult.setErrcode(BaseResult.SUCCESS);
        baseResult.setData((Object)dataJo);
        this.loadPredictConfigList(baseResult, false);
    }

    private void loadCurrentPredictObjList() {
        List<String> ffilteritemList;
        ArrayList<FilterItemValuesDTO> filterItemValuesDTOList = new ArrayList<FilterItemValuesDTO>();
        DynamicObject forgidDo = (DynamicObject)this.getModel().getValue(KEY_CONTROL_FORGID);
        JSONObject modSchemeJo = this.getModSchemeJo(this.ctx.getCurModelTypeId());
        String fpredimentype = modSchemeJo.getString("fpredimentype");
        String[] fpredimentypeArr = StringUtils.split((String)fpredimentype, (String)"/");
        if (forgidDo != null) {
            String forgidfnumber = forgidDo.getString("number");
            String dimType = fpredimentypeArr[0];
            FilterItemValuesDTO forgidDTO = new FilterItemValuesDTO();
            forgidDTO.setLabelId(dimType);
            forgidDTO.setValues(forgidfnumber);
            filterItemValuesDTOList.add(forgidDTO);
        }
        int fpredimentypeLength = fpredimentypeArr.length;
        for (int i = 0; i < fpredimentypeLength; ++i) {
            if (i == 0 || i == fpredimentypeLength - 1) continue;
            String dimType = fpredimentypeArr[i];
            DynamicObject dimDo = (DynamicObject)this.getModel().getValue(dimType);
            if (dimDo == null) continue;
            String fdimnumber = dimDo.getString("number");
            FilterItemValuesDTO fdimDTO = new FilterItemValuesDTO();
            fdimDTO.setLabelId(dimType);
            fdimDTO.setValues(fdimnumber);
            filterItemValuesDTOList.add(fdimDTO);
        }
        String ffilteritem = modSchemeJo.getString("ffilteritem");
        String[] ffilteritemArr = StringUtils.split((String)ffilteritem, (String)"/");
        String ffilteritemEntityId = modSchemeJo.getString("ffilteritemEntityId");
        String[] ffilteritemEntityIdArr = StringUtils.split((String)ffilteritemEntityId, (String)"/");
        if (ffilteritemArr != null && ffilteritemArr.length > 0 && (ffilteritemList = Arrays.asList(ffilteritemArr)).contains(DimFilterTypeEnum.FSUPPLIER.getId())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{DimFilterTypeEnum.FSUPPLIER.getId()});
            int i = ffilteritemList.indexOf(DimFilterTypeEnum.FSUPPLIER.getId());
            String dimType = ffilteritemArr[i];
            DynamicObject dimDo = (DynamicObject)this.getModel().getValue(dimType);
            if (dimDo != null) {
                String fdimnumber = dimDo.getString("number");
                FilterItemValuesDTO fdimDTO = new FilterItemValuesDTO();
                fdimDTO.setLabelId(dimType);
                fdimDTO.setValues(fdimnumber);
                filterItemValuesDTOList.add(fdimDTO);
            }
        }
        String lastPredimentype = fpredimentypeArr[fpredimentypeArr.length - 1];
        MulBasedataDynamicObjectCollection fmaterialidsDoc = (MulBasedataDynamicObjectCollection)this.getModel().getValue(lastPredimentype);
        if (fmaterialidsDoc != null && fmaterialidsDoc.size() > 0) {
            FilterItemValuesDTO fmaterialidDTO = new FilterItemValuesDTO();
            fmaterialidDTO.setLabelId(lastPredimentype);
            String fmaterialnumbers = "";
            for (DynamicObject fmaterialidDo : fmaterialidsDoc) {
                String fmaterialnumber = fmaterialidDo.getDynamicObject(1).getString("number");
                fmaterialnumbers = StringUtils.isEmpty((CharSequence)fmaterialnumbers) ? fmaterialnumber : String.format("%s,%s", fmaterialnumbers, fmaterialnumber);
            }
            fmaterialidDTO.setValues(fmaterialnumbers);
            filterItemValuesDTOList.add(fmaterialidDTO);
        }
        PredictObjListQuery predictObjListQuery = this.ctx.getCurFilterItemQuery();
        predictObjListQuery.setFilterItemValuesDTOList(filterItemValuesDTOList);
        this.loadDetailListFromRemote(predictObjListQuery);
        this.refreshBillList();
    }

    private PredictObjListQuery resetQueryCondition() {
        List<String> ffilteritemList;
        PredictObjListQuery curFilterItemQuery = this.ctx.getCurFilterItemQuery();
        JSONObject modSchemeJo = this.getModSchemeJo(this.ctx.getCurModelTypeId());
        String fpredimentype = modSchemeJo.getString("fpredimentype");
        String[] fpredimentypeArr = fpredimentype.split("/");
        int fpredimentypeLength = fpredimentypeArr.length;
        this.getModel().setValue(KEY_CONTROL_FORGID, null);
        for (int i = 0; i < fpredimentypeLength; ++i) {
            if (i == 0) continue;
            String dimType = fpredimentypeArr[i];
            this.getModel().setValue(dimType, null);
        }
        String ffilteritem = modSchemeJo.getString("ffilteritem");
        String[] ffilteritemArr = StringUtils.split((String)ffilteritem, (String)"/");
        if (ffilteritemArr != null && ffilteritemArr.length > 0 && (ffilteritemList = Arrays.asList(ffilteritemArr)).contains(DimFilterTypeEnum.FSUPPLIER.getId())) {
            this.getModel().setValue(DimFilterTypeEnum.FSUPPLIER.getId(), null);
        }
        if (curFilterItemQuery != null) {
            curFilterItemQuery.setCurrent(Long.valueOf(1L));
            curFilterItemQuery.setOrderByExpr(null);
            curFilterItemQuery.setFilters(null);
            curFilterItemQuery.setFilterItemValuesDTOList(null);
        }
        this.ctx.setCurFilterItemQuery(curFilterItemQuery);
        return curFilterItemQuery;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_MOD_SCHEME_SELECT)) {
            String fmodeltypeid = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            this.openPredictObjConfig(fmodeltypeid);
            this.getView().close();
        }
    }

    private void openPredictObjConfig(String fmodeltypeid) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("fmodeltypeid", fmodeltypeid);
        String caption = ResManager.loadKDString((String)"\u914d\u7f6e\u9884\u6d4b\u5bf9\u8c61\u8303\u56f4", (String)"PredictObjConfigFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ids_predict_obj_config");
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fmodeltypeid = (String)formShowParameter.getCustomParam("fmodeltypeid");
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.ctx.setSubServiceId(subServiceId);
        this.loadHomeOverview();
        this.loadOnlineModelTypeList(fmodeltypeid);
        PredictObjListQuery predictObjListQuery = new PredictObjListQuery();
        predictObjListQuery.setSubServiceId(subServiceId);
        predictObjListQuery.setFmodeltypeid(fmodeltypeid);
        this.loadDetailListFromRemote(predictObjListQuery);
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP_PREDICT_DETAIL);
        billList.setPageIndex(1);
        billList.clearSelection();
        billList.refresh();
    }

    private void loadDetailListFromRemote(PredictObjListQuery filterItemQuery) {
        RequestContext rc = RequestContext.get();
        this.ctx.setCurFilterItemQuery(filterItemQuery);
        filterItemQuery.setNeedRecord(Boolean.FALSE);
        BaseResult baseResult = this.predictObjService().getPredictObjDetailList(Long.valueOf(rc.getOrgId()), filterItemQuery);
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            this.ctx.setCurrDetailListBaseResult(baseResult);
        } else {
            this.ctx.setCurrDetailListBaseResult(BaseResult.fail((String)"", (String)""));
        }
    }

    private void loadPredictConfigFromRemote(PredictObjListQuery filterItemQuery) {
        RequestContext rc = RequestContext.get();
        this.ctx.setCurFilterItemQuery(filterItemQuery);
        filterItemQuery.setSize(Long.valueOf(Long.parseLong(String.valueOf(Integer.MAX_VALUE))));
        BaseResult baseResult = this.predictObjService().getPredictObjConfigList(Long.valueOf(rc.getOrgId()), filterItemQuery);
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            this.loadPredictConfigList(baseResult, true);
        } else {
            this.ctx.setCurrDetailListBaseResult(BaseResult.fail((String)"", (String)""));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadPredictConfigList(BaseResult baseResult, boolean isPredicted) {
        this.getCache().put(KEY_IS_PREDICTED_LIST, String.valueOf(isPredicted));
        this.getModel().deleteEntryData(KEY_CONFIG_ENTRYENTITY);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_CONFIG_ENTRYENTITY);
        JSONObject modSchemeJo = this.getModSchemeJo(this.ctx.getCurModelTypeId());
        String ffilteritem = modSchemeJo.getString("ffilteritem");
        String ffilteritemFname = modSchemeJo.getString("ffilteritemFname");
        String[] ffilteritemArr = StringUtils.split((String)ffilteritem, (String)"/");
        String[] ffilteritemFnameArr = StringUtils.split((String)ffilteritemFname, (String)"/");
        if (ffilteritemArr != null && ffilteritemArr.length > 0) {
            List<String> ffilteritemList = Arrays.asList(ffilteritemArr);
            if (ffilteritemList.contains(DimFilterTypeEnum.FSUPPLIER.getId())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{DimFilterTypeEnum.FSUPPLIER.getId()});
            }
            for (int i = 0; i < ffilteritemArr.length; ++i) {
                String filteritem = ffilteritemArr[i];
                entryGrid.setColumnProperty(KEY_CONFIG_PREFIX + filteritem, "header", (Object)new LocaleString(ffilteritemFnameArr[i]));
            }
        }
        JSONObject dataJo = baseResult.getDataAsJSONObject();
        JSONArray recordJa = dataJo.getJSONArray("records");
        ArrayList<String> fpredimtypeCodeList = new ArrayList<String>();
        String fpredimentype = modSchemeJo.getString("fpredimentype");
        String fpredimentypeFname = modSchemeJo.getString("fpredimentypeFname");
        String fpredimentypeEntityId = modSchemeJo.getString("fpredimentypeEntityId");
        String[] fpredimentypeArr = StringUtils.split((String)fpredimentype, (String)"/");
        String[] fpredimentypeFnameArr = StringUtils.split((String)fpredimentypeFname, (String)"/");
        String[] fpredimentypeEntityIdArr = StringUtils.split((String)fpredimentypeEntityId, (String)"/");
        for (int i = 0; i < fpredimentypeArr.length; ++i) {
            String dimType = fpredimentypeArr[i];
            if (i == 0) {
                dimType = KEY_CONTROL_FORGID;
            }
            entryGrid.setColumnProperty(KEY_CONFIG_PREFIX + dimType, "header", (Object)new LocaleString(fpredimentypeFnameArr[i]));
        }
        if (recordJa != null && recordJa.size() > 0) {
            HashMap<String, void> dimTypeNumberListMap = new HashMap<String, void>();
            HashMap<String, void> dimTypeNumberDoMap = new HashMap<String, void>();
            List fieldEdits = entryGrid.getFieldEdits();
            List<String> dimFieldKeyList = Arrays.asList(fpredimentypeArr);
            for (int i = 0; i < fieldEdits.size(); ++i) {
                String dimType;
                FieldEdit fieldEdit = (FieldEdit)fieldEdits.get(i);
                String fieldKey = fieldEdit.getFieldKey();
                String[] s = fieldKey.split("_", 2);
                String string = dimType = s != null && s.length >= 2 ? s[1] : fieldKey;
                if (!dimFieldKeyList.contains(dimType) && Arrays.asList(CONFIG_ENTRY_ENTITY_ALL_DIM_FIELD).contains(dimType)) {
                    fieldEdit.setVisible(fieldKey, false);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)DimFilterTypeEnum.FSUPPLIER.getId()) && !tenantDTO.getTenantName().toLowerCase().contains("mybic")) {
                    fieldEdit.setVisible(fieldKey, false);
                }
                if (!dimType.equalsIgnoreCase(KEY_CONTROL_FORGID)) continue;
                fieldEdit.setVisible("config_forgid", true);
            }
            Map<String, Integer> fpredimentypeCodeFispredictMap = null;
            if (!isPredicted) {
                fpredimentypeCodeFispredictMap = this.getFpredimentypeCodeFispredictMap(rc, recordJa, fpredimtypeCodeList);
            }
            for (Object obj : recordJa) {
                JSONObject itemJo = (JSONObject)obj;
                String fpredimtypeCode = itemJo.getString("fpredimentypeCode");
                String newFpredimentypeCode = fpredimtypeCode.replaceAll("->", "====");
                String[] fpredimentypeCodeArr = StringUtils.split((String)newFpredimentypeCode, (String)"====");
                for (int i = 0; i < fpredimentypeArr.length; ++i) {
                    void var33_45;
                    String dimType = fpredimentypeArr[i];
                    List list = (List)dimTypeNumberListMap.get(dimType);
                    if (list == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var33_45.add(fpredimentypeCodeArr[i]);
                    dimTypeNumberListMap.put(dimType, var33_45);
                }
            }
            HashMap<Object, String> orgmaterialnumberSuppliernameMap = new HashMap<Object, String>();
            if (tenantDTO.getTenantName().toLowerCase().contains("mybic")) {
                String fsupplierNameFieldKey = "axnz_supplier.name";
                List forgnumberList = ((List)dimTypeNumberListMap.get(fpredimentypeArr[0])).stream().distinct().collect(Collectors.toList());
                List fmaterialnumberList = ((List)dimTypeNumberListMap.get(fpredimentypeArr[fpredimentypeArr.length - 1])).stream().distinct().collect(Collectors.toList());
                DynamicObject[] materialpurchaseinfoDoArr = BusinessDataServiceHelper.load((String)"bd_materialpurchaseinfo", (String)String.format("id,org.number,masterid.number,%s", fsupplierNameFieldKey), (QFilter[])new QFilter("masterid.number", "in", fmaterialnumberList).and("org.number", "in", forgnumberList).toArray());
                if (materialpurchaseinfoDoArr != null && materialpurchaseinfoDoArr.length > 0) {
                    for (String string : materialpurchaseinfoDoArr) {
                        String orgmaterialnumber = String.format("%s%s", string.getString("org.number"), string.getString("masterid.number"));
                        String suppliername = string.getString(fsupplierNameFieldKey);
                        orgmaterialnumberSuppliernameMap.put(orgmaterialnumber, suppliername);
                    }
                }
            }
            for (int i = 0; i < fpredimentypeArr.length; ++i) {
                void var33_53;
                DynamicObjectCollection doc;
                String dimType = fpredimentypeArr[i];
                String entityId = i == 0 ? "bos_org" : fpredimentypeEntityIdArr[i];
                List numberList = (List)dimTypeNumberListMap.get(dimType);
                QFilter qFilter = new QFilter("number", "in", (Object)numberList);
                String selectFields = "number,name";
                if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"fmaterialid")) {
                    selectFields = "number,name,group.fullname";
                }
                if ((doc = QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])qFilter.toArray())) == null || doc.size() <= 0) continue;
                Map map = (Map)dimTypeNumberDoMap.get(dimType);
                if (map == null) {
                    HashMap hashMap = new HashMap();
                }
                for (DynamicObject dimDo : doc) {
                    var33_53.put(dimDo.getString("number"), dimDo);
                }
                dimTypeNumberDoMap.put(dimType, var33_53);
            }
            int rowCount = recordJa.size();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_CONFIG_ENTRYENTITY, rowCount);
            for (int j = 0; j < rowCount; ++j) {
                int row = rowIndex[j];
                JSONObject itemJo = recordJa.getJSONObject(j);
                String fpredimtypeCode = itemJo.getString("fpredimentypeCode");
                String newFpredimentypeCode = fpredimtypeCode.replaceAll("->", "====");
                String[] stringArray = StringUtils.split((String)newFpredimentypeCode, (String)"====");
                Integer isPredict = fpredimentypeCodeFispredictMap != null ? fpredimentypeCodeFispredictMap.getOrDefault(fpredimtypeCode, 0) : Integer.valueOf(0);
                this.getModel().setValue("config_fpredimtypecode", (Object)fpredimtypeCode, row);
                this.getModel().setValue("config_fispredict", (Object)(isPredicted ? Integer.valueOf(YesNoEnum.YES.getKey()) : isPredict), row);
                int fpredimentypeLength = fpredimentypeArr.length;
                String forgnumber = "";
                for (int i = 0; i < fpredimentypeLength; ++i) {
                    String colName;
                    String dimType = fpredimentypeArr[i];
                    Map numberDoMap = (Map)dimTypeNumberDoMap.get(dimType);
                    DynamicObject dimDo = (DynamicObject)numberDoMap.get(stringArray[i]);
                    String value = dimDo.getString("name");
                    String string = colName = i == 0 ? "config_forgid" : KEY_CONFIG_PREFIX + dimType;
                    if (i == 0) {
                        forgnumber = dimDo.getString("number");
                    }
                    this.getModel().setValue(colName, (Object)value, row);
                    if (i != fpredimentypeLength - 1 || !StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"fmaterialid")) continue;
                    String fmaterialnumber = dimDo.getString("number");
                    if (tenantDTO.getTenantName().toLowerCase().contains("mybic")) {
                        String orgmaterialnumber = String.format("%s%s", forgnumber, fmaterialnumber);
                        String suppliername = (String)orgmaterialnumberSuppliernameMap.get(orgmaterialnumber);
                        this.getModel().setValue("config_fsupplier", (Object)suppliername, row);
                    }
                    this.getModel().setValue("config_fmaterialnumber", (Object)fmaterialnumber, row);
                    String materialGroupFullName = dimDo.getString("group.fullname");
                    String[] materialGroupFullNameArr = materialGroupFullName != null ? materialGroupFullName.split("!") : null;
                    String flevel1fname = null;
                    String flevel2fname = null;
                    String flevel3fname = null;
                    if (materialGroupFullNameArr != null) {
                        flevel1fname = materialGroupFullNameArr.length >= 1 ? materialGroupFullNameArr[0] : "";
                        flevel2fname = materialGroupFullNameArr.length >= 2 ? materialGroupFullNameArr[1] : "";
                        flevel3fname = materialGroupFullNameArr.length >= 3 ? materialGroupFullNameArr[2] : "";
                    }
                    this.getModel().setValue("config_fbrand1level", (Object)flevel1fname, row);
                    this.getModel().setValue("config_fbrand2level", (Object)flevel2fname, row);
                    this.getModel().setValue("config_fbrand3level", (Object)flevel3fname, row);
                }
            }
            entryGrid.setSplitPage(true);
            entryGrid.setPageIndex(dataJo.getInteger("current").intValue());
            entryGrid.setPageRow(20);
            entryGrid.setPageRows(20);
        }
    }

    private Map<String, Integer> getFpredimentypeCodeFispredictMap(RequestContext rc, JSONArray recordJa, List<String> fpredimtypeCodeList) {
        JSONArray dataJa;
        HashMap<String, Integer> fpredimentypeCodeFispredictMap = new HashMap<String, Integer>();
        for (Object obj : recordJa) {
            JSONObject itemJo = (JSONObject)obj;
            String fpredimtypeCode = itemJo.getString("fpredimentypeCode");
            fpredimtypeCodeList.add(fpredimtypeCode);
        }
        PredictObjCheckQuery predictObjCheckQuery = new PredictObjCheckQuery();
        predictObjCheckQuery.setFpredimentypeCodeList(fpredimtypeCodeList);
        predictObjCheckQuery.setFmodeltypeid(this.ctx.getCurModelTypeId());
        predictObjCheckQuery.setSubServiceId(this.ctx.getSubServiceId());
        BaseResult checkBaseResult = this.predictObjService().getPredictObjConfigCheck(Long.valueOf(rc.getOrgId()), predictObjCheckQuery);
        if (Objects.equals(checkBaseResult.getErrcode(), BaseResult.SUCCESS) && (dataJa = checkBaseResult.getDataAsJSONArray()) != null && dataJa.size() > 0) {
            for (Object obj : dataJa) {
                JSONObject itemJo = (JSONObject)obj;
                fpredimentypeCodeFispredictMap.put(itemJo.getString("fpredimentypeCode"), itemJo.getIntValue(KEY_F_IS_PREDICT));
            }
        }
        return fpredimentypeCodeFispredictMap;
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        IListColumn seqListColumn = (IListColumn)columns.get(0);
        columns.clear();
        columns.add(seqListColumn);
        BaseResult baseResult = this.ctx.getCurLastDetailBaseResult();
        if (baseResult != null && Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            JSONArray fieldsJa = CommonUtil.emptyIfNull((JSONArray)dataJo.getJSONArray("fields"));
            ArrayList<String> fieldList = new ArrayList<String>(10);
            for (int i = 0; i < fieldsJa.size(); ++i) {
                JSONObject fieldsJo = fieldsJa.getJSONObject(i);
                String s = fieldsJo.getString("id");
                String id = s != null ? s.toLowerCase() : "";
                fieldList.add(id);
                boolean allowOrder = fieldsJo.getBooleanValue("allowOrder");
                boolean allowFilter = fieldsJo.getBooleanValue("allowFilter");
                boolean isHyperlink = false;
                ListColumn listColumn = this.createListColumn(id, fieldsJo.getString("name"), i + 1, allowOrder, allowFilter, isHyperlink);
                listColumn.setParentViewKey(KEY_LISTGRIDVIEW_PREDICT_DETAIL);
                columns.add(listColumn);
            }
            this.ctx.setPredictDetailFieldList(fieldList);
        }
    }

    private ListColumn createListColumn(String key, String caption, int colIndex, boolean allowOrder, boolean allowFilter, boolean isHyperlink) {
        ListColumn col = new ListColumn();
        this.setListColumnProperties(key, caption, colIndex, allowOrder, allowFilter, col, isHyperlink);
        return col;
    }

    private void setListColumnProperties(String key, String caption, int colIndex, boolean allowOrder, boolean allowFilter, ListColumn col, boolean isHyperlink) {
        col.setCaption(new LocaleString(caption));
        col.setListFieldKey(key);
        col.setKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setWidth(new LocaleString("8%"));
        col.setBlankFieldCanOrderAndFilter(true);
        col.setColumnOrder(allowOrder);
        col.setColumnFilter(allowFilter);
        col.setHyperlink(isHyperlink);
    }

    private void loadOnlineModelTypeData(String fmodeltypeid) {
        RequestContext rc = RequestContext.get();
        JSONArray dataJa = this.anaResultService().getOnlineSchemeList(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        int len = dataJa.size();
        HashMap<String, String> modSchemeSelectMap = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            JSONObject jo = dataJa.getJSONObject(i);
            String modelTypeId = jo.getString("fmodeltypeid");
            if (StringUtils.isEmpty((CharSequence)fmodeltypeid)) {
                fmodeltypeid = modelTypeId;
            }
            modSchemeSelectMap.put(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId, jo.toJSONString());
        }
        this.getCache().put(modSchemeSelectMap);
        this.ctx.setCurModelTypeId(fmodeltypeid);
    }

    private void loadOnlineModelTypeList(String fmodeltypeid) {
        RequestContext rc = RequestContext.get();
        JSONArray dataJa = this.anaResultService().getOnlineSchemeList(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_MOD_SCHEME_SELECT);
        int len = dataJa.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        HashMap<String, String> modSchemeSelectMap = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            JSONObject jo = dataJa.getJSONObject(i);
            String modelTypeId = jo.getString("fmodeltypeid");
            if (StringUtils.isEmpty((CharSequence)fmodeltypeid)) {
                fmodeltypeid = modelTypeId;
            }
            modSchemeSelectMap.put(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId, jo.toJSONString());
            LocaleString comboItemText = new LocaleString(jo.getString("fmodeltypeidFname"));
            ComboItem comboItem = new ComboItem(comboItemText, modelTypeId);
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
        this.getCache().put(modSchemeSelectMap);
        this.ctx.setCurModelTypeId(fmodeltypeid);
        this.loadModelSummary(fmodeltypeid);
        this.getModel().setValue(KEY_COMBO_MOD_SCHEME_SELECT, (Object)fmodeltypeid);
    }

    private void loadHomeOverview() {
        RequestContext rc = RequestContext.get();
        HomeOverviewQuery homeOverviewQuery = new HomeOverviewQuery();
        homeOverviewQuery.setSubServiceId(this.ctx.getSubServiceId());
        BaseResult baseResult = this.anaResultService().getHomeOverview(Long.valueOf(rc.getOrgId()), homeOverviewQuery);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
            int modelCount;
            JSONArray dataJa = baseResult.getDataAsJSONArray();
            int n = modelCount = dataJa != null ? dataJa.size() : 0;
            if (dataJa != null && modelCount > 0) {
                for (int index = 0; index < dataJa.size(); ++index) {
                    JSONObject jo = (JSONObject)dataJa.get(index);
                    String fmodeltypeid = jo.getString("fmodeltypeid");
                    JSONObject homeOverviewJo = jo.getJSONObject("homeOverview");
                    if (homeOverviewJo == null) continue;
                    this.getCache().put(String.format(KEY_HOME_OVERVIEW_N, fmodeltypeid), homeOverviewJo.toJSONString());
                }
            }
        }
    }

    private void loadModelSummary(String fmodeltypeid) {
        int i;
        RequestContext rc = RequestContext.get();
        JSONObject dataJo = this.anaResultService().getFilterItem(Long.valueOf(rc.getOrgId()), this.ctx.getSubServiceId(), fmodeltypeid, false);
        JSONObject homeOverviewJo = this.getHomeOverviewJo(fmodeltypeid);
        JSONArray predimenttypeArray = dataJo.getJSONArray("predimenttypeArray");
        int dimCount = 0;
        if (predimenttypeArray != null && !predimenttypeArray.isEmpty()) {
            dimCount = predimenttypeArray.size();
            for (i = 0; i < dimCount; ++i) {
                JSONObject predimentypeJo = (JSONObject)predimenttypeArray.get(i);
                String labelId = predimentypeJo.getString("labelId");
                String labelName = predimentypeJo.getString("labelName");
                this.setLabelText(String.format(KEY_PRE_DIM_LEVEL_NAME_N, i + 1), String.format("\u9884\u6d4b%s\uff1a", labelName));
                this.setLabelText(String.format(KEY_PRE_DIM_LEVEL_COUNT_N, i + 1), String.valueOf(homeOverviewJo.getIntValue(String.format("%sCount", labelId))));
            }
        }
        this.setLabelText(KEY_CURRENT_COUNT, MathUtils.normalNum((String)homeOverviewJo.getString("currentCount")));
        for (i = 0; i < 5; ++i) {
            this.getView().setVisible(Boolean.valueOf(dimCount >= i + 1), new String[]{String.format(KEY_FLEX_DIM_LEVEL_N, i + 1)});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_CUR_PREDICT_OBJ});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_CONFIG_PREDICT_OBJ});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        boolean isOnline = false;
        if (tenantDTO != null) {
            isOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        }
        if (!isOnline) {
            e.setCancel(true);
            Object source = e.getSource();
            if (!(source instanceof FormShowParameter)) {
                return;
            }
            FormShowParameter fsp = (FormShowParameter)source;
            String parentPageId = fsp.getParentPageId();
            IdsPageCache parentCache = new IdsPageCache(parentPageId);
            parentCache.put("is_online_" + fsp.getFormId(), "false");
            parentCache.saveChanges();
        }
    }

    @Override
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        this.ctx = new PredictObjConfigContext(this.getCache());
        String fmodeltypeid = (String)formShowParameter.getCustomParam("fmodeltypeid");
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.ctx.setSubServiceId(subServiceId);
        this.loadHomeOverview();
        this.loadOnlineModelTypeData(fmodeltypeid);
        FlexPanelAp headAp = this.createDynamicPanel(fmodeltypeid);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", KEY_FLEX_DYNAMIC_FILTER);
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FlexPanelAp dynamicPanel = this.createDynamicPanel(this.ctx.getCurModelTypeId());
        Container myFldPanel = (Container)this.getView().getControl(KEY_FLEX_DYNAMIC_FILTER);
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        JSONObject modSchemeJo = this.getModSchemeJo(this.ctx.getCurModelTypeId());
        if (modSchemeJo != null) {
            BasedataEdit baseEdit;
            String fpredimentype = modSchemeJo.getString("fpredimentype");
            String fpredimentypeFname = modSchemeJo.getString("fpredimentypeFname");
            String[] fpredimentypeArr = StringUtils.split((String)fpredimentype, (String)"/");
            String[] fpredimentypeFnameArr = StringUtils.split((String)fpredimentypeFname, (String)"/");
            String ffilteritem = modSchemeJo.getString("ffilteritem");
            String ffilteritemFname = modSchemeJo.getString("ffilteritemFname");
            String[] ffilteritemArr = StringUtils.split((String)ffilteritem, (String)"/");
            int fpredimentypeLength = fpredimentypeArr.length;
            for (int i = 0; i < fpredimentypeLength; ++i) {
                if (i == 0 || i == fpredimentypeLength - 1) continue;
                String fieldKey = fpredimentypeArr[i];
                String fieldName = fpredimentypeFnameArr[i];
                if (!e.getKey().equalsIgnoreCase(fieldKey)) continue;
                baseEdit = new BasedataEdit();
                baseEdit.setKey(fieldKey);
                baseEdit.setView(this.getView());
                e.setControl((Control)baseEdit);
            }
            if (ffilteritemArr != null && ffilteritemArr.length > 0) {
                List<String> ffilteritemList = Arrays.asList(ffilteritemArr);
                if (e.getKey().equalsIgnoreCase(DimFilterTypeEnum.FSUPPLIER.getId()) && Arrays.asList(ffilteritemArr).contains(DimFilterTypeEnum.FSUPPLIER.getId())) {
                    int i = ffilteritemList.indexOf(DimFilterTypeEnum.FSUPPLIER.getId());
                    String fieldKey = ffilteritemArr[i];
                    baseEdit = new BasedataEdit();
                    baseEdit.setKey(fieldKey);
                    baseEdit.setView(this.getView());
                    e.setControl((Control)baseEdit);
                }
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fmodeltypeid = (String)formShowParameter.getCustomParam("fmodeltypeid");
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.ctx.setSubServiceId(subServiceId);
        this.loadOnlineModelTypeData(fmodeltypeid);
        JSONObject modSchemeJo = this.getModSchemeJo(this.ctx.getCurModelTypeId());
        String fpredimentypeFname = modSchemeJo.getString("fpredimentypeFname");
        String fpredimentypeEntityId = modSchemeJo.getString("fpredimentypeEntityId");
        String[] fpredimentypeFnameArr = StringUtils.split((String)fpredimentypeFname, (String)"/");
        String[] fpredimentypeEntityIdArr = StringUtils.split((String)fpredimentypeEntityId, (String)"/");
        OrgEdit orgEdit = (OrgEdit)this.getControl(KEY_CONTROL_FORGID);
        orgEdit.setOrgFunc(fpredimentypeEntityIdArr[0]);
        orgEdit.setText(fpredimentypeFnameArr[0]);
        orgEdit.setCaption(new LocaleString(fpredimentypeFnameArr[0]));
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registerEntityTypes(newMainType);
        e.setNewEntityType(newMainType);
    }

    private FlexPanelAp createDynamicPanel(String fmodeltypeid) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        JSONObject modSchemeJo = this.getModSchemeJo(fmodeltypeid);
        String fpredimentype = modSchemeJo.getString("fpredimentype");
        String fpredimentypeFname = modSchemeJo.getString("fpredimentypeFname");
        String fpredimentypeEntityId = modSchemeJo.getString("fpredimentypeEntityId");
        String ffilteritemEntityId = modSchemeJo.getString("ffilteritemEntityId");
        String[] fpredimentypeArr = StringUtils.split((String)fpredimentype, (String)"/");
        String[] fpredimentypeFnameArr = StringUtils.split((String)fpredimentypeFname, (String)"/");
        String[] fpredimentypeEntityIdArr = StringUtils.split((String)fpredimentypeEntityId, (String)"/");
        String[] ffilteritemEntityIdArr = StringUtils.split((String)ffilteritemEntityId, (String)"/");
        String ffilteritem = modSchemeJo.getString("ffilteritem");
        String ffilteritemFname = modSchemeJo.getString("ffilteritemFname");
        String[] ffilteritemArr = StringUtils.split((String)ffilteritem, (String)"/");
        String[] ffilteritemFnameArr = StringUtils.split((String)ffilteritemFname, (String)"/");
        int fpredimentypeLength = fpredimentypeArr.length;
        for (int i = 0; i < fpredimentypeLength; ++i) {
            if (i == 0 || i == fpredimentypeLength - 1) continue;
            String fieldKey = fpredimentypeArr[i];
            String fieldName = fpredimentypeFnameArr[i];
            String baseEntityId = fpredimentypeEntityIdArr[i];
            FieldAp fieldAp = this.createFieldAp(fieldKey, fieldName, baseEntityId);
            headPanelAp.getItems().add(fieldAp);
        }
        if (ffilteritemArr != null && ffilteritemArr.length > 0) {
            List<String> ffilteritemList = Arrays.asList(ffilteritemArr);
            if (Arrays.asList(ffilteritemArr).contains(DimFilterTypeEnum.FSUPPLIER.getId())) {
                int i = ffilteritemList.indexOf(DimFilterTypeEnum.FSUPPLIER.getId());
                String fieldKey = ffilteritemArr[i];
                String fieldName = ffilteritemFnameArr[i];
                String baseEntityId = ffilteritemEntityIdArr[i];
                FieldAp fieldAp = this.createFieldAp(fieldKey, fieldName, baseEntityId);
                headPanelAp.getItems().add(fieldAp);
            }
        }
        return headPanelAp;
    }

    private FieldAp createFieldAp(String fieldKey, String fieldName, String baseEntityId) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(fieldKey);
        fieldAp.setKey(fieldKey);
        fieldAp.setName(new LocaleString(fieldName));
        fieldAp.setFireUpdEvt(true);
        BasedataField ba = new BasedataField();
        ba.setId(fieldKey);
        ba.setKey(fieldKey);
        ba.setBaseEntityId(baseEntityId);
        ba.setOrgFieldId(KEY_CONTROL_FORGID);
        fieldAp.setField((Field)ba);
        return fieldAp;
    }

    private void registerEntityTypes(MainEntityType newMainType) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fmodeltypeid = (String)formShowParameter.getCustomParam("fmodeltypeid");
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.ctx.setSubServiceId(subServiceId);
        this.loadOnlineModelTypeData(fmodeltypeid);
        JSONObject modSchemeJo = this.getModSchemeJo(this.ctx.getCurModelTypeId());
        if (modSchemeJo != null) {
            String fpredimentype = modSchemeJo.getString("fpredimentype");
            String fpredimentypeEntityId = modSchemeJo.getString("fpredimentypeEntityId");
            String ffilteritemEntityId = modSchemeJo.getString("ffilteritemEntityId");
            String[] fpredimentypeArr = StringUtils.split((String)fpredimentype, (String)"/");
            String[] fpredimentypeEntityIdArr = StringUtils.split((String)fpredimentypeEntityId, (String)"/");
            String[] ffilteritemEntityIdArr = StringUtils.split((String)ffilteritemEntityId, (String)"/");
            String ffilteritem = modSchemeJo.getString("ffilteritem");
            String[] ffilteritemArr = StringUtils.split((String)ffilteritem, (String)"/");
            int fpredimentypeLength = fpredimentypeArr.length;
            for (int i = 0; i < fpredimentypeLength; ++i) {
                if (i == 0 || i == fpredimentypeLength - 1) continue;
                String fieldKey = fpredimentypeArr[i];
                String baseEntityId = fpredimentypeEntityIdArr[i];
                BasedataProp bdMatProp = this.createBasedataProp(newMainType, fieldKey, baseEntityId);
                newMainType.registerComplexProperty((DynamicComplexProperty)bdMatProp);
            }
            if (ffilteritemArr != null && ffilteritemArr.length > 0) {
                List<String> ffilteritemList = Arrays.asList(ffilteritemArr);
                if (Arrays.asList(ffilteritemArr).contains(DimFilterTypeEnum.FSUPPLIER.getId())) {
                    int i = ffilteritemList.indexOf(DimFilterTypeEnum.FSUPPLIER.getId());
                    String fieldKey = ffilteritemArr[i];
                    String baseEntityId = ffilteritemEntityIdArr[i];
                    BasedataProp bdMatProp = this.createBasedataProp(newMainType, fieldKey, baseEntityId);
                    newMainType.registerComplexProperty((DynamicComplexProperty)bdMatProp);
                }
            }
        }
    }

    private BasedataProp createBasedataProp(MainEntityType newMainType, String fieldKey, String baseEntityId) {
        BasedataProp bdMatProp = new BasedataProp();
        bdMatProp.setDbIgnore(true);
        bdMatProp.setBaseEntityId(baseEntityId);
        bdMatProp.setName(fieldKey);
        bdMatProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityId));
        bdMatProp.setOrgProp(KEY_CONTROL_FORGID);
        DynamicSimpleProperty pMatRefId = bdMatProp.createRefIDProp();
        pMatRefId.setPrimaryKey(false);
        pMatRefId.setName(fieldKey + "_id");
        pMatRefId.setDbIgnore(true);
        bdMatProp.setRefIdProp((IDataEntityProperty)pMatRefId);
        bdMatProp.setRefIdPropName(fieldKey + "_id");
        newMainType.addProperty((DynamicProperty)pMatRefId);
        return bdMatProp;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        RequestContext rc = RequestContext.get();
        String tabKey = tabSelectEvent.getTabKey();
        this.resetQueryCondition();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)KEY_TABPAGE_PREDICT)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_CUR_PREDICT_OBJ});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_CONFIG_PREDICT_OBJ});
            this.loadCurrentPredictObjList();
        } else if (StringUtils.equals((CharSequence)tabKey, (CharSequence)KEY_TABPAGE_CONFIG)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_CUR_PREDICT_OBJ});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_CONFIG_PREDICT_OBJ});
            this.loadPredictConfigFromRemote(this.ctx.getCurFilterItemQuery());
        }
    }
}

