/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.ids.core.enumtype.TimeTypeEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class SaleContributeAnaFormPlugin
extends BaseFormPlugin {
    private static final String KEY_CUSTOM_CONTROL_AP_CIRCLE = "ids_sale_circle_pack";
    private static final String CHART_TYPE_KEY = "saleContribute_circlePack";
    private static final String KEY_COMBO_SCHEME = "comboscheme";
    private static final String KEY_COMBO_F_TIME_TYPE = "comboftimetype";
    private static final String EVENT_NAME_HIDE_LOADING = "hideLoading";
    private static final String KEY_NUMBER_SCHEME_JO_MAP = "number_schemejo_map";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_DEFAULT_SCHEME_NUMBER = "defaultSchemeNumber";

    @Override
    public void setLabelText(String key, String text) {
        Label label = (Label)this.getView().getControl(key);
        if (label != null) {
            label.setText(text);
        }
    }

    private String getDefaultSchemeNumber() {
        return this.getCache().get(KEY_DEFAULT_SCHEME_NUMBER);
    }

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_RESET});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        super.click(evt);
        switch (evtKey) {
            case "btnok": {
                this.loadChartData();
                break;
            }
            case "btnreset": {
                this.resetQueryCondition();
                this.loadChartData();
                break;
            }
        }
    }

    private void resetQueryCondition() {
        String fschemeNumber = this.getDefaultSchemeNumber();
        this.getModel().setValue(KEY_COMBO_SCHEME, (Object)fschemeNumber);
        this.getModel().setValue(KEY_COMBO_F_TIME_TYPE, (Object)TimeTypeEnum.M1.getId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadTimeTypeItemList();
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.getCache().put("subServiceId", subServiceId);
        this.loadSaleContributeSchemeList(rc);
    }

    private void loadSaleContributeSchemeList(RequestContext rc) {
        JSONArray dataJa = this.materialSaleAnaService().getSaleContributeSchemeList(Long.valueOf(rc.getOrgId()), this.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        String defaultSchemeNumber = "";
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_SCHEME);
        int len = dataJa.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        HashMap<String, JSONObject> numberSchemeJoMap = new HashMap<String, JSONObject>(10);
        for (int i = 0; i < len; ++i) {
            JSONObject jo = dataJa.getJSONObject(i);
            String fnumber = jo.getString("fnumber");
            numberSchemeJoMap.put(fnumber, jo);
            JSONArray idNameList = jo.getJSONArray("idNameList");
            LocaleString comboItemText = new LocaleString(jo.getString("fname"));
            ComboItem comboItem = new ComboItem(comboItemText, fnumber);
            data.add(comboItem);
            if (!StringUtils.isEmpty((CharSequence)defaultSchemeNumber) || idNameList == null || idNameList.size() <= 0) continue;
            defaultSchemeNumber = fnumber;
            this.getCache().put(KEY_DEFAULT_SCHEME_NUMBER, defaultSchemeNumber);
        }
        comboEdit.setComboItems(data);
        this.getCache().put(KEY_NUMBER_SCHEME_JO_MAP, JSON.toJSONString(numberSchemeJoMap));
        if (StringUtils.isNotEmpty((CharSequence)defaultSchemeNumber)) {
            this.getModel().setValue(KEY_COMBO_SCHEME, (Object)defaultSchemeNumber);
            this.loadChartData();
        }
    }

    private void loadChartData() {
        this.getView().showLoading(null, 2000);
        RequestContext rc = RequestContext.get();
        String subServiceId = this.getSubServiceId();
        String schemeNumber = (String)this.getModel().getValue(KEY_COMBO_SCHEME);
        String ftimetype = (String)this.getModel().getValue(KEY_COMBO_F_TIME_TYPE);
        JSONObject dataJo = this.materialSaleAnaService().getSaleContributeAna(Long.valueOf(rc.getOrgId()), subServiceId, schemeNumber, ftimetype);
        JSONObject graphData = dataJo.getJSONObject("graphData");
        if (graphData == null) {
            return;
        }
        HashMap<String, String> custMap = new HashMap<String, String>();
        custMap.put("containerId", KEY_CUSTOM_CONTROL_AP_CIRCLE);
        custMap.put("chartType", CHART_TYPE_KEY);
        custMap.put("data", (String)graphData);
        CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL_AP_CIRCLE);
        customControl.setData(custMap);
    }

    private void loadTimeTypeItemList() {
        String start1Date = DateFormatUtils.format((Date)KDDateUtils.getTheMonthStart((int)-1), (String)"MM-dd");
        String start6Date = DateFormatUtils.format((Date)KDDateUtils.getTheMonthStart((int)-6), (String)"MM-dd");
        String endDate = DateFormatUtils.format((Date)KDDateUtils.addDays((Date)KDDateUtils.getTheMonthEnd((int)-1), (int)-1), (String)"MM-dd");
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_F_TIME_TYPE);
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(2);
        ComboItem month1Item = new ComboItem(new LocaleString(String.format("%s(%s~%s)", TimeTypeEnum.M1.getName(), start1Date, endDate)), TimeTypeEnum.M1.getId());
        itemList.add(month1Item);
        ComboItem month6Item = new ComboItem(new LocaleString(String.format("%s(%s~%s)", TimeTypeEnum.M6.getName(), start6Date, endDate)), TimeTypeEnum.M6.getId());
        itemList.add(month6Item);
        comboEdit.setComboItems(itemList);
        this.getModel().setValue(KEY_COMBO_F_TIME_TYPE, (Object)TimeTypeEnum.M1.getId());
    }

    public void customEvent(CustomEventArgs e) {
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        if (KEY_CUSTOM_CONTROL_AP_CIRCLE.equals(controlKey) && EVENT_NAME_HIDE_LOADING.equals(eventName)) {
            this.getView().hideLoading();
        }
    }
}

