/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.CustomBaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.PopAppUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;

public class SaleForecastHomeFormPlugin
extends BaseFormPlugin {
    private static final String KEY_CUSTOM_CONTROL = "saleforecasthomepage";
    private static final String KEY_EVENT_NAME_MENU_CLICK = "menuClick";
    private static final String KEY_FORM_ID = "formId";

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.getCache().put("subServiceId", subServiceId);
        this.loadConfigStatus();
    }

    private void loadConfigStatus() {
        Date now = new Date();
        RequestContext rc = RequestContext.get();
        CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL);
        BaseResult baseResult = this.dataAppService().getConfigStatus(Long.valueOf(rc.getOrgId()), this.getSubServiceId());
        CustomBaseResult customBaseResult = new CustomBaseResult(baseResult, this.getView().getPageId(), CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("data", customBaseResult.toJSONObject());
        customData.put("timestamp", now.getTime());
        customData.put("chartType", "homePage");
        customData.put("pageId", this.getView().getPageId());
        customData.put("uniqueCode", "homePage");
        customControl.setData(customData);
    }

    public void customEvent(CustomEventArgs e) {
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        if (KEY_CUSTOM_CONTROL.equals(controlKey) && KEY_EVENT_NAME_MENU_CLICK.equals(eventName)) {
            JSONObject menuObj = JSON.parseObject((String)args);
            String formId = menuObj.getString(KEY_FORM_ID);
            String appNumber = "ids";
            List appMenuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)appNumber);
            String menuId = appMenuInfos.stream().filter(appMenuInfo -> formId.equals(appMenuInfo.getFormId()) && "FormShowParameter".equals(appMenuInfo.getParamType())).findFirst().get().getId();
            IFormView mainView = this.getView().getMainView();
            String appPageId = "";
            if (mainView != null) {
                String mainViewPageId = mainView.getPageId();
                appPageId = appNumber + mainViewPageId;
                String appId = AppMetadataCache.getAppInfo((String)appNumber).getAppId();
                String billPageId = menuId + mainViewPageId;
                if (null != mainView.getViewNoPlugin(billPageId)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("view", this.getView());
                    hashMap.put("formnumber", formId);
                    hashMap.put("parametertype", "FormShowParameter");
                    PopAppUtils.activatePage(billPageId, this.getView(), hashMap);
                } else {
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.setFormId(formId);
                    formShowParameter.setAppId(appId);
                    formShowParameter.setCustomParam("appid", (Object)appId);
                    formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
                    formShowParameter.setPageId(billPageId);
                    IFormView fromView = this.getView().getView(appPageId);
                    fromView.showForm(formShowParameter);
                    this.getView().sendFormAction(fromView);
                }
            }
            IdsPageCache cache = new IdsPageCache(appPageId);
            cache.restore();
            String checkOnlineKey = "is_online_" + formId;
            String expect = "false";
            if (expect.equals(cache.get(checkOnlineKey))) {
                String msg = ResManager.loadKDString((String)"\u5e94\u7528\u672a\u4e0a\u7ebf\uff0c\u8bf7\u7b49\u5f85\u4e0a\u7ebf\u540e\u518d\u67e5\u770b\uff01", (String)"AppHomeFormPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]);
                String detail = ResManager.loadKDString((String)"\u60a8\u53ef\u4ee5\u7535\u8bdd\u8054\u7cfb\u6211\u4eec\u5feb\u901f\u4e0a\u7ebf\uff010755-84371244", (String)"AppHomeFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, detail, MessageBoxOptions.OK, ConfirmTypes.Wait, null);
                cache.remove(checkOnlineKey);
            }
        }
    }
}

