/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Objects;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.PermUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.FormTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ServiceAgreementFormPlugin
extends BaseFormPlugin {
    private static final String KEY_HTML_AGREEMENTCONTNET = "agreementcontent";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_CLOSE = "btnclose";
    private static final String KEY_BTN_CANCEL = "btncancel";
    private static final String KEY_BTN_AGREEMENT_CANCEL = "btnagreementcancel";
    private static final String KEY_AGREEMENT_CANCEL = "agreementcancel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_AGREEMENT_CANCEL, KEY_BTN_CLOSE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        RequestContext rc = RequestContext.get();
        Control ctl = (Control)evt.getSource();
        String btnKey = ctl.getKey();
        if (!this.hasPermission(btnKey)) {
            String tip = "";
            if (KEY_BTN_OK.equals(btnKey)) {
                tip = "\u540c\u610f\u534f\u8bae";
            } else if (KEY_BTN_AGREEMENT_CANCEL.equals(btnKey)) {
                tip = "\u89e3\u9664\u534f\u8bae";
            }
            String message = String.format("\u65e0\"\u667a\u80fd\u6570\u636e\u670d\u52a1\u534f\u8bae\"\u7684\"%s\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", tip);
            this.getView().showErrorNotification(message);
            return;
        }
        switch (btnKey) {
            case "btnok": {
                TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
                BaseResult baseResult = this.tenantService().agreementGrantAdd(rc, tenantDTO.getTenantId());
                if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                    FormTools.notifyMyServiceCardRefresh(this.getView());
                    this.getView().close();
                    LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u540c\u610f\u534f\u8bae", (String)"\u540c\u610f\u534f\u8bae-\u6210\u529f");
                    break;
                }
                this.getView().showErrorNotification(baseResult.getDescriptionCn());
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u540c\u610f\u534f\u8bae", (String)"\u540c\u610f\u534f\u8bae-\u5931\u8d25");
                break;
            }
            case "btnclose": {
                this.getView().close();
                break;
            }
            case "btnagreementcancel": {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_AGREEMENT_CANCEL, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u60a8\u662f\u5426\u786e\u5b9a\u8981\u89e3\u9664\u667a\u80fd\u6570\u636e\u670d\u52a1\u534f\u8bae\uff0c\u89e3\u9664\u534f\u8bae\u5c06\u4e0b\u7ebf\u6240\u6709\u667a\u80fd\u6570\u636e\u5e94\u7528\uff01", (String)"ServiceAgreementFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u89e3\u9664\u534f\u8bae", (String)"\u89e3\u9664\u534f\u8bae");
                break;
            }
        }
    }

    private boolean hasPermission(String btnKey) {
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        String appId = AppMetadataCache.getAppInfo((String)"ids").getAppId();
        if (KEY_BTN_OK.equals(btnKey)) {
            return PermUtils.hasPermission((Object)currentUserId, (Object)appId, (Object)"ids_service_agreement", (Object)"SERVICE-AGREEMENT-OK");
        }
        if (KEY_BTN_AGREEMENT_CANCEL.equals(btnKey)) {
            return PermUtils.hasPermission((Object)currentUserId, (Object)appId, (Object)"ids_service_agreement", (Object)"SERVICE-AGREEMENT-RELIEVE");
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)KEY_AGREEMENT_CANCEL, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            JSONObject paramsJo = new JSONObject();
            paramsJo.put("tenantId", (Object)tenantDTO.getTenantId());
            paramsJo.put("lastUserId", (Object)rc.getCurrUserId());
            paramsJo.put("lastUserName", (Object)rc.getUserName());
            BaseResult baseResult = this.idsServer().getBaseResultByPost(Long.valueOf(rc.getOrgId()), "/ids/clientproxy/agreement/grant/cancel", paramsJo);
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                this.dataAppService().removeSubserviceCache(Long.valueOf(rc.getOrgId()), rc.getTenantId(), null);
                this.getView().showSuccessNotification(baseResult.getDescriptionCn());
                this.getView().close();
                this.setControlVisible(rc, tenantDTO);
                FormTools.notifyMyServiceCardRefresh(this.getView());
            } else {
                this.getView().showErrorNotification(baseResult.getDescriptionCn());
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        IFormView view = this.getView();
        this.setControlVisible(rc, tenantDTO);
        String agreementContent = ResManager.loadKDString((String)"\u65e0\u5339\u914d\u534f\u8bae\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"ServiceAgreementFormPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]);
        if (tenantDTO != null) {
            JSONObject paramsJo = new JSONObject();
            paramsJo.put("tenantId", (Object)tenantDTO.getTenantId());
            paramsJo.put("platformCode", (Object)this.labelService().getPlatformCode());
            BaseResult baseResult = this.idsServer().getBaseResultByPost(Long.valueOf(rc.getOrgId()), "/ids/clientproxy/agreement/info/get", paramsJo);
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
                JSONObject dataJo = baseResult.getDataAsJSONObject();
                agreementContent = dataJo.getString("content");
            }
        }
        Html html = (Html)view.getControl(KEY_HTML_AGREEMENTCONTNET);
        html.setConent(agreementContent);
    }

    private void setControlVisible(RequestContext rc, TenantDTO tenantDTO) {
        IFormView view = this.getView();
        if (tenantDTO != null && this.agreementService().hasGrantAgreement(rc, tenantDTO.getTenantId())) {
            view.setVisible(Boolean.FALSE, new String[]{KEY_BTN_OK, KEY_BTN_CANCEL});
            view.setVisible(Boolean.TRUE, new String[]{KEY_BTN_CLOSE, KEY_BTN_AGREEMENT_CANCEL});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{KEY_BTN_OK, KEY_BTN_CANCEL});
            view.setVisible(Boolean.FALSE, new String[]{KEY_BTN_CLOSE, KEY_BTN_AGREEMENT_CANCEL});
        }
    }
}

