/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.dashboard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.ai.ids.core.cache.SessionCache;
import kd.ai.ids.core.entity.model.AuthorityClient;
import kd.ai.ids.core.entity.model.Dashboard;
import kd.ai.ids.core.entity.model.DashboardGroup;
import kd.ai.ids.core.enumtype.DashboardTypeEnum;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.query.clientproxy.GetDashboardGroupListQuery;
import kd.ai.ids.core.query.clientproxy.GetDashboardQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.FormTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;

public class DashboardAnaFormPlugin
extends BaseFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_ROOT_NODE_ID = "0";
    private static final String KEY_SEARCHAP = "searchap";
    private static final String KEY_CURRENT_DASHBOARD = "current_dashboard";
    private static final String KEY_FLEX_CONTAINER = "flexcontainer";
    private static final String KEY_VECTOR_RENAME = "vectoraprename";
    private static final String KEY_VECTOR_DELETE = "vectorapdelete";
    private static final String KEY_VECTOR_AP_EDIT = "vectorapedit";
    private static final String KEY_EDIT_DASHBOARD = "editdashboard";
    private static final String KEY_REFRESH_DASHBOARD = "refreshdashboard";
    private static final String KEY_BTN_DATA_ANALYSIS = "btndataanalysis";
    private static final String KEY_FLEX_GPT_MODAL = "flexgptmodal";
    private static final String KEY_FLEX_SHADOW = "flexshadow";
    private static final String KEY_FLEX_GPT = "flexgpt";
    private static final String KEY_SHOW_GPT = "showgpt";
    private static final String KEY_HIDE_GPT = "hidegpt";
    private static final String KEY_OPENED_GPT = "openedGPT";
    private static final String KEY_GROUP_ID_PREFIX = "groupid_";
    private static final String KEY_DASHBOARD_ID_PREFIX = "dashboardid_";
    private static final String KEY_LABELAP_DASHBOARD_NAME = "labelapname";

    private boolean openedGpt() {
        String s = this.getCache().get(KEY_OPENED_GPT);
        return StringUtils.isEmpty((CharSequence)s) ? false : Boolean.parseBoolean(s);
    }

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_VECTOR_RENAME, KEY_VECTOR_DELETE, KEY_FLEX_SHADOW});
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCHAP);
        search.addEnterListener(searchEnterEvent -> {
            String searchKey = searchEnterEvent.getText();
            this.loadGroupList(searchKey, null, false);
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_SHOW_GPT)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_GPT_MODAL});
                Dashboard dashboard = this.getDashboardDetail();
                String fdashboardInfo = dashboard.getFdashboardInfo();
                Integer dashboard_id = 0;
                if (StringUtils.isNotEmpty((CharSequence)fdashboardInfo)) {
                    JSONObject dashboardInfoJo = JSONObject.parseObject((String)fdashboardInfo);
                    dashboard_id = dashboardInfoJo.getIntValue("supersetDashboardId");
                }
                if (this.openedGpt()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_GPT_MODAL});
                } else {
                    FormShowParameter fsp = this.getView().getFormShowParameter();
                    String appIdentifier = (String)fsp.getCustomParam("appIdentifier");
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId(IdsFormIdEnum.IDS_GPT.getId());
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    customParams.put("dashboardId", dashboard.getId());
                    customParams.put("subServiceId", dashboard.getSubServiceId());
                    customParams.put("supersetDashboardId", dashboard_id);
                    customParams.put("appIdentifier", appIdentifier);
                    showParameter.setCustomParams(customParams);
                    showParameter.getOpenStyle().setTargetKey(KEY_FLEX_GPT);
                    showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IdsFormIdEnum.IDS_GPT.getId()));
                    this.getView().showForm(showParameter);
                    this.getCache().put(KEY_OPENED_GPT, String.valueOf(true));
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_EDIT_DASHBOARD)) {
                Dashboard dashboard = this.getDashboardDetail();
                String fdashboardInfo = dashboard.getFdashboardInfo();
                Integer dashboard_id = 0;
                if (StringUtils.isNotEmpty((CharSequence)fdashboardInfo)) {
                    JSONObject dashboardInfoJo = JSONObject.parseObject((String)fdashboardInfo);
                    dashboard_id = dashboardInfoJo.getIntValue("supersetDashboardId");
                }
                String path = "/superset/dashboard/%s/?show_filters=0&show_nav=false";
                path = String.format(path, dashboard_id);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setCaption("\u4eea\u8868\u76d8\u7f16\u8f91");
                formShowParameter.setFormId(IdsFormIdEnum.IDS_EMBED_SUPERSET.getId());
                formShowParameter.setCustomParam("path", (Object)path);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(formShowParameter);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_REFRESH_DASHBOARD)) {
                this.showDashboard(this.getCurrentDashboard().getId(), true);
            }
        }
    }

    private Dashboard getDashboardDetail() {
        RequestContext rc = RequestContext.get();
        Dashboard dashboard = this.getCurrentDashboard();
        GetDashboardQuery dashboardQuery = new GetDashboardQuery();
        dashboardQuery.setId(dashboard.getId());
        dashboardQuery.setTenantId(this.getTenantDTO().getTenantId());
        dashboardQuery.setNeedGuestToken(false);
        dashboardQuery.setSubServiceId(this.getSubServiceId());
        dashboardQuery.setFilters(null);
        BaseResult baseResult = this.dashboardService().getDashboard(Long.valueOf(rc.getOrgId()), dashboardQuery);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            dashboard = (Dashboard)JSONObject.parseObject((String)baseResult.getDataAsJSONObject().toJSONString(), Dashboard.class);
        }
        return dashboard;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        RequestContext rc = RequestContext.get();
        switch (evtKey) {
            case "vectoraprename": {
                if (!PermissionServiceHelper.checkPermission((Long)rc.getCurrUserId(), (String)"1ZY6U=RCHA6Y", (String)IdsFormIdEnum.IDS_DASHBOARD_ANA.getId(), (String)"4715a0df000000ac")) {
                    return;
                }
                TreeView tv = (TreeView)this.getControl(KEY_TREEVIEW);
                TreeView.TreeState treeState = tv.getTreeState();
                String focusNodeId = treeState.getFocusNodeId();
                boolean isDashboard = StringUtils.startsWith((CharSequence)focusNodeId, (CharSequence)KEY_DASHBOARD_ID_PREFIX);
                if (!isDashboard) break;
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(IdsFormIdEnum.IDS_DASHBOARD_EDIT_DLG.getId());
                Dashboard dashboard = this.getCurrentDashboard();
                if (dashboard.getFtype().intValue() == DashboardTypeEnum.PRESET.getKey()) {
                    this.getView().showTipNotification("\u9884\u7f6e\u6570\u636e\u4e0d\u652f\u6301\u7f16\u8f91");
                    return;
                }
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put("dashboard", JSONObject.toJSONString((Object)dashboard));
                customParams.put("tenantId", this.getTenantDTO().getTenantId());
                showParameter.setCustomParams(customParams);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_VECTOR_RENAME));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
            case "vectorapdelete": {
                if (!PermissionServiceHelper.checkPermission((Long)rc.getCurrUserId(), (String)"1ZY6U=RCHA6Y", (String)IdsFormIdEnum.IDS_DASHBOARD_ANA.getId(), (String)"4715e1f1000000ac")) {
                    return;
                }
                Dashboard dashboard = this.getCurrentDashboard();
                if (dashboard.getFtype().intValue() == DashboardTypeEnum.PRESET.getKey()) {
                    this.getView().showTipNotification("\u9884\u7f6e\u6570\u636e\u4e0d\u652f\u6301\u5220\u9664");
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u3010%s\u3011\u5417\uff1f", (String)"Common_Delete", (String)"ai-ids-plugin", (Object[])new Object[0]);
                msg = String.format(msg, this.getCurrentDashboard().getFname());
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_VECTOR_DELETE, (IFormPlugin)this);
                this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener, null, "");
                break;
            }
            case "flexshadow": {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_GPT_MODAL});
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_GPT_MODAL});
        AuthorityClient authorityClient = this.getAuthorityClient();
        if (authorityClient.getEnableGpt().intValue() != EnableEnum.AVAIL.getKey()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_DATA_ANALYSIS, KEY_FLEX_GPT_MODAL, KEY_VECTOR_AP_EDIT});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        RequestContext rc = RequestContext.get();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String appIdentifier = (String)fsp.getCustomParam("appIdentifier");
        this.getCache().put("appIdentifier", appIdentifier);
        String dataappId = this.dataAppService().getAppIdByPlatformCode(appIdentifier);
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), this.getTenantDTO().getTenantId(), dataappId);
        this.getCache().put("subServiceId", subServiceId);
        this.setOperateBtnStatus(Boolean.FALSE);
        this.loadGroupList(null, null, true);
    }

    private void loadGroupList(String searchKey, Long focusDashboardId, boolean forceRefresh) {
        RequestContext rc = RequestContext.get();
        GetDashboardGroupListQuery groupQuery = new GetDashboardGroupListQuery();
        groupQuery.setSubServiceId(this.getSubServiceId());
        groupQuery.setSearchKey(searchKey);
        JSONArray dashboardGroupJa = this.dashboardService().getDashboardGroupList(Long.valueOf(rc.getOrgId()), groupQuery);
        List groupList = JSONArray.parseArray((String)dashboardGroupJa.toJSONString(), DashboardGroup.class);
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tv.deleteAllNodes();
        if (CollectionUtils.isNotEmpty((Collection)groupList)) {
            TreeNode rootNode = new TreeNode(null, KEY_ROOT_NODE_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ApplicationConfigPlugin_11", (String)"ai-ids-plugin", (Object[])new Object[0]), (Object)Boolean.TRUE);
            rootNode.setIsOpened(true);
            TreeNode initTreeNode = null;
            for (DashboardGroup group : groupList) {
                String groupNodeId = String.format("%s%s", KEY_GROUP_ID_PREFIX, group.getId());
                TreeNode groupNode = new TreeNode(KEY_ROOT_NODE_ID, groupNodeId, group.getFname(), true);
                groupNode.setIcon("kdfont kdfont-wenjianjia2");
                groupNode.setIsOpened(true);
                List dashboardList = group.getChildren();
                if (CollectionUtils.isNotEmpty((Collection)dashboardList)) {
                    for (int i = 0; i < dashboardList.size(); ++i) {
                        Dashboard dashboard = (Dashboard)dashboardList.get(i);
                        String dashboardNodeId = String.format("%s%s", KEY_DASHBOARD_ID_PREFIX, dashboard.getId());
                        this.getCache().put(dashboardNodeId, JSONObject.toJSONString((Object)dashboard));
                        TreeNode dashboardNode = new TreeNode(groupNodeId, dashboardNodeId, dashboard.getFname(), false);
                        if (dashboard.getCreateTime().after(KDDateUtils.parseDateTime((String)(KDDateFormatUtils.getDateFormat().format(KDDateUtils.now()) + " 00:00:00")))) {
                            dashboardNode.setIcon("kdfont kdfont-NEW");
                        } else {
                            dashboardNode.setIcon("kdfont kdfont-yibiaoban");
                        }
                        dashboardNode.setIsOpened(true);
                        if (initTreeNode == null) {
                            initTreeNode = dashboardNode;
                        }
                        if (focusDashboardId != null && dashboard.getId().longValue() == focusDashboardId.longValue()) {
                            initTreeNode = dashboardNode;
                        }
                        groupNode.addChild(dashboardNode);
                    }
                }
                rootNode.addChild(groupNode);
            }
            tv.addNode(rootNode);
            tv.setRootVisible(false);
            if (initTreeNode != null) {
                tv.focusNode(initTreeNode);
                long dashboardId = this.getDashboardIdFromNodeId(initTreeNode.getId());
                this.showDashboard(dashboardId, forceRefresh);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        boolean isDashboard = StringUtils.startsWith((CharSequence)nodeId, (CharSequence)KEY_DASHBOARD_ID_PREFIX);
        if (isDashboard) {
            long dashboardId = this.getDashboardIdFromNodeId(nodeId);
            this.showDashboard(dashboardId, false);
        } else {
            this.setOperateBtnStatus(Boolean.FALSE);
        }
    }

    private long getDashboardIdFromNodeId(String nodeId) {
        long dashboardId = Long.parseLong(nodeId.split("_", 2)[1]);
        return dashboardId;
    }

    private void setOperateBtnStatus(Boolean enable) {
        this.getView().setEnable(enable, new String[]{KEY_VECTOR_RENAME, KEY_VECTOR_DELETE});
        if (!enable.booleanValue()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fc", "#999999");
            this.getView().updateControlMetadata(KEY_VECTOR_RENAME, map);
            this.getView().updateControlMetadata(KEY_VECTOR_DELETE, map);
        }
    }

    private Dashboard getCurrentDashboard() {
        String dashboardStr = SessionCache.get().get(KEY_CURRENT_DASHBOARD);
        Dashboard dashboard = (Dashboard)JSONObject.parseObject((String)dashboardStr, Dashboard.class);
        return dashboard;
    }

    private void showDashboard(long dashboardId, boolean forceRefresh) {
        this.setOperateBtnStatus(Boolean.TRUE);
        Dashboard currentShowDashboard = this.getCurrentDashboard();
        String dashboardNodeId = String.format("%s%s", KEY_DASHBOARD_ID_PREFIX, dashboardId);
        Dashboard toShowDashboard = (Dashboard)this.getCache().getAsObject(dashboardNodeId, Dashboard.class);
        this.setLabelText(KEY_LABELAP_DASHBOARD_NAME, toShowDashboard.getFname());
        if (forceRefresh || currentShowDashboard != null && dashboardId != currentShowDashboard.getId()) {
            this.getCache().put(KEY_OPENED_GPT, String.valueOf(false));
            String appIdentifier = this.getCache().get("appIdentifier");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(IdsFormIdEnum.IDS_DASHBOARD.getId());
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("dashboardId", toShowDashboard.getId());
            customParams.put("appIdentifier", appIdentifier);
            SessionCache.get().put(KEY_CURRENT_DASHBOARD, JSONObject.toJSONString((Object)toShowDashboard));
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setTargetKey(KEY_FLEX_CONTAINER);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject resultJo;
        super.closedCallBack(closedCallBackEvent);
        RequestContext rc = RequestContext.get();
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_VECTOR_RENAME) && returnData != null && (resultJo = JsonUtils.parseObj((Object)returnData)).getBooleanValue("status")) {
            Dashboard dashboard = (Dashboard)resultJo.getObject("dashboard", Dashboard.class);
            TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            String groupNodeId = String.format("%s%s", KEY_GROUP_ID_PREFIX, dashboard.getFgroupId());
            String dashboardNodeId = String.format("%s%s", KEY_DASHBOARD_ID_PREFIX, dashboard.getId());
            TreeNode dashboardNode = new TreeNode(groupNodeId, dashboardNodeId, dashboard.getFname(), (Object)Boolean.TRUE);
            dashboardNode.setIsOpened(true);
            tv.updateNode(dashboardNode);
            String dashboardStr = JSONObject.toJSONString((Object)dashboard);
            this.getCache().put(dashboardNodeId, dashboardStr);
            this.getCache().saveChanges();
            SessionCache.get().put(KEY_CURRENT_DASHBOARD, dashboardStr);
            this.showDashboard(dashboard.getId(), false);
            String msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"Common_Operation_Success", (String)"ai-ids-plugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        RequestContext rc = RequestContext.get();
        String action = e.getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)KEY_HIDE_GPT)) {
            Dashboard currentDashboard = this.getCurrentDashboard();
            this.loadGroupList(null, currentDashboard.getId(), false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        RequestContext rc = RequestContext.get();
        String callBackId = e.getCallBackId();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)KEY_VECTOR_DELETE) && e.getResult() == MessageBoxResult.Yes) {
            Dashboard dashboard = this.getCurrentDashboard();
            BaseResult baseResult = this.dashboardService().deleteDashboard(Long.valueOf(rc.getOrgId()), this.getSubServiceId(), dashboard.getId());
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                this.getView().showSuccessNotification("\u5220\u9664\u6210\u529f");
                Search search = (Search)this.getControl(KEY_SEARCHAP);
                String searchKey = search.getSearchKey();
                this.loadGroupList(searchKey, null, true);
            } else {
                this.getView().showErrorNotification(baseResult.getDescriptionCn());
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Object source = e.getSource();
        AuthorityClient authorityClient = this.getAuthorityClient();
        if (authorityClient.getEnableSuperset().intValue() != EnableEnum.AVAIL.getKey()) {
            e.setCancel(true);
            FormShowParameter fsp = (FormShowParameter)source;
            String rootPageId = fsp.getRootPageId();
            FormTools.showConfirmAsync(rootPageId, rootPageId, ResManager.loadKDString((String)"\u4eea\u8868\u76d8\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"AppHomeFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u60a8\u53ef\u4ee5\u7535\u8bdd\u8054\u7cfb\u6211\u4eec\u5feb\u901f\u6388\u6743\uff010755-84371244", (String)"AppHomeFormPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]));
            return;
        }
    }

    private AuthorityClient getAuthorityClient() {
        RequestContext rc = RequestContext.get();
        IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(rc.getOrgId()));
        JSONObject dataJo = this.commonService().getAuthorityClient(Long.valueOf(rc.getOrgId()), Long.valueOf(Long.parseLong(idsParameter.getAuthorityAppId())), idsParameter.getAuthorityAppSecret());
        AuthorityClient authorityClient = (AuthorityClient)JSONObject.parseObject((String)dataJo.toJSONString(), AuthorityClient.class);
        return authorityClient;
    }
}

