/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.dashboard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Objects;
import kd.ai.ids.core.entity.model.Dashboard;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;

public class DashboardEditDlgFormPlugin
extends BaseFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_FNAME = "fname";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        RequestContext rc = RequestContext.get();
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTNOK, (CharSequence)evtKey)) {
            String dashboardName = (String)this.getModel().getValue(KEY_FNAME);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String dashboardStr = (String)formShowParameter.getCustomParam("dashboard");
            Dashboard dashboard = (Dashboard)JSONObject.parseObject((String)dashboardStr, Dashboard.class);
            dashboard.setFname(dashboardName);
            BaseResult baseResult = this.dashboardService().saveDashboard(Long.valueOf(rc.getOrgId()), dashboard);
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
                dashboard = (Dashboard)JSONObject.parseObject((String)baseResult.getDataAsJSONString(), Dashboard.class);
                JSONObject pushResult = new JSONObject();
                pushResult.put("status", (Object)Boolean.TRUE);
                pushResult.put("dashboard", (Object)dashboard);
                String saveResult = JSON.toJSONString((Object)pushResult);
                this.getCache().put("opResult", saveResult);
                this.getView().close();
            } else {
                this.getView().showTipNotification(baseResult.getDescriptionCn());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String dashboardStr = (String)formShowParameter.getCustomParam("dashboard");
        Dashboard dashboard = (Dashboard)JSONObject.parseObject((String)dashboardStr, Dashboard.class);
        this.getModel().setValue(KEY_FNAME, (Object)dashboard.getFname());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)this.getCache().get("opResult"));
    }
}

