/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.dashboard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.SessionCache;
import kd.ai.ids.core.entity.model.Dashboard;
import kd.ai.ids.core.entity.model.DashboardFilter;
import kd.ai.ids.core.entity.model.DashboardFilterOption;
import kd.ai.ids.core.enumtype.ControlTypeEnum;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.query.clientproxy.GetDashboardFilterQuery;
import kd.ai.ids.core.query.clientproxy.GetDashboardQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.CustomBaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class DashboardFormPlugin
extends BaseFormPlugin {
    private static final String KEY_CUSTOM_CONTROL = "embeddashboard";
    private static final String KEY_AUTO_LOGIN_SUPERSET = "autologinsuperset";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_CURRENT_DASHBOARD = "current_dashboard";
    private static final String[] PRESET_BASEDATA_CONTROL_ID_ARR = new String[]{"mulbd_forgid", "mulbd_fwarehouseid", "mulbd_fcustid", "mulbd_fmaterialid", "mulbd_fsupplier", "mulbd_fbrand1level", "mulbd_fbrand2level", "mulbd_fbrand3level", "bd_forgid", "bd_fwarehouseid", "bd_fcustid", "bd_fmaterialid", "bd_fsupplier", "bd_fbrand1level", "bd_fbrand2level", "bd_fbrand3level"};
    private static final String KEY_MULBD_FORGID = "mulbd_forgid";
    private static final String KEY_BD_FORGID = "bd_forgid";
    private static final String KEY_FILTERS = "filters";
    private static final String KEY_FLEX_FILTERS = "flexfilters";
    private static final String KEY_FILTERS_CONTAINER = "filterscontainer";
    private static final String KEY_HEADAP = "headAp";
    private static final String KEY_COMBO_PREFIX = "combo_";
    private static final String KEY_HAS_AUTO_LOGIN_SUPERSET = "hasAutoLoginSuperset";

    private boolean hasAutoLoginSuperset() {
        String s = SessionCache.get().get(KEY_HAS_AUTO_LOGIN_SUPERSET);
        return StringUtils.isEmpty((CharSequence)s) ? false : Boolean.parseBoolean(s);
    }

    @Override
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FlexPanelAp headAp = this.createDynamicPanel();
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", KEY_FILTERS_CONTAINER);
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        List basedataEditFilterList = this.getDashboardFilters().stream().filter(x -> x.getControlType().equalsIgnoreCase(ControlTypeEnum.MUL_BASEDATA_EDIT.getKey()) || x.getControlType().equalsIgnoreCase(ControlTypeEnum.BASEDATA_EDIT.getKey())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(basedataEditFilterList)) {
            for (DashboardFilter dashboardFilter : basedataEditFilterList) {
                OrgEdit orgEdit;
                String controlId = dashboardFilter.getControlId();
                String controlType = dashboardFilter.getControlType();
                String orgFuncId = dashboardFilter.getOrgFuncId();
                Boolean mustInput = dashboardFilter.getMustInput();
                if (StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)ControlTypeEnum.MUL_BASEDATA_EDIT.getKey())) {
                    MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl(controlId);
                    mulBasedataEdit.setMustInput(mustInput.booleanValue());
                } else if (StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)ControlTypeEnum.BASEDATA_EDIT.getKey())) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BD_FORGID, (CharSequence)controlId)) {
                        orgEdit = (OrgEdit)this.getControl(controlId);
                        orgEdit.setMustInput(mustInput.booleanValue());
                    } else {
                        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(controlId);
                        basedataEdit.setMustInput(mustInput.booleanValue());
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)orgFuncId)) continue;
                if (StringUtils.equalsIgnoreCase((CharSequence)KEY_MULBD_FORGID, (CharSequence)controlId)) {
                    MulBasedataEdit forgidMulbdEdit = (MulBasedataEdit)this.getControl(controlId);
                    forgidMulbdEdit.setOrgFuncId(orgFuncId);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)KEY_BD_FORGID, (CharSequence)controlId)) continue;
                orgEdit = (OrgEdit)this.getControl(controlId);
                orgEdit.setOrgFunc(orgFuncId);
            }
        }
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        e.setDataEntity((Object)dataEntity);
    }

    public void onGetControl(OnGetControlArgs e) {
        List comboEditFilterList;
        String key = e.getKey();
        if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)KEY_COMBO_PREFIX) && CollectionUtils.isNotEmpty(comboEditFilterList = this.getDashboardFilters().stream().filter(x -> x.getControlId().equalsIgnoreCase(key)).collect(Collectors.toList()))) {
            DashboardFilter dashboardFilter = (DashboardFilter)comboEditFilterList.get(0);
            String controlId = dashboardFilter.getControlId();
            Boolean mustInput = dashboardFilter.getMustInput();
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(controlId);
            comboEdit.setView(this.getView());
            comboEdit.setMustInput(mustInput.booleanValue());
            e.setControl((Control)comboEdit);
        }
    }

    private FlexPanelAp createDynamicPanel() {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey(KEY_HEADAP);
        List comboEditFilterList = this.getDashboardFilters().stream().filter(x -> x.getControlType().equalsIgnoreCase(ControlTypeEnum.COMBO_EDIT.getKey())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(comboEditFilterList)) {
            for (DashboardFilter dashboardFilter : comboEditFilterList) {
                String controlId = dashboardFilter.getControlId();
                Boolean mustInput = dashboardFilter.getMustInput();
                FieldAp comboFieldAp = new FieldAp();
                comboFieldAp.setId(controlId);
                comboFieldAp.setKey(controlId);
                comboFieldAp.setName(new LocaleString(dashboardFilter.getName()));
                comboFieldAp.setBackColor("#ffffff");
                comboFieldAp.setFireUpdEvt(true);
                ComboField comboField = new ComboField();
                comboField.setId(controlId);
                comboField.setKey(controlId);
                comboField.setMustInput(mustInput.booleanValue());
                comboFieldAp.setField((Field)comboField);
                headPanelAp.getItems().add(comboFieldAp);
            }
        }
        return headPanelAp;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List comboEditFilterList = this.getDashboardFilters().stream().filter(x -> x.getControlType().equalsIgnoreCase(ControlTypeEnum.COMBO_EDIT.getKey())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(comboEditFilterList)) {
            for (DashboardFilter dashboardFilter : comboEditFilterList) {
                Boolean mustInput = dashboardFilter.getMustInput();
                ComboProp comboProp = new ComboProp();
                comboProp.setName(dashboardFilter.getControlId());
                comboProp.setDisplayName(new LocaleString(dashboardFilter.getName()));
                comboProp.setDbIgnore(true);
                comboProp.setAlias("");
                comboProp.setMustInput(mustInput.booleanValue());
                newMainType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
            }
        }
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    private List<DashboardFilter> getDashboardFilters() {
        List filterList = null;
        String filters = this.getCache().get(KEY_FILTERS);
        if (StringUtils.isEmpty((CharSequence)filters)) {
            String currentDashboardStr = SessionCache.get().get(KEY_CURRENT_DASHBOARD);
            Dashboard dashboard = (Dashboard)JSONObject.parseObject((String)currentDashboardStr, Dashboard.class);
            this.getCache().put(KEY_FILTERS, dashboard.getFfilters());
        }
        filterList = this.getCache().getAsList(KEY_FILTERS, DashboardFilter.class);
        return filterList;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_RESET});
    }

    public void click(EventObject evt) {
        String evtKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (evtKey = ctl.getKey()) {
            case "btnrefresh": {
                this.loadDashboard(false);
                break;
            }
            case "btnreset": {
                this.clearFilters();
                this.loadDashboard(true);
                break;
            }
        }
    }

    private void clearFilters() {
        List<DashboardFilter> filters = this.getDashboardFilters();
        if (CollectionUtils.isNotEmpty(filters)) {
            for (DashboardFilter filter : filters) {
                String controlId = filter.getControlId();
                this.getModel().setValue(controlId, null);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FlexPanelAp dynamicPanel = this.createDynamicPanel();
        Container myFldPanel = (Container)this.getView().getControl(KEY_FILTERS_CONTAINER);
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
        this.getView().setVisible(Boolean.FALSE, PRESET_BASEDATA_CONTROL_ID_ARR);
        this.initComboEditFilterOptions();
        this.loadDashboard(true);
    }

    private void initComboEditFilterOptions() {
        List comboEditFilterList = this.getDashboardFilters().stream().filter(x -> x.getControlType().equalsIgnoreCase(ControlTypeEnum.COMBO_EDIT.getKey())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(comboEditFilterList)) {
            for (DashboardFilter dashboardFilter : comboEditFilterList) {
                List optionList;
                String controlId = dashboardFilter.getControlId();
                ComboEdit comboEdit = (ComboEdit)this.getControl(controlId);
                if (comboEdit == null || !CollectionUtils.isNotEmpty((Collection)(optionList = dashboardFilter.getOptions()))) continue;
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(optionList.size());
                for (DashboardFilterOption option : optionList) {
                    LocaleString comboItemText = new LocaleString(option.getName());
                    ComboItem comboItem = new ComboItem(comboItemText, (String)option.getValue());
                    comboItemList.add(comboItem);
                }
                comboEdit.setComboItems(comboItemList);
            }
        }
    }

    private Dashboard getCurrentDashboard() {
        String currentDashboardStr = SessionCache.get().get(KEY_CURRENT_DASHBOARD);
        Dashboard dashboard = (Dashboard)JSONObject.parseObject((String)currentDashboardStr, Dashboard.class);
        return dashboard;
    }

    private void autoLoginSuperset() {
        CustomControl customControl = (CustomControl)this.getControl(KEY_AUTO_LOGIN_SUPERSET);
        RequestContext rc = RequestContext.get();
        String clientUrl = rc.getClientUrl();
        JSONObject sessionJo = this.supersetService().getSession(Long.valueOf(rc.getOrgId()), this.getTenantDTO().getTenantId());
        String supersetDomain = sessionJo.getString("supersetDomain");
        String topDomain = sessionJo.getString("topDomain");
        if (StringUtils.isEmpty((CharSequence)topDomain)) {
            topDomain = StrUtils.parseTopDomain((String)clientUrl);
            this.log.info("clientUrl: {}, topDomain: {}", (Object)clientUrl, (Object)topDomain);
        }
        Date now = new Date();
        String session = sessionJo.getString("session");
        String path = "/superset/welcome/";
        String next = String.format("%s%s", supersetDomain, path);
        next = String.format("%s%srandom=%s", next, next.contains("?") ? "&" : "?", now.getTime());
        String url = StrUtils.getSupersetRedirectUrl((String)next);
        JSONObject sessionInfoJo = new JSONObject();
        sessionInfoJo.put("supersetDomain", (Object)supersetDomain);
        sessionInfoJo.put("url", (Object)url);
        sessionInfoJo.put("path", (Object)path);
        sessionInfoJo.put("session", (Object)session);
        sessionInfoJo.put("topDomain", (Object)topDomain);
        String uniqueCode = String.format("%s_%s_%s", this.getView().getPageId(), UUID.randomUUID().toString(), path);
        HashMap<String, Object> customData = new HashMap<String, Object>();
        BaseResult tmpBaseResult = new BaseResult(BaseResult.SUCCESS, "success", "\u6210\u529f", (Object)sessionInfoJo);
        CustomBaseResult customBaseResult = new CustomBaseResult(tmpBaseResult, this.getView().getPageId(), CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        customData.put("data", customBaseResult.toJSONObject());
        customData.put("timestamp", now.getTime());
        customData.put("pageId", this.getView().getPageId());
        customData.put("uniqueCode", uniqueCode);
        customControl.setData(customData);
        SessionCache.get().put(KEY_HAS_AUTO_LOGIN_SUPERSET, String.valueOf(true));
    }

    private void loadDashboard(boolean isInit) {
        Dashboard dashboard = this.getCurrentDashboard();
        long dashboardId = dashboard.getId();
        Date now = new Date();
        RequestContext rc = RequestContext.get();
        CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL);
        if (!this.hasAutoLoginSuperset()) {
            this.autoLoginSuperset();
        }
        ArrayList<GetDashboardFilterQuery> filterList = new ArrayList<GetDashboardFilterQuery>();
        List<DashboardFilter> dashboardFilterList = this.getDashboardFilters();
        if (CollectionUtils.isNotEmpty(dashboardFilterList)) {
            for (DashboardFilter dashboardFilter : dashboardFilterList) {
                String value;
                List pkList;
                String controlId = dashboardFilter.getControlId();
                String controlType = dashboardFilter.getControlType();
                List defaultValues = dashboardFilter.getDefaultValues();
                GetDashboardFilterQuery filterQuery = new GetDashboardFilterQuery();
                filterQuery.setFieldId(dashboardFilter.getFieldId());
                filterQuery.setControlType(dashboardFilter.getControlType());
                if (StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)ControlTypeEnum.MUL_BASEDATA_EDIT.getKey())) {
                    MulBasedataDynamicObjectCollection doc;
                    List<String> valueList;
                    if (isInit && CollectionUtils.isNotEmpty((Collection)defaultValues)) {
                        pkList = QueryServiceHelper.queryPrimaryKeys((String)dashboardFilter.getEntityId(), (QFilter[])new QFilter(dashboardFilter.getProperty(), "in", (Object)defaultValues).toArray(), (String)"id asc", (int)100000);
                        this.getModel().setValue(controlId, (Object)(CollectionUtils.isNotEmpty((Collection)pkList) ? pkList.toArray() : null));
                    }
                    if (!CollectionUtils.isNotEmpty(valueList = this.getValueListFromDoc((DynamicObjectCollection)(doc = (MulBasedataDynamicObjectCollection)this.getModel().getValue(controlId)), dashboardFilter))) continue;
                    filterQuery.setValue(valueList);
                    filterList.add(filterQuery);
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)ControlTypeEnum.BASEDATA_EDIT.getKey())) {
                    Object value2;
                    DynamicObject dynamicObject;
                    if (isInit && CollectionUtils.isNotEmpty((Collection)defaultValues)) {
                        pkList = QueryServiceHelper.queryPrimaryKeys((String)dashboardFilter.getEntityId(), (QFilter[])new QFilter(dashboardFilter.getProperty(), "in", (Object)defaultValues).toArray(), (String)"id asc", (int)100000);
                        this.getModel().setValue(controlId, CollectionUtils.isNotEmpty((Collection)pkList) ? pkList.get(0) : null);
                    }
                    if ((dynamicObject = (DynamicObject)this.getModel().getValue(controlId)) == null || (value2 = dynamicObject.get(dashboardFilter.getProperty())) == null) continue;
                    filterQuery.setValue(value2);
                    filterList.add(filterQuery);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)ControlTypeEnum.COMBO_EDIT.getKey())) continue;
                if (isInit && CollectionUtils.isNotEmpty((Collection)defaultValues)) {
                    this.getModel().setValue(controlId, defaultValues.get(0));
                }
                if (!StringUtils.isNotEmpty((CharSequence)(value = (String)this.getModel().getValue(dashboardFilter.getControlId())))) continue;
                filterQuery.setValue((Object)value);
                filterList.add(filterQuery);
            }
        }
        GetDashboardQuery dashboardQuery = new GetDashboardQuery();
        dashboardQuery.setId(Long.valueOf(dashboardId));
        dashboardQuery.setTenantId(this.getTenantDTO().getTenantId());
        dashboardQuery.setNeedGuestToken(true);
        dashboardQuery.setSubServiceId(dashboard.getSubServiceId());
        dashboardQuery.setFilters(filterList);
        BaseResult baseResult = this.dashboardService().getDashboard(Long.valueOf(rc.getOrgId()), dashboardQuery);
        if (!Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) || baseResult.getData() == null) {
            this.getView().showMessage("\u4eea\u8868\u76d8\u5236\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u6765");
            return;
        }
        dashboard = (Dashboard)JSONObject.parseObject((String)baseResult.getDataAsJSONObject().toJSONString(), Dashboard.class);
        this.getCache().put(KEY_FILTERS, dashboard.getFfilters());
        if (dashboardFilterList != null && dashboardFilterList.size() > 0) {
            for (DashboardFilter dashboardFilter : dashboardFilterList) {
                String name = dashboardFilter.getName();
                String controlId = dashboardFilter.getControlId();
                String controlType = dashboardFilter.getControlType();
                if (!StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)ControlTypeEnum.MUL_BASEDATA_EDIT.getKey()) && !StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)ControlTypeEnum.BASEDATA_EDIT.getKey())) continue;
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("zh_CN", name);
                HashMap<String, HashMap<String, String>> map2 = new HashMap<String, HashMap<String, String>>();
                map2.put("caption", map1);
                this.getView().updateControlMetadata(controlId, map2);
                this.getView().setVisible(Boolean.TRUE, new String[]{controlId});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_FILTERS});
        }
        String fdashboardInfo = dashboard.getFdashboardInfo();
        if (StringUtils.isNotEmpty((CharSequence)fdashboardInfo)) {
            JSONObject dashboardInfoJo = JSONObject.parseObject((String)fdashboardInfo);
            String dashboardUuid = dashboardInfoJo.getString("supersetDashboardUuid");
            String supersetDomain = dashboard.getSupersetDomain();
            String guestToken = dashboard.getGuestToken();
            boolean hideTitle = dashboardInfoJo.getBooleanValue("hideTitle");
            boolean hideChartControls = dashboardInfoJo.getBooleanValue("hideChartControls");
            boolean filtersVisible = dashboardInfoJo.getBooleanValue("filtersVisible");
            boolean filtersExpanded = dashboardInfoJo.getBooleanValue("filtersExpanded");
            boolean hideTab = dashboardInfoJo.getBooleanValue("hideTab");
            HashMap<String, Object> customData = new HashMap<String, Object>();
            JSONObject dataJo = new JSONObject();
            dataJo.put("dashboardUuid", (Object)dashboardUuid);
            dataJo.put("token", (Object)guestToken);
            dataJo.put("domain", (Object)supersetDomain);
            dataJo.put("hideTitle", (Object)hideTitle);
            dataJo.put("hideTab", (Object)hideTab);
            dataJo.put("hideChartControls", (Object)hideChartControls);
            dataJo.put("filtersVisible", (Object)filtersVisible);
            dataJo.put("filtersExpanded", (Object)filtersExpanded);
            BaseResult tmpBaseResult = new BaseResult(BaseResult.SUCCESS, "success", "\u6210\u529f", (Object)dataJo);
            CustomBaseResult customBaseResult = new CustomBaseResult(tmpBaseResult, this.getView().getPageId(), CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("data", customBaseResult.toJSONObject());
            customData.put("timestamp", now.getTime());
            customData.put("pageId", this.getView().getPageId());
            customControl.setData(customData);
        }
    }

    private List<String> getValueListFromDoc(DynamicObjectCollection doc, DashboardFilter filter) {
        ArrayList<String> valueList = new ArrayList<String>(10);
        if (doc != null) {
            for (DynamicObject dynamicObject : doc) {
                String property = filter.getProperty();
                String propertyValue = dynamicObject.getDynamicObject(1).getString(property);
                valueList.add(propertyValue);
            }
        }
        return valueList;
    }
}

