/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.dashboard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.CustomBaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;

public class EmbedSupersetFormPlugin
extends BaseFormPlugin {
    private static final String KEY_EMBED_SUPERSET = "embedsuperset";
    private static final String KEY_SUPERSET_SESSION_INFO = "supersetSessionInfo";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    private String getSupersetSessionInfo() {
        return this.getCache().get(KEY_SUPERSET_SESSION_INFO);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String path = (String)formShowParameter.getCustomParam("path");
        RequestContext rc = RequestContext.get();
        String clientUrl = rc.getClientUrl();
        JSONObject sessionJo = this.supersetService().getSession(Long.valueOf(rc.getOrgId()), this.getTenantDTO().getTenantId());
        String supersetDomain = sessionJo.getString("supersetDomain");
        String topDomain = sessionJo.getString("topDomain");
        if (StringUtils.isEmpty((CharSequence)topDomain)) {
            topDomain = StrUtils.parseTopDomain((String)clientUrl);
            this.log.info("clientUrl: {}, topDomain: {}", (Object)clientUrl, (Object)topDomain);
        }
        String session = sessionJo.getString("session");
        String url = String.format("%s%s", supersetDomain, "/login/");
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            String next = String.format("%s%s", supersetDomain, path);
            url = StrUtils.getSupersetRedirectUrl((String)next);
        }
        JSONObject sessionInfoJo = new JSONObject();
        sessionInfoJo.put("supersetDomain", (Object)supersetDomain);
        sessionInfoJo.put("url", (Object)url);
        sessionInfoJo.put("path", (Object)path);
        sessionInfoJo.put("session", (Object)session);
        sessionInfoJo.put("topDomain", (Object)topDomain);
        String uniqueCode = String.format("%s_%s_%s", "", this.getView().getPageId(), path);
        CustomControl customControl = (CustomControl)this.getControl(KEY_EMBED_SUPERSET);
        Date now = new Date();
        HashMap<String, Object> customData = new HashMap<String, Object>();
        BaseResult tmpBaseResult = new BaseResult(BaseResult.SUCCESS, "success", "\u6210\u529f", (Object)sessionInfoJo);
        CustomBaseResult customBaseResult = new CustomBaseResult(tmpBaseResult, this.getView().getPageId(), CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        customData.put("data", customBaseResult.toJSONObject());
        customData.put("timestamp", now.getTime());
        customData.put("pageId", this.getView().getPageId());
        customData.put("uniqueCode", uniqueCode);
        customControl.setData(customData);
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }
}

