/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.dashboard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.Dashboard;
import kd.ai.ids.core.entity.model.DashboardInfo;
import kd.ai.ids.core.entity.model.gpt.ChatContent;
import kd.ai.ids.core.entity.model.gpt.ChatContentListResponseData;
import kd.ai.ids.core.entity.model.gpt.InsightResponseData;
import kd.ai.ids.core.entity.model.gpt.SqlChart;
import kd.ai.ids.core.entity.model.gpt.SqlTable;
import kd.ai.ids.core.entity.model.gpt.TaskResponseData;
import kd.ai.ids.core.entity.model.gpt.TaskResponseSql;
import kd.ai.ids.core.entity.model.gpt.TaskResponseText;
import kd.ai.ids.core.enumtype.ChatTypeEnum;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.enumtype.DashboardTypeEnum;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.MsgErrorcodeEnum;
import kd.ai.ids.core.enumtype.gpt.DataChartTypeEnum;
import kd.ai.ids.core.enumtype.gpt.GPTGenerateTypeEnum;
import kd.ai.ids.core.enumtype.gpt.MsgDataTypeEnum;
import kd.ai.ids.core.enumtype.gpt.SqlExecuteStatusEnum;
import kd.ai.ids.core.query.clientproxy.gpt.ChatContentListQuery;
import kd.ai.ids.core.query.clientproxy.gpt.Content;
import kd.ai.ids.core.query.clientproxy.gpt.CreateDashboardQuery;
import kd.ai.ids.core.query.clientproxy.gpt.CreatePPTQuery;
import kd.ai.ids.core.query.clientproxy.gpt.GetPPTStatusQuery;
import kd.ai.ids.core.query.clientproxy.gpt.GptInsightDataQuery;
import kd.ai.ids.core.query.clientproxy.gpt.ServiceParam;
import kd.ai.ids.core.query.clientproxy.gpt.TaskResponseQuery;
import kd.ai.ids.core.query.clientproxy.gpt.UserMessageQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.CustomBaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.service.KDDateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class GPTFormPlugin
extends BaseFormPlugin
implements SelectRowsEventListener {
    private static final String KEY_HIDE_GPT = "hidegpt";
    private static final String KEY_TABLEVIEW = "tableview";
    private static final String KEY_CHARTVIEW = "chartview";
    private static final String KEY_INLINEVIEW = "inlineview";
    private static final String KEY_INSIGHT = "insight";
    private static final String KEY_CREATE_DASHBOARD = "createdashboard";
    private static final String KEY_CREATE_PPT = "createppt";
    private static final String KEY_SEND_MSG = "sendmsg";
    private static final String KEY_STOP_GENERATE = "stopgenerate";
    private static final String KEY_FEEDBACK = "feedback";
    private static final String KEY_SELECT_ALL = "selectall";
    private static final String KEY_RESET = "reset";
    private static final String KEY_RETRY_SEND_MSG = "retrysendmsg";
    private static final String KEY_EDIT_MSG = "editmsg";
    private static final String KEY_BARITEM_DASHBOARD = "baritemdashboard";
    private static final String KEY_BARITEM_PPT = "baritemppt";
    private static final String KEY_BTN_GENERATE = "btngenerate";
    private static final String KEY_BTN_CANCEL = "btncancel";
    private static final String KEY_LABELAP_SELECT_COUNT = "labelapselectcount";
    private static final String KEY_FLEX_CHAT = "flexchat";
    private static final String KEY_FLEX_BOTTOM = "flexbottom";
    private static final String KEY_FLEX_CHAT_CARD = "flexchatcard";
    private static final String KEY_FLEX_INSIGHT = "flexinsight";
    private static final String KEY_LABEL_FEEDBACK = "labelfeedback";
    private static final String KEY_TITLE = "title";
    private static final String KEY_ACTION_WAIT_TASK_RESPONSE = "TaskResponse";
    private static final String KEY_ACTION_WAIT_GPT_INSIGHT_DATA = "GptInsightData";
    private static final String KEY_ACTION_WAIT_CREATE_PPT = "CreatePPT";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ENTRYENTITY_SELECT = "entryentityselect";
    private static final String KEY_MSG = "msg";
    private static final String KEY_NEWCHAT = "newchat";
    private static final String KEY_IMAGEAP_GPTLOGO = "imageapgptlogo";
    private static final String KEY_IMAGEAP_NEWCHAT = "imageapnewchat";
    private static final String KEY_VECTORAP_SEND_MSG = "vectorapsendmsg";
    private static final String KEY_FLEX_STOP_GENERATE = "flexstopgenerate";
    private static final String KEY_CUSTOM_CONTROL_GPTINPUT = "gptinput";
    private static final String KEY_KEY_UP = "keyUp";
    private static final String KEY_SUBMIT_VALUE = "submitValue";
    private static final String KEY_LABEL_CURR_COUNT = "labelcurrcount";
    private static final String KEY_LABEL_GEN_TYPE = "labelgentype";
    private static final String KEY_IMAGEAP_MSG_LOADING = "imageapmsgloading";
    private static final String KEY_CUSTOM_CONTROL_EMBED_SUPERSET_TABLE = "embedsuperset_table";
    private static final String KEY_CUSTOM_CONTROL_EMBED_SUPERSET_CHART = "embedsuperset_chart";
    private static final String KEY_SESSION_ID = "sessionId";
    private static final String KEY_REQUEST_ID = "requestId";
    private static final String KEY_LAST_MSG = "lastMsg";
    private static final String KEY_CURR_ANSWER_MSG_INDEX = "currMsgIndex";
    private static final String KEY_CURR_TASK_RESPONSE_DATA = "currTaskResponseData";
    private static final String KEY_NEED_STOP_GENERATE = "isStopGenerate";
    private static final String KEY_VALID_MSG_REQUESTID_CHATCONTENT_MAP = "validMsgRequestIdChatContentMap";
    private static final String KEY_CURR_GENERATE_TYPE = "currGenerateType";
    private static final String KEY_LAST_CREATE_DASHBOARD_ID = "lastCreateDashboardId";
    private static final String KEY_DOWNLOAD_REQUEST_ID = "downloadRequestId";
    private static final String KEY_FLEX_GPT_MODAL = "flexgptmodal";
    private static final String KEY_EDIT_CHART = "editchart";
    private static final String KEY_REFRESH_CHART = "refreshchart";
    private static final String KEY_VECTORAP_INSIGHT = "vectorapinsight";
    private static final String KEY_LABELAP_INSIGHT = "labelapinsight";
    private static final String KEY_REQUESTID_STARTTIME_MAP = "requestIdStartTimeMap";
    private static final String KEY_FLEX_GENERATE_SELECT = "flexgenerateselect";
    private static final long TIMEOUT_MS = 30000L;
    private static final String EMPTY_INLINE_DATA = "\u6682\u65e0\u6570\u636e";

    private String getSessionId() {
        return this.getCache().get(KEY_SESSION_ID);
    }

    private String getRequestId() {
        return this.getCache().get(KEY_REQUEST_ID);
    }

    private String getLastMsg() {
        return this.getCache().get(KEY_LAST_MSG);
    }

    private int getCurrAnswerMsgIndex() {
        String s = this.getCache().get(KEY_CURR_ANSWER_MSG_INDEX);
        return StringUtils.isEmpty((CharSequence)s) ? 0 : Integer.parseInt(s);
    }

    private void resetCurrAnswerMsgIndex(int msgIndex) {
        this.getCache().put(KEY_CURR_ANSWER_MSG_INDEX, String.valueOf(msgIndex));
    }

    private boolean needStopGenerate() {
        String s = this.getCache().get(KEY_NEED_STOP_GENERATE);
        return StringUtils.isEmpty((CharSequence)s) ? false : Boolean.parseBoolean(s);
    }

    private String getCurrGenerateType() {
        return this.getCache().get(KEY_CURR_GENERATE_TYPE);
    }

    private String getLastCreateDashboradId() {
        return this.getCache().get(KEY_LAST_CREATE_DASHBOARD_ID);
    }

    private String getDownloadRequestId() {
        return this.getCache().get(KEY_DOWNLOAD_REQUEST_ID);
    }

    private Map<String, ChatContent> getValidMsgRequestIdChatContentMap() {
        HashMap<String, ChatContent> map = new HashMap<String, ChatContent>();
        Map objectMap = (Map)this.getCache().getAsObject(KEY_VALID_MSG_REQUESTID_CHATCONTENT_MAP, Map.class);
        if (MapUtils.isNotEmpty((Map)objectMap)) {
            Set entries = objectMap.entrySet();
            for (Map.Entry entry : entries) {
                String requestId = (String)entry.getKey();
                Object o = objectMap.get(requestId);
                if (o == null) continue;
                ChatContent chatContent = (ChatContent)JSONObject.parseObject((String)JSONObject.toJSONString(o), ChatContent.class);
                map.put(requestId, chatContent);
            }
        }
        return map;
    }

    private int[] getValidAnswerIndexArr() {
        Map<String, ChatContent> requestIdRowIndexMap = this.getValidMsgRequestIdChatContentMap();
        if (MapUtils.isNotEmpty(requestIdRowIndexMap)) {
            Collection<ChatContent> chatContentList = requestIdRowIndexMap.values();
            List sortedChatContentList = chatContentList.stream().sorted(Comparator.comparing(ChatContent::getMsgIndex)).collect(Collectors.toList());
            int[] indexArr = new int[sortedChatContentList.size()];
            int i = 0;
            for (Object o : sortedChatContentList) {
                ChatContent chatContent = (ChatContent)JSONObject.parseObject((String)JSONObject.toJSONString(o), ChatContent.class);
                indexArr[i++] = chatContent.getMsgIndex();
            }
            return indexArr;
        }
        return new int[0];
    }

    private Map<String, Long> getRequestIdStartTimeMap() {
        HashMap map = (HashMap)this.getCache().getAsObject(KEY_REQUESTID_STARTTIME_MAP, Map.class);
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{KEY_BTN_GENERATE, KEY_BTN_CANCEL});
        final CardEntry selectCardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY_SELECT);
        selectCardEntry.addSelectRowsListener((SelectRowsEventListener)this);
        selectCardEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                int rowIndex = evt.getRow();
                if (StringUtils.isEmpty((CharSequence)GPTFormPlugin.this.getCurrGenerateType())) {
                    selectCardEntry.selectRows(new int[0], rowIndex);
                    return;
                }
                int[] selectRows = selectCardEntry.getSelectRows();
                GPTFormPlugin.this.setLabelText(GPTFormPlugin.KEY_LABELAP_SELECT_COUNT, selectRows != null ? String.valueOf(selectRows.length) : String.valueOf(0));
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        super.click(evt);
        switch (evtKey) {
            case "btngenerate": {
                this.generateDashboardOrPPT();
                break;
            }
            case "btncancel": {
                this.goChat();
                break;
            }
        }
    }

    private void goChat() {
        this.clearSelected();
        this.exitCreateEditStatus();
    }

    private void generateDashboardOrPPT() {
        RequestContext rc = RequestContext.get();
        CardEntry entry = (CardEntry)this.getControl(KEY_ENTRYENTITY_SELECT);
        int[] selectRows = entry.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u6570\u636e");
            return;
        }
        String currGenerateType = this.getCurrGenerateType();
        if (StringUtils.equalsIgnoreCase((CharSequence)currGenerateType, (CharSequence)GPTGenerateTypeEnum.PPT.getId())) {
            String sessionId = this.getSessionId();
            String title = (String)this.getModel().getValue(KEY_TITLE);
            String downloadRequestId = UUID.randomUUID().toString();
            this.getCache().put(KEY_DOWNLOAD_REQUEST_ID, downloadRequestId);
            List<Content> contentList = this.getContentList();
            CreatePPTQuery createPPTQuery = new CreatePPTQuery();
            createPPTQuery.setContentList(contentList);
            createPPTQuery.setTenantId(this.getTenantDTO().getTenantId());
            createPPTQuery.setSessionId(sessionId);
            createPPTQuery.setUserId(String.valueOf(rc.getCurrUserId()));
            createPPTQuery.setPptTemplate(null);
            createPPTQuery.setDownloadRequestId(downloadRequestId);
            createPPTQuery.setTitle(title);
            BaseResult baseResult = this.gptService().createPPT(Long.valueOf(rc.getOrgId()), createPPTQuery);
            this.getView().showLoading(new LocaleString("\u751f\u6210\u4e2d..."));
            if (Objects.equals(baseResult.getErrcode(), MsgErrorcodeEnum.CODE_0.getId())) {
                GetPPTStatusQuery getPPTStatusQuery = new GetPPTStatusQuery();
                getPPTStatusQuery.setDownloadRequestId(downloadRequestId);
                BaseResult downloadBaseResult = this.gptService().getPPTStatus(Long.valueOf(rc.getOrgId()), getPPTStatusQuery);
                JSONObject dataJo = downloadBaseResult.getDataAsJSONObject();
                int executeStatus = dataJo.getIntValue("executeStatus");
                if (executeStatus == ExecuteStatusEnum.FAIL.getKey()) {
                    this.getView().hideLoading();
                    this.log.info("\u521b\u5efaPPT\u5931\u8d25\u4e86\uff0cdownloadRequestId:{}", (Object)downloadRequestId);
                    this.getView().showErrorNotification("PPT\u751f\u6210\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u67d0\u4e9b\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301");
                } else {
                    this.getView().addClientCallBack(KEY_ACTION_WAIT_CREATE_PPT, Integer.valueOf(0));
                    this.log.info("PPT\u521b\u5efa\u4e2d...\uff0cdownloadRequestId:{}", (Object)downloadRequestId);
                }
            }
        } else {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String subServiceId = (String)formShowParameter.getCustomParam("subServiceId");
            String title = (String)this.getModel().getValue(KEY_TITLE);
            Dashboard dashboard = new Dashboard();
            dashboard.setId(null);
            dashboard.setSubServiceId(subServiceId);
            dashboard.setFtype(Integer.valueOf(DashboardTypeEnum.GPT.getKey()));
            dashboard.setFname(title);
            DashboardInfo dashboardInfo = new DashboardInfo();
            String tenantId = this.getTenantDTO().getTenantId();
            String sessionId = this.getSessionId();
            List<Content> contentList = this.getContentList();
            CreateDashboardQuery createDashboardQuery = new CreateDashboardQuery();
            createDashboardQuery.setContentList(contentList);
            createDashboardQuery.setTenantId(tenantId);
            createDashboardQuery.setTitle(title);
            createDashboardQuery.setSessionId(sessionId);
            createDashboardQuery.setUserId(String.valueOf(rc.getCurrUserId()));
            BaseResult baseResult = this.gptService().createDashboard(Long.valueOf(rc.getOrgId()), createDashboardQuery);
            if (!Objects.equals(baseResult.getErrcode(), MsgErrorcodeEnum.CODE_0.getId())) {
                this.log.info("\u521b\u5efa\u4eea\u8868\u76d8\u5931\u8d25\uff0csessionId:{}", (Object)sessionId);
                this.getView().showErrorNotification(baseResult.getDescriptionCn());
                return;
            }
            this.log.info("\u521b\u5efa\u4eea\u8868\u76d8\u6210\u529f\uff0csessionId:{}", (Object)sessionId);
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            dashboardInfo.setSupersetDashboardId(Long.valueOf(Long.parseLong(dataJo.getString("dashboardId"))));
            dashboardInfo.setSupersetDashboardUuid(dataJo.getString("dashboardUUID"));
            dashboard.setFdashboardInfo(JSONObject.toJSONString((Object)dashboardInfo));
            dashboard.setFstatus(Integer.valueOf(EnableEnum.AVAIL.getKey()));
            BaseResult saveDashboardBaseResult = this.dashboardService().saveDashboard(Long.valueOf(rc.getOrgId()), dashboard);
            if (Objects.equals(saveDashboardBaseResult.getErrcode(), BaseResult.SUCCESS) && saveDashboardBaseResult.getData() != null) {
                dashboard = (Dashboard)JSONObject.parseObject((String)baseResult.getDataAsJSONString(), Dashboard.class);
                this.getCache().put(KEY_LAST_CREATE_DASHBOARD_ID, String.valueOf(dashboard.getId()));
                this.clearSelected();
                this.getModel().setValue(KEY_TITLE, null);
                IFormView parentView = this.getView().getParentView();
                parentView.getModel().setValue(KEY_LAST_CREATE_DASHBOARD_ID, (Object)this.getLastCreateDashboradId());
                parentView.addClientCallBack(KEY_HIDE_GPT, Integer.valueOf(0));
                this.getView().sendFormAction(parentView);
                this.getView().showSuccessNotification("\u521b\u5efa\u6210\u529f");
            } else {
                this.getView().showTipNotification(saveDashboardBaseResult.getDescriptionCn());
            }
        }
    }

    private List<Content> getContentList() {
        ArrayList<Content> contentList = new ArrayList<Content>();
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY_SELECT);
        int[] selectRows = cardEntry.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            for (int rowIndex : selectRows) {
                String chatContentStr = (String)this.getModel().getValue("chatcontent", rowIndex);
                ChatContent chatContent = (ChatContent)JSONObject.parseObject((String)chatContentStr, ChatContent.class);
                if (chatContent == null) continue;
                Content content = new Content();
                content.setIndex(chatContent.getIndex());
                content.setSelectData(chatContent.getHasData());
                content.setSelectInsight(chatContent.getHasInsight());
                contentList.add(content);
            }
        }
        return contentList;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        RequestContext rc = RequestContext.get();
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_HIDE_GPT)) {
                this.hideGptForm();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_NEWCHAT)) {
                this.newSessionId();
                this.getModel().deleteEntryData(KEY_ENTRYENTITY);
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ENTRYENTITY});
                this.getModel().deleteEntryData(KEY_ENTRYENTITY_SELECT);
                this.getCache().put(KEY_VALID_MSG_REQUESTID_CHATCONTENT_MAP, "");
                this.exitCreateEditStatus();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_SEND_MSG)) {
                String lastMsg = this.getLastMsg();
                String content = (String)this.getModel().getValue(KEY_MSG);
                if (StringUtils.isEmpty((CharSequence)content)) {
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)lastMsg, (CharSequence)content)) {
                    this.getView().showTipNotification("\u91cd\u590d\u6d88\u606f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u53d1\u9001");
                    return;
                }
                this.sendMsg(content);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_EDIT_CHART)) {
                CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
                int focusRow = cardEntry.getEntryState().getFocusRow();
                String tableId = (String)this.getModel().getValue("tableid", focusRow);
                String chartId = (String)this.getModel().getValue("chartid", focusRow);
                String path = "/explore/?slice_id=%s&show_nav=false";
                String viewType = (String)this.getModel().getValue("viewtype", focusRow);
                if (StringUtils.equalsIgnoreCase((CharSequence)viewType, (CharSequence)KEY_TABLEVIEW)) {
                    path = String.format(path, tableId);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)viewType, (CharSequence)KEY_CHARTVIEW)) {
                    path = String.format(path, chartId);
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setCaption("\u56fe\u8868\u7f16\u8f91");
                formShowParameter.setFormId(IdsFormIdEnum.IDS_EMBED_SUPERSET.getId());
                formShowParameter.setCustomParam("path", (Object)path);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(formShowParameter);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_REFRESH_CHART)) {
                CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
                int focusRow = cardEntry.getEntryState().getFocusRow();
                this.getModel().setValue("random", (Object)"0", focusRow);
                this.getView().updateView(KEY_ENTRYENTITY, focusRow);
                String action = String.format("%s%s%s", KEY_REFRESH_CHART, "->", focusRow);
                this.getView().addClientCallBack(action, Integer.valueOf(400));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_CREATE_DASHBOARD)) {
                DynamicObjectCollection entity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                int size = entity.size();
                if (size == 0) {
                    this.getView().showTipNotification("\u6682\u65e0\u53ef\u7528\u7684\u6570\u636e\uff0c\u8bf7\u5148\u5411\u6211\u63d0\u95ee");
                    return;
                }
                this.enterCreateEditStatus(GPTGenerateTypeEnum.DASHBOARD);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_CREATE_PPT)) {
                DynamicObjectCollection entity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                int size = entity.size();
                if (size == 0) {
                    this.getView().showTipNotification("\u6682\u65e0\u53ef\u7528\u7684\u6570\u636e\uff0c\u8bf7\u5148\u5411\u6211\u63d0\u95ee");
                    return;
                }
                this.enterCreateEditStatus(GPTGenerateTypeEnum.PPT);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_STOP_GENERATE)) {
                this.getCache().put(KEY_NEED_STOP_GENERATE, "true");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_FEEDBACK)) {
                CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
                int focusRow = cardEntry.getEntryState().getFocusRow();
                String content = (String)this.getModel().getValue("sqlerror", focusRow);
                this.getModel().setValue(KEY_MSG, (Object)content);
                this.initGptInputControl(content, true);
                this.getView().updateView(KEY_ENTRYENTITY);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_INSIGHT)) {
                CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
                int focusRow = cardEntry.getEntryState().getFocusRow();
                this.resetCurrAnswerMsgIndex(focusRow);
                String sessionId = this.getSessionId();
                String requestId = (String)this.getModel().getValue("requestid", focusRow);
                TaskResponseQuery taskResponseQuery = new TaskResponseQuery();
                taskResponseQuery.setSessionId(sessionId);
                taskResponseQuery.setRequestId(requestId);
                taskResponseQuery.setTenantId(this.getTenantDTO().getTenantId());
                taskResponseQuery.setUserId(String.valueOf(rc.getCurrUserId()));
                BaseResult taskResponseBaseResult = this.gptService().taskResponse(Long.valueOf(rc.getOrgId()), taskResponseQuery);
                if (Objects.equals(taskResponseBaseResult.getErrcode(), MsgErrorcodeEnum.CODE_501.getId()) && taskResponseBaseResult.getData() != null) {
                    this.log.info("\u6d1e\u5bdf\u6d41\u63a7\u4e2d\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                    this.getModel().setValue("insightstatus", (Object)String.valueOf(MsgErrorcodeEnum.CODE_501.getId()), focusRow);
                    this.getModel().setValue(KEY_INSIGHT, (Object)"\u6d1e\u5bdf\u6d41\u63a7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", focusRow);
                } else {
                    this.resetRequestIdStartTime(requestId);
                    this.getView().addClientCallBack(KEY_ACTION_WAIT_GPT_INSIGHT_DATA, Integer.valueOf(0));
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_SELECT_ALL)) {
                CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY_SELECT);
                int[] validAnswerIndexArr = this.getValidAnswerIndexArr();
                if (validAnswerIndexArr != null && validAnswerIndexArr.length > 0) {
                    int[] rowIndex = new int[validAnswerIndexArr.length];
                    for (int i = 0; i < validAnswerIndexArr.length; ++i) {
                        rowIndex[i] = i;
                    }
                    cardEntry.selectRows(rowIndex, 0);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_RESET)) {
                this.clearSelected();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_RETRY_SEND_MSG)) {
                String value = this.getLastMsg();
                this.sendMsg(value);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_TABLEVIEW)) {
                this.showViewType(KEY_TABLEVIEW);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_CHARTVIEW)) {
                this.showViewType(KEY_CHARTVIEW);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_INLINEVIEW)) {
                this.showViewType(KEY_INLINEVIEW);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_EDIT_MSG)) {
                CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
                int focusRow = cardEntry.getEntryState().getFocusRow();
                String content = (String)this.getModel().getValue("question", focusRow);
                this.initGptInputControl(content, true);
            }
        }
    }

    private void showViewType(String viewType) {
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        this.getModel().setValue("viewtype", (Object)viewType, focusRow);
        this.getView().updateView(KEY_ENTRYENTITY, focusRow);
        String path = "/explore/?slice_id=%s&standalone=1";
        String requestId = (String)this.getModel().getValue("requestid", focusRow);
        if (StringUtils.equalsIgnoreCase((CharSequence)viewType, (CharSequence)KEY_TABLEVIEW)) {
            String tableId = (String)this.getModel().getValue("tableid", focusRow);
            this.showSupersetChart(DataChartTypeEnum.TABLE, requestId, String.format(path, tableId), false);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)viewType, (CharSequence)KEY_CHARTVIEW)) {
            String chartId = (String)this.getModel().getValue("chartid", focusRow);
            this.showSupersetChart(DataChartTypeEnum.CHART, requestId, String.format(path, chartId), false);
        }
    }

    private void hideGptForm() {
        JSONObject opResult = new JSONObject();
        opResult.put("status", (Object)Boolean.TRUE);
        opResult.put("dashboardId", (Object)this.getLastCreateDashboradId());
        opResult.put("opKey", (Object)KEY_HIDE_GPT);
        this.getCache().put("opResult", opResult.toJSONString());
        IFormView parentView = this.getView().getParentView();
        parentView.setVisible(Boolean.FALSE, new String[]{KEY_FLEX_GPT_MODAL});
        parentView.getModel().setValue(KEY_LAST_CREATE_DASHBOARD_ID, (Object)this.getLastCreateDashboradId());
        parentView.addClientCallBack(KEY_HIDE_GPT, Integer.valueOf(0));
        this.getView().sendFormAction(parentView);
    }

    private void exitCreateEditStatus() {
        this.getCache().put(KEY_CURR_GENERATE_TYPE, "");
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_GENERATE_SELECT});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BARITEM_DASHBOARD, KEY_BARITEM_PPT, KEY_FLEX_BOTTOM, KEY_FLEX_CHAT});
        this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BARITEM_DASHBOARD, KEY_BARITEM_PPT});
        this.setSendMsgStatus(true);
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        for (int i = 0; i < entity.size(); ++i) {
            cardEntry.setChildVisible(true, i, new String[]{KEY_FLEX_CHAT_CARD, KEY_FLEX_INSIGHT});
            cardEntry.setChildVisible(true, i, new String[]{KEY_EDIT_CHART, KEY_REFRESH_CHART, KEY_VECTORAP_INSIGHT, KEY_LABELAP_INSIGHT, KEY_TABLEVIEW, KEY_CHARTVIEW});
        }
    }

    private void enterCreateEditStatus(GPTGenerateTypeEnum gptGenerateTypeEnum) {
        RequestContext rc = RequestContext.get();
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
        String sessionId = this.getSessionId();
        ChatContentListQuery chatContentListQuery = new ChatContentListQuery();
        chatContentListQuery.setSessionId(sessionId);
        chatContentListQuery.setTenantId(this.getTenantDTO().getTenantId());
        chatContentListQuery.setUserId(String.valueOf(rc.getCurrUserId()));
        BaseResult baseResult = this.gptService().chatContentList(Long.valueOf(rc.getOrgId()), chatContentListQuery);
        if (Objects.equals(baseResult.getErrcode(), MsgErrorcodeEnum.CODE_0.getId())) {
            this.log.info("\u83b7\u53d6\u4f1a\u8bdd\u4e2d\u6709\u6548\u7684\u6d88\u606f\u5185\u5bb9\u6210\u529f\uff0csessionId:{}", (Object)sessionId);
            ChatContentListResponseData chatContentListResponseData = (ChatContentListResponseData)JSONObject.parseObject((String)baseResult.getDataAsJSONString(), ChatContentListResponseData.class);
            ArrayList<ChatContent> chatContentList = new ArrayList<ChatContent>(10);
            if (chatContentListResponseData != null) {
                Map<String, ChatContent> requestIdChatContentMap;
                List contentList = chatContentListResponseData.getContentList();
                if (CollectionUtils.isNotEmpty((Collection)contentList)) {
                    this.log.info("ChatContentList has data, validMsgIndex use remote.");
                    requestIdChatContentMap = this.getValidMsgRequestIdChatContentMap();
                    for (ChatContent chatContent : contentList) {
                        String requestId = chatContent.getIndex();
                        if (requestIdChatContentMap == null || !requestIdChatContentMap.containsKey(requestId)) continue;
                        ChatContent localChatContent = requestIdChatContentMap.get(requestId);
                        chatContent.setMsgIndex(localChatContent.getMsgIndex());
                        chatContentList.add(chatContent);
                    }
                } else {
                    this.log.info("ChatContentList no data, validMsgIndex use local.");
                    requestIdChatContentMap = this.getValidMsgRequestIdChatContentMap();
                    if (MapUtils.isNotEmpty(requestIdChatContentMap)) {
                        for (ChatContent chatContent : requestIdChatContentMap.values()) {
                            chatContentList.add(chatContent);
                        }
                    }
                }
            }
            if (CollectionUtils.isEmpty(chatContentList)) {
                this.getView().showTipNotification("\u6682\u65e0\u53ef\u7528\u7684\u6570\u636e\uff0c\u4f60\u53ef\u4ee5\u7ee7\u7eed\u63d0\u95ee");
                return;
            }
            this.initSelectEntityData(chatContentList);
            HashMap<String, String> titleMap1 = new HashMap<String, String>();
            titleMap1.put("zh_CN", String.format("%s\u540d\u79f0", gptGenerateTypeEnum.getName()));
            HashMap<String, HashMap<String, String>> titleMap2 = new HashMap<String, HashMap<String, String>>();
            titleMap2.put("caption", titleMap1);
            this.getView().updateControlMetadata(KEY_TITLE, titleMap2);
            this.getModel().setValue(KEY_TITLE, null);
            this.setLabelText(KEY_LABEL_GEN_TYPE, String.format("\u5feb\u901f\u751f\u6210%s", gptGenerateTypeEnum.getName()));
            this.getCache().put(KEY_CURR_GENERATE_TYPE, gptGenerateTypeEnum.getId());
            this.setLabelText(KEY_LABELAP_SELECT_COUNT, String.valueOf(0));
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_GENERATE_SELECT});
        } else {
            this.log.info("\u83b7\u53d6\u4f1a\u8bdd\u4e2d\u6709\u6548\u7684\u6d88\u606f\u5185\u5bb9\u5931\u8d25\uff0csessionId:{}", (Object)sessionId);
            this.getView().showErrorNotification(baseResult.getDescriptionCn());
        }
    }

    private void initSelectEntityData(List<ChatContent> chatContentList) {
        if (CollectionUtils.isNotEmpty(chatContentList)) {
            int validMsgSize = chatContentList.size();
            this.getModel().deleteEntryData(KEY_ENTRYENTITY_SELECT);
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY_SELECT, validMsgSize);
            int selectMsgIndex = 0;
            for (ChatContent chatContent : chatContentList) {
                String selectViewType = null;
                String tableId = (String)this.getModel().getValue("tableid", chatContent.getMsgIndex().intValue());
                String chartId = (String)this.getModel().getValue("chartid", chatContent.getMsgIndex().intValue());
                String inlineData = (String)this.getModel().getValue("inlinedata", chatContent.getMsgIndex().intValue());
                if (StringUtils.isNotEmpty((CharSequence)chartId)) {
                    selectViewType = KEY_CHARTVIEW;
                } else if (StringUtils.isNotEmpty((CharSequence)tableId)) {
                    selectViewType = KEY_TABLEVIEW;
                } else if (StringUtils.isNotEmpty((CharSequence)inlineData)) {
                    selectViewType = KEY_INLINEVIEW;
                }
                this.getModel().setValue("selectviewtype", (Object)selectViewType, selectMsgIndex);
                this.getModel().setValue("selecttitle", (Object)chatContent.getTitle(), selectMsgIndex);
                this.getModel().setValue("chatcontent", (Object)JSONObject.toJSONString((Object)chatContent), selectMsgIndex);
                ++selectMsgIndex;
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ENTRYENTITY_SELECT});
        }
    }

    private void clearSelected() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(KEY_ENTRYENTITY_SELECT);
        int size = entity.size();
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY_SELECT);
        if (size > 0) {
            cardEntry.selectRows(new int[0], 0);
        }
        this.setLabelText(KEY_LABELAP_SELECT_COUNT, String.valueOf(0));
    }

    private BaseResult gptInsightData(String sessionId, String requestId) {
        RequestContext rc = RequestContext.get();
        GptInsightDataQuery gptInsightDataQuery = new GptInsightDataQuery();
        gptInsightDataQuery.setRequestId(requestId);
        gptInsightDataQuery.setSessionId(sessionId);
        gptInsightDataQuery.setUserId(String.valueOf(rc.getCurrUserId()));
        gptInsightDataQuery.setTenantId(this.getTenantDTO().getTenantId());
        BaseResult baseResult = this.gptService().gptInsightData(Long.valueOf(rc.getOrgId()), gptInsightDataQuery);
        return baseResult;
    }

    private void sendMsg(String content) {
        this.getView().updateView(KEY_ENTRYENTITY);
        this.setSendMsgStatus(false);
        this.showQuestionMsgInEntity(content);
        this.getCache().put(KEY_LAST_MSG, content);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_STOP_GENERATE});
        this.sendUserMessage2GPT(content);
    }

    private String newRequestId() {
        String requestId = "unittestrequestid";
        if (!CommonUtil.useMock()) {
            requestId = UUID.randomUUID().toString();
        }
        return requestId;
    }

    private void sendUserMessage2GPT(String content) {
        RequestContext rc = RequestContext.get();
        String sessionId = this.getSessionId();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer dashboard_id = (Integer)formShowParameter.getCustomParam("supersetDashboardId");
        String appIdentifier = (String)formShowParameter.getCustomParam("appIdentifier");
        String requestId = this.newRequestId();
        this.getCache().put(KEY_REQUEST_ID, requestId);
        UserMessageQuery userMessageQuery = new UserMessageQuery();
        userMessageQuery.setPayload(content);
        userMessageQuery.setUserId(String.valueOf(rc.getCurrUserId()));
        userMessageQuery.setService(appIdentifier);
        userMessageQuery.setRequestId(requestId);
        userMessageQuery.setSessionId(sessionId);
        userMessageQuery.setTenantId(this.getTenantDTO().getTenantId());
        ServiceParam serviceParam = new ServiceParam();
        serviceParam.setDashboard_id(String.valueOf(dashboard_id));
        userMessageQuery.setServiceParam(serviceParam);
        BaseResult baseResult = this.gptService().userMessage(Long.valueOf(rc.getOrgId()), userMessageQuery);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
            this.getModel().setValue(KEY_MSG, null);
            this.resetRequestIdStartTime(requestId);
            this.getView().addClientCallBack(KEY_ACTION_WAIT_TASK_RESPONSE, Integer.valueOf(0));
        } else if (Objects.equals(baseResult.getErrcode(), MsgErrorcodeEnum.CODE_201.getId()) && baseResult.getData() != null) {
            this.log.info("\u91cd\u590d\u6d88\u606f\uff0crequestId:{}", (Object)userMessageQuery.getRequestId());
            this.getView().showTipNotification("\u91cd\u590d\u6d88\u606f");
            this.getModel().setValue(KEY_MSG, null);
            this.setSendMsgStatus(true);
        } else {
            this.setSendMsgStatus(true);
            this.getView().showErrorNotification(baseResult.getDescriptionCn());
        }
    }

    private void resetRequestIdStartTime(String requestId) {
        Map<String, Long> requestIdStartTimeMap = this.getRequestIdStartTimeMap();
        requestIdStartTimeMap.put(requestId, KDDateUtils.now().getTime());
        this.getCache().put(KEY_REQUESTID_STARTTIME_MAP, JSONObject.toJSONString(requestIdStartTimeMap));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        RequestContext rc = RequestContext.get();
        String action = e.getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)KEY_ACTION_WAIT_TASK_RESPONSE)) {
            Integer currMsgIndex = this.getCurrAnswerMsgIndex();
            if (this.needStopGenerate()) {
                this.getModel().setValue("answer", (Object)"\u751f\u6210\u5df2\u505c\u6b62\uff0c\u4f60\u53ef\u4ee5\u7ee7\u7eed\u63d0\u95ee", currMsgIndex.intValue());
                this.resetCurrAnswerMsgIndex(0);
                this.setSendMsgStatus(true);
                return;
            }
            boolean createEntryRow = currMsgIndex <= 0;
            String sessionId = this.getSessionId();
            String requestId = this.getRequestId();
            TaskResponseQuery taskResponseQuery = new TaskResponseQuery();
            taskResponseQuery.setSessionId(sessionId);
            taskResponseQuery.setRequestId(requestId);
            taskResponseQuery.setTenantId(this.getTenantDTO().getTenantId());
            taskResponseQuery.setUserId(String.valueOf(rc.getCurrUserId()));
            BaseResult baseResult = this.gptService().taskResponse(Long.valueOf(rc.getOrgId()), taskResponseQuery);
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
                this.log.info("\u6d88\u606f\u5904\u7406\u5b8c\u6210\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                TaskResponseData taskResponseData = (TaskResponseData)JSONObject.parseObject((String)baseResult.getDataAsJSONString(), TaskResponseData.class);
                this.setSendMsgStatus(true);
                this.showAnswerMsgInEntity(requestId, MsgErrorcodeEnum.CODE_0.getId(), taskResponseData, null, createEntryRow);
                this.resetCurrAnswerMsgIndex(0);
                this.getCache().put(KEY_CURR_TASK_RESPONSE_DATA, JSONObject.toJSONString((Object)taskResponseData));
                String currGenerateType = this.getCurrGenerateType();
                if (StringUtils.isNotEmpty((CharSequence)currGenerateType)) {
                    this.enterCreateEditStatus(GPTGenerateTypeEnum.fromId((String)currGenerateType));
                }
            } else if (Objects.equals(baseResult.getErrcode(), MsgErrorcodeEnum.CODE_201.getId()) && baseResult.getData() != null) {
                this.log.info("\u6d88\u606f\u5904\u7406\u4e2d\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                TaskResponseData taskResponseData = (TaskResponseData)JSONObject.parseObject((String)baseResult.getDataAsJSONString(), TaskResponseData.class);
                Map<String, Long> requestIdStartTimeMap = this.getRequestIdStartTimeMap();
                Long requestIdStartTime = requestIdStartTimeMap.get(requestId);
                if (requestIdStartTime != null && KDDateUtils.now().getTime() - requestIdStartTime > 30000L) {
                    this.showAnswerMsgInEntity(requestId, MsgErrorcodeEnum.CODE_408.getId(), taskResponseData, null, createEntryRow);
                    this.setSendMsgStatus(true);
                } else {
                    this.getView().addClientCallBack(KEY_ACTION_WAIT_TASK_RESPONSE, Integer.valueOf(500));
                    this.showAnswerMsgInEntity(requestId, MsgErrorcodeEnum.CODE_201.getId(), taskResponseData, null, createEntryRow);
                    this.setSendMsgStatus(false);
                }
            } else if (Objects.equals(baseResult.getErrcode(), MsgErrorcodeEnum.CODE_501.getId()) && baseResult.getData() != null) {
                this.log.info("\u6d88\u606f\u6d41\u63a7\u4e2d\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                TaskResponseData taskResponseData = (TaskResponseData)JSONObject.parseObject((String)baseResult.getDataAsJSONString(), TaskResponseData.class);
                this.showAnswerMsgInEntity(requestId, MsgErrorcodeEnum.CODE_501.getId(), taskResponseData, null, createEntryRow);
                this.setSendMsgStatus(true);
            } else {
                this.log.info("\u670d\u52a1\u7aef\u9519\u8bef\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                TaskResponseData taskResponseData = (TaskResponseData)JSONObject.parseObject((String)baseResult.getDataAsJSONString(), TaskResponseData.class);
                this.showAnswerMsgInEntity(requestId, MsgErrorcodeEnum.CODE_500.getId(), taskResponseData, baseResult.getDescriptionCn(), createEntryRow);
                this.setSendMsgStatus(true);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)KEY_ACTION_WAIT_GPT_INSIGHT_DATA)) {
            CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
            int focusRow = cardEntry.getEntryState().getFocusRow();
            this.resetCurrAnswerMsgIndex(focusRow);
            String sessionId = this.getSessionId();
            String requestId = (String)this.getModel().getValue("requestid", focusRow);
            TaskResponseQuery taskResponseQuery = new TaskResponseQuery();
            taskResponseQuery.setSessionId(sessionId);
            taskResponseQuery.setRequestId(requestId);
            taskResponseQuery.setTenantId(this.getTenantDTO().getTenantId());
            taskResponseQuery.setUserId(String.valueOf(rc.getCurrUserId()));
            BaseResult taskResponseBaseResult = this.gptService().taskResponse(Long.valueOf(rc.getOrgId()), taskResponseQuery);
            if (Objects.equals(taskResponseBaseResult.getErrcode(), MsgErrorcodeEnum.CODE_501.getId())) {
                this.log.info("\u6d1e\u5bdf\u6d41\u63a7\u4e2d\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                this.getModel().setValue("insightstatus", (Object)String.valueOf(MsgErrorcodeEnum.CODE_501.getId()), focusRow);
                this.getModel().setValue(KEY_INSIGHT, (Object)"\u6d1e\u5bdf\u6d41\u63a7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", focusRow);
            } else {
                BaseResult baseResult = this.gptInsightData(sessionId, requestId);
                if (Objects.equals(baseResult.getErrcode(), MsgErrorcodeEnum.CODE_0.getId())) {
                    this.log.info("\u6d1e\u5bdf\u6210\u529f\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                    this.updateInsight(requestId, baseResult);
                } else if (Objects.equals(baseResult.getErrcode(), MsgErrorcodeEnum.CODE_201.getId())) {
                    this.log.info("\u6d1e\u5bdf\u6570\u636e\u4e2d...\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                    Map<String, Long> requestIdStartTimeMap = this.getRequestIdStartTimeMap();
                    Long requestIdStartTime = requestIdStartTimeMap.get(requestId);
                    if (requestIdStartTime != null && KDDateUtils.now().getTime() - requestIdStartTime > 30000L) {
                        this.log.info("\u6d1e\u5bdf\u8bf7\u6c42\u8d85\u65f6\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                        this.getModel().setValue("insightstatus", (Object)String.valueOf(MsgErrorcodeEnum.CODE_408.getId()), focusRow);
                        this.getModel().setValue(KEY_INSIGHT, (Object)"\u6d1e\u5bdf\u8bf7\u6c42\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", focusRow);
                    } else {
                        this.getModel().setValue("insightstatus", (Object)String.valueOf(MsgErrorcodeEnum.CODE_201.getId()), focusRow);
                        this.getModel().setValue(KEY_INSIGHT, (Object)"\u6b63\u5728\u4e3a\u4f60\u6d1e\u5bdf\u6570\u636e...", focusRow);
                        this.getView().addClientCallBack(KEY_ACTION_WAIT_GPT_INSIGHT_DATA, Integer.valueOf(500));
                    }
                } else {
                    this.log.info("\u6d1e\u5bdf\u5931\u8d25\uff0csessionId:{}, requestId:{}", (Object)sessionId, (Object)requestId);
                    this.getModel().setValue("insightstatus", (Object)String.valueOf(MsgErrorcodeEnum.CODE_500.getId()), focusRow);
                    this.getModel().setValue(KEY_INSIGHT, (Object)String.format("\u6d1e\u5bdf\u8bf7\u6c42\u9519\u8bef\uff1a%s\u3002\u8bf7\u7a0d\u540e\u518d\u8bd5", baseResult.getDescriptionCn()), focusRow);
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)KEY_ACTION_WAIT_CREATE_PPT)) {
            String downloadRequestId = this.getDownloadRequestId();
            GetPPTStatusQuery getPPTStatusQuery = new GetPPTStatusQuery();
            getPPTStatusQuery.setDownloadRequestId(downloadRequestId);
            BaseResult downloadBaseResult = this.gptService().getPPTStatus(Long.valueOf(rc.getOrgId()), getPPTStatusQuery);
            JSONObject dataJo = downloadBaseResult.getDataAsJSONObject();
            int executeStatus = dataJo.getIntValue("executeStatus");
            if (executeStatus == ExecuteStatusEnum.SUCCESS.getKey()) {
                String downloadUrl = this.gptService().getPPTDownloadUrl(Long.valueOf(rc.getOrgId()), null, downloadRequestId);
                this.getView().download(downloadUrl);
                this.getView().showLoading(new LocaleString("\u751f\u6210\u4e2d..."), 1500, false);
                this.clearSelected();
                this.getModel().setValue(KEY_TITLE, null);
            } else if (executeStatus == ExecuteStatusEnum.FAIL.getKey()) {
                this.getView().hideLoading();
                this.log.info("\u521b\u5efaPPT\u5931\u8d25\u4e86\uff0cdownloadRequestId:{}", (Object)downloadRequestId);
                this.getView().showErrorNotification("PPT\u751f\u6210\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u67d0\u4e9b\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301");
            } else {
                this.getView().addClientCallBack(KEY_ACTION_WAIT_CREATE_PPT, Integer.valueOf(500));
                this.log.info("PPT\u521b\u5efa\u4e2d...\uff0cdownloadRequestId:{}", (Object)downloadRequestId);
            }
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)action, (CharSequence)KEY_REFRESH_CHART)) {
            int focusRow = Integer.parseInt(action.split("->")[1]);
            this.getModel().setValue("random", (Object)"1", focusRow);
            this.getView().updateView(KEY_ENTRYENTITY, focusRow);
            String requestId = (String)this.getModel().getValue("requestid", focusRow);
            String viewType = (String)this.getModel().getValue("viewtype", focusRow);
            String path = "/explore/?slice_id=%s&standalone=1";
            if (StringUtils.equalsIgnoreCase((CharSequence)viewType, (CharSequence)KEY_TABLEVIEW)) {
                String tableId = (String)this.getModel().getValue("tableid", focusRow);
                this.showSupersetChart(DataChartTypeEnum.TABLE, requestId, String.format(path, tableId), false);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)viewType, (CharSequence)KEY_CHARTVIEW)) {
                String chartId = (String)this.getModel().getValue("chartid", focusRow);
                this.showSupersetChart(DataChartTypeEnum.CHART, requestId, String.format(path, chartId), false);
            }
        }
    }

    private void updateInsight(String requestId, BaseResult gptInsightDataBaseResult) {
        String message;
        int msgIndex = this.getCurrAnswerMsgIndex();
        InsightResponseData insightResponseData = (InsightResponseData)JSONObject.parseObject((String)gptInsightDataBaseResult.getDataAsJSONString(), InsightResponseData.class);
        if (StringUtils.equalsIgnoreCase((CharSequence)insightResponseData.getDataType(), (CharSequence)MsgDataTypeEnum.TEXT.getId()) && StringUtils.isNotEmpty((CharSequence)(message = insightResponseData.getText().getMessage()))) {
            Map<String, ChatContent> validMsgRequestIdChatContentMap = this.getValidMsgRequestIdChatContentMap();
            ChatContent chatContent = validMsgRequestIdChatContentMap.get(requestId);
            if (chatContent != null) {
                chatContent.setHasInsight(Boolean.valueOf(true));
                validMsgRequestIdChatContentMap.put(requestId, chatContent);
                this.getCache().put(KEY_VALID_MSG_REQUESTID_CHATCONTENT_MAP, JSONObject.toJSONString(validMsgRequestIdChatContentMap));
            }
            this.getModel().setValue(KEY_INSIGHT, (Object)message, msgIndex);
            this.getModel().setValue("insightstatus", (Object)MsgErrorcodeEnum.CODE_0.getId(), msgIndex);
            this.getView().updateView(KEY_ENTRYENTITY);
        }
        this.resetCurrAnswerMsgIndex(0);
    }

    private void setSendMsgStatus(boolean enable) {
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRYENTITY);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        for (int i = 0; i < entity.size(); ++i) {
            cardEntry.setChildEnable(enable, i, new String[]{KEY_EDIT_CHART, KEY_REFRESH_CHART, KEY_TABLEVIEW, KEY_CHARTVIEW, KEY_LABELAP_INSIGHT, KEY_LABEL_FEEDBACK, KEY_RETRY_SEND_MSG, KEY_EDIT_MSG});
        }
        if (enable) {
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_MSG, KEY_VECTORAP_SEND_MSG, KEY_IMAGEAP_NEWCHAT});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_STOP_GENERATE});
            this.getCache().put(KEY_NEED_STOP_GENERATE, String.valueOf(false));
            this.initGptInputControl(null, true);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_MSG, KEY_VECTORAP_SEND_MSG, KEY_IMAGEAP_NEWCHAT});
            this.initGptInputControl(null, false);
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_STOP_GENERATE});
        }
    }

    private void showAnswerMsgInEntity(String requestId, int msgStatus, TaskResponseData taskResponseData, String errMsg, boolean createEntryRow) {
        int currMsgIndex;
        DynamicObjectCollection entity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        int size = entity.size();
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRYENTITY});
        Map<String, ChatContent> validMsgRequestIdChatContentMap = this.getValidMsgRequestIdChatContentMap();
        if (validMsgRequestIdChatContentMap == null) {
            validMsgRequestIdChatContentMap = new HashMap<String, ChatContent>();
        }
        int msgIndex = currMsgIndex = this.getCurrAnswerMsgIndex();
        if (createEntryRow) {
            msgIndex = size;
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, 1);
            this.resetCurrAnswerMsgIndex(msgIndex);
        }
        this.getModel().setValue("msgindex", (Object)String.valueOf(msgIndex), msgIndex);
        this.getModel().setValue("msgstatus", (Object)msgStatus, msgIndex);
        this.getModel().setValue("type", (Object)ChatTypeEnum.A.getId(), msgIndex);
        this.getModel().setValue("requestid", (Object)requestId, msgIndex);
        if (msgStatus == MsgErrorcodeEnum.CODE_0.getId()) {
            this.getModel().setValue("msgdatatype", (Object)taskResponseData.getDataType(), msgIndex);
            if (StringUtils.equalsIgnoreCase((CharSequence)taskResponseData.getDataType(), (CharSequence)MsgDataTypeEnum.SQL.getId())) {
                TaskResponseSql sql = taskResponseData.getSql();
                String gptContent = sql.getGptContent();
                String executeStatus = sql.getExecuteStatus();
                this.getModel().setValue("sqlexecutestatus", (Object)executeStatus, msgIndex);
                if (StringUtils.equalsIgnoreCase((CharSequence)executeStatus, (CharSequence)SqlExecuteStatusEnum.SUCCESS.getId())) {
                    String sqlDataType = sql.getDataType();
                    SqlTable table = sql.getTable();
                    SqlChart chart = sql.getChart();
                    String tableId = null;
                    String tableTitle = null;
                    if (table != null) {
                        tableId = table.getId();
                        tableTitle = table.getTitle();
                    }
                    String chartId = null;
                    String chartTitle = null;
                    if (chart != null) {
                        chartId = chart.getId();
                        chartTitle = chart.getTitle();
                    }
                    String msgTitle = StringUtils.isEmpty((CharSequence)tableTitle) ? chartTitle : tableTitle;
                    String insight = sql.getInsight();
                    String inlineData = sql.getInlineData() == null || sql.getInlineData().isEmpty() ? EMPTY_INLINE_DATA : JSONObject.toJSONString((Object)sql.getInlineData(), (boolean)true);
                    String insightStatus = (String)this.getModel().getValue("insightstatus", msgIndex);
                    if (StringUtils.isEmpty((CharSequence)insightStatus)) {
                        insightStatus = String.valueOf(MsgErrorcodeEnum.CODE__1.getId());
                    }
                    this.getModel().setValue("tableid", (Object)tableId, msgIndex);
                    this.getModel().setValue("chartid", (Object)chartId, msgIndex);
                    this.getModel().setValue("msgtitle", (Object)msgTitle, msgIndex);
                    this.getModel().setValue("sqldatatype", (Object)sqlDataType, msgIndex);
                    this.getModel().setValue("inlinedata", (Object)inlineData, msgIndex);
                    this.getModel().setValue("insightstatus", (Object)insightStatus, msgIndex);
                    this.getModel().setValue(KEY_INSIGHT, (Object)insight, msgIndex);
                    ChatContent chatContent = new ChatContent();
                    chatContent.setHasData(Boolean.valueOf(false));
                    chatContent.setHasInsight(Boolean.valueOf(false));
                    chatContent.setTitle(msgTitle);
                    chatContent.setIndex(requestId);
                    chatContent.setMsgIndex(Integer.valueOf(msgIndex));
                    String path = "/explore/?slice_id=%s&standalone=1";
                    if (!ObjectUtils.isEmpty((Object)tableId) || !ObjectUtils.isEmpty((Object)chartId)) {
                        if (!ObjectUtils.isEmpty((Object)tableId)) {
                            this.getModel().setValue("viewtype", (Object)KEY_TABLEVIEW, msgIndex);
                            this.showSupersetChart(DataChartTypeEnum.TABLE, requestId, String.format(path, tableId), false);
                        }
                        if (!ObjectUtils.isEmpty((Object)chartId)) {
                            this.getModel().setValue("viewtype", (Object)KEY_CHARTVIEW, msgIndex);
                            this.showSupersetChart(DataChartTypeEnum.CHART, requestId, String.format(path, chartId), false);
                        }
                        chatContent.setHasData(Boolean.valueOf(true));
                        validMsgRequestIdChatContentMap.put(requestId, chatContent);
                    }
                } else {
                    String error = sql.getError();
                    this.getModel().setValue("sql", (Object)gptContent, msgIndex);
                    this.getModel().setValue("sqlerror", (Object)error, msgIndex);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)taskResponseData.getDataType(), (CharSequence)MsgDataTypeEnum.TEXT.getId())) {
                ChatContent chatContent = new ChatContent();
                chatContent.setHasData(Boolean.valueOf(false));
                chatContent.setHasInsight(Boolean.valueOf(false));
                chatContent.setTitle(null);
                chatContent.setIndex(requestId);
                chatContent.setMsgIndex(Integer.valueOf(msgIndex));
                TaskResponseText text = taskResponseData.getText();
                String message = text.getMessage();
                this.getModel().setValue("answer", (Object)message, msgIndex);
            } else {
                this.getModel().setValue("answer", (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b", msgIndex);
            }
            this.getCache().put(KEY_VALID_MSG_REQUESTID_CHATCONTENT_MAP, JSONObject.toJSONString(validMsgRequestIdChatContentMap));
        } else if (msgStatus == MsgErrorcodeEnum.CODE_501.getId()) {
            this.getModel().setValue("answer", (Object)"\u6d88\u606f\u6d41\u63a7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", msgIndex);
            this.resetCurrAnswerMsgIndex(0);
        } else if (msgStatus == MsgErrorcodeEnum.CODE_408.getId()) {
            this.getModel().setValue("answer", (Object)"\u6d88\u606f\u8bf7\u6c42\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", msgIndex);
            this.resetCurrAnswerMsgIndex(0);
        } else if (msgStatus == MsgErrorcodeEnum.CODE_500.getId()) {
            this.getModel().setValue("answer", (Object)String.format("\u6d88\u606f\u8bf7\u6c42\u9519\u8bef\uff1a%s\u3002\u8bf7\u7a0d\u540e\u518d\u8bd5", errMsg), msgIndex);
            this.resetCurrAnswerMsgIndex(0);
        }
    }

    private void showQuestionMsgInEntity(String content) {
        int size;
        DynamicObjectCollection entity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        int index = size = entity.size();
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ENTRYENTITY});
        this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, 1);
        this.getModel().setValue("type", (Object)ChatTypeEnum.Q.getId(), index);
        this.getModel().setValue("question", (Object)content, index);
        this.getModel().setValue("msgdatatype", (Object)MsgErrorcodeEnum.CODE_0.getId());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Image gptLogoImg = (Image)this.getControl(KEY_IMAGEAP_GPTLOGO);
        gptLogoImg.setUrl("data:image/png;base64,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");
        Image newChatImg = (Image)this.getControl(KEY_IMAGEAP_NEWCHAT);
        newChatImg.setUrl("kingdee/ai-ids/gptinput/img/new_chat.png");
        Image msgLoadingImg = (Image)this.getControl(KEY_IMAGEAP_MSG_LOADING);
        msgLoadingImg.setUrl("kingdee/ai-ids/gptinput/img/msg_loading.gif");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imageHoverKey", "kingdee/ai-ids/gptinput/img/new_chat_hover.png");
        newChatImg.setCustomProperties(map);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_GENERATE_SELECT});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ENTRYENTITY, KEY_FLEX_STOP_GENERATE, KEY_FLEX_GENERATE_SELECT});
        this.newSessionId();
        this.initGptInputControl(null, true);
    }

    private void newSessionId() {
        String sessionId = UUID.randomUUID().toString();
        this.getCache().put(KEY_SESSION_ID, sessionId);
    }

    private void initGptInputControl(String value, boolean enable) {
        Date now = new Date();
        CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL_GPTINPUT);
        HashMap<String, Object> customData = new HashMap<String, Object>();
        JSONObject dataJo = new JSONObject();
        dataJo.put("value", (Object)value);
        dataJo.put("enable", (Object)enable);
        dataJo.put("focus", (Object)enable);
        this.setLabelText(KEY_LABEL_CURR_COUNT, String.valueOf(0));
        BaseResult tmpBaseResult = new BaseResult(BaseResult.SUCCESS, "success", "\u6210\u529f", (Object)dataJo);
        CustomBaseResult customBaseResult = new CustomBaseResult(tmpBaseResult, this.getView().getPageId(), CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        customData.put("data", customBaseResult.toJSONObject());
        customData.put("timestamp", now.getTime());
        customData.put("pageId", this.getView().getPageId());
        customData.put("uniqueCode", UUID.randomUUID().toString());
        customControl.setData(customData);
    }

    public void customEvent(CustomEventArgs e) {
        RequestContext rc = RequestContext.get();
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        JSONObject args = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)eventArgs)) {
            args = JSON.parseObject((String)eventArgs);
        }
        if (KEY_CUSTOM_CONTROL_GPTINPUT.equals(controlKey)) {
            if (KEY_KEY_UP.equalsIgnoreCase(eventName)) {
                String value = args.getString("value");
                this.getModel().setValue(KEY_MSG, (Object)value);
                this.setLabelText(KEY_LABEL_CURR_COUNT, StringUtils.isNotEmpty((CharSequence)value) ? String.valueOf(value.length()) : "0");
            } else if (KEY_SUBMIT_VALUE.equalsIgnoreCase(eventName)) {
                String value = args.getString("value");
                this.getModel().setValue(KEY_MSG, (Object)value);
                if (StringUtils.isEmpty((CharSequence)value)) {
                    return;
                }
                this.sendMsg(value);
            }
        }
    }

    private void showSupersetChart(DataChartTypeEnum dataChartTypeEnum, String requestId, String path, boolean refreshCustomControl) {
        CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL_EMBED_SUPERSET_TABLE);
        if (dataChartTypeEnum.getId().equalsIgnoreCase(DataChartTypeEnum.CHART.getId())) {
            customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL_EMBED_SUPERSET_CHART);
        }
        RequestContext rc = RequestContext.get();
        String clientUrl = rc.getClientUrl();
        JSONObject sessionJo = this.supersetService().getSession(Long.valueOf(rc.getOrgId()), this.getTenantDTO().getTenantId());
        String supersetDomain = sessionJo.getString("supersetDomain");
        String topDomain = sessionJo.getString("topDomain");
        if (StringUtils.isEmpty((CharSequence)topDomain)) {
            topDomain = StrUtils.parseTopDomain((String)clientUrl);
            this.log.info("clientUrl: {}, topDomain: {}", (Object)clientUrl, (Object)topDomain);
        }
        Date now = new Date();
        String session = sessionJo.getString("session");
        String url = String.format("%s%s", supersetDomain, "/login/");
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            String next = String.format("%s%s", supersetDomain, path);
            next = String.format("%s%srandom=%s", next, next.contains("?") ? "&" : "?", now.getTime());
            url = StrUtils.getSupersetRedirectUrl((String)next);
        }
        JSONObject sessionInfoJo = new JSONObject();
        sessionInfoJo.put("supersetDomain", (Object)supersetDomain);
        sessionInfoJo.put("url", (Object)url);
        sessionInfoJo.put("path", (Object)path);
        sessionInfoJo.put("session", (Object)session);
        sessionInfoJo.put("topDomain", (Object)topDomain);
        sessionInfoJo.put("refresh", (Object)refreshCustomControl);
        String uniqueCode = String.format("%s_%s_%s", this.getView().getPageId(), requestId, path);
        HashMap<String, Object> customData = new HashMap<String, Object>();
        BaseResult tmpBaseResult = new BaseResult(BaseResult.SUCCESS, "success", "\u6210\u529f", (Object)sessionInfoJo);
        CustomBaseResult customBaseResult = new CustomBaseResult(tmpBaseResult, this.getView().getPageId(), CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        customData.put("data", customBaseResult.toJSONObject());
        customData.put("timestamp", now.getTime());
        customData.put("pageId", this.getView().getPageId());
        customData.put("uniqueCode", uniqueCode);
        customControl.setData(customData);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }
}

