/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.entity.model.gpe.SchemeConfig;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.gpe.AlgorithmEnum;
import kd.ai.ids.core.enumtype.gpe.FieldRoleEnum;
import kd.ai.ids.core.query.gpe.AttachmentFileInfo;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IGpeTaskExecuteService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.AlgoUtils;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.tool.AttachmentTools;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class BizTransSchemeExecuteTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(BizTransSchemeExecuteTask.class);
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String KEY_ALGO_KEY = "kd.ai.ids.plugin.form.gpe.BizTransSchemeListPlugin.executeScheme";

    public IGpeTaskExecuteService gpeTaskExecuteService() {
        return (IGpeTaskExecuteService)Services.get(IGpeTaskExecuteService.class);
    }

    private IIdsParameterService idsParameterService() {
        return (IIdsParameterService)Services.get(IIdsParameterService.class);
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        int progress = 0;
        long bizTransSchemeId = (Long)params.get("id");
        DynamicObject bizTransSchemeDo = BusinessDataServiceHelper.loadSingle((Object)bizTransSchemeId, (String)IdsFormIdEnum.IDS_GPE_BIZ_TRANS_SCHEME.getId());
        String desc = String.format("\u4e1a\u52a1\u5173\u8054\u65b9\u6848 - \u51c6\u5907\u6267\u884c...(%s)", bizTransSchemeDo.getString("name"));
        this.feedbackProgress(progress, desc, null);
        DynamicObject predictRecordDo = bizTransSchemeDo.getDynamicObject("predictrecord");
        long predictRecordId = (Long)predictRecordDo.getPkValue();
        predictRecordDo = BusinessDataServiceHelper.loadSingle((Object)predictRecordId, (String)IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId());
        DynamicObject schemeDo = predictRecordDo.getDynamicObject("scheme");
        List<PlainField> plainFieldList = this.loadPredictResultPlainFieldList((Long)schemeDo.getPkValue());
        progress = 25;
        desc = "\u6b63\u5728\u52a0\u8f7d\u9884\u6d4b\u7ed3\u679c...";
        this.feedbackProgress(progress, desc, null);
        String originCacheId = this.cacheOriginDataSet(predictRecordId, plainFieldList);
        progress = 50;
        desc = "\u6b63\u5728\u540c\u6b65\u6570\u636e...";
        this.feedbackProgress(progress, desc, null);
        this.gpeTaskExecuteService().executeBizTransSchemeTask(bizTransSchemeDo, originCacheId, plainFieldList, KEY_ALGO_KEY);
        progress = 99;
        desc = "\u6267\u884c\u6210\u529f";
        this.feedbackProgress(progress, desc, null);
        HashMap<String, Number> result = new HashMap<String, Number>();
        int errcode = BaseResult.SUCCESS;
        result.put("errcode", errcode);
        result.put("id", bizTransSchemeId);
        this.feedbackCustomdata(result);
    }

    private RowMeta assemblyRowMeta(List<PlainField> plainFieldList) {
        Field[] fieldArr = new Field[plainFieldList.size()];
        for (int i = 0; i < plainFieldList.size(); ++i) {
            PlainField plainField = plainFieldList.get(i);
            DataType dataType = AlgoUtils.getAlgoDataType((String)plainField.getFieldType());
            fieldArr[i] = new Field(plainField.getFieldKey(), dataType);
        }
        RowMeta rowMeta = new RowMeta(fieldArr);
        return rowMeta;
    }

    private List<PlainField> loadPredictResultPlainFieldList(long schemeId) {
        DynamicObject schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
        DynamicObject datasetDo = schemeDo.getDynamicObject("dataset");
        if (datasetDo != null) {
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        }
        String fconfigStr = schemeDo.getString("config_tag");
        SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigStr, SchemeConfig.class);
        String timefield = schemeConfig.getFtimefield();
        String algorithmStr = schemeDo.getString("algorithm");
        List targetFieldList = schemeConfig.getFtargetfield();
        ArrayList<String> allfieldList = new ArrayList<String>();
        allfieldList.add(timefield);
        allfieldList.addAll(targetFieldList);
        allfieldList.addAll(schemeConfig.getFpreobjfield());
        allfieldList.addAll(schemeConfig.getFdimfield());
        List algorithmList = StrUtils.splitStr2List((String)algorithmStr);
        ArrayList<PlainField> allPlainFieldList = new ArrayList<PlainField>();
        if (datasetDo != null) {
            FieldInfo fieldInfo;
            List tempAllPlainFieldList;
            List fieldInfoList;
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            String metadataStr = datasetDo.getString("metadata_tag");
            DataSourceMetadata metadata = null;
            if (StringUtils.isNotEmpty((CharSequence)metadataStr) && CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList())) && CollectionUtils.isNotEmpty((Collection)(tempAllPlainFieldList = (fieldInfo = (FieldInfo)fieldInfoList.get(0)).getPlainFieldList()))) {
                Map<String, PlainField> fieldKeyPlainFieldMap = tempAllPlainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldKey, a -> a, (k1, k2) -> k1));
                for (PlainField plainField : tempAllPlainFieldList) {
                    if (!allfieldList.contains(plainField.getFieldKey())) continue;
                    allPlainFieldList.add(plainField);
                }
                for (String targetfield : targetFieldList) {
                    PlainField targetPlainField = fieldKeyPlainFieldMap.get(targetfield);
                    for (String algorithm : algorithmList) {
                        PlainField plainField = new PlainField();
                        AlgorithmEnum algorithmEnum = AlgorithmEnum.fromKey((String)algorithm);
                        plainField.setFieldKey(String.format("%s_%s", targetfield, algorithm));
                        plainField.setDisplayName(String.format("%s_%s", targetPlainField.getDisplayName(), algorithmEnum.getName()));
                        plainField.setFieldRole(FieldRoleEnum.METRIC.getId());
                        plainField.setFieldType(targetPlainField.getFieldType());
                        allPlainFieldList.add(plainField);
                    }
                }
            }
        }
        return allPlainFieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cacheOriginDataSet(long predictRecordId, List<PlainField> plainFieldList) {
        String originCacheId = null;
        DynamicObject predictRecordDo = BusinessDataServiceHelper.loadSingle((Object)predictRecordId, (String)IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId());
        DynamicObject schemeDo = predictRecordDo.getDynamicObject("scheme");
        if (CollectionUtils.isNotEmpty(plainFieldList)) {
            schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
            DynamicObject datasetDo = schemeDo.getDynamicObject("dataset");
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            long attachmentId = (Long)predictRecordDo.getDynamicObject("attachmentid").getPkValue();
            IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
            AttachmentFileInfo datasetFileInfo = AttachmentTools.getAttachmentInfo(attachmentId, idsParameter.getCosmicProxyIp());
            boolean firstLineColName = true;
            String splitChar = datasetDo.getString("splitchar");
            long st1 = KDDateUtils.now().getTime();
            List lineList = null;
            if (datasetFileInfo != null) {
                InputStream inputStream = datasetFileInfo.getInputStream();
                try {
                    lineList = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.forName("utf-8"));
                }
                catch (Exception e) {
                    CommonUtil.getStackTrace((Exception)e);
                }
                finally {
                    CommonUtil.safeClose((InputStream)inputStream);
                }
            }
            if (lineList == null) {
                return "";
            }
            long st2 = KDDateUtils.now().getTime();
            log.info("st2 - st1 : {}", (Object)(st2 - st1));
            if (firstLineColName) {
                String firstLine = (String)lineList.get(0);
                String[] colNameArr = firstLine.split(splitChar);
                ArrayList<PlainField> newPlainFieldList = new ArrayList<PlainField>();
                Map<String, PlainField> map = plainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldKey, a -> a, (k1, k2) -> k1));
                for (String colName : colNameArr) {
                    PlainField plainField = map.get(colName);
                    if (plainField == null) continue;
                    newPlainFieldList.add(plainField);
                }
                plainFieldList = newPlainFieldList;
                lineList = lineList.subList(1, lineList.size());
            }
            RowMeta rowMeta = this.assemblyRowMeta(plainFieldList);
            long st3 = KDDateUtils.now().getTime();
            log.info("st3 - st2 : {}", (Object)(st3 - st2));
            Iterator lineIterator = lineList.stream().map(s -> s.split(splitChar)).map(arr -> Arrays.stream(arr).map(String::new).toArray()).iterator();
            long st4 = KDDateUtils.now().getTime();
            log.info("st4 - st3 : {}", (Object)(st4 - st3));
            Algo algo = Algo.create((String)KEY_ALGO_KEY);
            DataSet originDataSet = algo.createDataSet(lineIterator, rowMeta);
            CacheHint hint = new CacheHint();
            hint.setTimeout(3600000L);
            CachedDataSet cachedOriginDataSet = originDataSet.cache(hint);
            originCacheId = cachedOriginDataSet.getCacheId();
            long st5 = KDDateUtils.now().getTime();
            log.info("st5 - st4 : {}", (Object)(st5 - st4));
        }
        return originCacheId;
    }
}

