/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.entity.model.BizObjField;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.entity.model.gpe.SchemeConfig;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.gpe.AlgorithmEnum;
import kd.ai.ids.core.enumtype.gpe.FieldRoleEnum;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BizTransSchemeFormPlugin
extends BaseFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_BTN_SAVESCHEME = "savescheme";
    private static final String KEY_ADVCONAP_QUEUE = "advconapqueue";
    private static final String KEY_FLEX_RECEIVENOTICE = "flexreceivenotice";
    private static final String KEY_INSERT_FIELD_BTN = "insertfieldbtn";
    private static final String CACHE_KEY_AUTO_SET_SCHEME = "autoSetScheme";

    private boolean isAutoSetScheme() {
        String s = this.getCache().get(CACHE_KEY_AUTO_SET_SCHEME);
        return Boolean.parseBoolean(s);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_INSERT_FIELD_BTN});
        BasedataEdit bEdit = (BasedataEdit)this.getView().getControl("predictrecord");
        bEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        super.click(evt);
        if (evtKey.equals(KEY_INSERT_FIELD_BTN)) {
            String filterField = (String)this.getModel().getValue("filterfield");
            String filterCondition = (String)this.getModel().getValue("filtercondition");
            filterCondition = StringUtils.isEmpty((CharSequence)filterCondition) ? filterField : String.format("%s %s", filterCondition, filterField);
            this.getModel().setValue("filtercondition", (Object)filterCondition);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"bizobj") || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"predictrecord")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"predictrecord")) {
                this.getCache().put(CACHE_KEY_AUTO_SET_SCHEME, "true");
                DynamicObject predictRecordDo = (DynamicObject)changeData[0].getNewValue();
                if (predictRecordDo != null) {
                    DynamicObject schemeDo = predictRecordDo.getDynamicObject("scheme");
                    this.getModel().setValue("scheme", (Object)schemeDo);
                    this.getModel().setValue("predictrecord", (Object)predictRecordDo);
                    this.getCache().put(CACHE_KEY_AUTO_SET_SCHEME, "false");
                }
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            this.initMappingFieldComboEdit(true);
            this.initFilterFieldComboEdit();
            this.getView().hideLoading();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"scheme")) {
            if (!this.isAutoSetScheme()) {
                this.getModel().setValue("predictrecord", null);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"bizobjfield")) {
            int rowIndex = changeData[0].getRowIndex();
            String oldValue = changeData[0].getOldValue() != null ? changeData[0].getOldValue().toString() : null;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_mapping_entry");
            EntryData entryData = entryGrid.getEntryData();
            DynamicObject[] dataEntitys = entryData.getDataEntitys();
            ArrayList<String> bizobjfieldList = new ArrayList<String>();
            if (dataEntitys != null && dataEntitys.length > 0) {
                long newCount;
                for (DynamicObject dynamicObject : dataEntitys) {
                    String bizobjfield = dynamicObject.getString("bizobjfield");
                    if (!StringUtils.isNotEmpty((CharSequence)bizobjfield)) continue;
                    bizobjfieldList.add(bizobjfield);
                }
                long oldCount = bizobjfieldList.size();
                if (oldCount > (newCount = bizobjfieldList.stream().distinct().count())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d", (String)"BizAssociateSchemeFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]));
                    this.getModel().setValue("bizobjfield", (Object)oldValue, rowIndex);
                    return;
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"receivenotice")) {
            boolean receiveNotice = Boolean.parseBoolean(changeData[0].getNewValue().toString());
            this.setReceiveNoticeVisible(receiveNotice);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Donothing donothing;
        String operateKey;
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing && StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_SAVESCHEME, (CharSequence)(operateKey = (donothing = (Donothing)source).getOperateKey()))) {
            DynamicObject dynamicObject;
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (pkValue != null && Long.parseLong(pkValue.toString()) > 0L && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)IdsFormIdEnum.IDS_GPE_BIZ_TRANS_SCHEME.getId())).getInt("status") == EnableEnum.AVAIL.getKey()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7f16\u8f91\u5df2\u542f\u7528\u7684\u65b9\u6848", (String)"BizAssociateSchemeFormPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            boolean receiveNotice = (Boolean)this.getModel().getValue("receivenotice");
            String eventNumber = (String)this.getModel().getValue("eventnumber");
            if (receiveNotice && StringUtils.isEmpty((CharSequence)eventNumber)) {
                this.getView().showTipNotification("\u542f\u7528\u4e8b\u4ef6\u901a\u77e5\u65f6\uff0c\u4e8b\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_mapping_entry");
            EntryData entryData = entryGrid.getEntryData();
            DynamicObject[] dataEntitys = entryData.getDataEntitys();
            ArrayList<String> quotefieldList = new ArrayList<String>();
            if (dataEntitys != null && dataEntitys.length > 0) {
                for (DynamicObject dynamicObject2 : dataEntitys) {
                    String quotefield = dynamicObject2.getString("quotefield");
                    if (!StringUtils.isNotEmpty((CharSequence)quotefield)) continue;
                    quotefieldList.add(quotefield);
                }
            }
            if (quotefieldList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u5f15\u7528\u6570\u636e\u5b57\u6bb5", (String)"BizAssociateSchemeFormPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            String customparams = (String)this.getModel().getValue("customparams");
            if (StringUtils.isNotEmpty((CharSequence)customparams)) {
                Object obj = null;
                try {
                    obj = JSON.parse((String)customparams);
                }
                catch (Exception e) {
                    this.log.info(String.format("%s\u4e0d\u662fJSON\u5b57\u7b26\u4e32", customparams));
                }
                if (obj == null || !(obj instanceof JSONObject)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u5fc5\u987b\u4e3aJSON\u5b57\u7b26\u4e32", (String)"BizAssociateSchemeFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.getView().invokeOperation("save");
        }
    }

    private List<PlainField> loadPlainFieldList(long schemeId) {
        DynamicObject schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
        DynamicObject datasetDo = schemeDo.getDynamicObject("dataset");
        datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        String fconfigStr = schemeDo.getString("config_tag");
        SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigStr, SchemeConfig.class);
        String timefield = schemeConfig.getFtimefield();
        String algorithmStr = schemeDo.getString("algorithm");
        List targetFieldList = schemeConfig.getFtargetfield();
        ArrayList<String> allfieldList = new ArrayList<String>();
        allfieldList.add(timefield);
        allfieldList.addAll(targetFieldList);
        allfieldList.addAll(schemeConfig.getFpreobjfield());
        allfieldList.addAll(schemeConfig.getFdimfield());
        List algorithmList = StrUtils.splitStr2List((String)algorithmStr);
        ArrayList<PlainField> allPlainFieldList = new ArrayList<PlainField>();
        if (datasetDo != null) {
            FieldInfo fieldInfo;
            List tempAllPlainFieldList;
            List fieldInfoList;
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            String metadataStr = datasetDo.getString("metadata_tag");
            DataSourceMetadata metadata = null;
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)metadataStr) && CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList())) && CollectionUtils.isNotEmpty((Collection)(tempAllPlainFieldList = (fieldInfo = (FieldInfo)fieldInfoList.get(0)).getPlainFieldList()))) {
                Map<String, PlainField> fieldKeyPlainFieldMap = tempAllPlainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldKey, a -> a, (k1, k2) -> k1));
                for (PlainField plainField : tempAllPlainFieldList) {
                    if (!allfieldList.contains(plainField.getFieldKey())) continue;
                    allPlainFieldList.add(plainField);
                }
                for (String targetfield : targetFieldList) {
                    PlainField targetPlainField = fieldKeyPlainFieldMap.get(targetfield);
                    for (String algorithm : algorithmList) {
                        PlainField plainField = new PlainField();
                        AlgorithmEnum algorithmEnum = AlgorithmEnum.fromKey((String)algorithm);
                        plainField.setFieldKey(String.format("%s_%s", targetfield, algorithm));
                        plainField.setDisplayName(String.format("%s_%s", targetPlainField.getDisplayName(), algorithmEnum.getName()));
                        plainField.setFieldRole(FieldRoleEnum.METRIC.getId());
                        plainField.setFieldType(targetPlainField.getFieldType());
                        allPlainFieldList.add(plainField);
                    }
                }
            }
        }
        return allPlainFieldList;
    }

    private void initMappingFieldComboEdit(boolean deleteEntryData) {
        DynamicObject predictRecordDo = (DynamicObject)this.getModel().getValue("predictrecord");
        DynamicObject bizobjDo = (DynamicObject)this.getModel().getValue("bizobj");
        if (predictRecordDo == null || bizobjDo == null) {
            return;
        }
        DynamicObject schemeDo = predictRecordDo.getDynamicObject("scheme");
        String entityNumber = bizobjDo.getString("number");
        List<PlainField> allPlainFieldList = this.loadPlainFieldList((Long)schemeDo.getPkValue());
        if (CollectionUtils.isNotEmpty(allPlainFieldList)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_mapping_entry");
            List controls = entryGrid.getControls();
            List<BizObjField> bizObjFieldList = this.getBizObjAllFieldList(entityNumber);
            for (Control control : controls) {
                int i;
                if (!(control instanceof ComboEdit)) continue;
                ComboEdit comboEdit = (ComboEdit)control;
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
                if (comboEdit.getKey().equals("quotefield")) {
                    for (i = 0; i < allPlainFieldList.size(); ++i) {
                        PlainField plainField = allPlainFieldList.get(i);
                        String id = plainField.getFieldKey();
                        String quoteFieldName = plainField.getDisplayName();
                        LocaleString comboItemText = new LocaleString(quoteFieldName);
                        ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(id));
                        comboItemList.add(comboItem);
                    }
                } else if (comboEdit.getKey().equals("bizobjfield")) {
                    for (i = 0; i < bizObjFieldList.size(); ++i) {
                        BizObjField bizObjField = bizObjFieldList.get(i);
                        int fieldType = bizObjField.getFieldType();
                        String fieldName = bizObjField.getFieldName();
                        String fieldCaption = bizObjField.getFieldCaption();
                        if (!AppConstants.INT_LIST.contains(fieldType) && !AppConstants.LONG_LIST.contains(fieldType) && !AppConstants.FLOAT_LIST.contains(fieldType) && !AppConstants.CHAR_LIST.contains(fieldType) && !AppConstants.DATE_LIST.contains(fieldType) && !AppConstants.DATETIME_LIST.contains(fieldType)) continue;
                        LocaleString comboItemText = new LocaleString(fieldCaption);
                        ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(fieldName));
                        comboItemList.add(comboItem);
                        comboEdit.setEnable("s", false, i);
                    }
                }
                comboEdit.setComboItems(comboItemList);
            }
            if (deleteEntryData) {
                this.getModel().deleteEntryData("field_mapping_entry");
                int rowCount = bizObjFieldList.size();
                int[] rowIndex = this.getModel().batchCreateNewEntryRow("field_mapping_entry", rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    BizObjField bizObjField = bizObjFieldList.get(i);
                    this.getModel().setValue("bizobjfield", (Object)bizObjField.getFieldName(), rowIndex[i]);
                }
            }
        }
    }

    private void initFilterFieldComboEdit() {
        List<PlainField> plainFieldList;
        DynamicObject schemeDo = (DynamicObject)this.getModel().getValue("scheme");
        if (schemeDo != null && (plainFieldList = this.loadPlainFieldList((Long)schemeDo.getPkValue())) != null && plainFieldList.size() > 0) {
            ComboEdit filterFieldComboEdit = (ComboEdit)this.getControl("filterfield");
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(plainFieldList.size());
            for (PlainField plainField : plainFieldList) {
                String id = plainField.getFieldKey();
                String fieldName = plainField.getDisplayName();
                LocaleString comboItemText = new LocaleString(fieldName);
                ComboItem comboItem = new ComboItem(comboItemText, id);
                comboItemList.add(comboItem);
            }
            filterFieldComboEdit.setComboItems(comboItemList);
        }
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        Object pkId = billShowParameter.getPkId();
        if (pkId != null) {
            String entityId = billShowParameter.getFormId();
            DynamicObject schemeDo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityId);
            String bizobj = schemeDo.getDynamicObject("bizobj").getString("number");
            this.checkIfNewField(bizobj, schemeDo);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        RequestContext rc = RequestContext.get();
        BillView billView = (BillView)e.getSource();
        BillShowParameter billShowParameter = (BillShowParameter)billView.getFormShowParameter();
        Object pkId = billShowParameter.getPkId();
        String entityId = billShowParameter.getFormId();
        boolean receiveNotice = true;
        this.setQueueConfigVisible(rc);
        if (pkId != null) {
            DynamicObject schemeDo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityId);
            receiveNotice = schemeDo.getBoolean("receivenotice");
            this.initMappingFieldComboEdit(false);
            this.initFilterFieldComboEdit();
        }
        this.setReceiveNoticeVisible(receiveNotice);
    }

    private void checkIfNewField(String bizobj, DynamicObject schemeDo) {
        List<BizObjField> bizObjFieldList = this.getBizObjAllFieldList(bizobj);
        DynamicObjectCollection fieldMappingEntryDoc = schemeDo.getDynamicObjectCollection("field_mapping_entry");
        ArrayList<String> oldFieldList = new ArrayList<String>();
        for (DynamicObject fieldMappingEntryDo : fieldMappingEntryDoc) {
            oldFieldList.add(fieldMappingEntryDo.getString("bizobjfield"));
        }
        boolean ifNewField = false;
        if (bizObjFieldList != null && bizObjFieldList.size() > 0) {
            int oldSeq = oldFieldList.size();
            for (BizObjField bizObjField : bizObjFieldList) {
                String fieldName = bizObjField.getFieldName();
                if (oldFieldList.contains(fieldName)) continue;
                DynamicObject fieldMappingDo = fieldMappingEntryDoc.addNew();
                fieldMappingDo.set("seq", (Object)(++oldSeq));
                fieldMappingDo.set("bizobjfield", (Object)fieldName);
                ifNewField = true;
            }
        }
        if (ifNewField) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeDo});
        }
    }

    private List<BizObjField> getBizObjAllFieldList(String bizobj) {
        ArrayList<BizObjField> bizObjFieldList = new ArrayList<BizObjField>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizobj);
        if (mainEntityType != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getAlias())) {
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entry : allEntities.entrySet()) {
                Map fieldMap;
                EntityType entityType = (EntityType)entry.getValue();
                String entityName = entityType.getName();
                ISimpleProperty primaryKey = entityType.getPrimaryKey();
                if (primaryKey != null) {
                    BizObjField bizObjPkField = new BizObjField();
                    bizObjPkField.setEntryEntity(entityName);
                    bizObjPkField.setFieldType(Integer.valueOf(primaryKey.getDbType()));
                    String pkFieldName = primaryKey.getName();
                    String pkFieldCaption = "ID";
                    if (!(entityType instanceof BillEntityType)) {
                        pkFieldName = String.format("%s.%s", entityName, pkFieldName);
                        pkFieldCaption = String.format("%s.%s", entityType.getDisplayName().getLocaleValue(), pkFieldCaption);
                    }
                    bizObjPkField.setFieldName(pkFieldName);
                    bizObjPkField.setFieldCaption(pkFieldCaption);
                    bizObjFieldList.add(bizObjPkField);
                }
                if ((fieldMap = entityType.getFields()) == null || fieldMap.isEmpty()) continue;
                Iterator iterator = fieldMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    String fieldName = (String)iterator.next().getKey();
                    IDataEntityProperty dp = (IDataEntityProperty)fieldMap.get(fieldName);
                    if (StringUtils.isEmpty((CharSequence)dp.getAlias())) continue;
                    String fieldCaption = dp.getDisplayName().getLocaleValue();
                    if (!(entityType instanceof BillEntityType)) {
                        fieldName = String.format("%s.%s", entityName, fieldName);
                        fieldCaption = String.format("%s.%s", entityType.getDisplayName().getLocaleValue(), fieldCaption);
                    }
                    BizObjField bizObjField = new BizObjField();
                    bizObjField.setFieldName(fieldName);
                    bizObjField.setFieldCaption(fieldCaption);
                    bizObjField.setEntryEntity(entityName);
                    if (dp instanceof FieldProp) {
                        FieldProp fieldProp = (FieldProp)dp;
                        bizObjField.setFieldType(Integer.valueOf(fieldProp.getDbType()));
                    } else {
                        if (!(dp instanceof BasedataProp)) continue;
                        BasedataProp basedataProp = (BasedataProp)dp;
                        bizObjField.setFieldType(Integer.valueOf(basedataProp.getDbType()));
                    }
                    bizObjFieldList.add(bizObjField);
                }
            }
        }
        return bizObjFieldList;
    }

    private void setQueueConfigVisible(RequestContext rc) {
        IdsParameter idsParameter = ((IIdsParameterService)Services.get(IIdsParameterService.class)).getIdsParameter(Long.valueOf(rc.getOrgId()));
        if (idsParameter.getMqConfig().booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ADVCONAP_QUEUE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ADVCONAP_QUEUE});
        }
    }

    private void setReceiveNoticeVisible(boolean receiveNotice) {
        this.getView().setVisible(Boolean.valueOf(receiveNotice), new String[]{KEY_FLEX_RECEIVENOTICE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("number", (Object)("SCHEME-" + new Date().getTime()));
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject schemeDo;
        IDataEntityProperty property = evt.getProperty();
        if (property.getName().equalsIgnoreCase("predictrecord") && (schemeDo = (DynamicObject)this.getModel().getValue("scheme")) != null) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("scheme", "=", schemeDo.getPkValue()));
            formShowParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }
}

