/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.job.IdsJobForm;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BizTransSchemeListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(BizTransSchemeListPlugin.class);
    private static final String KEY_BTN_ENABLE = "enable";
    private static final String KEY_BTN_DISABLE = "disable";
    private static final String KEY_BTN_EXECUTE = "execute";
    private static final String KEY_BTN_REFRESH = "refresh";
    private static final String KEY_TOOLBARAP = "toolbarap";
    private static final String TASK_CLOSE_BACK = "taskcloseback";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
    }

    public void createNewData(BizDataEventArgs e) {
        RequestContext rc = RequestContext.get();
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        RequestContext rc = RequestContext.get();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            ListSelectedRowCollection listSelectedData = donothing.getListSelectedData();
            if (listSelectedData == null || listSelectedData.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            Object[] pkArray = listSelectedData.getPrimaryKeyValues();
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_GPE_BIZ_TRANS_SCHEME.getId());
            DynamicObject[] selectedDynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)newDynamicObject.getDynamicObjectType());
            if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_ENABLE, (CharSequence)operateKey)) {
                for (DynamicObject dynamicObject : selectedDynamicObjectArray) {
                    dynamicObject.set("status", (Object)EnableEnum.AVAIL.getKey());
                }
                SaveServiceHelper.save((DynamicObject[])selectedDynamicObjectArray);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"Common_Operation_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_DISABLE, (CharSequence)operateKey)) {
                for (DynamicObject dynamicObject : selectedDynamicObjectArray) {
                    dynamicObject.set("status", (Object)EnableEnum.INVALID.getKey());
                }
                SaveServiceHelper.save((DynamicObject[])selectedDynamicObjectArray);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"Common_Operation_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_EXECUTE, (CharSequence)operateKey)) {
                int maxCount = 1;
                int selectedDataSize = listSelectedData.size();
                if (selectedDataSize > maxCount) {
                    this.getView().showTipNotification(String.format("\u4e00\u6b21\u6700\u591a\u6267\u884c%s\u4e2a\u4e1a\u52a1\u5173\u8054\u65b9\u6848\uff0c\u5f53\u524d\u9009\u4e2d\u6570\u91cf\uff1a%s\u3002", maxCount, selectedDataSize));
                    return;
                }
                for (DynamicObject dynamicObject : selectedDynamicObjectArray) {
                    int status = dynamicObject.getInt("status");
                    if (status == EnableEnum.AVAIL.getKey()) continue;
                    this.getView().showTipNotification("\u53ea\u5141\u8bb8\u6267\u884c\u5df2\u542f\u7528\u7684\u65b9\u6848\u3002");
                    return;
                }
                for (DynamicObject bizTransSchemeDo : selectedDynamicObjectArray) {
                    this.asyncExecuteTask(bizTransSchemeDo);
                }
            }
            this.getView().invokeOperation(KEY_BTN_REFRESH);
        }
    }

    private void asyncExecuteTask(DynamicObject bizTransSchemeDo) {
        ThreadUtils.sleep((long)100L);
        RequestContext rc = RequestContext.get();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("ids");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(String.format("\u300c\u4e1a\u52a1\u5173\u8054\u65b9\u6848\u300d - %s", bizTransSchemeDo.getString("name")));
        jobInfo.setId(ID.genStringId());
        jobInfo.setRunByLang(rc.getLang());
        jobInfo.setRunByOrgId(rc.getOrgId());
        jobInfo.setRunByUserId(rc.getCurrUserId());
        jobInfo.setRunConcurrently(true);
        jobInfo.setTaskClassname("kd.ai.ids.plugin.form.gpe.BizTransSchemeExecuteTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", bizTransSchemeDo.getPkValue());
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TASK_CLOSE_BACK);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption("\u4e1a\u52a1\u5173\u8054\u65b9\u6848\u6267\u884c\u8fdb\u5ea6");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setTimeout(86400);
        jobFormInfo.setClickClassName("kd.ai.ids.plugin.form.gpe.BizTransSchemeExecuteClickTask");
        IdsJobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TASK_CLOSE_BACK)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        JSONObject dataJo;
        int errcode;
        String data;
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotEmpty((CharSequence)(data = taskInfo.getData())) && (errcode = (dataJo = JSONObject.parseObject((String)data)).getIntValue("errcode")) == BaseResult.SUCCESS) {
            long id = dataJo.getLong("id");
            this.getView().showSuccessNotification("\u6267\u884c\u6210\u529f");
        }
    }
}

