/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.Entity;
import kd.ai.ids.core.entity.model.EntityCatalog;
import kd.ai.ids.core.entity.model.Field;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.XtypeEnum;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CreateDatasetFormPlugin
extends BaseFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
BeforeBindDataListener {
    private static final String KEY_COMBO_DATASOURCE = "datasource";
    private static final String KEY_BAR_PREVIEW = "barpreview";
    private static final String KEY_BAR_SAVE = "barsave";
    private static final String KEY_FLEX_EMPTY = "flexempty";
    private static final String KEY_FLEX_ENTITY_STRUCTURE = "flexentitystructure";
    private static final String KEY_LABELAP_ENTITY_BASE_INFO = "labelapentitybaseinfo";
    private static final String KEY_LABELAP_TABLE_BASE_INFO = "labelaptablebaseinfo";
    private static final String KEY_LABELAP_FIELD_COUNT = "labelapfieldcount";
    private static final String KEY_TREEVIEWAP_MODEL = "treeviewapmodel";
    private static final String CACHE_KEY_CURR_ENTITY_KEY = "currEntityKey";
    private static final String CACHE_KEY_SELECTED_FIELD_LIST_PREFIX = "selectedFieldList_";
    private static final String CACHE_KEY_ALL_ENTITY_KEY_LIST = "allEntityKey";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_FIELD_NAME = "fieldname";
    private static final String KEY_FIELD_KEY = "fieldkey";
    private static final String KEY_FIELD_COMMENT = "fieldcomment";
    private static final String KEY_FLEX_PREVIEWWRAP = "flexpreviewwrap";
    private static final String KEY_FLEX_PREVIEW = "flexpreview";
    private static final String KEY_VECTORAP_CLOSE = "vectorapclose";
    private static final String KEY_LABELAP_COUNT = "labelapcount";

    public String getCurrEntityKey() {
        return this.getCache().get(CACHE_KEY_CURR_ENTITY_KEY);
    }

    public List<Field> getSelectedFieldList(String entityKey) {
        return this.getCache().getAsList(CACHE_KEY_SELECTED_FIELD_LIST_PREFIX + entityKey, Field.class);
    }

    public List<String> getAllEntityKeyList() {
        return this.getCache().getAsList(CACHE_KEY_ALL_ENTITY_KEY_LIST, String.class);
    }

    private void putEntityToCache(Map<String, String> data, Entity entity) {
        JSONObject o = (JSONObject)JSON.toJSON((Object)entity);
        o.remove((Object)"children");
        data.put("EntityCache_" + entity.getKey(), o.toJSONString());
    }

    private Entity getEntityFromCache(String entityKey) {
        String s = this.getCache().get("EntityCache_" + entityKey);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return (Entity)JSON.parseObject((String)s, Entity.class);
    }

    @Override
    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryGrid.addSelectRowsListener(new SelectRowsEventListener(){

            public void selectRowsChange(SelectRowsEvent evt) {
                super.selectRowsChange(evt);
                EntryGrid entryGrid = (EntryGrid)evt.getSource();
                int[] selectRows = entryGrid.getSelectRows();
                EntryData entryData = entryGrid.getEntryData();
                DynamicObject[] dataEntitys = entryData.getDataEntitys();
                String currEntityKey = CreateDatasetFormPlugin.this.getCurrEntityKey();
                ArrayList<Field> selectedFieldList = new ArrayList<Field>();
                if (selectRows != null && selectRows.length > 0) {
                    for (int rowIndex : selectRows) {
                        DynamicObject rowDo = dataEntitys[rowIndex];
                        String fieldName = rowDo.getString(CreateDatasetFormPlugin.KEY_FIELD_NAME);
                        String fieldKey = rowDo.getString(CreateDatasetFormPlugin.KEY_FIELD_KEY);
                        String fieldComment = rowDo.getString(CreateDatasetFormPlugin.KEY_FIELD_COMMENT);
                        Field field = new Field();
                        field.setFieldName(fieldKey);
                        field.setKey(fieldName);
                        field.setName(fieldComment);
                        selectedFieldList.add(field);
                    }
                }
                CreateDatasetFormPlugin.this.getCache().put(CreateDatasetFormPlugin.CACHE_KEY_SELECTED_FIELD_LIST_PREFIX + currEntityKey, selectedFieldList);
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEWAP_MODEL);
        tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{KEY_VECTORAP_CLOSE});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        RequestContext rc = RequestContext.get();
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)KEY_BAR_PREVIEW)) {
            this.previewData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)KEY_BAR_SAVE)) {
            this.getView().showTipNotification("save");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_DATASOURCE)) {
            DynamicObject newDo = (DynamicObject)changeData[0].getNewValue();
            String datasource = newDo != null ? newDo.getString("number") : "";
            this.loadDatasourceModelData(datasource);
        }
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "vectorapclose": {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEWWRAP});
                break;
            }
        }
    }

    private void previewData() {
        List<String> allEntityKeyList = this.getAllEntityKeyList();
        ArrayList<Field> allFieldList = new ArrayList<Field>();
        for (String entityKey : allEntityKeyList) {
            List<Field> selectedFieldList = this.getSelectedFieldList(entityKey);
            if (!CollectionUtils.isNotEmpty(selectedFieldList)) continue;
            allFieldList.addAll(selectedFieldList);
        }
        if (CollectionUtils.isEmpty(allFieldList)) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u8981\u9884\u89c8\u7684\u5b57\u6bb5");
            return;
        }
        List fieldKeyList = allFieldList.stream().map(Field::getFieldName).distinct().collect(Collectors.toList());
        String selectFields = StringUtils.join(fieldKeyList, (String)",");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.getDatasource(), (String)selectFields, null, null, (int)100);
        JSONArray dataJa = new JSONArray();
        int count = 0;
        if (doc != null && doc.size() > 0) {
            for (DynamicObject dynamicObject : doc) {
                JSONObject rowJo = new JSONObject();
                for (int i = 0; i < fieldKeyList.size(); ++i) {
                    String fieldKey = (String)fieldKeyList.get(i);
                    Field field = (Field)allFieldList.get(i);
                    rowJo.put(field.getKey(), dynamicObject.get(fieldKey));
                }
                dataJa.add((Object)rowJo);
            }
            count = doc.size();
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEWWRAP});
        this.setLabelText(KEY_LABELAP_COUNT, String.format("(%s\u6761)", count));
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("fields", JSONObject.toJSONString(allFieldList));
        customParams.put("data", JSONObject.toJSONString((Object)dataJa));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(IdsFormIdEnum.IDS_GPE_PREVIEW_DATA.getId());
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setTargetKey(KEY_FLEX_PREVIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getView().showForm(formShowParameter);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_EMPTY, KEY_FLEX_PREVIEWWRAP});
        this.getModel().setValue("number", (Object)"\u81ea\u52a8\u751f\u6210");
        String datasource = this.getDatasource();
        this.loadDatasourceModelData(datasource);
    }

    private String getDatasource() {
        DynamicObject datasourceDo = (DynamicObject)this.getModel().getValue(KEY_COMBO_DATASOURCE);
        String datasource = "";
        if (datasourceDo != null) {
            datasource = datasourceDo.getString("number");
        }
        return datasource;
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String entityKey = (String)treeNodeEvent.getNodeId();
        this.log.info("#####treeNodeClick entityKey : {}" + entityKey);
        Entity entity = this.getEntityFromCache(entityKey);
        if (entity != null) {
            this.log.info("##### entity:{}", (Object)JSONObject.toJSONString((Object)entity));
            this.initEntityFieldData(entity);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
    }

    private void loadDatasourceModelData(String datasource) {
        if (!StringUtils.isNotEmpty((CharSequence)datasource)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ENTITY_STRUCTURE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_EMPTY});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_EMPTY});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_ENTITY_STRUCTURE});
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)datasource);
        EntityCatalog entityEntityCatalog = new EntityCatalog();
        entityEntityCatalog.setId(datasource);
        entityEntityCatalog.setText(mainEntityType.getName());
        entityEntityCatalog.setXtype(XtypeEnum.ENTITY.getKey());
        entityEntityCatalog.setParentid(mainEntityType.getAppId());
        Entity entity = this.tenantModelService().getEntityStructByMainEntityType(entityEntityCatalog, mainEntityType);
        String bizAppNumber = mainEntityType.getBizAppNumber();
        QFilter filter = new QFilter("number", "=", (Object)bizAppNumber);
        DynamicObject bizAppDo = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,masterid,type,parentid,inheritpath,bizcloud,deploystatus,visible", (QFilter[])filter.toArray());
        String bizAppId = bizAppDo.getString("id");
        String bizCloudId = bizAppDo.getString("bizcloud");
        DynamicObject bizCloudDo = BizCloudServiceHelp.getBizCloudByID((String)bizCloudId);
        EntityCatalog allEntityCatalog = new EntityCatalog();
        allEntityCatalog.setId("0");
        allEntityCatalog.setParentid("0");
        allEntityCatalog.setText("\u5168\u90e8");
        allEntityCatalog.setXtype(XtypeEnum.CATALOG.getKey());
        allEntityCatalog.setEntity(null);
        allEntityCatalog.setChildren(null);
        ArrayList<EntityCatalog> bizCloudEntityCatalogList = new ArrayList<EntityCatalog>();
        EntityCatalog bizCloudCatalog = new EntityCatalog();
        bizCloudCatalog.setXtype(XtypeEnum.CATALOG.getKey());
        bizCloudCatalog.setId(bizCloudDo.getString("id"));
        bizCloudCatalog.setParentid("0");
        bizCloudCatalog.setText(bizCloudDo.getString("name"));
        bizCloudCatalog.setEntity(null);
        ArrayList<EntityCatalog> bizAppEntityCatalogList = new ArrayList<EntityCatalog>();
        EntityCatalog bizAppEntityCatalog = new EntityCatalog();
        bizAppEntityCatalog.setId(bizAppId);
        bizAppEntityCatalog.setParentid(bizCloudId);
        bizAppEntityCatalog.setText(bizAppDo.getString("name"));
        bizAppEntityCatalog.setXtype(XtypeEnum.CATALOG.getKey());
        bizAppEntityCatalog.setEntity(null);
        ArrayList<EntityCatalog> bizObjectList = new ArrayList<EntityCatalog>();
        EntityCatalog bizObjectEntityCatalog = new EntityCatalog();
        bizObjectEntityCatalog.setId(datasource);
        bizObjectEntityCatalog.setParentid(bizAppId);
        bizObjectEntityCatalog.setText(mainEntityType.getDisplayName().getLocaleValue());
        bizObjectEntityCatalog.setXtype(XtypeEnum.ENTITY.getKey());
        bizObjectEntityCatalog.setEntity(entity);
        bizObjectEntityCatalog.setChildren(null);
        bizObjectList.add(bizObjectEntityCatalog);
        if (!CollectionUtils.isEmpty(bizObjectList)) {
            bizAppEntityCatalog.setChildren(bizObjectList);
            bizAppEntityCatalogList.add(bizAppEntityCatalog);
        }
        if (!CollectionUtils.isEmpty(bizAppEntityCatalogList)) {
            bizCloudCatalog.setChildren(bizAppEntityCatalogList);
        }
        if (!CollectionUtils.isEmpty((Collection)bizCloudCatalog.getChildren())) {
            bizCloudEntityCatalogList.add(bizCloudCatalog);
        }
        allEntityCatalog.setChildren(bizCloudEntityCatalogList);
        this.loadModelData(allEntityCatalog);
    }

    private void loadModelData(EntityCatalog entityCatalog) {
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEWAP_MODEL);
        tv.deleteAllNodes();
        String rootId = entityCatalog.getId();
        TreeNode rootNode = new TreeNode(null, rootId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ApplicationConfigPlugin_11", (String)"ai-ids-plugin", (Object[])new Object[0]), (Object)Boolean.TRUE);
        rootNode.setIsOpened(true);
        Entity initEntity = null;
        TreeNode initTreeNode = null;
        List bizCloudList = entityCatalog.getChildren();
        HashMap<String, String> cache = new HashMap<String, String>();
        ArrayList<String> allEntityKeyList = new ArrayList<String>();
        for (EntityCatalog bizCloudEntityCatalog : bizCloudList) {
            TreeNode tn1 = new TreeNode(bizCloudEntityCatalog.getParentid(), bizCloudEntityCatalog.getKey(), bizCloudEntityCatalog.getText(), (Object)Boolean.TRUE);
            tn1.setIcon("folder");
            tn1.setIsOpened(true);
            List appList = bizCloudEntityCatalog.getChildren();
            for (EntityCatalog appEntityCatalog : appList) {
                TreeNode tn2 = new TreeNode(appEntityCatalog.getParentid(), appEntityCatalog.getKey(), appEntityCatalog.getText(), (Object)Boolean.TRUE);
                tn2.setIsOpened(true);
                List entityList = appEntityCatalog.getChildren();
                for (EntityCatalog entityEntityCatalog : entityList) {
                    Entity entity = entityEntityCatalog.getEntity();
                    if (entity == null) continue;
                    String entityKey = entity.getKey();
                    allEntityKeyList.add(entityKey);
                    TreeNode tn3 = new TreeNode(entityEntityCatalog.getParentid(), entityKey, entityEntityCatalog.getText(), (Object)Boolean.TRUE);
                    tn2.addChild(tn3);
                    tn3.setIsOpened(true);
                    if (initEntity == null) {
                        initEntity = entity;
                        initTreeNode = tn3;
                        this.initEntityFieldData(initEntity);
                    }
                    entity.setEntityId(entity.getId());
                    this.putEntityToCache(cache, entity);
                    List entityChildrenList = entity.getChildren();
                    if (CollectionUtils.isEmpty((Collection)entityChildrenList)) continue;
                    for (Entity childrenEntity : entityChildrenList) {
                        allEntityKeyList.add(childrenEntity.getKey());
                        childrenEntity.setEntityId(entity.getId());
                        this.putEntityToCache(cache, childrenEntity);
                        List subEntityChildrenList = childrenEntity.getChildren();
                        boolean isParent = !CollectionUtils.isEmpty((Collection)childrenEntity.getChildren());
                        TreeNode tn4 = new TreeNode(entity.getKey(), childrenEntity.getKey(), childrenEntity.getName(), isParent);
                        tn3.addChild(tn4);
                        tn4.setIsOpened(true);
                        if (CollectionUtils.isEmpty((Collection)subEntityChildrenList)) continue;
                        for (Entity subChildrenEntity : subEntityChildrenList) {
                            allEntityKeyList.add(subChildrenEntity.getKey());
                            subChildrenEntity.setEntityId(entity.getId());
                            this.putEntityToCache(cache, subChildrenEntity);
                            List subSubEntityChildrenList = subChildrenEntity.getChildren();
                            boolean subEntityIsParent = !CollectionUtils.isEmpty((Collection)subSubEntityChildrenList);
                            TreeNode tn5 = new TreeNode(entity.getKey(), subChildrenEntity.getKey(), subChildrenEntity.getName(), subEntityIsParent);
                            tn4.addChild(tn5);
                            tn5.setIsOpened(true);
                        }
                    }
                }
                tn1.addChild(tn2);
            }
            rootNode.addChild(tn1);
        }
        this.getCache().put(CACHE_KEY_ALL_ENTITY_KEY_LIST, allEntityKeyList);
        tv.addNode(rootNode);
        tv.setRootVisible(false);
        if (initTreeNode != null) {
            tv.focusNode(initTreeNode);
        }
        this.getCache().put(cache);
    }

    private void initEntityFieldData(Entity entity) {
        if (entity == null) {
            return;
        }
        Label entityBaseInfoLabel = (Label)this.getView().getControl(KEY_LABELAP_ENTITY_BASE_INFO);
        entityBaseInfoLabel.setText(String.format("%s\uff1a%s(%s)", ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"ApplicationConfigPlugin_12", (String)"ai-ids-plugin", (Object[])new Object[0]), entity.getName(), entity.getId()));
        Label tableBaseInfoLabel = (Label)this.getView().getControl(KEY_LABELAP_TABLE_BASE_INFO);
        tableBaseInfoLabel.setText(String.format("%s\uff1a%s", ResManager.loadKDString((String)"\u8868\u540d", (String)"ApplicationConfigPlugin_13", (String)"ai-ids-plugin", (Object[])new Object[0]), entity.getTableName()));
        List fieldList = CommonUtil.emptyIfNull((List)entity.getFields());
        this.setLabelText(KEY_LABELAP_FIELD_COUNT, String.format("\u5b57\u6bb5\u6570\u91cf\uff1a%s", fieldList.size()));
        String currEntityKey = entity.getKey();
        this.getCache().put(CACHE_KEY_CURR_ENTITY_KEY, currEntityKey);
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int size = fieldList.size();
        IDataModel dataModel = this.getModel();
        dataModel.batchCreateNewEntryRow(KEY_ENTRYENTITY, size);
        List<Field> selectedFieldList = this.getSelectedFieldList(currEntityKey);
        List<Object> selectedFieldKeyList = new ArrayList();
        if (CollectionUtils.isNotEmpty(selectedFieldList)) {
            selectedFieldKeyList = selectedFieldList.stream().map(Field::getKey).collect(Collectors.toList());
        }
        int[] selectRows = new int[selectedFieldKeyList.size()];
        int selectRowIndex = 0;
        for (int i = 0; i < fieldList.size(); ++i) {
            Field field = (Field)fieldList.get(i);
            dataModel.setValue(KEY_FIELD_NAME, (Object)field.getKey(), i);
            dataModel.setValue(KEY_FIELD_KEY, (Object)field.getFieldName(), i);
            dataModel.setValue(KEY_FIELD_COMMENT, (Object)field.getName(), i);
            if (!selectedFieldKeyList.contains(field.getKey())) continue;
            selectRows[selectRowIndex++] = i;
        }
        entryGrid.selectRows(selectRows, 0);
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ENTRYENTITY});
    }
}

