/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.gpe.DataSourceTypeEnum;
import kd.ai.ids.core.enumtype.gpe.FieldRoleEnum;
import kd.ai.ids.core.query.gpe.GpeRequestContext;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.AwsS3Utils;
import kd.ai.ids.core.utils.EntityUtils;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.job.IdsJobForm;
import kd.ai.ids.plugin.tool.AttachmentTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataSetFormPlugin
extends BaseFormPlugin
implements TabSelectListener {
    private static final String KEY_BARITEM_SYNC_DATA = "syncdata";
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String KEY_OP_SAVE_DS = "saveds";
    private static final String KEY_OP_SAVE_DS_WITHOUT_TIPS = "savedswithouttips";
    private static final String KEY_CSV_FIELD_ENTRYENTITY = "csvfieldentryentity";
    private static final String KEY_TAB = "tabap";
    private static final String KEY_TAB_PREVIEWDATA = "tabpreviewdata";
    private static final String KEY_TAB_DATASTATISTICS = "tabdatastatistics";
    private static final String FLEX_PREVIEW_CSV_DATA = "flexpreviewcsvdata";
    private static final String FLEX_PREVIEW_EMPTY = "flexpreviewempty";
    private static final String KEY_ENTRYENTITY_OVERVIEW = "overviewentryentity";
    private static final String KEY_ENTRYENTITY_CATEGORY = "categoryentryentity";
    private static final String KEY_ENTRYENTITY_NUM = "numentryentity";
    private static final String KEY_VAR_NAME = "varname";
    private static final String KEY_VAR_VALUE = "varvalue";
    private static final String KEY_VAR_UNIT = "varunit";
    private static final String KEY_CATEGORY_PREFIX = "c_";
    private static final String KEY_NUM_PREFIX = "n_";
    private static final String AI_GPE_CATE_STATISTICS = "ai_gpe_cate_statistics";
    private static final String AI_GPE_NUM_STATISTICS = "ai_gpe_num_statistics";
    private static final String LABELAP_FAIL_MSG = "labelapfailmsg";
    private static final String FLEX_DATA_STATISTICS = "flexdatastatistics";
    private static final String FLEX_CALCULATING = "flexcalculating";
    private static final String FLEX_FAIL = "flexfail";
    private static final String FLEX_EMPTY = "flexempty";
    private static final String KEY_LABELAP_REFRESH_TIME = "labelaprefreshtime";
    private static final Integer REFRESH_TIME = 1000;
    private static final Integer REFRESH_TIME_TOTAL = 3;
    private static final String BTN_RE_EXECUTE = "btn_re_execute";
    private static final String BTN_EXECUTE_STATISTIC = "btn_execute_statistic";
    private static final String KEY_ACTION_UPDATE_REFRESH_TIME = "updateRefreshTime";
    private static final String TASK_CLOSE_BACK = "taskcloseback";
    private static final String KEY_SET_FILTER = "setFilter";
    private static final String KEY_BTN_FILTER = "btnfilter";
    private static final String KEY_VECTORAP = "vectorap";

    private int getRefrshTime() {
        String s = this.getCache().get(KEY_LABELAP_REFRESH_TIME);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Integer.parseInt(s);
        }
        return 5;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_RE_EXECUTE, KEY_BTN_FILTER, BTN_EXECUTE_STATISTIC});
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tab = (Tab)this.getControl(KEY_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if (operationKey.equalsIgnoreCase("save") && args.getOperationResult().isSuccess()) {
            args.getOperationResult().setShowMessage(false);
        }
        Object source = args.getSource();
        RequestContext rc = RequestContext.get();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BARITEM_SYNC_DATA, (CharSequence)operateKey)) {
                DynamicObject dataSourceDo = (DynamicObject)this.getModel().getValue("datasource");
                dataSourceDo = BusinessDataServiceHelper.loadSingle((Object)dataSourceDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASOURCE.getId());
                this.cacheMetadata(dataSourceDo);
                String type = dataSourceDo.getString("type");
                int totalCount = 0;
                if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.BIZOBJ.getId())) {
                    IdsParameter idsParameter = ((IIdsParameterService)Services.get(IIdsParameterService.class)).getIdsParameter(Long.valueOf(rc.getOrgId()));
                    ORM orm = ORM.create();
                    String metadataStr = (String)this.getModel().getValue("metadata_tag");
                    if (StringUtils.isNotEmpty((CharSequence)metadataStr)) {
                        DataSourceMetadata metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class);
                        List fieldInfoList = metadata.getFieldInfoList();
                        for (FieldInfo fieldInfo : fieldInfoList) {
                            List plainFieldList = fieldInfo.getPlainFieldList();
                            List fieldIdList = plainFieldList.stream().map(PlainField::getFieldId).collect(Collectors.toList());
                            String selectFields = StringUtils.join(fieldIdList, (String)",");
                            String entityNumber = fieldInfo.getEntityNumber();
                            String filterJson = (String)this.getModel().getValue("filter_tag");
                            QFilter[] qFilters = null;
                            if (StringUtils.isNotEmpty((CharSequence)filterJson)) {
                                QFilter qFilter = EntityUtils.transFilterJson2QFilter((String)entityNumber, (String)filterJson);
                                qFilters = qFilter.toArray();
                            }
                            totalCount = orm.count(((Object)((Object)this)).getClass().getName(), entityNumber, selectFields, qFilters);
                        }
                    }
                    if (totalCount > idsParameter.getMaxRowCount()) {
                        this.getView().showTipNotification(String.format("\u8bb0\u5f55\u6570%s\u6761\uff0c\u8d85\u8fc7\u6700\u5927\u9650\u5236%s\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u540e\u518d\u540c\u6b65\u3002", totalCount, idsParameter.getMaxRowCount()));
                        return;
                    }
                }
                if (!this.isValidMetadata()) {
                    return;
                }
                long datasetId = (Long)this.getModel().getDataEntity(true).getPkValue();
                this.getView().invokeOperation(KEY_OP_SAVE_DS_WITHOUT_TIPS);
                if (datasetId == 0L) {
                    datasetId = (Long)this.getModel().getDataEntity(true).getPkValue();
                }
                this.asyncSyncDataTask(datasetId, false, totalCount);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)KEY_OP_SAVE_DS)) {
                this.saveDataset(true);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)KEY_OP_SAVE_DS_WITHOUT_TIPS)) {
                this.saveDataset(false);
            }
        }
    }

    private void saveDataset(boolean showMessage) {
        long pkValue = (Long)this.getModel().getDataEntity(true).getPkValue();
        if (pkValue != 0L) {
            ORM orm = ORM.create();
            QFilter qFilter = new QFilter("dataset", "=", (Object)pkValue).or("futuredataset", "=", (Object)pkValue);
            int count = orm.count(((Object)((Object)this)).getClass().getName(), IdsFormIdEnum.IDS_GPE_SCHEME.getId(), qFilter.toArray());
            if (count > 0) {
                this.getView().showTipNotification("\u201c\u9884\u6d4b\u6a21\u578b\u65b9\u6848\u201d\u7684\u5b57\u6bb5\u201c\u6570\u636e\u96c6\u201d\u6216\u201c\u672a\u6765\u6570\u636e\u96c6\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u4fee\u6539\u3002");
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_OP_SAVE_DS});
                return;
            }
        }
        DynamicObject dataSourceDo = (DynamicObject)this.getModel().getValue("datasource");
        dataSourceDo = BusinessDataServiceHelper.loadSingle((Object)dataSourceDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASOURCE.getId());
        if (pkValue == 0L) {
            this.getModel().setValue("status", (Object)BillStatusEnum.STAGING.getId());
        }
        this.cacheMetadata(dataSourceDo);
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if ((name == null || name.isEmpty() || StringUtils.isEmpty((CharSequence)name.getLocaleValue())) && dataSourceDo != null) {
            LocaleString localeName = new LocaleString(dataSourceDo.getString("name"));
            this.getModel().setValue("name", (Object)localeName);
        }
        if (!this.isValidMetadata()) {
            return;
        }
        this.getModel().setValue("enable", (Object)EnableEnum.AVAIL.getKey());
        this.getView().invokeOperation("save");
        if (showMessage) {
            this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f");
        }
        DynamicObject datasetDo = this.getModel().getDataEntity(true);
        Boolean isSyncData = (Boolean)this.getModel().getValue("issyncdata");
        if (!isSyncData.booleanValue()) {
            datasetDo.set("enable", (Object)EnableEnum.INVALID.getKey());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datasetDo});
        }
        this.loadPlainFieldList();
    }

    private void cacheMetadata(DynamicObject dataSourceDo) {
        DataSourceMetadata metadata = (DataSourceMetadata)JSONObject.parseObject((String)dataSourceDo.getString("metadata_tag"), DataSourceMetadata.class);
        List fieldInfoList = metadata.getFieldInfoList();
        FieldInfo fieldInfo = (FieldInfo)fieldInfoList.get(0);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_CSV_FIELD_ENTRYENTITY);
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        List plainFieldList = fieldInfo.getPlainFieldList();
        ArrayList<PlainField> newPlainFieldList = new ArrayList<PlainField>();
        if (dataEntitys != null) {
            for (DynamicObject rowDo : dataEntitys) {
                String fieldKey = rowDo.getString("csvfieldkey");
                PlainField plainField = plainFieldList.stream().filter(e -> e.getFieldKey().equalsIgnoreCase(fieldKey)).findFirst().get();
                String fieldType = rowDo.getString("csvfieldtype");
                String fieldRole = rowDo.getString("csvfieldrole");
                String displayName = rowDo.getString("csvdisplayname");
                plainField.setFieldType(fieldType);
                plainField.setFieldRole(fieldRole);
                plainField.setDisplayName(displayName);
                newPlainFieldList.add(plainField);
            }
        }
        fieldInfo.setPlainFieldList(newPlainFieldList);
        metadata.setFieldInfoList(fieldInfoList);
        String metadataStr = JSONObject.toJSONString((Object)metadata);
        this.getModel().setValue("metadata_tag", (Object)metadataStr);
    }

    private boolean isValidMetadata() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_CSV_FIELD_ENTRYENTITY);
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        ArrayList<String> timeRoleFieldList = new ArrayList<String>();
        ArrayList<String> metricFieldList = new ArrayList<String>();
        if (dataEntitys != null) {
            for (DynamicObject rowDo : dataEntitys) {
                String fieldKey = rowDo.getString("csvfieldkey");
                String fieldRole = rowDo.getString("csvfieldrole");
                if (StringUtils.equalsIgnoreCase((CharSequence)fieldRole, (CharSequence)FieldRoleEnum.TIME.getId())) {
                    timeRoleFieldList.add(fieldKey);
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)fieldRole, (CharSequence)FieldRoleEnum.METRIC.getId())) continue;
                metricFieldList.add(fieldKey);
            }
        }
        if (CollectionUtils.isEmpty(timeRoleFieldList)) {
            this.getView().showTipNotification("\u6570\u636e\u96c6\u4e2d\u9700\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u5b57\u6bb5\u89d2\u8272\u4e3a\u201c\u65f6\u95f4\u201d\u7684\u5b57\u6bb5");
            return false;
        }
        if (CollectionUtils.isEmpty(metricFieldList)) {
            this.getView().showTipNotification("\u6570\u636e\u96c6\u4e2d\u9700\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u5b57\u6bb5\u89d2\u8272\u4e3a\u201c\u5ea6\u91cf\u201d\u7684\u5b57\u6bb5");
            return false;
        }
        return true;
    }

    private void asyncSyncDataTask(long datasetId, boolean onlyExecuteDataStatistic, int totalCount) {
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BARITEM_SYNC_DATA});
        String opName = onlyExecuteDataStatistic ? "\u6570\u636e\u7edf\u8ba1" : "\u540c\u6b65\u6570\u636e";
        ThreadUtils.sleep((long)100L);
        RequestContext rc = RequestContext.get();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("ids");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(String.format("\u300c\u6570\u636e\u96c6\u300d%s - %s", opName, this.getModel().getValue("name")));
        jobInfo.setId(ID.genStringId());
        jobInfo.setTaskClassname("kd.ai.ids.plugin.form.gpe.DataStatisticsTask");
        jobInfo.setRunByLang(rc.getLang());
        jobInfo.setRunByOrgId(rc.getOrgId());
        jobInfo.setRunByUserId(rc.getCurrUserId());
        jobInfo.setRunConcurrently(true);
        String filterJson = (String)this.getModel().getValue("filter_tag");
        GpeRequestContext gpeRequestContext = new GpeRequestContext(RequestContext.get());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", datasetId);
        params.put("qFilter", filterJson);
        params.put("onlyExecuteDataStatistic", onlyExecuteDataStatistic);
        params.put("totalCount", totalCount);
        params.put("gpeRequestContext", JSONObject.toJSONString((Object)gpeRequestContext));
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TASK_CLOSE_BACK);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(String.format("%s\u8fdb\u5ea6", opName));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setTimeout(86400);
        jobFormInfo.setClickClassName("kd.ai.ids.plugin.form.gpe.DataStatisticsClickTask");
        IdsJobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject dataJo;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TASK_CLOSE_BACK)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_SET_FILTER) && returnData != null && (dataJo = JsonUtils.parseObj((Object)returnData)) != null) {
            String filterJson = dataJo.toJSONString();
            this.getModel().setValue("filter", (Object)"\u8fc7\u6ee4\u6761\u4ef6");
            this.getModel().setValue("filter_tag", (Object)filterJson);
        }
    }

    private void taskCallBack(Object returnData) {
        String data;
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotEmpty((CharSequence)(data = taskInfo.getData()))) {
            JSONObject dataJo = JSONObject.parseObject((String)data);
            long id = dataJo.getLong("id");
            JSONObject syncDataResultJo = dataJo.getJSONObject("syncDataResult");
            boolean dataStatistics = dataJo.getBooleanValue("dataStatistics");
            Tab tab = (Tab)this.getControl(KEY_TAB);
            String currentTab = tab.getCurrentTab();
            if (syncDataResultJo.getBooleanValue("status")) {
                long attachmentId = syncDataResultJo.getLong("attachmentid");
                DynamicObject attachmentDo = BusinessDataServiceHelper.loadSingle((Object)attachmentId, (String)IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId());
                this.getModel().setValue("issyncdata", (Object)YesNoEnum.YES.getKey());
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BARITEM_SYNC_DATA});
                this.getModel().setValue("attachmentid", (Object)attachmentDo);
                this.getView().updateView("attachmentid");
                if (StringUtils.equalsIgnoreCase((CharSequence)currentTab, (CharSequence)KEY_TAB_PREVIEWDATA)) {
                    this.previewData();
                }
            } else {
                this.getView().showMessage(String.format("\u540c\u6b65\u5931\u8d25-%s", syncDataResultJo.getString("failMsg")));
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BARITEM_SYNC_DATA});
                return;
            }
            if (dataStatistics) {
                DynamicObject datasetDo = BusinessDataServiceHelper.loadSingle((Object)id, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
                this.getModel().setValue("summary_tag", (Object)datasetDo.getString("summary_tag"));
                this.getModel().setValue("requestid", (Object)datasetDo.getString("requestid"));
                if (StringUtils.equalsIgnoreCase((CharSequence)currentTab, (CharSequence)KEY_TAB_DATASTATISTICS)) {
                    this.loadDataStatistics();
                }
            } else {
                String failMsg = dataJo.getString("dataStatisticsFailMsg");
                this.setDataStatisticsFlexVisible(ExecuteStatusEnum.FAIL.getKey(), failMsg, null);
                this.getView().showMessage(failMsg);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject dataSourceDo;
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"datasource") && (dataSourceDo = (DynamicObject)this.getModel().getValue("datasource")) != null) {
            Object dataSourceId = dataSourceDo.getPkValue();
            DynamicObject dataSourceDetailDo = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)IdsFormIdEnum.IDS_GPE_DATASOURCE.getId());
            String splitChar = dataSourceDetailDo.getString("splitchar");
            boolean firstLinecolName = dataSourceDetailDo.getBoolean("firstlinecolname");
            String metadataStr = dataSourceDetailDo.getString("metadata_tag");
            this.getModel().setValue("splitchar", (Object)splitChar);
            this.getModel().setValue("firstlinecolname", (Object)firstLinecolName);
            this.getModel().setValue("metadata", (Object)"\u6570\u636e\u96c6\u5143\u6570\u636e");
            this.getModel().setValue("metadata_tag", (Object)metadataStr);
            this.loadPlainFieldList();
        }
    }

    private String getEntityNumberFromMetadata(String metadataStr) {
        DataSourceMetadata metadata;
        List fieldInfoList;
        String entityId = null;
        if (StringUtils.isNotEmpty((CharSequence)metadataStr) && CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList()))) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfoList.get(0);
            entityId = fieldInfo.getEntityNumber();
        }
        return entityId;
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btn_re_execute": 
            case "btn_execute_statistic": {
                this.asyncSyncDataTask((Long)this.getModel().getDataEntity(true).getPkValue(), true, 0);
                break;
            }
            case "btnfilter": {
                String metadataStr = (String)this.getModel().getValue("metadata_tag");
                if (StringUtils.isEmpty((CharSequence)metadataStr)) {
                    this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90");
                    return;
                }
                String entityId = this.getEntityNumberFromMetadata(metadataStr);
                if (!StringUtils.isNotEmpty((CharSequence)entityId)) break;
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                String entityName = mainEntityType.getDisplayName().getLocaleValue();
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put("entityId", entityId);
                String filterJson = (String)this.getModel().getValue("filter_tag");
                customParams.put("qFilter", filterJson);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId(IdsFormIdEnum.IDS_GPE_FILTERGRID.getId());
                formShowParameter.setCaption(String.format("\u901a\u7528\u8fc7\u6ee4 - %s", entityName));
                formShowParameter.setCustomParams(customParams);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_SET_FILTER));
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.TRUE, new String[]{KEY_ENTRYENTITY_OVERVIEW, KEY_ENTRYENTITY_CATEGORY, KEY_ENTRYENTITY_NUM});
    }

    private void loadDataStatistics() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String summaryStr = dataEntity.getString("summary_tag");
        if (StringUtils.isNotEmpty((CharSequence)summaryStr)) {
            this.setDataStatisticsFlexVisible(ExecuteStatusEnum.SUCCESS.getKey(), null, summaryStr);
        } else {
            this.log.info("summary_tag is empty");
            this.refreshRequestStatus();
        }
    }

    private void showDataStatistics(String summaryStr) {
        JSONArray numVarStatisticsJa;
        int numVarSize;
        JSONArray cateVarStatisticsJa;
        int cateVarSize;
        int metricSize;
        List<PlainField> allPlainFieldList = this.loadPlainFieldList();
        Map<String, PlainField> map = allPlainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldKey, a -> a, (k1, k2) -> k1));
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_DATA_STATISTICS});
        this.getModel().deleteEntryData(KEY_ENTRYENTITY_OVERVIEW);
        this.getModel().deleteEntryData(KEY_ENTRYENTITY_CATEGORY);
        this.getModel().deleteEntryData(KEY_ENTRYENTITY_NUM);
        JSONObject summaryJo = JSONObject.parseObject((String)summaryStr);
        JSONArray overviewStatisticsJa = summaryJo.getJSONArray("overview_statistics");
        int n = metricSize = overviewStatisticsJa != null ? overviewStatisticsJa.size() : 0;
        if (overviewStatisticsJa != null && metricSize > 0) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY_OVERVIEW, metricSize);
            for (int index = 0; index < overviewStatisticsJa.size(); ++index) {
                JSONObject jo = (JSONObject)overviewStatisticsJa.get(index);
                String name = jo.getString("name");
                String value = String.valueOf(jo.get((Object)"value"));
                String unit = jo.getString("unit");
                this.getModel().setValue(KEY_VAR_NAME, (Object)name, index);
                this.getModel().setValue(KEY_VAR_VALUE, (Object)value, index);
                this.getModel().setValue(KEY_VAR_UNIT, (Object)unit, index);
            }
        }
        int n2 = cateVarSize = (cateVarStatisticsJa = summaryJo.getJSONArray("categorical_variable_statistics")) != null ? cateVarStatisticsJa.size() : 0;
        if (cateVarStatisticsJa != null && cateVarSize > 0) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY_CATEGORY, cateVarSize);
            JSONArray plotJa = new JSONArray();
            for (int index = 0; index < cateVarStatisticsJa.size(); ++index) {
                JSONObject jo = (JSONObject)cateVarStatisticsJa.get(index);
                String id = jo.getString("id");
                PlainField plainField = map.get(id);
                if (plainField != null && !StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)plainField.getDisplayName())) {
                    id = String.format("%s(%s)", plainField.getDisplayName(), id);
                }
                this.getModel().setValue(String.format("%s%s", KEY_CATEGORY_PREFIX, KEY_VAR_NAME), (Object)id, index);
                JSONArray indicatorJa = jo.getJSONArray("indicator");
                if (indicatorJa != null && indicatorJa.size() > 0) {
                    for (int i = 0; i < indicatorJa.size(); ++i) {
                        JSONObject indicatorJo = (JSONObject)indicatorJa.get(i);
                        String indicatorId = indicatorJo.getString("id");
                        String name = indicatorJo.getString("name");
                        String value = String.valueOf(indicatorJo.get((Object)"value"));
                        String unit = indicatorJo.getString("unit");
                        this.getModel().setValue(String.format("%s%s_%s", KEY_CATEGORY_PREFIX, indicatorId, "name"), (Object)name, index);
                        this.getModel().setValue(String.format("%s%s_%s", KEY_CATEGORY_PREFIX, indicatorId, "value"), (Object)value, index);
                        this.getModel().setValue(String.format("%s%s_%s", KEY_CATEGORY_PREFIX, indicatorId, "unit"), (Object)unit, index);
                    }
                }
                JSONObject plotJo = jo.getJSONObject("plot");
                plotJo.put("xName", (Object)"\u53d8\u91cf\u503c");
                plotJo.put("yName", (Object)"\u6b21\u6570");
                plotJo.put("title", (Object)String.format("%s-\u9891\u6b21\u7edf\u8ba1\uff08TOP50\uff09", id));
                plotJo.put("type", (Object)"bar");
                plotJo.put("uniqueId", (Object)ID.genStringId());
                plotJa.add((Object)plotJo);
            }
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("data", plotJa);
            customData.put("timestamp", KDDateUtils.now().getTime());
            customData.put("containerId", AI_GPE_CATE_STATISTICS);
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl(AI_GPE_CATE_STATISTICS);
            customControl.setData(customData);
        }
        int n3 = numVarSize = (numVarStatisticsJa = summaryJo.getJSONArray("numerical_variable_statistics")) != null ? numVarStatisticsJa.size() : 0;
        if (numVarStatisticsJa != null && numVarSize > 0) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY_NUM, numVarSize);
            JSONArray plotJa = new JSONArray();
            for (int index = 0; index < numVarStatisticsJa.size(); ++index) {
                JSONObject jo = (JSONObject)numVarStatisticsJa.get(index);
                String id = jo.getString("id");
                PlainField plainField = map.get(id);
                if (plainField != null && !StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)plainField.getDisplayName())) {
                    id = String.format("%s(%s)", plainField.getDisplayName(), id);
                }
                this.getModel().setValue(String.format("%s%s", KEY_NUM_PREFIX, KEY_VAR_NAME), (Object)id, index);
                JSONArray indicatorJa = jo.getJSONArray("indicator");
                if (indicatorJa != null && indicatorJa.size() > 0) {
                    for (int i = 0; i < indicatorJa.size(); ++i) {
                        JSONObject indicatorJo = (JSONObject)indicatorJa.get(i);
                        String indicatorId = indicatorJo.getString("id");
                        String name = indicatorJo.getString("name");
                        String value = String.valueOf(indicatorJo.get((Object)"value"));
                        String unit = indicatorJo.getString("unit");
                        this.getModel().setValue(String.format("%s%s_%s", KEY_NUM_PREFIX, indicatorId, "name"), (Object)name, index);
                        this.getModel().setValue(String.format("%s%s_%s", KEY_NUM_PREFIX, indicatorId, "value"), (Object)value, index);
                        this.getModel().setValue(String.format("%s%s_%s", KEY_NUM_PREFIX, indicatorId, "unit"), (Object)unit, index);
                    }
                }
                JSONObject plotJo = jo.getJSONObject("plot");
                plotJo.put("xName", (Object)"\u53d8\u91cf\u503c\u533a\u95f4");
                plotJo.put("yName", (Object)"\u6b21\u6570");
                plotJo.put("title", (Object)String.format("%s-\u9891\u7387\u5206\u5e03", id));
                plotJo.put("type", (Object)"histogram");
                plotJo.put("uniqueId", (Object)ID.genStringId());
                plotJa.add((Object)plotJo);
            }
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("data", plotJa);
            customData.put("timestamp", KDDateUtils.now().getTime());
            customData.put("containerId", AI_GPE_NUM_STATISTICS);
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl(AI_GPE_NUM_STATISTICS);
            customControl.setData(customData);
        }
    }

    private void refreshRequestStatus() {
        String requestId = (String)this.getModel().getValue("requestid");
        if (StringUtils.isNotEmpty((CharSequence)requestId)) {
            DynamicObject datasetDo = this.getModel().getDataEntity(true);
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            String executeStatus = datasetDo.getString("executestatus");
            int status = Integer.parseInt(executeStatus);
            String failMsg = datasetDo.getString("failmsg_tag");
            String summaryStr = datasetDo.getString("summary_tag");
            this.setDataStatisticsFlexVisible(status, failMsg, summaryStr);
        }
    }

    private void setDataStatisticsFlexVisible(int status, String failMsg, String summary) {
        if (status == ExecuteStatusEnum.SUCCESS.getKey()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_CALCULATING, FLEX_FAIL, FLEX_EMPTY});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_DATA_STATISTICS});
            if (StringUtils.isEmpty((CharSequence)summary)) {
                this.getView().showTipNotification("\u6267\u884c\u6210\u529f - \u65e0\u6570\u636e\u7edf\u8ba1\u7ed3\u679c");
            } else {
                this.showDataStatistics(summary);
            }
        } else if (status == ExecuteStatusEnum.INIT.getKey() || status == ExecuteStatusEnum.EXECUTING.getKey()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_FAIL, FLEX_DATA_STATISTICS, FLEX_EMPTY});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_CALCULATING});
            this.getView().addClientCallBack(KEY_ACTION_UPDATE_REFRESH_TIME, REFRESH_TIME);
            this.getCache().put(KEY_LABELAP_REFRESH_TIME, String.valueOf(REFRESH_TIME_TOTAL));
            this.setLabelText(KEY_LABELAP_REFRESH_TIME, String.valueOf(REFRESH_TIME_TOTAL));
        } else if (status == ExecuteStatusEnum.FAIL.getKey()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_CALCULATING, FLEX_DATA_STATISTICS, FLEX_EMPTY});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_FAIL});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BARITEM_SYNC_DATA});
            this.setLabelText(LABELAP_FAIL_MSG, failMsg);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String action = e.getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)KEY_ACTION_UPDATE_REFRESH_TIME)) {
            int refreshTime = this.getRefrshTime() - 1;
            this.getCache().put(KEY_LABELAP_REFRESH_TIME, String.valueOf(refreshTime));
            this.setLabelText(KEY_LABELAP_REFRESH_TIME, String.valueOf(refreshTime));
            if (refreshTime > 0) {
                this.getView().addClientCallBack(KEY_ACTION_UPDATE_REFRESH_TIME, REFRESH_TIME);
            } else {
                this.refreshRequestStatus();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        String formTitle = StringUtils.isEmpty((CharSequence)name.getLocaleValue()) ? "\u6570\u636e\u96c6" : String.format("\u6570\u636e\u96c6 - %s", name.getLocaleValue());
        this.getView().setFormTitle(new LocaleString(formTitle));
        Boolean isSyncData = (Boolean)this.getModel().getValue("issyncdata");
        if (isSyncData.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTN_FILTER, KEY_VECTORAP});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fc", "#999999");
            this.getView().updateControlMetadata(KEY_BTN_FILTER, map);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_CALCULATING, FLEX_FAIL, FLEX_EMPTY, FLEX_DATA_STATISTICS, FLEX_PREVIEW_CSV_DATA});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_EMPTY});
        this.loadPlainFieldList();
    }

    private void previewData() {
        List<PlainField> allPlainFieldList = this.loadPlainFieldList();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject attachmentDo = dataEntity.getDynamicObject("attachmentid");
        if (attachmentDo != null) {
            String splitChar = dataEntity.getString("splitchar");
            Boolean firstLineColName = dataEntity.getBoolean("firstlinecolname");
            IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
            String attachmentFileUrl = AttachmentTools.getAttachmentFileUrl((Long)attachmentDo.getPkValue(), idsParameter.getCosmicProxyIp());
            if (StringUtils.isNotEmpty((CharSequence)attachmentFileUrl)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PREVIEW_CSV_DATA});
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PREVIEW_EMPTY});
                String content = AwsS3Utils.readS3File((String)attachmentFileUrl);
                String[] lineArr = content.split("\\r?\\n", 102);
                JSONArray dataJa = new JSONArray();
                if (lineArr != null && lineArr.length > 0) {
                    for (int i = 0; i < lineArr.length; ++i) {
                        if (i == 0 && firstLineColName.booleanValue()) continue;
                        JSONObject rowJo = new JSONObject();
                        for (int j = 0; j < allPlainFieldList.size(); ++j) {
                            String fieldKey = allPlainFieldList.get(j).getFieldKey();
                            String[] split = lineArr[i].split(splitChar);
                            String fieldValue = null;
                            fieldValue = j > split.length - 1 ? null : split[j];
                            rowJo.put(fieldKey, (Object)fieldValue);
                        }
                        dataJa.add((Object)rowJo);
                        if (dataJa.size() == 100) break;
                    }
                }
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put("fields", JSONObject.toJSONString(allPlainFieldList));
                customParams.put("data", JSONObject.toJSONString((Object)dataJa));
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId(IdsFormIdEnum.IDS_GPE_PREVIEW_DATA.getId());
                formShowParameter.setCustomParams(customParams);
                formShowParameter.getOpenStyle().setTargetKey(FLEX_PREVIEW_CSV_DATA);
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                this.getView().showForm(formShowParameter);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PREVIEW_CSV_DATA});
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PREVIEW_EMPTY});
            }
        }
    }

    private List<PlainField> loadPlainFieldList() {
        FieldInfo fieldInfo;
        List fieldInfoList;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String metadataStr = dataEntity.getString("metadata_tag");
        DataSourceMetadata metadata = null;
        List<Object> allPlainFieldList = new ArrayList<PlainField>();
        if (StringUtils.isNotEmpty((CharSequence)metadataStr) && CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList())) && CollectionUtils.isNotEmpty(allPlainFieldList = (fieldInfo = (FieldInfo)fieldInfoList.get(0)).getPlainFieldList())) {
            int colSize = allPlainFieldList.size();
            this.getModel().deleteEntryData(KEY_CSV_FIELD_ENTRYENTITY);
            IDataModel dataModel = this.getModel();
            dataModel.batchCreateNewEntryRow(KEY_CSV_FIELD_ENTRYENTITY, colSize);
            for (int i = 0; i < allPlainFieldList.size(); ++i) {
                PlainField plainField = (PlainField)allPlainFieldList.get(i);
                dataModel.setValue("csvfieldkey", (Object)plainField.getFieldKey(), i);
                dataModel.setValue("csvdisplayname", (Object)plainField.getDisplayName(), i);
                dataModel.setValue("csvfieldtype", (Object)plainField.getFieldType(), i);
                dataModel.setValue("csvfieldrole", (Object)plainField.getFieldRole(), i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"csvfieldkey"});
            }
        }
        return allPlainFieldList;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        RequestContext rc = RequestContext.get();
        String tabKey = tabSelectEvent.getTabKey();
        DynamicObject dataSourceDo = (DynamicObject)this.getModel().getValue("datasource");
        dataSourceDo = BusinessDataServiceHelper.loadSingle((Object)dataSourceDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASOURCE.getId());
        this.cacheMetadata(dataSourceDo);
        if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_PREVIEWDATA)) {
            this.previewData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_DATASTATISTICS)) {
            this.loadDataStatistics();
        }
    }
}

