/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.enumtype.AttachmentSourceEnum;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.gpe.DataSourceTypeEnum;
import kd.ai.ids.core.enumtype.gpe.ErrorCodeEnum;
import kd.ai.ids.core.enumtype.gpe.FieldTypeEnum;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.utils.AwsS3Utils;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.EntityUtils;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.core.utils.PermUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.AttachmentTools;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DataSourceFormPlugin
extends BaseFormPlugin
implements UploadListener,
TabSelectListener {
    private static final String KEY_BD_ENTITYNUMBER = "entitynumber";
    private static final String KEY_OP_PREVIEW_DATA = "previewdata";
    private static final String KEY_OP_SAVE_DS = "saveds";
    private static final String KEY_OP_SELECT_FIELD = "selectfield";
    private static final String KEY_FLEX_EMPTY = "flexempty";
    private static final String KEY_FLEX_ENTITY_STRUCTURE = "flexentitystructure";
    private static final String KEY_FLEX_TREE = "flextree";
    private static final String KEY_FLEX_TREEEMPTY = "flextreeempty";
    private static final String CACHE_KEY_TEMP_NAME = "tempName";
    private static final String CACHE_KEY_IS_INIT = "isInit";
    private static final String KEY_FIELD_ENTRYENTITY = "fieldentryentity";
    private static final String KEY_CSV_FIELD_ENTRYENTITY = "csvfieldentryentity";
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String KEY_FLEX_PREVIEWCSVDATA = "flexpreviewcsvdata";
    private static final String KEY_FLEX_PREVIEWBIZOBJDATA = "flexpreviewbizobjdata";
    private static final String KEY_FLEX_PREVIEW_CSVEMPTY = "flexpreviewcsvempty";
    private static final String KEY_FLEX_PREVIEW_BIZOBJ_EMPTY = "flexpreviewbizobjempty";
    private static final String KEY_TABAP_BIZOBJ = "tabapbizobj";
    private static final String KEY_TABAP_CSV = "tabapcsv";
    private static final String KEY_TAB_FIELD = "tabpageapfield";
    private static final String KEY_TAB_BIZOBJ_PREVIEWDATA = "tabbizobjpreviewdata";
    private static final String KEY_TAB_CSV_PREVIEWDATA = "tabcsvpreviewdata";
    private static final String CACHE_KEY_TEMPFILEURL = "tempFileUrl";
    public static final String KEY_BARITEM_SELECTFIELD = "baritemselectfield";

    public boolean isInit() {
        String isInit = this.getCache().get(CACHE_KEY_IS_INIT);
        return Boolean.parseBoolean(isInit);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public List<PlainField> getSelectedPlainFieldList() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FIELD_ENTRYENTITY);
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        ArrayList<PlainField> selectedPlainFieldList = new ArrayList<PlainField>();
        if (dataEntitys != null && dataEntitys.length > 0) {
            for (DynamicObject rowDo : dataEntitys) {
                String fieldKey = rowDo.getString("fieldkey");
                String fieldId = rowDo.getString("fieldid");
                String fieldName = rowDo.getString("fieldname");
                String fieldType = rowDo.getString("fieldtype");
                String fieldRole = rowDo.getString("fieldrole");
                String displayName = rowDo.getString("displayname");
                String entityKey = rowDo.getString("entitykey");
                PlainField plainField = new PlainField();
                plainField.setFieldId(fieldId);
                plainField.setFieldKey(fieldKey);
                plainField.setFieldName(fieldName);
                plainField.setFieldType(fieldType);
                plainField.setFieldRole(fieldRole);
                plainField.setDisplayName(displayName);
                plainField.setEntityKey(entityKey);
                selectedPlainFieldList.add(plainField);
            }
        }
        return selectedPlainFieldList;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANELAP);
        attachmentPanel.addUploadListener((UploadListener)this);
        Tab tab = (Tab)this.getControl(KEY_TABAP_BIZOBJ);
        tab.addTabSelectListener((TabSelectListener)this);
        Tab tabCsv = (Tab)this.getControl(KEY_TABAP_CSV);
        tabCsv.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_BIZOBJ_PREVIEWDATA)) {
            this.getView().hideLoading();
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BARITEM_SELECTFIELD});
            this.previewData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_FIELD)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BARITEM_SELECTFIELD});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_CSV_PREVIEWDATA)) {
            String tempFileUrl = this.getCache().get(CACHE_KEY_TEMPFILEURL);
            this.previewCsvData(tempFileUrl, false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)KEY_OP_PREVIEW_DATA)) {
            this.previewData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)KEY_OP_SAVE_DS)) {
            List<PlainField> allPlainFieldList;
            boolean flag;
            String type;
            long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
            if (pkValue != 0L) {
                ORM orm = ORM.create();
                QFilter qFilter = new QFilter("datasource", "=", (Object)pkValue);
                int count = orm.count(((Object)((Object)this)).getClass().getName(), IdsFormIdEnum.IDS_GPE_DATASET.getId(), qFilter.toArray());
                if (count > 0) {
                    this.getView().showTipNotification("\u201c\u6570\u636e\u96c6\u201d\u7684\u5b57\u6bb5\u201c\u6570\u636e\u6e90\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u4fee\u6539\u3002");
                    this.getView().setEnable(Boolean.FALSE, new String[]{KEY_OP_SAVE_DS});
                    return;
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)(type = (String)this.getModel().getValue("type")), (CharSequence)DataSourceTypeEnum.CSV.getId())) {
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANELAP);
                List attachmentData = attachmentPanel.getAttachmentData();
                DynamicObject attachmentDo = (DynamicObject)this.getModel().getValue("attachmentid");
                if (attachmentDo == null && CollectionUtils.isEmpty((Collection)attachmentData)) {
                    this.getView().showTipNotification("\u8bf7\u4e0a\u4f20CSV\u6587\u4ef6");
                    return;
                }
            }
            if (flag = this.updatePageValue(type, false)) {
                return;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.BIZOBJ.getId()) && CollectionUtils.isEmpty(allPlainFieldList = this.getSelectedPlainFieldList())) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u201c\u5b57\u6bb5\u201d\u3002");
                return;
            }
            this.getModel().setValue("status", (Object)BillStatusEnum.AUDITED.getId());
            this.getView().invokeOperation("save");
            this.uploadTempAttachment();
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.CSV.getId())) {
                this.previewCsvHeader(null);
                this.previewCsvData(null, true);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)KEY_OP_SELECT_FIELD)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            this.updatePageValue(DataSourceTypeEnum.BIZOBJ.getId(), false);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(IdsFormIdEnum.IDS_GPE_BIZOBJ_FIELD_SEL.getId());
            fsp.setCustomParam("entityNumber", (Object)this.getEntityNumber());
            fsp.setCustomParam("metadata_tag", this.getModel().getValue("metadata_tag"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_OP_SELECT_FIELD));
            StyleCss css = new StyleCss();
            css.setWidth("60%");
            css.setHeight("80%");
            fsp.getOpenStyle().setInlineStyleCss(css);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
            this.getView().hideLoading();
        }
    }

    private void uploadTempAttachment() {
        String tempFileUrl = this.getCache().get(CACHE_KEY_TEMPFILEURL);
        String fileName = this.getCache().get(CACHE_KEY_TEMP_NAME);
        if (StringUtils.isNotEmpty((CharSequence)tempFileUrl)) {
            long dataSourceId = (Long)this.getModel().getDataEntity(true).getPkValue();
            DynamicObject attachmentDo = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId());
            CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)attachmentDo.getDataEntityType().getName(), (DynamicObject)attachmentDo, null);
            String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)attachmentDo);
            long id = ID.genLongId();
            attachmentDo.set("id", (Object)id);
            attachmentDo.set("number", (Object)number);
            attachmentDo.set("name", (Object)fileName);
            attachmentDo.set("status", (Object)BillStatusEnum.AUDITED.getId());
            attachmentDo.set("enable", (Object)YesNoEnum.YES.getKeyStr());
            attachmentDo.set("masterid", (Object)id);
            attachmentDo.set("source", (Object)AttachmentSourceEnum.IDS_GPE_DATASOURCE.getId());
            attachmentDo.set("sourceid", (Object)dataSourceId);
            String content = this.loadTextFileString(tempFileUrl);
            InputStream in = IOUtils.toInputStream((String)content, (Charset)Charset.forName("utf-8"));
            int fileSize = 0;
            try {
                fileSize = in.available();
                attachmentDo.set("filesize", (Object)fileSize);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachmentDo});
                boolean uploadSuccess = this.upload(attachmentDo, in, fileName);
                if (uploadSuccess) {
                    DynamicObject dataSourceDo = this.getModel().getDataEntity(true);
                    dataSourceDo.set("attachmentid", (Object)attachmentDo);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSourceDo});
                    this.getModel().setValue("attachmentid", (Object)attachmentDo);
                    this.showAttachment();
                    this.deleteAttachment(dataSourceDo);
                }
            }
            catch (Exception e) {
                this.log.error("error:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void deleteAttachment(DynamicObject dataSourceDo) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(KEY_ATTACHMENTPANELAP);
        List attachmentDataList = attachmentPanel.getAttachmentData();
        if (CollectionUtils.isNotEmpty((Collection)attachmentDataList)) {
            for (Map attachmentData : attachmentDataList) {
                attachmentPanel.remove(attachmentData);
            }
        }
        AttachmentServiceHelper.remove((String)IdsFormIdEnum.IDS_GPE_DATASOURCE.getId(), (Object)dataSourceDo.getPkValue());
    }

    private void showAttachment() {
        DynamicObject attachmentDo = (DynamicObject)this.getModel().getValue("attachmentid");
        boolean hasAttachment = attachmentDo != null;
        this.getView().setVisible(Boolean.valueOf(!hasAttachment), new String[]{KEY_ATTACHMENTPANELAP});
        this.getView().setVisible(Boolean.valueOf(hasAttachment), new String[]{"attachmentid"});
    }

    private boolean upload(DynamicObject attachmentDo, InputStream inputStream, String fileName) {
        RequestContext rc = RequestContext.get();
        boolean uploadSuccess = false;
        try {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".csv")) {
                fileName = String.format("%s.csv", fileName);
            }
            String today = DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyyMMdd");
            String uploadPath = String.format("%s/%s/%s/%s/%s/%s", rc.getTenantId(), rc.getAccountId(), today, IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId(), attachmentDo.getPkValue(), fileName);
            FileService fs = FileServiceFactory.getAttachmentFileService();
            FileItem fi = new FileItem(fileName, uploadPath, inputStream);
            int size = inputStream.available();
            String path = fs.upload(fi);
            HashMap<String, Object> uploadFileMap = new HashMap<String, Object>();
            uploadFileMap.put("entityNum", attachmentDo.getDynamicObjectType().getName());
            uploadFileMap.put("billPkId", attachmentDo.get("id"));
            uploadFileMap.put("lastModified", KDDateUtils.now().getTime());
            uploadFileMap.put("name", fileName);
            uploadFileMap.put("url", uploadPath);
            uploadFileMap.put("size", size);
            uploadFileMap.put("status", "success");
            ArrayList<HashMap<String, Object>> attachments = new ArrayList<HashMap<String, Object>>();
            attachments.add(uploadFileMap);
            AttachmentServiceHelper.upload((String)attachmentDo.getDynamicObjectType().getName(), (Object)attachmentDo.getPkValue(), (String)KEY_ATTACHMENTPANELAP, attachments);
            uploadSuccess = true;
            this.log.info("\u4e0a\u4f20\u6210\u529f\uff1a" + path);
        }
        catch (Exception e) {
            uploadSuccess = false;
            this.log.error("error:" + e.getMessage(), (Throwable)e);
        }
        return uploadSuccess;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject dataJo;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_OP_SELECT_FIELD) && returnData != null && (dataJo = JsonUtils.parseObj((Object)returnData)) != null) {
            String entityNumber = dataJo.getString("entityNumber");
            this.updateBizObjValue(entityNumber);
            String metadataTag = dataJo.getString("metadata_tag");
            this.getModel().setValue("metadata_tag", (Object)metadataTag);
            this.initEntityFieldData();
        }
    }

    private void updateBizObjValue(String entityNumber) {
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            DynamicObject bosEntityobject = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter("number", "=", (Object)entityNumber).toArray());
            this.getModel().setValue(KEY_BD_ENTITYNUMBER, (Object)bosEntityobject);
            this.getView().updateView(KEY_BD_ENTITYNUMBER);
        }
    }

    private boolean updatePageValue(String type, boolean isInit) {
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.CSV.getId())) {
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (name == null || name.isEmpty() || StringUtils.isEmpty((CharSequence)name.getLocaleValue())) {
                String tempName = this.getCache().get(CACHE_KEY_TEMP_NAME);
                LocaleString localeName = new LocaleString(tempName);
                this.getModel().setValue("name", (Object)localeName);
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_CSV_FIELD_ENTRYENTITY);
            EntryData entryData = entryGrid.getEntryData();
            DynamicObject[] dataEntitys = entryData.getDataEntitys();
            ArrayList<PlainField> plainFieldList = new ArrayList<PlainField>();
            boolean fieldKeyHasEmpty = false;
            boolean fieldNameHasEmpty = false;
            if (dataEntitys != null) {
                for (DynamicObject rowDo : dataEntitys) {
                    String fieldKey = rowDo.getString("csvfieldkey");
                    String fieldType = rowDo.getString("csvfieldtype");
                    String fieldRole = rowDo.getString("csvfieldrole");
                    String displayName = rowDo.getString("csvdisplayname");
                    PlainField plainField = new PlainField();
                    plainField.setFieldKey(fieldKey);
                    plainField.setFieldType(fieldType);
                    plainField.setFieldRole(fieldRole);
                    plainField.setDisplayName(displayName);
                    plainFieldList.add(plainField);
                    if (StringUtils.isEmpty((CharSequence)fieldKey)) {
                        fieldKeyHasEmpty = true;
                    }
                    if (!StringUtils.isEmpty((CharSequence)fieldKey)) continue;
                    fieldNameHasEmpty = true;
                }
            }
            if (!isInit) {
                if (fieldKeyHasEmpty) {
                    this.getView().showTipNotification("\u5b57\u6bb5\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                    return true;
                }
                if (fieldNameHasEmpty) {
                    this.getView().showTipNotification("\u5b57\u6bb5\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                    return true;
                }
            }
            DataSourceMetadata metadata = new DataSourceMetadata();
            ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setEntityNumber(DataSourceTypeEnum.CSV.getId());
            fieldInfo.setPlainFieldList(plainFieldList);
            fieldInfoList.add(fieldInfo);
            metadata.setFieldInfoList(fieldInfoList);
            String metadataStr = JSONObject.toJSONString((Object)metadata);
            this.getModel().setValue("metadata", (Object)String.format("%s\u914d\u7f6e", DataSourceTypeEnum.CSV.getName()));
            this.getModel().setValue("metadata_tag", (Object)metadataStr);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.BIZOBJ.getId())) {
            String entityNumber = this.getEntityNumber();
            if (StringUtils.isEmpty((CharSequence)entityNumber)) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u3002");
                return true;
            }
            List<PlainField> allPlainFieldList = this.getSelectedPlainFieldList();
            DataSourceMetadata model = new DataSourceMetadata();
            ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setEntityNumber(entityNumber);
            fieldInfo.setPlainFieldList(allPlainFieldList);
            fieldInfoList.add(fieldInfo);
            model.setFieldInfoList(fieldInfoList);
            String modelStr = JSONObject.toJSONString((Object)model);
            DynamicObject entityNumberDo = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITYNUMBER);
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (name == null || name.isEmpty() || StringUtils.isEmpty((CharSequence)name.getLocaleValue())) {
                LocaleString localeName = new LocaleString(entityNumberDo.getString("name"));
                this.getModel().setValue("name", (Object)localeName);
            }
            this.getModel().setValue("splitchar", (Object)"\\u0001");
            this.getModel().setValue("metadata", (Object)String.format("%s\u914d\u7f6e", DataSourceTypeEnum.BIZOBJ.getName()));
            this.getModel().setValue("metadata_tag", (Object)modelStr);
            this.initEntityFieldData();
        }
        return false;
    }

    public void upload(UploadEvent evt) {
        this.getModel().setValue("metadata_tag", null);
        for (Object obj : evt.getUrls()) {
            Map urlMap = (Map)obj;
            Integer size = (Integer)urlMap.get("size");
            if (size == null || size <= 0x6400000) continue;
            evt.setCancelMsg("\u6700\u5927\u652f\u6301\u4e0a\u4f20100M\u7684\u6587\u4ef6");
            evt.setCancel(true);
            break;
        }
    }

    public void beforeUpload(BeforeUploadEvent evt) {
    }

    public void afterUpload(UploadEvent evt) {
        this.getView().setEnable(Boolean.TRUE, new String[]{KEY_OP_SAVE_DS});
        this.getCache().put(CACHE_KEY_IS_INIT, "true");
        for (Object obj : evt.getUrls()) {
            Map fileMap = (Map)obj;
            String tempFileUrl = (String)fileMap.get("url");
            String name = (String)fileMap.get("name");
            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
            name = name.split("\\.")[0];
            this.getCache().put(CACHE_KEY_TEMP_NAME, name);
            this.getModel().setValue("name", (Object)new LocaleString(name));
            this.getCache().put(CACHE_KEY_TEMPFILEURL, tempFileUrl);
            this.previewCsvHeader(tempFileUrl);
            this.previewCsvData(tempFileUrl, false);
        }
        this.getCache().remove(CACHE_KEY_IS_INIT);
    }

    public void afterRemove(UploadEvent evt) {
        this.getModel().deleteEntryData(KEY_FIELD_ENTRYENTITY);
        this.getModel().deleteEntryData(KEY_CSV_FIELD_ENTRYENTITY);
    }

    private void previewCsvHeader(String tempFileUrl) {
        DynamicObject attachmentDo = (DynamicObject)this.getModel().getValue("attachmentid");
        if (attachmentDo != null || StringUtils.isNotEmpty((CharSequence)tempFileUrl)) {
            String url = tempFileUrl;
            if (StringUtils.isEmpty((CharSequence)tempFileUrl)) {
                IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
                url = AttachmentTools.getAttachmentFileUrl((Long)attachmentDo.getPkValue(), idsParameter.getCosmicProxyIp());
            }
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                String content = null;
                content = StringUtils.isNotEmpty((CharSequence)tempFileUrl) ? this.loadTextFileString(url) : AwsS3Utils.readS3File((String)url);
                char firstChar = content.charAt(0);
                if (firstChar == '\ufeff') {
                    content = content.substring(1);
                }
                String[] lineArr = content.split("\\r?\\n", 102);
                String[] colArr = null;
                String splitChar = (String)this.getModel().getValue("splitchar");
                Boolean firstLineColName = (Boolean)this.getModel().getValue("firstlinecolname");
                List<Object> allPlainFieldList = new ArrayList();
                if (lineArr != null && lineArr.length > 0) {
                    this.getCache().put(CACHE_KEY_IS_INIT, "true");
                    try {
                        for (int i = 0; i < lineArr.length && i == 0; ++i) {
                            int index;
                            colArr = lineArr[i].split(splitChar);
                            int colSize = colArr.length;
                            this.getModel().deleteEntryData(KEY_CSV_FIELD_ENTRYENTITY);
                            IDataModel dataModel = this.getModel();
                            dataModel.batchCreateNewEntryRow(KEY_CSV_FIELD_ENTRYENTITY, colSize);
                            allPlainFieldList = this.getPlainFieldListFromMetadata(DataSourceTypeEnum.CSV.getId());
                            if (CollectionUtils.isEmpty(allPlainFieldList)) {
                                for (index = 0; index < colArr.length; ++index) {
                                    String colName = colArr[index];
                                    String fieldKey = colName.replaceAll("\\.", "_");
                                    String fieldType = FieldTypeEnum.STRING.getId();
                                    if (lineArr.length > 1) {
                                        String[] firstDataLineArr = lineArr[1].split(splitChar);
                                        String fieldValue = firstDataLineArr[index];
                                        fieldType = EntityUtils.getFieldTypeByFieldValue((String)fieldValue);
                                    }
                                    String displayName = fieldKey;
                                    String fieldRole = EntityUtils.getFieldRoleByFieldType((String)fieldType);
                                    PlainField plainField = new PlainField();
                                    plainField.setFieldKey(fieldKey);
                                    plainField.setFieldType(fieldType);
                                    plainField.setDisplayName(displayName);
                                    plainField.setFieldRole(fieldRole);
                                    allPlainFieldList.add(plainField);
                                }
                            }
                            for (index = 0; index < allPlainFieldList.size(); ++index) {
                                PlainField plainField = (PlainField)allPlainFieldList.get(index);
                                this.getModel().setValue("csvfieldkey", (Object)plainField.getFieldKey(), index);
                                this.getModel().setValue("csvdisplayname", (Object)plainField.getDisplayName(), index);
                                this.getModel().setValue("csvfieldtype", (Object)plainField.getFieldType(), index);
                                this.getModel().setValue("csvfieldrole", (Object)plainField.getFieldRole(), index);
                                if (!firstLineColName.booleanValue()) continue;
                                this.getView().setEnable(Boolean.FALSE, index, new String[]{"csvfieldkey"});
                            }
                        }
                    }
                    catch (Exception e) {
                        CommonUtil.getStackTrace((Exception)e);
                        this.getView().showErrorNotification("\u89e3\u6790\u6587\u4ef6\u5185\u5bb9\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u540e\u91cd\u65b0\u4e0a\u4f20");
                        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_OP_SAVE_DS});
                    }
                    this.getCache().remove(CACHE_KEY_IS_INIT);
                }
            }
        }
    }

    private void previewCsvData(String tempFileUrl, boolean isInit) {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEWCSVDATA});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEW_CSVEMPTY});
        this.updatePageValue(DataSourceTypeEnum.CSV.getId(), isInit);
        DynamicObject attachmentDo = (DynamicObject)this.getModel().getValue("attachmentid");
        if (attachmentDo != null || StringUtils.isNotEmpty((CharSequence)tempFileUrl)) {
            String url = tempFileUrl;
            if (StringUtils.isEmpty((CharSequence)tempFileUrl)) {
                IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
                url = AttachmentTools.getAttachmentFileUrl((Long)attachmentDo.getPkValue(), idsParameter.getCosmicProxyIp());
            }
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                String content = null;
                content = StringUtils.isNotEmpty((CharSequence)tempFileUrl) ? this.loadTextFileString(url) : AwsS3Utils.readS3File((String)url);
                String[] lineArr = content.split("\\r?\\n", 102);
                String splitChar = (String)this.getModel().getValue("splitchar");
                Boolean firstLineColName = (Boolean)this.getModel().getValue("firstlinecolname");
                List<PlainField> allPlainFieldList = this.getPlainFieldListFromMetadata(DataSourceTypeEnum.CSV.getId());
                JSONArray dataJa = new JSONArray();
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEW_CSVEMPTY});
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEWCSVDATA});
                if (lineArr != null && lineArr.length > 0) {
                    try {
                        for (int i = 0; i < lineArr.length; ++i) {
                            String line;
                            if (firstLineColName.booleanValue() && i == 0 || StringUtils.isEmpty((CharSequence)(line = lineArr[i]))) continue;
                            JSONObject rowJo = new JSONObject();
                            for (int index = 0; index < allPlainFieldList.size(); ++index) {
                                PlainField plainField = allPlainFieldList.get(index);
                                String fieldKey = plainField.getFieldKey();
                                rowJo.put(fieldKey, (Object)line.split(splitChar)[index]);
                            }
                            dataJa.add((Object)rowJo);
                            if (dataJa.size() != 100) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        CommonUtil.getStackTrace((Exception)e);
                        this.getView().showErrorNotification("\u89e3\u6790\u6587\u4ef6\u5185\u5bb9\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u540e\u91cd\u65b0\u4e0a\u4f20");
                        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_OP_SAVE_DS});
                    }
                    HashMap<String, String> customParams = new HashMap<String, String>();
                    customParams.put("fields", JSONObject.toJSONString(allPlainFieldList));
                    customParams.put("data", JSONObject.toJSONString((Object)dataJa));
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.setFormId(IdsFormIdEnum.IDS_GPE_PREVIEW_DATA.getId());
                    formShowParameter.setCustomParams(customParams);
                    formShowParameter.getOpenStyle().setTargetKey(KEY_FLEX_PREVIEWCSVDATA);
                    formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                    this.getView().showForm(formShowParameter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTextFileString(String fileUrl) {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        int temp = 0;
        int len = 0;
        byte[] bt = null;
        InputStream inStream = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(2);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            bt = new byte[0x6400000];
            while ((temp = inStream.read()) != -1) {
                bt[len] = (byte)temp;
                ++len;
            }
        }
        catch (Exception e) {
            CommonUtil.getStackTrace((Exception)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception e) {
                CommonUtil.getStackTrace((Exception)e);
            }
        }
        return new String(bt, 0, len);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_BD_ENTITYNUMBER)) {
            this.loadModelData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"type")) {
            String type = (String)changeData[0].getNewValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.BIZOBJ.getId())) {
                this.getModel().setValue("splitchar", (Object)"\\u0001");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.CSV.getId())) {
                this.getModel().setValue("splitchar", (Object)",");
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"splitchar")) {
            this.getModel().setValue("metadata", null);
            this.getModel().setValue("metadata_tag", null);
            String tempFileUrl = this.getCache().get(CACHE_KEY_TEMPFILEURL);
            this.previewCsvHeader(tempFileUrl);
            this.previewCsvData(tempFileUrl, false);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"firstlinecolname")) {
            Boolean firstLineColName = (Boolean)changeData[0].getNewValue();
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_CSV_FIELD_ENTRYENTITY);
            EntryData entryData = entryGrid.getEntryData();
            DynamicObject[] dataEntitys = entryData.getDataEntitys();
            if (!firstLineColName.booleanValue()) {
                if (dataEntitys != null && dataEntitys.length > 0) {
                    for (int i = 0; i < dataEntitys.length; ++i) {
                        this.getView().setEnable(Boolean.TRUE, i, new String[]{"csvfieldkey"});
                    }
                    this.getView().showTipNotification("\u8bf7\u914d\u7f6e\u5b57\u6bb5\u6807\u8bc6\u4e0e\u663e\u793a\u540d\u79f0");
                }
            } else {
                this.getCache().put(CACHE_KEY_IS_INIT, "true");
                String tempFileUrl = this.getCache().get(CACHE_KEY_TEMPFILEURL);
                this.previewCsvHeader(tempFileUrl);
                this.previewCsvData(tempFileUrl, false);
                this.getCache().remove(CACHE_KEY_IS_INIT);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"csvfieldkey") && !this.isInit()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_CSV_FIELD_ENTRYENTITY);
            int focusRow = entryGrid.getEntryState().getFocusRow();
            String fieldKey = (String)changeData[0].getNewValue();
            this.getModel().setValue("csvdisplayname", (Object)fieldKey, focusRow);
        }
    }

    private void previewData() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEWBIZOBJDATA});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEW_BIZOBJ_EMPTY});
        String entityNumber = this.getEntityNumber();
        List<PlainField> allPlainFieldList = this.getPlainFieldListFromMetadata(entityNumber);
        if (CollectionUtils.isEmpty(allPlainFieldList)) {
            return;
        }
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
        List fieldIdList = allPlainFieldList.stream().map(PlainField::getFieldId).distinct().collect(Collectors.toList());
        String selectFields = StringUtils.join(fieldIdList, (String)",");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityNumber, (String)selectFields, null, null, (int)100);
        JSONArray dataJa = new JSONArray();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEW_BIZOBJ_EMPTY});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEWBIZOBJDATA});
        if (doc != null && doc.size() > 0) {
            for (DynamicObject dynamicObject : doc) {
                JSONObject rowJo = new JSONObject();
                for (int i = 0; i < allPlainFieldList.size(); ++i) {
                    PlainField plainField = allPlainFieldList.get(i);
                    String fieldKey = plainField.getFieldKey();
                    String fieldId = plainField.getFieldId();
                    Object fieldValue = dynamicObject.get(fieldId);
                    if (fieldValue != null && (StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATE.getId()) || StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATETIME.getId()))) {
                        fieldValue = KDDateFormatUtils.getDateFormat().format(fieldValue);
                    }
                    String fieldValueStr = fieldValue != null ? fieldValue.toString() : "";
                    rowJo.put(fieldKey, (Object)fieldValueStr);
                }
                dataJa.add((Object)rowJo);
            }
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("fields", JSONObject.toJSONString(allPlainFieldList));
        customParams.put("data", JSONObject.toJSONString((Object)dataJa));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(IdsFormIdEnum.IDS_GPE_PREVIEW_DATA.getId());
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setTargetKey(KEY_FLEX_PREVIEWBIZOBJDATA);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getView().showForm(formShowParameter);
        this.getView().hideLoading();
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean hasPermission = PermUtils.hasPermission((Object)RequestContext.get().getCurrUserId(), (Object)"open", (Object)"third_app", (Object)"QXX0009");
        if (!hasPermission) {
            throw new KDBizException(new ErrorCode(ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getId(), ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getName()), new Object[0]);
        }
        IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
        this.openAPIService().initOpenAPIThirdApp(idsParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getCache().put(CACHE_KEY_IS_INIT, "true");
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        String formTitle = StringUtils.isEmpty((CharSequence)name.getLocaleValue()) ? "\u6570\u636e\u6e90" : String.format("\u6570\u636e\u6e90 - %s", name.getLocaleValue());
        this.getView().setFormTitle(new LocaleString(formTitle));
        this.getCache().put(CACHE_KEY_TEMP_NAME, name.getLocaleValue());
        this.loadModelData();
        String type = (String)this.getModel().getValue("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.CSV.getId())) {
            this.previewCsvHeader(null);
            this.previewCsvData(null, true);
        }
        this.getCache().remove(CACHE_KEY_IS_INIT);
        this.showAttachment();
    }

    private String getEntityNumber() {
        DynamicObject entityNumberDo = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITYNUMBER);
        String entityNumber = "";
        if (entityNumberDo != null) {
            entityNumber = entityNumberDo.getString("number");
        }
        return entityNumber;
    }

    private void loadModelData() {
        String entityNumber = this.getEntityNumber();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_EMPTY, KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_TREE});
        if (!StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_TREE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_EMPTY, KEY_FLEX_TREEEMPTY});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_EMPTY, KEY_FLEX_TREEEMPTY});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_TREE});
        this.initEntityFieldData();
    }

    private List<PlainField> getPlainFieldListFromMetadata(String entityNumber) {
        List fieldInfoList;
        Optional<FieldInfo> first;
        List<Object> plainFieldList = new ArrayList<PlainField>();
        String modelStr = (String)this.getModel().getValue("metadata_tag");
        DataSourceMetadata model = null;
        if (StringUtils.isNotEmpty((CharSequence)modelStr) && (first = (fieldInfoList = (model = (DataSourceMetadata)JSONObject.parseObject((String)modelStr, DataSourceMetadata.class)).getFieldInfoList()).stream().filter(e -> e.getEntityNumber().equalsIgnoreCase(entityNumber)).findFirst()).isPresent()) {
            FieldInfo fieldInfo = first.get();
            plainFieldList = fieldInfo.getPlainFieldList();
        }
        return plainFieldList;
    }

    private void initEntityFieldData() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return;
        }
        List<PlainField> allPlainFieldList = this.getPlainFieldListFromMetadata(entityNumber);
        this.getModel().deleteEntryData(KEY_FIELD_ENTRYENTITY);
        int size = allPlainFieldList.size();
        if (size > 0) {
            IDataModel dataModel = this.getModel();
            dataModel.batchCreateNewEntryRow(KEY_FIELD_ENTRYENTITY, size);
            for (int i = 0; i < allPlainFieldList.size(); ++i) {
                PlainField plainField = allPlainFieldList.get(i);
                dataModel.setValue("fieldkey", (Object)plainField.getFieldKey(), i);
                dataModel.setValue("fieldname", (Object)plainField.getFieldName(), i);
                dataModel.setValue("displayname", (Object)plainField.getDisplayName(), i);
                dataModel.setValue("fieldtype", (Object)plainField.getFieldType(), i);
                dataModel.setValue("fieldrole", (Object)plainField.getFieldRole(), i);
                dataModel.setValue("fieldid", (Object)plainField.getFieldId(), i);
                dataModel.setValue("entitykey", (Object)plainField.getEntityKey(), i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"fieldkey"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"fieldname"});
            }
        }
    }
}

