/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.enumtype.AttachmentSourceEnum;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.gpe.DataSourceTypeEnum;
import kd.ai.ids.core.enumtype.gpe.FieldTypeEnum;
import kd.ai.ids.core.query.gpe.AttachmentFileInfo;
import kd.ai.ids.core.query.gpe.DatasetField;
import kd.ai.ids.core.query.gpe.DatasetMetadata;
import kd.ai.ids.core.query.gpe.DatasetMetadataQuery;
import kd.ai.ids.core.query.gpe.GpeRequestContext;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IGpeServerService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.EntityUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.tool.AttachmentTools;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DataStatisticsTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(DataStatisticsTask.class);
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";

    public IGpeServerService gpeServerService() {
        return (IGpeServerService)Services.get(IGpeServerService.class);
    }

    private IIdsParameterService idsParameterService() {
        return (IIdsParameterService)Services.get(IIdsParameterService.class);
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        log.info("start execute");
        int progress = 0;
        boolean onlyExecuteDataStatistic = (Boolean)params.get("onlyExecuteDataStatistic");
        String opName = onlyExecuteDataStatistic ? "\u6570\u636e\u7edf\u8ba1" : "\u540c\u6b65\u6570\u636e";
        long datasetId = (Long)params.get("id");
        String filterJson = (String)params.get("qFilter");
        int totalCount = (Integer)params.get("totalCount");
        String gpeRequestContextStr = (String)params.get("gpeRequestContext");
        GpeRequestContext gpeRequestContext = (GpeRequestContext)JSONObject.parseObject((String)gpeRequestContextStr, GpeRequestContext.class);
        DynamicObject datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        ILocaleString datasetNameLs = datasetDo.getLocaleString("name");
        String datasetName = datasetNameLs.getLocaleValue();
        String desc = String.format("%s - \u51c6\u5907\u6267\u884c...(%s)", opName, datasetName);
        this.feedbackProgress(progress, desc, null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        JSONObject syncDataResultJo = new JSONObject();
        syncDataResultJo.put("status", (Object)true);
        if (!onlyExecuteDataStatistic) {
            syncDataResultJo = this.syncdata(datasetDo, opName, datasetName, filterJson, totalCount);
        }
        if (syncDataResultJo.getBooleanValue("status")) {
            result = this.dataStatistics(progress, desc, datasetId, datasetDo, opName, datasetName, gpeRequestContext);
        }
        result.put("syncDataResult", syncDataResultJo);
        result.put("id", datasetId);
        this.feedbackCustomdata(result);
    }

    private HashMap<String, Object> dataStatistics(int progress, String desc, long datasetId, DynamicObject datasetDo, String opName, String datasetName, GpeRequestContext gpeRequestContext) {
        log.info("start dataStatistics");
        boolean dataStatisticsResult = false;
        String failMsg = "";
        String summary = "";
        long attachmentId = (Long)datasetDo.getDynamicObject("attachmentid").getPkValue();
        IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
        String dataSetFileUrl = AttachmentTools.getAttachmentFileUrl(attachmentId, idsParameter.getCosmicProxyIp());
        String requestId = "";
        if (StringUtils.isNotEmpty((CharSequence)dataSetFileUrl) && StringUtils.isNotEmpty((CharSequence)(requestId = this.executeDataStatistics(datasetDo, dataSetFileUrl, gpeRequestContext)))) {
            boolean needRetry = false;
            do {
                datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
                summary = datasetDo.getString("summary_tag");
                String executeStatus = datasetDo.getString("executestatus");
                failMsg = datasetDo.getString("failmsg_tag");
                if (this.isStop() && StringUtils.isBlank((CharSequence)summary)) {
                    failMsg = "\u6267\u884c\u5931\u8d25 - \u4efb\u52a1\u88ab\u7ec8\u6b62";
                    break;
                }
                int status = Integer.parseInt(executeStatus);
                if (status == ExecuteStatusEnum.INIT.getKey()) {
                    needRetry = true;
                    progress = 50;
                    desc = "\u7b49\u5f85\u6267\u884c...";
                } else if (status == ExecuteStatusEnum.EXECUTING.getKey()) {
                    needRetry = true;
                    progress = 75;
                    desc = "\u6267\u884c\u4e2d...";
                } else if (status == ExecuteStatusEnum.SUCCESS.getKey()) {
                    if (StringUtils.isNotEmpty((CharSequence)summary)) {
                        needRetry = false;
                        progress = 100;
                        desc = "\u6267\u884c\u6210\u529f";
                        dataStatisticsResult = true;
                        datasetDo.set("summary", (Object)"\u6982\u89c8\u7edf\u8ba1");
                        datasetDo.set("status", (Object)BillStatusEnum.AUDITED.getId());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datasetDo});
                    } else {
                        needRetry = false;
                        progress = 100;
                        failMsg = desc = "\u6267\u884c\u5931\u8d25 - \u6570\u636e\u7edf\u8ba1\u7ed3\u679c\u4e3a\u7a7a";
                    }
                } else if (status == ExecuteStatusEnum.FAIL.getKey()) {
                    needRetry = false;
                    progress = 100;
                    failMsg = desc = String.format("\u6267\u884c\u5931\u8d25 - %s", StringUtils.isNotEmpty((CharSequence)failMsg) ? failMsg : "\u672a\u77e5\u539f\u56e0");
                }
                this.feedbackProgress(progress, String.format("%s - %s(%s)", opName, desc, datasetName), null);
                if (!needRetry) continue;
                log.info("sleep 3s");
                ThreadUtils.sleep((long)3000L);
            } while (needRetry);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dataStatistics", dataStatisticsResult);
        result.put("dataStatisticsFailMsg", failMsg);
        log.info("end dataStatistics");
        return result;
    }

    private String executeDataStatistics(DynamicObject datasetDo, String dataSetFileUrl, GpeRequestContext gpeRequestContext) {
        String requestId = UUID.randomUUID().toString();
        DatasetMetadataQuery metadataQuery = this.assemblyDatasetMetadataQuery(datasetDo);
        JSONObject datasetJo = new JSONObject();
        datasetJo.put("dataset", (Object)metadataQuery);
        JSONObject paramJo = new JSONObject();
        paramJo.put("dataset", (Object)dataSetFileUrl);
        paramJo.put("metadata", (Object)datasetJo);
        paramJo.put("requestId", (Object)requestId);
        CustomApiResult customApiResult = this.gpeServerService().getCustomApiResult(gpeRequestContext, "/gpes/algorithm/dataset/statistic/summary", paramJo);
        if (customApiResult.isStatus()) {
            datasetDo.set("requestid", (Object)requestId);
            datasetDo.set("executestatus", (Object)ExecuteStatusEnum.INIT.getKeyStr());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datasetDo});
        }
        return requestId;
    }

    private DatasetMetadataQuery assemblyDatasetMetadataQuery(DynamicObject datasetDo) {
        DatasetMetadataQuery metadataQuery = new DatasetMetadataQuery();
        metadataQuery.setSplitchar(datasetDo.getString("splitchar"));
        metadataQuery.setFirstLineColName(Boolean.valueOf(datasetDo.getBoolean("firstlinecolname")));
        DatasetMetadata datasetMetadata = new DatasetMetadata();
        ArrayList<DatasetField> datasetFieldList = new ArrayList<DatasetField>();
        String metadataStr = datasetDo.getString("metadata_tag");
        if (StringUtils.isNotEmpty((CharSequence)metadataStr)) {
            DataSourceMetadata dataSourceMetadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class);
            List fieldInfoList = dataSourceMetadata.getFieldInfoList();
            for (FieldInfo fieldInfo : fieldInfoList) {
                List plainFieldList = fieldInfo.getPlainFieldList();
                for (PlainField plainField : plainFieldList) {
                    DatasetField datasetField = new DatasetField();
                    try {
                        BeanUtils.copyProperties((Object)datasetField, (Object)plainField);
                    }
                    catch (IllegalAccessException e) {
                        CommonUtil.getStackTrace((Exception)e);
                    }
                    catch (InvocationTargetException e) {
                        CommonUtil.getStackTrace((Exception)e);
                    }
                    datasetFieldList.add(datasetField);
                }
            }
        }
        datasetMetadata.setFieldList(datasetFieldList);
        metadataQuery.setMetadata(datasetMetadata);
        return metadataQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject syncdata(DynamicObject datasetDo, String opName, String datasetName, String filterJson, int totalCount) {
        log.info("start syncdata");
        JSONObject syncdataResultJo = new JSONObject();
        int progress = 25;
        String desc = String.format("%s - \u6267\u884c\u4e2d...", opName);
        this.feedbackProgress(progress, desc, null);
        InputStream in = null;
        JSONObject fieldValueInfoJo = null;
        boolean uploadResult = false;
        long attachmentId = 0L;
        try {
            String fileName = String.format("%s.csv", ID.genLongId());
            DynamicObject dataSourceDo = datasetDo.getDynamicObject("datasource");
            Object dataSourceId = dataSourceDo.getPkValue();
            DynamicObject dataSourceDetailDo = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)IdsFormIdEnum.IDS_GPE_DATASOURCE.getId());
            String type = dataSourceDetailDo.getString("type");
            DynamicObject dataSourceAttachmentDo = dataSourceDetailDo.getDynamicObject("attachmentid");
            fieldValueInfoJo = new JSONObject();
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.CSV.getId())) {
                if (dataSourceAttachmentDo != null) {
                    IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
                    AttachmentFileInfo attachmentFileInfo = AttachmentTools.getAttachmentInfo((Long)dataSourceAttachmentDo.getPkValue(), idsParameter.getCosmicProxyIp());
                    fileName = attachmentFileInfo.getFileName();
                    in = attachmentFileInfo.getInputStream();
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.BIZOBJ.getId())) {
                String splitChar = datasetDo.getString("splitchar");
                String metadataStr = datasetDo.getString("metadata_tag");
                if (StringUtils.isNotEmpty((CharSequence)metadataStr)) {
                    DataSourceMetadata metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class);
                    List fieldInfoList = metadata.getFieldInfoList();
                    StringBuilder contentSb = new StringBuilder();
                    char split = splitChar.charAt(0);
                    if (StringUtils.equalsIgnoreCase((CharSequence)splitChar, (CharSequence)"\\u0001")) {
                        split = '\u0001';
                    }
                    for (FieldInfo fieldInfo : fieldInfoList) {
                        List plainFieldList = fieldInfo.getPlainFieldList();
                        for (PlainField plainField : plainFieldList) {
                            String fieldValue = plainField.getFieldKey();
                            if (StringUtils.isEmpty((CharSequence)contentSb)) {
                                contentSb.append(fieldValue);
                                continue;
                            }
                            contentSb.append(split).append(fieldValue);
                        }
                        contentSb.append(System.lineSeparator());
                        List fieldIdList = plainFieldList.stream().map(PlainField::getFieldId).collect(Collectors.toList());
                        if (!fieldIdList.contains("id")) {
                            fieldIdList.add(0, "id");
                        }
                        String selectFields = StringUtils.join(fieldIdList, (String)",");
                        String entityNumber = fieldInfo.getEntityNumber();
                        QFilter syncQFilter = null;
                        if (StringUtils.isNotEmpty((CharSequence)filterJson)) {
                            syncQFilter = EntityUtils.transFilterJson2QFilter((String)entityNumber, (String)filterJson);
                        }
                        long orgId = OrgUnitServiceHelper.getOrgService().getRootOrgId();
                        IdsParameter idsParameter = ((IIdsParameterService)Services.get(IIdsParameterService.class)).getIdsParameter(Long.valueOf(orgId));
                        if (totalCount > idsParameter.getMaxRowCount()) {
                            totalCount = idsParameter.getMaxRowCount();
                        }
                        Object minPkValue = null;
                        int tempPages = totalCount / 100000;
                        int pages = totalCount % 100000 == 0 ? tempPages : tempPages + 1;
                        log.info("[total]syncdata from {} with pages:{}, totalCount:{}", new Object[]{entityNumber, pages, totalCount});
                        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
                            QFilter[] qFilters;
                            DynamicObjectCollection lineDoc;
                            log.info("[page]syncdata from {} with pages:{}/{}, totalCount:{}, minPkValue:{}", new Object[]{entityNumber, pageIndex + 1, pages, totalCount, minPkValue});
                            QFilter qFilter = null;
                            if (minPkValue != null) {
                                qFilter = new QFilter("id", "<", minPkValue);
                            }
                            if (syncQFilter != null) {
                                qFilter = qFilter != null ? qFilter.and(syncQFilter) : syncQFilter;
                            }
                            if ((lineDoc = QueryServiceHelper.query((String)entityNumber, (String)selectFields, (QFilter[])(qFilters = qFilter != null ? qFilter.toArray() : null), (String)String.format("%s desc", "id"), (int)100000)) == null || lineDoc.size() <= 0) continue;
                            for (int i = 0; i < lineDoc.size(); ++i) {
                                DynamicObject lineDo = (DynamicObject)lineDoc.get(i);
                                if (i == lineDoc.size() - 1) {
                                    minPkValue = lineDo.get("id");
                                }
                                StringBuilder lineSb = new StringBuilder();
                                for (PlainField plainField : plainFieldList) {
                                    String fieldValueStr;
                                    String fieldKey = plainField.getFieldKey();
                                    String fieldId = plainField.getFieldId();
                                    Object fieldValue = lineDo.get(fieldId);
                                    String string = fieldValueStr = fieldValue != null ? fieldValue.toString() : "";
                                    if (fieldValue != null && StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATE.getId()) || StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATETIME.getId())) {
                                        Date dateValue = null;
                                        try {
                                            dateValue = (Date)fieldValue;
                                            if (dateValue != null) {
                                                Date oldMaxDate;
                                                String dateValueStr;
                                                fieldValueStr = dateValueStr = KDDateFormatUtils.getDateFormat().format(dateValue);
                                                String fieldMaxId = String.format("%s_%s", fieldKey, "max");
                                                String maxDateStr = dateValueStr;
                                                String oldMaxDateStr = fieldValueInfoJo.getString(fieldMaxId);
                                                if (StringUtils.isNotEmpty((CharSequence)oldMaxDateStr) && dateValue.before(oldMaxDate = KDDateUtils.parseDate((String)oldMaxDateStr))) {
                                                    maxDateStr = oldMaxDateStr;
                                                }
                                                fieldValueInfoJo.put(fieldMaxId, (Object)maxDateStr);
                                            }
                                        }
                                        catch (ClassCastException e) {
                                            log.error("maxDateStr error:" + e.getMessage(), (Throwable)e);
                                            syncdataResultJo.put("status", (Object)false);
                                            syncdataResultJo.put("failMsg", (Object)String.format("%s\u5b57\u6bb5\u65e0\u6cd5\u8f6c\u6362\u4e3a\u65e5\u671f\u7c7b\u578b", fieldKey));
                                            JSONObject jSONObject = syncdataResultJo;
                                            CommonUtil.safeClose((InputStream)in);
                                            return jSONObject;
                                        }
                                    }
                                    if (StringUtils.isEmpty((CharSequence)lineSb)) {
                                        lineSb.append(fieldValueStr);
                                        continue;
                                    }
                                    lineSb.append(split).append(fieldValueStr);
                                }
                                contentSb.append((CharSequence)lineSb);
                                if (pageIndex == pages - 1 && i == lineDoc.size() - 1) continue;
                                contentSb.append(System.lineSeparator());
                            }
                        }
                    }
                    in = IOUtils.toInputStream((String)contentSb.toString(), (Charset)Charset.forName("utf-8"));
                }
            }
            if (in != null) {
                attachmentId = ID.genLongId();
                DynamicObject attachmentDo = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId());
                CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)attachmentDo.getDataEntityType().getName(), (DynamicObject)attachmentDo, null);
                String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)attachmentDo);
                attachmentDo.set("id", (Object)attachmentId);
                attachmentDo.set("number", (Object)number);
                attachmentDo.set("name", (Object)fileName);
                attachmentDo.set("status", (Object)BillStatusEnum.AUDITED.getId());
                attachmentDo.set("enable", (Object)YesNoEnum.YES.getKeyStr());
                attachmentDo.set("masterid", (Object)attachmentId);
                attachmentDo.set("source", (Object)AttachmentSourceEnum.IDS_GPE_DATASET.getId());
                attachmentDo.set("sourceid", datasetDo.getPkValue());
                int fileSize = 0;
                try {
                    fileSize = in.available();
                    attachmentDo.set("filesize", (Object)fileSize);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachmentDo});
                    uploadResult = this.upload(attachmentDo, in, fileName);
                }
                catch (Exception e) {
                    log.error("error:" + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("syncdata error:" + e.getMessage(), (Throwable)e);
        }
        finally {
            CommonUtil.safeClose(in);
        }
        if (uploadResult) {
            DynamicObject attachmentDo = BusinessDataServiceHelper.loadSingle((Object)attachmentId, (String)IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId());
            datasetDo.set("fieldvalueinfo", (Object)fieldValueInfoJo.toJSONString());
            datasetDo.set("enable", (Object)EnableEnum.AVAIL.getKey());
            datasetDo.set("issyncdata", (Object)YesNoEnum.YES.getKey());
            datasetDo.set("attachmentid", (Object)attachmentDo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datasetDo});
            progress = 50;
            desc = String.format("%s - \u6267\u884c\u6210\u529f(%s)", opName, datasetName);
            this.feedbackProgress(progress, desc, null);
            syncdataResultJo.put("attachmentid", (Object)attachmentId);
            syncdataResultJo.put("status", (Object)true);
        } else {
            syncdataResultJo.put("status", (Object)false);
            syncdataResultJo.put("failMsg", (Object)"\u6570\u636e\u96c6\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        log.info("end syncdata");
        return syncdataResultJo;
    }

    private boolean upload(DynamicObject attachmentDo, InputStream inputStream, String fileName) {
        RequestContext rc = RequestContext.get();
        boolean uploadResult = false;
        try {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".csv")) {
                fileName = String.format("%s.csv", fileName);
            }
            String today = DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyyMMdd");
            String uploadPath = String.format("%s/%s/%s/%s/%s/%s", rc.getTenantId(), rc.getAccountId(), today, IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId(), attachmentDo.getPkValue(), fileName);
            FileService fs = FileServiceFactory.getAttachmentFileService();
            FileItem fi = new FileItem(fileName, uploadPath, inputStream);
            int size = inputStream.available();
            String path = fs.upload(fi);
            HashMap<String, Object> uploadFileMap = new HashMap<String, Object>();
            uploadFileMap.put("entityNum", attachmentDo.getDynamicObjectType().getName());
            uploadFileMap.put("billPkId", attachmentDo.get("id"));
            uploadFileMap.put("lastModified", KDDateUtils.now().getTime());
            uploadFileMap.put("name", fileName);
            uploadFileMap.put("url", uploadPath);
            uploadFileMap.put("size", size);
            uploadFileMap.put("status", "success");
            ArrayList<HashMap<String, Object>> attachments = new ArrayList<HashMap<String, Object>>();
            attachments.add(uploadFileMap);
            AttachmentServiceHelper.upload((String)attachmentDo.getDynamicObjectType().getName(), (Object)attachmentDo.getPkValue(), (String)KEY_ATTACHMENTPANELAP, attachments);
            uploadResult = true;
            log.info("\u4e0a\u4f20\u6210\u529f\uff1a" + path);
        }
        catch (Exception e) {
            uploadResult = false;
            log.error("error:" + e.getMessage(), (Throwable)e);
        }
        return uploadResult;
    }
}

