/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IGpeServerService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.tool.AttachmentTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ExecuteSchemeTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ExecuteSchemeTask.class);
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";

    public IGpeServerService gpeServerService() {
        return (IGpeServerService)Services.get(IGpeServerService.class);
    }

    private IIdsParameterService idsParameterService() {
        return (IIdsParameterService)Services.get(IIdsParameterService.class);
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        int progress = 0;
        String desc = "\u6210\u529f\u89e6\u53d1\u6267\u884c...";
        this.feedbackProgress(progress, desc, null);
        String requestId = params.get("requestId").toString();
        long predictRecordId = (Long)params.get("predictRecordId");
        DynamicObject predictRecordDo = null;
        int executeStatus = ExecuteStatusEnum.INIT.getKey();
        int errcode = BaseResult.FAIL;
        String failMsg = "";
        if (StringUtils.isNotEmpty((CharSequence)requestId)) {
            boolean needRetry = false;
            do {
                predictRecordDo = BusinessDataServiceHelper.loadSingle((Object)predictRecordId, (String)IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId());
                String executeStatusStr = predictRecordDo.getString("executestatus");
                executeStatus = Integer.parseInt(executeStatusStr);
                failMsg = predictRecordDo.getString("failmsg_tag");
                if (this.isStop() && ExecuteStatusEnum.isExecuting((String)executeStatusStr)) {
                    executeStatus = ExecuteStatusEnum.FAIL.getKey();
                    failMsg = "\u6267\u884c\u5931\u8d25 - \u4efb\u52a1\u88ab\u7ec8\u6b62";
                    break;
                }
                if (executeStatus == ExecuteStatusEnum.INIT.getKey()) {
                    needRetry = true;
                    progress = 0;
                    desc = "\u7b49\u5f85\u6267\u884c...";
                } else if (executeStatus == ExecuteStatusEnum.EXECUTING.getKey()) {
                    needRetry = true;
                    progress = 50;
                    desc = "\u6267\u884c\u4e2d...";
                } else if (executeStatus == ExecuteStatusEnum.SUCCESS.getKey()) {
                    DynamicObject attachmentDo = predictRecordDo.getDynamicObject("attachmentid");
                    if (attachmentDo != null) {
                        IdsParameter idsParameter;
                        long attachmentId = (Long)attachmentDo.getPkValue();
                        String dataSetFileUrl = AttachmentTools.getAttachmentFileUrl(attachmentId, (idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()))).getCosmicProxyIp());
                        if (StringUtils.isNotEmpty((CharSequence)dataSetFileUrl)) {
                            executeStatus = ExecuteStatusEnum.SUCCESS.getKey();
                            needRetry = false;
                            progress = 100;
                            desc = "\u6267\u884c\u6210\u529f\uff0c\u53ef\u524d\u5f80\u300c\u9884\u6d4b\u8bb0\u5f55\u300d\u4e2d\u67e5\u770b\u9884\u6d4b\u7ed3\u679c";
                            errcode = BaseResult.SUCCESS;
                        }
                    } else {
                        executeStatus = ExecuteStatusEnum.FAIL.getKey();
                        needRetry = false;
                        progress = 100;
                        failMsg = desc = "\u6267\u884c\u5931\u8d25 - \u65e0\u9884\u6d4b\u7ed3\u679c\u6587\u4ef6";
                    }
                } else if (executeStatus == ExecuteStatusEnum.FAIL.getKey()) {
                    executeStatus = ExecuteStatusEnum.FAIL.getKey();
                    needRetry = false;
                    progress = 100;
                    failMsg = desc = String.format("\u6267\u884c\u5931\u8d25 - %s", StringUtils.isNotEmpty((CharSequence)failMsg) ? failMsg : "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                this.feedbackProgress(progress, desc, null);
                if (!needRetry) continue;
                log.info("sleep 3s");
                ThreadUtils.sleep((long)3000L);
            } while (needRetry);
        }
        this.updateExecuteExtraInfo(predictRecordDo, executeStatus, failMsg);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("errcode", errcode);
        result.put("failMsg", failMsg);
        result.put("id", predictRecordId);
        this.feedbackCustomdata(result);
    }

    private void updateExecuteExtraInfo(DynamicObject predictRecordDo, int executeStatus, String failMsg) {
        if (predictRecordDo != null && (executeStatus == ExecuteStatusEnum.SUCCESS.getKey() || executeStatus == ExecuteStatusEnum.FAIL.getKey())) {
            if (executeStatus == ExecuteStatusEnum.FAIL.getKey()) {
                predictRecordDo.set("enable", (Object)EnableEnum.INVALID.getKey());
                predictRecordDo.set("failmsg", (Object)StrUtils.formatLargeTextSummary((String)failMsg));
            } else if (executeStatus == ExecuteStatusEnum.SUCCESS.getKey()) {
                predictRecordDo.set("status", (Object)BillStatusEnum.AUDITED.getId());
            }
            Date startTime = predictRecordDo.getDate("createtime");
            Date endTime = KDDateUtils.now();
            String timeConsuming = "";
            if (startTime != null) {
                timeConsuming = DateUtils.formatConsuming((Long)(endTime.getTime() - startTime.getTime()));
            }
            predictRecordDo.set("endtime", (Object)endTime);
            predictRecordDo.set("timecomsuming", (Object)timeConsuming);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{predictRecordDo});
        }
    }
}

