/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import java.util.EventObject;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeClosedEvent;
import org.apache.commons.lang3.StringUtils;

public class FilterGridFormPlugin
extends BaseFormPlugin {
    private static final String KEY_FILTERGRID = "filtergridap";
    private static final String KEY_BTN_OK = "btnok";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String btnKey = ctl.getKey();
        if (KEY_BTN_OK.equals(btnKey)) {
            FilterCondition filterCondition = this.getFilter();
            String filterStr = this.transFilterToStr(filterCondition);
            this.getCache().put("dlgResult", filterStr);
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityId = (String)fsp.getCustomParam("entityId");
        String filterJson = (String)fsp.getCustomParam("qFilter");
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            this.getView().showTipNotification("\u5b9e\u4f53\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        filterGrid.setEntityNumber(entityId);
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String filterJson = (String)fsp.getCustomParam("qFilter");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        if (StringUtils.isNotEmpty((CharSequence)filterJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        super.afterBindData(e);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private String transFilterToStr(FilterCondition filterCondition) {
        String filter = null;
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        return filter;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)this.getCache().get("dlgResult"));
    }
}

