/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.entity.model.gpe.SchemeConfig;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.gpe.DataSourceTypeEnum;
import kd.ai.ids.core.query.gpe.AttachmentFileInfo;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.utils.AlgoUtils;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.job.IdsJobForm;
import kd.ai.ids.plugin.tool.AttachmentTools;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class PredictEvaluationDlgFormPlugin
extends BaseFormPlugin {
    private static final String KEY_PREDICTRECORD = "predictrecord";
    private static final String KEY_SCHEME = "scheme";
    private static final String KEY_DATASOURCE = "datasource";
    private static final String KEY_DATASET = "dataset";
    private static final String KEY_EVALUATION_DATASET = "evaluationdataset";
    private static final String KEY_DATASOURCE_TYPE = "datasourcetype";
    private static final String KEY_EVALUATION_PERIOD = "evaluationperiod";
    private static final String KEY_EVALUATION_PERIOD_TAG = "evaluationperiod_tag";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String KEY_ALGO_KEY = "kd.ai.ids.plugin.form.gpe.PredictEvaluationDlgFormPlugin.queryEvaluationDataset";
    private static final String KEY_BTN_LOAD_EVALUATION_DS = "btn_load_evaluation_ds";
    private static final String TASK_CLOSE_BACK = "taskcloseback";
    public static final String KEY_AUTO_CLOSE = "autoClose";

    private String getEvaluationDatasetCacheId() {
        return this.getCache().get("evaluationDatasetCacheId");
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_LOAD_EVALUATION_DS});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String btnKey = ctl.getKey();
        if (KEY_BTN_OK.equals(btnKey)) {
            boolean isSame;
            String evaluationDatasetCacheId = this.getEvaluationDatasetCacheId();
            Algo algo = Algo.create((String)KEY_ALGO_KEY);
            CachedDataSet evaluationDataSet = Algo.getCacheDataSet((String)evaluationDatasetCacheId);
            DynamicObject schemeDo = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
            schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
            DynamicObject datasetDo = schemeDo.getDynamicObject(KEY_DATASET);
            DynamicObject evaluationDatasetDo = (DynamicObject)this.getModel().getValue(KEY_EVALUATION_DATASET);
            if (datasetDo != null && evaluationDatasetDo != null && !(isSame = this.datasetMetadataIsSame(datasetDo.getPkValue(), evaluationDatasetDo.getPkValue()))) {
                return;
            }
            List<String> timeValueList = this.parseEvaluationTimeValueList(algo, evaluationDataSet, schemeDo);
            if (CollectionUtils.isEmpty(timeValueList)) {
                this.getView().showTipNotification("\u8bc4\u4f30\u6570\u636e\u96c6\u65f6\u95f4\u8303\u56f4\u81f3\u5c11\u5305\u542b\u9884\u6d4b\u7ed3\u679c\u8bc4\u4f30\u5468\u671f\u4e2d\u7684\u4e00\u4e2a\u9884\u6d4b\u65e5\u671f");
                return;
            }
            DynamicObject recordDo = (DynamicObject)this.getModel().getValue(KEY_PREDICTRECORD);
            if (recordDo != null) {
                String number = recordDo.getString("number");
                Object recordId = recordDo.getPkValue();
                JSONObject dataJo = new JSONObject();
                dataJo.put("number", (Object)number);
                dataJo.put("recordId", recordId);
                dataJo.put("evaluationDatasetCacheId", (Object)evaluationDatasetCacheId);
                this.getCache().put("dlgResult", dataJo.toJSONString());
                this.getView().close();
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)btnKey, (CharSequence)KEY_BTN_LOAD_EVALUATION_DS)) {
            DynamicObject schemeDo = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
            DynamicObject predictDatasetDo = (DynamicObject)this.getModel().getValue(KEY_DATASET);
            long schemeId = (Long)schemeDo.getPkValue();
            long predictDatasetId = (Long)predictDatasetDo.getPkValue();
            this.asyncSyncDataTask(predictDatasetId, schemeId);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)this.getCache().get("dlgResult"));
    }

    private void asyncSyncDataTask(long predictDatasetId, long schemeId) {
        String opName = "\u62bd\u53d6\u8bc4\u4f30\u6570\u636e\u96c6";
        ThreadUtils.sleep((long)100L);
        RequestContext rc = RequestContext.get();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("ids");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(String.format("\u300c\u6570\u636e\u96c6\u300d%s", opName));
        jobInfo.setId(ID.genStringId());
        jobInfo.setTaskClassname("kd.ai.ids.plugin.form.gpe.SyncEvaluationDatasetTask");
        jobInfo.setRunByLang(rc.getLang());
        jobInfo.setRunByOrgId(rc.getOrgId());
        jobInfo.setRunByUserId(rc.getCurrUserId());
        jobInfo.setRunConcurrently(true);
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", predictDatasetId);
        params.put(KEY_SCHEME, schemeId);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TASK_CLOSE_BACK);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(String.format("%s\u8fdb\u5ea6", opName));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setTimeout(86400);
        jobFormInfo.setClickClassName("kd.ai.ids.plugin.form.gpe.SyncEvaluationDatasetClickTask");
        IdsJobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TASK_CLOSE_BACK)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        JSONObject dataJo;
        int errcode;
        String data;
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        Object taskinfo;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (taskinfo = (result = (Map)returnData).get("taskinfo")) != null && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotEmpty((CharSequence)(data = taskInfo.getData())) && (errcode = (dataJo = JSONObject.parseObject((String)data)).getIntValue("errcode")) == BaseResult.SUCCESS) {
            long evaluationDatasetId = dataJo.getLong("id");
            boolean syncData = dataJo.getBoolean("syncData");
            if (syncData) {
                this.getModel().setValue(KEY_EVALUATION_DATASET, (Object)evaluationDatasetId);
            }
        }
    }

    private boolean datasetMetadataIsSame(Object datasetId, Object anotherDatasetId) {
        List<PlainField> plainFieldList = this.loadPlainFieldList((Long)datasetId);
        List<PlainField> anotherPlainFieldList = this.loadPlainFieldList((Long)anotherDatasetId);
        String plainFieldKeys = StringUtils.join((Iterable)plainFieldList.stream().map(PlainField::getFieldKey).collect(Collectors.toList()), (String)",");
        String anotherPlainFieldKeys = StringUtils.join((Iterable)anotherPlainFieldList.stream().map(PlainField::getFieldKey).collect(Collectors.toList()), (String)",");
        String plainFieldRoles = StringUtils.join((Iterable)plainFieldList.stream().map(PlainField::getFieldRole).collect(Collectors.toList()), (String)",");
        String anotherPlainFieldRoles = StringUtils.join((Iterable)anotherPlainFieldList.stream().map(PlainField::getFieldRole).collect(Collectors.toList()), (String)",");
        String plainFieldTypes = StringUtils.join((Iterable)plainFieldList.stream().map(PlainField::getFieldType).collect(Collectors.toList()), (String)",");
        String anotherPlainFieldTypes = StringUtils.join((Iterable)anotherPlainFieldList.stream().map(PlainField::getFieldType).collect(Collectors.toList()), (String)",");
        if (!StringUtils.equalsIgnoreCase((CharSequence)plainFieldKeys, (CharSequence)anotherPlainFieldKeys)) {
            this.getView().showErrorNotification("\u8bc4\u4f30\u6570\u636e\u96c6\u548c\u9884\u6d4b\u6a21\u578b\u65b9\u6848\u6570\u636e\u96c6\u5b57\u6bb5\u6807\u8bc6\u5b58\u5728\u4e0d\u4e00\u81f4");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)plainFieldRoles, (CharSequence)anotherPlainFieldRoles)) {
            this.getView().showErrorNotification("\u8bc4\u4f30\u6570\u636e\u96c6\u548c\u9884\u6d4b\u6a21\u578b\u65b9\u6848\u6570\u636e\u96c6\u5b57\u6bb5\u89d2\u8272\u5b58\u5728\u4e0d\u4e00\u81f4");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)plainFieldTypes, (CharSequence)anotherPlainFieldTypes)) {
            this.getView().showErrorNotification("\u8bc4\u4f30\u6570\u636e\u96c6\u548c\u9884\u6d4b\u6a21\u578b\u65b9\u6848\u6570\u636e\u96c6\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u5b58\u5728\u4e0d\u4e00\u81f4");
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_PREDICTRECORD)) {
            DynamicObject recordDo = (DynamicObject)changeData[0].getNewValue();
            this.initEvaluationExtraInfo(recordDo);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_DATASOURCE)) {
            DynamicObject dataSourceDo = (DynamicObject)changeData[0].getNewValue();
            String type = dataSourceDo.getString("type");
            this.initDataSourceByType(type);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_EVALUATION_DATASET)) {
            DynamicObject predictDatasetDo;
            DynamicObject evaluationDatasetDo = (DynamicObject)changeData[0].getNewValue();
            DynamicObject schemeDo = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
            if (schemeDo != null && (predictDatasetDo = (schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId())).getDynamicObject(KEY_DATASET)) != null && evaluationDatasetDo != null) {
                long evaluationDatasetId = (Long)evaluationDatasetDo.getPkValue();
                boolean isSame = this.datasetMetadataIsSame(predictDatasetDo.getPkValue(), evaluationDatasetDo.getPkValue());
                if (!isSame) {
                    this.getModel().setValue(KEY_EVALUATION_DATASET, null);
                    return;
                }
                String evaluationCacheDatasetId = this.cacheEvaluationDataSet(evaluationDatasetId);
                this.getCache().put("evaluationDatasetCacheId", evaluationCacheDatasetId);
            }
        }
    }

    private void initEvaluationExtraInfo(DynamicObject recordDo) {
        String timeGranularity;
        int predictLength;
        DynamicObject schemeDo = recordDo.getDynamicObject(KEY_SCHEME);
        this.getModel().setValue(KEY_SCHEME, (Object)schemeDo);
        if (schemeDo == null) {
            this.getView().showTipNotification("\u9884\u6d4b\u6a21\u578b\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u6362\u4e00\u4e2a\u8bd5\u8bd5\u5427\u3002");
            return;
        }
        schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
        DynamicObject datasetDo = schemeDo.getDynamicObject(KEY_DATASET);
        String predictPeroid = "[]";
        Date predictStartDate = schemeDo.getDate("predictstartdate");
        List predictPeroidList = DateUtils.calPredictPeriod((Date)predictStartDate, (int)(predictLength = schemeDo.getInt("predictlength")), (String)(timeGranularity = schemeDo.getString("timegranularity")));
        if (CollectionUtils.isNotEmpty((Collection)predictPeroidList)) {
            predictPeroid = predictPeroidList.size() == 1 ? String.format("[%s]", predictPeroidList.get(0)) : String.format("[%s ~ %s]", predictPeroidList.get(0), predictPeroidList.get(predictPeroidList.size() - 1));
        }
        datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        DynamicObject dataSourceDo = datasetDo.getDynamicObject(KEY_DATASOURCE);
        dataSourceDo = BusinessDataServiceHelper.loadSingle((Object)dataSourceDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASOURCE.getId());
        String type = dataSourceDo.getString("type");
        this.getModel().setValue(KEY_DATASOURCE, dataSourceDo.getPkValue());
        this.getModel().setValue(KEY_DATASET, datasetDo.getPkValue());
        this.getModel().setValue(KEY_EVALUATION_PERIOD, (Object)predictPeroid);
        this.getModel().setValue(KEY_EVALUATION_PERIOD_TAG, (Object)StringUtils.join((Iterable)predictPeroidList, (String)","));
        this.initDataSourceByType(type);
    }

    private void initDataSourceByType(String type) {
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.fromKey((String)type);
        String typeName = "-";
        if (dataSourceTypeEnum != null) {
            typeName = dataSourceTypeEnum.getName();
        }
        this.getModel().setValue(KEY_DATASOURCE_TYPE, (Object)typeName);
    }

    private List<String> parseEvaluationTimeValueList(Algo algo, CachedDataSet evaluationDataSet, DynamicObject schemeDo) {
        String configTag = schemeDo.getString("config_tag");
        SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)configTag, SchemeConfig.class);
        String ftimefield = schemeConfig.getFtimefield();
        ArrayList<String> timevalueList = new ArrayList<String>(3);
        DataSet dataSet = evaluationDataSet.toDataSet(algo, false);
        String executeSql = String.format("select %s group by %s", ftimefield, ftimefield);
        DataSet groupDataSet = dataSet.executeSql(executeSql);
        while (groupDataSet.hasNext()) {
            Row row = groupDataSet.next();
            Object value = row.get(ftimefield);
            String valueStr = value != null ? value.toString() : "";
            timevalueList.add(valueStr);
        }
        return timevalueList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cacheEvaluationDataSet(long datasetId) {
        String originCacheId = null;
        List<PlainField> plainFieldList = this.loadPlainFieldList(datasetId);
        if (kd.bos.util.CollectionUtils.isNotEmpty(plainFieldList)) {
            DynamicObject datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            Algo algo = Algo.create((String)KEY_ALGO_KEY);
            RowMeta rowMeta = this.assemblyRowMeta(plainFieldList);
            long attachmentId = (Long)datasetDo.getDynamicObject("attachmentid").getPkValue();
            IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
            AttachmentFileInfo datasetFileInfo = AttachmentTools.getAttachmentInfo(attachmentId, idsParameter.getCosmicProxyIp());
            boolean firstLineColName = datasetDo.getBoolean("firstlinecolname");
            String splitChar = datasetDo.getString("splitchar");
            long st1 = KDDateUtils.now().getTime();
            List lineList = null;
            if (datasetFileInfo != null) {
                InputStream inputStream = null;
                try {
                    inputStream = datasetFileInfo.getInputStream();
                    lineList = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.forName("utf-8"));
                }
                catch (Exception e) {
                    CommonUtil.getStackTrace((Exception)e);
                }
                finally {
                    CommonUtil.safeClose((InputStream)inputStream);
                }
            }
            if (lineList == null) {
                return "";
            }
            long st2 = KDDateUtils.now().getTime();
            this.log.info("st2 - st1 : {}", (Object)(st2 - st1));
            if (firstLineColName) {
                lineList = lineList.subList(1, lineList.size());
            }
            long st3 = KDDateUtils.now().getTime();
            this.log.info("st3 - st2 : {}", (Object)(st3 - st2));
            Iterator lineIterator = lineList.stream().map(s -> s.split(splitChar)).map(arr -> Arrays.stream(arr).map(String::new).toArray()).iterator();
            long st4 = KDDateUtils.now().getTime();
            this.log.info("st4 - st3 : {}", (Object)(st4 - st3));
            DataSet originDataSet = algo.createDataSet(lineIterator, rowMeta);
            originCacheId = this.filterEvaluationDataSetAndCache(originDataSet);
            long st5 = KDDateUtils.now().getTime();
            this.log.info("st5 - st4 : {}", (Object)(st5 - st4));
        }
        return originCacheId;
    }

    private String filterEvaluationDataSetAndCache(DataSet originDataSet) {
        DynamicObject schemeDo = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
        schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
        String configTag = schemeDo.getString("config_tag");
        SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)configTag, SchemeConfig.class);
        String ftimefield = schemeConfig.getFtimefield();
        Date predictStartDate = schemeDo.getDate("predictstartdate");
        int predictLength = schemeDo.getInt("predictlength");
        String timeGranularity = schemeDo.getString("timegranularity");
        List predictPeroidList = DateUtils.calPredictPeriod((Date)predictStartDate, (int)predictLength, (String)timeGranularity);
        String predictStartDateStr = (String)predictPeroidList.get(0);
        String predictEndDateStr = (String)predictPeroidList.get(predictPeroidList.size() - 1);
        String filter = String.format("%s >= TO_DATE(\"%s\", \"yyyy-MM-dd\") and %s <= TO_DATE(\"%s\", \"yyyy-MM-dd\")", ftimefield, predictStartDateStr, ftimefield, predictEndDateStr);
        DataSet filterDataSet = originDataSet.filter(filter);
        CacheHint hint = new CacheHint();
        hint.setTimeout(3600000L);
        CachedDataSet cachedOriginDataSet = filterDataSet.cache(hint);
        String originCacheId = cachedOriginDataSet.getCacheId();
        return originCacheId;
    }

    private RowMeta assemblyRowMeta(List<PlainField> plainFieldList) {
        Field[] fieldArr = new Field[plainFieldList.size()];
        for (int i = 0; i < plainFieldList.size(); ++i) {
            PlainField plainField = plainFieldList.get(i);
            DataType dataType = AlgoUtils.getAlgoDataType((String)plainField.getFieldType());
            fieldArr[i] = new Field(plainField.getFieldKey(), dataType, true);
        }
        RowMeta rowMeta = new RowMeta(fieldArr);
        return rowMeta;
    }

    private List<PlainField> loadPlainFieldList(long datasetId) {
        List fieldInfoList;
        DynamicObject datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        String metadataStr = datasetDo.getString("metadata_tag");
        DataSourceMetadata metadata = null;
        List<Object> allPlainFieldList = new ArrayList<PlainField>();
        if (StringUtils.isNotEmpty((CharSequence)metadataStr) && CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList()))) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfoList.get(0);
            allPlainFieldList = fieldInfo.getPlainFieldList();
        }
        return allPlainFieldList;
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject recordDo;
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String autoClose = (String)fsp.getCustomParam(KEY_AUTO_CLOSE);
        if (autoClose != null && Boolean.parseBoolean(autoClose)) {
            this.getView().close();
            return;
        }
        Object recordId = fsp.getCustomParam("recordId");
        if (recordId != null && (recordDo = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId())) != null) {
            this.getModel().setValue(KEY_PREDICTRECORD, (Object)recordDo);
            this.initEvaluationExtraInfo(recordDo);
        }
    }
}

