/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.entity.model.gpe.SchemeConfig;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.gpe.AlgorithmEnum;
import kd.ai.ids.core.enumtype.gpe.FieldRoleEnum;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.utils.AwsS3Utils;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.AttachmentTools;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PredictRecordFormPlugin
extends BaseFormPlugin
implements TabSelectListener {
    private static final String KEY_CSV_FIELD_ENTRYENTITY = "csvfieldentryentity";
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String FLEX_PREVIEW_CSV_DATA = "flexpreviewcsvdata";
    private static final String FLEX_PREVIEW_EMPTY = "flexpreviewempty";
    private static final String KEY_OP_RESULT_ANALYSIS = "resultanalysis";
    private static final String KEY_OP_EVALUATION = "evaluation";
    private static final String KEY_TAB_FIELD_LIST = "tabfieldlist";
    private static final String CACHE_KEY_SORTED_PLAIN_FIELD_LIST = "sortedPlainFieldList";
    private static final String KEY_TABAP = "tabap";

    private List<PlainField> getSortedPlainFieldList() {
        List<Object> plainFieldList = new ArrayList<PlainField>();
        String s = this.getCache().get(CACHE_KEY_SORTED_PLAIN_FIELD_LIST);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            plainFieldList = JSONArray.parseArray((String)s, PlainField.class);
        }
        return plainFieldList;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OP_RESULT_ANALYSIS)) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                String number = dataEntity.getString("number");
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(IdsFormIdEnum.IDS_GPE_RESULT_ANALYSIS.getId());
                fsp.setCaption(String.format("\u7ed3\u679c\u5206\u6790-%s", number));
                fsp.setCustomParam("recordId", dataEntity.getPkValue());
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(fsp);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OP_EVALUATION)) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(IdsFormIdEnum.IDS_GPE_PRE_EVALUATION.getId());
                fsp.setCustomParam("recordId", dataEntity.getPkValue());
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_OP_EVALUATION));
                StyleCss css = new StyleCss();
                css.setWidth("780px");
                css.setHeight("380px");
                fsp.getOpenStyle().setInlineStyleCss(css);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject dataJo;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_OP_EVALUATION) && returnData != null && (dataJo = JsonUtils.parseObj((Object)returnData)) != null) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(IdsFormIdEnum.IDS_GPE_RESULT_ANALYSIS.getId());
            fsp.setCaption(String.format("\u9884\u6d4b\u8bc4\u4f30-%s", dataJo.getString("number")));
            fsp.setCustomParam("recordId", (Object)dataJo.getLongValue("recordId"));
            fsp.setCustomParam("evaluationDatasetCacheId", (Object)dataJo.getString("evaluationDatasetCacheId"));
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(fsp);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void afterBindData(EventObject e) {
        DynamicObject datasetDo;
        super.afterBindData(e);
        DynamicObject predictRecordDo = this.getModel().getDataEntity(true);
        DynamicObject schemeDo = predictRecordDo.getDynamicObject("scheme");
        if (schemeDo != null && (datasetDo = (schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId())).getDynamicObject("dataset")) != null) {
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            List<PlainField> allPlainFieldList = this.loadPlainFieldList(schemeDo, datasetDo);
            this.previewData(predictRecordDo, datasetDo, allPlainFieldList);
        }
    }

    private List<PlainField> loadPlainFieldList(DynamicObject schemeDo, DynamicObject datasetDo) {
        String fconfigStr = schemeDo.getString("config_tag");
        SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigStr, SchemeConfig.class);
        String timefield = schemeConfig.getFtimefield();
        String algorithmStr = schemeDo.getString("algorithm");
        List targetFieldList = schemeConfig.getFtargetfield();
        ArrayList<String> allfieldList = new ArrayList<String>();
        allfieldList.add(timefield);
        allfieldList.addAll(targetFieldList);
        allfieldList.addAll(schemeConfig.getFpreobjfield());
        allfieldList.addAll(schemeConfig.getFdimfield());
        List algorithmList = StrUtils.splitStr2List((String)algorithmStr);
        ArrayList<PlainField> allPlainFieldList = new ArrayList<PlainField>();
        if (datasetDo != null) {
            FieldInfo fieldInfo;
            List tempAllPlainFieldList;
            List fieldInfoList;
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            String metadataStr = datasetDo.getString("metadata_tag");
            DataSourceMetadata metadata = null;
            if (StringUtils.isNotEmpty((CharSequence)metadataStr) && CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList())) && CollectionUtils.isNotEmpty((Collection)(tempAllPlainFieldList = (fieldInfo = (FieldInfo)fieldInfoList.get(0)).getPlainFieldList()))) {
                Map<String, PlainField> fieldKeyPlainFieldMap = tempAllPlainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldKey, a -> a, (k1, k2) -> k1));
                for (PlainField plainField : tempAllPlainFieldList) {
                    if (!allfieldList.contains(plainField.getFieldKey())) continue;
                    allPlainFieldList.add(plainField);
                }
                for (String targetfield : targetFieldList) {
                    PlainField targetPlainField = fieldKeyPlainFieldMap.get(targetfield);
                    for (String algorithm : algorithmList) {
                        PlainField plainField = new PlainField();
                        AlgorithmEnum algorithmEnum = AlgorithmEnum.fromKey((String)algorithm);
                        plainField.setFieldKey(String.format("%s_%s", targetfield, algorithm));
                        plainField.setDisplayName(String.format("%s_%s", targetPlainField.getDisplayName(), algorithmEnum.getName()));
                        plainField.setFieldRole(FieldRoleEnum.METRIC.getId());
                        plainField.setFieldType(targetPlainField.getFieldType());
                        allPlainFieldList.add(plainField);
                    }
                }
            }
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_CSV_FIELD_ENTRYENTITY});
        return allPlainFieldList;
    }

    private void previewData(DynamicObject predictRecordDo, DynamicObject datasetDo, List<PlainField> allPlainFieldList) {
        if (datasetDo != null && CollectionUtils.isNotEmpty(allPlainFieldList)) {
            long attachmentId = (Long)predictRecordDo.getDynamicObject("attachmentid").getPkValue();
            String splitChar = datasetDo.getString("splitchar");
            boolean firstLineColName = true;
            IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
            String attachmentFileUrl = AttachmentTools.getAttachmentFileUrl(attachmentId, idsParameter.getCosmicProxyIp());
            if (StringUtils.isNotEmpty((CharSequence)attachmentFileUrl)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PREVIEW_CSV_DATA});
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PREVIEW_EMPTY});
                String content = AwsS3Utils.readS3File((String)attachmentFileUrl);
                String[] lineArr = content.split("\\r?\\n", 102);
                JSONArray dataJa = new JSONArray();
                if (lineArr != null && lineArr.length > 0) {
                    for (int i = 0; i < lineArr.length; ++i) {
                        if (i == 0 && firstLineColName) {
                            String firstLine = lineArr[0];
                            String[] colNameArr = firstLine.split(splitChar);
                            ArrayList<PlainField> newPlainFieldList = new ArrayList<PlainField>();
                            Map<String, PlainField> plainFieldMap = allPlainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldKey, a -> a, (k1, k2) -> k1));
                            for (String colName : colNameArr) {
                                PlainField plainField = plainFieldMap.get(colName);
                                if (plainField == null) continue;
                                newPlainFieldList.add(plainField);
                            }
                            allPlainFieldList = newPlainFieldList;
                            this.getCache().put(CACHE_KEY_SORTED_PLAIN_FIELD_LIST, JSONObject.toJSONString(allPlainFieldList));
                            continue;
                        }
                        JSONObject rowJo = new JSONObject();
                        for (int j = 0; j < allPlainFieldList.size(); ++j) {
                            String fieldKey = allPlainFieldList.get(j).getFieldKey();
                            String[] split = lineArr[i].split(splitChar);
                            String fieldValue = null;
                            fieldValue = j > split.length - 1 ? null : split[j];
                            rowJo.put(fieldKey, (Object)fieldValue);
                        }
                        dataJa.add((Object)rowJo);
                        if (dataJa.size() == 100) break;
                    }
                }
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put("fields", JSONObject.toJSONString(allPlainFieldList));
                customParams.put("data", JSONObject.toJSONString((Object)dataJa));
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId(IdsFormIdEnum.IDS_GPE_PREVIEW_DATA.getId());
                formShowParameter.setCustomParams(customParams);
                formShowParameter.getOpenStyle().setTargetKey(FLEX_PREVIEW_CSV_DATA);
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                this.getView().showForm(formShowParameter);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PREVIEW_CSV_DATA});
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PREVIEW_EMPTY});
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        List<PlainField> sortedPlainFieldList;
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_FIELD_LIST) && CollectionUtils.isNotEmpty(sortedPlainFieldList = this.getSortedPlainFieldList())) {
            int colSize = sortedPlainFieldList.size();
            this.getModel().deleteEntryData(KEY_CSV_FIELD_ENTRYENTITY);
            IDataModel dataModel = this.getModel();
            dataModel.batchCreateNewEntryRow(KEY_CSV_FIELD_ENTRYENTITY, colSize);
            for (int i = 0; i < sortedPlainFieldList.size(); ++i) {
                PlainField plainField = sortedPlainFieldList.get(i);
                dataModel.setValue("csvfieldkey", (Object)plainField.getFieldKey(), i);
                dataModel.setValue("csvdisplayname", (Object)plainField.getDisplayName(), i);
                dataModel.setValue("csvfieldtype", (Object)plainField.getFieldType(), i);
                dataModel.setValue("csvfieldrole", (Object)plainField.getFieldRole(), i);
            }
        }
    }
}

