/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.utils.JsonUtils;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.Donothing;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PredictRecordListPlugin
extends AbstractListPlugin {
    private static final String KEY_TOOLBARAP = "toolbarap";
    private static final String KEY_OP_RESULT_ANALYSIS = "resultanalysis";
    private static final String KEY_OP_EVALUATION = "evaluation";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        RequestContext rc = RequestContext.get();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OP_RESULT_ANALYSIS)) {
                ListSelectedRow listFocusRow = donothing.getListFocusRow();
                String number = listFocusRow.getNumber();
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(IdsFormIdEnum.IDS_GPE_RESULT_ANALYSIS.getId());
                fsp.setCaption(String.format("\u7ed3\u679c\u5206\u6790-%s", number));
                fsp.setCustomParam("recordId", listFocusRow.getPrimaryKeyValue());
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(fsp);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OP_EVALUATION)) {
                ListSelectedRow listFocusRow = donothing.getListFocusRow();
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(IdsFormIdEnum.IDS_GPE_PRE_EVALUATION.getId());
                fsp.setCustomParam("recordId", listFocusRow.getPrimaryKeyValue());
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_OP_EVALUATION));
                StyleCss css = new StyleCss();
                css.setWidth("780px");
                css.setHeight("380px");
                fsp.getOpenStyle().setInlineStyleCss(css);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject dataJo;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_OP_EVALUATION) && returnData != null && (dataJo = JsonUtils.parseObj((Object)returnData)) != null) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(IdsFormIdEnum.IDS_GPE_RESULT_ANALYSIS.getId());
            fsp.setCaption(String.format("\u9884\u6d4b\u8bc4\u4f30-%s", dataJo.getString("number")));
            fsp.setCustomParam("recordId", (Object)dataJo.getLongValue("recordId"));
            fsp.setCustomParam("evaluationDatasetCacheId", (Object)dataJo.getString("evaluationDatasetCacheId"));
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(fsp);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List schemeFilterColumns;
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object schemeId = listShowParameter.getCustomParam("scheme");
        if (schemeId != null && CollectionUtils.isNotEmpty((Collection)(schemeFilterColumns = args.getCommonFilterColumns()))) {
            for (FilterColumn filterColumn : schemeFilterColumns) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)filterColumn.getFieldName(), (CharSequence)"scheme.number")) continue;
                filterColumn.setDefaultValue(String.valueOf(schemeId));
            }
        }
    }
}

