/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.entity.model.gpe.SchemeConfig;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.gpe.AlgorithmEnum;
import kd.ai.ids.core.enumtype.gpe.FieldRoleEnum;
import kd.ai.ids.core.enumtype.gpe.FieldTypeEnum;
import kd.ai.ids.core.query.gpe.AttachmentFileInfo;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.utils.AlgoUtils;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.AttachmentTools;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.id.ID;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ResultAnalysisFormPlugin
extends BaseFormPlugin {
    private static final String KEY_CUSTOM_CONTROL = "ai_gpe_model_analysis";
    private static final String KEY_RECORD = "record";
    private static final String KEY_SCHEME = "scheme";
    private static final String KEY_DATASET = "dataset";
    private static final String KEY_LABEL_PREFIX = "label_";
    private static final String KEY_TIMEFIELD = "timefield";
    private static final String KEY_TARGETFIELD = "targetfield";
    private static final String KEY_PREOBJFIELD = "preobjfield";
    private static final String KEY_PREDICTLENGTH = "predictlength";
    private static final String KEY_ALGORITHM = "algorithm";
    private static final String KEY_FLEX_RESULT = "flexresult";
    private static final String KEY_FLEX_EMPTY = "flexempty";
    private static final String KEY_FILTERS_CONTAINER = "filterscontainer";
    private static final String KEY_HEADAP = "headAp";
    private static final String KEY_COMBO_PREFIX = "combo_";
    private static final String KEY_MULCOMBO_PREFIX = "mulcombo_";
    private static final String KEY_MULCOMBO_TARGET_FIELD = "mulcombotargetfield";
    private static final String KEY_MULCOMBO_ALGORITHM = "mulcomboalgorithm";
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String FLEX_RESULT_DETAIL = "flexresultdetail";
    private static final String KEY_ALGO_KEY = "kd.ai.ids.plugin.form.gpe.ResultAnalysisFormPlugin.queryResultAnalysis";
    private static final String CACHE_KEY_ORIGIN_CACHE_ID = "originCacheId";

    private String getOriginCacheId() {
        return this.getCache().get(CACHE_KEY_ORIGIN_CACHE_ID);
    }

    private String getEvaluationDatasetCacheId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String evaluationDatasetCacheId = (String)fsp.getCustomParam("evaluationDatasetCacheId");
        return evaluationDatasetCacheId;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_RESET});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        long predictRecordId = (Long)fsp.getCustomParam("recordId");
        switch (evtKey) {
            case "btnrefresh": {
                this.queryResultAnalysis(predictRecordId);
                break;
            }
            case "btnreset": {
                String originCacheId = this.getOriginCacheId();
                this.initFilterAndLoadChartData(predictRecordId, originCacheId);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject recordDo;
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_RECORD) && (recordDo = (DynamicObject)changeData[0].getNewValue()) != null) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("recordId", recordDo.getPkValue());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(IdsFormIdEnum.IDS_GPE_RESULT_ANALYSIS.getId());
            formShowParameter.setCustomParams(customParams);
            formShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(formShowParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    private DynamicObject getCurrSchemeDo(long predictRecordId) {
        DynamicObject schemeDo = null;
        if (predictRecordId > 0L) {
            DynamicObject predictRecordDo = BusinessDataServiceHelper.loadSingle((Object)predictRecordId, (String)IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId());
            schemeDo = predictRecordDo.getDynamicObject(KEY_SCHEME);
            schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
        }
        return schemeDo;
    }

    private void initPredictRecordInfo(long predictRecordId) {
        DynamicObject recordDo = BusinessDataServiceHelper.loadSingle((Object)predictRecordId, (String)IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId());
        if (recordDo != null) {
            DynamicObject schemeDo = recordDo.getDynamicObject(KEY_SCHEME);
            this.getModel().setValue(KEY_RECORD, (Object)recordDo);
            this.getModel().setValue(KEY_SCHEME, (Object)schemeDo);
            this.getModel().setValue("label_dataset", (Object)schemeDo.getDynamicObject(KEY_DATASET));
            this.getModel().setValue("label_timefield", (Object)schemeDo.getString("timefieldname"));
            this.getModel().setValue("label_targetfield", (Object)schemeDo.getString("targetfieldname"));
            this.getModel().setValue("label_preobjfield", (Object)schemeDo.getString("preobjfieldname"));
            this.getModel().setValue("label_predictlength", (Object)schemeDo.getBigDecimal(KEY_PREDICTLENGTH));
            this.getModel().setValue("label_algorithm", (Object)schemeDo.getString(KEY_ALGORITHM));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_RESULT});
        FormShowParameter fsp = this.getView().getFormShowParameter();
        long predictRecordId = (Long)fsp.getCustomParam("recordId");
        FlexPanelAp dynamicPanel = this.createDynamicPanel(predictRecordId);
        Container myFldPanel = (Container)this.getView().getControl(KEY_FILTERS_CONTAINER);
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
        this.initPredictRecordInfo(predictRecordId);
        String originCacheId = this.cacheOriginDataSet(predictRecordId);
        this.getCache().put(CACHE_KEY_ORIGIN_CACHE_ID, originCacheId);
        this.initFilterAndLoadChartData(predictRecordId, originCacheId);
    }

    private void initFilterAndLoadChartData(long predictRecordId, String originCacheId) {
        Algo algo = Algo.create((String)KEY_ALGO_KEY);
        CachedDataSet originCachedDataSet = Algo.getCacheDataSet((String)originCacheId);
        this.initDimFilterOptions(predictRecordId, algo, originCachedDataSet);
        this.initPreobjFilterOptions(predictRecordId, algo, originCachedDataSet);
        this.initTargetFilterOptions(predictRecordId);
        this.initAlgorithmFilterOptions(predictRecordId);
        this.queryResultAnalysis(predictRecordId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private String getQuoteChar(String fieldType) {
        String quoteChar = "'";
        if (StringUtils.isNotEmpty((CharSequence)fieldType) && (fieldType.equalsIgnoreCase(FieldTypeEnum.INT.getId()) || fieldType.equalsIgnoreCase(FieldTypeEnum.DECIMAL.getId()) || fieldType.equalsIgnoreCase(FieldTypeEnum.LONG.getId()))) {
            quoteChar = "";
        }
        return quoteChar;
    }

    private void queryResultAnalysis(long predictRecordId) {
        String inStr;
        String quoteChar;
        List valueList;
        String valueStr;
        String controlId;
        String fieldKey;
        long st = KDDateUtils.now().getTime();
        String targetfieldStr = (String)this.getModel().getValue(KEY_MULCOMBO_TARGET_FIELD);
        String algorithmStr = (String)this.getModel().getValue(KEY_MULCOMBO_ALGORITHM);
        List selectedTargetfieldList = StrUtils.splitStr2List((String)targetfieldStr);
        List selectedAlgorithmList = StrUtils.splitStr2List((String)algorithmStr);
        List<PlainField> dimPlainFieldList = this.loadDimPlainFieldList(predictRecordId);
        List<PlainField> preobjPlainFieldList = this.loadPreobjPlainFieldList(predictRecordId);
        StringBuilder whereSql = new StringBuilder(" where 1 = 1 ");
        for (PlainField plainField : dimPlainFieldList) {
            fieldKey = plainField.getFieldKey();
            controlId = this.assemblyMulComboEditKey(fieldKey);
            valueStr = (String)this.getModel().getValue(controlId);
            valueList = StrUtils.splitStr2List((String)valueStr);
            if (!kd.bos.util.CollectionUtils.isNotEmpty((Collection)valueList)) continue;
            quoteChar = this.getQuoteChar(plainField.getFieldType());
            inStr = StrUtils.valueList2InStr((List)valueList, (String)quoteChar);
            whereSql.append(" and ").append(fieldKey).append(" in (").append(inStr).append(")");
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty(preobjPlainFieldList)) {
            for (PlainField plainField : preobjPlainFieldList) {
                fieldKey = plainField.getFieldKey();
                controlId = this.assemblyComboEditKey(fieldKey);
                valueStr = (String)this.getModel().getValue(controlId);
                valueList = StrUtils.splitStr2List((String)valueStr);
                if (!kd.bos.util.CollectionUtils.isNotEmpty((Collection)valueList)) continue;
                quoteChar = this.getQuoteChar(plainField.getFieldType());
                inStr = StrUtils.valueList2InStr((List)valueList, (String)quoteChar);
                whereSql.append(" and ").append(fieldKey).append(" in (").append(inStr).append(")");
            }
            if (kd.bos.util.CollectionUtils.isEmpty(preobjPlainFieldList)) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u9884\u6d4b\u5bf9\u8c61");
                return;
            }
        }
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)selectedTargetfieldList)) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u9884\u6d4b\u76ee\u6807");
            return;
        }
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)selectedAlgorithmList)) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u9884\u6d4b\u7b97\u6cd5");
            return;
        }
        List<PlainField> plainFieldList = this.loadPlainFieldList(predictRecordId);
        if (kd.bos.util.CollectionUtils.isNotEmpty(plainFieldList)) {
            int rowCount;
            DynamicObject schemeDo = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
            schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
            DynamicObject datasetDo = schemeDo.getDynamicObject(KEY_DATASET);
            HashMap<String, PlainField> fieldKeyPlainFieldMap = new HashMap();
            if (datasetDo != null) {
                List fieldInfoList;
                datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
                String metadataStr = datasetDo.getString("metadata_tag");
                DataSourceMetadata metadata = null;
                if (StringUtils.isNotEmpty((CharSequence)metadataStr) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList()))) {
                    FieldInfo fieldInfo = (FieldInfo)fieldInfoList.get(0);
                    List allPlainFieldList = fieldInfo.getPlainFieldList();
                    fieldKeyPlainFieldMap = allPlainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldKey, a -> a, (k1, k2) -> k1));
                }
            }
            Date predictStartDate = schemeDo.getDate("predictstartdate");
            int predictLength = schemeDo.getInt(KEY_PREDICTLENGTH);
            String timeGranularity = schemeDo.getString("timegranularity");
            List predictPeroidList = DateUtils.calPredictPeriod((Date)predictStartDate, (int)predictLength, (String)timeGranularity);
            String fconfigStr = schemeDo.getString("config_tag");
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigStr, SchemeConfig.class);
            String timefield = schemeConfig.getFtimefield();
            List ftargetfieldList = selectedTargetfieldList;
            List algorithmList = selectedAlgorithmList;
            String prevalues = "";
            for (Object ftargetfield : ftargetfieldList) {
                for (String algorithm : algorithmList) {
                    String ftargetfield_algorithm = String.format("%s_%s", ftargetfield, algorithm);
                    String sumPreValue = String.format("sum(%s) as %s, sum(%s) as %s", ftargetfield, ftargetfield, ftargetfield_algorithm, ftargetfield_algorithm);
                    if (StringUtils.isEmpty((CharSequence)prevalues)) {
                        prevalues = sumPreValue;
                        continue;
                    }
                    prevalues = String.format("%s,%s", prevalues, sumPreValue);
                }
            }
            String evaluationActvalues = "";
            for (String ftargetfield : ftargetfieldList) {
                String sumEvaluationValue = String.format("sum(%s) as %s", ftargetfield, ftargetfield);
                if (StringUtils.isEmpty((CharSequence)evaluationActvalues)) {
                    evaluationActvalues = sumEvaluationValue;
                    continue;
                }
                evaluationActvalues = String.format("%s,%s", evaluationActvalues, sumEvaluationValue);
            }
            Algo algo = Algo.create((String)KEY_ALGO_KEY);
            String originCacheId = this.getOriginCacheId();
            String evaluationCacheId = this.getEvaluationDatasetCacheId();
            CachedDataSet originCachedDataSet = Algo.getCacheDataSet((String)originCacheId);
            DataSet originDataSet = originCachedDataSet.toDataSet(algo, false);
            DataSet evaluationDataSet = null;
            if (StringUtils.isNotEmpty((CharSequence)evaluationCacheId)) {
                CachedDataSet evaluationCacahedDataSet = Algo.getCacheDataSet((String)evaluationCacheId);
                evaluationDataSet = evaluationCacahedDataSet.toDataSet(algo, false);
            }
            String executeSql = String.format("select %s,%s %s group by %s order by %s asc", timefield, prevalues, whereSql, timefield, timefield);
            DataSet sumDataSet = originDataSet.executeSql(executeSql);
            CacheHint hint = new CacheHint();
            hint.setTimeout(3600000L);
            CachedDataSet cachedDataSet = sumDataSet.cache(hint);
            CachedDataSet evaluationCachedDataSet = null;
            if (evaluationDataSet != null) {
                String executeEvaluationSql = String.format("select %s,%s %s group by %s order by %s asc", timefield, evaluationActvalues, whereSql, timefield, timefield);
                DataSet evaluationSumDataSet = evaluationDataSet.executeSql(executeEvaluationSql);
                evaluationCachedDataSet = evaluationSumDataSet.cache(hint);
            }
            if ((rowCount = cachedDataSet.getRowCount()) == 0) {
                this.showEmptyPanel();
                return;
            }
            this.assemblyDetailData(cachedDataSet, timefield, ftargetfieldList, algorithmList, fieldKeyPlainFieldMap, evaluationCachedDataSet);
            JSONArray dataJa = new JSONArray();
            for (String ftargetfield : ftargetfieldList) {
                BigDecimal evaluationActValue;
                String time;
                ArrayList<String> xList = new ArrayList<String>();
                JSONObject yJo = new JSONObject();
                PlainField targetPlainField = (PlainField)fieldKeyPlainFieldMap.get(ftargetfield);
                yJo.put("targetField", (Object)ftargetfield);
                yJo.put("targetFieldName", (Object)targetPlainField.getDisplayName());
                JSONArray actValueJa = new JSONArray();
                JSONArray preValueJa = new JSONArray();
                JSONArray evalutaionValueJa = new JSONArray();
                JSONArray evalutaionOffsetPercentJa = new JSONArray();
                HashMap<String, BigDecimal> timeEvaluationValueMap = new HashMap<String, BigDecimal>();
                HashMap algorithmValueListMap = new HashMap();
                HashMap algorithmOffsetPercentListMap = new HashMap();
                HashMap evaluationAlgorithmOffsetPercentListMap = new HashMap();
                Iterator sumIterator = cachedDataSet.iterator(0, cachedDataSet.getRowCount());
                if (evaluationCachedDataSet != null) {
                    Iterator evaluationSumIterator = evaluationCachedDataSet.iterator(0, evaluationCachedDataSet.getRowCount());
                    while (evaluationSumIterator.hasNext()) {
                        Row row = (Row)evaluationSumIterator.next();
                        time = KDDateFormatUtils.getDateFormat().format(row.getDate(timefield));
                        evaluationActValue = row.getBigDecimal(ftargetfield);
                        evaluationActValue = evaluationActValue != null && evaluationActValue.doubleValue() != 0.0 ? evaluationActValue : null;
                        timeEvaluationValueMap.put(time, evaluationActValue);
                    }
                }
                while (sumIterator.hasNext()) {
                    Row row = (Row)sumIterator.next();
                    BigDecimal actValue = row.getBigDecimal(ftargetfield);
                    time = KDDateFormatUtils.getDateFormat().format(row.getDate(timefield));
                    xList.add(time);
                    actValue = actValue != null && actValue.doubleValue() != 0.0 ? actValue : null;
                    actValueJa.add((Object)actValue);
                    evaluationActValue = (BigDecimal)timeEvaluationValueMap.get(time);
                    evalutaionValueJa.add((Object)evaluationActValue);
                    for (String algorithm : algorithmList) {
                        BigDecimal offsetValue;
                        BigDecimal offsetPercent = null;
                        BigDecimal evaluationOffsetPercent = null;
                        String colName = String.format("%s_%s", ftargetfield, algorithm);
                        BigDecimal preValue = row.getBigDecimal(colName);
                        ArrayList<BigDecimal> valueList2 = (ArrayList<BigDecimal>)algorithmValueListMap.get(algorithm);
                        ArrayList<BigDecimal> offsetPercentList = (ArrayList<BigDecimal>)algorithmOffsetPercentListMap.get(algorithm);
                        ArrayList<BigDecimal> evaluationOffsetPercentList = (ArrayList<BigDecimal>)evaluationAlgorithmOffsetPercentListMap.get(algorithm);
                        if (kd.bos.util.CollectionUtils.isEmpty((Collection)valueList2)) {
                            valueList2 = new ArrayList<BigDecimal>();
                        }
                        if (kd.bos.util.CollectionUtils.isEmpty((Collection)offsetPercentList)) {
                            offsetPercentList = new ArrayList<BigDecimal>();
                        }
                        if (kd.bos.util.CollectionUtils.isEmpty((Collection)evaluationOffsetPercentList)) {
                            evaluationOffsetPercentList = new ArrayList<BigDecimal>();
                        }
                        preValue = preValue != null && preValue.doubleValue() != 0.0 ? preValue : null;
                        valueList2.add(preValue);
                        if (actValue != null && actValue.doubleValue() != 0.0 && preValue != null && preValue.doubleValue() != 0.0) {
                            offsetValue = preValue.subtract(actValue);
                            offsetPercent = offsetValue.divide(actValue, 3, 4).multiply(new BigDecimal(100));
                            offsetPercent = offsetPercent.abs();
                        }
                        offsetPercentList.add(offsetPercent);
                        algorithmValueListMap.put(algorithm, valueList2);
                        algorithmOffsetPercentListMap.put(algorithm, offsetPercentList);
                        if (evaluationActValue != null && evaluationActValue.doubleValue() != 0.0 && preValue != null && preValue.doubleValue() != 0.0) {
                            offsetValue = preValue.subtract(evaluationActValue);
                            evaluationOffsetPercent = offsetValue.divide(evaluationActValue, 3, 4).multiply(new BigDecimal(100));
                            evaluationOffsetPercent = evaluationOffsetPercent.abs();
                        }
                        evaluationOffsetPercentList.add(evaluationOffsetPercent);
                        evaluationAlgorithmOffsetPercentListMap.put(algorithm, evaluationOffsetPercentList);
                    }
                }
                for (String algorithm : algorithmList) {
                    AlgorithmEnum algorithmEnum = AlgorithmEnum.fromKey((String)algorithm);
                    JSONObject preValueJo = new JSONObject();
                    preValueJo.put("label", (Object)algorithmEnum.getDisplayShortName());
                    preValueJo.put("type", (Object)"value");
                    preValueJo.put("algorithmId", (Object)algorithm);
                    preValueJo.put("value", algorithmValueListMap.getOrDefault(algorithm, new ArrayList()));
                    preValueJa.add((Object)preValueJo);
                    JSONObject preOffsetPercentJo = new JSONObject();
                    preOffsetPercentJo.put("label", (Object)String.format("%s\u7edd\u5bf9\u767e\u5206\u6bd4\u8bef\u5dee", algorithmEnum.getDisplayShortName()));
                    preOffsetPercentJo.put("type", (Object)"offsetPercent");
                    preOffsetPercentJo.put("algorithmId", (Object)algorithm);
                    preOffsetPercentJo.put("value", algorithmOffsetPercentListMap.getOrDefault(algorithm, new ArrayList()));
                    preValueJa.add((Object)preOffsetPercentJo);
                    if (evaluationCachedDataSet == null) continue;
                    JSONObject evaluationOffsetPercentJo = new JSONObject();
                    evaluationOffsetPercentJo.put("label", (Object)String.format("\u8bc4\u4f30-%s\u7edd\u5bf9\u767e\u5206\u6bd4\u8bef\u5dee", algorithmEnum.getDisplayShortName()));
                    evaluationOffsetPercentJo.put("type", (Object)"offsetPercent");
                    evaluationOffsetPercentJo.put("algorithmId", (Object)algorithm);
                    evaluationOffsetPercentJo.put("value", evaluationAlgorithmOffsetPercentListMap.getOrDefault(algorithm, new ArrayList()));
                    evalutaionOffsetPercentJa.add((Object)evaluationOffsetPercentJo);
                }
                JSONObject evalutaionValueJo = new JSONObject();
                evalutaionValueJo.put("label", (Object)String.format("\u8bc4\u4f30-%s", targetPlainField.getDisplayName()));
                evalutaionValueJo.put("value", (Object)evalutaionValueJa);
                yJo.put("actValue", (Object)actValueJa);
                yJo.put("evalutaionValue", (Object)evalutaionValueJo);
                yJo.put("evalutaionOffsetPercent", (Object)evalutaionOffsetPercentJa);
                yJo.put("predictPeroidList", (Object)predictPeroidList);
                yJo.put("preValue", (Object)preValueJa);
                JSONObject dataJo = new JSONObject();
                dataJo.put("title", (Object)String.format("\u9884\u6d4b\u6548\u679c - %s", targetPlainField.getDisplayName()));
                dataJo.put("uniqueId", (Object)ID.genStringId());
                dataJo.put("x", xList);
                dataJo.put("y", (Object)yJo);
                dataJa.add((Object)dataJo);
            }
            if (dataJa != null && dataJa.size() > 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_EMPTY});
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_RESULT});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_RESULT});
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_EMPTY});
            }
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("data", dataJa);
            customData.put("timestamp", KDDateUtils.now().getTime());
            customData.put("renderType", "entity");
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL);
            customControl.setData(customData);
            long et = KDDateUtils.now().getTime();
            long costTime = et - st;
            this.log.info("queryResultAnalysis costTime:{}ms", (Object)costTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cacheOriginDataSet(long predictRecordId) {
        String originCacheId = null;
        List<PlainField> plainFieldList = this.loadPlainFieldList(predictRecordId);
        if (kd.bos.util.CollectionUtils.isNotEmpty(plainFieldList)) {
            DynamicObject schemeDo = (DynamicObject)this.getModel().getValue(KEY_SCHEME);
            schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
            DynamicObject datasetDo = schemeDo.getDynamicObject(KEY_DATASET);
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            Algo algo = Algo.create((String)KEY_ALGO_KEY);
            DynamicObject predictRecordDo = BusinessDataServiceHelper.loadSingle((Object)predictRecordId, (String)IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId());
            long attachmentId = (Long)predictRecordDo.getDynamicObject("attachmentid").getPkValue();
            IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()));
            AttachmentFileInfo datasetFileInfo = AttachmentTools.getAttachmentInfo(attachmentId, idsParameter.getCosmicProxyIp());
            boolean firstLineColName = true;
            String splitChar = datasetDo.getString("splitchar");
            long st1 = KDDateUtils.now().getTime();
            List lineList = null;
            if (datasetFileInfo != null) {
                InputStream inputStream = null;
                try {
                    inputStream = datasetFileInfo.getInputStream();
                    lineList = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.forName("utf-8"));
                }
                catch (Exception e) {
                    CommonUtil.getStackTrace((Exception)e);
                }
                finally {
                    CommonUtil.safeClose((InputStream)inputStream);
                }
            }
            if (lineList == null) {
                return "";
            }
            long st2 = KDDateUtils.now().getTime();
            this.log.info("st2 - st1 : {}", (Object)(st2 - st1));
            if (firstLineColName) {
                String firstLine = (String)lineList.get(0);
                String[] colNameArr = firstLine.split(splitChar);
                ArrayList<PlainField> newPlainFieldList = new ArrayList<PlainField>();
                Map<String, PlainField> map = plainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldKey, a -> a, (k1, k2) -> k1));
                for (String colName : colNameArr) {
                    PlainField plainField = map.get(colName);
                    if (plainField == null) continue;
                    newPlainFieldList.add(plainField);
                }
                plainFieldList = newPlainFieldList;
                lineList = lineList.subList(1, lineList.size());
            }
            RowMeta rowMeta = this.assemblyRowMeta(plainFieldList);
            long st3 = KDDateUtils.now().getTime();
            this.log.info("st3 - st2 : {}", (Object)(st3 - st2));
            Iterator lineIterator = lineList.stream().map(s -> s.split(splitChar)).map(arr -> Arrays.stream(arr).map(String::new).toArray()).iterator();
            long st4 = KDDateUtils.now().getTime();
            this.log.info("st4 - st3 : {}", (Object)(st4 - st3));
            DataSet originDataSet = algo.createDataSet(lineIterator, rowMeta);
            CacheHint hint = new CacheHint();
            hint.setTimeout(3600000L);
            CachedDataSet cachedOriginDataSet = originDataSet.cache(hint);
            originCacheId = cachedOriginDataSet.getCacheId();
            long st5 = KDDateUtils.now().getTime();
            this.log.info("st5 - st4 : {}", (Object)(st5 - st4));
        }
        return originCacheId;
    }

    private void showEmptyPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_RESULT});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_EMPTY});
    }

    private void assemblyDetailData(CachedDataSet cachedDataSet, String timefield, List<String> ftargetfieldList, List<String> algorithmList, Map<String, PlainField> fieldKeyPlainFieldMap, CachedDataSet evaluationCachedDataSet) {
        String ftargetfield_algorithm;
        JSONArray detailHeaderJa = new JSONArray();
        JSONObject indicatorJo = new JSONObject();
        indicatorJo.put("id", (Object)"indicator");
        indicatorJo.put("name", (Object)"\u7edf\u8ba1\u6307\u6807");
        detailHeaderJa.add((Object)indicatorJo);
        JSONArray detailDataJa = new JSONArray();
        HashMap<String, JSONObject> algorithmValueJoMap = new HashMap<String, JSONObject>();
        HashMap<String, JSONObject> algorithmOffsetValueJoMap = new HashMap<String, JSONObject>();
        HashMap<String, JSONObject> algorithmOffsetPercentJoMap = new HashMap<String, JSONObject>();
        HashMap<String, JSONObject> evaluationAlgorithmOffsetValueJoMap = new HashMap<String, JSONObject>();
        HashMap<String, JSONObject> evaluationAlgorithmOffsetPercentJoMap = new HashMap<String, JSONObject>();
        Iterator sumDetailIterator = cachedDataSet.iterator(0, cachedDataSet.getRowCount());
        while (sumDetailIterator.hasNext()) {
            Row row = (Row)sumDetailIterator.next();
            String time = KDDateFormatUtils.getDateFormat().format(row.getDate(timefield));
            JSONObject timeJo = new JSONObject();
            timeJo.put("id", (Object)time);
            timeJo.put("name", (Object)time);
            detailHeaderJa.add((Object)timeJo);
        }
        for (String ftargetfield : ftargetfieldList) {
            BigDecimal evaluationActValue;
            JSONObject actValueJo = new JSONObject();
            PlainField targetPlainField = fieldKeyPlainFieldMap.get(ftargetfield);
            actValueJo.put("indicator", (Object)String.format("\u5b9e\u9645%s", targetPlainField.getDisplayName()));
            Iterator sumTargetDetailIterator = cachedDataSet.iterator(0, cachedDataSet.getRowCount());
            JSONObject evaluationActValueJo = new JSONObject();
            evaluationActValueJo.put("indicator", (Object)String.format("\u8bc4\u4f30-\u5b9e\u9645%s", targetPlainField.getDisplayName()));
            if (evaluationCachedDataSet != null) {
                Iterator evaluationSumIterator = evaluationCachedDataSet.iterator(0, evaluationCachedDataSet.getRowCount());
                while (evaluationSumIterator.hasNext()) {
                    Row row = (Row)evaluationSumIterator.next();
                    String time = KDDateFormatUtils.getDateFormat().format(row.getDate(timefield));
                    evaluationActValue = row.getBigDecimal(ftargetfield);
                    evaluationActValue = evaluationActValue != null && evaluationActValue.doubleValue() != 0.0 ? evaluationActValue.setScale(2, 4) : null;
                    evaluationActValueJo.put(time, (Object)evaluationActValue);
                }
            }
            while (sumTargetDetailIterator.hasNext()) {
                Row row = (Row)sumTargetDetailIterator.next();
                String time = KDDateFormatUtils.getDateFormat().format(row.getDate(timefield));
                BigDecimal actValue = row.getBigDecimal(ftargetfield);
                actValue = actValue != null && actValue.doubleValue() != 0.0 ? actValue.setScale(2, 4) : null;
                actValueJo.put(time, (Object)actValue);
                evaluationActValue = evaluationActValueJo.getBigDecimal(time);
                for (String algorithm : algorithmList) {
                    BigDecimal offsetPercent = null;
                    BigDecimal evaluationOffsetPercent = null;
                    String ftargetfield_algorithm2 = String.format("%s_%s", ftargetfield, algorithm);
                    AlgorithmEnum algorithmEnum = AlgorithmEnum.fromKey((String)algorithm);
                    String colName = String.format("%s_%s", ftargetfield, algorithm);
                    BigDecimal preValue = row.getBigDecimal(colName);
                    BigDecimal offsetValue = null;
                    BigDecimal evaluationOffsetValue = null;
                    JSONObject algorithmPreValueJo = (JSONObject)algorithmValueJoMap.get(ftargetfield_algorithm2);
                    JSONObject algorithmOffsetValueJo = (JSONObject)algorithmOffsetValueJoMap.get(ftargetfield_algorithm2);
                    JSONObject algorithmOffsetPercentJo = (JSONObject)algorithmOffsetPercentJoMap.get(ftargetfield_algorithm2);
                    JSONObject evaluationAlgorithmOffsetValueJo = (JSONObject)evaluationAlgorithmOffsetValueJoMap.get(ftargetfield_algorithm2);
                    JSONObject evaluationAlgorithmOffsetPercentJo = (JSONObject)evaluationAlgorithmOffsetPercentJoMap.get(ftargetfield_algorithm2);
                    if (actValue != null && preValue != null) {
                        offsetValue = preValue.subtract(actValue);
                        offsetValue = offsetValue.setScale(2, 4);
                        if (actValue.doubleValue() != 0.0 && preValue.doubleValue() != 0.0) {
                            offsetPercent = offsetValue.divide(actValue, 3, 4).multiply(new BigDecimal(100));
                            offsetPercent = offsetPercent.abs();
                        }
                    }
                    if (evaluationActValue != null && preValue != null) {
                        evaluationOffsetValue = preValue.subtract(evaluationActValue);
                        evaluationOffsetValue = evaluationOffsetValue.setScale(2, 4);
                        if (evaluationActValue.doubleValue() != 0.0 && preValue.doubleValue() != 0.0) {
                            evaluationOffsetPercent = evaluationOffsetValue.divide(evaluationActValue, 3, 4).multiply(new BigDecimal(100));
                            evaluationOffsetPercent = evaluationOffsetPercent.abs();
                        }
                    }
                    if (algorithmPreValueJo == null) {
                        algorithmPreValueJo = new JSONObject();
                        algorithmPreValueJo.put("indicator", (Object)String.format("%s_%s", targetPlainField.getDisplayName(), algorithmEnum.getDisplayShortName()));
                    }
                    if (algorithmOffsetValueJo == null) {
                        algorithmOffsetValueJo = new JSONObject();
                        algorithmOffsetValueJo.put("indicator", (Object)String.format("%s_%s\u7edd\u5bf9\u8bef\u5dee", targetPlainField.getDisplayName(), algorithmEnum.getDisplayShortName()));
                    }
                    if (algorithmOffsetPercentJo == null) {
                        algorithmOffsetPercentJo = new JSONObject();
                        algorithmOffsetPercentJo.put("indicator", (Object)String.format("%s_%s\u7edd\u5bf9\u767e\u5206\u6bd4\u8bef\u5dee", targetPlainField.getDisplayName(), algorithmEnum.getDisplayShortName()));
                    }
                    preValue = preValue != null && preValue.doubleValue() != 0.0 ? preValue.setScale(2, 4) : null;
                    algorithmPreValueJo.put(time, (Object)preValue);
                    algorithmValueJoMap.put(ftargetfield_algorithm2, algorithmPreValueJo);
                    algorithmOffsetValueJo.put(time, (Object)offsetValue);
                    algorithmOffsetValueJoMap.put(ftargetfield_algorithm2, algorithmOffsetValueJo);
                    algorithmOffsetPercentJo.put(time, (Object)offsetPercent);
                    algorithmOffsetPercentJoMap.put(ftargetfield_algorithm2, algorithmOffsetPercentJo);
                    if (evaluationCachedDataSet == null) continue;
                    if (evaluationAlgorithmOffsetValueJo == null) {
                        evaluationAlgorithmOffsetValueJo = new JSONObject();
                        evaluationAlgorithmOffsetValueJo.put("indicator", (Object)String.format("\u8bc4\u4f30-%s_%s\u7edd\u5bf9\u8bef\u5dee", targetPlainField.getDisplayName(), algorithmEnum.getDisplayShortName()));
                    }
                    if (evaluationAlgorithmOffsetPercentJo == null) {
                        evaluationAlgorithmOffsetPercentJo = new JSONObject();
                        evaluationAlgorithmOffsetPercentJo.put("indicator", (Object)String.format("\u8bc4\u4f30-%s_%s\u7edd\u5bf9\u767e\u5206\u6bd4\u8bef\u5dee", targetPlainField.getDisplayName(), algorithmEnum.getDisplayShortName()));
                    }
                    evaluationAlgorithmOffsetValueJo.put(time, (Object)evaluationOffsetValue);
                    evaluationAlgorithmOffsetValueJoMap.put(ftargetfield_algorithm2, evaluationAlgorithmOffsetValueJo);
                    evaluationAlgorithmOffsetPercentJo.put(time, (Object)evaluationOffsetPercent);
                    evaluationAlgorithmOffsetPercentJoMap.put(ftargetfield_algorithm2, evaluationAlgorithmOffsetPercentJo);
                }
            }
            detailDataJa.add((Object)actValueJo);
            if (evaluationCachedDataSet == null) continue;
            detailDataJa.add((Object)evaluationActValueJo);
        }
        for (String ftargetfield : ftargetfieldList) {
            for (String algorithm : algorithmList) {
                ftargetfield_algorithm = String.format("%s_%s", ftargetfield, algorithm);
                detailDataJa.add(algorithmValueJoMap.get(ftargetfield_algorithm));
            }
        }
        for (String ftargetfield : ftargetfieldList) {
            for (String algorithm : algorithmList) {
                ftargetfield_algorithm = String.format("%s_%s", ftargetfield, algorithm);
                detailDataJa.add(algorithmOffsetValueJoMap.get(ftargetfield_algorithm));
            }
        }
        for (String ftargetfield : ftargetfieldList) {
            for (String algorithm : algorithmList) {
                ftargetfield_algorithm = String.format("%s_%s", ftargetfield, algorithm);
                detailDataJa.add(algorithmOffsetPercentJoMap.get(ftargetfield_algorithm));
            }
        }
        for (String ftargetfield : ftargetfieldList) {
            for (String algorithm : algorithmList) {
                ftargetfield_algorithm = String.format("%s_%s", ftargetfield, algorithm);
                detailDataJa.add(evaluationAlgorithmOffsetValueJoMap.get(ftargetfield_algorithm));
            }
        }
        for (String ftargetfield : ftargetfieldList) {
            for (String algorithm : algorithmList) {
                ftargetfield_algorithm = String.format("%s_%s", ftargetfield, algorithm);
                detailDataJa.add(evaluationAlgorithmOffsetPercentJoMap.get(ftargetfield_algorithm));
            }
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("tableHeader", JSONObject.toJSONString((Object)detailHeaderJa));
        customParams.put("tableData", JSONObject.toJSONString((Object)detailDataJa));
        customParams.put("firstColFixed", true);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(IdsFormIdEnum.IDS_GPE_TABLE.getId());
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setTargetKey(FLEX_RESULT_DETAIL);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getView().showForm(formShowParameter);
    }

    private RowMeta assemblyRowMeta(List<PlainField> plainFieldList) {
        kd.bos.algo.Field[] fieldArr = new kd.bos.algo.Field[plainFieldList.size()];
        for (int i = 0; i < plainFieldList.size(); ++i) {
            PlainField plainField = plainFieldList.get(i);
            DataType dataType = AlgoUtils.getAlgoDataType((String)plainField.getFieldType());
            fieldArr[i] = new kd.bos.algo.Field(plainField.getFieldKey(), dataType, true);
        }
        RowMeta rowMeta = new RowMeta(fieldArr);
        return rowMeta;
    }

    private List<PlainField> loadPlainFieldList(long predictRecordId) {
        ArrayList<PlainField> allPlainFieldList = new ArrayList<PlainField>();
        DynamicObject schemeDo = this.getCurrSchemeDo(predictRecordId);
        if (schemeDo != null) {
            DynamicObject datasetDo = schemeDo.getDynamicObject(KEY_DATASET);
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            String fconfigStr = schemeDo.getString("config_tag");
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigStr, SchemeConfig.class);
            String timefield = schemeConfig.getFtimefield();
            String algorithmStr = schemeDo.getString(KEY_ALGORITHM);
            List targetFieldList = schemeConfig.getFtargetfield();
            ArrayList<String> allfieldList = new ArrayList<String>();
            allfieldList.add(timefield);
            allfieldList.addAll(targetFieldList);
            allfieldList.addAll(schemeConfig.getFpreobjfield());
            allfieldList.addAll(schemeConfig.getFdimfield());
            List algorithmList = StrUtils.splitStr2List((String)algorithmStr);
            if (datasetDo != null) {
                FieldInfo fieldInfo;
                List tempAllPlainFieldList;
                List fieldInfoList;
                datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
                String metadataStr = datasetDo.getString("metadata_tag");
                DataSourceMetadata metadata = null;
                if (StringUtils.isNotEmpty((CharSequence)metadataStr) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList())) && CollectionUtils.isNotEmpty((Collection)(tempAllPlainFieldList = (fieldInfo = (FieldInfo)fieldInfoList.get(0)).getPlainFieldList()))) {
                    Map<String, PlainField> fieldKeyPlainFieldMap = tempAllPlainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldKey, a -> a, (k1, k2) -> k1));
                    for (PlainField plainField : tempAllPlainFieldList) {
                        if (!allfieldList.contains(plainField.getFieldKey())) continue;
                        allPlainFieldList.add(plainField);
                    }
                    for (String targetfield : targetFieldList) {
                        PlainField targetPlainField = fieldKeyPlainFieldMap.get(targetfield);
                        for (String algorithm : algorithmList) {
                            PlainField plainField = new PlainField();
                            AlgorithmEnum algorithmEnum = AlgorithmEnum.fromKey((String)algorithm);
                            plainField.setFieldKey(String.format("%s_%s", targetfield, algorithm));
                            plainField.setDisplayName(String.format("%s_%s", targetPlainField.getDisplayName(), algorithmEnum.getDisplayShortName()));
                            plainField.setFieldRole(FieldRoleEnum.METRIC.getId());
                            plainField.setFieldType(targetPlainField.getFieldType());
                            allPlainFieldList.add(plainField);
                        }
                    }
                }
            }
        }
        return allPlainFieldList;
    }

    private void initDimFilterOptions(long predictRecordId, Algo algo, CachedDataSet originCachedDataSet) {
        List<PlainField> dimPlainFieldList = this.loadDimPlainFieldList(predictRecordId);
        if (kd.bos.util.CollectionUtils.isNotEmpty(dimPlainFieldList)) {
            for (PlainField plainField : dimPlainFieldList) {
                String fieldKey = plainField.getFieldKey();
                DataSet dataSet = originCachedDataSet.toDataSet(algo, false);
                String executeSql = String.format("select %s group by %s", fieldKey, fieldKey);
                DataSet groupDataSet = dataSet.executeSql(executeSql);
                String controlId = this.assemblyMulComboEditKey(plainField.getFieldKey());
                MulComboEdit mulComboEdit = (MulComboEdit)this.getControl(controlId);
                if (mulComboEdit != null) {
                    ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(3);
                    while (groupDataSet.hasNext()) {
                        Row row = groupDataSet.next();
                        Object value = row.get(fieldKey);
                        String valueStr = value != null ? value.toString() : "";
                        LocaleString comboItemText = new LocaleString(valueStr);
                        ComboItem comboItem = new ComboItem(comboItemText, valueStr);
                        comboItemList.add(comboItem);
                    }
                    mulComboEdit.setComboItems(comboItemList);
                }
                this.getModel().setValue(controlId, null);
            }
        }
    }

    private void initPreobjFilterOptions(long predictRecordId, Algo algo, CachedDataSet originCachedDataSet) {
        List<PlainField> preobjPlainFieldList = this.loadPreobjPlainFieldList(predictRecordId);
        if (kd.bos.util.CollectionUtils.isNotEmpty(preobjPlainFieldList)) {
            HashMap<String, String> fieldKeyValueMap = new HashMap<String, String>();
            DataSet tempDataSet = originCachedDataSet.toDataSet(algo, false);
            DataSet firstLineDataSet = tempDataSet.limit(0, 1);
            if (firstLineDataSet.hasNext()) {
                Row row = firstLineDataSet.next();
                for (PlainField plainField : preobjPlainFieldList) {
                    String fieldKey = plainField.getFieldKey();
                    fieldKeyValueMap.put(fieldKey, row.getString(fieldKey));
                }
            }
            for (PlainField plainField : preobjPlainFieldList) {
                String fieldKey = plainField.getFieldKey();
                DataSet dataSet = originCachedDataSet.toDataSet(algo, false);
                String executeSql = String.format("select %s group by %s", fieldKey, fieldKey);
                DataSet groupDataSet = dataSet.executeSql(executeSql);
                String controlId = this.assemblyComboEditKey(plainField.getFieldKey());
                ComboEdit comboEdit = (ComboEdit)this.getControl(controlId);
                String defaultValue = null;
                if (comboEdit != null) {
                    ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(3);
                    while (groupDataSet.hasNext()) {
                        String valueStr;
                        Row row = groupDataSet.next();
                        Object value = row.get(fieldKey);
                        String string = valueStr = value != null ? value.toString() : "";
                        if (StringUtils.isEmpty(defaultValue)) {
                            defaultValue = fieldKeyValueMap.getOrDefault(fieldKey, valueStr);
                        }
                        LocaleString comboItemText = new LocaleString(valueStr);
                        ComboItem comboItem = new ComboItem(comboItemText, valueStr);
                        comboItemList.add(comboItem);
                    }
                    comboEdit.setComboItems(comboItemList);
                }
                this.getModel().setValue(controlId, defaultValue);
            }
        }
    }

    private void initTargetFilterOptions(long predictRecordId) {
        List<PlainField> targetPlainFieldList = this.loadTargetPlainFieldList(predictRecordId);
        if (kd.bos.util.CollectionUtils.isNotEmpty(targetPlainFieldList)) {
            List idList = targetPlainFieldList.stream().map(PlainField::getFieldKey).collect(Collectors.toList());
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_MULCOMBO_TARGET_FIELD);
            if (comboEdit != null) {
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(targetPlainFieldList.size());
                for (PlainField plainField : targetPlainFieldList) {
                    LocaleString comboItemText = new LocaleString(plainField.getDisplayName());
                    ComboItem comboItem = new ComboItem(comboItemText, plainField.getFieldKey());
                    comboItemList.add(comboItem);
                }
                comboEdit.setComboItems(comboItemList);
            }
            this.getModel().setValue(KEY_MULCOMBO_TARGET_FIELD, (Object)StringUtils.join(idList, (String)","));
        }
    }

    private void initAlgorithmFilterOptions(long predictRecordId) {
        String algorithmStr;
        DynamicObject schemeDo = this.getCurrSchemeDo(predictRecordId);
        if (schemeDo != null && StringUtils.isNotEmpty((CharSequence)(algorithmStr = schemeDo.getString(KEY_ALGORITHM)))) {
            List algorithmList = StrUtils.splitStr2List((String)algorithmStr);
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_MULCOMBO_ALGORITHM);
            if (comboEdit != null) {
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(algorithmList.size());
                for (String algorithm : algorithmList) {
                    AlgorithmEnum algorithmEnum = AlgorithmEnum.fromKey((String)algorithm);
                    LocaleString comboItemText = new LocaleString(algorithmEnum.getName());
                    ComboItem comboItem = new ComboItem(comboItemText, algorithmEnum.getId());
                    comboItemList.add(comboItem);
                }
                comboEdit.setComboItems(comboItemList);
            }
            this.getModel().setValue(KEY_MULCOMBO_ALGORITHM, (Object)StringUtils.join((Iterable)algorithmList, (String)","));
        }
    }

    private List<PlainField> loadDimPlainFieldList(long predictRecordId) {
        List<Object> dimPlainFieldList = new ArrayList<PlainField>(3);
        DynamicObject schemeDo = this.getCurrSchemeDo(predictRecordId);
        if (schemeDo != null) {
            DynamicObject datasetDo = schemeDo.getDynamicObject(KEY_DATASET);
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            String fconfigStr = schemeDo.getString("config_tag");
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigStr, SchemeConfig.class);
            ArrayList allfilterList = new ArrayList();
            List fdimfieldList = schemeConfig.getFdimfield();
            allfilterList.addAll(fdimfieldList);
            if (kd.bos.util.CollectionUtils.isNotEmpty(allfilterList)) {
                FieldInfo fieldInfo;
                List allPlainFieldList;
                List fieldInfoList;
                String metadataStr = datasetDo.getString("metadata_tag");
                DataSourceMetadata metadata = null;
                if (StringUtils.isNotEmpty((CharSequence)metadataStr) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList())) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(allPlainFieldList = (fieldInfo = (FieldInfo)fieldInfoList.get(0)).getPlainFieldList()))) {
                    dimPlainFieldList = allPlainFieldList.stream().filter(e -> allfilterList.contains(e.getFieldKey())).collect(Collectors.toList());
                }
            }
        }
        return dimPlainFieldList;
    }

    private List<PlainField> loadPreobjPlainFieldList(long predictRecordId) {
        List<Object> dimPlainFieldList = new ArrayList<PlainField>(3);
        DynamicObject schemeDo = this.getCurrSchemeDo(predictRecordId);
        if (schemeDo != null) {
            DynamicObject datasetDo = schemeDo.getDynamicObject(KEY_DATASET);
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            String fconfigStr = schemeDo.getString("config_tag");
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigStr, SchemeConfig.class);
            ArrayList allfilterList = new ArrayList();
            List fpreobjfield = schemeConfig.getFpreobjfield();
            allfilterList.addAll(fpreobjfield);
            if (kd.bos.util.CollectionUtils.isNotEmpty(allfilterList)) {
                FieldInfo fieldInfo;
                List allPlainFieldList;
                List fieldInfoList;
                String metadataStr = datasetDo.getString("metadata_tag");
                DataSourceMetadata metadata = null;
                if (StringUtils.isNotEmpty((CharSequence)metadataStr) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList())) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(allPlainFieldList = (fieldInfo = (FieldInfo)fieldInfoList.get(0)).getPlainFieldList()))) {
                    dimPlainFieldList = allPlainFieldList.stream().filter(e -> allfilterList.contains(e.getFieldKey())).collect(Collectors.toList());
                }
            }
        }
        return dimPlainFieldList;
    }

    private List<PlainField> loadTargetPlainFieldList(long predictRecordId) {
        List<Object> targetPlainFieldList = new ArrayList<PlainField>(3);
        DynamicObject schemeDo = this.getCurrSchemeDo(predictRecordId);
        if (schemeDo != null) {
            DynamicObject datasetDo = schemeDo.getDynamicObject(KEY_DATASET);
            datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
            String fconfigStr = schemeDo.getString("config_tag");
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigStr, SchemeConfig.class);
            String algorithmStr = schemeDo.getString(KEY_ALGORITHM);
            List ftargetfield = schemeConfig.getFtargetfield();
            if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)ftargetfield)) {
                FieldInfo fieldInfo;
                List allPlainFieldList;
                List fieldInfoList;
                String metadataStr = datasetDo.getString("metadata_tag");
                DataSourceMetadata metadata = null;
                if (StringUtils.isNotEmpty((CharSequence)metadataStr) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList())) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(allPlainFieldList = (fieldInfo = (FieldInfo)fieldInfoList.get(0)).getPlainFieldList()))) {
                    targetPlainFieldList = allPlainFieldList.stream().filter(e -> ftargetfield.contains(e.getFieldKey())).collect(Collectors.toList());
                }
            }
        }
        return targetPlainFieldList;
    }

    private String assemblyComboEditKey(String fieldKey) {
        return KEY_COMBO_PREFIX + fieldKey;
    }

    private String assemblyMulComboEditKey(String fieldKey) {
        return KEY_MULCOMBO_PREFIX + fieldKey;
    }

    @Override
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter fsp = (FormShowParameter)e.getSource();
        long predictRecordId = (Long)fsp.getCustomParam("recordId");
        FlexPanelAp headAp = this.createDynamicPanel(predictRecordId);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", KEY_FILTERS_CONTAINER);
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)KEY_MULCOMBO_PREFIX)) {
            String mulComboEditId = key.replace(KEY_MULCOMBO_PREFIX, "");
            FormShowParameter fsp = this.getView().getFormShowParameter();
            long predictRecordId = (Long)fsp.getCustomParam("recordId");
            List<PlainField> dimPlainFieldList = this.loadDimPlainFieldList(predictRecordId);
            Optional<PlainField> first = dimPlainFieldList.stream().filter(x -> x.getFieldKey().equalsIgnoreCase(mulComboEditId)).findFirst();
            if (first.isPresent()) {
                PlainField plainField = first.get();
                String controlId = this.assemblyMulComboEditKey(plainField.getFieldKey());
                Boolean mustInput = Boolean.FALSE;
                MulComboEdit mulComboEdit = new MulComboEdit();
                mulComboEdit.setKey(controlId);
                mulComboEdit.setView(this.getView());
                mulComboEdit.setMustInput(mustInput.booleanValue());
                e.setControl((Control)mulComboEdit);
            }
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)KEY_COMBO_PREFIX)) {
            String comboEditId = key.replace(KEY_COMBO_PREFIX, "");
            FormShowParameter fsp = this.getView().getFormShowParameter();
            long predictRecordId = (Long)fsp.getCustomParam("recordId");
            List<PlainField> preobjPlainFieldList = this.loadPreobjPlainFieldList(predictRecordId);
            Optional<PlainField> first = preobjPlainFieldList.stream().filter(x -> x.getFieldKey().equalsIgnoreCase(comboEditId)).findFirst();
            if (first.isPresent()) {
                PlainField plainField = first.get();
                String controlId = this.assemblyComboEditKey(plainField.getFieldKey());
                Boolean mustInput = Boolean.TRUE;
                ComboEdit comboEdit = new ComboEdit();
                comboEdit.setKey(controlId);
                comboEdit.setView(this.getView());
                comboEdit.setMustInput(mustInput.booleanValue());
                e.setControl((Control)comboEdit);
            }
        }
    }

    private FlexPanelAp createDynamicPanel(long predictRecordId) {
        Boolean mustInput;
        String controlId;
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey(KEY_HEADAP);
        List<PlainField> dimPlainFieldList = this.loadDimPlainFieldList(predictRecordId);
        List<PlainField> preobjPlainFieldList = this.loadPreobjPlainFieldList(predictRecordId);
        if (kd.bos.util.CollectionUtils.isNotEmpty(dimPlainFieldList)) {
            for (PlainField plainField : dimPlainFieldList) {
                controlId = this.assemblyMulComboEditKey(plainField.getFieldKey());
                mustInput = Boolean.FALSE;
                FieldAp mulComboFieldAp = new FieldAp();
                mulComboFieldAp.setId(controlId);
                mulComboFieldAp.setKey(controlId);
                mulComboFieldAp.setName(new LocaleString(plainField.getDisplayName()));
                mulComboFieldAp.setBackColor("#ffffff");
                mulComboFieldAp.setFireUpdEvt(true);
                MulComboField mulComboField = new MulComboField();
                mulComboField.setId(controlId);
                mulComboField.setKey(controlId);
                mulComboField.setMustInput(mustInput.booleanValue());
                mulComboFieldAp.setField((Field)mulComboField);
                headPanelAp.getItems().add(mulComboFieldAp);
            }
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty(preobjPlainFieldList)) {
            for (PlainField plainField : preobjPlainFieldList) {
                controlId = this.assemblyComboEditKey(plainField.getFieldKey());
                mustInput = Boolean.TRUE;
                FieldAp comboFieldAp = new FieldAp();
                comboFieldAp.setId(controlId);
                comboFieldAp.setKey(controlId);
                comboFieldAp.setName(new LocaleString(plainField.getDisplayName()));
                comboFieldAp.setBackColor("#ffffff");
                comboFieldAp.setFireUpdEvt(true);
                ComboField comboField = new ComboField();
                comboField.setId(controlId);
                comboField.setKey(controlId);
                comboField.setMustInput(mustInput.booleanValue());
                comboFieldAp.setField((Field)comboField);
                headPanelAp.getItems().add(comboFieldAp);
            }
        }
        return headPanelAp;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        Boolean mustInput;
        String controlId;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        long predictRecordId = (Long)fsp.getCustomParam("recordId");
        List<PlainField> dimPlainFieldList = this.loadDimPlainFieldList(predictRecordId);
        List<PlainField> preobjPlainFieldList = this.loadPreobjPlainFieldList(predictRecordId);
        if (kd.bos.util.CollectionUtils.isNotEmpty(dimPlainFieldList)) {
            for (PlainField plainField : dimPlainFieldList) {
                controlId = this.assemblyMulComboEditKey(plainField.getFieldKey());
                mustInput = Boolean.FALSE;
                MulComboProp mulComboProp = new MulComboProp();
                mulComboProp.setName(controlId);
                mulComboProp.setDisplayName(new LocaleString(plainField.getDisplayName()));
                mulComboProp.setDbIgnore(true);
                mulComboProp.setAlias("");
                mulComboProp.setMustInput(mustInput.booleanValue());
                newMainType.registerSimpleProperty((DynamicSimpleProperty)mulComboProp);
            }
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty(preobjPlainFieldList)) {
            for (PlainField plainField : preobjPlainFieldList) {
                controlId = this.assemblyComboEditKey(plainField.getFieldKey());
                mustInput = Boolean.TRUE;
                ComboProp comboProp = new ComboProp();
                comboProp.setName(controlId);
                comboProp.setDisplayName(new LocaleString(plainField.getDisplayName()));
                comboProp.setDbIgnore(true);
                comboProp.setAlias("");
                comboProp.setMustInput(mustInput.booleanValue());
                newMainType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
            }
        }
    }

    @Override
    public void pageRelease(EventObject e) {
        super.pageRelease(e);
    }
}

