/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.entity.model.gpe.SchemeConfig;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.gpe.AlgoArimaParamEnum;
import kd.ai.ids.core.enumtype.gpe.AlgoLinearRegressionParamEnum;
import kd.ai.ids.core.enumtype.gpe.AlgoNhitsParamEnum;
import kd.ai.ids.core.enumtype.gpe.AlgoProphetParamEnum;
import kd.ai.ids.core.enumtype.gpe.AlgoTFTParamEnum;
import kd.ai.ids.core.enumtype.gpe.AlgoXGBRegressorParamEnum;
import kd.ai.ids.core.enumtype.gpe.AlgorithmEnum;
import kd.ai.ids.core.enumtype.gpe.DataSourceTypeEnum;
import kd.ai.ids.core.enumtype.gpe.FieldRoleEnum;
import kd.ai.ids.core.enumtype.gpe.TimeGranularityEnum;
import kd.ai.ids.core.query.gpe.DatasetField;
import kd.ai.ids.core.query.gpe.DatasetMetadata;
import kd.ai.ids.core.query.gpe.DatasetMetadataQuery;
import kd.ai.ids.core.query.gpe.GpeRequestContext;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.job.IdsJobForm;
import kd.ai.ids.plugin.tool.AttachmentTools;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SchemeFormPlugin
extends BaseFormPlugin {
    private static final String KEY_OP_SAVE_DS = "saveds";
    private static final String KEY_OP_EXECUTE = "execute";
    private static final String KEY_OP_PREDICT_RECORD = "predictrecord";
    private static final String CACHE_KEY_ALL_PLAINFIELD_LIST = "allPlainFieldList";
    private static final String TASK_CLOSE_BACK = "taskcloseback";
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String KEY_PREDICT_RECORD = "predictRecord";
    private static final String KEY_STATIC_PREIFX = "static_";
    private static final String KEY_TIME_VARY_PREFIX = "time_vary_";
    private static final String[] timeDataFeatureFieldArr = new String[]{"static_cats", "static_reals", "time_vary_known_cats", "time_vary_known_reals", "time_vary_unknown_cats", "time_vary_unknown_reals"};
    public static final int TFT_HIDDEN_SIZE_DEFAULT_VALUE = 16;
    public static final int NHITS_HIDDEN_SIZE_DEFAULT_VALUE = 512;

    @Override
    public void initialize() {
        super.initialize();
    }

    private List<PlainField> getAllPlainFieldList() {
        String s = this.getCache().get(CACHE_KEY_ALL_PLAINFIELD_LIST);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return JSONArray.parseArray((String)s, PlainField.class);
        }
        return new ArrayList<PlainField>();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TASK_CLOSE_BACK)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        String data;
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotEmpty((CharSequence)(data = taskInfo.getData()))) {
            JSONObject dataJo = JSONObject.parseObject((String)data);
            int errcode = dataJo.getIntValue("errcode");
            String failMsg = dataJo.getString("failMsg");
            if (errcode == BaseResult.SUCCESS) {
                long id = dataJo.getLong("id");
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(String.format("%s-%s", KEY_PREDICT_RECORD, id), (IFormPlugin)this);
                this.getView().showConfirm("\u9884\u6d4b\u6210\u529f\uff0c\u524d\u5f80\u67e5\u770b\u7ed3\u679c\u5206\u6790\uff1f", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.getView().showMessage(failMsg);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.startsWithIgnoreCase((CharSequence)callBackId, (CharSequence)KEY_PREDICT_RECORD)) {
            long id = Long.parseLong(callBackId.split("-")[1]);
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                long predictRecordId = id;
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(IdsFormIdEnum.IDS_GPE_RESULT_ANALYSIS.getId());
                fsp.setCustomParam("recordId", (Object)predictRecordId);
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(fsp);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OP_SAVE_DS)) {
                boolean isSame;
                long pkValue = (Long)this.getModel().getDataEntity(true).getPkValue();
                if (pkValue != 0L) {
                    ORM orm = ORM.create();
                    QFilter qFilter = new QFilter("scheme", "=", (Object)pkValue);
                    int count = orm.count(((Object)((Object)this)).getClass().getName(), IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId(), qFilter.toArray());
                    if (count > 0) {
                        this.getView().showTipNotification("\u201c\u9884\u6d4b\u7ed3\u679c\u201d\u7684\u5b57\u6bb5\u201c\u9884\u6d4b\u6a21\u578b\u65b9\u6848\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u4fee\u6539\u3002");
                        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_OP_SAVE_DS});
                        return;
                    }
                }
                DynamicObject dataSetDo = (DynamicObject)this.getModel().getValue("dataset");
                OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
                if ((name == null || name.isEmpty() || StringUtils.isEmpty((CharSequence)name.getLocaleValue())) && dataSetDo != null) {
                    String fname = dataSetDo.getString("name");
                    LocaleString localeName = new LocaleString(fname);
                    this.getModel().setValue("name", (Object)localeName);
                }
                DynamicObject futureDatasetDo = (DynamicObject)this.getModel().getValue("futuredataset");
                if (dataSetDo != null && futureDatasetDo != null && !(isSame = this.datasetMetadataIsSame(dataSetDo.getPkValue(), futureDatasetDo.getPkValue()))) {
                    return;
                }
                SchemeConfig schemeConfig = new SchemeConfig();
                this.assemblyBaseParams(schemeConfig);
                this.assemblyTimeSeriesFeatureParams(schemeConfig);
                JSONObject falgorithmconfigJo = new JSONObject();
                String algorithm = (String)this.getModel().getValue("algorithm");
                List<String> algorithmList = Arrays.asList(StringUtils.split((String)algorithm, (String)","));
                if (CollectionUtils.containsAny(algorithmList, (Object[])new String[]{AlgorithmEnum.ARIMA.getId()})) {
                    this.assemblyArimaParams(falgorithmconfigJo);
                }
                if (CollectionUtils.containsAny(algorithmList, (Object[])new String[]{AlgorithmEnum.PROPHET.getId()})) {
                    this.assemblyProphetParams(falgorithmconfigJo);
                }
                if (CollectionUtils.containsAny(algorithmList, (Object[])new String[]{AlgorithmEnum.LINEARREGRESSION.getId()})) {
                    this.assemblyLinearRegressionParams(falgorithmconfigJo);
                }
                if (CollectionUtils.containsAny(algorithmList, (Object[])new String[]{AlgorithmEnum.XGBREGRESSOR.getId()})) {
                    this.assemblyXGBRegressorParams(falgorithmconfigJo);
                }
                if (CollectionUtils.containsAny(algorithmList, (Object[])new String[]{AlgorithmEnum.TFT.getId()})) {
                    this.assemblyTFTParams(falgorithmconfigJo);
                }
                if (CollectionUtils.containsAny(algorithmList, (Object[])new String[]{AlgorithmEnum.NHITS.getId()})) {
                    this.assemblyNhitsParams(falgorithmconfigJo);
                }
                schemeConfig.setFalgorithm(algorithmList);
                schemeConfig.setFalgorithmconfig(falgorithmconfigJo);
                this.getModel().setValue("config", (Object)"\u65b9\u6848\u914d\u7f6e");
                this.getModel().setValue("config_tag", (Object)JSONObject.toJSONString((Object)schemeConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                this.getModel().setValue("status", (Object)BillStatusEnum.AUDITED.getId());
                this.getView().invokeOperation("save");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OP_EXECUTE)) {
                String requestId = UUID.randomUUID().toString();
                DynamicObject predictRecordDo = this.genPredictRecord(requestId);
                this.executePredict(requestId, (Long)predictRecordDo.getPkValue());
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_OP_PREDICT_RECORD)) {
                Object pkValue = this.getModel().getDataEntity(true).getPkValue();
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setFormId("bos_list");
                listShowParameter.setBillFormId(IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId());
                listShowParameter.setCustomParam("scheme", pkValue);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    private boolean datasetMetadataIsSame(Object datasetId, Object anotherDatasetId) {
        List<PlainField> plainFieldList = this.loadPlainFieldList((Long)datasetId);
        List<PlainField> anotherPlainFieldList = this.loadPlainFieldList((Long)anotherDatasetId);
        String plainFieldKeys = StringUtils.join((Iterable)plainFieldList.stream().map(PlainField::getFieldKey).collect(Collectors.toList()), (String)",");
        String anotherPlainFieldKeys = StringUtils.join((Iterable)anotherPlainFieldList.stream().map(PlainField::getFieldKey).collect(Collectors.toList()), (String)",");
        String plainFieldRoles = StringUtils.join((Iterable)plainFieldList.stream().map(PlainField::getFieldRole).collect(Collectors.toList()), (String)",");
        String anotherPlainFieldRoles = StringUtils.join((Iterable)anotherPlainFieldList.stream().map(PlainField::getFieldRole).collect(Collectors.toList()), (String)",");
        String plainFieldTypes = StringUtils.join((Iterable)plainFieldList.stream().map(PlainField::getFieldType).collect(Collectors.toList()), (String)",");
        String anotherPlainFieldTypes = StringUtils.join((Iterable)anotherPlainFieldList.stream().map(PlainField::getFieldType).collect(Collectors.toList()), (String)",");
        if (!StringUtils.equalsIgnoreCase((CharSequence)plainFieldKeys, (CharSequence)anotherPlainFieldKeys)) {
            this.getView().showErrorNotification("\u4fdd\u5b58\u5931\u8d25\uff0c\u6570\u636e\u96c6\u4e0e\u672a\u6765\u6570\u636e\u96c6\u5b57\u6bb5\u6807\u8bc6\u5b58\u5728\u4e0d\u4e00\u81f4");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)plainFieldRoles, (CharSequence)anotherPlainFieldRoles)) {
            this.getView().showErrorNotification("\u4fdd\u5b58\u5931\u8d25\uff0c\u6570\u636e\u96c6\u4e0e\u672a\u6765\u6570\u636e\u96c6\u5b57\u6bb5\u89d2\u8272\u5b58\u5728\u4e0d\u4e00\u81f4");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)plainFieldTypes, (CharSequence)anotherPlainFieldTypes)) {
            this.getView().showErrorNotification("\u4fdd\u5b58\u5931\u8d25\uff0c\u6570\u636e\u96c6\u4e0e\u672a\u6765\u6570\u636e\u96c6\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u5b58\u5728\u4e0d\u4e00\u81f4");
            return false;
        }
        return true;
    }

    private List<PlainField> loadPlainFieldList(long datasetId) {
        List fieldInfoList;
        DynamicObject datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        String metadataStr = datasetDo.getString("metadata_tag");
        DataSourceMetadata metadata = null;
        List<Object> allPlainFieldList = new ArrayList<PlainField>();
        if (StringUtils.isNotEmpty((CharSequence)metadataStr) && CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList()))) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfoList.get(0);
            allPlainFieldList = fieldInfo.getPlainFieldList();
        }
        return allPlainFieldList;
    }

    private void asyncExecuteTask(String requestId, long predictRecordId) {
        ThreadUtils.sleep((long)100L);
        RequestContext rc = RequestContext.get();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("ids");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(String.format("\u300c\u9884\u6d4b\u6a21\u578b\u65b9\u6848\u300d\u6267\u884c\u9884\u6d4b - %s", this.getModel().getDataEntity(true).getString("name")));
        jobInfo.setId(ID.genStringId());
        jobInfo.setTaskClassname("kd.ai.ids.plugin.form.gpe.ExecuteSchemeTask");
        jobInfo.setRunByLang(rc.getLang());
        jobInfo.setRunByOrgId(rc.getOrgId());
        jobInfo.setRunByUserId(rc.getCurrUserId());
        jobInfo.setRunConcurrently(true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("requestId", requestId);
        params.put("predictRecordId", predictRecordId);
        params.put("clientFullContextPath", RequestContext.get().getClientFullContextPath());
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TASK_CLOSE_BACK);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption("\u9884\u6d4b\u6267\u884c\u8fdb\u5ea6");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setTimeout(86400);
        jobFormInfo.setClickClassName("kd.ai.ids.plugin.form.gpe.ExecuteSchemeClickTask");
        IdsJobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private DynamicObject genPredictRecord(String requestId) {
        long predictRecordId = ID.genLongId();
        DynamicObject predictRecordDo = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_GPE_PREDICT_RECORD.getId());
        DynamicObject schemeDo = this.getModel().getDataEntity(true);
        predictRecordDo.set("id", (Object)predictRecordId);
        predictRecordDo.set("scheme", (Object)schemeDo);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)predictRecordDo.getDataEntityType().getName(), (DynamicObject)predictRecordDo, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)predictRecordDo);
        predictRecordDo.set("number", (Object)number);
        predictRecordDo.set("name", (Object)number.split("-", 2)[1]);
        predictRecordDo.set("executestatus", (Object)ExecuteStatusEnum.INIT.getKey());
        predictRecordDo.set("status", (Object)BillStatusEnum.STAGING.getId());
        predictRecordDo.set("enable", (Object)EnableEnum.AVAIL.getKey());
        predictRecordDo.set("creator", (Object)RequestContext.get().getCurrUserId());
        predictRecordDo.set("requestid", (Object)requestId);
        predictRecordDo.set("masterid", (Object)predictRecordId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{predictRecordDo});
        return predictRecordDo;
    }

    private void executePredict(String requestId, long predictRecordId) {
        IdsParameter idsParameter;
        String status;
        DynamicObject schemeDo = this.getModel().getDataEntity(true);
        if (schemeDo != null && (Long)schemeDo.getPkValue() > 0L && !StringUtils.equalsIgnoreCase((CharSequence)(status = schemeDo.getString("status")), (CharSequence)BillStatusEnum.AUDITED.getId())) {
            schemeDo.set("status", (Object)BillStatusEnum.AUDITED.getId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeDo});
        }
        DynamicObject datasetDo = (DynamicObject)this.getModel().getValue("dataset");
        long datasetId = (Long)datasetDo.getPkValue();
        long attachmentId = (Long)datasetDo.getDynamicObject("attachmentid").getPkValue();
        String dataSetFileUrl = AttachmentTools.getAttachmentFileUrl(attachmentId, (idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getOrgService().getRootOrgId()))).getCosmicProxyIp());
        if (StringUtils.isNotEmpty((CharSequence)dataSetFileUrl)) {
            JSONObject paramJo = new JSONObject();
            DatasetMetadataQuery datasetMetadataQuery = this.assemblyDatasetMetadataQuery(datasetId);
            JSONObject datasetJo = new JSONObject();
            datasetJo.put("dataset", (Object)datasetMetadataQuery);
            DynamicObject futureDatasetDo = (DynamicObject)this.getModel().getValue("futuredataset");
            String futureDatasetFileUrl = null;
            if (futureDatasetDo != null) {
                long futureDatasetId = (Long)futureDatasetDo.getPkValue();
                long futureAattachmentId = (Long)futureDatasetDo.getDynamicObject("attachmentid").getPkValue();
                futureDatasetFileUrl = AttachmentTools.getAttachmentFileUrl(futureAattachmentId, idsParameter.getCosmicProxyIp());
                if (StringUtils.isNotEmpty((CharSequence)futureDatasetFileUrl)) {
                    DatasetMetadataQuery futureDatasetMetadataQuery = this.assemblyDatasetMetadataQuery(futureDatasetId);
                    datasetJo.put("futureDataset", (Object)futureDatasetMetadataQuery);
                }
            }
            GpeRequestContext gpeRequestContext = new GpeRequestContext(RequestContext.get());
            String configTag = (String)this.getModel().getValue("config_tag");
            paramJo.put("dataset", (Object)dataSetFileUrl);
            paramJo.put("metadata", (Object)datasetJo);
            paramJo.put("scheme", (Object)JSONObject.parseObject((String)configTag));
            paramJo.put("predictRecordId", (Object)predictRecordId);
            paramJo.put("futureDataset", (Object)futureDatasetFileUrl);
            paramJo.put("requestId", (Object)requestId);
            CustomApiResult customApiResult = this.gpeServerService().getCustomApiResult(gpeRequestContext, "/gpes/algorithm/dataset/predict", paramJo);
            if (customApiResult.isStatus()) {
                this.asyncExecuteTask(requestId, predictRecordId);
            } else {
                this.getView().showErrorNotification(customApiResult.getMessage());
            }
        }
    }

    private DatasetMetadataQuery assemblyDatasetMetadataQuery(long datasetId) {
        DynamicObject datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        DatasetMetadataQuery metadataQuery = new DatasetMetadataQuery();
        String splitChar = datasetDo.getString("splitchar");
        char split = splitChar.charAt(0);
        if (StringUtils.equalsIgnoreCase((CharSequence)splitChar, (CharSequence)"\\u0001")) {
            split = '\u0001';
        }
        metadataQuery.setSplitchar(String.valueOf(split));
        metadataQuery.setFirstLineColName(Boolean.valueOf(datasetDo.getBoolean("firstlinecolname")));
        DatasetMetadata datasetMetadata = new DatasetMetadata();
        ArrayList<DatasetField> datasetFieldList = new ArrayList<DatasetField>();
        String metadataStr = datasetDo.getString("metadata_tag");
        if (StringUtils.isNotEmpty((CharSequence)metadataStr)) {
            DataSourceMetadata dataSourceMetadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class);
            List fieldInfoList = dataSourceMetadata.getFieldInfoList();
            for (FieldInfo fieldInfo : fieldInfoList) {
                List plainFieldList = fieldInfo.getPlainFieldList();
                for (PlainField plainField : plainFieldList) {
                    DatasetField datasetField = new DatasetField();
                    try {
                        BeanUtils.copyProperties((Object)datasetField, (Object)plainField);
                    }
                    catch (IllegalAccessException e) {
                        CommonUtil.getStackTrace((Exception)e);
                    }
                    catch (InvocationTargetException e) {
                        CommonUtil.getStackTrace((Exception)e);
                    }
                    datasetFieldList.add(datasetField);
                }
            }
        }
        datasetMetadata.setFieldList(datasetFieldList);
        metadataQuery.setMetadata(datasetMetadata);
        return metadataQuery;
    }

    private void assemblyBaseParams(SchemeConfig schemeConfig) {
        String ftimefield = (String)this.getModel().getValue("timefield");
        String ftargetfield = (String)this.getModel().getValue("targetfield");
        String fpreobjfield = (String)this.getModel().getValue("preobjfield");
        String fdimfield = (String)this.getModel().getValue("dimfield");
        BigDecimal fvalidationlength = (BigDecimal)this.getModel().getValue("validationlength");
        String ftimegranularity = (String)this.getModel().getValue("timegranularity");
        BigDecimal fpredictlength = (BigDecimal)this.getModel().getValue("predictlength");
        Date fpredictstartdate = (Date)this.getModel().getValue("predictstartdate");
        schemeConfig.setFtimefield(ftimefield);
        schemeConfig.setFtargetfield(StrUtils.splitStr2List((String)ftargetfield));
        schemeConfig.setFpreobjfield(StrUtils.splitStr2List((String)fpreobjfield));
        schemeConfig.setFdimfield(StrUtils.splitStr2List((String)fdimfield));
        schemeConfig.setFvalidationlength(Integer.valueOf(fvalidationlength.intValue()));
        schemeConfig.setFtimegranularity(ftimegranularity);
        schemeConfig.setFpredictlength(Integer.valueOf(fpredictlength.intValue()));
        schemeConfig.setFpredictstartdate(KDDateFormatUtils.getDateFormat().format(fpredictstartdate));
    }

    private void assemblyTimeSeriesFeatureParams(SchemeConfig schemeConfig) {
        String fstatic_cats = (String)this.getModel().getValue("static_cats");
        String fstatic_reals = (String)this.getModel().getValue("static_reals");
        String ftime_vary_known_cats = (String)this.getModel().getValue("time_vary_known_cats");
        String ftime_vary_known_reals = (String)this.getModel().getValue("time_vary_known_reals");
        String ftime_vary_unknown_cats = (String)this.getModel().getValue("time_vary_unknown_cats");
        String ftime_vary_unknown_reals = (String)this.getModel().getValue("time_vary_unknown_reals");
        schemeConfig.setFstatic_cats(StrUtils.splitStr2List((String)fstatic_cats));
        schemeConfig.setFstatic_reals(StrUtils.splitStr2List((String)fstatic_reals));
        schemeConfig.setFtime_vary_known_cats(StrUtils.splitStr2List((String)ftime_vary_known_cats));
        schemeConfig.setFtime_vary_known_reals(StrUtils.splitStr2List((String)ftime_vary_known_reals));
        schemeConfig.setFtime_vary_unknown_cats(StrUtils.splitStr2List((String)ftime_vary_unknown_cats));
        schemeConfig.setFtime_vary_unknown_reals(StrUtils.splitStr2List((String)ftime_vary_unknown_reals));
    }

    private void assemblyArimaParams(JSONObject falgorithmconfigJo) {
        BigDecimal arimap = (BigDecimal)this.getModel().getValue("arimap");
        BigDecimal arimad = (BigDecimal)this.getModel().getValue("arimad");
        BigDecimal arimaq = (BigDecimal)this.getModel().getValue("arimaq");
        String arimatrend = (String)this.getModel().getValue("arimatrend");
        JSONObject paramsJo = new JSONObject();
        paramsJo.put(AlgoArimaParamEnum.P.getId(), (Object)arimap);
        paramsJo.put(AlgoArimaParamEnum.D.getId(), (Object)arimad);
        paramsJo.put(AlgoArimaParamEnum.Q.getId(), (Object)arimaq);
        paramsJo.put(AlgoArimaParamEnum.TREND.getId(), (Object)arimatrend);
        falgorithmconfigJo.put(AlgorithmEnum.ARIMA.getId(), (Object)paramsJo);
    }

    private void assemblyProphetParams(JSONObject falgorithmconfigJo) {
        String phtgrowth = (String)this.getModel().getValue("phtgrowth");
        String phtyearly_seasonality = (String)this.getModel().getValue("phtyearly_seasonality");
        String phtweekly_seasonality = (String)this.getModel().getValue("phtweekly_seasonality");
        String phtdaily_seasonality = (String)this.getModel().getValue("phtdaily_seasonality");
        String phtseasonality_mode = (String)this.getModel().getValue("phtseasonality_mode");
        JSONObject paramsJo = new JSONObject();
        paramsJo.put(AlgoProphetParamEnum.GROWTH.getId(), (Object)phtgrowth);
        paramsJo.put(AlgoProphetParamEnum.YEARLY_SEASONALITY.getId(), (Object)StrUtils.str2Boolean((String)phtyearly_seasonality));
        paramsJo.put(AlgoProphetParamEnum.WEEKLY_SEASONALITY.getId(), (Object)StrUtils.str2Boolean((String)phtweekly_seasonality));
        paramsJo.put(AlgoProphetParamEnum.DAILY_SEASONALITY.getId(), (Object)StrUtils.str2Boolean((String)phtdaily_seasonality));
        paramsJo.put(AlgoProphetParamEnum.SEASONALITY_MODE.getId(), (Object)phtseasonality_mode);
        falgorithmconfigJo.put(AlgorithmEnum.PROPHET.getId(), (Object)paramsJo);
    }

    private void assemblyLinearRegressionParams(JSONObject falgorithmconfigJo) {
        String lrfit_intercept = (String)this.getModel().getValue("lrfit_intercept");
        JSONObject paramsJo = new JSONObject();
        paramsJo.put(AlgoLinearRegressionParamEnum.FIT_INTERCEPT.getId(), (Object)StrUtils.str2Boolean((String)lrfit_intercept));
        falgorithmconfigJo.put(AlgorithmEnum.LINEARREGRESSION.getId(), (Object)paramsJo);
    }

    private void assemblyXGBRegressorParams(JSONObject falgorithmconfigJo) {
        BigDecimal n_estimators = (BigDecimal)this.getModel().getValue("xgbn_estimators");
        BigDecimal max_depth = (BigDecimal)this.getModel().getValue("xgbmax_depth");
        BigDecimal max_leaves = (BigDecimal)this.getModel().getValue("xgbmax_leaves");
        String growth_policy_str = (String)this.getModel().getValue("xgbgrowth_policy");
        Integer growth_policy = Integer.parseInt(growth_policy_str);
        BigDecimal learning_rate = (BigDecimal)this.getModel().getValue("xgblearning_rate");
        String booster = (String)this.getModel().getValue("xgbbooster");
        JSONObject paramsJo = new JSONObject();
        paramsJo.put(AlgoXGBRegressorParamEnum.N_ESTIMATORS.getId(), (Object)n_estimators);
        paramsJo.put(AlgoXGBRegressorParamEnum.MAX_DEPTH.getId(), (Object)max_depth);
        paramsJo.put(AlgoXGBRegressorParamEnum.MAX_LEAVES.getId(), (Object)max_leaves);
        paramsJo.put(AlgoXGBRegressorParamEnum.GROWTH_POLICY.getId(), (Object)growth_policy);
        paramsJo.put(AlgoXGBRegressorParamEnum.LEARNING_RATE.getId(), (Object)learning_rate);
        paramsJo.put(AlgoXGBRegressorParamEnum.BOOSTER.getId(), (Object)booster);
        falgorithmconfigJo.put(AlgorithmEnum.XGBREGRESSOR.getId(), (Object)paramsJo);
    }

    private void assemblyTFTParams(JSONObject falgorithmconfigJo) {
        BigDecimal tfthidden_size = (BigDecimal)this.getModel().getValue("tfthidden_size");
        BigDecimal tftlstm_layers = (BigDecimal)this.getModel().getValue("tftlstm_layers");
        BigDecimal tftdropout = (BigDecimal)this.getModel().getValue("tftdropout");
        String tftloss = (String)this.getModel().getValue("tftloss");
        BigDecimal tftattention_head_size = (BigDecimal)this.getModel().getValue("tftattention_head_size");
        BigDecimal tftmax_encoder_length = (BigDecimal)this.getModel().getValue("tftmax_encoder_length");
        String tftx_reals_str = (String)this.getModel().getValue("tftx_reals");
        String tftx_categoricals_str = (String)this.getModel().getValue("tftx_categoricals");
        List tftx_reals = StrUtils.splitStr2List((String)tftx_reals_str);
        List tftx_categoricals = StrUtils.splitStr2List((String)tftx_categoricals_str);
        BigDecimal tfthidden_continuous_size = (BigDecimal)this.getModel().getValue("tfthidden_continuous_size");
        BigDecimal tftlearning_rate = (BigDecimal)this.getModel().getValue("tftlearning_rate");
        JSONObject paramsJo = new JSONObject();
        paramsJo.put(AlgoTFTParamEnum.HIDDEN_SIZE.getId(), (Object)tfthidden_size);
        paramsJo.put(AlgoTFTParamEnum.LSTM_LAYERS.getId(), (Object)tftlstm_layers);
        paramsJo.put(AlgoTFTParamEnum.DROPOUT.getId(), (Object)tftdropout);
        paramsJo.put(AlgoTFTParamEnum.LOSS.getId(), (Object)tftloss);
        paramsJo.put(AlgoTFTParamEnum.ATTENTION_HEAD_SIZE.getId(), (Object)tftattention_head_size);
        paramsJo.put(AlgoTFTParamEnum.MAX_ENCODER_LENGTH.getId(), (Object)tftmax_encoder_length);
        paramsJo.put(AlgoTFTParamEnum.X_REALS.getId(), (Object)tftx_reals);
        paramsJo.put(AlgoTFTParamEnum.X_CATEGORICALS.getId(), (Object)tftx_categoricals);
        paramsJo.put(AlgoTFTParamEnum.HIDDEN_CONTINUOUS_SIZE.getId(), (Object)tfthidden_continuous_size);
        paramsJo.put(AlgoTFTParamEnum.LEARNING_RATE.getId(), (Object)tftlearning_rate);
        falgorithmconfigJo.put(AlgorithmEnum.TFT.getId(), (Object)paramsJo);
    }

    private void assemblyNhitsParams(JSONObject falgorithmconfigJo) {
        BigDecimal hidden_size = (BigDecimal)this.getModel().getValue("nhitshidden_size");
        BigDecimal static_hidden_size = (BigDecimal)this.getModel().getValue("nhitsstatic_hidden_size");
        String loss = (String)this.getModel().getValue("nhitsloss");
        String shared_weights = (String)this.getModel().getValue("nhitsshared_weights");
        String naive_level = (String)this.getModel().getValue("nhitsnaive_level");
        String initialization = (String)this.getModel().getValue("nhitsinitialization");
        String pooling_mode = (String)this.getModel().getValue("nhitspooling_mode");
        String batch_normalization = (String)this.getModel().getValue("nhitsbatch_normalization");
        BigDecimal dropout = (BigDecimal)this.getModel().getValue("nhitsdropout");
        String activate = (String)this.getModel().getValue("nhitsactivate");
        String x_reals_str = (String)this.getModel().getValue("nhitsx_reals");
        String x_categoricals_str = (String)this.getModel().getValue("nhitsx_categoricals");
        List x_reals = StrUtils.splitStr2List((String)x_reals_str);
        List x_categoricals = StrUtils.splitStr2List((String)x_categoricals_str);
        BigDecimal learning_rate = (BigDecimal)this.getModel().getValue("nhitslearning_rate");
        JSONObject paramsJo = new JSONObject();
        paramsJo.put(AlgoNhitsParamEnum.HIDDEN_SIZE.getId(), (Object)hidden_size);
        paramsJo.put(AlgoNhitsParamEnum.STATIC_HIDDEN_SIZE.getId(), (Object)static_hidden_size);
        paramsJo.put(AlgoNhitsParamEnum.LOSS.getId(), (Object)loss);
        paramsJo.put(AlgoNhitsParamEnum.SHARED_WEIGHTS.getId(), (Object)StrUtils.str2Boolean((String)shared_weights));
        paramsJo.put(AlgoNhitsParamEnum.NAIVE_LEVEL.getId(), (Object)StrUtils.str2Boolean((String)naive_level));
        paramsJo.put(AlgoNhitsParamEnum.INITIALIZATION.getId(), (Object)initialization);
        paramsJo.put(AlgoNhitsParamEnum.POOLING_MODE.getId(), (Object)pooling_mode);
        paramsJo.put(AlgoNhitsParamEnum.BATCH_NORMALIZATION.getId(), (Object)StrUtils.str2Boolean((String)batch_normalization));
        paramsJo.put(AlgoNhitsParamEnum.DROPOUT.getId(), (Object)dropout);
        paramsJo.put(AlgoNhitsParamEnum.ACTIVATE.getId(), (Object)activate);
        paramsJo.put(AlgoNhitsParamEnum.X_REALS.getId(), (Object)x_reals);
        paramsJo.put(AlgoNhitsParamEnum.X_CATEGORICALS.getId(), (Object)x_categoricals);
        paramsJo.put(AlgoNhitsParamEnum.LEARNING_RATE.getId(), (Object)learning_rate);
        falgorithmconfigJo.put(AlgorithmEnum.NHITS.getId(), (Object)paramsJo);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        block8: {
            String name;
            block13: {
                block14: {
                    AlgorithmEnum[] algorithmEnums;
                    ChangeData[] changeData;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    String fieldMaxId;
                                    JSONObject fieldValueInfoJo;
                                    String dateMaxValueStr;
                                    block7: {
                                        name = e.getProperty().getName();
                                        changeData = e.getChangeSet();
                                        if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"dataset")) break block7;
                                        DynamicObject datasetDo = (DynamicObject)changeData[0].getNewValue();
                                        if (datasetDo == null) break block8;
                                        long datasetId = (Long)datasetDo.getPkValue();
                                        this.initFieldMulComboList(datasetId);
                                        this.disableNotSupportTimegranularity(datasetId);
                                        break block8;
                                    }
                                    if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"timefield")) break block9;
                                    String ftimefield = (String)changeData[0].getNewValue();
                                    String names = this.getFieldDisplayNameByKey(ftimefield);
                                    this.getModel().setValue("timefieldname", (Object)names);
                                    DynamicObject datasetDo = (DynamicObject)this.getModel().getValue("dataset");
                                    datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
                                    String fieldValueInfo = datasetDo.getString("fieldvalueinfo");
                                    if (!StringUtils.isNotEmpty((CharSequence)fieldValueInfo) || !StringUtils.isNotEmpty((CharSequence)(dateMaxValueStr = (fieldValueInfoJo = JSONObject.parseObject((String)fieldValueInfo)).getString(fieldMaxId = String.format("%s_%s", ftimefield, "max"))))) break block8;
                                    Date maxDate = KDDateUtils.parseDate((String)dateMaxValueStr);
                                    Date defaultPredictStartDate = KDDateUtils.addDays((Date)maxDate, (int)1);
                                    this.getModel().setValue("predictstartdate", (Object)defaultPredictStartDate);
                                    break block8;
                                }
                                if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"targetfield")) break block10;
                                String ftargetfield = (String)changeData[0].getNewValue();
                                String names = this.getFieldDisplayNameByKey(ftargetfield);
                                this.getModel().setValue("targetfieldname", (Object)names);
                                break block8;
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"preobjfield")) break block11;
                            String fpreobjfield = (String)changeData[0].getNewValue();
                            String names = this.getFieldDisplayNameByKey(fpreobjfield);
                            this.getModel().setValue("preobjfieldname", (Object)names);
                            this.resetDimMulComboEdit(fpreobjfield, "dimfield", null, Collections.singletonList(FieldRoleEnum.DIM.getId()));
                            break block8;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"dimfield")) break block12;
                        String fdimfield = (String)changeData[0].getNewValue();
                        String names = this.getFieldDisplayNameByKey(fdimfield);
                        this.getModel().setValue("dimfieldname", (Object)names);
                        this.resetDimMulComboEdit(fdimfield, "preobjfield", null, Collections.singletonList(FieldRoleEnum.DIM.getId()));
                        break block8;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"algorithm")) break block13;
                    String algorithm = (String)changeData[0].getNewValue();
                    if (!StringUtils.isNotEmpty((CharSequence)algorithm)) break block14;
                    String[] algorithmArr = StringUtils.split((String)algorithm, (String)",");
                    if (algorithmArr == null || algorithmArr.length <= 0) break block8;
                    List<String> selectedAlgorithmList = Arrays.asList(algorithmArr);
                    for (AlgorithmEnum algorithmEnum : algorithmEnums = AlgorithmEnum.values()) {
                        if (selectedAlgorithmList.contains(algorithmEnum.getId())) {
                            this.getView().setVisible(Boolean.TRUE, new String[]{String.format("tabpage_%s", algorithmEnum.getAbbr())});
                            continue;
                        }
                        this.getView().setVisible(Boolean.FALSE, new String[]{String.format("tabpage_%s", algorithmEnum.getAbbr())});
                    }
                    break block8;
                }
                this.setAllAlgorithmHide(null);
                break block8;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)KEY_STATIC_PREIFX) || StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)KEY_TIME_VARY_PREFIX)) {
                List<String> timeDataFeatureFieldList = Arrays.asList(timeDataFeatureFieldArr);
                ArrayList selectedValueList = new ArrayList();
                for (String timeDataFeatureField : timeDataFeatureFieldList) {
                    String valueStr = (String)this.getModel().getValue(timeDataFeatureField);
                    List valueList = StrUtils.splitStr2List((String)valueStr);
                    selectedValueList.addAll(valueList);
                }
                String selectedValueStr = "";
                if (CollectionUtils.isNotEmpty(selectedValueList)) {
                    selectedValueStr = StringUtils.join(selectedValueList, (String)",");
                }
                for (String timeDataFeatureField : timeDataFeatureFieldList) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)timeDataFeatureField)) continue;
                    String excludeValueStr = (String)this.getModel().getValue(timeDataFeatureField);
                    if (StringUtils.equalsIgnoreCase((CharSequence)timeDataFeatureField, (CharSequence)"time_vary_unknown_reals")) {
                        this.resetDimMulComboEdit(selectedValueStr, timeDataFeatureField, excludeValueStr, Arrays.asList(FieldRoleEnum.DIM.getId(), FieldRoleEnum.METRIC.getId()));
                        continue;
                    }
                    this.resetDimMulComboEdit(selectedValueStr, timeDataFeatureField, excludeValueStr, Collections.singletonList(FieldRoleEnum.DIM.getId()));
                }
            }
        }
    }

    private String getFieldDisplayNameByKey(String fieldKeys) {
        String names = "";
        if (StringUtils.isNotEmpty((CharSequence)fieldKeys)) {
            String[] fieldKeyArr;
            List<PlainField> plainFieldList = this.getAllPlainFieldList();
            for (String fieldKey : fieldKeyArr = StringUtils.split((String)fieldKeys, (String)",")) {
                Optional<PlainField> first = plainFieldList.stream().filter(e -> e.getFieldKey().equalsIgnoreCase(fieldKey)).findFirst();
                if (!first.isPresent()) continue;
                String displayName = first.get().getDisplayName();
                names = StringUtils.isNotEmpty((CharSequence)names) ? String.format("%s ; %s", names, displayName) : displayName;
            }
        }
        return names;
    }

    private void initFieldMulComboList(long datasetId) {
        List fieldInfoList;
        DynamicObject datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        String metadataStr = datasetDo.getString("metadata_tag");
        DataSourceMetadata metadata = null;
        List<Object> allPlainFieldList = new ArrayList<PlainField>();
        if (StringUtils.isNotEmpty((CharSequence)metadataStr) && CollectionUtils.isNotEmpty((Collection)(fieldInfoList = (metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class)).getFieldInfoList()))) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfoList.get(0);
            allPlainFieldList = fieldInfo.getPlainFieldList();
        }
        if (CollectionUtils.isNotEmpty(allPlainFieldList)) {
            this.getCache().put(CACHE_KEY_ALL_PLAINFIELD_LIST, JSONObject.toJSONString(allPlainFieldList));
            this.initTimeFieldComboEdit(allPlainFieldList);
            this.initMulComboEdit("targetfield", allPlainFieldList, Collections.singletonList(FieldRoleEnum.METRIC.getId()));
            this.initMulComboEdit("preobjfield", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("dimfield", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("static_cats", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("static_reals", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("time_vary_known_cats", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("time_vary_known_reals", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("time_vary_unknown_cats", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("time_vary_unknown_reals", allPlainFieldList, Arrays.asList(FieldRoleEnum.DIM.getId(), FieldRoleEnum.METRIC.getId()));
            this.initMulComboEdit("tftx_reals", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("tftx_categoricals", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("nhitsx_reals", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
            this.initMulComboEdit("nhitsx_categoricals", allPlainFieldList, Collections.singletonList(FieldRoleEnum.DIM.getId()));
        }
    }

    private void initTimeFieldComboEdit(List<PlainField> plainFieldList) {
        if (CollectionUtils.isNotEmpty(plainFieldList)) {
            plainFieldList = plainFieldList.stream().filter(e -> e.getFieldRole().equalsIgnoreCase(FieldRoleEnum.TIME.getId())).collect(Collectors.toList());
            ComboEdit comboEdit = (ComboEdit)this.getControl("timefield");
            int size = plainFieldList.size();
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(size);
            for (int i = 0; i < size; ++i) {
                PlainField plainField = (PlainField)plainFieldList.get(i);
                String name = plainField.getDisplayName();
                LocaleString comboItemText = new LocaleString(name);
                ComboItem comboItem = new ComboItem(comboItemText, plainField.getFieldKey());
                comboItemList.add(comboItem);
            }
            comboEdit.setComboItems(comboItemList);
        }
    }

    private void initMulComboEdit(String controlKey, List<PlainField> plainFieldList, List<String> fieldRoleEnumIdList) {
        if (CollectionUtils.isNotEmpty(plainFieldList)) {
            plainFieldList = plainFieldList.stream().filter(e -> fieldRoleEnumIdList.contains(e.getFieldRole())).collect(Collectors.toList());
            MulComboEdit mulComboEdit = (MulComboEdit)this.getControl(controlKey);
            int size = plainFieldList.size();
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(size);
            for (int i = 0; i < size; ++i) {
                PlainField plainField = (PlainField)plainFieldList.get(i);
                String name = plainField.getDisplayName();
                LocaleString comboItemText = new LocaleString(name);
                ComboItem comboItem = new ComboItem(comboItemText, plainField.getFieldKey());
                comboItemList.add(comboItem);
            }
            mulComboEdit.setComboItems(comboItemList);
        }
    }

    private void resetDimMulComboEdit(String changedValue, String disableTargetControlId, String excludeDiabledValue, List<String> fieldRoleEnumIdList) {
        List<Object> plainFieldList = this.getAllPlainFieldList();
        List valueList = StrUtils.splitStr2List((String)changedValue);
        List excludeValueList = StrUtils.splitStr2List((String)excludeDiabledValue);
        if (CollectionUtils.isNotEmpty(plainFieldList)) {
            plainFieldList = plainFieldList.stream().filter(e -> fieldRoleEnumIdList.contains(e.getFieldRole())).collect(Collectors.toList());
            MulComboEdit mulComboEdit = (MulComboEdit)this.getControl(disableTargetControlId);
            int size = plainFieldList.size();
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(size);
            for (int i = 0; i < size; ++i) {
                PlainField plainField = (PlainField)plainFieldList.get(i);
                String fieldKey = plainField.getFieldKey();
                String name = plainField.getDisplayName();
                LocaleString comboItemText = new LocaleString(name);
                ComboItem comboItem = new ComboItem(comboItemText, fieldKey);
                if (valueList.contains(fieldKey)) {
                    if (excludeValueList.contains(fieldKey)) {
                        comboItem.setDisable(false);
                    } else {
                        comboItem.setDisable(true);
                    }
                }
                comboItemList.add(comboItem);
            }
            mulComboEdit.setComboItems(comboItemList);
        }
    }

    private void disableNotSupportTimegranularity(long datasetId) {
        String type;
        DynamicObject dataSourceDo;
        this.getView().setEnable(Boolean.TRUE, new String[]{"timegranularity"});
        DynamicObject datasetDo = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        if (datasetDo != null && (dataSourceDo = datasetDo.getDynamicObject("datasource")) != null && StringUtils.equalsIgnoreCase((CharSequence)(type = (dataSourceDo = BusinessDataServiceHelper.loadSingle((Object)dataSourceDo.getPkValue(), (String)IdsFormIdEnum.IDS_GPE_DATASOURCE.getId())).getString("type")), (CharSequence)DataSourceTypeEnum.BIZOBJ.getId())) {
            this.getModel().setValue("timegranularity", (Object)TimeGranularityEnum.FDATE.getId());
            this.getView().setEnable(Boolean.FALSE, new String[]{"timegranularity"});
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject datasetDo = dataEntity.getDynamicObject("dataset");
        String algorithm = "";
        if (datasetDo != null) {
            this.initFieldMulComboList((Long)datasetDo.getPkValue());
            algorithm = dataEntity.getString("algorithm");
            String config = dataEntity.getString("config_tag");
            this.initSchemeConfig(config);
        }
        this.setAllAlgorithmHide(algorithm);
    }

    private void setAllAlgorithmHide(String showAlgorithms) {
        AlgorithmEnum[] algorithmEnums;
        List<Object> showAlgorithmList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)showAlgorithms)) {
            showAlgorithmList = Arrays.asList(StringUtils.split((String)showAlgorithms, (String)","));
        }
        for (AlgorithmEnum algorithmEnum : algorithmEnums = AlgorithmEnum.values()) {
            this.getView().setVisible(Boolean.valueOf(showAlgorithmList.contains(algorithmEnum.getId())), new String[]{String.format("tabpage_%s", algorithmEnum.getAbbr())});
        }
        if (!showAlgorithmList.contains(AlgorithmEnum.TFT.getId())) {
            this.getModel().setValue("tfthidden_size", (Object)16);
        }
        if (!showAlgorithmList.contains(AlgorithmEnum.NHITS.getId())) {
            this.getModel().setValue("nhitshidden_size", (Object)512);
        }
    }

    private void initSchemeConfig(String config) {
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)config, SchemeConfig.class);
            this.getModel().setValue("timefield", (Object)schemeConfig.getFtimefield());
            this.getModel().setValue("targetfield", (Object)StringUtils.join((Iterable)schemeConfig.getFtargetfield(), (String)","));
            this.getModel().setValue("preobjfield", (Object)StringUtils.join((Iterable)schemeConfig.getFpreobjfield(), (String)","));
            this.getModel().setValue("dimfield", (Object)StringUtils.join((Iterable)schemeConfig.getFdimfield(), (String)","));
            this.getModel().setValue("predictstartdate", (Object)KDDateUtils.parseDate((String)schemeConfig.getFpredictstartdate()));
            this.getModel().setValue("static_cats", (Object)StringUtils.join((Iterable)schemeConfig.getFstatic_cats(), (String)","));
            this.getModel().setValue("static_reals", (Object)StringUtils.join((Iterable)schemeConfig.getFstatic_reals(), (String)","));
            this.getModel().setValue("time_vary_known_cats", (Object)StringUtils.join((Iterable)schemeConfig.getFtime_vary_known_cats(), (String)","));
            this.getModel().setValue("time_vary_known_reals", (Object)StringUtils.join((Iterable)schemeConfig.getFtime_vary_known_reals(), (String)","));
            this.getModel().setValue("time_vary_unknown_cats", (Object)StringUtils.join((Iterable)schemeConfig.getFtime_vary_unknown_cats(), (String)","));
            this.getModel().setValue("time_vary_unknown_reals", (Object)StringUtils.join((Iterable)schemeConfig.getFtime_vary_unknown_reals(), (String)","));
            List falgorithmList = schemeConfig.getFalgorithm();
            JSONObject falgorithmconfigJo = schemeConfig.getFalgorithmconfig();
            if (CollectionUtils.isNotEmpty((Collection)falgorithmList)) {
                for (String algorithm : falgorithmList) {
                    JSONObject paramsJo = falgorithmconfigJo.getJSONObject(algorithm);
                    if (paramsJo == null) continue;
                    this.initAlgorithmParams(algorithm, paramsJo);
                }
            }
            if (falgorithmconfigJo != null) {
                JSONObject nhitsJo;
                JSONObject tftJo = falgorithmconfigJo.getJSONObject(AlgorithmEnum.TFT.getId());
                if (tftJo != null) {
                    JSONArray tftx_reals = tftJo.getJSONArray(AlgoTFTParamEnum.X_REALS.getId());
                    JSONArray tftx_categoricals = tftJo.getJSONArray(AlgoTFTParamEnum.X_CATEGORICALS.getId());
                    this.getModel().setValue("tftx_reals", (Object)StringUtils.join((Iterable)tftx_reals.toJavaList(String.class), (String)","));
                    this.getModel().setValue("tftx_categoricals", (Object)StringUtils.join((Iterable)tftx_categoricals.toJavaList(String.class), (String)","));
                }
                if ((nhitsJo = falgorithmconfigJo.getJSONObject(AlgorithmEnum.NHITS.getId())) != null) {
                    JSONArray nhitsx_reals = nhitsJo.getJSONArray(AlgoNhitsParamEnum.X_REALS.getId());
                    JSONArray nhitsx_categoricals = nhitsJo.getJSONArray(AlgoNhitsParamEnum.X_CATEGORICALS.getId());
                    this.getModel().setValue("nhitsx_reals", (Object)StringUtils.join((Iterable)nhitsx_reals.toJavaList(String.class), (String)","));
                    this.getModel().setValue("nhitsx_categoricals", (Object)StringUtils.join((Iterable)nhitsx_categoricals.toJavaList(String.class), (String)","));
                }
            }
        }
    }

    private void initAlgorithmParams(String algorithm, JSONObject paramsJo) {
        if (StringUtils.equalsIgnoreCase((CharSequence)algorithm, (CharSequence)AlgorithmEnum.ARIMA.getId())) {
            BigDecimal arimap = paramsJo.getBigDecimal(AlgoArimaParamEnum.P.getId());
            BigDecimal arimad = paramsJo.getBigDecimal(AlgoArimaParamEnum.D.getId());
            BigDecimal arimaq = paramsJo.getBigDecimal(AlgoArimaParamEnum.Q.getId());
            String arimatrend = paramsJo.getString(AlgoArimaParamEnum.TREND.getId());
            this.getModel().setValue("arimap", (Object)arimap);
            this.getModel().setValue("arimad", (Object)arimad);
            this.getModel().setValue("arimaq", (Object)arimaq);
            this.getModel().setValue("arimatrend", (Object)arimatrend);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)algorithm, (CharSequence)AlgorithmEnum.PROPHET.getId())) {
            String phtgrowth = paramsJo.getString(AlgoProphetParamEnum.GROWTH.getId());
            String phtyearly_seasonality = paramsJo.getString(AlgoProphetParamEnum.YEARLY_SEASONALITY.getId());
            String phtweekly_seasonality = paramsJo.getString(AlgoProphetParamEnum.WEEKLY_SEASONALITY.getId());
            String phtdaily_seasonality = paramsJo.getString(AlgoProphetParamEnum.DAILY_SEASONALITY.getId());
            String phtseasonality_mode = paramsJo.getString(AlgoProphetParamEnum.SEASONALITY_MODE.getId());
            this.getModel().setValue("phtgrowth", (Object)phtgrowth);
            this.getModel().setValue("phtyearly_seasonality", (Object)phtyearly_seasonality);
            this.getModel().setValue("phtweekly_seasonality", (Object)phtweekly_seasonality);
            this.getModel().setValue("phtdaily_seasonality", (Object)phtdaily_seasonality);
            this.getModel().setValue("phtseasonality_mode", (Object)phtseasonality_mode);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)algorithm, (CharSequence)AlgorithmEnum.LINEARREGRESSION.getId())) {
            String lrfit_intercept = paramsJo.getString(AlgoLinearRegressionParamEnum.FIT_INTERCEPT.getId());
            this.getModel().setValue("lrfit_intercept", (Object)lrfit_intercept);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)algorithm, (CharSequence)AlgorithmEnum.XGBREGRESSOR.getId())) {
            BigDecimal n_estimators = paramsJo.getBigDecimal(AlgoXGBRegressorParamEnum.N_ESTIMATORS.getId());
            BigDecimal max_depth = paramsJo.getBigDecimal(AlgoXGBRegressorParamEnum.MAX_DEPTH.getId());
            BigDecimal max_leaves = paramsJo.getBigDecimal(AlgoXGBRegressorParamEnum.MAX_LEAVES.getId());
            String growth_policy = paramsJo.getString(AlgoXGBRegressorParamEnum.GROWTH_POLICY.getId());
            BigDecimal learning_rate = paramsJo.getBigDecimal(AlgoXGBRegressorParamEnum.LEARNING_RATE.getId());
            String booster = paramsJo.getString(AlgoXGBRegressorParamEnum.BOOSTER.getId());
            this.getModel().setValue("xgbn_estimators", (Object)n_estimators);
            this.getModel().setValue("xgbmax_depth", (Object)max_depth);
            this.getModel().setValue("xgbmax_leaves", (Object)max_leaves);
            this.getModel().setValue("xgbgrowth_policy", (Object)growth_policy);
            this.getModel().setValue("xgblearning_rate", (Object)learning_rate);
            this.getModel().setValue("xgbbooster", (Object)booster);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)algorithm, (CharSequence)AlgorithmEnum.TFT.getId())) {
            BigDecimal tfthidden_size = paramsJo.getBigDecimal(AlgoTFTParamEnum.HIDDEN_SIZE.getId());
            BigDecimal tftlstm_layers = paramsJo.getBigDecimal(AlgoTFTParamEnum.LSTM_LAYERS.getId());
            BigDecimal tftdropout = paramsJo.getBigDecimal(AlgoTFTParamEnum.DROPOUT.getId());
            String tftloss = paramsJo.getString(AlgoTFTParamEnum.LOSS.getId());
            BigDecimal tftattention_head_size = paramsJo.getBigDecimal(AlgoTFTParamEnum.ATTENTION_HEAD_SIZE.getId());
            BigDecimal tftmax_encoder_length = paramsJo.getBigDecimal(AlgoTFTParamEnum.MAX_ENCODER_LENGTH.getId());
            JSONArray tftx_realsJa = paramsJo.getJSONArray(AlgoTFTParamEnum.X_REALS.getId());
            JSONArray tftx_categoricalsJa = paramsJo.getJSONArray(AlgoTFTParamEnum.X_CATEGORICALS.getId());
            List tftx_reals = tftx_realsJa.toJavaList(String.class);
            List tftx_categoricals = tftx_categoricalsJa.toJavaList(String.class);
            BigDecimal tfthidden_continuous_size = paramsJo.getBigDecimal(AlgoTFTParamEnum.HIDDEN_CONTINUOUS_SIZE.getId());
            BigDecimal tftlearning_rate = paramsJo.getBigDecimal(AlgoTFTParamEnum.LEARNING_RATE.getId());
            this.getModel().setValue("tfthidden_size", (Object)tfthidden_size);
            this.getModel().setValue("tftlstm_layers", (Object)tftlstm_layers);
            this.getModel().setValue("tftdropout", (Object)tftdropout);
            this.getModel().setValue("tftloss", (Object)tftloss);
            this.getModel().setValue("tftattention_head_size", (Object)tftattention_head_size);
            this.getModel().setValue("tftmax_encoder_length", (Object)tftmax_encoder_length);
            this.getModel().setValue("tftx_reals", (Object)tftx_reals);
            this.getModel().setValue("tftx_categoricals", (Object)tftx_categoricals);
            this.getModel().setValue("tfthidden_continuous_size", (Object)tfthidden_continuous_size);
            this.getModel().setValue("tftlearning_rate", (Object)tftlearning_rate);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)algorithm, (CharSequence)AlgorithmEnum.NHITS.getId())) {
            BigDecimal hidden_size = paramsJo.getBigDecimal(AlgoNhitsParamEnum.HIDDEN_SIZE.getId());
            BigDecimal static_hidden_size = paramsJo.getBigDecimal(AlgoNhitsParamEnum.STATIC_HIDDEN_SIZE.getId());
            String loss = paramsJo.getString(AlgoNhitsParamEnum.LOSS.getId());
            String shared_weights = paramsJo.getString(AlgoNhitsParamEnum.SHARED_WEIGHTS.getId());
            String naive_level = paramsJo.getString(AlgoNhitsParamEnum.NAIVE_LEVEL.getId());
            String initialization = paramsJo.getString(AlgoNhitsParamEnum.INITIALIZATION.getId());
            String pooling_mode = paramsJo.getString(AlgoNhitsParamEnum.POOLING_MODE.getId());
            String batch_normalization = paramsJo.getString(AlgoNhitsParamEnum.BATCH_NORMALIZATION.getId());
            BigDecimal dropout = paramsJo.getBigDecimal(AlgoNhitsParamEnum.DROPOUT.getId());
            String activate = paramsJo.getString(AlgoNhitsParamEnum.ACTIVATE.getId());
            JSONArray x_realsJa = paramsJo.getJSONArray(AlgoNhitsParamEnum.X_REALS.getId());
            JSONArray x_categoricalsJa = paramsJo.getJSONArray(AlgoNhitsParamEnum.X_CATEGORICALS.getId());
            List x_reals = x_realsJa.toJavaList(String.class);
            List x_categoricals = x_categoricalsJa.toJavaList(String.class);
            BigDecimal learning_rate = paramsJo.getBigDecimal(AlgoNhitsParamEnum.LEARNING_RATE.getId());
            this.getModel().setValue("nhitshidden_size", (Object)hidden_size);
            this.getModel().setValue("nhitsstatic_hidden_size", (Object)static_hidden_size);
            this.getModel().setValue("nhitsloss", (Object)loss);
            this.getModel().setValue("nhitsshared_weights", (Object)StrUtils.str2Boolean((String)shared_weights));
            this.getModel().setValue("nhitsnaive_level", (Object)StrUtils.str2Boolean((String)naive_level));
            this.getModel().setValue("nhitsinitialization", (Object)initialization);
            this.getModel().setValue("nhitspooling_mode", (Object)pooling_mode);
            this.getModel().setValue("nhitsbatch_normalization", (Object)StrUtils.str2Boolean((String)batch_normalization));
            this.getModel().setValue("nhitsdropout", (Object)dropout);
            this.getModel().setValue("nhitsactivate", (Object)activate);
            this.getModel().setValue("nhitsx_reals", (Object)x_reals);
            this.getModel().setValue("nhitsx_categoricals", (Object)x_categoricals);
            this.getModel().setValue("nhitslearning_rate", (Object)learning_rate);
        }
    }
}

