/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.gpe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.gpe.DataSourceMetadata;
import kd.ai.ids.core.entity.model.gpe.FieldInfo;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.entity.model.gpe.SchemeConfig;
import kd.ai.ids.core.enumtype.AttachmentSourceEnum;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.gpe.DataSetTypeEnum;
import kd.ai.ids.core.enumtype.gpe.DataSourceTypeEnum;
import kd.ai.ids.core.enumtype.gpe.FieldTypeEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.EntityUtils;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class SyncEvaluationDatasetTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(SyncEvaluationDatasetTask.class);
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";

    private IIdsParameterService idsParameterService() {
        return (IIdsParameterService)Services.get(IIdsParameterService.class);
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        int progress = 0;
        String opName = "\u62bd\u53d6\u8bc4\u4f30\u6570\u636e\u96c6";
        long schemeId = (Long)params.get("scheme");
        long predictDatasetId = (Long)params.get("id");
        DynamicObject schemeDo = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)IdsFormIdEnum.IDS_GPE_SCHEME.getId());
        DynamicObject datasetDo = BusinessDataServiceHelper.loadSingle((Object)predictDatasetId, (String)IdsFormIdEnum.IDS_GPE_DATASET.getId());
        CloneUtils cloneUtils = new CloneUtils(false, true);
        DynamicObject evaluationDatasetDo = (DynamicObject)cloneUtils.clone((IDataEntityBase)datasetDo);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)evaluationDatasetDo.getDataEntityType().getName(), (DynamicObject)evaluationDatasetDo, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)evaluationDatasetDo);
        String name = evaluationDatasetDo.getString("name");
        long evaluationDatasetId = ID.genLongId();
        evaluationDatasetDo.set("id", (Object)evaluationDatasetId);
        evaluationDatasetDo.set("number", (Object)number);
        evaluationDatasetDo.set("masterid", (Object)evaluationDatasetId);
        evaluationDatasetDo.set("name", (Object)new LocaleString(String.format("%s-\u8bc4\u4f30", name)));
        evaluationDatasetDo.set("type", (Object)String.format(",%s,", DataSetTypeEnum.EVALUATION.getId()));
        evaluationDatasetDo.set("creator", (Object)rc.getCurrUserId());
        evaluationDatasetDo.set("modifier", (Object)rc.getCurrUserId());
        evaluationDatasetDo.set("createtime", (Object)KDDateUtils.now());
        evaluationDatasetDo.set("modifytime", (Object)KDDateUtils.now());
        evaluationDatasetDo.set("requestid", null);
        evaluationDatasetDo.set("summary", null);
        evaluationDatasetDo.set("summary_tag", null);
        evaluationDatasetDo.set("fieldvalueinfo", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{evaluationDatasetDo});
        String desc = String.format("%s - \u51c6\u5907\u6267\u884c...", opName);
        this.feedbackProgress(progress, desc, null);
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        int errcode = BaseResult.SUCCESS;
        boolean syncDataResult = true;
        this.syncdata(evaluationDatasetDo, opName, schemeDo);
        result.put("errcode", Integer.valueOf(errcode));
        result.put("syncData", Boolean.valueOf(syncDataResult));
        result.put("id", Long.valueOf(evaluationDatasetId));
        this.feedbackCustomdata(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncdata(DynamicObject datasetDo, String opName, DynamicObject schemeDo) {
        boolean uploadSuccess;
        block22: {
            int progress = 25;
            String desc = String.format("%s - \u6267\u884c\u4e2d...", opName);
            this.feedbackProgress(progress, desc, null);
            uploadSuccess = false;
            InputStream in = null;
            JSONObject fieldValueInfoJo = null;
            long attachmentId = 0L;
            try {
                String fileName = String.format("%s.csv", ID.genLongId());
                DynamicObject dataSourceDo = datasetDo.getDynamicObject("datasource");
                Object dataSourceId = dataSourceDo.getPkValue();
                DynamicObject dataSourceDetailDo = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)IdsFormIdEnum.IDS_GPE_DATASOURCE.getId());
                String type = dataSourceDetailDo.getString("type");
                fieldValueInfoJo = new JSONObject();
                if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.BIZOBJ.getId())) {
                    long orgId = OrgUnitServiceHelper.getOrgService().getRootOrgId();
                    IdsParameter idsParameter = ((IIdsParameterService)Services.get(IIdsParameterService.class)).getIdsParameter(Long.valueOf(orgId));
                    String splitChar = datasetDo.getString("splitchar");
                    String metadataStr = datasetDo.getString("metadata_tag");
                    if (StringUtils.isNotEmpty((CharSequence)metadataStr)) {
                        DataSourceMetadata metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class);
                        List fieldInfoList = metadata.getFieldInfoList();
                        StringBuilder contentSb = new StringBuilder();
                        char split = splitChar.charAt(0);
                        if (StringUtils.equalsIgnoreCase((CharSequence)splitChar, (CharSequence)"\\u0001")) {
                            split = '\u0001';
                        }
                        for (FieldInfo fieldInfo : fieldInfoList) {
                            QFilter[] qFilters;
                            DynamicObjectCollection lineDoc;
                            QFilter qFilter;
                            List plainFieldList = fieldInfo.getPlainFieldList();
                            for (PlainField plainField : plainFieldList) {
                                String fieldValue = plainField.getFieldKey();
                                if (StringUtils.isEmpty((CharSequence)contentSb)) {
                                    contentSb.append(fieldValue);
                                    continue;
                                }
                                contentSb.append(split).append(fieldValue);
                            }
                            contentSb.append(System.lineSeparator());
                            List fieldIdList = plainFieldList.stream().map(PlainField::getFieldId).collect(Collectors.toList());
                            String selectFields = StringUtils.join(fieldIdList, (String)",");
                            Date predictStartDate = schemeDo.getDate("predictstartdate");
                            int predictLength = schemeDo.getInt("predictlength");
                            String timeGranularity = schemeDo.getString("timegranularity");
                            List predictPeroidList = DateUtils.calPredictPeriod((Date)predictStartDate, (int)predictLength, (String)timeGranularity);
                            Date startDate = null;
                            Date endDate = null;
                            if (CollectionUtils.isNotEmpty((Collection)predictPeroidList)) {
                                String predictStartDateStr = (String)predictPeroidList.get(0);
                                String predictEndDateStr = (String)predictPeroidList.get(predictPeroidList.size() - 1);
                                endDate = KDDateUtils.addDays((Date)KDDateUtils.parseDate((String)predictEndDateStr), (int)1);
                                startDate = KDDateUtils.parseDateTime((String)String.format("%s 00:00:00", predictStartDateStr));
                            }
                            String configTag = schemeDo.getString("config_tag");
                            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)configTag, SchemeConfig.class);
                            String entityNumber = fieldInfo.getEntityNumber();
                            String filterJson = datasetDo.getString("filter_tag");
                            PlainField timePlainField = plainFieldList.stream().filter(e -> e.getFieldKey().equalsIgnoreCase(schemeConfig.getFtimefield())).findFirst().get();
                            String timeFieldId = timePlainField.getFieldId();
                            filterJson = this.excludeTimeFieldFilter(filterJson, timeFieldId);
                            QFilter timefieldQFilter = new QFilter(timeFieldId, ">=", (Object)startDate).and(timeFieldId, "<=", (Object)endDate);
                            if (StringUtils.isNotEmpty((CharSequence)filterJson) && (qFilter = EntityUtils.transFilterJson2QFilter((String)entityNumber, (String)filterJson)) != null) {
                                timefieldQFilter.and(qFilter);
                            }
                            if ((lineDoc = QueryServiceHelper.query((String)entityNumber, (String)selectFields, (QFilter[])(qFilters = timefieldQFilter.toArray()), (String)"id desc", (int)idsParameter.getMaxRowCount())) != null && lineDoc.size() > 0) {
                                for (int i = 0; i < lineDoc.size(); ++i) {
                                    DynamicObject lineDo = (DynamicObject)lineDoc.get(i);
                                    StringBuilder lineSb = new StringBuilder();
                                    for (PlainField plainField : plainFieldList) {
                                        String fieldValueStr;
                                        String fieldKey = plainField.getFieldKey();
                                        String fieldId = plainField.getFieldId();
                                        Object fieldValue = lineDo.get(fieldId);
                                        String string = fieldValueStr = fieldValue != null ? fieldValue.toString() : "";
                                        if (StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATE.getId()) || StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATETIME.getId())) {
                                            Date oldMaxDate;
                                            String dateValueStr;
                                            Date dateValue = (Date)fieldValue;
                                            fieldValueStr = dateValueStr = KDDateFormatUtils.getDateFormat().format(dateValue);
                                            String fieldMaxId = String.format("%s_%s", fieldKey, "max");
                                            String maxDateStr = dateValueStr;
                                            String oldMaxDateStr = fieldValueInfoJo.getString(fieldMaxId);
                                            if (StringUtils.isNotEmpty((CharSequence)oldMaxDateStr) && dateValue.before(oldMaxDate = KDDateUtils.parseDate((String)oldMaxDateStr))) {
                                                maxDateStr = oldMaxDateStr;
                                            }
                                            fieldValueInfoJo.put(fieldMaxId, (Object)maxDateStr);
                                        }
                                        if (StringUtils.isEmpty((CharSequence)lineSb)) {
                                            lineSb.append(fieldValueStr);
                                            continue;
                                        }
                                        lineSb.append(split).append(fieldValueStr);
                                    }
                                    contentSb.append((CharSequence)lineSb);
                                    if (i == lineDoc.size() - 1) continue;
                                    contentSb.append(System.lineSeparator());
                                }
                            }
                            log.info(contentSb.toString());
                        }
                        in = IOUtils.toInputStream((String)contentSb.toString(), (Charset)Charset.forName("utf-8"));
                    }
                }
                if (in == null) break block22;
                attachmentId = ID.genLongId();
                DynamicObject attachmentDo = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId());
                CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)attachmentDo.getDataEntityType().getName(), (DynamicObject)attachmentDo, null);
                String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)attachmentDo);
                attachmentDo.set("id", (Object)attachmentId);
                attachmentDo.set("number", (Object)number);
                attachmentDo.set("name", (Object)fileName);
                attachmentDo.set("status", (Object)BillStatusEnum.AUDITED.getId());
                attachmentDo.set("enable", (Object)YesNoEnum.YES.getKeyStr());
                attachmentDo.set("masterid", (Object)attachmentId);
                attachmentDo.set("source", (Object)AttachmentSourceEnum.IDS_GPE_DATASET.getId());
                attachmentDo.set("sourceid", datasetDo.getPkValue());
                int fileSize = 0;
                try {
                    fileSize = in.available();
                    attachmentDo.set("filesize", (Object)fileSize);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachmentDo});
                    uploadSuccess = this.upload(attachmentDo, in, fileName);
                    if (uploadSuccess) {
                        datasetDo.set("fieldvalueinfo", (Object)fieldValueInfoJo.toJSONString());
                        datasetDo.set("enable", (Object)EnableEnum.AVAIL.getKey());
                        datasetDo.set("issyncdata", (Object)YesNoEnum.YES.getKey());
                        datasetDo.set("attachmentid", (Object)attachmentDo);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datasetDo});
                        progress = 50;
                        desc = String.format("%s - \u6267\u884c\u6210\u529f", opName);
                        this.feedbackProgress(progress, desc, null);
                    }
                }
                catch (Exception e2) {
                    log.error("error:" + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Exception e3) {
                CommonUtil.getStackTrace((Exception)e3);
            }
            finally {
                CommonUtil.safeClose(in);
            }
        }
        return uploadSuccess;
    }

    private String excludeTimeFieldFilter(String filterJson, String timeFieldId) {
        JSONObject filterJo;
        if (StringUtils.isNotEmpty((CharSequence)filterJson) && (filterJo = JSONObject.parseObject((String)filterJson)) != null) {
            JSONArray filterRowJa = filterJo.getJSONArray("filterRow");
            JSONArray newFilterRowJa = new JSONArray();
            if (filterRowJa != null) {
                for (Object o : filterRowJa) {
                    JSONObject jo = (JSONObject)o;
                    String fieldName = jo.getString("fieldName");
                    if (StringUtils.equalsIgnoreCase((CharSequence)timeFieldId, (CharSequence)fieldName)) continue;
                    newFilterRowJa.add((Object)jo);
                }
            }
            filterJo.put("filterRow", (Object)newFilterRowJa);
            filterJson = filterJo.toJSONString();
        }
        return filterJson;
    }

    private boolean upload(DynamicObject attachmentDo, InputStream inputStream, String fileName) {
        RequestContext rc = RequestContext.get();
        boolean uploadSuccess = false;
        try {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".csv")) {
                fileName = String.format("%s.csv", fileName);
            }
            String today = DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyyMMdd");
            String uploadPath = String.format("%s/%s/%s/%s/%s/%s", rc.getTenantId(), rc.getAccountId(), today, IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId(), attachmentDo.getPkValue(), fileName);
            FileService fs = FileServiceFactory.getAttachmentFileService();
            FileItem fi = new FileItem(fileName, uploadPath, inputStream);
            int size = inputStream.available();
            String path = fs.upload(fi);
            HashMap<String, Object> uploadFileMap = new HashMap<String, Object>();
            uploadFileMap.put("entityNum", attachmentDo.getDynamicObjectType().getName());
            uploadFileMap.put("billPkId", attachmentDo.get("id"));
            uploadFileMap.put("lastModified", KDDateUtils.now().getTime());
            uploadFileMap.put("name", fileName);
            uploadFileMap.put("url", uploadPath);
            uploadFileMap.put("size", size);
            uploadFileMap.put("status", "success");
            ArrayList<HashMap<String, Object>> attachments = new ArrayList<HashMap<String, Object>>();
            attachments.add(uploadFileMap);
            AttachmentServiceHelper.upload((String)attachmentDo.getDynamicObjectType().getName(), (Object)attachmentDo.getPkValue(), (String)KEY_ATTACHMENTPANELAP, attachments);
            uploadSuccess = true;
            log.info("\u4e0a\u4f20\u6210\u529f\uff1a" + path);
        }
        catch (Exception e) {
            uploadSuccess = false;
            log.error("error:" + e.getMessage(), (Throwable)e);
        }
        return uploadSuccess;
    }
}

