/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.salesplan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.ai.ids.core.constants.SalesplanFieldKeyConst;
import kd.ai.ids.core.entity.model.ResultConfig;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.SalesplanIndicatorEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.UnAudit;
import kd.bos.entity.operate.UnSubmit;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SalesPlanFormPlugin
extends BaseFormPlugin {
    private static final String KEY_PERIOD_GROUP_AP_PREFIX = "periodgroupap";
    private static final String KEY_IS_INIT_PAGE_DATA = "is_init_page_data";
    private static final String KEY_ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String KEY_BATCHFILLENTRY = "batchfillentry";
    private static final String KEY_FILLQTY_NEWVALUE = "fillqtyNewValue";
    private static final String KEY_FILLAMOOUNT_NEWVALUE = "fillAmountNewValue";

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    private String getResultConfig() {
        return this.getCache().get("resultConfig");
    }

    private boolean getIsInitPageData() {
        String isInit = this.getCache().get(KEY_IS_INIT_PAGE_DATA);
        return StringUtils.isNotEmpty((CharSequence)isInit) ? Boolean.parseBoolean(isInit) : false;
    }

    @Override
    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("ids_salesplan_entry");
        final BillView billView = (BillView)this.getView();
        entryGrid.addDataBindListener(new EntryGridBindDataListener(){

            public void entryGridBindData(EntryGridBindDataEvent e) {
                super.entryGridBindData(e);
                SalesPlanFormPlugin.this.resetEntryTableConfig(billView);
            }
        });
    }

    private void resetEntryTableConfig(BillView billView) {
        long periodId;
        DynamicObject salesplanPeriodDo;
        JSONObject configJo;
        JSONArray fpreperiodsJa;
        DynamicObject periodDo;
        DynamicObject salesplanDo;
        BillShowParameter billShowParameter = (BillShowParameter)billView.getFormShowParameter();
        Object pkId = billShowParameter.getPkId();
        String entityId = billShowParameter.getFormId();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("ids_salesplan_entry");
        SubEntryGrid indicatorSubEntryGrid = (SubEntryGrid)this.getView().getControl("ids_salesplan_indicator");
        if (pkId != null && (salesplanDo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityId)) != null && (periodDo = salesplanDo.getDynamicObject("periodid")) != null && (fpreperiodsJa = (configJo = JSONObject.parseObject((String)(salesplanPeriodDo = BusinessDataServiceHelper.loadSingle((Object)(periodId = ((Long)periodDo.getPkValue()).longValue()), (String)"ids_salesplan_period")).getString("config_tag"))).getJSONArray("fpreperiods")) != null && fpreperiodsJa.size() > 0) {
            int i;
            for (i = 0; i < fpreperiodsJa.size(); ++i) {
                String period = fpreperiodsJa.getString(i);
                period = String.format("%s(T+%s)", period, i + 1);
                LocaleString periodLocaleString = new LocaleString(period);
                entryGrid.setColumnProperty(String.format("%s%s", KEY_PERIOD_GROUP_AP_PREFIX, i + 1), "header", (Object)periodLocaleString);
                indicatorSubEntryGrid.setColumnProperty(String.format("%s%s", "value", i + 1), "header", (Object)periodLocaleString);
            }
            for (i = fpreperiodsJa.size(); i < 12; ++i) {
                billView.setVisible(Boolean.FALSE, new String[]{String.format("%s%s", KEY_PERIOD_GROUP_AP_PREFIX, i + 1), String.format("%s%s", "value", i + 1)});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_ADVCONTOOLBARAP});
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillShowParameter billShowParameter;
        Object pkId;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if ((source instanceof UnSubmit || source instanceof UnAudit || source instanceof Delete || source instanceof Submit || source instanceof Audit || source instanceof Save) && (pkId = (billShowParameter = (BillShowParameter)this.getView().getFormShowParameter()).getPkId()) != null) {
            DynamicObject salesplanDo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)this.getView().getEntityId());
            QFilter periodQFilter = new QFilter("periodid", "=", salesplanDo.getDynamicObject("periodid").getPkValue());
            boolean existsPeriodPushDown = QueryServiceHelper.exists((String)IdsFormIdEnum.IDS_SALESPLAN_PUSH_HIS.getId(), (QFilter[])periodQFilter.toArray());
            QFilter qFilter = new QFilter("salesplanid", "=", pkId);
            if (existsPeriodPushDown || QueryServiceHelper.exists((String)IdsFormIdEnum.IDS_SALESPLAN_PUSH_HIS.getId(), (QFilter[])qFilter.toArray())) {
                this.getView().showErrorNotification("\u8be5\u5355\u636e\u5df2\u5b58\u5728\u9700\u6c42\u8ba1\u5212\u5355\u4e0b\u63a8\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c");
                args.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)KEY_BATCHFILLENTRY)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("ids_salesplan_entry");
            int focusRowIndex = this.getModel().getEntryCurrentRowIndex("ids_salesplan_entry");
            String focusField = entryGrid.getEntryState().getFocusField();
            String fillqtyStr = this.getCache().get(KEY_FILLQTY_NEWVALUE);
            String fillamountStr = this.getCache().get(KEY_FILLAMOOUNT_NEWVALUE);
            if (focusRowIndex < 0 || StringUtils.isEmpty((CharSequence)focusField)) {
                this.log.info("focusRowIndex:{}, focusField:{}, fillqtyStr:{}, fillamountStr:{}", new Object[]{focusRowIndex, focusField, fillqtyStr, fillamountStr});
                return;
            }
            BigDecimal fillqtyNewValue = StringUtils.isNotEmpty((CharSequence)fillqtyStr) ? new BigDecimal(fillqtyStr) : null;
            BigDecimal fillamountNewValue = StringUtils.isNotEmpty((CharSequence)fillamountStr) ? new BigDecimal(fillamountStr) : null;
            String name = focusField;
            String index = name.substring(name.length() - 1);
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            if (dataEntitys != null && dataEntitys.length > 0) {
                for (int i = 0; i < dataEntitys.length; ++i) {
                    if (i < focusRowIndex) continue;
                    DynamicObject dataEntity = dataEntitys[i];
                    BigDecimal price = dataEntity.getBigDecimal("price");
                    DynamicObjectCollection indicatorDoc = dataEntity.getDynamicObjectCollection("ids_salesplan_indicator");
                    for (DynamicObject indicatorDo : indicatorDoc) {
                        String findicator = indicatorDo.getString("indicator");
                        if (StringUtils.equalsIgnoreCase((CharSequence)findicator, (CharSequence)SalesplanIndicatorEnum.FFILLQTY.getId())) {
                            if (StringUtils.startsWithIgnoreCase((CharSequence)focusField, (CharSequence)SalesplanIndicatorEnum.FFILLQTY.getId())) {
                                indicatorDo.set(String.format("%s%s", "value", index), (Object)fillqtyNewValue);
                                continue;
                            }
                            if (fillamountNewValue == null) continue;
                            indicatorDo.set(String.format("%s%s", "value", index), (Object)fillamountNewValue.divide(price, 2, 4));
                            continue;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)findicator, (CharSequence)SalesplanIndicatorEnum.FFILLAMOUNT.getId())) continue;
                        if (StringUtils.startsWithIgnoreCase((CharSequence)focusField, (CharSequence)SalesplanIndicatorEnum.FFILLQTY.getId())) {
                            if (fillqtyNewValue == null) continue;
                            indicatorDo.set(String.format("%s%s", "value", index), (Object)fillqtyNewValue.multiply(price));
                            continue;
                        }
                        indicatorDo.set(String.format("%s%s", "value", index), (Object)fillamountNewValue);
                    }
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if ((StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)SalesplanIndicatorEnum.FFILLQTY.getId()) || StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)SalesplanIndicatorEnum.FFILLAMOUNT.getId())) && !this.getIsInitPageData()) {
            String indicator = name.substring(0, name.length() - 1);
            String relationIndicator = "";
            if (StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)SalesplanIndicatorEnum.FFILLQTY.getId())) {
                relationIndicator = SalesplanIndicatorEnum.FFILLAMOUNT.getId();
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)SalesplanIndicatorEnum.FFILLAMOUNT.getId())) {
                relationIndicator = SalesplanIndicatorEnum.FFILLQTY.getId();
            }
            String index = name.substring(name.length() - 1);
            ChangeData changeRowData = changeData[0];
            BigDecimal price = changeRowData.getDataEntity().getBigDecimal("price");
            BigDecimal value = changeRowData.getNewValue() != null ? (BigDecimal)changeRowData.getNewValue() : null;
            BigDecimal relationValue = null;
            int rowIndex = changeRowData.getRowIndex();
            if (StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)SalesplanIndicatorEnum.FFILLQTY.getId())) {
                BigDecimal amount;
                relationValue = amount = this.getAmount(price, value);
                this.getModel().setValue(String.format("%s%s", SalesplanIndicatorEnum.FFILLAMOUNT, index), (Object)amount, rowIndex);
                this.getCache().put(KEY_FILLQTY_NEWVALUE, String.valueOf(value));
                this.getModel().setValue(String.format("%s%s", SalesplanIndicatorEnum.FFILLQTY, index), (Object)value, rowIndex);
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)SalesplanIndicatorEnum.FFILLAMOUNT.getId())) {
                BigDecimal qty;
                relationValue = qty = this.getQty(price, value);
                this.getModel().setValue(String.format("%s%s", SalesplanIndicatorEnum.FFILLQTY, index), (Object)qty, rowIndex);
                this.getCache().put(KEY_FILLAMOOUNT_NEWVALUE, String.valueOf(value));
                this.getModel().setValue(String.format("%s%s", SalesplanIndicatorEnum.FFILLAMOUNT, index), (Object)value, rowIndex);
            }
            SubEntryGrid subEntryGrid = (SubEntryGrid)this.getView().getControl("ids_salesplan_indicator");
            EntryData subEntryData = subEntryGrid.getEntryData();
            DynamicObject[] dataEntitys = subEntryData.getDataEntitys();
            int subEntryIndicatorRowIndex = -1;
            int subEntryRelationIndicatorRowIndex = -1;
            if (dataEntitys != null && dataEntitys.length > 0) {
                for (int i = 0; i < dataEntitys.length; ++i) {
                    String indicatorType = dataEntitys[i].getString("indicator");
                    if (StringUtils.equalsIgnoreCase((CharSequence)indicatorType, (CharSequence)indicator)) {
                        subEntryIndicatorRowIndex = i;
                        continue;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)indicatorType, (CharSequence)relationIndicator)) continue;
                    subEntryRelationIndicatorRowIndex = i;
                }
            }
            if (subEntryIndicatorRowIndex >= 0) {
                this.getModel().setValue(String.format("%s%s", "value", index), (Object)value, subEntryIndicatorRowIndex);
            }
            if (subEntryRelationIndicatorRowIndex >= 0) {
                this.getModel().setValue(String.format("%s%s", "value", index), (Object)relationValue, subEntryRelationIndicatorRowIndex);
            }
        }
    }

    private BigDecimal getQty(BigDecimal price, BigDecimal amount) {
        return amount != null ? amount.divide(price, 2, 4) : null;
    }

    private BigDecimal getAmount(BigDecimal price, BigDecimal qty) {
        return qty != null ? price.multiply(qty).setScale(2, RoundingMode.HALF_UP) : null;
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        BillView billView = (BillView)eventObject.getSource();
        BillShowParameter billShowParameter = (BillShowParameter)billView.getFormShowParameter();
        Object pkId = billShowParameter.getPkId();
        String entityId = billShowParameter.getFormId();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("ids_salesplan_entry");
        this.initFmodeltypeidComEdit(this.dataAppService().getSalesForecastAppIdByPlatformCode());
        if (pkId != null) {
            this.getCache().put(KEY_IS_INIT_PAGE_DATA, "true");
            DynamicObject salesplanDo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityId);
            String fmodeltypeid = salesplanDo.getString("modeltypeid");
            this.accordBizAssociateSchemeHideField(fmodeltypeid);
            DynamicObjectCollection entryDoc = salesplanDo.getDynamicObjectCollection("ids_salesplan_entry");
            if (entryDoc != null && entryDoc.size() > 0) {
                int entryRowCount = entryDoc.size();
                for (int i = 0; i < entryRowCount; ++i) {
                    DynamicObject entryDo = (DynamicObject)entryDoc.get(i);
                    DynamicObjectCollection indicatorDoc = entryDo.getDynamicObjectCollection("ids_salesplan_indicator");
                    if (indicatorDoc == null || indicatorDoc.size() <= 0) continue;
                    for (DynamicObject indicatorDo : indicatorDoc) {
                        String indicator = indicatorDo.getString("indicator");
                        for (int j = 0; j < 12; ++j) {
                            int index = j + 1;
                            BigDecimal value = indicatorDo.getBigDecimal(String.format("%s%s", "value", index), true);
                            this.getModel().setValue(String.format("%s%s", indicator, index), (Object)value, i);
                        }
                    }
                }
            }
            this.getCache().put(KEY_IS_INIT_PAGE_DATA, "false");
        }
        Optional.ofNullable(entryGrid).ifPresent(e -> {
            e.setColumnProperty("supplier", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("base1level", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("base2level", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("base3level", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("materialid", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("materialnumber", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("modelnum", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("baseunit", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("unitid", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("price", "isFixed", (Object)Boolean.TRUE);
        });
    }

    private void accordBizAssociateSchemeHideField(String fmodeltypeid) {
        QFilter qFilter = new QFilter("appid", "=", (Object)this.dataAppService().getSalesForecastAppIdByPlatformCode()).and("bizobj", "=", (Object)"ids_salesplan").and("modeltypeid", "=", (Object)fmodeltypeid).and("status", "=", (Object)String.valueOf(YesNoEnum.YES.getKey()));
        DynamicObject bizAssociateSchemeDo = BusinessDataServiceHelper.loadSingle((String)"ids_biz_associate_scheme", (QFilter[])qFilter.toArray());
        if (bizAssociateSchemeDo != null) {
            DynamicObjectCollection fieldMappingDoc = bizAssociateSchemeDo.getDynamicObjectCollection("field_mapping_entry");
            ArrayList<String> needShowFieldList = new ArrayList<String>(10);
            if (fieldMappingDoc != null && fieldMappingDoc.size() > 0) {
                for (DynamicObject fieldMappingDo : fieldMappingDoc) {
                    String quoteField = fieldMappingDo.getString("quotefield");
                    String bizobjField = fieldMappingDo.getString("bizobjfield");
                    if (StringUtils.isEmpty((CharSequence)quoteField) || StringUtils.isEmpty((CharSequence)bizobjField)) continue;
                    String[] splitArr = bizobjField.split("\\.");
                    String realBizobjFieldId = splitArr[splitArr.length - 1];
                    String renameField = fieldMappingDo.getString("renamefield");
                    if (StringUtils.isNotEmpty((CharSequence)renameField)) {
                        if (!bizobjField.contains(".")) {
                            HashMap<String, String> map1 = new HashMap<String, String>();
                            map1.put("zh_CN", renameField);
                            HashMap<String, HashMap<String, String>> map2 = new HashMap<String, HashMap<String, String>>();
                            map2.put("caption", map1);
                            this.getView().updateControlMetadata(realBizobjFieldId, map2);
                        } else if (bizobjField.contains(String.format("%s.", "ids_salesplan_entry"))) {
                            EntryGrid entryGrid = (EntryGrid)this.getControl("ids_salesplan_entry");
                            entryGrid.setColumnProperty(realBizobjFieldId, "header", (Object)new LocaleString(renameField));
                        }
                    }
                    needShowFieldList.add(realBizobjFieldId);
                }
            }
            ArrayList<String> needHideFieldList = new ArrayList<String>(Arrays.asList(SalesplanFieldKeyConst.CAN_HIDE_FIELD_LIST));
            needHideFieldList.removeAll(needShowFieldList);
            this.getView().setVisible(Boolean.FALSE, needHideFieldList.toArray(new String[needHideFieldList.size()]));
            if (needHideFieldList.contains("materialid")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"materialnumber", "modelnum", "baseunit"});
            }
        }
    }

    private void loadResultConfig() {
        RequestContext rc = RequestContext.get();
        JSONArray dataJa = this.modelResultService().getResultConfig(Long.valueOf(rc.getOrgId()), this.getSubServiceId());
        if (dataJa != null && !dataJa.isEmpty()) {
            this.getCache().put("resultConfig", JSON.toJSONString((Object)dataJa));
        }
    }

    private List<ResultConfig> getResultConfigList() {
        List<Object> resultConfigList = new ArrayList<ResultConfig>();
        String resultConfig = this.getResultConfig();
        if (StringUtils.isNotEmpty((CharSequence)resultConfig)) {
            resultConfigList = JSON.parseArray((String)resultConfig, ResultConfig.class);
        }
        return resultConfigList;
    }

    private void initFmodeltypeidComEdit(String appId) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
        RequestContext rc = RequestContext.get();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), this.getTenantDTO().getTenantId(), appId);
        this.getCache().put("subServiceId", subServiceId);
        this.loadResultConfig();
        List<ResultConfig> resultConfigList = this.getResultConfigList();
        if (resultConfigList != null && !resultConfigList.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("modeltypeid");
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(resultConfigList.size());
            for (ResultConfig resultConfig : resultConfigList) {
                String id = resultConfig.getId();
                String name = resultConfig.getName();
                LocaleString comboItemText = new LocaleString(name);
                ComboItem comboItem = new ComboItem(comboItemText, String.valueOf(id));
                comboItemList.add(comboItem);
            }
            comboEdit.setComboItems(comboItemList);
        }
        this.getView().hideLoading();
    }
}

