/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.salesplan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.ai.ids.core.constants.SalesplanFieldKeyConst;
import kd.ai.ids.core.entity.model.RequirePlanPushDownParams;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.ModelConfigItemEnum;
import kd.ai.ids.core.enumtype.PushdownTypeEnum;
import kd.ai.ids.core.enumtype.RequireplanIndicatorEnum;
import kd.ai.ids.core.enumtype.SalesplanIndicatorEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.form.BaseListPlugin;
import kd.ai.ids.plugin.helper.BizAssociateSchemeHelper;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.UnAudit;
import kd.bos.entity.operate.UnSubmit;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class SalesPlanListPlugin
extends BaseListPlugin {
    private static final Log log = LogFactory.getLog(SalesPlanListPlugin.class);
    private static final String KEY_TOOLBARAP = "toolbarap";
    private static final String KEY_PUSH_DOWN = "pushdown";
    private static final String KEY_PUSH_DOWN_SELECTED = "pushdownselected";
    private static final String KEY_FIELDKEY_RENAME_MAP = "fieldkey_rename_map";
    private static final String KEY_HIDE_FIELD_KEY_LIST = "hide_column_list";

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        if (!BizAssociateSchemeHelper.bizobjHasAvailScheme("ids_salesplan")) {
            this.getView().showTipNotification("\u3010\u9500\u552e\u8ba1\u5212\u5355\u3011\u6682\u672a\u914d\u7f6e\u53ef\u7528\u7684\u4e1a\u52a1\u5173\u8054\u65b9\u6848\uff0c\u529f\u80fd\u53ef\u80fd\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528", Integer.valueOf(10000));
        }
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        DynamicObject periodDo = this.getCurrPeriodDo();
        if (periodDo == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5355\u636e\u540d\u79f0");
            return;
        }
        if (source instanceof UnSubmit || source instanceof UnAudit || source instanceof Delete || source instanceof Submit || source instanceof Audit) {
            QFilter periodQFilter = new QFilter("periodid", "=", periodDo.getPkValue());
            boolean existsPeriodPushDown = QueryServiceHelper.exists((String)IdsFormIdEnum.IDS_SALESPLAN_PUSH_HIS.getId(), (QFilter[])periodQFilter.toArray());
            if (existsPeriodPushDown) {
                this.getView().showErrorNotification("\u9009\u4e2d\u5355\u636e\u5747\u5df2\u5b58\u5728\u9700\u6c42\u8ba1\u5212\u5355\u4e0b\u63a8\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c");
                args.setCancel(true);
            } else {
                Object[] idList = ((DefaultEntityOperate)source).getListSelectedData().getPrimaryKeyValues();
                if (idList != null && idList.length > 0) {
                    QFilter qFilter = new QFilter("salesplanid", "in", (Object)idList);
                    DynamicObjectCollection salesplanPushHisDoc = QueryServiceHelper.query((String)IdsFormIdEnum.IDS_SALESPLAN_PUSH_HIS.getId(), (String)"salesplanid", (QFilter[])qFilter.toArray());
                    ArrayList<Long> existsIdList = new ArrayList<Long>();
                    ArrayList<String> existsBillnoList = new ArrayList<String>();
                    if (salesplanPushHisDoc != null && salesplanPushHisDoc.size() > 0) {
                        for (DynamicObject salesplanPushHisDo : salesplanPushHisDoc) {
                            existsIdList.add(salesplanPushHisDo.getLong("salesplanid"));
                        }
                        QFilter existsSalesplanQFilter = new QFilter("id", "in", existsIdList);
                        DynamicObjectCollection salesplanDoc = QueryServiceHelper.query((String)IdsFormIdEnum.IDS_SALESPLAN.getId(), (String)"billno", (QFilter[])existsSalesplanQFilter.toArray());
                        if (salesplanDoc != null && salesplanDoc.size() > 0) {
                            for (DynamicObject salesplanDo : salesplanDoc) {
                                String billno = salesplanDo.getString("billno");
                                existsBillnoList.add(billno);
                            }
                            int maxShowSize = 10;
                            int existsCount = existsBillnoList.size();
                            String existsBillnos = existsCount > maxShowSize ? String.format("\u3010%s\u3011\u7b49%s\u5f20\u5355\u636e", String.join((CharSequence)",", existsBillnoList.subList(0, maxShowSize)), existsCount) : String.join((CharSequence)",", existsBillnoList);
                            this.getView().showErrorNotification(String.format("%s\u5df2\u5b58\u5728\u9700\u6c42\u8ba1\u5212\u5355\u4e0b\u63a8\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c", existsBillnos));
                            args.setCancel(true);
                        }
                    }
                }
            }
        }
    }

    private DynamicObject getCurrPeriodDo() {
        String s;
        DynamicObject periodDo = null;
        ControlFilters filters = ((IListView)this.getView()).getControlFilters();
        List filterList = filters.getFilter("periodid.id");
        if (filterList != null && filterList.size() > 0 && StringUtils.isNotEmpty((CharSequence)(s = (String)filterList.get(0)))) {
            Long periodId = Long.parseLong(s);
            periodDo = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)"ids_salesplan_period");
        }
        return periodDo;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Donothing donothing;
        String operateKey;
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing && (StringUtils.equalsIgnoreCase((CharSequence)(operateKey = (donothing = (Donothing)source).getOperateKey()), (CharSequence)KEY_PUSH_DOWN) || StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_PUSH_DOWN_SELECTED))) {
            if (!BizAssociateSchemeHelper.bizobjHasAvailScheme("ids_requireplan_entry")) {
                this.getView().showTipNotification("\u8bf7\u5148\u4e3a\u4e1a\u52a1\u5bf9\u8c61\u3010\u9700\u6c42\u8ba1\u5212\u5355\u660e\u7ec6\u3011\u521b\u5efa\u4e1a\u52a1\u5173\u8054\u65b9\u6848", Integer.valueOf(10000));
                return;
            }
            DynamicObject periodDo = this.getCurrPeriodDo();
            if (periodDo != null) {
                Long periodId = (Long)periodDo.getPkValue();
                String periodName = periodDo.getString("name");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ids_salesplan_push_dlg");
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("periodid", periodId);
                customParams.put("name", periodName);
                customParams.put("pushdownType", operateKey);
                if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_PUSH_DOWN_SELECTED)) {
                    Object[] idList = donothing.getListSelectedData().getPrimaryKeyValues();
                    ORM orm = ORM.create();
                    QFilter qFilter = new QFilter("id", "in", (Object)idList).and("billstatus", "!=", (Object)BillStatusEnum.AUDITED.getId());
                    int unauditCount = orm.count(((Object)((Object)this)).getClass().getName(), "ids_salesplan", "id", qFilter.toArray());
                    if (unauditCount > 0) {
                        this.getView().showTipNotification(String.format("\u9009\u4e2d\u8bb0\u5f55\u4e2d\u5b58\u5728%s\u5f20\u5355\u636e\u672a\u5ba1\u6838\uff0c\u8bf7\u5148\u5ba1\u6838\u518d\u4e0b\u63a8", unauditCount));
                        return;
                    }
                    this.getCache().put("idList", Arrays.asList(idList));
                }
                showParameter.setCustomParams(customParams);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_PUSH_DOWN));
                this.getView().showForm(showParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject resultJo;
        super.closedCallBack(closedCallBackEvent);
        RequestContext rc = RequestContext.get();
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_PUSH_DOWN) && returnData != null && (resultJo = JsonUtils.parseObj((Object)returnData)).getBooleanValue("status")) {
            String fmodeltypeid = resultJo.getString("modeltypeid");
            String billTitle = resultJo.getString("billtitle");
            Long periodId = resultJo.getLong("periodid");
            String adoptqtyIndicator = resultJo.getString("adoptqtyindicator");
            String pushdownType = resultJo.getString("pushdownType");
            List idList = null;
            if (StringUtils.equalsIgnoreCase((CharSequence)pushdownType, (CharSequence)PushdownTypeEnum.PUSHDOWN_SELECTED.getId())) {
                idList = this.getCache().getAsList("idList", Long.class);
            }
            String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), this.getTenantDTO().getTenantId(), this.dataAppService().getSalesForecastAppIdByPlatformCode());
            String fitemKey = String.format("%s%s", ModelConfigItemEnum.REQUIRE_PLAN_CONFIG_PREFIX.getId(), fmodeltypeid);
            JSONObject dataJo = this.commonService().getModelConfigItem(Long.valueOf(rc.getOrgId()), subServiceId, fitemKey);
            JSONObject configJo = dataJo.getJSONObject(fitemKey).getJSONObject("fitemvalue");
            JSONArray fpreperiodsJa = configJo.getJSONArray("fpreperiods");
            QFilter schemeQFilter = new QFilter("appid", "=", (Object)this.dataAppService().getSalesForecastAppIdByPlatformCode()).and("bizobj", "=", (Object)"ids_requireplan_entry").and("status", "=", (Object)String.valueOf(YesNoEnum.YES.getKey()));
            DynamicObject[] bizAssociateSchemeDoArr = BusinessDataServiceHelper.load((String)"ids_biz_associate_scheme", (String)"id,modeltypeid", (QFilter[])schemeQFilter.toArray());
            if (bizAssociateSchemeDoArr != null && bizAssociateSchemeDoArr.length > 0) {
                Object[] pkArray = new Object[bizAssociateSchemeDoArr.length];
                for (int i = 0; i < bizAssociateSchemeDoArr.length; ++i) {
                    pkArray[i] = bizAssociateSchemeDoArr[i].getPkValue();
                }
                DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ids_biz_associate_scheme");
                DynamicObject[] selectedDynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)newDynamicObject.getDynamicObjectType());
                RequirePlanPushDownParams requirePlanPushDownParams = new RequirePlanPushDownParams();
                requirePlanPushDownParams.setPeriodId(periodId);
                requirePlanPushDownParams.setBillTitle(billTitle);
                requirePlanPushDownParams.setAdoptqtyindicator(adoptqtyIndicator);
                requirePlanPushDownParams.setSelectedIdList(idList);
                ThreadUtils.execute(() -> {
                    log.info("pushdown requireplan start... {}", (Object)JSONObject.toJSONString((Object)pkArray));
                    log.info("pushdown requireplan executeBizAssociateSchemeTask start...");
                    this.taskExecuteService().executeBizAssociateSchemeTask(selectedDynamicObjectArray, Long.valueOf(rc.getOrgId()), subServiceId, Long.valueOf(rc.getCurrUserId()), requirePlanPushDownParams);
                    log.info("pushdown requireplan executeBizAssociateSchemeTask end.");
                    log.info("pushdown requireplan syncRequirePlanEntryFromSalsePlan start...");
                    this.syncRequirePlanEntryFromSalsePlan(billTitle, periodId, fpreperiodsJa, requirePlanPushDownParams);
                    log.info("pushdown requireplan syncRequirePlanEntryFromSalsePlan end.");
                    log.info("pushdown requireplan end.");
                });
                ThreadUtils.sleep((long)1500L);
                this.getView().showSuccessNotification("\u4e0b\u63a8\u5df2\u6210\u529f\u89e6\u53d1\uff0c\u8bf7\u7a0d\u540e\u524d\u5f80\u3010\u9700\u6c42\u8ba1\u5212\u5355\u3011\u4e2d\u67e5\u770b", Integer.valueOf(3000));
            }
        }
    }

    private void fillAdoptqtyDefaultValue(DynamicObject requirePlanEntryDo, RequirePlanPushDownParams requirePlanPushDownParams, DynamicObject requirePlanDo) {
        if (requirePlanDo != null && requirePlanEntryDo != null) {
            JSONObject configJo = JSONObject.parseObject((String)requirePlanDo.getString("config_tag"));
            JSONArray fpreperiodsJa = configJo.getJSONArray("fpreperiods");
            if (fpreperiodsJa == null || fpreperiodsJa.size() == 0) {
                return;
            }
            DynamicObjectCollection reqIndicatorEntryDoc = requirePlanEntryDo.getDynamicObjectCollection("ids_req_indicator_entry");
            if (reqIndicatorEntryDoc != null && reqIndicatorEntryDoc.size() > 0) {
                String valueFieldKey;
                int i;
                String adoptqtyindicator = requirePlanPushDownParams.getAdoptqtyindicator();
                int adoptqtyIndex = -1;
                DynamicObject preqtyIndicatorEntryDo = null;
                DynamicObject fillqtyIndicatorEntryDo = null;
                int amountIndex = -1;
                DynamicObject avgpriceIndicatorEntryDo = null;
                for (i = 0; i < reqIndicatorEntryDoc.size(); ++i) {
                    DynamicObject reqIndicatorEntryDo = (DynamicObject)reqIndicatorEntryDoc.get(i);
                    String indicator = reqIndicatorEntryDo.getString("indicator");
                    if (StringUtils.equalsIgnoreCase((CharSequence)indicator, (CharSequence)RequireplanIndicatorEnum.FADOPTQTY.getId())) {
                        adoptqtyIndex = i;
                        continue;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)indicator, (CharSequence)RequireplanIndicatorEnum.FPREQTY.getId())) {
                        preqtyIndicatorEntryDo = reqIndicatorEntryDo;
                        continue;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)indicator, (CharSequence)RequireplanIndicatorEnum.FFILLQTY.getId())) {
                        fillqtyIndicatorEntryDo = reqIndicatorEntryDo;
                        continue;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)indicator, (CharSequence)RequireplanIndicatorEnum.FAVGPRICE.getId())) {
                        avgpriceIndicatorEntryDo = reqIndicatorEntryDo;
                        continue;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)indicator, (CharSequence)RequireplanIndicatorEnum.FAMOUNT.getId())) continue;
                    amountIndex = i;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)adoptqtyindicator, (CharSequence)RequireplanIndicatorEnum.FPREQTY.getId())) {
                    for (i = 0; i < fpreperiodsJa.size(); ++i) {
                        valueFieldKey = String.format("%s%s", "value", i + 1);
                        BigDecimal preValue = null;
                        if (preqtyIndicatorEntryDo != null) {
                            preValue = preqtyIndicatorEntryDo.getBigDecimal(valueFieldKey, true);
                        }
                        ((DynamicObject)reqIndicatorEntryDoc.get(adoptqtyIndex)).set(valueFieldKey, (Object)preValue);
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)adoptqtyindicator, (CharSequence)RequireplanIndicatorEnum.FFILLQTY.getId())) {
                    for (i = 0; i < fpreperiodsJa.size(); ++i) {
                        valueFieldKey = String.format("%s%s", "value", i + 1);
                        BigDecimal fillValue = null;
                        if (fillqtyIndicatorEntryDo != null) {
                            fillValue = fillqtyIndicatorEntryDo.getBigDecimal(valueFieldKey, true);
                        }
                        BigDecimal avgpriceValue = null;
                        if (avgpriceIndicatorEntryDo != null) {
                            avgpriceValue = avgpriceIndicatorEntryDo.getBigDecimal(valueFieldKey, true);
                        }
                        BigDecimal amountValue = null;
                        if (fillValue != null && avgpriceValue != null) {
                            amountValue = fillValue.multiply(avgpriceValue).setScale(2, RoundingMode.HALF_UP);
                        }
                        ((DynamicObject)reqIndicatorEntryDoc.get(adoptqtyIndex)).set(valueFieldKey, (Object)fillValue);
                        ((DynamicObject)reqIndicatorEntryDoc.get(amountIndex)).set(valueFieldKey, (Object)amountValue);
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{requirePlanEntryDo});
        }
    }

    private void syncRequirePlanEntryFromSalsePlan(String billTitle, Long periodId, JSONArray fpreperiodsJa, RequirePlanPushDownParams requirePlanPushDownParams) {
        log.info("sync requireplanentry from salesplan start... billTitle:{}, periodId:{}", (Object)billTitle, (Object)periodId);
        QFilter requirePlanQFilter = new QFilter("billtitle", "=", (Object)billTitle).and("periodid", "=", (Object)periodId);
        DynamicObject requirePlanDo = BusinessDataServiceHelper.loadSingle((String)"ids_requireplan", (QFilter[])requirePlanQFilter.toArray());
        if (requirePlanDo == null) {
            log.info("replainPlan not found with billTitle : {}, periodId : {}.", (Object)billTitle, (Object)periodId);
            return;
        }
        long requireplanid = (Long)requirePlanDo.getPkValue();
        String salesplanSubEntryValueFields = "";
        for (int i = 0; i < 12; ++i) {
            String valueFieldKey = String.format("%s.%s.value%s", "ids_salesplan_entry", "ids_salesplan_indicator", i + 1);
            salesplanSubEntryValueFields = String.format("%s,%s", salesplanSubEntryValueFields, valueFieldKey);
        }
        String algoKey = String.format("kd.ai.ids.plugin.form.salesplan.SalesPlanListPlugin.%s", "pushDownRequirePlan");
        Algo algo = Algo.create((String)algoKey);
        QFilter salesPlanQFilter = new QFilter("periodid", "=", (Object)periodId);
        List selectedIdList = requirePlanPushDownParams.getSelectedIdList();
        if (CollectionUtils.isNotEmpty((Collection)selectedIdList)) {
            salesPlanQFilter.and("id", "in", (Object)selectedIdList);
        }
        String groupByFields = "periodid,orgid,warehouseid,custid,ids_salesplan_entry.materialid,ids_salesplan_entry.ids_salesplan_indicator.indicator";
        String[] groupByFieldArr = groupByFields.split(",");
        DataSet salesplanDataSet = algo.createDataSet(new Input[]{new OrmInput(algoKey, "ids_salesplan", groupByFields + salesplanSubEntryValueFields, salesPlanQFilter.toArray())});
        GroupbyDataSet groupbyDataSet = salesplanDataSet.groupBy(groupByFieldArr);
        for (int i = 0; i < fpreperiodsJa.size(); ++i) {
            String sumField = String.format("%s.%s.value%s", "ids_salesplan_entry", "ids_salesplan_indicator", i + 1);
            String sumFieldAlias = String.format("sumvalue%s", i + 1);
            groupbyDataSet.sum(sumField, sumFieldAlias);
        }
        ArrayList<Long> realSyncRequirePlanEntryIdList = new ArrayList<Long>();
        DataSet groupByFinishDateSet = groupbyDataSet.finish();
        while (groupByFinishDateSet.hasNext()) {
            Row row = groupByFinishDateSet.next();
            String indicator = row.getString(String.format("%s.%s.%s", "ids_salesplan_entry", "ids_salesplan_indicator", "indicator"));
            if (!StringUtils.equalsIgnoreCase((CharSequence)indicator, (CharSequence)SalesplanIndicatorEnum.FFILLQTY.getId())) continue;
            long orgid = row.getLong("orgid");
            long warehouseid = row.getLong("warehouseid");
            long custid = row.getLong("custid");
            long materialid = row.getLong(String.format("%s.%s", "ids_salesplan_entry", "materialid"));
            ArrayList<BigDecimal> valueList = new ArrayList<BigDecimal>(fpreperiodsJa.size());
            for (int i = 0; i < fpreperiodsJa.size(); ++i) {
                String sumFieldAlias = String.format("sumvalue%s", i + 1);
                valueList.add(row.getBigDecimal(sumFieldAlias));
            }
            QFilter requirePlanEntryQFilter = new QFilter("requireplanid", "=", (Object)requireplanid).and("orgid", "=", (Object)orgid).and("warehouseid", "=", (Object)warehouseid).and("custid", "=", (Object)custid).and("materialid", "=", (Object)materialid);
            DynamicObject preObjRequirePlanEntryDo = BusinessDataServiceHelper.loadSingle((String)"ids_requireplan_entry", (QFilter[])requirePlanEntryQFilter.toArray());
            if (preObjRequirePlanEntryDo == null) continue;
            realSyncRequirePlanEntryIdList.add((Long)preObjRequirePlanEntryDo.getPkValue());
            DynamicObjectCollection reqIndicatorEntryDoc = preObjRequirePlanEntryDo.getDynamicObjectCollection("ids_req_indicator_entry");
            if (reqIndicatorEntryDoc != null && reqIndicatorEntryDoc.size() > 0) {
                for (DynamicObject reqIndicatorEntryDo : reqIndicatorEntryDoc) {
                    String entryIndicator = reqIndicatorEntryDo.getString("indicator");
                    if (!StringUtils.equalsIgnoreCase((CharSequence)entryIndicator, (CharSequence)SalesplanIndicatorEnum.FFILLQTY.getId())) continue;
                    for (int i = 0; i < fpreperiodsJa.size(); ++i) {
                        reqIndicatorEntryDo.set(String.format("%s%s", "value", i + 1), valueList.get(i));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{preObjRequirePlanEntryDo});
            this.fillAdoptqtyDefaultValue(preObjRequirePlanEntryDo, requirePlanPushDownParams, requirePlanDo);
        }
        this.saveSalesplanPushHis(periodId, requireplanid, selectedIdList);
        if (realSyncRequirePlanEntryIdList != null && realSyncRequirePlanEntryIdList.size() > 0) {
            QFilter requirePlanEntryQFilter = new QFilter("requireplanid", "=", (Object)requireplanid).and("id", "not in", realSyncRequirePlanEntryIdList);
            DeleteServiceHelper.delete((String)"ids_requireplan_entry", (QFilter[])requirePlanEntryQFilter.toArray());
        }
        log.info("sync requireplanentry from salesplan end. billTitle:{}, periodId:{}", (Object)billTitle, (Object)periodId);
    }

    private void saveSalesplanPushHis(Long periodId, long requireplanid, List<Long> selectedIdList) {
        DynamicObject[] salesplanPushHisDoArr = new DynamicObject[CollectionUtils.isNotEmpty(selectedIdList) ? selectedIdList.size() : 1];
        if (CollectionUtils.isNotEmpty(selectedIdList)) {
            for (int i = 0; i < selectedIdList.size(); ++i) {
                Long salesplanid = selectedIdList.get(i);
                DynamicObject salesplanPushHisDo = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_SALESPLAN_PUSH_HIS.getId());
                salesplanPushHisDo.set("salesplanid", (Object)salesplanid);
                salesplanPushHisDo.set("requireplanid", (Object)requireplanid);
                salesplanPushHisDoArr[i] = salesplanPushHisDo;
            }
        } else {
            DynamicObject salesplanPushHisDo = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_SALESPLAN_PUSH_HIS.getId());
            salesplanPushHisDo.set("periodid", (Object)periodId);
            salesplanPushHisDo.set("requireplanid", (Object)requireplanid);
            salesplanPushHisDoArr[0] = salesplanPushHisDo;
        }
        SaveServiceHelper.save((DynamicObject[])salesplanPushHisDoArr);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        JSONObject fieldKeyRenameJo = this.getCache().getAsObject(KEY_FIELDKEY_RENAME_MAP);
        List hideFieldKeyList = this.getCache().getAsList(KEY_HIDE_FIELD_KEY_LIST, String.class);
        ArrayList<IListColumn> newColumns = new ArrayList<IListColumn>();
        List columns = args.getListColumns();
        for (IListColumn listColumn : columns) {
            String fieldKey = listColumn.getListFieldKey();
            if (hideFieldKeyList.contains(fieldKey)) continue;
            if (fieldKeyRenameJo != null && fieldKeyRenameJo.containsKey((Object)fieldKey) && listColumn instanceof ListColumn) {
                ListColumn colText1 = (ListColumn)listColumn;
                colText1.setCaption(new LocaleString(fieldKeyRenameJo.getString(fieldKey)));
            }
            newColumns.add(listColumn);
        }
        args.setListColumns(newColumns);
    }

    public void beforeBindData(EventObject e) {
        QFilter qFilter;
        DynamicObject salesplanDo;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long periodId = (Long)formShowParameter.getCustomParam("periodid");
        if (periodId == null) {
            periodId = this.getLastPeriodId();
        }
        if ((salesplanDo = BusinessDataServiceHelper.loadSingle((String)"ids_salesplan", (QFilter[])(qFilter = new QFilter("periodid", "=", (Object)periodId)).toArray())) != null) {
            String fmodeltypeid = salesplanDo.getString("modeltypeid");
            this.accordBizAssociateSchemeHideField(fmodeltypeid, periodId);
        }
    }

    private Long getLastPeriodId() {
        DynamicObject periodDo;
        Long periodId = null;
        DynamicObject[] lastSingleSalesplanDoArr = BusinessDataServiceHelper.load((String)"ids_salesplan", (String)"id,periodid", null, (String)"id desc", (int)1);
        if (lastSingleSalesplanDoArr != null && lastSingleSalesplanDoArr.length > 0 && (periodDo = lastSingleSalesplanDoArr[0].getDynamicObject("periodid")) != null) {
            periodId = (Long)periodDo.getPkValue();
        }
        return periodId;
    }

    private void accordBizAssociateSchemeHideField(String fmodeltypeid, long periodId) {
        DynamicObject bizAssociateSchemeDo;
        JSONObject configJo;
        JSONArray fpreperiodsJa;
        BillList list = (BillList)this.getControl("billlistap");
        IFormView formView = list.getView();
        HashMap<String, String> fieldKeyRenameMap = new HashMap<String, String>();
        ArrayList<Object> hideFieldKeyList = new ArrayList<Object>();
        DynamicObject salesplanPeriodDo = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)"ids_salesplan_period");
        if (salesplanPeriodDo != null && (fpreperiodsJa = (configJo = JSONObject.parseObject((String)salesplanPeriodDo.getString("config_tag"))).getJSONArray("fpreperiods")) != null && fpreperiodsJa.size() > 0) {
            int i;
            for (i = 0; i < fpreperiodsJa.size(); ++i) {
                String period = fpreperiodsJa.getString(i);
                fieldKeyRenameMap.put(String.format("%s%s", "value", i + 1), period);
            }
            for (i = fpreperiodsJa.size(); i < 12; ++i) {
                String fieldKey = String.format("%s%s", "value", i + 1);
                formView.setVisible(Boolean.FALSE, new String[]{fieldKey});
                hideFieldKeyList.add(fieldKey);
            }
        }
        if ((bizAssociateSchemeDo = this.getCurrentBizAssociateSchemeDo(fmodeltypeid)) != null) {
            DynamicObjectCollection fieldMappingDoc = bizAssociateSchemeDo.getDynamicObjectCollection("field_mapping_entry");
            ArrayList<String> needShowFieldList = new ArrayList<String>(10);
            if (fieldMappingDoc != null && fieldMappingDoc.size() > 0) {
                for (DynamicObject fieldMappingDo : fieldMappingDoc) {
                    String quoteField = fieldMappingDo.getString("quotefield");
                    String bizobjField = fieldMappingDo.getString("bizobjfield");
                    if (StringUtils.isEmpty((CharSequence)quoteField) || StringUtils.isEmpty((CharSequence)bizobjField)) continue;
                    String[] splitArr = bizobjField.split("\\.");
                    String realBizobjFieldId = splitArr[splitArr.length - 1];
                    String renameField = fieldMappingDo.getString("renamefield");
                    if (StringUtils.isNotEmpty((CharSequence)renameField)) {
                        fieldKeyRenameMap.put(realBizobjFieldId, renameField);
                        fieldKeyRenameMap.put(String.format("%s.name", realBizobjFieldId), renameField);
                        if (StringUtils.equalsIgnoreCase((CharSequence)realBizobjFieldId, (CharSequence)"bizoperatorid")) {
                            fieldKeyRenameMap.put(String.format("%s.operatorname", realBizobjFieldId), renameField);
                        }
                    }
                    needShowFieldList.add(realBizobjFieldId);
                }
            }
            ArrayList<String> needHideFieldList = new ArrayList<String>(Arrays.asList(SalesplanFieldKeyConst.CAN_HIDE_FIELD_LIST));
            needHideFieldList.removeAll(needShowFieldList);
            for (String hideField : needHideFieldList) {
                formView.setVisible(Boolean.FALSE, new String[]{String.format("%s_name", hideField)});
                hideFieldKeyList.add(String.format("%s.name", hideField));
            }
            if (needHideFieldList.contains("bizoperatorid")) {
                formView.setVisible(Boolean.FALSE, new String[]{String.format("%s_operatorname", "bizoperatorid")});
                hideFieldKeyList.add(String.format("%s.operatorname", "bizoperatorid"));
            }
            if (needHideFieldList.contains("materialid")) {
                formView.setVisible(Boolean.FALSE, new String[]{String.format("%s_number", "materialid")});
                formView.setVisible(Boolean.FALSE, new String[]{String.format("%s_%s", "materialid", "modelnum")});
                formView.setVisible(Boolean.FALSE, new String[]{String.format("%s_%s_name", "materialid", "baseunit")});
                hideFieldKeyList.add(String.format("%s.number", "materialid"));
                hideFieldKeyList.add(String.format("%s.%s", "materialid", "modelnum"));
                hideFieldKeyList.add(String.format("%s.%s.name", "materialid", "baseunit"));
            }
            this.getCache().put(KEY_FIELDKEY_RENAME_MAP, JSONObject.toJSONString(fieldKeyRenameMap));
            this.getCache().put(KEY_HIDE_FIELD_KEY_LIST, JSONObject.toJSONString(hideFieldKeyList));
        }
    }

    private DynamicObject getCurrentBizAssociateSchemeDo(String fmodeltypeid) {
        QFilter qFilter = new QFilter("appid", "=", (Object)this.dataAppService().getSalesForecastAppIdByPlatformCode()).and("bizobj", "=", (Object)"ids_salesplan").and("modeltypeid", "=", (Object)fmodeltypeid).and("status", "=", (Object)String.valueOf(YesNoEnum.YES.getKey()));
        DynamicObject bizAssociateSchemeDo = BusinessDataServiceHelper.loadSingle((String)"ids_biz_associate_scheme", (QFilter[])qFilter.toArray());
        return bizAssociateSchemeDo;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long periodId = (Long)formShowParameter.getCustomParam("periodid");
        if (periodId == null) {
            periodId = this.getLastPeriodId();
        }
        if (periodId != null) {
            FilterColumn periodFilter = args.getFilterColumn("periodid.number");
            periodFilter.setDefaultValue(String.valueOf(periodId));
            this.initFastFilterColumn(args, periodId);
        }
    }

    private void initFastFilterColumn(FilterContainerInitArgs args, Long periodId) {
        List fastFilterColumns = args.getFastFilterColumns();
        QFilter qFilter = new QFilter("periodid", "=", (Object)periodId);
        DynamicObject salesplanDo = BusinessDataServiceHelper.loadSingle((String)"ids_salesplan", (QFilter[])qFilter.toArray());
        if (salesplanDo != null) {
            HashMap<String, String> fieldKeyRenameMap = new HashMap<String, String>();
            ArrayList<String> needShowFieldList = new ArrayList<String>(10);
            String fmodeltypeid = salesplanDo.getString("modeltypeid");
            DynamicObject bizAssociateSchemeDo = this.getCurrentBizAssociateSchemeDo(fmodeltypeid);
            if (bizAssociateSchemeDo != null) {
                DynamicObjectCollection fieldMappingDoc = bizAssociateSchemeDo.getDynamicObjectCollection("field_mapping_entry");
                if (fieldMappingDoc != null && fieldMappingDoc.size() > 0) {
                    for (DynamicObject fieldMappingDo : fieldMappingDoc) {
                        String quoteField = fieldMappingDo.getString("quotefield");
                        String bizobjField = fieldMappingDo.getString("bizobjfield");
                        if (StringUtils.isEmpty((CharSequence)quoteField) || StringUtils.isEmpty((CharSequence)bizobjField)) continue;
                        String[] splitArr = bizobjField.split("\\.");
                        String realBizobjFieldId = splitArr[splitArr.length - 1];
                        String renameField = fieldMappingDo.getString("renamefield");
                        if (StringUtils.isNotEmpty((CharSequence)renameField)) {
                            fieldKeyRenameMap.put(realBizobjFieldId, renameField);
                            fieldKeyRenameMap.put(String.format("%s.name", realBizobjFieldId), renameField);
                            if (StringUtils.equalsIgnoreCase((CharSequence)realBizobjFieldId, (CharSequence)"bizoperatorid")) {
                                fieldKeyRenameMap.put(String.format("%s.operatorname", realBizobjFieldId), renameField);
                            }
                        }
                        needShowFieldList.add(realBizobjFieldId);
                    }
                }
                int bosuseridIndex = -1;
                int bizoperatoridIndex = -1;
                for (int i = 0; i < fastFilterColumns.size(); ++i) {
                    FilterColumn filterColumn = (FilterColumn)fastFilterColumns.get(i);
                    String fieldName = filterColumn.getFieldName();
                    if (fieldKeyRenameMap.containsKey(fieldName)) {
                        filterColumn.setCaption(new LocaleString((String)fieldKeyRenameMap.get(fieldName)));
                    }
                    if (StringUtils.contains((CharSequence)fieldName, (CharSequence)"bosuserid")) {
                        bosuseridIndex = i;
                        continue;
                    }
                    if (!StringUtils.contains((CharSequence)fieldName, (CharSequence)"bizoperatorid")) continue;
                    bizoperatoridIndex = i;
                }
                if (!needShowFieldList.contains("bosuserid")) {
                    fastFilterColumns.remove(bosuseridIndex);
                }
                if (!needShowFieldList.contains("bizoperatorid")) {
                    fastFilterColumns.remove(bizoperatoridIndex);
                }
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }
}

