/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.salesplan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.ai.ids.core.enumtype.ModelConfigItemEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.form.BaseListPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class SalesPlanPeriodListPlugin
extends BaseListPlugin {
    private static final Log log = LogFactory.getLog(SalesPlanPeriodListPlugin.class);
    private static final String KEY_BILLLIST = "billlistap";
    private static final String KEY_TOOLBARAP = "toolbarap";
    private static final String KEY_RE_GENERATE = "regenerate";
    public static final String KEY_REFRESH = "refresh";
    public static final String KEY_DELETE_PERIOD = "deleteperiod";

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("number".equals(args.getFieldName()) && args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent) {
            args.setCancel(true);
            BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow currentRow = linkClickEvent.getCurrentRow();
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setFormId("bos_list");
            listShowParameter.setBillFormId("ids_salesplan");
            listShowParameter.setCaption(currentRow.getName());
            listShowParameter.setCustomParam("periodid", currentRow.getPrimaryKeyValue());
            listShowParameter.setCustomParam("name", (Object)currentRow.getName());
            listShowParameter.setSelectedEntity("ids_salesplan");
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        RequestContext rc = RequestContext.get();
        Object source = args.getSource();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            ListSelectedRowCollection listSelectedData = donothing.getListSelectedData();
            String operateKey = donothing.getOperateKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_RE_GENERATE)) {
                TenantDTO tenantDTO = this.getTenantDTO();
                String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
                String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
                this.getCache().put("subServiceId", subServiceId);
                QFilter qFilter = new QFilter("appid", "=", (Object)this.dataAppService().getSalesForecastAppIdByPlatformCode()).and("bizobj", "=", (Object)"ids_salesplan").and("status", "=", (Object)String.valueOf(YesNoEnum.YES.getKey()));
                DynamicObject[] bizAssociateSchemeDoArr = BusinessDataServiceHelper.load((String)"ids_biz_associate_scheme", (String)"id,modeltypeid", (QFilter[])qFilter.toArray());
                if (bizAssociateSchemeDoArr != null && bizAssociateSchemeDoArr.length > 0) {
                    String existedBillTitles = this.getWillGeneratePeriodTitles(rc, subServiceId, bizAssociateSchemeDoArr, true);
                    if (StringUtils.isNotEmpty((CharSequence)existedBillTitles)) {
                        this.getView().showTipNotification(String.format("\u5df2\u5b58\u5728\u540d\u79f0\u4e3a\u3010%s\u3011\u7684\u9500\u552e\u8ba1\u5212\u5468\u671f\uff0c\u8bf7\u5148\u5220\u9664\u518d\u751f\u6210", existedBillTitles));
                        return;
                    }
                    String billTitles = this.getWillGeneratePeriodTitles(rc, subServiceId, bizAssociateSchemeDoArr, false);
                    if (StringUtils.isNotEmpty((CharSequence)billTitles)) {
                        String msg = ResManager.loadKDString((String)String.format("\u5c06\u751f\u6210\u3010%s\u3011\u7684\u9500\u552e\u8ba1\u5212\u5468\u671f\uff0c\r\n\u662f\u5426\u7ee7\u7eed\u6267\u884c\u751f\u6210\u64cd\u4f5c\uff1f", billTitles), (String)"SalesPlanPeriodListPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]);
                        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_RE_GENERATE, (IFormPlugin)this);
                        this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener, null, "");
                    }
                } else {
                    this.getView().showTipNotification("\u8bf7\u5148\u4e3a\u4e1a\u52a1\u5bf9\u8c61\u3010\u9500\u552e\u8ba1\u5212\u5355\u3011\u521b\u5efa\u4e1a\u52a1\u5173\u8054\u65b9\u6848", Integer.valueOf(3000));
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_DELETE_PERIOD)) {
                int selectRows = listSelectedData.size();
                String existsTitle = "";
                for (ListSelectedRow listSelectedRow : listSelectedData) {
                    Object periodId = listSelectedRow.getPrimaryKeyValue();
                    String name = listSelectedRow.getName();
                    QFilter qFilter = new QFilter("periodid", "=", periodId);
                    boolean exists = QueryServiceHelper.exists((String)"ids_requireplan", (QFilter[])qFilter.toArray());
                    if (!exists) continue;
                    existsTitle = StringUtils.isEmpty((CharSequence)existsTitle) ? name : String.format("%s,%s", existsTitle, name);
                }
                if (StringUtils.isNotEmpty((CharSequence)existsTitle)) {
                    this.getView().showTipNotification(String.format("\u3010%s\u3011\u5df2\u5b58\u5728\u9700\u6c42\u8ba1\u5212\u5355\u4e0b\u63a8\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", existsTitle));
                    return;
                }
                String msg = ResManager.loadKDString((String)String.format("\u6240\u9009%s\u4e2a\u5468\u671f\u5185\u6240\u6709\u9500\u552e\u8ba1\u5212\u5355\u5c06\u88ab\u5220\u9664\uff0c\r\n\u662f\u5426\u7ee7\u7eed\u6267\u884c\u5220\u9664\u64cd\u4f5c\uff1f", selectRows), (String)"SalesPlanPeriodListPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_DELETE_PERIOD, (IFormPlugin)this);
                this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener, null, selectRows + "");
            }
        }
    }

    private String getWillGeneratePeriodTitles(RequestContext rc, String subServiceId, DynamicObject[] bizAssociateSchemeDoArr, boolean existed) {
        String billTitles = "";
        for (int i = 0; i < bizAssociateSchemeDoArr.length; ++i) {
            String fmodeltypeid = bizAssociateSchemeDoArr[i].getString("modeltypeid");
            String fitemKey = String.format("%s%s", ModelConfigItemEnum.SALES_PLAN_CONFIG_PREFIX.getId(), fmodeltypeid);
            JSONObject dataJo = this.commonService().getModelConfigItem(Long.valueOf(rc.getOrgId()), subServiceId, fitemKey);
            JSONObject configJo = dataJo.getJSONObject(fitemKey).getJSONObject("fitemvalue");
            String billTitle = configJo.getString("fbilltitle");
            if (existed) {
                Long periodId = this.salesPlanPeriodService().getPeriodIdByName(billTitle);
                if (periodId == null || periodId <= 0L) continue;
                billTitles = StringUtils.isEmpty((CharSequence)billTitles) ? billTitle : String.format("%s,%s", billTitles, billTitle);
                continue;
            }
            billTitles = StringUtils.isEmpty((CharSequence)billTitles) ? billTitle : String.format("%s,%s", billTitles, billTitle);
        }
        return billTitles;
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        RequestContext rc = RequestContext.get();
        if (StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)KEY_DELETE_PERIOD)) {
            if (e.getResult() == MessageBoxResult.Yes) {
                BillList billList = (BillList)this.getControl(KEY_BILLLIST);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                Object[] pkArray = selectedRows.getPrimaryKeyValues();
                QFilter periodQFilter = new QFilter("periodid", "in", (Object)pkArray);
                DeleteServiceHelper.delete((String)"ids_salesplan", (QFilter[])periodQFilter.toArray());
                QFilter qFilter = new QFilter("id", "in", (Object)pkArray);
                int delete = DeleteServiceHelper.delete((String)"ids_salesplan_period", (QFilter[])qFilter.toArray());
                if (pkArray.length == delete) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"Common_Operation_Success", (String)"ai-ids-plugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation(KEY_REFRESH);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)KEY_RE_GENERATE) && e.getResult() == MessageBoxResult.Yes) {
            String subServiceId = this.getCache().get("subServiceId");
            QFilter qFilter = new QFilter("appid", "=", (Object)this.dataAppService().getSalesForecastAppIdByPlatformCode()).and("bizobj", "=", (Object)"ids_salesplan").and("status", "=", (Object)String.valueOf(YesNoEnum.YES.getKey()));
            DynamicObject[] bizAssociateSchemeDoArr = BusinessDataServiceHelper.load((String)"ids_biz_associate_scheme", (String)"id,modeltypeid", (QFilter[])qFilter.toArray());
            if (bizAssociateSchemeDoArr != null && bizAssociateSchemeDoArr.length > 0) {
                String existedBillTitles = this.getWillGeneratePeriodTitles(rc, subServiceId, bizAssociateSchemeDoArr, true);
                if (StringUtils.isNotEmpty((CharSequence)existedBillTitles)) {
                    this.getView().showTipNotification(String.format("\u5df2\u5b58\u5728\u540d\u79f0\u4e3a\u3010%s\u3011\u7684\u9500\u552e\u8ba1\u5212\u5468\u671f\uff0c\u8bf7\u5148\u5220\u9664\u518d\u751f\u6210", existedBillTitles));
                    return;
                }
                Object[] pkArray = new Object[bizAssociateSchemeDoArr.length];
                for (int i = 0; i < bizAssociateSchemeDoArr.length; ++i) {
                    pkArray[i] = bizAssociateSchemeDoArr[i].getPkValue();
                }
                DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ids_biz_associate_scheme");
                DynamicObject[] selectedDynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)newDynamicObject.getDynamicObjectType());
                ThreadUtils.execute(() -> {
                    log.info("regenerate salesplan start... {}", (Object)JSONObject.toJSONString((Object)pkArray));
                    this.taskExecuteService().executeBizAssociateSchemeTask(selectedDynamicObjectArray, Long.valueOf(rc.getOrgId()), subServiceId, Long.valueOf(rc.getCurrUserId()), null);
                    log.info("regenerate salesplan end.");
                });
                ThreadUtils.sleep((long)1500L);
                this.getView().showSuccessNotification("\u91cd\u65b0\u751f\u6210\u5df2\u89e6\u53d1");
                this.getView().invokeOperation(KEY_REFRESH);
            }
        }
    }
}

