/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.salesplan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.PushdownTypeEnum;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SalesPlanPushDlgFormPlugin
extends BaseFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_PERIOD = "period";
    private static final String KEY_BILL_TITLE = "billtitle";
    private static final String KEY_PUSH_RESULT = "pushResult";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData;
        DynamicObject periodDo;
        String name = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_PERIOD) && (periodDo = (DynamicObject)(changeData = e.getChangeSet())[0].getNewValue()) != null) {
            String billTitle = periodDo.getString("name");
            billTitle = this.genRequirePlanBillTitle(billTitle);
            this.getModel().setValue(KEY_BILL_TITLE, (Object)billTitle);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String evtKey = ctl.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTNOK, (CharSequence)evtKey)) {
            QFilter requirePlanQFilter;
            DynamicObject requireplanPeriodDo;
            DynamicObject periodDo = (DynamicObject)this.getModel().getValue(KEY_PERIOD);
            String billTitle = (String)this.getModel().getValue(KEY_BILL_TITLE);
            String adoptqtyIndicator = (String)this.getModel().getValue("adoptqtyindicator");
            String pushdownType = this.getCache().get("pushdownType");
            if (periodDo == null) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u4e0b\u63a8\u7684\u9500\u552e\u8ba1\u5212\u5468\u671f");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)adoptqtyIndicator)) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u6700\u7ec8\u91c7\u7eb3\u6570\u91cf\u9ed8\u8ba4\u586b\u5145\u6307\u6807");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)billTitle)) {
                this.getView().showTipNotification("\u8bf7\u586b\u5199\u4e0b\u63a8\u751f\u6210\u9700\u6c42\u8ba1\u5212\u5355\u6807\u9898");
                return;
            }
            long periodId = (Long)periodDo.getPkValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)pushdownType, (CharSequence)PushdownTypeEnum.PUSHDOWN.getId())) {
                QFilter qFilter = new QFilter("periodid", "=", (Object)periodId).and("billstatus", "!=", (Object)BillStatusEnum.AUDITED.getId());
                int existsUnAuditedCount = ORM.create().count(((Object)((Object)this)).getClass().getName(), "ids_salesplan", "id", qFilter.toArray());
                if (existsUnAuditedCount > 0) {
                    this.getView().showTipNotification(String.format("\u9500\u552e\u8ba1\u5212\u5468\u671f\u5b58\u5728%s\u5f20\u5355\u636e\u672a\u5ba1\u6838\uff0c\u8bf7\u5148\u5ba1\u6838\u518d\u4e0b\u63a8", existsUnAuditedCount));
                    return;
                }
            }
            if ((requireplanPeriodDo = BusinessDataServiceHelper.loadSingle((String)"ids_requireplan", (String)"id,billtitle", (QFilter[])(requirePlanQFilter = new QFilter(KEY_BILL_TITLE, "=", (Object)billTitle)).toArray())) != null) {
                this.log.info("[terminated]A require plan with the same name : {} already exists, pushdown terminated.", (Object)billTitle);
                this.getView().showTipNotification(String.format("\u5df2\u5b58\u5728\u540d\u79f0\u3010%s\u3011\u7684\u9700\u6c42\u8ba1\u5212\u5355\uff0c\u8bf7\u5148\u5220\u9664\u518d\u4e0b\u63a8", billTitle));
                return;
            }
            QFilter salesplanQFilter = new QFilter("periodid", "=", (Object)periodId).and("billstatus", "=", (Object)BillStatusEnum.AUDITED.getId());
            DynamicObject salesplanDo = BusinessDataServiceHelper.loadSingle((String)"ids_salesplan", (QFilter[])salesplanQFilter.toArray());
            if (salesplanDo == null) {
                this.getView().showTipNotification("\u6682\u65e0\u5df2\u5ba1\u6838\u5355\u636e\uff0c\u7981\u6b62\u4e0b\u63a8");
                return;
            }
            JSONObject pushResult = new JSONObject();
            pushResult.put("status", (Object)Boolean.TRUE);
            pushResult.put("modeltypeid", (Object)salesplanDo.getString("modeltypeid"));
            pushResult.put("modeltypename", (Object)salesplanDo.getString("modeltypename"));
            pushResult.put(KEY_BILL_TITLE, (Object)billTitle);
            pushResult.put("periodid", salesplanDo.getDynamicObject("periodid").getPkValue());
            pushResult.put("adoptqtyindicator", (Object)adoptqtyIndicator);
            pushResult.put("pushdownType", (Object)pushdownType);
            String saveResult = JSON.toJSONString((Object)pushResult);
            this.getCache().put(KEY_PUSH_RESULT, saveResult);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long periodId = (Long)formShowParameter.getCustomParam("periodid");
        String billTitle = (String)formShowParameter.getCustomParam("name");
        String pushdownType = (String)formShowParameter.getCustomParam("pushdownType");
        if (StringUtils.equalsIgnoreCase((CharSequence)pushdownType, (CharSequence)PushdownTypeEnum.PUSHDOWN_SELECTED.getId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PERIOD});
            this.getView().setFormTitle(new LocaleString("\u4e0b\u63a8\u5f53\u524d\u9009\u4e2d\u5355\u636e\u751f\u6210\u9700\u6c42\u8ba1\u5212\u5355"));
        }
        billTitle = this.genRequirePlanBillTitle(billTitle);
        this.getModel().setValue(KEY_PERIOD, (Object)periodId);
        this.getModel().setValue(KEY_BILL_TITLE, (Object)billTitle);
        this.getCache().put("pushdownType", pushdownType);
    }

    private String genRequirePlanBillTitle(String billTitle) {
        if (StringUtils.contains((CharSequence)billTitle, (CharSequence)"\u9500\u552e\u8ba1\u5212\u5355")) {
            billTitle = billTitle.replace("\u9500\u552e\u8ba1\u5212\u5355", "\u9700\u6c42\u8ba1\u5212\u5355");
        }
        return billTitle;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)this.getCache().get(KEY_PUSH_RESULT));
    }
}

