/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.sf.std;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.ids.core.entity.model.sf.std.AppConfig;
import kd.ai.ids.core.entity.model.sf.std.SchemeConfig;
import kd.ai.ids.core.enumtype.DimEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.sf.std.SubChannelEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.FormTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AppConfigFormPlugin
extends BaseFormPlugin {
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_VECTORAP_ADD = "vectorapadd";
    private static final String KEY_LABELAP_ADD = "labelapadd";
    private static final String KEY_FLEX_ADD = "flexadd";
    private static final String KEY_ORG_DIM_NAME = "orgdimname";
    private static final String KEY_CUST_DIM_NAME = "custdimname";
    private static final String KEY_PRODUCT_DIM_NAME = "productdimname";
    private static final String KEY_FTIMEGRANULARITY_NAME = "ftimegranularityname";
    private static final String KEY_FPREDICTLENGTH_NAME = "fpredictlengthname";
    private static final String KEY_FVALUETYPE_NAME = "fvaluetypename";
    private static final String KEY_FSCHEMEID = "fschemeid";
    private static final String KEY_FENABLE = "fenable";
    private static final String KEY_SUB_CHANNEL = "subchannel";
    private static final String KEY_IS_ONLINE = "isonline";
    private static final String KEY_IS_ONLINE_TEMP = "isonlinetemp";
    private static final String KEY_VECTORAP_CONFIG = "vectorapconfig";
    private static final String KEY_VECTORAP_ENABLE = "vectorapenable";
    private static final String KEY_VECTORAP_DISABLE = "vectorapdisable";
    private static final String KEY_VECTORAP_VIEW = "vectorapview";
    private static final String KEY_VECTORAP_EDIT = "vectorapedit";
    private static final String KEY_CARD_FLEX_NEW_SCHEME = "cardflexnewscheme";
    private static final String KEY_FLEX_NEW_SCHEME = "flexnewscheme";

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    private String getSubServiceId() {
        String s = this.getCache().get("subServiceId");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
            TenantDTO tenantDTO = this.getTenantDTO();
            if (tenantDTO != null) {
                s = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
                this.setSubServiceId(s);
            }
        }
        return s;
    }

    public void setSubServiceId(String subServiceId) {
        this.getCache().put("subServiceId", subServiceId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_VECTORAP_ADD, KEY_LABELAP_ADD, KEY_FLEX_ADD, KEY_VECTORAP_CONFIG, KEY_VECTORAP_ENABLE, KEY_VECTORAP_DISABLE, KEY_VECTORAP_VIEW, KEY_VECTORAP_EDIT});
    }

    public void click(EventObject evt) {
        String controlKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (controlKey = ctl.getKey()) {
            case "vectorapadd": 
            case "labelapadd": 
            case "flexadd": {
                this.enterSchemeConfigPage(null, null, true);
                break;
            }
            case "vectorapenable": {
                this.modSchemeStatus(YesNoEnum.YES.getKey());
                break;
            }
            case "vectorapdisable": {
                this.modSchemeStatus(YesNoEnum.NO.getKey());
                break;
            }
            case "vectorapview": {
                this.viewScheme();
                break;
            }
            case "vectorapedit": {
                this.editScheme();
                break;
            }
            case "vectorapconfig": {
                this.openPredictObjConfig();
                break;
            }
        }
    }

    private void openPredictObjConfig() {
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRY_ENTITY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        String fschemeid = (String)this.getModel().getValue(KEY_FSCHEMEID, focusRow);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put(KEY_FSCHEMEID, fschemeid);
        String caption = ResManager.loadKDString((String)"\u914d\u7f6e\u9884\u6d4b\u5bf9\u8c61\u8303\u56f4", (String)"PredictObjConfigFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_PRE_OBJ_CONF.getId());
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    private void editScheme() {
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRY_ENTITY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        String fschemeid = (String)this.getModel().getValue(KEY_FSCHEMEID, focusRow);
        String isOnline = (String)this.getModel().getValue(KEY_IS_ONLINE, focusRow);
        this.enterSchemeConfigPage(fschemeid, isOnline, true);
    }

    private void viewScheme() {
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRY_ENTITY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        String fschemeid = (String)this.getModel().getValue(KEY_FSCHEMEID, focusRow);
        String isOnline = (String)this.getModel().getValue(KEY_IS_ONLINE, focusRow);
        this.enterSchemeConfigPage(fschemeid, isOnline, false);
    }

    private void enterSchemeConfigPage(String fschemeid, String isOnline, boolean canEdit) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_SCHEME_CONFIG.getId());
        showParameter.setCustomParam(KEY_FSCHEMEID, (Object)fschemeid);
        showParameter.setCustomParam(KEY_IS_ONLINE, (Object)isOnline);
        showParameter.setCustomParam("canEdit", (Object)canEdit);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String caption = "\u5e94\u7528\u914d\u7f6e-\u9884\u6d4b\u65b9\u6848";
        showParameter.setCaption(caption);
        this.getView().showForm(showParameter);
    }

    private void modSchemeStatus(int enable) {
        RequestContext rc = RequestContext.get();
        if (enable == YesNoEnum.YES.getKey()) {
            if (!PermissionServiceHelper.checkPermission((Long)rc.getCurrUserId(), (String)"1ZY6U=RCHA6Y", (String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (String)"4730fc5d000000ac")) {
                this.getView().showErrorNotification(String.format("\u65e0\"%s\"\u7684\"%s\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", IdsFormIdEnum.IDS_SF_SCHEME.getName(), "\u542f\u7528"));
                return;
            }
        } else if (enable == YesNoEnum.NO.getKey() && !PermissionServiceHelper.checkPermission((Long)rc.getCurrUserId(), (String)"1ZY6U=RCHA6Y", (String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (String)"47160c2b000000ac")) {
            this.getView().showErrorNotification(String.format("\u65e0\"%s\"\u7684\"%s\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", IdsFormIdEnum.IDS_SF_SCHEME.getName(), "\u7981\u7528"));
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRY_ENTITY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        String fschemeid = (String)this.getModel().getValue(KEY_FSCHEMEID, focusRow);
        DynamicObject schemeDo = BusinessDataServiceHelper.loadSingle((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (QFilter[])new QFilter("number", "=", (Object)fschemeid).toArray());
        schemeDo.set("enable", (Object)String.valueOf(enable));
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeDo});
        if (saveObjs.length > 0) {
            this.getModel().setValue(KEY_FENABLE, (Object)enable, focusRow);
            this.getView().updateView(KEY_ENTRY_ENTITY, focusRow);
            if (enable == YesNoEnum.YES.getKey()) {
                String fconfigTag = schemeDo.getString("config_tag");
                SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
                String fdatasource = schemeConfig.getFdatasource();
                this.sfStandardService().subServiceInit(this.getSubServiceId(), this.getTenantDTO().getTenantId(), fdatasource);
            }
            this.getView().showSuccessNotification("\u64cd\u4f5c\u6210\u529f");
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_NEW_SCHEME});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadOnlineSchemeList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOnlineSchemeList() {
        String subServiceId = this.getSubServiceId();
        this.getModel().beginInit();
        try {
            String fenable;
            JSONArray schemeJa = new JSONArray();
            JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(subServiceId);
            JSONObject subServiceJo = this.dataAppService().getSubService(subServiceId);
            String subChannel = subServiceJo.getString("subChannel");
            if (StringUtils.equalsIgnoreCase((CharSequence)subChannel, (CharSequence)SubChannelEnum.IDS.getId())) {
                DynamicObject[] schemeDoArr;
                HashMap onlineSchemeJoMap = new HashMap();
                if (dataJa != null) {
                    for (Object e : dataJa) {
                        JSONObject schememJo = (JSONObject)e;
                        onlineSchemeJoMap.put(String.valueOf(schememJo.getIntValue(KEY_FSCHEMEID)), schememJo);
                    }
                }
                if ((schemeDoArr = BusinessDataServiceHelper.load((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (String)"id,name,number,enable,config_tag,bizstatus", null, (String)" id asc")) != null) {
                    for (DynamicObject dynamicObject : schemeDoArr) {
                        JSONObject schemeJo = new JSONObject();
                        String fschemeid = dynamicObject.getString("number");
                        schemeJo.put("fname", (Object)dynamicObject.getString("name"));
                        schemeJo.put(KEY_FSCHEMEID, (Object)Integer.parseInt(dynamicObject.getString("number")));
                        schemeJo.put("fconfigTag", (Object)dynamicObject.getString("config_tag"));
                        fenable = dynamicObject.getBoolean("enable") ? YesNoEnum.YES.getKeyStr() : YesNoEnum.NO.getKeyStr();
                        schemeJo.put(KEY_FENABLE, (Object)fenable);
                        String isOnlineTemp = dynamicObject.getBoolean("bizstatus") ? YesNoEnum.YES.getKeyStr() : YesNoEnum.NO.getKeyStr();
                        String isOnline = onlineSchemeJoMap.containsKey(fschemeid) ? YesNoEnum.YES.getKeyStr() : YesNoEnum.NO.getKeyStr();
                        schemeJo.put(KEY_IS_ONLINE, (Object)isOnline);
                        schemeJo.put(KEY_IS_ONLINE_TEMP, (Object)isOnlineTemp);
                        schemeJa.add((Object)schemeJo);
                    }
                }
            } else {
                schemeJa = dataJa;
                if (schemeJa != null && schemeJa.size() > 0) {
                    for (Object obj : schemeJa) {
                        JSONObject jSONObject = (JSONObject)obj;
                        jSONObject.put(KEY_IS_ONLINE, (Object)YesNoEnum.YES.getKeyStr());
                        jSONObject.put(KEY_IS_ONLINE_TEMP, (Object)YesNoEnum.YES.getKeyStr());
                    }
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CARD_FLEX_NEW_SCHEME});
            }
            if (schemeJa != null && schemeJa.size() > 0) {
                JSONObject dataJo = this.sfStandardService().appConfigGet(subServiceId);
                JSONObject appConfigJo = dataJo.getJSONObject("appConfig");
                AppConfig appConfig = (AppConfig)JSONObject.parseObject((String)appConfigJo.toJSONString(), AppConfig.class);
                int modelCount = schemeJa.size();
                this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY, modelCount);
                for (int index = 0; index < schemeJa.size(); ++index) {
                    JSONObject jSONObject = (JSONObject)schemeJa.get(index);
                    String fschemeid = String.valueOf(jSONObject.getInteger(KEY_FSCHEMEID));
                    String fname = jSONObject.getString("fname");
                    fenable = jSONObject.getString(KEY_FENABLE);
                    String fconfigTag = jSONObject.getString("fconfigTag");
                    String isOnlineTemp = jSONObject.getString(KEY_IS_ONLINE_TEMP);
                    String isOnline = jSONObject.containsKey((Object)KEY_IS_ONLINE) ? jSONObject.getString(KEY_IS_ONLINE) : YesNoEnum.NO.getKeyStr();
                    SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
                    String orgDimName = schemeConfig.getDimName(appConfig, DimEnum.ORG);
                    String custDimName = schemeConfig.getDimName(appConfig, DimEnum.CUST);
                    String productDimName = schemeConfig.getDimName(appConfig, DimEnum.PRODUCT);
                    String ftimegranularityName = schemeConfig.getFtimegranularityName(appConfig);
                    String fvaluetypeName = schemeConfig.getFvaluetypeName(appConfig);
                    this.getModel().setValue(KEY_FSCHEMEID, (Object)fschemeid, index);
                    this.getModel().setValue("fname", (Object)fname, index);
                    this.getModel().setValue(KEY_ORG_DIM_NAME, (Object)orgDimName, index);
                    this.getModel().setValue(KEY_CUST_DIM_NAME, (Object)custDimName, index);
                    this.getModel().setValue(KEY_PRODUCT_DIM_NAME, (Object)productDimName, index);
                    this.getModel().setValue(KEY_FTIMEGRANULARITY_NAME, (Object)ftimegranularityName, index);
                    this.getModel().setValue(KEY_FPREDICTLENGTH_NAME, (Object)schemeConfig.getFpredictlength(), index);
                    this.getModel().setValue(KEY_FVALUETYPE_NAME, (Object)fvaluetypeName, index);
                    this.getModel().setValue(KEY_FENABLE, (Object)fenable, index);
                    this.getModel().setValue(KEY_SUB_CHANNEL, (Object)subChannel, index);
                    this.getModel().setValue(KEY_IS_ONLINE, (Object)isOnline, index);
                    this.getModel().setValue(KEY_IS_ONLINE_TEMP, (Object)isOnlineTemp, index);
                }
            }
        }
        finally {
            this.getModel().endInit();
        }
        FormTools.cachePageId(this.getView());
    }
}

