/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.sf.std;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import java.util.UUID;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.entity.model.sf.std.AppExecuteLogDTO;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.ExecuteTypeEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.RetryTypeEnum;
import kd.ai.ids.core.enumtype.sf.std.AppExecuteLogNodeEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ExecProcessFormPlugin
extends BaseFormPlugin {
    private static final String KEY_WIZARDAP = "wizardap";
    private static final String KEY_VECTORAP_CONFIG = "vectorapconfig";
    private static final String KEY_VECTORAP_ENABLE = "vectorapenable";
    private static final String KEY_VECTORAP_DISABLE = "vectorapdisable";
    private static final String KEY_VECTORAP_VIEW = "vectorapview";
    private static final String KEY_IMAGEAP_MODEL_CALCULATE = "imageapmodelcalculate";
    private static final String KEY_UPLOAD_TASK_NUMBER = "uploadtasknumber";
    private static final String KEY_UPLOAD_TASK_NAME = "uploadtaskname";
    private static final String KEY_UPLOAD_TASK_RULE = "uploadtaskrule";
    private static final String KEY_QUERY_TASK_NUMBER = "querytasknumber";
    private static final String KEY_QUERY_TASK_NAME = "querytaskname";
    private static final String KEY_QUERY_TASK_RULE = "querytaskrule";
    private static final String KEY_TOOLBAR_UPLOAD = "toolbarupload";
    private static final String KEY_TOOLBAR_QUERY = "toolbarquery";
    private static final String KEY_TOOLBAR_CALCULATE = "toolbarcalculate";
    private static final String KEY_UPLOAD_TASK_EXECUTE = "uploadtaskexecute";
    private static final String KEY_QUERY_TASK_EXECUTE = "querytaskexecute";
    private static final String KEY_UPLOAD_REFRESH = "uploadrefresh";
    private static final String KEY_QUERY_REFRESH = "queryrefresh";
    private static final String KEY_CALCALATE_REFRESH = "calculaterefresh";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_MODEL_ANALYSIS = "btnmodelanalysis";
    private static final String FLEX_NODE_STATUS_N = "flexnodestatus%s";
    private static final String FLEX_STATUS_INIT_N = "flexstatusinit%s";
    private static final String FLEX_STATUS_EXECUTING_N = "flexstatusexecuting%s";
    private static final String FLEX_STATUS_SUCCESS_N = "flexstatussuccess%s";
    private static final String FLEX_STATUS_FAIL_N = "flexstatusfail%s";
    private static final String FLEX_ALL_SUCCESS = "flexallsuccess";
    private static final String FLEX_NO_RESULT = "flexnoresult";

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    private String getSubServiceId() {
        String s = this.getCache().get("subServiceId");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String appId = (String)fsp.getCustomParam("appId");
            TenantDTO tenantDTO = this.getTenantDTO();
            if (tenantDTO != null) {
                s = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), appId);
                this.setSubServiceId(s);
            }
        }
        return s;
    }

    public void setSubServiceId(String subServiceId) {
        this.getCache().put("subServiceId", subServiceId);
    }

    private String getModelVersionId() {
        return this.getCache().get("modelVersionId");
    }

    private String getExecuteId() {
        return this.getCache().get("executeId");
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBAR_UPLOAD, KEY_TOOLBAR_QUERY, KEY_TOOLBAR_CALCULATE});
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_MODEL_ANALYSIS});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operatorKey = afterDoOperationEventArgs.getOperateKey();
        RequestContext rc = RequestContext.get();
        if (StringUtils.equalsIgnoreCase((CharSequence)operatorKey, (CharSequence)KEY_UPLOAD_TASK_EXECUTE)) {
            ThreadUtils.execute(() -> {
                this.log.info("execute upload task start ...");
                String modelVersionId = this.getModelVersionId();
                String subServiceId = this.getSubServiceId();
                FormShowParameter fsp = this.getView().getFormShowParameter();
                String appId = (String)fsp.getCustomParam("appId");
                String planNumber = modelVersionId;
                DynamicObject planDo = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (QFilter[])new QFilter("number", "=", (Object)planNumber).toArray());
                String planName = planDo.getString("name");
                String executeId = UUID.randomUUID().toString();
                this.getCache().put("executeId", executeId);
                this.taskExecuteService().uploadData(Long.valueOf(rc.getOrgId()), modelVersionId, this.getTenantDTO(), appId, planName, ExecuteTypeEnum.MANUAL.getKey(), rc.getCurrUserId(), subServiceId, executeId);
                this.log.info("execute upload task end.");
            });
            this.getView().showSuccessNotification("\u4efb\u52a1\u5df2\u6210\u529f\u89e6\u53d1");
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_UPLOAD_TASK_EXECUTE});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operatorKey, (CharSequence)KEY_QUERY_TASK_EXECUTE)) {
            String subServiceId = this.getSubServiceId();
            String executeId = this.getExecuteId();
            if (StringUtils.isEmpty((CharSequence)executeId)) {
                AppExecuteLogDTO appExecuteLogDTO = this.sfStandardService().appEexecuteLogLast(subServiceId);
                if (appExecuteLogDTO != null) {
                    executeId = appExecuteLogDTO.getExecuteId();
                } else {
                    this.getView().showTipNotification("\u8bf7\u5148\u6267\u884c\u6570\u636e\u51c6\u5907\u4efb\u52a1");
                    return;
                }
            }
            String finalExecuteId = executeId;
            ThreadUtils.execute(() -> {
                this.log.info("execute query task start ...");
                FormShowParameter fsp = this.getView().getFormShowParameter();
                String appId = (String)fsp.getCustomParam("appId");
                String planNumber = subServiceId;
                DynamicObject planDo = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (QFilter[])new QFilter("number", "=", (Object)planNumber).toArray());
                String planName = planDo.getString("name");
                this.taskExecuteService().queryData(Long.valueOf(rc.getOrgId()), subServiceId, appId, this.getTenantDTO(), planName, ExecuteTypeEnum.MANUAL.getKey(), RetryTypeEnum.NORMAL.getKey(), rc.getCurrUserId(), finalExecuteId);
                this.log.info("execute query task end.");
            });
            this.getView().showSuccessNotification("\u4efb\u52a1\u5df2\u6210\u529f\u89e6\u53d1");
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_QUERY_TASK_EXECUTE});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operatorKey, (CharSequence)KEY_UPLOAD_REFRESH) || StringUtils.equalsIgnoreCase((CharSequence)operatorKey, (CharSequence)KEY_QUERY_REFRESH) || StringUtils.equalsIgnoreCase((CharSequence)operatorKey, (CharSequence)KEY_CALCALATE_REFRESH)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            this.loadNodeStatus();
            this.getView().hideLoading();
        }
    }

    public void click(EventObject evt) {
        String controlKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (controlKey = ctl.getKey()) {
            case "btnrefresh": {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
                this.loadNodeStatus();
                this.getView().hideLoading();
                break;
            }
            case "btnmodelanalysis": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_MODEL_ANALYSIS.getId());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String subServiceId = this.getSubServiceId();
        String tenantId = this.getTenantDTO().getTenantId();
        this.loadNodeStatus();
        String modelVersionId = "";
        JSONObject appModelJo = this.sfStandardService().appModelGet(subServiceId, tenantId);
        if (appModelJo != null) {
            modelVersionId = appModelJo.getString("modelVersionId");
        }
        if (CommonUtil.useMock()) {
            modelVersionId = "ids_unittestnumber";
            subServiceId = "ids_unittestnumber";
        }
        this.getCache().put("modelVersionId", modelVersionId);
        this.showUploadTask(modelVersionId);
        Image modelCalculateImage = (Image)this.getControl(KEY_IMAGEAP_MODEL_CALCULATE);
        modelCalculateImage.setUrl("kingdee/ai-ids/modelanalysic/img/model_calculate.gif");
        this.showQueryTask(subServiceId);
    }

    private void loadNodeStatus() {
        this.setNodeStatus(0);
        this.setNodeStatus(1);
        this.setNodeStatus(2);
        this.setNodeStatus(3);
    }

    private void showUploadTask(String planNumber) {
        DynamicObject planDo = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (QFilter[])new QFilter("number", "=", (Object)planNumber).toArray());
        if (planDo != null) {
            String planName = planDo.getString("name");
            String planDesc = "def".equalsIgnoreCase(planDo.getString("repeatmode")) ? planDo.getString("plan") : planDo.getString("txtdesc");
            this.getModel().setValue(KEY_UPLOAD_TASK_NUMBER, (Object)planNumber);
            this.getModel().setValue(KEY_UPLOAD_TASK_NAME, (Object)planName);
            this.getModel().setValue(KEY_UPLOAD_TASK_RULE, (Object)planDesc);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_UPLOAD_TASK_EXECUTE});
        }
    }

    private void showQueryTask(String planNumber) {
        DynamicObject planDo = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (QFilter[])new QFilter("number", "=", (Object)planNumber).toArray());
        if (planDo != null) {
            String planName = planDo.getString("name");
            String planDesc = "def".equalsIgnoreCase(planDo.getString("repeatmode")) ? planDo.getString("plan") : planDo.getString("txtdesc");
            this.getModel().setValue(KEY_QUERY_TASK_NUMBER, (Object)planNumber);
            this.getModel().setValue(KEY_QUERY_TASK_NAME, (Object)planName);
            this.getModel().setValue(KEY_QUERY_TASK_RULE, (Object)planDesc);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_QUERY_TASK_EXECUTE});
        }
    }

    private void setNodeStatus(int stepIndex) {
        Map appExecuteLogNodeStatusMap = this.sfStandardService().getAppExecuteLogNodeStatusMap(this.getSubServiceId());
        int uploadExecuteStatus = appExecuteLogNodeStatusMap.getOrDefault(AppExecuteLogNodeEnum.DATA_PREPARATION.getKey(), ExecuteStatusEnum.INIT.getKey());
        int modelCalculateExecuteStatus = appExecuteLogNodeStatusMap.getOrDefault(AppExecuteLogNodeEnum.MODEL_CALCULATE.getKey(), ExecuteStatusEnum.INIT.getKey());
        int queryExecuteStatus = appExecuteLogNodeStatusMap.getOrDefault(AppExecuteLogNodeEnum.DATA_CALLING.getKey(), ExecuteStatusEnum.INIT.getKey());
        int executeStatus = -1;
        if (stepIndex == 0) {
            executeStatus = uploadExecuteStatus;
        } else if (stepIndex == 1) {
            executeStatus = modelCalculateExecuteStatus;
        } else if (stepIndex == 2) {
            executeStatus = queryExecuteStatus;
        } else if (stepIndex == 3) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ALL_SUCCESS, FLEX_NO_RESULT});
            if (uploadExecuteStatus == ExecuteStatusEnum.SUCCESS.getKey() && modelCalculateExecuteStatus == ExecuteStatusEnum.SUCCESS.getKey() && queryExecuteStatus == ExecuteStatusEnum.SUCCESS.getKey()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ALL_SUCCESS});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_NO_RESULT});
            }
        }
        this.setFlexNodeStatusVisible(stepIndex, executeStatus);
    }

    private void setFlexNodeStatusVisible(int stepIndex, int executeStatus) {
        String flexNodeStatus = String.format(FLEX_NODE_STATUS_N, stepIndex + 1);
        String flexStatusInit = String.format(FLEX_STATUS_INIT_N, stepIndex + 1);
        String flexStatusExecuting = String.format(FLEX_STATUS_EXECUTING_N, stepIndex + 1);
        String flexStatusSuccess = String.format(FLEX_STATUS_SUCCESS_N, stepIndex + 1);
        String flexStatusFail = String.format(FLEX_STATUS_FAIL_N, stepIndex + 1);
        this.getView().setVisible(Boolean.FALSE, new String[]{flexNodeStatus, flexStatusInit, flexStatusExecuting, flexStatusSuccess, flexStatusFail});
        if (executeStatus == ExecuteStatusEnum.INIT.getKey()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{flexNodeStatus, flexStatusInit});
        } else if (executeStatus == ExecuteStatusEnum.EXECUTING.getKey()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{flexNodeStatus, flexStatusExecuting});
        } else if (executeStatus == ExecuteStatusEnum.SUCCESS.getKey()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{flexNodeStatus, flexStatusSuccess});
        } else if (executeStatus == ExecuteStatusEnum.FAIL.getKey()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{flexNodeStatus, flexStatusFail});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        boolean isOnline = false;
        if (tenantDTO != null) {
            isOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        }
        if (!isOnline) {
            e.setCancel(true);
            Object source = e.getSource();
            if (!(source instanceof FormShowParameter)) {
                return;
            }
            FormShowParameter fsp = (FormShowParameter)source;
            String parentPageId = fsp.getParentPageId();
            IdsPageCache parentCache = new IdsPageCache(parentPageId);
            parentCache.put("is_online_" + fsp.getFormId(), "false");
            parentCache.saveChanges();
        }
    }
}

