/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.sf.std;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.entity.model.sf.std.AppConfig;
import kd.ai.ids.core.entity.model.sf.std.SchemeConfig;
import kd.ai.ids.core.entity.model.sf.std.SfOnlineScheme;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.query.data.HomeOverviewQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.ListUtils;
import kd.ai.ids.core.utils.MathUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.FormTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import org.apache.commons.collections4.CollectionUtils;

public class HomeOverviewFormPlugin
extends BaseFormPlugin {
    private static final String KEY_HOME_OVERVIEW_DATA = "homeOverViewData";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_FMODELTYPEID = "fmodeltypeid";
    private static final String KEY_FMODELTYPEID_FNAME = "fmodeltypeidfname";
    private static final String KEY_CURRENT_COUNT = "currentcount";
    private static final String KEY_TOTAL_COUNT = "totalcount";
    private static final String KEY_LAST_UPDATE_TIME = "flastupdatetime";
    private static final String KEY_AVG_PREDICT_ERROR = "avgpredicterror";
    private static final String KEY_DIM_COUNT = "dimcount";
    private static final String KEY_PRE_DIM_LEVEL_NAME_N = "predimlevelname_%s";
    private static final String KEY_PRE_DIM_LEVEL_COUNT_N = "predimlevelcount_%s";
    private static final String KEY_CUSTOM_CONTROL_PREDICT_ERROR = "custompredicterror";
    private static final String KEY_VECTORAP_CONFIG = "vectorapconfig";

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    private void setSubServiceId() {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.getCache().put("subServiceId", subServiceId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_VECTORAP_CONFIG});
    }

    private Map<Integer, SfOnlineScheme> getFschemeidSchemeMap() {
        Map<Integer, SfOnlineScheme> map = new HashMap<Integer, SfOnlineScheme>();
        JSONArray onlineSchemeJa = this.sfStandardService().getOnlineSchemeList(this.getSubServiceId());
        if (onlineSchemeJa != null) {
            List sfOnlineSchemeList = onlineSchemeJa.toJavaList(SfOnlineScheme.class);
            map = sfOnlineSchemeList.stream().collect(Collectors.toMap(SfOnlineScheme::getFschemeid, a -> a, (k1, k2) -> k1));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().beginInit();
        RequestContext rc = RequestContext.get();
        this.setSubServiceId();
        String subServiceId = this.getSubServiceId();
        try {
            Date now = new Date();
            HomeOverviewQuery homeOverviewQuery = new HomeOverviewQuery();
            homeOverviewQuery.setSubServiceId(subServiceId);
            BaseResult baseResult = this.sfStandardService().getHomeOverview(Long.valueOf(rc.getOrgId()), homeOverviewQuery);
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                int modelCount;
                JSONArray dataJa = baseResult.getDataAsJSONArray();
                int n = modelCount = dataJa != null ? dataJa.size() : 0;
                if (dataJa != null && modelCount > 0) {
                    this.getCache().put(KEY_HOME_OVERVIEW_DATA, JSONArray.toJSONString((Object)dataJa));
                    this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY, modelCount);
                    AppConfig appConfig = this.getAppConfig();
                    Map<Integer, SfOnlineScheme> fschemeidSchemeMap = this.getFschemeidSchemeMap();
                    for (int index = 0; index < dataJa.size(); ++index) {
                        JSONObject jo = (JSONObject)dataJa.get(index);
                        String fschemeid = jo.getString("fschemeid");
                        String fmodeltypeidFname = jo.getString("fname");
                        SfOnlineScheme sfOnlineScheme = fschemeidSchemeMap.get(Integer.valueOf(fschemeid));
                        String fconfigTag = sfOnlineScheme.getFconfigTag();
                        SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
                        List orgList = schemeConfig.getOrg();
                        List custList = schemeConfig.getCust();
                        List productList = schemeConfig.getProduct();
                        ArrayList allDimList = new ArrayList();
                        if (orgList != null) {
                            orgList = ListUtils.subLastN((List)orgList, (int)3);
                            CollectionUtils.addAll(allDimList, (Iterable)orgList);
                        }
                        if (custList != null) {
                            CollectionUtils.addAll(allDimList, (Iterable)custList);
                        }
                        if (productList != null) {
                            CollectionUtils.addAll(allDimList, (Iterable)productList);
                        }
                        this.getModel().setValue(KEY_FMODELTYPEID, (Object)fschemeid, index);
                        this.getModel().setValue(KEY_FMODELTYPEID_FNAME, (Object)fmodeltypeidFname, index);
                        this.getModel().setValue(KEY_AVG_PREDICT_ERROR, (Object)(jo.getOrDefault((Object)"avgPredictError", (Object)0.0) + "%"), index);
                        this.getModel().setValue(KEY_LAST_UPDATE_TIME, (Object)jo.getString(KEY_LAST_UPDATE_TIME), index);
                        JSONObject homeOverviewJo = jo.getJSONObject("fhomeoverview");
                        int dimCount = 0;
                        if (homeOverviewJo != null) {
                            this.getModel().setValue(KEY_CURRENT_COUNT, (Object)MathUtils.normalNum((String)homeOverviewJo.getString("currentCount")), index);
                            this.getModel().setValue(KEY_TOTAL_COUNT, (Object)MathUtils.normalNum((String)homeOverviewJo.getString("totalCount")), index);
                            if (allDimList != null && !allDimList.isEmpty()) {
                                dimCount = allDimList.size();
                                for (int i = 0; i < dimCount; ++i) {
                                    String dimfid = (String)allDimList.get(i);
                                    String labelName = schemeConfig.getDimName(appConfig, dimfid);
                                    this.getModel().setValue(String.format(KEY_PRE_DIM_LEVEL_NAME_N, i + 1), (Object)String.format("\u9884\u6d4b%s", labelName), index);
                                    this.getModel().setValue(String.format(KEY_PRE_DIM_LEVEL_COUNT_N, i + 1), (Object)homeOverviewJo.getIntValue(String.format("%sCount", dimfid)), index);
                                }
                            }
                        }
                        this.getModel().setValue(KEY_DIM_COUNT, (Object)dimCount, index);
                    }
                    JSONArray newDataJa = new JSONArray();
                    if (dataJa != null && modelCount > 0) {
                        for (int index = 0; index < dataJa.size(); ++index) {
                            JSONObject jo = (JSONObject)dataJa.get(index);
                            String fschemeid = jo.getString("fschemeid");
                            String fmodeltypeidFname = jo.getString("fname");
                            jo.put(KEY_FMODELTYPEID, (Object)fschemeid);
                            jo.put("fmodeltypeidFname", (Object)fmodeltypeidFname);
                            newDataJa.add((Object)jo);
                        }
                    }
                    HashMap<String, Object> customData = new HashMap<String, Object>();
                    customData.put("data", newDataJa);
                    customData.put("timestamp", now.getTime());
                    customData.put("chartType", "predict_error_trend");
                    customData.put("pageId", this.getView().getPageId());
                    CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL_PREDICT_ERROR);
                    customControl.setData(customData);
                }
            }
        }
        finally {
            this.getModel().endInit();
        }
        FormTools.cachePageId(this.getView());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void click(EventObject e) {
        super.click(e);
        String controlKey = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            controlKey = ((Control)source).getKey();
        }
        switch (controlKey) {
            case "vectorapconfig": {
                this.openPredictObjConfig();
                break;
            }
        }
    }

    private AppConfig getAppConfig() {
        JSONObject dataJo = this.sfStandardService().appConfigGet(this.getSubServiceId());
        JSONObject appConfigJo = dataJo.getJSONObject("appConfig");
        String appConfigStr = appConfigJo.toJSONString();
        AppConfig appConfig = (AppConfig)JSONObject.parseObject((String)appConfigStr, AppConfig.class);
        return appConfig;
    }

    private void openPredictObjConfig() {
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRY_ENTITY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        String fmodeltypeid = (String)this.getModel().getValue(KEY_FMODELTYPEID, focusRow);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("fschemeid", fmodeltypeid);
        String caption = ResManager.loadKDString((String)"\u914d\u7f6e\u9884\u6d4b\u5bf9\u8c61\u8303\u56f4", (String)"PredictObjConfigFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_PRE_OBJ_CONF.getId());
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        boolean isOnline = false;
        if (tenantDTO != null) {
            isOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        }
        if (!isOnline) {
            e.setCancel(true);
            Object source = e.getSource();
            if (!(source instanceof FormShowParameter)) {
                return;
            }
            FormShowParameter fsp = (FormShowParameter)source;
            String parentPageId = fsp.getParentPageId();
            IdsPageCache parentCache = new IdsPageCache(parentPageId);
            parentCache.put("is_online_" + fsp.getFormId(), "false");
            parentCache.saveChanges();
        } else {
            String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
            JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(subServiceId);
            if (dataJa == null || dataJa.size() == 0) {
                e.setCancel(true);
                Object source = e.getSource();
                if (!(source instanceof FormShowParameter)) {
                    return;
                }
                FormShowParameter fsp = (FormShowParameter)source;
                String parentPageId = fsp.getParentPageId();
                IdsPageCache parentCache = new IdsPageCache(parentPageId);
                parentCache.put("is_scheme_online_" + fsp.getFormId(), "false");
                parentCache.saveChanges();
            }
        }
    }
}

