/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.sf.std;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.ids.core.query.sf.std.StandardFilterItemQuery;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.util.StringUtils;

public class ModelAnalysisChart {
    private static final String[] AL_COLOR = new String[]{"#F273B5", "#6682F5", "#45DAD1"};
    private static final String[] LINE_COLOR = new String[]{"#8F8F8F", "#C8A786", "#40A9FF"};
    private static final String[] BAR_COLOR = new String[]{"#40a9ff", "#45dad1", "#73d13d", "#9f69e2"};
    private static final String SVG_LINE = "path://M960 521.728c0 75.84-62.08 137.856-137.792 137.856L201.856 659.584C126.016 659.584 64 597.568 64 521.728L64 502.336c0-75.84 62.016-137.856 137.856-137.856l620.352 0C897.92 364.416 960 426.496 960 502.336L960 521.728z";
    private static final String SVG_SQUARE = "path://M1024 127.937531v767.625183c0 70.665495-57.272035 127.937531-127.937531 127.93753h-767.625183c-70.665495 0-127.937531-57.272035-127.93753-127.93753v-767.625183c0-70.665495 57.272035-127.937531 127.93753-127.937531h767.625183c70.665495 0 127.937531 57.272035 127.937531 127.937531z";

    public void refreshAnaYearTrend(JSONObject dataJo, StandardFilterItemQuery filterItemQuery, PointLineChart pointLineChart, String fvaluetypeName) {
        pointLineChart.clearData();
        pointLineChart.setName(new LocaleString(""));
        this.baseSettingChart((Chart)pointLineChart);
        JSONArray ftimeJa = CommonUtil.emptyIfNull((JSONArray)dataJo.getJSONArray("ftimeList"));
        List xData = ftimeJa.toJavaList(String.class);
        this.setAxisYearTrend((Chart)pointLineChart, ResManager.loadKDString((String)"\u65e5\u671f", (String)"ModelAnalysisFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]), fvaluetypeName, xData);
        JSONArray valueArray = dataJo.getJSONArray("valueArray");
        ArrayList<Map<String, Object>> legendData = new ArrayList<Map<String, Object>>(4);
        if (valueArray != null && !valueArray.isEmpty()) {
            int lineIndex = 0;
            int alIndex = 0;
            for (int j = 0; j < valueArray.size(); ++j) {
                HashMap<String, String> lineStyle;
                JSONObject valueJo = valueArray.getJSONObject(j);
                String algorithmId = valueJo.getString("algorithmId");
                JSONArray valueJa = CommonUtil.emptyIfNull((JSONArray)valueJo.getJSONArray("value"));
                List numbers = valueJa.toJavaList(Double.class);
                String name = valueJo.getString("label");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", name);
                map.put("data", numbers.toArray(new Number[0]));
                if (StringUtils.isNotEmpty((String)algorithmId)) {
                    lineStyle = new HashMap<String, String>();
                    lineStyle.put("type", "dashed");
                    map.put("lineStyle", lineStyle);
                    map.put("symbol", "emptyCircle");
                    map.put("lineColor", this.getAlColor(alIndex));
                    legendData.add(this.createLegend(name, null));
                    ++alIndex;
                } else {
                    lineStyle = new HashMap();
                    lineStyle.put("type", "solid");
                    map.put("lineStyle", lineStyle);
                    map.put("symbol", "circle");
                    map.put("lineColor", this.getLineColor(lineIndex));
                    legendData.add(this.createLegend(name, SVG_LINE));
                    ++lineIndex;
                }
                this.setLineSeriesYearTrend((Chart)pointLineChart, map);
            }
        }
        this.setLegendData((Chart)pointLineChart, legendData);
        pointLineChart.refresh();
    }

    private String getLineColor(int i) {
        return i >= 0 && i < LINE_COLOR.length ? LINE_COLOR[i] : null;
    }

    private String getBarColor(int i) {
        return i >= 0 && i < BAR_COLOR.length ? BAR_COLOR[i] : null;
    }

    private String getAlColor(int i) {
        return i >= 0 && i < AL_COLOR.length ? AL_COLOR[i] : null;
    }

    private Map<String, Object> createLegend(String name, String icon) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        if (StringUtils.isNotEmpty((String)icon)) {
            map.put("icon", icon);
        }
        return map;
    }

    public void baseSettingChart(Chart chart) {
        chart.setShowTooltip(true);
        chart.setShowTitle(true);
        chart.setShowLegend(true);
        chart.setMerge(false);
        chart.setLegendVertical(false);
        chart.setLegendPropValue("width", (Object)"70%");
        chart.setMargin(Position.right, "1%");
    }

    private Map<String, Object> wrapLineStyle(Map<String, Object> lineStyle) {
        if (lineStyle == null || lineStyle.isEmpty()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("normal", lineStyle);
        return map;
    }

    public void setLineSeriesYearTrend(Chart chart, Map<String, Object> settings) {
        String name = (String)settings.get("name");
        Number[] number = (Number[])settings.get("data");
        String stack = (String)settings.get("stack");
        String lineColor = (String)settings.get("lineColor");
        Map lineStyle = (Map)settings.get("lineStyle");
        LineSeries lineSeries = chart.createLineSeries(name);
        lineSeries.setPropValue("lineStyle", this.wrapLineStyle(lineStyle));
        lineSeries.setData(number);
        lineSeries.setName(name);
        lineSeries.setStack(stack);
        lineSeries.setLineColor(lineColor);
        lineSeries.setItemColor(lineColor);
        String symbol = (String)settings.get("symbol");
        if (StringUtils.isEmpty((String)symbol)) {
            symbol = "emptyCircle";
        }
        lineSeries.setPropValue("symbol", (Object)symbol);
    }

    public void setAxisYearTrend(Chart chart, String xAxisName, String yAxisName, List<String> xData) {
        Axis x = chart.createXAxis(xAxisName, AxisType.category);
        chart.createYAxis(yAxisName, AxisType.value);
        x.setPropValue("data", xData);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        x.setPropValue("axisTick", axisTick);
        HashMap<String, String[]> axisLine = new HashMap<String, String[]>();
        String[] symbolArr = new String[]{"none", "none"};
        axisLine.put("symbol", symbolArr);
        x.setPropValue("axisLine", axisLine);
        HashMap<String, Boolean> splitLine = new HashMap<String, Boolean>();
        splitLine.put("show", Boolean.FALSE);
        x.setPropValue("splitLine", splitLine);
    }

    public void setLegendData(Chart chart, List<Map<String, Object>> data) {
        chart.setLegendPropValue("data", data);
        chart.setLegendPropValue("itemWidth", (Object)20);
        chart.setLegendAlign(XAlign.center, YAlign.top);
    }
}

