/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.sf.std;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.entity.model.sf.std.AppConfig;
import kd.ai.ids.core.entity.model.sf.std.Fdim;
import kd.ai.ids.core.entity.model.sf.std.Ftype;
import kd.ai.ids.core.entity.model.sf.std.SchemeConfig;
import kd.ai.ids.core.entity.model.sf.std.SfOnlineScheme;
import kd.ai.ids.core.enumtype.DimEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.query.sf.std.DimValuesDTO;
import kd.ai.ids.core.query.sf.std.StandardFilterItemQuery;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.DynamicObjectUtils;
import kd.ai.ids.core.utils.SfAppConfigUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.form.sf.std.ModelAnalysisChart;
import kd.ai.ids.plugin.form.sf.std.ModelAnalysisContext;
import kd.ai.ids.plugin.tool.FormTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.FieldAp;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ModelAnalysisFormPlugin
extends BaseFormPlugin
implements BeforeBindDataListener {
    public static final String KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP = "modSchemeSelectMap_";
    public static final String KEY_LOAD_ANA_YEAR_TREND = "LoadAnaYearTrend";
    public static final String KEY_LOAD_ANA_LAST_TREND = "LoadAnaLastTrend";
    public static final String KEY_LOAD_ANA_LAST_TREND_DETAIL = "LoadAnaLastTrendDetail";
    public static final String KEY_ERROR_DATA = "error";
    public static final String KEY_CHECK_AND_HIDE_LOADING = "CheckAndHideLoading";
    public static final String KEY_LAST_TREND_GRAPH1 = "lasttrendgraph1";
    public static final String KEY_CURRENT_SCHEME = "currentScheme";
    private static final String KEY_BTN_UN_ONLINE_OK = "btnunonlineok";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String KEY_BTN_RESET = "btnreset";
    private static final String KEY_BTN_PREDICT_MODEL_EXPLAIN = "btnmodelexplain";
    private static final String KEY_COMBO_MODSCHEME_SELECT = "combomodschemeselect";
    private static final String KEY_LABEL_ORG_DIM = "labelorgdim";
    private static final String KEY_LABEL_CUST_DIM = "labelcustdim";
    private static final String KEY_LABEL_PRODUCT_DIM = "labelproductdim";
    private static final String KEY_LABEL_PREDICT_PERIOD = "labelpredictperiod";
    private static final String KEY_LABEL_PREDICT_LENGTH = "labelpredictlength";
    private static final String KEY_LABEL_PREDICT_VALUE = "labelpredictvalue";
    private static final String KEY_POINTLINE_CHART_YEAR_TREND = "pointlinechartyeartrend";
    private static final String KEY_CUSTOME_CHART_LAST_TREND = "customchartlasttrend";
    private static final String KEY_LABEL_PREDICT_DETAIL_TITLE = "labelpredictdetailtitle";
    private static final String KEY_FORMID_IDS_PREDICT_MODEL_EXPLAIN = "ids_predict_model_explain";
    private static final String KEY_FILTER_ITEM_QUERY = "filterItemQuery";
    private static final String KEY_LABEL_YEAR_TREND_TITLE = "labelapyeartrendtitle";
    private static final String KEY_LABEL_LAST_TREND_LIST_TITLE = "labelaplasttrendlisttitle";
    private static final String KEY_VECTOR_LAST_TREND_GRAPH = "vectoraplasttrendgraph";
    private static final String KEY_VECTOR_LAST_TREND_LIST = "vectoraplasttrendlist";
    private static final String KEY_ENTRY_ENTITY_LAST_TREND = "lasttrendentryentity";
    private static final String FLEX_ORG_DIM = "flexorgdim";
    private static final String FLEX_CUST_DIM = "flexcustdim";
    private static final String FLEX_PRODUCT_DIM = "flexproductdim";
    private static final String KEY_FLEXFILTERS = "flexfilters";
    private static final String KEY_MULBD_FILTER_ID_LIST = "mulbdFilterIdList";
    private static final String KEY_BD_FILTER_ID_LIST = "bdFilterIdList";
    private static final String KEY_SCHEME_CONFIG = "schemeConfig";
    private static final String KEY_APP_CONFIG = "appConfig";
    private static final String CACHE_KEY_VALUE_MAP = "valueMap";
    private final ModelAnalysisChart modelAnalysisChart = new ModelAnalysisChart();
    private ModelAnalysisContext ctx = null;
    private static final int CALL_BACK_DEFAULT_DURATION = 300;

    private String getSubServiceIdWithNoCache() {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        return subServiceId;
    }

    private Map<String, Object> getValueMap() {
        return (Map)this.getCache().getAsObject(CACHE_KEY_VALUE_MAP, Map.class);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.ctx = new ModelAnalysisContext(this.getCache());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_REFRESH, KEY_BTN_RESET, KEY_BTN_PREDICT_MODEL_EXPLAIN, KEY_CUSTOME_CHART_LAST_TREND, KEY_VECTOR_LAST_TREND_LIST, KEY_VECTOR_LAST_TREND_GRAPH});
    }

    public void click(EventObject evt) {
        String evtKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (evtKey = ctl.getKey()) {
            case "btnrefresh": {
                List bdFilterList;
                StandardFilterItemQuery filterItemQuery = this.ctx.getCurFilterItemQuery();
                ArrayList<DimValuesDTO> dimValuesDTOList = new ArrayList<DimValuesDTO>();
                Map<String, Object> map = this.getValueByKey(this.ctx.getCurModelTypeId());
                List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
                if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
                    for (String fdimid : mulbdFilterList) {
                        DimValuesDTO dimValuesDTO = new DimValuesDTO();
                        dimValuesDTO.setLabelId(fdimid);
                        MulBasedataDynamicObjectCollection mulbdDoc = (MulBasedataDynamicObjectCollection)this.getModel().getValue(fdimid);
                        List valueList = DynamicObjectUtils.getPkValueListFromDoc((DynamicObjectCollection)mulbdDoc);
                        dimValuesDTO.setValues(valueList);
                        dimValuesDTOList.add(dimValuesDTO);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)(bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST)))) {
                    for (String fdimid : bdFilterList) {
                        DimValuesDTO dimValuesDTO = new DimValuesDTO();
                        dimValuesDTO.setLabelId(fdimid);
                        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(fdimid);
                        if (dynamicObject == null) continue;
                        ArrayList<Object> valueList = new ArrayList<Object>();
                        valueList.add(dynamicObject.getPkValue());
                        dimValuesDTO.setValues(valueList);
                        dimValuesDTOList.add(dimValuesDTO);
                    }
                }
                filterItemQuery.setFdimvaluesList(dimValuesDTOList);
                this.loadChartData(false, filterItemQuery);
                break;
            }
            case "btnreset": {
                this.resetQueryCondition();
                this.loadChartData(true, null);
                break;
            }
            case "btnmodelexplain": {
                this.showPredictModelExplain();
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        String fpretimetype = "";
        StandardFilterItemQuery filterItemQuery = null;
        if (controlKey.equalsIgnoreCase(KEY_LAST_TREND_GRAPH1) && eventName.equalsIgnoreCase("barClick")) {
            String dateStr;
            JSONObject menuObj = JSON.parseObject((String)args);
            String name = menuObj.getString("fdate");
            fpretimetype = menuObj.getString("fpretimetype");
            String filterQueryStr = menuObj.getString("filterQuery");
            filterItemQuery = (StandardFilterItemQuery)JSON.toJavaObject((JSON)JSON.parseObject((String)filterQueryStr), StandardFilterItemQuery.class);
            Date startDate = null;
            Date endDate = null;
            Date now = new Date();
            if (StringUtils.equalsIgnoreCase((CharSequence)"fdate", (CharSequence)fpretimetype)) {
                dateStr = name = name.replace('.', '-');
                endDate = startDate = DateUtils.parseDate((String)dateStr, (String)"yy-MM-dd");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"fweek", (CharSequence)fpretimetype)) {
                String beginOfWeek = name = name.replace('.', '-');
                startDate = DateUtils.parseDate((String)beginOfWeek, (String)"yy-MM-dd");
                endDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)startDate, (int)6);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"fmonth", (CharSequence)fpretimetype)) {
                name = name.replace('.', '-');
                dateStr = name + DateFormatUtils.format((Date)now, (String)"-dd");
                startDate = DateUtils.beginOfMonth((String)dateStr);
                endDate = DateUtils.endOfMonth((String)dateStr);
            }
            filterItemQuery.setStartTime(DateFormatUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
            filterItemQuery.setEndTime(DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_PRE_DETAIL.getId());
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("fschemeid", filterItemQuery.getFschemeid());
            customParams.put(KEY_FILTER_ITEM_QUERY, JSON.toJSONString((Object)filterItemQuery));
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    private void showPredictModelExplain() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(KEY_FORMID_IDS_PREDICT_MODEL_EXPLAIN);
        HashMap<String, String> customParams = new HashMap<String, String>();
        String fmodeltypeid = this.ctx.getCurModelTypeId();
        SfOnlineScheme sfOnlineScheme = (SfOnlineScheme)this.getCache().getAsObject(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + fmodeltypeid, SfOnlineScheme.class);
        if (sfOnlineScheme != null) {
            AppConfig appConfig = this.getAppConfig(this.ctx.getSubServiceId());
            String fconfigTag = sfOnlineScheme.getFconfigTag();
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
            String orgDimName = schemeConfig.getDimName(appConfig, DimEnum.ORG);
            String custDimName = schemeConfig.getDimName(appConfig, DimEnum.CUST);
            String productDimName = schemeConfig.getDimName(appConfig, DimEnum.PRODUCT);
            String predictPeriodName = schemeConfig.getFtimegranularityName(appConfig);
            String predictLengthName = String.valueOf(schemeConfig.getFpredictlength());
            String predictValueName = schemeConfig.getFvaluetypeName(appConfig);
            customParams.put("fmodeltypeidName", sfOnlineScheme.getFname());
            customParams.put("orgDimName", orgDimName);
            customParams.put("custDimName", custDimName);
            customParams.put("productDimName", productDimName);
            customParams.put("predictPeriodName", predictPeriodName);
            customParams.put("predictLengthName", predictLengthName);
            customParams.put("predictValueName", predictValueName);
            customParams.put("subServiceId", this.ctx.getSubServiceId());
            customParams.put("fmodeltypeid", fmodeltypeid);
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private void resetQueryCondition() {
        StandardFilterItemQuery defaultFilterItemQuery = this.ctx.getDefaultFilterItemQuery();
        if (defaultFilterItemQuery != null) {
            defaultFilterItemQuery.setCurrent(Long.valueOf(1L));
            defaultFilterItemQuery.setOrderByExpr(null);
        }
        this.ctx.setCurFilterItemQuery(defaultFilterItemQuery);
        if (defaultFilterItemQuery != null) {
            // empty if block
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_COMBO_MODSCHEME_SELECT)) {
            String fmodeltypeid = changeData[0].getNewValue() != null ? changeData[0].getNewValue().toString() : "";
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("fschemeid", fmodeltypeid);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ids_sf_std_model_analysis");
            formShowParameter.setCustomParams(customParams);
            formShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(formShowParameter);
        }
    }

    private String loadAppConfig(String subServiceId) {
        JSONObject dataJo = this.sfStandardService().appConfigGet(subServiceId);
        JSONObject appConfigJo = dataJo.getJSONObject(KEY_APP_CONFIG);
        String appConfigStr = appConfigJo.toJSONString();
        this.getCache().put(KEY_APP_CONFIG, appConfigStr);
        return appConfigStr;
    }

    private AppConfig getAppConfig(String subServiceId) {
        AppConfig appConfig = null;
        String appConfigStr = this.getCache().get(KEY_APP_CONFIG);
        if (StringUtils.isEmpty((CharSequence)appConfigStr)) {
            appConfigStr = this.loadAppConfig(subServiceId);
        }
        appConfig = (AppConfig)JSONObject.parseObject((String)appConfigStr, AppConfig.class);
        return appConfig;
    }

    private void showCurrentModSelectAndFilterItem(String modelTypeId) {
        SfOnlineScheme sfOnlineScheme = (SfOnlineScheme)this.getCache().getAsObject(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId, SfOnlineScheme.class);
        if (sfOnlineScheme != null) {
            AppConfig appConfig = this.getAppConfig(this.ctx.getSubServiceId());
            String fconfigTag = sfOnlineScheme.getFconfigTag();
            SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
            String orgDimName = schemeConfig.getDimName(appConfig, DimEnum.ORG);
            String custDimName = schemeConfig.getDimName(appConfig, DimEnum.CUST);
            String productDimName = schemeConfig.getDimName(appConfig, DimEnum.PRODUCT);
            String fpretimetype = (String)schemeConfig.getFtimegranularity().get(0);
            String predictPeriodName = schemeConfig.getFtimegranularityName(appConfig);
            String predictLengthName = String.valueOf(schemeConfig.getFpredictlength());
            String predictValueName = schemeConfig.getFvaluetypeName(appConfig);
            this.ctx.setCurPreTimeType(fpretimetype);
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ORG_DIM, FLEX_CUST_DIM, FLEX_PRODUCT_DIM});
            this.setLabelText(KEY_LABEL_ORG_DIM, orgDimName);
            if (!StringUtils.isEmpty((CharSequence)orgDimName)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ORG_DIM});
            }
            this.setLabelText(KEY_LABEL_CUST_DIM, custDimName);
            if (!StringUtils.isEmpty((CharSequence)custDimName)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_CUST_DIM});
            }
            this.setLabelText(KEY_LABEL_PRODUCT_DIM, productDimName);
            if (!StringUtils.isEmpty((CharSequence)productDimName)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PRODUCT_DIM});
            }
            this.setLabelText(KEY_LABEL_PREDICT_PERIOD, predictPeriodName);
            this.setLabelText(KEY_LABEL_PREDICT_LENGTH, predictLengthName);
            this.setLabelText(KEY_LABEL_PREDICT_VALUE, predictValueName);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    private void loadOnlineModelTypeList(RequestContext rc) {
        JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(this.ctx.getSubServiceId());
        if (dataJa == null || dataJa.isEmpty()) {
            return;
        }
        List sfOnlineSchemeList = dataJa.toJavaList(SfOnlineScheme.class);
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_COMBO_MODSCHEME_SELECT);
        int len = sfOnlineSchemeList.size();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(len);
        HashMap<String, String> modSchemeSelectMap = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            SfOnlineScheme sfOnlineScheme = (SfOnlineScheme)sfOnlineSchemeList.get(i);
            String modelTypeId = String.valueOf(sfOnlineScheme.getFschemeid());
            if (StringUtils.isEmpty((CharSequence)this.ctx.getCurModelTypeId())) {
                this.ctx.setCurModelTypeId(modelTypeId);
            }
            modSchemeSelectMap.put(KEY_CACHE_PREF_MOD_SCHEME_SELECT_MAP + modelTypeId, JSONObject.toJSONString((Object)sfOnlineScheme));
            LocaleString comboItemText = new LocaleString(sfOnlineScheme.getFname());
            ComboItem comboItem = new ComboItem(comboItemText, modelTypeId);
            data.add(comboItem);
        }
        comboEdit.setComboItems(data);
        this.getCache().put(modSchemeSelectMap);
        this.showCurrentModSelectAndFilterItem(this.ctx.getCurModelTypeId());
    }

    private void loadAnaYearTrendFromRemote(StandardFilterItemQuery filterItemQuery) {
        JSONObject dataJo = this.sfStandardService().getYearTrend(filterItemQuery);
        if (dataJo != null) {
            this.ctx.setCurAnaYearTrendData(dataJo.toJSONString());
        } else {
            this.ctx.setCurAnaYearTrendData(KEY_ERROR_DATA);
        }
    }

    private void refreshAnaYearTrend(JSONObject dataJo, StandardFilterItemQuery filterItemQuery) {
        Control yearTrendChart = this.getControl(KEY_POINTLINE_CHART_YEAR_TREND);
        if (yearTrendChart instanceof PointLineChart) {
            String subServiceId = this.ctx.getSubServiceId();
            this.setLabelText(KEY_LABEL_YEAR_TREND_TITLE, dataJo.getString("title"));
            PointLineChart pointLineChart = (PointLineChart)yearTrendChart;
            Map<String, Object> map = this.getValueByKey(filterItemQuery.getFschemeid());
            AppConfig appConfig = this.getAppConfig(subServiceId);
            SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
            String fvaluetypeName = schemeConfig.getFvaluetypeName(appConfig);
            this.modelAnalysisChart.refreshAnaYearTrend(dataJo, filterItemQuery, pointLineChart, fvaluetypeName);
        }
    }

    private void loadAnaLastTrendFromRemote(StandardFilterItemQuery filterItemQuery) {
        JSONObject dataJo = this.sfStandardService().getLastTrend(filterItemQuery);
        if (dataJo != null) {
            this.ctx.setCurAnaLastTrendData(dataJo.toJSONString());
        } else {
            this.ctx.setCurAnaLastTrendData(KEY_ERROR_DATA);
        }
    }

    private void loadAnaLastTrendDetailFromRemote(StandardFilterItemQuery filterItemQuery) {
        JSONObject dataJo = this.sfStandardService().getLastTrendDetail(filterItemQuery);
        if (dataJo != null) {
            this.ctx.setCurAnaLastTrendDetailData(dataJo.toJSONString());
        } else {
            this.ctx.setCurAnaLastTrendDetailData(KEY_ERROR_DATA);
        }
    }

    private void setCustomChart(JSONObject dataJo) {
        Date now = new Date();
        HashMap<String, Object> customData = new HashMap<String, Object>();
        StandardFilterItemQuery filterItemQuery = this.ctx.getCurFilterItemQuery();
        ArrayList list = (ArrayList)filterItemQuery.getFdimvaluesList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                List arr = ((DimValuesDTO)list.get(i)).getValues();
                if (arr == null) continue;
                for (int j = 0; j < arr.size(); ++j) {
                    Object temp = arr.get(j);
                    if (temp == null) continue;
                    String tranStr = String.valueOf(temp);
                    arr.set(j, tranStr);
                }
            }
        }
        dataJo.put("filterQuery", (Object)filterItemQuery);
        String fpretimetype = this.ctx.getCurPreTimeType();
        dataJo.put("fpretimetype", (Object)fpretimetype);
        customData.put("data", dataJo);
        customData.put("timestamp", now.getTime());
        customData.put("chartType", "analysic_trend");
        customData.put("pageId", this.getView().getPageId());
        String uniqueCode = String.format("%s_%s", this.getView().getPageId(), UUID.randomUUID().toString());
        customData.put("uniqueCode", uniqueCode);
        CustomControl customControl = (CustomControl)this.getControl(KEY_LAST_TREND_GRAPH1);
        customControl.setData(customData);
    }

    private void refreshAnaLastTrendDetail(JSONObject dataJo) {
        String title = dataJo.getString("title");
        this.setLabelText(KEY_LABEL_LAST_TREND_LIST_TITLE, title);
        this.showLastTrendDetailList();
    }

    private void showLastTrendDetailList() {
        JSONObject dataJo = JSON.parseObject((String)this.ctx.getCurAnaLastTrendDetailData());
        JSONArray valueArrayJa = dataJo.getJSONArray("valueArray");
        JSONArray ftimeListJa = dataJo.getJSONArray("ftimeList");
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY_LAST_TREND);
        if (ftimeListJa != null && !ftimeListJa.isEmpty()) {
            int i;
            int rowCount = valueArrayJa.size();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY_LAST_TREND, rowCount);
            EntryGrid entry = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY_LAST_TREND);
            for (i = 0; i < 43; ++i) {
                int finalI = i;
                boolean colVisible = finalI < ftimeListJa.size();
                Optional.ofNullable(entry).ifPresent(e -> {
                    String valueColName = String.format("value%s", finalI + 1);
                    e.setColumnProperty(valueColName, "header", colVisible ? new LocaleString(ftimeListJa.getString(finalI)) : "");
                    e.setColumnProperty(valueColName, "vi", (Object)colVisible);
                });
            }
            for (i = 0; i < rowCount; ++i) {
                JSONObject valueJo = valueArrayJa.getJSONObject(i);
                JSONArray valueJa = valueJo.getJSONArray("value");
                this.getModel().setValue("statindicators", (Object)valueJo.getString("label"), rowIndex[i]);
                for (int j = 0; j < valueJa.size(); ++j) {
                    this.getModel().setValue(String.format("value%s", j + 1), (Object)valueJa.getDouble(j), rowIndex[i]);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filterItemQueryStr = (String)formShowParameter.getCustomParam(KEY_FILTER_ITEM_QUERY);
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        if (StringUtils.isNotEmpty((CharSequence)fschemeid)) {
            this.ctx.setCurModelTypeId(fschemeid);
        }
        this.initDimFilters();
        StandardFilterItemQuery filterItemQuery = null;
        if (StringUtils.isNotEmpty((CharSequence)filterItemQueryStr)) {
            filterItemQuery = (StandardFilterItemQuery)JSON.toJavaObject((JSON)JSON.parseObject((String)filterItemQueryStr), StandardFilterItemQuery.class);
            this.ctx.setCurFilterItemQuery(filterItemQuery);
            this.ctx.setCurModelTypeId(filterItemQuery.getFschemeid());
            List fdimvaluesList = filterItemQuery.getFdimvaluesList();
            Map<String, Object> map = this.getValueByKey(fschemeid);
            SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
            AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
            Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
            List bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST);
            List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
            if (CollectionUtils.isNotEmpty((Collection)fdimvaluesList)) {
                for (int i = 0; i < fdimvaluesList.size(); ++i) {
                    DimValuesDTO dimValuesDTO = (DimValuesDTO)fdimvaluesList.get(i);
                    String labelId = dimValuesDTO.getLabelId();
                    List valueList = dimValuesDTO.getValues();
                    if (!CollectionUtils.isNotEmpty((Collection)valueList)) continue;
                    Ftype ftype = (Ftype)fidFtypeMap.get(labelId);
                    List<Object> pkList = valueList.stream().map(s -> Long.parseLong(String.valueOf(s))).collect(Collectors.toList());
                    Object[] values = pkList.toArray(new Object[pkList.size()]);
                    String fentityid = ftype.getFentityid();
                    if (!StringUtils.isNotEmpty((CharSequence)fentityid)) continue;
                    if (mulbdFilterList.contains(labelId)) {
                        this.getModel().setValue(labelId, (Object)values);
                        this.getView().updateView(labelId);
                        continue;
                    }
                    if (!bdFilterList.contains(labelId)) continue;
                    this.getModel().setValue(labelId, values[0]);
                    this.getView().updateView(labelId);
                }
            }
        }
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.ctx.setSubServiceId(subServiceId);
        this.loadOnlineModelTypeList(rc);
        this.loadChartData(fschemeid == null, filterItemQuery);
        this.getModel().setValue(KEY_COMBO_MODSCHEME_SELECT, (Object)this.ctx.getCurModelTypeId());
    }

    private void loadChartData(boolean isInit, StandardFilterItemQuery filterItemQuery) {
        if (filterItemQuery == null) {
            filterItemQuery = new StandardFilterItemQuery();
        }
        filterItemQuery.setFschemeid(this.ctx.getCurModelTypeId());
        filterItemQuery.setSubServiceId(this.ctx.getSubServiceId());
        List fdimvaluesList = filterItemQuery.getFdimvaluesList();
        if (CollectionUtils.isEmpty((Collection)fdimvaluesList)) {
            this.setDimDefaultValue(filterItemQuery);
        }
        this.ctx.setCurFilterItemQuery(filterItemQuery);
        if (isInit) {
            this.ctx.setDefaultFilterItemQuery(filterItemQuery);
        }
        FormTools.showLoading(this.getView(), this.getView().getPageId(), null);
        this.getView().addClientCallBack(KEY_LOAD_ANA_YEAR_TREND);
        this.getView().addClientCallBack(KEY_LOAD_ANA_LAST_TREND);
        this.getView().addClientCallBack(KEY_LOAD_ANA_LAST_TREND_DETAIL);
        this.getView().addClientCallBack(KEY_CHECK_AND_HIDE_LOADING);
        this.clearData();
        this.getCache().saveChanges();
        StandardFilterItemQuery finalFilterItemQuery = filterItemQuery;
        ThreadUtils.execute(() -> {
            this.loadAnaYearTrendFromRemote(finalFilterItemQuery);
            this.getCache().saveChanges();
        });
        ThreadUtils.execute(() -> {
            this.loadAnaLastTrendFromRemote(finalFilterItemQuery);
            this.getCache().saveChanges();
        });
        ThreadUtils.execute(() -> {
            this.loadAnaLastTrendDetailFromRemote(finalFilterItemQuery);
            this.getCache().saveChanges();
        });
    }

    private void setDimDefaultValue(StandardFilterItemQuery filterItemQuery) {
        JSONObject resultJo = this.dataAppService().getSubService(this.ctx.getSubServiceId());
        String extraInfo = resultJo.getString("extraInfo");
        Map<String, Object> map = this.getValueByKey(this.ctx.getCurModelTypeId());
        ArrayList preDimList = new ArrayList(5);
        List bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST);
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        preDimList.addAll(mulbdFilterList);
        preDimList.addAll(bdFilterList);
        JSONObject extraInfoJo = null;
        extraInfoJo = StringUtils.isNotEmpty((CharSequence)extraInfo) ? JSONObject.parseObject((String)extraInfo).getJSONObject(this.ctx.getCurModelTypeId()) : this.sfStandardService().getAnaExtraInfo(filterItemQuery);
        if (extraInfoJo != null) {
            ArrayList<DimValuesDTO> fdimvaluesList = new ArrayList<DimValuesDTO>(5);
            for (String labelId : preDimList) {
                Long value = extraInfoJo.getLongValue(labelId);
                List<Long> valueList = Collections.singletonList(value);
                DimValuesDTO dimValuesDTO = new DimValuesDTO();
                dimValuesDTO.setLabelId(labelId);
                dimValuesDTO.setValues(valueList);
                fdimvaluesList.add(dimValuesDTO);
                if (CollectionUtils.containsAny((Collection)mulbdFilterList, (Object[])new String[]{labelId})) {
                    this.getModel().setValue(labelId, (Object)valueList.toArray(new Object[valueList.size()]));
                    this.getView().updateView(labelId);
                    continue;
                }
                if (!CollectionUtils.containsAny((Collection)bdFilterList, (Object[])new String[]{labelId})) continue;
                this.getModel().setValue(labelId, (Object)value);
                this.getView().updateView(labelId);
            }
            filterItemQuery.setFdimvaluesList(fdimvaluesList);
        }
    }

    private void clearData() {
        this.ctx.setCurAnaYearTrendData("");
        this.ctx.setCurAnaLastTrendData("");
        this.ctx.setCurAnaLastTrendDetailData("");
        this.setLabelText(KEY_LABEL_PREDICT_DETAIL_TITLE, "");
        this.clearChartData(KEY_POINTLINE_CHART_YEAR_TREND, KEY_CUSTOME_CHART_LAST_TREND);
    }

    private void clearChartData(String ... keys) {
        for (String key : keys) {
            Chart chart = (Chart)this.getControl(key);
            chart.clearData();
            chart.refresh();
        }
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)KEY_BTN_UN_ONLINE_OK, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
            this.getView().close();
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        boolean isOnline = false;
        if (tenantDTO != null) {
            isOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        }
        if (!isOnline) {
            e.setCancel(true);
            Object source = e.getSource();
            if (!(source instanceof FormShowParameter)) {
                return;
            }
            FormShowParameter fsp = (FormShowParameter)source;
            String parentPageId = fsp.getParentPageId();
            IdsPageCache parentCache = new IdsPageCache(parentPageId);
            parentCache.put("is_online_" + fsp.getFormId(), "false");
            parentCache.saveChanges();
        } else {
            String subServiceId = this.getSubServiceIdWithNoCache();
            JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(subServiceId);
            if (dataJa == null || dataJa.size() == 0) {
                e.setCancel(true);
                Object source = e.getSource();
                if (!(source instanceof FormShowParameter)) {
                    return;
                }
                FormShowParameter fsp = (FormShowParameter)source;
                String parentPageId = fsp.getParentPageId();
                IdsPageCache parentCache = new IdsPageCache(parentPageId);
                parentCache.put("is_scheme_online_" + fsp.getFormId(), "false");
                parentCache.saveChanges();
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        String anaYearTrendData = this.ctx.getCurAnaYearTrendData();
        String anaLastTrendData = this.ctx.getCurAnaLastTrendData();
        String anaLastTrendDetailData = this.ctx.getCurAnaLastTrendDetailData();
        switch (name) {
            case "LoadAnaYearTrend": {
                this.clientCallBackLoadAnaYearTrend(name, anaYearTrendData);
                break;
            }
            case "LoadAnaLastTrend": {
                this.clientCallBackLoadAnaLastTrend(name, anaLastTrendData);
                break;
            }
            case "LoadAnaLastTrendDetail": {
                this.clientCallBackLoadAnaLastTrendDetail(name, anaLastTrendDetailData);
                break;
            }
            case "CheckAndHideLoading": {
                this.clientCallBackCheckAndHideLoading(name, anaYearTrendData, anaLastTrendData);
                break;
            }
        }
    }

    private int getCallBackDuration() {
        return 300 + RandomUtils.nextInt((int)300);
    }

    private void clientCallBackCheckAndHideLoading(String name, String anaYearTrendData, String anaLastTrendData) {
        if (StringUtils.isNotEmpty((CharSequence)anaYearTrendData) && StringUtils.isNotEmpty((CharSequence)anaLastTrendData)) {
            FormTools.hideLoading(this.getView(), this.getView().getPageId());
        } else {
            this.getView().addClientCallBack(name, Integer.valueOf(this.getCallBackDuration()));
        }
    }

    private void clientCallBackLoadAnaLastTrendDetail(String name, String anaLastTrendDetailData) {
        if (StringUtils.isEmpty((CharSequence)anaLastTrendDetailData)) {
            this.getView().addClientCallBack(name, Integer.valueOf(this.getCallBackDuration()));
        } else if (!KEY_ERROR_DATA.equals(anaLastTrendDetailData)) {
            this.refreshAnaLastTrendDetail(JSON.parseObject((String)anaLastTrendDetailData));
        }
    }

    private void clientCallBackLoadAnaLastTrend(String name, String anaLastTrendData) {
        if (StringUtils.isEmpty((CharSequence)anaLastTrendData)) {
            this.getView().addClientCallBack(name, Integer.valueOf(this.getCallBackDuration()));
        } else if (!KEY_ERROR_DATA.equals(anaLastTrendData)) {
            this.setCustomChart(JSON.parseObject((String)anaLastTrendData));
        }
    }

    private void clientCallBackLoadAnaYearTrend(String name, String anaYearTrendData) {
        if (StringUtils.isEmpty((CharSequence)anaYearTrendData)) {
            this.getView().addClientCallBack(name, Integer.valueOf(this.getCallBackDuration()));
        } else if (!KEY_ERROR_DATA.equals(anaYearTrendData)) {
            StandardFilterItemQuery currentFilterItemQuery = this.ctx.getCurFilterItemQuery();
            this.refreshAnaYearTrend(JSON.parseObject((String)anaYearTrendData), currentFilterItemQuery);
        }
    }

    public void initDimFilters() {
        List bdFilterList;
        Container container = (Container)this.getView().getControl(KEY_FLEXFILTERS);
        ArrayList<Map> items = new ArrayList<Map>();
        Map<String, Object> map = this.getValueByKey(this.ctx.getCurModelTypeId());
        SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
        AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
        Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
            for (String fdimid : mulbdFilterList) {
                Ftype ftype = (Ftype)fidFtypeMap.get(fdimid);
                FieldAp fieldAp = this.createDynamicFieldAp(ftype);
                items.add(fieldAp.createControl());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST)))) {
            for (String fdimid : bdFilterList) {
                Ftype ftype = (Ftype)fidFtypeMap.get(fdimid);
                FieldAp fieldAp = this.createDynamicBdFieldAp(ftype);
                items.add(fieldAp.createControl());
            }
        }
        container.addControls(items);
    }

    private FieldAp createDynamicFieldAp(Ftype ftype) {
        String fid = ftype.getFid();
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(fid);
        fieldAp.setKey(fid);
        fieldAp.setName(new LocaleString(ftype.getFname()));
        fieldAp.setFireUpdEvt(true);
        MulBasedataField ba = new MulBasedataField();
        ba.setId(fid);
        ba.setKey(fid);
        ba.setBaseEntityId(ftype.getFentityid());
        ba.setOrgFuncs(ftype.getForgfuncid());
        fieldAp.setField((Field)ba);
        return fieldAp;
    }

    private FieldAp createDynamicBdFieldAp(Ftype ftype) {
        String fid = ftype.getFid();
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(fid);
        fieldAp.setKey(fid);
        fieldAp.setName(new LocaleString(ftype.getFname()));
        fieldAp.setFireUpdEvt(true);
        BasedataField ba = new BasedataField();
        ba.setId(fid);
        ba.setKey(fid);
        ba.setBaseEntityId(ftype.getFentityid());
        fieldAp.setField((Field)ba);
        return fieldAp;
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        Map<String, Object> map = this.getValueByKey(fschemeid);
        List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
        List bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST);
        if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList) && mulbdFilterList.contains(key)) {
            MulBasedataEdit basedataEdit = new MulBasedataEdit();
            basedataEdit.setKey(key);
            basedataEdit.setView(this.getView());
            e.setControl((Control)basedataEdit);
        } else if (CollectionUtils.isNotEmpty((Collection)bdFilterList) && bdFilterList.contains(key)) {
            BasedataEdit basedataEdit = new BasedataEdit();
            basedataEdit.setKey(key);
            basedataEdit.setView(this.getView());
            e.setControl((Control)basedataEdit);
        }
    }

    private Map<String, Object> getValueByKey(String fschemeid) {
        Map<String, Object> map = this.getValueMap();
        if (map != null) {
            for (String key : map.keySet()) {
                if (key.equalsIgnoreCase(KEY_MULBD_FILTER_ID_LIST)) {
                    List mulbdFilterList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)map.get(KEY_MULBD_FILTER_ID_LIST)), String.class);
                    map.put(KEY_MULBD_FILTER_ID_LIST, mulbdFilterList);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_SCHEME_CONFIG)) {
                    SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)map.get(KEY_SCHEME_CONFIG)), SchemeConfig.class);
                    map.put(KEY_SCHEME_CONFIG, schemeConfig);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_APP_CONFIG)) {
                    AppConfig appConfig = (AppConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)map.get(KEY_APP_CONFIG)), AppConfig.class);
                    map.put(KEY_APP_CONFIG, appConfig);
                    continue;
                }
                if (key.equalsIgnoreCase("fschemeid")) {
                    map.put("fschemeid", map.get("fschemeid"));
                    continue;
                }
                if (!key.equalsIgnoreCase(KEY_CURRENT_SCHEME)) continue;
                SfOnlineScheme sfOnlineScheme = (SfOnlineScheme)JSONObject.parseObject((String)JSONObject.toJSONString((Object)map.get(KEY_CURRENT_SCHEME)), SfOnlineScheme.class);
                map.put(KEY_CURRENT_SCHEME, sfOnlineScheme);
            }
            return map;
        }
        map = new HashMap<String, Object>(4);
        String subServiceId = this.getSubServiceIdWithNoCache();
        JSONArray dataJa = this.sfStandardService().getOnlineSchemeList(subServiceId);
        List sfOnlineSchemeList = dataJa.toJavaList(SfOnlineScheme.class);
        if (StringUtils.isEmpty((CharSequence)fschemeid) && CollectionUtils.isNotEmpty((Collection)sfOnlineSchemeList)) {
            fschemeid = String.valueOf(((SfOnlineScheme)sfOnlineSchemeList.get(0)).getFschemeid());
        }
        Integer finalFschemeid = Integer.parseInt(fschemeid);
        SfOnlineScheme sfOnlineScheme = sfOnlineSchemeList.stream().filter(e1 -> e1.getFschemeid().equals(finalFschemeid)).findFirst().get();
        AppConfig appConfig = this.getAppConfig(subServiceId);
        String fconfigTag = sfOnlineScheme.getFconfigTag();
        SchemeConfig schemeConfig = (SchemeConfig)JSONObject.parseObject((String)fconfigTag, SchemeConfig.class);
        Fdim lastDim = SfAppConfigUtils.getLastDim((AppConfig)appConfig, (String)schemeConfig.getFdatasource(), (String)schemeConfig.getFschemetemplate());
        ArrayList mulbdFilterList = new ArrayList();
        ArrayList bdFilterList = new ArrayList();
        for (DimEnum dim : DimEnum.values()) {
            List fdimidList = schemeConfig.getFidListByDim(dim.getId(), appConfig);
            if (dim.getId().equalsIgnoreCase(lastDim.getFid())) {
                if (!CollectionUtils.isNotEmpty((Collection)fdimidList)) continue;
                bdFilterList.addAll(fdimidList);
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)fdimidList)) continue;
            mulbdFilterList.addAll(fdimidList);
        }
        map.put(KEY_MULBD_FILTER_ID_LIST, mulbdFilterList);
        map.put(KEY_BD_FILTER_ID_LIST, bdFilterList);
        map.put(KEY_SCHEME_CONFIG, schemeConfig);
        map.put(KEY_APP_CONFIG, appConfig);
        map.put("fschemeid", fschemeid);
        map.put(KEY_CURRENT_SCHEME, sfOnlineScheme);
        this.getCache().put(CACHE_KEY_VALUE_MAP, JSONObject.toJSONString(map));
        return map;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fschemeid = (String)formShowParameter.getCustomParam("fschemeid");
        Map<String, Object> map = this.getValueByKey(fschemeid);
        fschemeid = (String)map.get("fschemeid");
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        this.registBasedataEntityType(newMainType, fschemeid);
        e.setNewEntityType(newMainType);
    }

    private void registBasedataEntityType(MainEntityType newMainType, String fschemeid) {
        if (StringUtils.isNotEmpty((CharSequence)fschemeid)) {
            List bdFilterList;
            Map<String, Object> map = this.getValueByKey(fschemeid);
            SchemeConfig schemeConfig = (SchemeConfig)map.get(KEY_SCHEME_CONFIG);
            AppConfig appConfig = (AppConfig)map.get(KEY_APP_CONFIG);
            Map fidFtypeMap = schemeConfig.getFidFTypeMap(appConfig);
            List mulbdFilterList = (List)map.get(KEY_MULBD_FILTER_ID_LIST);
            if (CollectionUtils.isNotEmpty((Collection)mulbdFilterList)) {
                for (String key : mulbdFilterList) {
                    Ftype ftype = (Ftype)fidFtypeMap.get(key);
                    DynamicObjectType type = new DynamicObjectType(key);
                    type.setDbIgnore(false);
                    this.registerProperties(type, ftype);
                    MulBasedataProp prop = new MulBasedataProp(key, type);
                    prop.setDbIgnore(true);
                    prop.setBaseEntityId(ftype.getFentityid());
                    prop.setOrgFunc(ftype.getForgfuncid());
                    prop.setName(key);
                    prop.setDbIgnore(true);
                    prop.setDisplayName(new LocaleString(ftype.getFname()));
                    prop.setGroupControl(false);
                    newMainType.registerCollectionProperty((DynamicCollectionProperty)prop);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(bdFilterList = (List)map.get(KEY_BD_FILTER_ID_LIST)))) {
                for (String key : bdFilterList) {
                    Ftype ftype = (Ftype)fidFtypeMap.get(key);
                    BasedataProp bdMatProp = this.createBasedataProp(newMainType, ftype.getFid(), ftype.getFentityid());
                    newMainType.registerComplexProperty((DynamicComplexProperty)bdMatProp);
                }
            }
        }
    }

    private BasedataProp createBasedataProp(MainEntityType newMainType, String fieldKey, String baseEntityId) {
        BasedataProp bdMatProp = new BasedataProp();
        bdMatProp.setDbIgnore(true);
        bdMatProp.setBaseEntityId(baseEntityId);
        bdMatProp.setName(fieldKey);
        bdMatProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityId));
        DynamicSimpleProperty pMatRefId = bdMatProp.createRefIDProp();
        pMatRefId.setPrimaryKey(false);
        pMatRefId.setName(fieldKey + "_id");
        pMatRefId.setDbIgnore(true);
        bdMatProp.setRefIdProp((IDataEntityProperty)pMatRefId);
        bdMatProp.setRefIdPropName(fieldKey + "_id");
        newMainType.addProperty((DynamicProperty)pMatRefId);
        return bdMatProp;
    }

    private void registerProperties(DynamicObjectType type, Ftype ftype) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        pkProp.setAlias("F" + pkName);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        BasedataProp baseProp = new BasedataProp();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ftype.getFentityid());
        baseProp.setBaseEntityId(dt.getName());
        baseProp.setAlias("FBasedataId");
        baseProp.setName("fbasedataid");
        baseProp.setDisplayProp("name");
        baseProp.setDisplayName(new LocaleString(ftype.getFname()));
        baseProp.setEditSearchProp("name");
        baseProp.setDbIgnore(true);
        baseProp.setComplexType((IDataEntityType)dt);
        String key_ref = "fbasedataid_id";
        DynamicSimpleProperty refIdProp = baseProp.createRefIDProp();
        refIdProp.setName(key_ref);
        refIdProp.setAlias("FBasedataId");
        refIdProp.setDbIgnore(false);
        baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
        baseProp.setRefIdPropName(key_ref);
        type.registerComplexProperty((DynamicComplexProperty)baseProp);
        type.registerSimpleProperty(refIdProp);
    }
}

