/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form.sf.std;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.ai.ids.core.entity.model.sf.std.ListCol;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.query.sf.std.DimValuesDTO;
import kd.ai.ids.core.query.sf.std.StandardFilterItemQuery;
import kd.ai.ids.core.service.ISfStandardService;
import kd.ai.ids.core.service.Services;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PredictDetailEntryGrid
extends EntryGrid {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_CACHE_CURRENT_FILTER_ITEM_QUERY = "currentFilterItemQuery";
    private static final String KEY_MULBD_FILTER_ID_LIST = "mulbdFilterIdList";
    private static final String KEY_FILTER_ITEM_QUERY = "filterItemQuery";

    public ISfStandardService sfStandardService() {
        return (ISfStandardService)Services.get(ISfStandardService.class);
    }

    public void hyperLinkClick(String fieldName, int rowIndex) {
        super.hyperLinkClick(fieldName, rowIndex);
        StandardFilterItemQuery standardFilterItemQuery = new StandardFilterItemQuery();
        String currFilterItemQueryStr = this.getView().getPageCache().get(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY);
        if (StringUtils.isNotEmpty((CharSequence)currFilterItemQueryStr)) {
            standardFilterItemQuery = (StandardFilterItemQuery)JSONObject.parseObject((String)currFilterItemQueryStr, StandardFilterItemQuery.class);
        }
        String mulbdFilterIdListStr = this.getView().getPageCache().get(KEY_MULBD_FILTER_ID_LIST);
        List mulbdFilterIdList = null;
        if (StringUtils.isNotEmpty((CharSequence)mulbdFilterIdListStr)) {
            mulbdFilterIdList = JSONArray.parseArray((String)mulbdFilterIdListStr, String.class);
        }
        String recordsStr = this.getView().getPageCache().get("records");
        JSONArray records = null;
        if (StringUtils.isNotEmpty((CharSequence)recordsStr)) {
            records = JSONArray.parseArray((String)recordsStr);
            Long index = (long)rowIndex % standardFilterItemQuery.getSize();
            JSONObject rowJo = records.getJSONObject(index.intValue());
            ArrayList<DimValuesDTO> fdimvaluesList = new ArrayList<DimValuesDTO>();
            if (mulbdFilterIdList != null && CollectionUtils.isNotEmpty((Collection)mulbdFilterIdList)) {
                for (String ftypeid : mulbdFilterIdList) {
                    Object value = rowJo.get((Object)ftypeid);
                    if (!ObjectUtils.isNotEmpty((Object)value)) continue;
                    DimValuesDTO dimValuesDTO = new DimValuesDTO();
                    dimValuesDTO.setLabelId(ftypeid);
                    dimValuesDTO.setValues(Collections.singletonList(value));
                    fdimvaluesList.add(dimValuesDTO);
                }
            }
            standardFilterItemQuery.setFdimvaluesList(fdimvaluesList);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(IdsFormIdEnum.IDS_SF_STD_MODEL_ANALYSIS.getId());
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put(KEY_FILTER_ITEM_QUERY, JSON.toJSONString((Object)standardFilterItemQuery));
        customParams.put("fschemeid", standardFilterItemQuery.getFschemeid());
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    protected boolean onFetchPageData(int pageIndex, int pageRows) {
        DynamicObject dataEntity;
        DynamicObjectCollection doc;
        String reset = this.getView().getPageCache().get("resetCurrentPageIndex");
        if (StringUtils.equals((CharSequence)Boolean.TRUE.toString(), (CharSequence)reset)) {
            pageIndex = 1;
            this.getView().getPageCache().remove("resetCurrentPageIndex");
        }
        if ((doc = (dataEntity = this.getModel().getDataEntity(true)).getDynamicObjectCollection(KEY_ENTRYENTITY)) != null && doc.size() > 0) {
            StandardFilterItemQuery standardFilterItemQuery = new StandardFilterItemQuery();
            String currFilterItemQueryStr = this.getView().getPageCache().get(KEY_CACHE_CURRENT_FILTER_ITEM_QUERY);
            if (StringUtils.isNotEmpty((CharSequence)currFilterItemQueryStr)) {
                standardFilterItemQuery = (StandardFilterItemQuery)JSONObject.parseObject((String)currFilterItemQueryStr, StandardFilterItemQuery.class);
            }
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity(this.getKey());
            entryEntities.clear();
            int startRowIndex = (pageIndex - 1) * pageRows;
            dataEntity.getDataEntityState().setEntryStartRowIndex(this.getKey(), startRowIndex);
            dataEntity.getDataEntityState().setEntryPageSize(this.getKey(), pageRows);
            standardFilterItemQuery.setCurrent(Long.valueOf(Long.parseLong(String.valueOf(pageIndex))));
            standardFilterItemQuery.setSize(Long.valueOf(Long.parseLong(String.valueOf(pageRows))));
            standardFilterItemQuery.setNeedRecord(Boolean.TRUE);
            JSONObject dataJo = this.sfStandardService().getLastDetailList(standardFilterItemQuery);
            JSONObject resultJo = dataJo.getJSONObject("result");
            JSONArray fields = dataJo.getJSONArray("fields");
            JSONArray records = resultJo.getJSONArray("records");
            if (fields != null && fields.size() > 0) {
                List listColList = fields.toJavaList(ListCol.class);
                if (records != null && records.size() > 0) {
                    for (int i = 0; i < records.size(); ++i) {
                        DynamicObject entryEntity = entryEntities.addNew();
                        JSONObject jo = records.getJSONObject(i);
                        for (ListCol listCol : listColList) {
                            String key = listCol.getId().replace("_lc", "");
                            Object value = jo.getOrDefault((Object)key, null);
                            this.getModel().setValue(listCol.getId(), value, startRowIndex + i);
                        }
                    }
                    this.getView().getPageCache().put("records", JSONObject.toJSONString((Object)records));
                } else {
                    this.getView().getPageCache().put("records", null);
                }
            }
            this.loadSummary(fields, standardFilterItemQuery);
        }
        return true;
    }

    private void loadSummary(JSONArray fields, StandardFilterItemQuery standardFilterItemQuery) {
        JSONObject summaryJo = this.sfStandardService().getLastDetailSummary(standardFilterItemQuery);
        if (fields != null && fields.size() > 0) {
            List listColList = fields.toJavaList(ListCol.class);
            for (ListCol listCol : listColList) {
                if (!listCol.getAllowSum().booleanValue()) continue;
                String colId = listCol.getId();
                BigDecimal value = summaryJo.getBigDecimal(this.getColIdWithoutLc(colId));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(colId, value != null ? value.toString() : "");
                this.setFloatButtomData(map);
            }
        }
    }

    private String getColIdWithoutLc(String colId) {
        return colId.replace("_lc", "");
    }

    public void setPageRows(int rows) {
        AbstractGrid.GridState entryState = this.getEntryState();
        this.getView().getPageCache().put("resetCurrentPageIndex", Boolean.TRUE.toString());
        if (this.onFetchPageData(entryState.getCurrentPageIndex(), rows)) {
            super.setPageRows(rows);
        }
    }
}

